/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCHSMsgRxF.c
 *
 *
 *------------------------------------------------------------------------
 */
// *****************************************************************************
// RCHSMsgRxF.c
//
// History
// 26/07/2010 ChihWen/Palaksha/Bhadra: In Huawei lab against a CNXT CO (H33EADB, B02D111/D57.1.10),
//       Xtalk-like noise will make CPE falsely detect C-Tone, and fail later in handshaking.
//       Here we increase tone detect scale from 3 to 8 in handshaking.And force to DMT mode
//       or T1413 mode when measured power in RCGlaf1 is lower than 21dB when against
//       CNXT CO (version number = 0x07 or 0x0b).
//       This fix is controlled by Bit#8 (0x0100) of CMV OPTN 25 0 (0 = feature disabled 1 = feature enabled)
//       Grep for SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop
// *****************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "RCGalf2RxF.h"
#include "RCFlag2RxF.h"
#include "trail.h"
#include "gdata_bis.h"

//SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop (begin)
#include "T1413.h"
#define POWER_THRESHOLD_5KM   0x1500
//SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop (end)
extern void RxSymbolReAlign(void);

DATA_MAP_deILV2_BIS
int16 gs_RxHSMsgExchTrailEnable = 1;
DATA_MAP_END//DATA_MAP_deILV2_BIS


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCHSMsgRxF
 *
 *  Description: R_C_HS_MSG_RX exchanges handshake messages and moves to
 *  selected mode upon completing message exchange and mode selection.
 *
 *  Prototype: void RCHSMsgRxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]          - input of IFFT, used in RxBit()
 *      gs_RxToneBuf[]           - frequency domain samples, used in RxBit()
 *      gpt_RxInfo               - (I) RX message information structure, used in
 *                                 HSMsgHandler()
 *      guc_RxOctet              - (I/O) current octet being transmitted
 *      gs_RxState               - (I) current RX state
 *      gs_RxSubState            - (I/O) current RX substate
 *      gl_RxSymbolCount         - (I) # symbol periods in current RX state
 *      gpuca_RxMsgBuf           - (I) message octets to be transmitted in this state
 *      gs_RxNextState           - (O) RX state that will begin next symbol period
 *      gt_hsc                   - (I) handshake control structure
 *
 *  Substates:
 *      R_C_HS_MSG_RX_IDLE_FLAG  - Get FLAGs until the beginning of a message.
 *      R_C_HS_MSG_RX_COLLECT_MESSAGE    - Gather octets for a whole message and start decode bkgd task.
 *      R_C_HS_MSG_RX_DECODE_MESSAGE     - Continue decode message background task until it finishes
 *      R_C_HS_MSG_RX_START_PROCESSING   - Start HS msg processing, begin HSMsgHandler background task
 *      R_C_HS_MSG_RX_HANDLE_PROCESSING  - Process received message and run the message exchange state machine.
 *
 *  Notes: implements state R_C_HS_MSG_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_HS_MSG_RX_IDLE_FLAG             (0)
#define R_C_HS_MSG_RX_COLLECT_MESSAGE       (1)
#define R_C_HS_MSG_RX_DECODE_MESSAGE        (2)
#define R_C_HS_MSG_RX_START_PROCESSING      (3)
#define R_C_HS_MSG_RX_HANDLE_PROCESSING     (4)

void RCHSMsgRxF(void) {


   /* ---- initialize ---- */
    if (gl_RxSymbolCount == 0)
    {
        gs_RxSymCnt      = 0;
        gs_RxSubStateCnt = 0;   /*  this is for RxSymbolReAlign() */
        gs_RxSubState    = R_C_HS_MSG_RX_IDLE_FLAG;

         if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_ST_GHS))
         { /* g.hs sample sessions */
            if(gs_HandShake_Cnt == 0)
            {
            InitializeHSC( &gt_hsc );
            InitializeInfoField( gpt_TxInfo );
            }
            else
            {
               gt_hsc.s_State = R_HS_INITIAL;
               gt_hsc.l_SelectedMode = NOT_SELECTED;
               if(gt_hsc.s_CL_Exchanged == TRUE)
               {
                  CopyInfoField(gpt_TxInfoSave, gpt_TxInfo, TRUE);
               }
            }
         }
         else /* default */
         {
         InitializeHSC( &gt_hsc );
         //SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop (begin)
#ifndef ISDN   // Only for Annex-A
         if ( (OPTNArray[OPTN_AlgControl3] & CMV_TO_BoostGhsToneDetScale) && ((gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
           ((gs_CurrentCoVendorID == 0x07) || (gs_CurrentCoVendorID == 0x0b)) ) && (gs_hsk_tone_power_dB < POWER_THRESHOLD_5KM) )
         {
            if (gul_ModeControl & (STAT_ConfigMode_G992_1_ALL|STAT_ConfigMode_G992_2_ALL))
            {
               gft_USPerf_CNXT = FALSE;
               gul_ModeControl &= (STAT_ConfigMode_G992_1_ALL|STAT_ConfigMode_G992_2_ALL) ;
               guc_T1413_relink_count = MAX_ALLOWED_GHS_TRIES;
            }
         }
#endif // ifndef ISDN
         //SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop (end)
         InitializeInfoField( gpt_TxInfo );
      }

      /* increment hand shake counter outside of function InitializeHSC() */
      gs_HandShake_Cnt ++;
    }

    /*  *************************************************************************** */
    /*  **** Realign symbol boundary right after Tx completes message xmission **** */
    /*  *************************************************************************** */
    /* ---- note that gft_SymbolReAlignmentRequired is set to TRUE at the end of  ---- */
    /* ---- a message transmission.  So, RxSymbolReAlign uses at least the three  ---- */
    /* ---- mandatory FLAGs at the beginning of an incoming message.              ---- */
    if (gft_SymbolReAlignRequired == TRUE)
    {
         if (gs_RxHSMsgExchTrailEnable == 1)
         {
         gs_RxHSMsgExchTrailEnable = 0;
#ifdef LEAVE_TRAIL
         GhsLeaveTrail(gt_hsc.s_State, gt_hsc.s_State, gs_RxSymCnt, "TX", gpt_TxInfo->uc_Type, NULL);
#endif /*  LEAVE_TRAIL */

         DebugTrail(4, DEBUG_LOG_STATESTRAIL, 0xCCCC, (int16)(((gt_hsc.s_State&0xFF)<<8) | (gt_hsc.s_State&0xFF)), (int16)(gs_RxSymCnt-2), (int16)((gpt_TxInfo->uc_Type<<8) | (gpt_RxInfo->uc_Type)));
      }
        RxSymbolReAlign();
        //---- if timeout, move to the beginning ----
        if ( gs_RxSymCnt >= HS_MSG_TIMEOUT ) {
            gt_hsc.s_TxMsgComplete = FALSE; // reset flag

         if (gft_GotoFailStateOnTimeOut_FromHandshake == FALSE)
         {
            gs_RxNextState         = R_C_SILENT1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;

            /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
            gs_TxNextState = R_SILENT0_TX;
            gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
         }
         else
         {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_GHS_TONE_LOSS_OR_TIME_OUT;
         }

        }
    }

    /*  ************************************************************************** */
    /*  **** When symbol alignment is done or not required                    **** */
    /*  **** start collecting an incoming message                             **** */
    /*  ************************************************************************** */

   else
   {
      gs_RxHSMsgExchTrailEnable = 1;

        /* ---- Bit Detection : common for all substates ---- */
        RxBit( (int16) (gs_RxSymCnt & MODULO_BY_8_MASK) );

        /* ==== if one full octet received, process in different substates ==== */

        if ( (gs_RxSymCnt & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) )
        {

#ifdef DEBUG_GHS
            printf( "Rx\t%x\n", guc_RxOctet );
#endif /*  DEBUG_GHS */
            switch (gs_RxSubState)
            {

               /* =============================================== */
               /* get FLAGs until the beginning of a message */
               /* =============================================== */
               case R_C_HS_MSG_RX_IDLE_FLAG:

                 /* ---- if first non-FLAG octet received ---- */
                if ( guc_RxOctet != FLAG )
                {
                    /* ---- fill gua_RxMsgBuf and move to next substate ---- */
                    gs_RxOctetCnt      = 1;
                    gpuca_RxMsgBuf[ 0 ] = guc_RxOctet;
                    gs_RxSubState      = R_C_HS_MSG_RX_COLLECT_MESSAGE;

               DebugTrail(3,DEBUG_LOG_GHSMESSAGES, (int16) 0xEEEC, (int16) gl_RxSymbolCount, (int16)guc_RxOctet);
                }

                if (gt_hsc.s_TxMsgComplete == TRUE)
                {
                  gt_hsc.s_TxMsgComplete = FALSE;  //reset tx msg complete flag

                    switch (gt_hsc.s_State)
                    {

                    /* ---- for states that are not receiving any message other than FLAG ---- */
                    case R_HS_INITIAL         :
                    case R_HS_MS_OK           :
                    case R_HS_CL_OK           :
                    case R_HS_RESTART         :
                    case R_HS_NOT_READY       :
                    case R_HS_NOT_SUPPORTED   :
                    case R_HS_NOT_UNDERSTOOD  :

                        gs_RxSubState = R_C_HS_MSG_RX_START_PROCESSING;
                        break;

                    default:
                        /* ---- if timeout, move to the beginning ---- */
                     if ( gs_RxSymCnt >= HS_MSG_TIMEOUT )
                     {
                            gt_hsc.s_TxMsgComplete = FALSE; /*  reset flag */

                     if (gft_GotoFailStateOnTimeOut_FromHandshake == FALSE)
                     {

                        gs_RxNextState         = R_C_SILENT1_RX;
                        gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;

                        /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
                        gs_TxNextState = R_SILENT0_TX;
                        gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
                     }
                     else
                     {
                        gs_RxNextState = FAIL_RX;
                        gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

                        /* set exception handler variables */
                        gus_ExceptionState   = gs_RxState;
                        gus_ExceptionCode = E_CODE_GHS_TONE_LOSS_OR_TIME_OUT;
                     }

                        }
                        break;

                    }  /*  switch */

                }   /*  if (TxMsgComplete) */

                break;

            /* =============================================== */
            /* gather octets for a whole message and decode it at the end */
            /* =============================================== */
            case R_C_HS_MSG_RX_COLLECT_MESSAGE:

                /* ---- gather octets until it reaches another FLAG ---- */
                gpuca_RxMsgBuf[ gs_RxOctetCnt++ ] = guc_RxOctet;
            DebugTrail(1,DEBUG_LOG_GHSMESSAGES, (int16)guc_RxOctet);

                /* ---- if end of message or buffer filled up ---- */
                if ( (guc_RxOctet == FLAG) || (gs_RxOctetCnt == MESSAGE_BUF_LEN) ) {
                    AddFunctionToBkgdFifo((PtrToBkgdFunc)DecodeMessage);
               guc_DecodeMsgState = HS_DECODE_MSG_START;
               gs_RxSubState = R_C_HS_MSG_RX_DECODE_MESSAGE;
            }
            break;

         case R_C_HS_MSG_RX_DECODE_MESSAGE:
            if (guc_DecodeMsgState == HS_DECODE_MSG_DONE) {
               // reset state variable
               guc_DecodeMsgState = HS_DECODE_MSG_INITIAL;

                    /* ---- if invalid message, ignore it ---- */
                    if (gt_hsc.s_DecodeResult == INVALID_MESSAGE) {
                        gs_RxSubState = R_C_HS_MSG_RX_IDLE_FLAG;
                    }
                    /* ---- if not INVALID_MESSAGE ---- */
                    else {
                        gs_RxSubState = R_C_HS_MSG_RX_START_PROCESSING;
                    }
                }  /* if (guc_DecodeMsgState == HS_DECODE_MSG_DONE)*/

                break;

            /* =============================================== */
            /* process received message and run message exchange state machine */
            /* =============================================== */
            case R_C_HS_MSG_RX_START_PROCESSING:

                AddFunctionToBkgdFifo((PtrToBkgdFunc)HSMsgHandler);
            guc_MsgHandlerState = HS_MSG_HANDLER_START;
            gs_RxSubState = R_C_HS_MSG_RX_HANDLE_PROCESSING;
            break;

         case R_C_HS_MSG_RX_HANDLE_PROCESSING:
            if (guc_MsgHandlerState == HS_MSG_HANDLER_DONE)
            {
               // reset state variable
               guc_MsgHandlerState = HS_MSG_HANDLER_INITIAL;

               gt_hsc.s_RxMsgComplete = TRUE;   /*  Let Tx know a message is complete in Rx  */
               gt_hsc.s_TxMsgComplete = FALSE;  /*  reset flag */

#ifdef LEAVE_TRAIL
               if ((gt_hsc.s_State == R_HS_INITIAL) || (gt_hsc.s_NextState == R_HS_INITIAL))
                  GhsLeaveTrail(gt_hsc.s_State, gt_hsc.s_NextState, gs_RxSymCnt, "TX", 0x3F, NULL);
               else
                  GhsLeaveTrail(gt_hsc.s_State, gt_hsc.s_NextState, gs_RxSymCnt, "RX", gpt_RxInfo->uc_Type, NULL);
#endif /*  LEAVE_TRAIL */

               if (gs_RxHSMsgExchTrailEnable == 1)
               {
                  DebugTrail(4, DEBUG_LOG_STATESTRAIL, 0xDDDD, (int16)(((gt_hsc.s_NextState&0xFF)<<8) | (gt_hsc.s_State&0xFF)), gs_RxSymCnt, (int16)((gpt_TxInfo->uc_Type<<8) | (gpt_RxInfo->uc_Type)));
               }
               if (gt_hsc.s_NextState == R_HS_EXIT)
               {
#if 1
                  if(gt_hsc.l_SelectedMode == RESTART_HS)   //M_NAK_EF
                  {

                     gs_HandShake_Cnt = 0;
                     gs_RxNextState         = R_C_SILENT1_RX;
                     gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;

                     /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
                     gs_TxNextState = R_SILENT0_TX;
                     gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
                  }
#else
                     if (gt_hsc.l_SelectedMode == RESTART_HS)
                     {
                     //Exception codes have been set earlier, where l_SelectedMode was set
                     gs_RxNextState = FAIL_RX;
                     gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                     gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
                        if( gt_hsc.s_State == R_HS_RESTART)
                           gus_ExceptionCode = E_CODE_GHS_NearEnd_EF ;
                        else
                           gus_ExceptionCode = E_CODE_GHS_FarEnd_EF ;
                     }
#endif

#if 0             //VDSL 2 implementation
                  else if (gt_hsc.l_SelectedMode == NO_COMMON_MODE)
                  {
                     gs_RxNextState = FAIL_RX;
                     gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                     gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
                        gus_ExceptionCode = E_CODE_GHS_NoCommonMode ;
                  }
#endif

                  else if ( gt_hsc.s_State == R_HS_NOT_UNDERSTOOD )
                  {
                     gs_RxNextState = FAIL_RX;
                     gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                     gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
                     gus_ExceptionCode = E_CODE_GHS_RX_MSGBUF_OVERFLOW;
                  }
                  else if ( gt_hsc.s_State ==  R_HS_MS_OK)
                  {
                     gs_RxNextState = R_C_GALF2_RX;
                     gpF_RxStateFunc = (PtrToFunc)RCGalf2RxF;
                     if ((gt_hsc.l_SelectedMode == NO_COMMON_MODE)
                        ||(gt_hsc.l_SelectedMode == SILENCE ))
                     {
                        gft_enterTraining = FALSE;
                     }
                     // we have valid mode, set FLAG to indicate codeswap starts
                     else
                     {
                        gft_enterTraining = TRUE;
                     }
                  }
                  else if ( gt_hsc.s_State == R_HS_SEND_MS )
                  {
                     gs_RxNextState = R_C_FLAG2_RX;
                     gpF_RxStateFunc = (PtrToFunc)RCFlag2RxF;
                     // we have valid mode, set FLAG to indicate codeswap starts
                     gft_enterTraining = TRUE;
                  }
                  else if(gt_hsc.l_SelectedMode == RESTART_VIA_CLEARDOWN)
                  { /*  if NAK-CD received */
                        gs_RxNextState = R_C_FLAG2_RX;
                        gpF_RxStateFunc = (PtrToFunc)RCFlag2RxF;
                  }
                  else
                  {
                     // should have covered all cases above; fail here without exception code.
                     gs_RxNextState = FAIL_RX;
                     gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                     gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
                  }
               }
               else     //if gt_hsc.s_NextState != R_HS_EXIT
               {
                  gt_hsc.s_State   = gt_hsc.s_NextState;
                  gs_RxSubState    = R_C_HS_MSG_RX_IDLE_FLAG;
                  gs_RxSubStateCnt = 0;   /*  this is for RxSymbolReAlign */
                  gs_RxSymCnt      = -1;  /*  initialize symbol counter for a new message */
               }
            } /* if (guc_MsgHandlerState == HS_MSG_HANDLER_DONE)*/
                break;

            }   /*  switch */

        }   /*  if octet complete */

    }   /*  else (symbol alignment is not require) */

    gs_RxSymCnt++;  /*  increment symbol counter */

}   /*  RCHSMsgRxF */

#undef R_C_HS_MSG_RX_IDLE_FLAG
#undef R_C_HS_MSG_RX_COLLECT_MESSAGE
#undef R_C_HS_MSG_RX_DECODE_MESSAGE
#undef R_C_HS_MSG_RX_START_PROCESSING
#undef R_C_HS_MSG_RX_HANDLE_PROCESSING


