/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCQuietEF1RxF.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */

#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "hndshk2.h"
#include "detect.h"
#include "hndshk_Data.h"
#include "states.h"
#include "RCSilent1RxF.h"
#include "RCRecovRxF.h"

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RCQuietEF1RxF
 *
 *  Description: Transition state when escape to Fast Retrain is selected as mode
 *  of operation.
 *
 *  Prototype: void RCQuietEF1RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *
 *  Notes: impements state R_C_QUIET_EF1_RX
 *
 *-------------------------------------------------------------------
 *^^^
 */
void RCQuietEF1RxF(void) {

   /* ---- initialize ---- */
   if ( gl_RxSymbolCount == 0 )
      gs_RxSubStateCnt = 0;

   /* ---- check for timeout ---- */
   if ( gl_RxSymbolCount >= R_C_QUIET_EF1_RX_MAX_LEN ) {
      gs_RxNextState = R_C_SILENT1_RX;
      gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;
   }

   if ( DetectTone(gsa_RxToneBuf, C_RECOV_TONE, C_RECOV_TONE_MIN, C_RECOV_TONE_MAX, DETECT_SCALE << 8) )
      gs_RxSubStateCnt++; /*  substate counter here is used just as a generic counter */
   else
      gs_RxSubStateCnt = 0;

#ifdef INCLUDE_FASTRETRAIN_CODE
   /* ---- C_Recov detected ---- */
   if ( gs_RxSubStateCnt >= R_C_RECOV_MIN_COUNT ) {
      gs_RxNextState = R_C_RECOV_RX;
      gpF_RxStateFunc = (PtrToFunc)RCRecovRxF;
   }
#endif

}   /*  RCQuietEF1RxF */

