/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCSilent1RxF.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
// ************************************************************************
// RCSilent1RxF.c
//
// History
//
// 04/02/2014 Balabath:XDSLRTFW-1489 -Low performance in Periodic noises immunity tests at Orange.
// We are using extra INP for LOW REIN cases, where REIN noise not effect the sysmbols. And also
// multiple bugs are corrected in Estimateimpulse, Estimateimpulse2 functions. and also consider
// the full value of "guc_impulse_noise_present " while considering the extra INP protection.
// guc_impulse_noise_present gives information about coarse impluse present are not, is it valid
// pps and Impulse power. for code changes grep for " XDSLRTFW-1489 "
//
// ************************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "afe.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "TxTneSt.h"
#include "hndshk_Data.h"
#include "RCTonesRxF.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


void EstimateImpulse(void);
void EstimateImpulse2(void);
extern int32 VectorPower(int16 *s_databuf, int16 s_offset, int16 s_ndata, int16 s_GuardBits);
// detect impulse noise
#define IMPULSE_WINDOW_LEN 18




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCSilent1RxF
 *
 *  Description: R_C_SILENT1_RX is a beginning state of a handshake session.
 *  It pauses for 500ms and move to next state.
 *
 *  Prototype: void RCSilent1RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]   - input of IFFT, used in DetectTones()
 *      gs_RxToneBuf[]    - frequency domain samples, used in DetectTones()
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *      gt_hsc            - (I/O) handshake control structure
 *
 *  Notes: implements state R_C_SILENT1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define    R_C_SILENT1_RX_SUBSTATE0     (0)
#define    R_C_SILENT1_RX_SUBSTATE1     (1)
#define    R_C_SILENT1_RX_SUBSTATE2     (2)

void RCSilent1RxF(void) {
   int16 s_PGA_Max;
   //XDSLRTFW-2033 (Start_End)
   gul_ToneDetectSymbCount++;

   switch (gs_RxSubState) {
   case R_C_SILENT1_RX_SUBSTATE0:

      if(gl_RxSymbolCount == 0)
      {

         if ((TESTArray[TEST_Control] & TEST_RUN_ANYLIF_VR9) == 0)
         {
            //XDSLRTFW-2137 (Start)
            if ((OPTNArray[OPTN_ModeControl] & (OPTN_ConfigMode_G992_1_B | OPTN_ConfigMode_G992_3_B | OPTN_ConfigMode_G992_5_B | OPTN_ConfigMode_G992_3_J ))
                  || (OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_G992_5_J)
               )
            //XDSLRTFW-2137 (End)
            {
               // Anx B LIF
               if    (gus_HybridType != VRX_HYB_TYPE_ABJ)
               {

                  gs_RxNextState = FAIL_RX;
                  gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                  /* Set exception handler variables */
                  gus_ExceptionState   = gs_RxState;
                  gus_ExceptionCode = E_CODE_INCORRECT_LIF_MODULE;
               }

            }
            //XDSLRTFW-2137 (Start)
            else if ((OPTNArray[OPTN_ModeControl] & (OPTN_ConfigMode_T1413 | OPTN_ConfigMode_G992_1_A | OPTN_ConfigMode_G992_3_A | OPTN_ConfigMode_G992_3_L | OPTN_ConfigMode_G992_5_A | OPTN_ConfigMode_G992_3_I | OPTN_ConfigMode_G992_3_M | OPTN_ConfigMode_G992_2_AB))
                     || (OPTNArray[OPTN_ModeControl1] & (OPTN_ConfigMode_G992_5_I|OPTN_ConfigMode_G992_5_M))
                  )
            //XDSLRTFW-2137 (End)
            {
               // Anx A LIF
               if    (gus_HybridType != VRX_HYB_TYPE_ABJ)
               {

                  gs_RxNextState = FAIL_RX;
                  gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                  /* Set exception handler variables */
                  gus_ExceptionState   = gs_RxState;
                  gus_ExceptionCode = E_CODE_INCORRECT_LIF_MODULE;
               }
            }
         }

         //SetInitialPgaToMax() ;
         s_PGA_Max = AFED_SetInitialPgaToMax();

         gs_pre_tdq_h_exp=14;

            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);

         }
         else
         {

            guc_PgaTrainingState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);
            gs_RxSubState = R_C_SILENT1_RX_SUBSTATE1;
         }

         break;
      case R_C_SILENT1_RX_SUBSTATE1:
         if (guc_PgaTrainingState == TRAINING_DONE)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
            gs_RxSubState = R_C_SILENT1_RX_SUBSTATE2;
                gs_RxSubStateCnt = 0;
            }
            break;
      case R_C_SILENT1_RX_SUBSTATE2:
#ifdef TARGET_HW // SocratesHW
               //DO impulse detection
            if (gl_RxSymbolCount < 4*TIME_500MS && gft_ShortRSilent0 == FALSE)
            {
                EstimateImpulse();
            }
         /* In handshake only mode, silence period is 2 seconds. In HS/T1 multimode, */
         /* silence period is 100ms. */

         else if ((gl_RxSymbolCount >= 4*TIME_500MS) || ((gl_RxSymbolCount >= TIME_100MS) && (gft_ShortRSilent0 != FALSE)))
#else //Cocomo tests
         if ( gl_RxSymbolCount >= (TIME_100MS) )
#endif
            {
#ifdef TARGET_HW
                EstimateImpulse2();
#endif
            gft_ShortRSilent0 = FALSE;
            gs_RxNextState = R_C_TONES_RX;
            gpF_RxStateFunc = (PtrToFunc)RCTonesRxF;
         }
         break;
   }
}   /*  RCSilent1RxF */

/*******************************************************************************
*
*  Prototype: void EstimateImpulse(void)
*
*  This function detects if impulse noise is present (Estimation)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*******************************************************************************/
void EstimateImpulse(void)
{
  int16 i,idx; //XDSLRTFW-1489 (start_end)
  uint8 uc_extra_shift = 0;
   if(gs_RxSubStateCnt == 0)
      guc_impulse_noise_present = 0;
    //gs_sliding_idx gives the index of current symbol in the sliding window
    gs_sliding_idx =  gs_RxSubStateCnt % IMPULSE_WINDOW_LEN ;

    // Coarse detection: Calculate the highest and lowest energy for IMPULSE_WINDOW_LEN frames

    if (gs_RxSubStateCnt < IMPULSE_WINDOW_LEN)
    {
        gla_sym_pwr[gs_sliding_idx] = VectorPower(gsa_RxToneBuf, gs_RxFirstChannel,
        gs_RxLastChannel - gs_RxFirstChannel+1,  guc_pwr_accu_shift_bits);
        if( (gla_sym_pwr[gs_sliding_idx] >> 25) !=0 )
        {
            uc_extra_shift = 1;
            //XDSLRTFW-1489 (start)
            for(i = gs_sliding_idx; i >(gs_sliding_idx-IMPULSE_WINDOW_LEN); i--)
            {
              idx =  i % IMPULSE_WINDOW_LEN ;
              gla_sym_pwr[idx] = gla_sym_pwr[idx]>>uc_extra_shift;
            }
            guc_pwr_accu_shift_bits += uc_extra_shift ;
        }
        // During first 18 frames, gl_accu_pwr_old and gl_accu_pwr_new hold the same value
        gl_accu_pwr_old = ((gl_accu_pwr_old )>> uc_extra_shift)+ gla_sym_pwr[gs_sliding_idx];
        gl_accu_pwr_new = ((gl_accu_pwr_new )>> uc_extra_shift)+ gla_sym_pwr[gs_sliding_idx];
        uc_extra_shift =0;
      //XDSLRTFW-1489 (end)
    }

    else if (gs_RxSubStateCnt >= IMPULSE_WINDOW_LEN && gs_RxSubStateCnt < 120*IMPULSE_WINDOW_LEN) //in 2000 frames
    {
        // During accumulation phase, gl_accu_pwr_old is reset each 18 frames, since
        // we use it to find the lowest and  highest value of consecutive 18 frames
        // in the first second. If  gs_sliding_idx!=17, it carries the sum of the power
        // of lasest 0-gs_sliding_idx frames.
        // gl_accu_pwr_new is, however, is a running variable, it always carries
        // the sum of the power of the lastest 18 frames
        if (gs_sliding_idx ==0)  //calculate the  power of consecutive 18 frames
        {
            // update the lower bound
            if (gl_window_pwr_lb > gl_accu_pwr_old )
                 gl_window_pwr_lb = gl_accu_pwr_old ;
             //update the upper bound, we may not able to see the real upper bound here
            if (gl_window_pwr_ub < gl_accu_pwr_old)
                gl_window_pwr_ub = gl_accu_pwr_old ;
            gl_accu_pwr_old =  0 ;
        }
        //gl_accu_pwr_new removes the oldest value
        gl_accu_pwr_new -= gla_sym_pwr[gs_sliding_idx];
        gla_sym_pwr[gs_sliding_idx] = VectorPower(gsa_RxToneBuf, gs_RxFirstChannel,
        gs_RxLastChannel - gs_RxFirstChannel+1,  guc_pwr_accu_shift_bits);
        if( (gla_sym_pwr[gs_sliding_idx] >> 25) !=0 )
        {
            uc_extra_shift = 1;
            //XDSLRTFW-1489 (start)
            for(i = gs_sliding_idx; i >(gs_sliding_idx-IMPULSE_WINDOW_LEN); i--)
            {
              idx =  i % IMPULSE_WINDOW_LEN ;
              gla_sym_pwr[idx] = gla_sym_pwr[idx]>>uc_extra_shift;
            }
            guc_pwr_accu_shift_bits += uc_extra_shift ;
        }
         //gl_accu_pwr_new removes the newest value
        gl_accu_pwr_new = ((gl_accu_pwr_new )>> uc_extra_shift)+ gla_sym_pwr[gs_sliding_idx];
        //gl_accu_pwr_old removes the newest value
        gl_accu_pwr_old = ((gl_accu_pwr_old )>> uc_extra_shift)+ gla_sym_pwr[gs_sliding_idx];
      //XDSLRTFW-1489 (end)

        gl_window_pwr_lb >>= uc_extra_shift;
        gl_window_pwr_ub >>= uc_extra_shift;
        uc_extra_shift = 0;

    }

    if  (gs_RxSubStateCnt >=  120*IMPULSE_WINDOW_LEN)
    {
        // set a coarse detection indicator based on gl_window_pwr_lb and gl_window_pwr_lb
        if (gs_RxSubStateCnt == 120*IMPULSE_WINDOW_LEN)
        {
            // The differnce between the upper bound and lower bound
            gus_impulse_coarse_detect = gl_window_pwr_ub/gl_window_pwr_lb;
            if (gl_window_pwr_ub >= (3*gl_window_pwr_lb))  //if the power difference is more than 4.7 dB
               guc_impulse_noise_present = IMPULSE_NOISE_COARSE_DETECT;  //Set the flag after coarse detection

            // During the characterization phase, gl_accu_pwr_old is running variable
            // and carries the sum of power of IMPULSE_WINDOW_LEN frames. It is a one
            // frame delay version of gl_accu_pwr_new.
            gl_accu_pwr_old = gl_accu_pwr_new;
            // set the detection threshold
            // if the flag for coarse detection is set, we use a fixed threshold
            // otherwise, we assume the threshold is not reliable and adapt it futher.
            if (guc_impulse_noise_present)
                l_imp_detect_threshold = gl_window_pwr_ub /IMPULSE_WINDOW_LEN; //upper bound of an impulse over IMPULSE_WINDOW_LEN
            else
                l_imp_detect_threshold = gl_window_pwr_lb /IMPULSE_WINDOW_LEN; // lower bound of noise power over a symbol period
        }


//     if (guc_impulse_noise_present)
//     {
        // (1) detect impulse flag and estimate maximum power
        // remove the oldest symbol energy calculate new symbol energy
        // This is positive since gl_accu_pwr_old = sum(gla_sym_pwr(0:17))
         gl_accu_pwr_new =  gl_accu_pwr_old - gla_sym_pwr[gs_sliding_idx];
         gla_sym_pwr[gs_sliding_idx] = VectorPower(gsa_RxToneBuf, gs_RxFirstChannel,
                            gs_RxLastChannel-gs_RxFirstChannel+1,  guc_pwr_accu_shift_bits);
        //calculate the new accumulated energy
         gl_accu_pwr_new += gla_sym_pwr[gs_sliding_idx] ;

         //keep updating the upper bound, we use it for the decison using power criterion
         if (gl_window_pwr_ub < gl_accu_pwr_new)
                gl_window_pwr_ub = gl_accu_pwr_new ;

         // if the impulse duration is short such that most of the time it falls into one pmd symbol,
         // gs_power_up_cnt is close to the number of impulses during detection period;
         // if the impulse duration is in [1/2 symbol, 1 symbol], an impulse can corrupt 2 symbols,
         // gs_power_up_cnt and gs_power_down_cnt will be close to twic the number of impulses
         // during detection period, and so on so forth

         // gs_power_up_cnt and gs_power_down_cnt do not carry any physical meaning,
         // It may assist us to determine the period of the impulse's period is large, (e.x 1Hz)
         // If the difference between the two number is big, it may indicates impulse
         // is aperiodic.
         if (gl_accu_pwr_new -  gl_accu_pwr_old > l_imp_detect_threshold )
         {
            // (1.1) we will check the number of symbol power change to know how many frames an impulse afffected
            gs_power_up_cnt ++;
            // (1.2) estimate the max impulse power increment over one symbol
            gl_imp_power +=  (gl_accu_pwr_new -  gl_accu_pwr_old) >> 8;

            gl_ave_imp_power = gl_imp_power / (gs_power_up_cnt + gs_power_down_cnt);
            // set the threshold 3db lower than the moving average impulse power
            if (!guc_impulse_noise_present) l_imp_detect_threshold= gl_ave_imp_power<<7;
            // (2) impulse duration (inp) and frequency
            //  gus_max_imp_symbol is the number of consecutive symbols corrupted by an impulse.
            s_noimp_cnt = 0;
            s_imp_cnt++;
            if ( s_imp_cnt > gus_max_imp_symbol)
                 gus_max_imp_symbol = s_imp_cnt;
            // calculation of the duration of impulse free symbol starts after detection of the first impulse
            if (gs_power_up_cnt==1 && gs_power_down_cnt==1)  gus_max_noimp_symbol =0;
         }
         else
         {
            if (gl_accu_pwr_old - gl_accu_pwr_new > l_imp_detect_threshold)   //0.75*256
            {
                // (1.1) we will check the number of symbol power change to know how many frames an impulse afffected
                gs_power_down_cnt ++;
                // (1.2) estimate the max impulse power increment over one symbol
                gl_imp_power +=  (gl_accu_pwr_old -  gl_accu_pwr_new)>>8;
                gl_ave_imp_power = gl_imp_power / (gs_power_up_cnt+ gs_power_down_cnt);
                if (!guc_impulse_noise_present) l_imp_detect_threshold= gl_ave_imp_power <<7;

            }
            //  gus_max_noimp_symbol is the number of consecutive symbols that are not affected by impulse
            //  This parameter is only useful in lab. If the impulse is not strictly periodical.
            //  gus_max_noimp_symbol can be too big to bring any useful information.
            //  The impulse rate can estimated by (gus_max_imp_symbol-1)/ (gus_max_noimp_symbol+gus_max_imp_symbol)
            //  if the impulse is periodical.
            s_imp_cnt =0;
            s_noimp_cnt ++;
            if ( s_noimp_cnt > gus_max_noimp_symbol)
                gus_max_noimp_symbol = s_noimp_cnt;
         }

         gl_accu_pwr_old = gl_accu_pwr_new;
 //       } // if (gus_impulse_coarse_detect >= 6)

    } //if  (gs_RxSubStateCnt >=  120*IMPULSE_WINDOW_LEN)

    gs_RxSubStateCnt ++;

} //void()

/*******************************************************************************
*
*  Prototype: void EstimateImpulse2(void)
*
*  This function calculates the impulse noise characterization parameters
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*******************************************************************************/
void EstimateImpulse2()
{


    // "gs_num_impulse" total number of impulses present in the ~1.5s window (0.5s used for coarse detection)
    if (gus_max_imp_symbol>1)
    {
       gs_num_impulse = (gs_power_up_cnt+ gs_power_down_cnt)/(gus_max_imp_symbol-1)/2;
    }
    else
    {
      if(gus_max_imp_symbol) // To avoid divide by zero.
         gs_num_impulse = (gs_power_up_cnt+ gs_power_down_cnt)/gus_max_imp_symbol/2;
      else
         gs_num_impulse = 0;
    }

    gs_imp_period= gus_max_noimp_symbol+gus_max_imp_symbol;

    // frequency criterion: does not work if impulse frequnce <=1pps or >= 160pps
    if (gs_imp_period > 25 && gs_imp_period< 4400 && gs_num_impulse * gs_imp_period > 4400)
      guc_impulse_noise_present |=  IMPULSE_NOISE_FREQ_VALID;

    //power criterion: it the impulse power is not 3db lower than the difference of
    // window of highest and lowest energy
    // Here 8 is used because gl_ave_imp_power was gl_ave_imp_power >> 8;
    if ( gl_ave_imp_power * gus_max_imp_symbol > ((gl_window_pwr_ub-gl_window_pwr_lb)>>(8+1)))
       guc_impulse_noise_present |=  IMPULSE_NOISE_POWER_LEVEL_VALID;
    //XDSLRTFW-1489 (start)
   //gl_avepower  => 10*log10(400*2^8) =>50.1030 dB (Here 2^8 consider for compensation factoe above)
    if((gl_ave_imp_power > 400)
      &&((guc_impulse_noise_present & REIN_IMPULSE_NOISE_VALID)== REIN_IMPULSE_NOISE_VALID)
      )
    {
       gft_HighREIN_NOISE = TRUE;
    }
   //XDSLRTFW-1489 (end)

}

