/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCTonesRxF.c
 *
 *------------------------------------------------------------------------
 */
//
// 20/08/2010 Sriram Shastry: Fix for disabling the detection of B43 and J43 carrier set with OPTN 25, bitmask 0x4000.
//    By default, this cmv bit is ONE(enable the detection). Besides the fix, in addition to the B43 detection in C-TONES,
//    which is based on power difference between B43 tones and its neighboring tones, we also use B43
//    carrier set to decode C-GLAF1 and C-FLAG1 to double confirm if B43 tones are really transmitted from CO site.
//    Only if B43 carrier set are detected in C-TONES, and C-GLAF1 and C-FLAG1 are correctly decoded, then we think
//    B43 are really transmitted from CO site. It also means CO may support AnnexM mode.
//    Grep for SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection
//
// 28/07/2011 Kannan: T1413 bring up and T1413 mode loop length estimation.
//           Grep for XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup
//
// 9/09/2011 Anantha Ramu: Added feature to try GHS MAX_ALLOWED_GHS_FAILS times before trying T1413
//                         if T1413 is one of the configured modes in CPE.
//                         Grep for  XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL
//
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on...).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on...).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                   0: disabled (default)
//                   1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                   0 -> GHS Activation startup (Default)
//                   1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
//18/07/2014 Balabth: AFE Read access failures are seen because of  AFE_DONE bit not getting cleared.
//           AFE_DONE bit is W1C (Write 1 to clear this bit). DSL FW write 1 to clear this bit for both AFE read and AFE write functions.
//           We are reading the register immediately after setting this bit some times not working.
//          added wait until AFE_DONE bit get cleared .
//          And There was a bug for reporting the sub-error codes if AFE failure occurs after LinkStart.Fixed the same
//          And also changed timing to 90sec in case non standard activations sequence.
//          Grep for: "XDSLRTFW-1831"
//
// 10/10/2017 Abu Rahman
//            XDSLRTFW-3511 : VRX518 ADSL(2/2+) C-Comb based Loop Length Estimation with considering PCB for ISDN
//            Include Ghs PCB information from CL identification field in Ghs CTone power measurement which
//            is used for Ghs based loop length estimation. This Modification is done only for ISDN mode.
//            Grep for XDSLRTFW-3511
//
//************************************************************************************************
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "ghs.h"
#include "states.h"
#include "fifo.h"
#include "cmv.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "detect.h"
#include "hndshk_Data.h"
#include "pga_set.h"
#include "act_T1413.h"
#include "RCGalf1RxF.h"
#include "SetPgaForToneDetection.h"
#include "accum32.h"
#include "memsetbf.h"
#include "bufmisc.h"
#include "pll.h"
#include "afe.h"
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
#include "pga_set.h"
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
extern int16 DetectGhsCarrierSet(void);
#define GHSCARRIERSET_ACCUM_PREPARE 0
#define GHSCARRIERSET_ACCUM         1
#define GHSCARRIERSET_AVERAGE    2
#define GHSCARRIERSET_DETECT     3


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCTonesRxF
 *
 *  Description: R_C_TONES_RX detects the C_Tones from an ATU-C.
 *  Upon detection of C_Tones, Rx enters R_C_GALF state.
 *
 *  Prototype: void RCTonesRxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]            - input of IFFT, used in DetectTones()
 *      gs_RxToneBuf[]             - frequency domain samples, used in DetectTones()
 *      gs_RxSubState              - (I/O) current RX substate
 *      gs_RxSubStateCnt           - (I/O) # symbols in current RX substate
 *      gl_RxSymbolCount           - (I) # symbol periods in current RX state
 *      gs_RxNextState             - (O) RX state that will begin next symbol period
 *      gt_hsc                     - (I/O) handshake control structure
 *
 *  Substates:
 *      R_C_TONES_RX_DETECT_TONES  - Attempt to detect tones.
 *      R_C_TONES_RX_COUNT_SYMBOLS - Count the number of symbols that tones are
 *                                   present, and transition to R_C_GALF1_RX if
 *                                   present for C_TONES_CNT consecutive symbols.
 *
 *  Notes: implements state R_C_TONES_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_TONES_RX_DETECT_TONES  (0)
#define R_C_TONES_RX_COUNT_SYMBOLS (1)

void RCTonesRxF(void) {

    int16 i, s_TonesDetected;
   int16 s_R_C_TONES_BURST_CNT, s_R_C_TONES_DETECTION_FAILURE_CNT;
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
   uint32 ul_ActTimeout;

   //XDSLRTFW-2033 (Start_End)
   gul_ToneDetectSymbCount++;

   if (gus_Cnfg_Misc & CNFG_MISC_NON_STANDARD_HSK_MASK)
  {
         ul_ActTimeout = 180*TIME_500MS;

      //XDSLRTFW-2033 (Start)
      gul_PGAResetSec--;
      if (gul_PGAResetSec == 0)
      {
         gul_PGAResetSec = TIME_8S;

         //Go back to initial silent state and rest PGA to max.
         gs_RxNextState = R_C_SILENT1_RX;
         gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;

         /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
         gs_TxNextState = R_SILENT0_TX;
         gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
      }
      //XDSLRTFW-2033 (End)
   }
   else
   {
      ul_ActTimeout = 4*TIME_500MS;
   }
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (End)

    if ( gl_RxSymbolCount == 0 )
   {
        gs_RxSubStateCnt = 0;
      gs_DetectGhsCarrierSet_State = GHSCARRIERSET_ACCUM_PREPARE;
   }

   //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup (START)
   // The given below code is moved here from substate "R_C_TONES_RX_DETECT_TONES"
   // to transition for T1413 mode, if Ghs tones were not detected within 2 secs.
   // In substate "R_C_TONES_RX_DETECT_TONES" T1413 switching takes place at symbol
   // count 8710 instead of 2secs(4312.5*2 = 8625 symbols), i.e 85 symbols more.
   // It casues to T1413 link failure at channel analysis.
   // Exception code: "E_CODE_RCReverb3Rx_C_SEGUE1_Failure"

   /* If tones are not detected for 2 seconds and PGA set is completed, switch */
   /* to T1.413 mode if enabled. */
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
   if ((gul_ToneDetectSymbCount >= ul_ActTimeout) && (gs_SetPgaForTones_State == SETPGATONES_LEVEL_OK))
   {
      gul_ToneDetectSymbCount = 0;
      gul_PGAResetSec = TIME_8S;
      //XDSLRTFW-2033 (End)

#ifndef ISDN
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL
//    if ((gul_ModeControl & OPTN_ConfigMode_T1413) != 0) //Original line
        if (((gul_ModeControl & OPTN_ConfigMode_T1413) != 0) &&
        ((gus_Cnfg_Misc & CNFG_MISC_NON_STANDARD_HSK_MASK)||(guc_Ghs_fails_count >= (MAX_ALLOWED_GHS_FAILS))))
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL
#else
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (End)
        if ((gul_ModeControl & (uint32)(OPTN_ConfigMode_ETSI_AnnexC<<16)) != 0)
#endif
      {
         gs_TxNextState = R_ACT_REQ_TX;
         gpF_TxStateFunc = (PtrToFunc)RActReqTxF;

         gs_RxNextState = R_C_ACT_RX;
         gpF_RxStateFunc = (PtrToFunc)RCActRxF;
         #ifndef ISDN
         //XDSLRTFW-623 BugFix_T1413_Ghs_Xtalk_Activation_Stuck (START_END)
         guc_Ghs_fails_count = 0;
         #endif

      }
      /* If T1.413 is not enabled and tones are not detected for 4 seconds, go */
      /* back to initial states to reset the PGA to max, in case it was set */
      /* really low (and is stuck there) because of some transient strong noise. */
      else if (gl_RxSymbolCount >= 8*TIME_500MS)
      {
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
#ifndef ISDN
            if((gul_ModeControl & OPTN_ConfigMode_T1413) != 0)
            {
                guc_Ghs_fails_count++;
            }
#endif
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
         gs_RxNextState = R_C_SILENT1_RX;
         gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;

         /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
         gs_TxNextState = R_SILENT0_TX;
         gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
      }
   }
   //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup  (END)

   s_R_C_TONES_BURST_CNT = (8*R_C_TONES_BURST_CNT) >> GHSCARRIERSET_LOG2_NUM_ACCUM_SYMBOLS;
   if (s_R_C_TONES_BURST_CNT <= 2)
      s_R_C_TONES_BURST_CNT = 2;    // At least two detections

   s_R_C_TONES_DETECTION_FAILURE_CNT = (8*R_C_TONES_DETECTION_FAILURE_CNT) >> GHSCARRIERSET_LOG2_NUM_ACCUM_SYMBOLS;
   if (s_R_C_TONES_DETECTION_FAILURE_CNT == 0)
      s_R_C_TONES_DETECTION_FAILURE_CNT = 1;

   SetPgaForToneDetection();

   {
      /* average recieved signal and perform multi-tone detection */
      /* returns -1 -- no detection performed, 0 -- no tones detected, 1 -- tones detected */
      s_TonesDetected = DetectGhsCarrierSet();
      if (s_TonesDetected == -1) return;
   }

    switch ( gs_RxSubState ) {

    /* =============================================== */
    /* initial silence period until a tone is first detected */
    /* =============================================== */
    case R_C_TONES_RX_DETECT_TONES:
        if ( s_TonesDetected ) {
         gs_TrainCnt = 0;
            gs_RxSubStateCnt = 0;
         for (i = 0; i < NUM_UNIQUE_DS_GHS_CARRIERS_SETS; i++)
         {
            gsa_DetectGhsCarrierSet_DetectCount[i] = 0;
         }
            gs_RxSubState    = R_C_TONES_RX_COUNT_SYMBOLS;
        }

        break;

    /* =============================================== */
    /* Count the number of symbols that tones are */
    /* present, and transition to R_C_GALF1_RX if */
    /* present for C_TONES_CNT consecutive symbols */
    /* =============================================== */
    case R_C_TONES_RX_COUNT_SYMBOLS:
        gs_RxSubStateCnt++;

        /* ---- back to substate R_C_TONES_RX_DETECT_TONES at tone loss ---- */
        if(!s_TonesDetected )
           gs_TrainCnt++;

      if(gs_TrainCnt == s_R_C_TONES_DETECTION_FAILURE_CNT)
      {
           gs_RxSubState = R_C_TONES_RX_DETECT_TONES;
      }

        /* ---- check if tones are present for C_TONES_CNT consecutive symbols ---- */
        if(gs_RxSubStateCnt >= s_R_C_TONES_BURST_CNT)
      {
#ifndef ISDN   // R3_P1: IOP_ALL_ALL_BDCM_ParadyneAnnexM

           // Detect whether J43 or A43c carrier set tones are present.

           if (gsa_DetectGhsCarrierSet_DetectCount[DS_GHS_CARRIER_SET_B43_J43]
               >= s_R_C_TONES_BURST_CNT)
           {
              guc_AnnexMCarSet_Detect = 0x1;

           }
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
//To enable detection on both B43 and A43c carrier set.
           //else if (gsa_DetectGhsCarrierSet_DetectCount[DS_GHS_CARRIER_SET_A43c]
           //         >= s_R_C_TONES_BURST_CNT)
           if (gsa_DetectGhsCarrierSet_DetectCount[DS_GHS_CARRIER_SET_A43c]
                    >= s_R_C_TONES_BURST_CNT)
           {
              guc_AnnexMCarSet_Detect |= 0x2;

           }
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
#endif // #ifndef ISDN //Paradyne_AnxM
         gsa_DnCarSet = NULL;
         /* Identify GHS carrier set used by far end in DS */
         if (gsa_DetectGhsCarrierSet_DetectCount[DS_GHS_CARRIER_SET_A43] >= s_R_C_TONES_BURST_CNT)
         {
            gsa_DnCarSet = gsa_DnCarSetA43;

            gs_DetectedCTones = A43_CTonesDetected; // XDSLRTFW-3511
         }
         else if (gsa_DetectGhsCarrierSet_DetectCount[DS_GHS_CARRIER_SET_B43_J43] >= s_R_C_TONES_BURST_CNT)
         {
            gsa_DnCarSet = gsa_DnCarSetB43_J43;
            gs_PilotToneIdx = C_PILOT_TONE_96;

            gs_DetectedCTones = B43_CTonesDetected; // XDSLRTFW-3511
         }

         else if (gsa_DetectGhsCarrierSet_DetectCount[DS_GHS_CARRIER_SET_A43c] >= s_R_C_TONES_BURST_CNT)
         {
            gsa_DnCarSet = gsa_DnCarSetA43c;
            gs_PilotToneIdx = gsa_DnCarSetA43c[0];

            gs_DetectedCTones = A43C_B43C_CTonesDetected; // XDSLRTFW-3511
         }

         /* ---- successful C_Tones detection, enter handshake ---- */
         if (gsa_DnCarSet != NULL)
         {
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
#ifndef ISDN
            if(gul_ModeControl & OPTN_ConfigMode_T1413)
            {
             guc_Ghs_fails_count++;
            }
#endif
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
            gs_PGA_required_In_GHS = gs_PGA_required;


            /* not excess power - go to next state */
            gs_RxNextState = R_C_GALF1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCGalf1RxF;
         }
         /* ---- back to substate R_C_TONES_RX_DETECT_TONES ---- */
         else
         {
            gs_DetectedCTones = NO_CToneDetected; // XDSLRTFW-3511

            gs_RxSubState = R_C_TONES_RX_DETECT_TONES;
         }
      }
        break;
    }   /*  switch */

}   /*  RCTonesRxF */

#undef GHSCARRIERSET_ACCUM
#undef GHSCARRIERSET_AVERAGE
#undef GHSCARRIERSET_DETECT

#undef R_C_TONES_RX_DETECT_TONES
#undef R_C_TONES_RX_COUNT_SYMBOLS
