/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RFlag2TxF.c
 *
 *
 *------------------------------------------------------------------------
 */

// ****************************************************************************************
// RFlag2TxF.c
//
// History
//
// 23/08/2012 Vinjam: Suppressed CRC/FEC counter write (through DSL 19 0 1) for CNXT DSLAM
//                    and initialized CRC & FEC counters to zero.
//            Grep for "XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI"
//
// 07/9/2012 Vinjam: Renamed "CMV_TO_SUPPRESS_HercCNTRtoSOCPLAM_SWWRITEOPTION" to "CMV_TO_SUPPRESS_CRC_FEC_WriteBackOption".
//                   Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 07/01/2013 Ram: Fix added for JIRA 575. Attach "FEC uncorrectable CW count" to CMV
//            Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
// *****************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "gdata_bis.h"



void TerminateHandshakeTx(void);

#ifdef BIS_CODESWAP
#include "soc_codeswap.h"
#endif

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RFlag2TxF
 *
 *  Description: FLAG characters are transmitted continuously until a
 *  GALF character is received.  Exits to selected G.hs mode when a
 *  GALF character is received.
 *
 *  Prototype: void RFlag2TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]            - frequency domain samples, used in TxBit()
 *      guc_TxOctet               - (I/O) current octet being transmitted
 *      gs_RxState                - (I) current RX state
 *      gs_TxSubState             - (I/O) current TX substate
 *      gl_TxSymbolCount          - (I) # symbol periods in current TX state
 *      gs_TxNextState            - (O) TX state that will begin next symbol period
 *
 *  Substates:
 *      R_FLAG2_TX_RECEIVE_GALF   - Wait until a GALF is received by the receiver.
 *      R_FLAG2_TX_TRANSMIT_FLAGS - Transmit additional FLAGs for a certain period
 *                                  of time, then exit G.hs.
 *
 *  Notes: implements state R_FLAG2_TX
 *
 *-------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_FLAG2_TX_RECEIVE_GALF   (0)
#define R_FLAG2_TX_TRANSMIT_FLAGS (1)

void RFlag2TxF(void)
{
#ifdef BIS_CODESWAP
    static int16 s_lflag = FALSE;
#endif//BIS_CODESWAP

    /* ---- initialize ---- */
    if ( gl_TxSymbolCount == 0 )
    {
        guc_TxOctet = FLAG;

#ifdef BIS_CODESWAP
      // It's time to swap rnoghs/post hndsk initialization Page if we get valid mode, otherwise we will stay in GHS back to Silent
      if (gft_enterTraining)
      {
         if ((gt_hsc.l_SelectedMode & G992_1_A ||
            gt_hsc.l_SelectedMode & G992_1_B ||
            gt_hsc.l_SelectedMode & G992_2_AB) &&
                !(gt_hsc.l_SelectedMode & HS_CHECK_2ND_32BITS))
         {
            gsa_CodeSwapNextSection[CSPAGE_BIS_R_NOGHS] = CSPAGE_BIS_XCVR0;
         }
         else
         {
            gsa_CodeSwapNextSection[CSPAGE_BIS_R_NOGHS] = CSPAGE_BIS_DISC1;
         }

            if(gs_CurrentCoChipset == CTLM_CO_CHIPSET)
            {
                gft_WorkAround_CTLM_chipset = 1;
            }
            else
            {
                gft_WorkAround_CTLM_chipset = 0;
            }


         gs_CodeSwapStatus = CODESWAP_START;
         gft_enterTraining = FALSE;
            s_lflag = TRUE;
      }
#endif
    }

#ifdef BIS_CODESWAP
    if (s_lflag)
    {
        //Wait to load the second page after state-machine becomes IDLE
        if (gs_CodeSwapStatus == CODESWAP_IDLE)
        {
         if ((gt_hsc.l_SelectedMode & G992_1_A ||
            gt_hsc.l_SelectedMode & G992_1_B ||
            gt_hsc.l_SelectedMode & G992_2_AB) &&
                !(gt_hsc.l_SelectedMode & HS_CHECK_2ND_32BITS))
         {
                //change the default behavior which is for BIS
            gsa_CodeSwapNextSection[CSPAGE_BULK_O1] = CSPAGE_BIS_DMT_RAM;
         }

            //when we start code-swap here, we will start CSPAGE_BULK_O1,
            //because both two possible "current-page" (CSPAGE_BIS_XCVR0 or
            //CSPAGE_BIS_DISC1) have their "next" to be CSPAGE_BULK_O1.
         gs_CodeSwapStatus = CODESWAP_START;
         s_lflag = FALSE;
        }
    }
#endif//BIS_CODESWAP

#ifdef DEBUG_GHS
    if ( ( gl_TxSymbolCount % SYMBOLS_PER_OCTET ) == 0 )
        printf( "Tx\t%x\t", guc_TxOctet );
#endif /*  DEBUG_GHS */

    /* ---- Transmit guc_TxOctet bit by bit ---- */
    TxBit();

    /* ==== if completing one octet ==== */
    if ( (gl_TxSymbolCount & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) ) {

        switch (gs_TxSubState) {

        /* =============================================== */
        /* wait until a GALF is received in Rx side  */
        /* =============================================== */
        case R_FLAG2_TX_RECEIVE_GALF:
            if (gt_hsc.s_RxMsgComplete == TRUE) {
                gt_hsc.s_RxMsgComplete = FALSE;  /*  reset flag */
                guc_TxOctet   = FLAG;
                gs_TxOctetCnt = 1;
                gs_TxSubState = R_FLAG2_TX_TRANSMIT_FLAGS;
            }
            else {
                guc_TxOctet = FLAG;
            }
            break;

        /* =============================================== */
        /* transmit additional FLAGs for a certain period of time, then exit G.hs */
        /* =============================================== */
        case R_FLAG2_TX_TRANSMIT_FLAGS:
            gs_TxOctetCnt++;

         // Start terminate GHS once we reach the min CD flags and
         // we finish codeswap DISC1 page
            if ((gs_TxOctetCnt >= gs_num_cleardown_flags)
#ifdef BIS_CODESWAP
         &&(gs_CodeSwapStatus == CODESWAP_IDLE)
#endif
         ){
               gt_hsc.s_TxMsgComplete = TRUE;
               TerminateHandshakeTx();
            }
            else {
                guc_TxOctet = FLAG;
            }

            break;

        }

    }   /* if */

}   /*  RFlag2TxF */

#undef R_FLAG2_TX_RECEIVE_GALF
#undef R_FLAG2_TX_TRANSMIT_FLAGS

