/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RGalf2TxF.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "gdata_bis.h"



#ifdef BIS_CODESWAP
#include "soc_codeswap.h"
#endif

extern void TerminateHandshakeTx(void);



/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RGalf2TxF
 *
 *  Description: FLAG characters are transmitted for a while not exceeding 500ms
 *  followed by 4 GALF characters.  Then, G.HS exits to selected G.hs mode.
 *
 *  Prototype: void RGalf2TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]        - frequency domain samples, used in TxBit()
 *      guc_TxOctet           - (I/O) current octet being transmitted
 *      gs_RxState            - (I) current RX state
 *      gs_TxSubState         - (I/O) current TX substate
 *      gl_TxSymbolCount      - (I) # symbol periods in current TX state
 *      gpuca_TxMsgBuf        - (I) message octets to be transmitted in this state
 *      gs_TxNextState        - (O) TX state that will begin next symbol period
 *      gt_StateMachCntrl     - (I) state machine control information
 *      guc_NoCommonModeFlag  - (I/O) flag indicating no common mode selected
 *
 *  Notes: implements state R_GALF2_TX
 *
 *-------------------------------------------------------------------
 *^^^
 */
void RGalf2TxF(void) {

    /* ---- initialize ---- */
    if ( gl_TxSymbolCount == 0 ) {
        gs_TxOctetCnt = 1;
        guc_TxOctet   = gpuca_TxMsgBuf[0];
    }

#ifdef BIS_CODESWAP
   if (gs_CodeSwapStatus == CODESWAP_IDLE)
   {
      if (gft_enterTraining)
      {
        //when we start code-swap here, we will start CSPAGE_BULK_O1,
        //because both two possible "current-page" (CSPAGE_BIS_XCVR0 or
        //CSPAGE_BIS_DISC1) have their "next" to be CSPAGE_BULK_O1.
      gs_CodeSwapStatus = CODESWAP_START;
      if ((gt_hsc.l_SelectedMode & G992_1_A ||
         gt_hsc.l_SelectedMode & G992_1_B ||
         gt_hsc.l_SelectedMode & G992_2_AB) &&
            !(gt_hsc.l_SelectedMode & HS_CHECK_2ND_32BITS))
      {
            //change the default behavior which is for BIS
         gsa_CodeSwapNextSection[CSPAGE_BULK_O1] = CSPAGE_BIS_DMT_RAM;
      }

        gft_enterTraining = FALSE;
    }
   }//CODESWAP_IDLE
#endif//BIS_CODESWAP

#ifdef DEBUG_GHS
    if ( ( gl_TxSymbolCount % SYMBOLS_PER_OCTET ) == 0 )
        printf( "Tx\t%x\t", guc_TxOctet );
#endif /*  DEBUG_GHS */

    /* ---- Transmit guc_TxOctet bit by bit ---- */
    TxBit();

    /* ==== if completing one octet ==== */
    if ( (gl_TxSymbolCount & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) )
    {

        /* ---- transmit FLAGs and GALFs ---- */
        if (gs_TxOctetCnt < gs_TxMsgBufCnt)
        {
#ifdef BIS_CODESWAP
         /* Make sure FLAGs are being transmitted until code swap finishes. */
         if (gs_TxOctetCnt == gs_num_cleardown_flags)
         {
            if (gs_CodeSwapStatus != CODESWAP_IDLE)
            {
               gs_TxOctetCnt--;
            }
         }
#endif
            guc_TxOctet = gpuca_TxMsgBuf[gs_TxOctetCnt++];
        }
        /* ---- jump to next state when done ---- */
        else
        {
            gt_hsc.s_TxMsgComplete = TRUE;

                TerminateHandshakeTx();
        }

    }  /*  if (octet complete) */

}   /*  RGalf2TxF */


