/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RHSMsgTxF.c
 *
 *
 *------------------------------------------------------------------------
 */
 //****************************************************************************
//RHSMsgTxF.c
//
// History
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx-
//                   G.Hs messages
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 24/01/2014 Balabath :- Correction of bugs and implementation as per the ErasureDecoding implementation
//                      -Change of Default settings of DSL 1 0 CMV settings
//                      - IOP issues resolved with EBLT-C
//                      for Code Changes grep for " XDSLRTFW-1502 "
//
// 10/04/2014 Sriram Shastry: To reduce the training time against CNX5, the
//            following two changes are introduced.
//            1. Remove US bounds/TSSI information from long CLR.
//            2. Remove the additional long CLR which is due to the CPE
//               preferred US PSD MASK is not matched with CO in the G.hs
//               Annex L message. When this happends, CPE just takes the
//               information from CL and doesn't need to send back to CO.
//            This is protected by CMV info 103 26 0x100. The default value
//            is 0 (Disabled.)
//            Grep for ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS
//
//  30/3/2015 Sriram Shastry:Jira XDSLRTFW-1843 :CPE  is unable to  link in ADSL2/ADSL2P under Multi-mode configuration.
//  Solution is force CPE  to  G.DMT  mode after 3 fails attempts during  training in ADSL2/ASDL2P mode.
//    Grep for  XDSLRTFW-1843
//
// 12/10/2015 Vinay: Added code to support G.Fast in ADSL G.Hs session.
//            Grep for XDSLRTFW-2298
//********************************************************************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "HSMsgTx_Util.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "RFlag2TxF.h"
#include "RGalf2TxF.h"
#include "gdata_bis.h"
#include "trail.h"
#include "DebugBuffer.h"



#ifdef BIS_CODESWAP
#include "soc_codeswap.h"
#endif
#define CMV_PTM_SELECTED                  0x1000
extern void SelectMode_Bis( Adsl2AllInfo_t *pt_BisInfo, Adsl2AllInfo_t *pt_TxBisInfo, Adsl2AllInfo_t *pt_RxBisInfo, int16 s_MultFactor );
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RHSMsgTxF
 *
 *  Description:
 *    Handshake messages are transmitted until message exchange is
 *    over and cleardown is requested.  Idle FLAGs are transmitted when there
 *    is no message to transmit.
 *
 *  Prototype: void RHSMsgTxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]              - frequency domain samples, used in TxBit()
 *      guc_TxOctet                 - (I/O) current octet being transmitted
 *      gs_RxState                  - (I) current RX state
 *      gs_TxSubState               - (I/O) current TX substate
 *      gl_TxSymbolCount            - (I) # symbol periods in current TX state
 *      gs_TxNextState              - (O) TX state that will begin next symbol period
 *      gpuca_TxMsgBuf              - (I) message octets to be transmitted in
 *                                    this state
 *      gs_TxMsgBufCnt              - (O) # octets in the message buffer to be
 *                                    transmitted in this state
 *      gt_hsc                      - (I/O) handshake control structure
 *      gft_RxSymbolReAlignRequired - (I/O) symbol realign flag
 *
 *  Substates:
 *      R_HS_MSG_TX_PREFIX_FLAG     - Transmits NUM_PREFIX_FLAG mandatory FLAGs
 *                                    at the head of a message.
 *      R_HS_MSG_TX_MESSAGE         - Transmits a message body.
 *      R_HS_MSG_TX_POSTFIX_FLAG    - Transmits NUM_POSTFIX_FLAG mandatory FLAGs
 *                                    at the tail of a message.
 *      R_HS_MSG_TX_IDLE_FLAG       - Transmits FLAGs while waiting for a
 *                                    message in Rx side.
 *
 *  Notes: implements state R_HS_MSG_TX
 *
 *-------------------------------------------------------------------
 *^^^
 */
// ------------------------------------------------------------------
// RHSMsgTxF.c
//
// History
//
// 20/8/2010 Sriram Shastry : Moved SelectMode() from Handshake Page 1 to
//   handshake Page 2 to free up program  memory in handshake page 1
//
// 20/08/2010 Sriram Shastry : PrepareCLR_Bis () from Handshake Page 1 to
//   handshake Page 2 to free up program  memory in handshake page 1
//
//-------------------------------------------------------------------

/* =============================================== */
/* substates */
/* =============================================== */
#define R_HS_MSG_TX_PREFIX_FLAG     (0)
#define R_HS_MSG_TX_MESSAGE         (1)
#define R_HS_MSG_TX_POSTFIX_FLAG    (2)
#define R_HS_MSG_TX_IDLE_FLAG       (3)


// newly created global variables for msg segmentation
//uint8 guca_MsgSegment[2*(gs_MaxMsgLen+FCS_LEN)]; // the reason we put 2*(MAX_MESSAGE_LEN+FCS_LEN) here is that
                                  // in G.HS standard sec 10.3, saying that "Not including the two octets
                                  // of FCS and any octets that have been inserted to achieve octet
                                  // transparency, the maximum number of octets in any frame shall be 64"
                                  // Therefore, the transmitted msg could reach 2*(MAX_MESSAGE_LEN+FCS_LEN)
#if defined(DANUBE) || defined(ADSL_62)
DATA_MAP_ILV1_GHS
#else
DATA_BULKO2_BEGIN
#endif
uint8 guca_MsgSegment[256];
DATA_MAP_END//DATA_BULKO2_BEGIN
// msg segment length
int16 gs_MsgSegLen;

extern HS_Encode_ADSL2_t   gta_HS_ADSL2[];      //Sriram : Moved as a part of program memory reshuffle HNDSHK Page 1 to HNDSHK Page 2
extern FlagT gft_StopTssiInClr;              //Sriram : Moved as a part of program memory reshuffle HNDSHK Page 1 to HNDSHK Page 2

void RHSMsgTxF(void) {

    /* ---- initialize ---- */
    if ( gl_TxSymbolCount == 0 )
    {
         guc_TxOctet    = FLAG;
      gs_MsgOctetCnt     = 0;
      gs_MsgOffset = 0;
        gs_TxMsgBufCnt = 0; /*  no message to transmit at the beginning of message exchange (HS_INITIAL) */

      InitNextMsgExchange();
    }

#ifdef DEBUG_GHS
    if ( ( gl_TxSymbolCount % SYMBOLS_PER_OCTET ) == 0 )
        printf( "Tx\t%x\t", guc_TxOctet );
#endif /*  DEBUG_GHS */

    /* ---- if timeout or tone loss in the Rx side, go back to the beginning ---- */
    if ( gs_RxState == R_C_SILENT1_RX )
    {
         gs_TxNextState = R_SILENT0_TX;
         gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
         return;
    }

    /* ---- Transmit guc_Octet bit by bit ---- */
    TxBit();

    /*  **** if completing an octet **** */
    if ( (gl_TxSymbolCount & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) )
    {
        switch (gs_TxSubState)
        {

        /* ==== transmit NUM_PREFIX_FLAG mandatory FLAGs at the head of a message ==== */
        case R_HS_MSG_TX_PREFIX_FLAG:
            TxFlag( NUM_PREFIX_FLAG, R_HS_MSG_TX_MESSAGE );
         if (gs_TxSubState == R_HS_MSG_TX_MESSAGE)
         {
            // If a retransmit msg segment request is received,
            // we have to do retransmission
            if (gft_TxRetransmit_Msg == TRUE)
               // Omit the new Tx segmentation
               return;

            gs_MsgSegLen = 0;
            if (gs_MsgOctetCnt < gs_TxMsgBufCnt)
               TxSegmentMsg();
         }

            break;

        /* ==== transmit a message body ==== */
        case R_HS_MSG_TX_MESSAGE:
         if (gs_TxOctetCnt < gs_MsgSegLen)
         {
            guc_TxOctet = guca_MsgSegment[gs_TxOctetCnt++];

            // Only when we are not retransmitting the last msg, can we increase msg octet counter
            if (!gft_TxRetransmit_Msg)
               gs_MsgOctetCnt++;
               if (gs_TxOctetCnt==1)
               {
                  DebugTrail(2,DEBUG_LOG_GHSMESSAGES, (int16) 0xAAAE, (int16) gl_RxSymbolCount);
               }
               DebugTrail(1,DEBUG_LOG_GHSMESSAGES, (int16)guc_TxOctet);

         }
         else
         {
#ifdef DEBUG_TRACES // XDSLRTFW-597
            //for debug purpose, log Tx GHS messages formed
            LogMessages(4,END_OF_THE_MSG,(uint16)guca_MsgSegment[0], (uint16)gs_MsgSegLen, (uint8 *)guca_MsgSegment, DEBUG_BUFFER_DELIMITER_GHS_TX_MSG);
#endif
#ifdef DEBUG_STREAMING
            DSH_SendEvent(DSH_EVT_GHS_TX,(uint16)gs_MsgSegLen,(void *)guca_MsgSegment);
#endif
            if (gs_MsgOctetCnt == gs_TxMsgBufCnt)
            {
               // reach the whole msg end
               gs_TxMsgBufCnt = 0;  //Reset gs_TxMsgBufCnt to 0
               gs_MsgOctetCnt = 0;  //Reset gs_MsgOctetCnt to 0
               gs_MsgOffset = 0;
               gft_WholeTxMsgComplete = TRUE;
            }



            // reach the msg segment end
            gt_hsc.s_TxMsgComplete    = TRUE;
            gft_SymbolReAlignRequired = TRUE;
            gs_ReAlignSubState         = 0;  /*  reset */
            guc_TxOctet               = FLAG;
            gs_TxOctetCnt             = 1;
            gs_TxSubState             = R_HS_MSG_TX_POSTFIX_FLAG;
         }

            break;

        /* =============================================== */
        /* transmit NUM_POSTFIX_FLAG mandatory FLAGs at the tail of a message */
        /* =============================================== */
        case R_HS_MSG_TX_POSTFIX_FLAG:
         DebugTrail(1,DEBUG_LOG_GHSMESSAGES, (int16) 0x007E) ;

            TxFlag( NUM_POSTFIX_FLAG, R_HS_MSG_TX_IDLE_FLAG );
            break;

        /* =============================================== */
        /* transmit FLAGs while waiting for a message in Rx side */
        /* =============================================== */
        case R_HS_MSG_TX_IDLE_FLAG:

            guc_TxOctet = FLAG;

            /* ---- if a message is completely received and decoded, move to next state ---- */
            if (gt_hsc.s_RxMsgComplete == TRUE)
            {
                gt_hsc.s_RxMsgComplete = FALSE; /* reset flag */

                /* ---- if HS message exchange is done, go to cleardown procedure ---- */
                if (gt_hsc.s_NextState == R_HS_EXIT)
               {
                  if (gt_hsc.s_State == R_HS_MS_OK)
                  {
                     gs_TxNextState = R_FLAG2_TX;
                     gpF_TxStateFunc = (PtrToFunc)RFlag2TxF;
                  }
                  else if (gt_hsc.s_State == R_HS_SEND_MS)
                  {
#ifdef BIS_CODESWAP
                     // We normally wouldn't get time out, but since BIS codeswap happens here,
                     // there is possibility that we could violate the at most 500ms transmitting
                     // FLAG restriction.
                     if (gs_TxOctetCnt > (TIME_500MS/MODULO_BY_64_MASK))
                     {
                     gs_TxNextState = FAIL_TX;
                     gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

                     /* set exception handler variables */
                     gus_ExceptionState   = gs_TxState;
                     gus_ExceptionCode = E_CODE_GHS_CD_FLAG_TIME_OUT;
                     return;
                  }

                  gs_TxOctetCnt++;

                  // It's time to swap rnoghs/post hndsk initialization Page if we get valid mode, otherwise we will stay in GHS back to Silent
                     if (gft_enterTraining)
                     {
                        if ((gt_hsc.l_SelectedMode & G992_1_A ||
                        gt_hsc.l_SelectedMode & G992_1_B ||
                        gt_hsc.l_SelectedMode & G992_2_AB) &&
                                !(gt_hsc.l_SelectedMode & HS_CHECK_2ND_32BITS))
                     {
                        gsa_CodeSwapNextSection[CSPAGE_BIS_R_NOGHS] = CSPAGE_BIS_XCVR0;
                     }
                     else
                     {
                                //assumption made: not DMT then BIS
                        gsa_CodeSwapNextSection[CSPAGE_BIS_R_NOGHS] = CSPAGE_BIS_DISC1;
                     }

                            if(gs_CurrentCoChipset == CTLM_CO_CHIPSET)
                            {
                                gft_WorkAround_CTLM_chipset = 1;
                            }
                            else
                            {
                                gft_WorkAround_CTLM_chipset = 0;
                            }

                     gs_CodeSwapStatus = CODESWAP_START;
                            //we dont need this since the next time we are at the next-state.
                            //And we use this flag to do code-swap in R_GALF2_TX.
                     //gft_enterTraining = FALSE;
                  }
#endif

                        gs_TxNextState = R_GALF2_TX;
                  gpF_TxStateFunc = (PtrToFunc)RGalf2TxF;

               } // end else if gt_hsc.s_State==R_HS_SEND_MS ;; If any other s_State, we should fail through Rx side handling.

                }
                /* ---- else, if gt_hsc.s_NextState != R_HS_EXIT, keep exchanging messages ---- */
                else
            {
                    InitNextMsgExchange();
                }

            }   /*  if (message complete) */

            break;

        }   /*  switch */

    }   /*  if (complete an octet) */

}   /*  RHSMsgTxF */


   /*^^^
 *-------------------------------------------------------------------
 *
 *  Name: SelectMode
 *
 *  Abstract: Selects mode of operation based on exchaned MS message
 *
 *  Parameters :
 *      pt_MS_Info - information structure containing mode select message.
 *
 *  Returns: one of the following mode code
 *      NO_COMMON_MODE
 *      SILENCE
 *      G_992_1_A
 *      G992_2_AB_ESC_TO_FR
 *      G992_2_AB_FULL_INIT
 *      NOT_SELECTED
 *
 *  Global Variables Used:
 *      gft_RS_Support - (O)
 *      gft_PilotOnDecTraining - (O)
 *
 *-------------------------------------------------------------------
 *^^^
 */
int32 SelectMode( InfoField_t *pt_MS_Info ) {

    int32 l_SelectedMode;
    int i, j;
    HS_Encode_ADSL2_t *pt;
    Adsl2AllInfo_t *pt1, *pt2,*pt3;
   uint8 uc_SI_SPar1_ORed ;

   l_SelectedMode = NOT_SELECTED ;     // Default; will change according to MS message

      for (i=0, uc_SI_SPar1_ORed=0 ; i<NUM_SI_SPAR1_OCTETS; i++)
      {
         uc_SI_SPar1_ORed |= pt_MS_Info->uc_SI_SPar1[i] ;
      }

#ifdef ADSL_BONDING
      if((pt_MS_Info->uc_ID_SPar1[2] & BONDING) && (pt_MS_Info->uc_BondingNP2 & BONDING_ETHERNET))
      {
         gft_RemotePAF_Enable = TRUE;
      }
      if( ((pt_MS_Info->uc_ID_SPar1[2] & BONDING) && (pt_MS_Info->uc_BondingNP2 & BONDING_ETHERNET))&&
          ((pt_MS_Info->uc_SI_NPar1 & SILENT_PERIOD) != 0))
      {
         l_SelectedMode  = SILENCE;
      }

      else
#endif
      /* ---- no common mode is indicated by an MS ---- */
      if ( ((pt_MS_Info->uc_ID_NPar1&NON_STANDARD)==0)
            && (pt_MS_Info->uc_SI_NPar1==0) && (uc_SI_SPar1_ORed==0) )
      {
         l_SelectedMode = NO_COMMON_MODE;
         //   gus_ExceptionCode = E_CODE_GHS_NoCommonMode ;
         gl_ADSL_Annex_Mode =0; // XDSLRTFW-2191(Start_End)
         // XDSLRTFW-1843(Start)
         guc_IFTN_CRC_MISMATCH_ERR_cnt = 0;
         guc_IFTN_DMT_T1413_Train_Cnt  = 0;
         // XDSLRTFW-1843(End)
      }

      /* ---- 1min of silence requested ---- */
      else if ( (pt_MS_Info->uc_SI_NPar1 & SILENT_PERIOD) != 0 )
      {
         l_SelectedMode  = SILENCE;
      }

      // For ADSL1 mode indicated in MS, we need to be sure that we also support it (i.e. sent them in CLR)
#ifndef ISDN
      /* ---- G.992.1 Annex A selected ---- */
      else if ( (pt_MS_Info->uc_SI_SPar1[0] & G992_1_A) && (gpt_TxInfoSave->uc_SI_SPar1[0] & G992_1_A) )
      {
        l_SelectedMode = G992_1_A;

        if ( ( pt_MS_Info->uc_SI_1A_NPar2 & R_ACK1 ) != 0 )
            gft_PilotOnDecTraining = FALSE;
        else if ( ( pt_MS_Info->uc_SI_1A_NPar2 & R_ACK2 ) != 0 )
            gft_PilotOnDecTraining = TRUE;
        else
            l_SelectedMode = NOT_SELECTED;

        if ( ( pt_MS_Info->uc_SI_1A_NPar2 & STM ) != 0 )
            gft_TransferMode  = STM;
        else if ( ( pt_MS_Info->uc_SI_1A_NPar2 & ATM ) != 0 )
            gft_TransferMode = ATM;
        else
            l_SelectedMode = NOT_SELECTED;

        gft_RS_Support = 16;    // mandatory for G992_1
      }
#else
      /* ---- G.992.1 Annex B selected ---- */
      else if ( (pt_MS_Info->uc_SI_SPar1[0] & G992_1_B) && (gpt_TxInfoSave->uc_SI_SPar1[0] &G992_1_B) )
      {
         l_SelectedMode = G992_1_B;

         if ( ( pt_MS_Info->uc_SI_1B_NPar2 & R_ACK1 ) != 0 )
            gft_PilotOnDecTraining = FALSE;
         else if ( ( pt_MS_Info->uc_SI_1B_NPar2 & R_ACK2 ) != 0 )
            gft_PilotOnDecTraining = TRUE;
         else
            l_SelectedMode = NOT_SELECTED;

         if ((pt_MS_Info->uc_SI_1B_NPar2 & UPSTREAM_1_32_DMT) != 0)
         {
            gft_Tones1To32Support = TRUE;
         }

         if ( ( pt_MS_Info->uc_SI_1B_NPar2 & STM ) != 0 )
            gft_TransferMode  = STM;
         else if ( ( pt_MS_Info->uc_SI_1B_NPar2 & ATM ) != 0 )
            gft_TransferMode = ATM;
         else
            l_SelectedMode = NOT_SELECTED;

         gft_RS_Support = 16;    // mandatory for G992_1
      }
#endif//ISDN
      /* ---- G.992.2 Annex A/B selected ---- */
      else if ( (pt_MS_Info->uc_SI_SPar1[0] & G992_2_AB) && (gpt_TxInfoSave->uc_SI_SPar1[0] & G992_2_AB) )
      {
#ifdef INCLUDE_FASTRETRAIN_CODE
         if ( pt_MS_Info->uc_SI_2AB_NPar2 & FAST_RETRAIN )
         {
            l_SelectedMode = G992_2_AB_ESC_TO_FR;
            gft_AutoRestartFlag = TRUE;
         }
         else
#endif
            l_SelectedMode = G992_2_AB_FULL_INIT;

         if ( ( pt_MS_Info->uc_SI_2AB_NPar2 & R_ACK1 ) != 0 )
            gft_PilotOnDecTraining = FALSE;
         else if ( ( pt_MS_Info->uc_SI_2AB_NPar2 & R_ACK2 ) != 0 )
            gft_PilotOnDecTraining = TRUE;
         else
            l_SelectedMode = NOT_SELECTED;

         if ( ( pt_MS_Info->uc_SI_2AB_NPar2 & RS16 ) != 0 )
            gft_RS_Support = 16;
         else
            gft_RS_Support = 8;

      }


      if (l_SelectedMode == NOT_SELECTED){
         pt = gta_HS_ADSL2;

      for (i=0 ; i<NUM_KNOWN_ADSL2_SPAR1_BITS ; i++){
         // For ADSL2 mode indicated in MS, we need to be sure that we also support it (i.e. sent them in CLR),
         // and that the CO did send information about them in CL;; otherwise, we choose l_SelectedMode = NOT_SELECTED
         if ( (pt_MS_Info->uc_SI_SPar1[pt->SI_SPar1_idx] & pt->SI_Spar1_anx_bit)
            && (gpt_TxInfoSave->uc_SI_SPar1[pt->SI_SPar1_idx] & pt->SI_Spar1_anx_bit)
            && (gpt_RxInfoSave->uc_SI_SPar1[pt->SI_SPar1_idx] & pt->SI_Spar1_anx_bit) )
         {
            l_SelectedMode = pt->smode;
#ifndef ISDN
            //special stuff for Annex-L
            if (l_SelectedMode == G992_3_A_FULL_INIT){
               //check whether Annex-L is selected
               if ((pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_A]->uc_SI_SPar2[0] & PSD_MASK) &&
                  (pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_A]->uca_PSD_Mask[0]) &&
                  (pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_A]->uca_PSD_Mask[1]))
               {
                  l_SelectedMode = G992_3_L_FULL_INIT;
                  STATArray[STAT_Misc] |= (pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_A]->uca_PSD_Mask[0] << 12);
               }
            }//l_SelectedMode
#endif//ISDN
            if (pt->bis_plus == 0){//BIS mode
               pt1 = pt_MS_Info->pta_G9923xInfo[pt->anx];
               pt2 = gpt_TxInfoSave->pta_G9923xInfo[pt->anx];
               pt3 = gpt_RxInfoSave->pta_G9923xInfo[pt->anx];
               j = 1;
            }
            else{//PLUS mode
               pt1 = pt_MS_Info->pta_G9925xInfo[pt->anx];
               pt2 = gpt_TxInfoSave->pta_G9925xInfo[pt->anx];
               pt3 = gpt_RxInfoSave->pta_G9925xInfo[pt->anx];
               j = 2;

            }
            SelectMode_Bis(pt1, pt2, pt3, (int16)j);
            break;
         } //pt_MS_Info...
         pt++;
      }//i
   }

   if ((pt_MS_Info->uc_SI_SPar1[4] & G9701) && (gpt_TxInfoSave->uc_SI_SPar1[4] & G9701))
   {
      l_SelectedMode = G9701;
   }
#ifdef LEAVE_TRAIL
   CopyInfoField (pt_MS_Info, &gt_TrailMSInfo, FALSE);
#endif
    return (l_SelectedMode);

}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: PrepareCLR_Bis
 *
 *  Abstract: Sets up Bis (ADSL2) or BisPlus (ADSL2+) parameters for a CLR
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */
// XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
//Sriram : Kept for Debug purpose
uint8 guca_Spar2_Octet2 = 0;
void PrepareCLR_Bis(Adsl2AllInfo_t *pt_BisInfo, uint8 s_annex, FlagT ft_BisOrPlus)
{

   int i, j, k;
   uint8 *puca_MaxNum_TpsTc[6] = {&pt_BisInfo->uc_DS_Max_Num_STM_TPS_TC, &pt_BisInfo->uc_DS_Max_Num_ATM_TPS_TC,
                           &pt_BisInfo->uc_DS_Max_Num_PTM_TPS_TC, &pt_BisInfo->uc_US_Max_Num_STM_TPS_TC, &pt_BisInfo->uc_US_Max_Num_ATM_TPS_TC,
                           &pt_BisInfo->uc_US_Max_Num_PTM_TPS_TC,};
   TPS_TC_BearerChannel_t *pta_BearerChannel[2] = {&(pt_BisInfo->ta_DSBearerChannel[0]), &(pt_BisInfo->ta_USBearerChannel[0])};

   int16 sa_Nbc[2];

   //ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS (START_END)
   if ((gft_StopTssiInClr) || (gft_CTNW_Shorten_GHS))
      pt_BisInfo->uc_SI_SPar2[0]  = TX_IMAGE_NYQ;
   else
      pt_BisInfo->uc_SI_SPar2[0]  = SPECTRUM_BOUNDS_UP | SPECTRUM_SHAPE_UP | TX_IMAGE_NYQ;

#ifndef ISDN
   if (!ft_BisOrPlus && s_annex == G992_3_ANNEX_A) // BIS Annex A
   {
      //G992.3 AnnexL PSD info indication bit
      if (gul_ModeControl & OPTN_ConfigMode_G992_3_L)
      {
         pt_BisInfo->uc_SI_SPar2[0]  |= PSD_MASK;

         // G992.3 AnnexL PSD Mask
         pt_BisInfo->uca_PSD_Mask[0] = PSD_MASK_ANXL_US;
         pt_BisInfo->uca_PSD_Mask[1] = PSD_MASK_ANXL_DS;
      }
   }
#else
   if (s_annex == G992_5_ANNEX_J || s_annex == G992_3_ANNEX_J)
   {
      // Do not send US Tssi for now
      // pt_BisInfo->uc_SI_SPar2[0]  =  // SPECTRUM_BOUNDS_UP | SPECTRUM_SHAPE_UP | TX_IMAGE_NYQ;
      if (gft_StopTssiInClr)
         pt_BisInfo->uc_SI_SPar2[0]  = TX_IMAGE_NYQ;
      else
         pt_BisInfo->uc_SI_SPar2[0]  = SPECTRUM_BOUNDS_UP | SPECTRUM_SHAPE_UP | TX_IMAGE_NYQ;

      pt_BisInfo->uc_SI_SPar2[0]  |= PSD_MASK;

      // G992.3 AnnexL PSD Mask
      pt_BisInfo->uca_PSD_Mask[0] = PSD_MASK_ANXJ_US1;
      pt_BisInfo->uca_PSD_Mask[1] = PSD_MASK_ANXJ_US2;
   }
#endif//ISDN
   else if (s_annex == G992_3_ANNEX_M || s_annex == G992_5_ANNEX_M)  // BIS/PLUS Annex M
   {
      pt_BisInfo->uc_SI_SPar2[0]  |= PSD_MASK;

      // G992.3/5 AnnexM PSD Mask
      pt_BisInfo->uca_PSD_Mask[0] = PSD_MASK_ANXM_US1;
      pt_BisInfo->uca_PSD_Mask[1] = PSD_MASK_ANXM_US2;
   }

   if((OPTNArray[OPTN_StateMachineCtrl] & OPTN_EnableDiagMode) !=0) /* If CPE asks for diagnostics mode */
      pt_BisInfo->t_PMD_Npar2.ft_DiagMode = DIAGNOSTICS_MODE;
   else
      pt_BisInfo->t_PMD_Npar2.ft_DiagMode = 0;

   if((OPTNArray[OPTN_StateMachineCtrl] & OPTN_EnableShortInit) !=0) /* If CPE asks for shortInit mode */
      pt_BisInfo->t_PMD_Npar2.ft_ShortInit = SHORT_INIT;
   else
      pt_BisInfo->t_PMD_Npar2.ft_ShortInit = 0;

    pt_BisInfo->uc_SI_NPar2[0]  = (pt_BisInfo->t_PMD_Npar2.ft_DiagMode | pt_BisInfo->t_PMD_Npar2.ft_ShortInit);

#ifdef ISDN
   if ((s_annex == G992_5_ANNEX_B) || (s_annex == G992_3_ANNEX_B))
   {
        pt_BisInfo->uc_SI_NPar2[0] |= UPSTREAM_1_32_BIS;
   }
#endif
   // XDSLRTFW-1502 (start)
   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
   if( (gs_DSL_EDcontrol & DSL_Enable_ERASUREDECODING_REPORTING) == DSL_Enable_ERASUREDECODING_REPORTING)
   {
       //change it to variable. Can be optimized
       pt_BisInfo->uc_SI_NPar2[1]|=  REPORT_ED;
   }
   // XDSLRTFW-1502 (end)

   pt_BisInfo->uc_SI_SPar2[1] = OH_DATARATE_DN | OH_DATARATE_UP | MAX_NUM_DS_TPSTC_FUNC_OF_EACH_TYPE | MAX_NUM_US_TPSTC_FUNC_OF_EACH_TYPE ;



   sa_Nbc[0] = gt_rx_config.s_Nbc;
   sa_Nbc[1] = gt_tx_config.s_Nbc;

   // reset the maximum number of TPS TC bearer channels

   for (k = 0; k < 2; k++)
         for (j = 0; j < 3; j++)
            *(puca_MaxNum_TpsTc[3*k+j]) = 0;

   for (k = 0; k < 2; k++)
   {
      for(i=0; i<sa_Nbc[k]; i++)
      {
         for (j = 0; j < 3; j++)
         {
            if (((pta_BearerChannel[k] + i)->s_Control) & j)
            {
               pt_BisInfo->uc_SI_SPar2[2*(i+1)] |= ((0x1+k)<<(2*j));
               // XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
               guca_Spar2_Octet2 |=pt_BisInfo->uc_SI_SPar2[2*(i+1)]; // for debug purpose
               //gt_ADSL_TcMode_Reprt.uc_TC_mode = guca_temp_Spar2_Octet2;
               *(puca_MaxNum_TpsTc[3*k+j])+= 1;
            }
         }
      }
   }

      // first check DS latency paths number
   for (i = 0; i < gt_rx_config.s_Nlp; i++)
      pt_BisInfo->uc_SI_SPar2[1+2*(i+1)] = 0x1; //DS latency path indicator bit is the LSB

      // next check US latency paths number
   for (i = 0; i < gt_tx_config.s_Nlp; i++)
      pt_BisInfo->uc_SI_SPar2[1+2*(i+1)] |= 0x2; //US latency path indicator bit is the 2nd LSB
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
#ifdef UNV_RETX_GHS
   if(gt_ReTxConfigInfo.us_ReTxConfigOptionBits & CMV_BIT_INDICATE_RETX)
   {
   // Enable retransmission for PSTC_TYPE_ATM(j =1) or TPSTC_TYPE_PTM(j=2)
   for (j = 1; j < 3; j++)
   {
      if ((pta_BearerChannel[0] ->s_Control) & j)
      {

         //Enable ReTransmission for TPSTC_TYPE_ATM(j =1) or TPSTC_TYPE_PTM(j=2)
         // DownStream(k=0) Bearer 0(i=0)
         // G.bis ATM TPS-TC #0 RETX/PTM TPS-TC #0 RETX in downstream supported
         pt_BisInfo->uc_SI_SPar2[3] |= 0x1 << (1+j);

      }
   }
   }
#endif
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
}

#ifdef ADSL_BONDING
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : StoreInfoField_Bonding_NPar3
 *  Author : Sriram Shastry
 *  Abstract :
 *    StoreInfoField_Bonding_NPar3() - Store NPar3 Discovery and PME aggregation fields into (CMV-mapped) variable
 *
 *  Parameters:
 *      InfoField_t *t_I : information structure to read from
 *       uint8 uc_FieldToStore:  which NPar3 field to store (bitfield - so multiple bits may be set)
 *
 *  Returns: None
 *
 *-------------------------------------------------------------------
 *^^^
 */

C_SCOPE void StoreInfoField_Bonding_NPar3(InfoField_t *t_I, uint8 uc_FieldToStore)
{
   if (uc_FieldToStore & BONDING_PME_DISCOVERY)
   {
      // PME discovery command
      gt_Bonding_DiscAggr_Status.sa_DiscCode[0] = (t_I->uca_BondingDisc[1]<<10)
                                          | (t_I->uca_BondingDisc[2]<<4)
                                          | (t_I->uca_BondingDisc[3]>>2);
      gt_Bonding_DiscAggr_Status.sa_DiscCode[1] =  (t_I->uca_BondingDisc[3]<<14)
                                          | (t_I->uca_BondingDisc[4]<<8)
                                          | (t_I->uca_BondingDisc[5]<<2)
                                          | (t_I->uca_BondingDisc[6]>>4);
      gt_Bonding_DiscAggr_Status.sa_DiscCode[2] = (t_I->uca_BondingDisc[6]<<12)
                                          | (t_I->uca_BondingDisc[7]<<6)
                                          | (t_I->uca_BondingDisc[8]<<0);
   }
   if (uc_FieldToStore & BONDING_PME_AGGREGATION)
   {
      // PME aggregation command
      gt_Bonding_DiscAggr_Status.sa_PMEAggr_data[0] = (t_I->uca_BondingAggr[0]<<14)
                                             | (t_I->uca_BondingAggr[1]<<8)
                                             | (t_I->uca_BondingAggr[2]<<2)
                                             | (t_I->uca_BondingAggr[3]>>4);
      gt_Bonding_DiscAggr_Status.sa_PMEAggr_data[1] = (t_I->uca_BondingAggr[3]<<12)
                                             | (t_I->uca_BondingAggr[4]<<6)
                                             | (t_I->uca_BondingAggr[5]<<0);
   }
}
#endif   // #ifdef ADSL_BONDING


#undef R_HS_MSG_TX_PREFIX_FLAG
#undef R_HS_MSG_TX_MESSAGE
#undef R_HS_MSG_TX_POSTFIX_FLAG
#undef R_HS_MSG_TX_IDLE_FLAG

#undef TxFlag
#undef InitNextMsgExchange

