/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RQuietEF1TxF.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "RRecovTxF.h"




/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RQuietEF1TxF
 *
 *  Description: Transition state when escape to Fast Retrain is selected as mode
 *  of operation.
 *
 *  Prototype: void RQuietEF1TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount  - (I) # symbol periods in current TX state
 *      gs_TxNextState    - (O) TX state that will begin next symbol period
 *      gs_RxState        - (I) current RX state
 *
 *  Notes: implements state R_QUIET_EF1_TX
 *
 *-------------------------------------------------------------------
 *^^^
 */
void RQuietEF1TxF(void) {

    /* ---- transmit silence ---- */
    if (gl_TxSymbolCount == 0)
   {
        TxToneSetUp(0,0,0);
   }
    /* ---- check for timeout in Rx side ---- */
    if ( gs_RxState == R_C_SILENT1_RX ) {
        gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
   }

#ifdef INCLUDE_FASTRETRAIN_CODE
    /* ---- proceed, if C_Recov is detected ---- */
    if (gs_RxState == R_C_RECOV_RX ) {
        gs_TxNextState = R_RECOV_TX;
      gpF_TxStateFunc = (PtrToFunc)RRecovTxF;

   }
#endif

}   /*  RQuietEF1TxF */




