/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSilent0TxF.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "afe.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "TxTneSt.h"
#include "hndshk_Data.h"
#include "RTonesReqTxF.h"
#include "RTone1TxF.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSilent0TxF
 *
 *  Description:
 *    R_SILENT0_TX is a silent state where no signal is transmitted.
 *    A host command moves the Tx state to R_TONES_REQ_TX. C_TONES from an ATU-C
 *    moves the Tx state to R_TONE1_TX.
 *
 *  Prototype: RSilent0TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount - number of symbold in current Tx state
 *      gs_RxState       - Rx state
 *      gs_TxNextState   - next Tx state
 *      gs_TxOutBuf[]    - time domain samples to transmit. used in TxQuiet().
 *
 *  Notes: implements state R_SILENT0_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RSilent0TxF(void) {

    /* ---- transmit silence ---- */
   if (gl_TxSymbolCount == 0)
   {
      gt_TaskArray[TX_FRAME_START].TimeCriticalTask=TxProcessTones;

      /* enable IFFT and clear TxToneBuf to generate the silent signal  */

      gft_IFFT_On = TRUE;
      TxToneSetUp(0,0,0);
   }

    /* ---- proceed to R_TONE_REQ_TX upon host commands CPE to start ---- */
   if (gs_RxState == R_C_TONES_RX)
   {
      gs_TxNextState = R_TONES_REQ_TX;
      gpF_TxStateFunc = (PtrToFunc)RTonesReqTxF;
   }

    /* ---- if C_Tones is received, move to R_TONE1_TX ---- */
   if ( gs_RxState == R_C_GALF1_RX )
   {
      gs_TxNextState = R_TONE1_TX;
      gpF_TxStateFunc = (PtrToFunc)RTone1TxF;
   }

    /* ---- if silence period has been requested by either ATU-R or ATU-C, ---- */
    /* ---- move to next state after about 1 minute of silence             ---- */
   if ( ( gt_hsc.l_SelectedMode == SILENCE ) && ( gl_TxSymbolCount >= REQUESTED_SILENCE ) ) {
      gt_hsc.l_SelectedMode = NOT_SELECTED; /*  reset */
      gs_TxNextState        = R_TONES_REQ_TX;
      gpF_TxStateFunc = (PtrToFunc)RTonesReqTxF;
   }

    /* ---- if no common mode can be determined,                     ---- */
    /* ---- do nothing until ATU-C or host command invoke handshking ---- */
   if ( gt_hsc.l_SelectedMode == NO_COMMON_MODE ) {
      gt_hsc.l_SelectedMode = NOT_SELECTED; /*  reset */
   }

}   /*  RSilent0TxF */

