/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RTone1TxF.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RTone1TxF.c
//
// History
// 31/05/2010 Nihar :Send "B43" & "J43" activation tones for "AnnexB + AnnexJ" multi mode
//          Grep for Perf_US_ALL_MultiTone_Activation
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
//
// 16/05/2013 Naveen: For Annex J mode or For Annex B+J mode, use only J43 tones for GHS when
//            the GHS carrier set is set for only J43 (i.e. the request is for using only J43 tones)
//            Otherwise, use B43 tones in GHS
//            Grep for XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "RFlag1TxF.h"
#include "memsetbf.h"



DATA_MAP_deILV2_BIS
int16 gs_HSAlignment = 2; /* Tx/Rx alignment obtained from lab measurements. */
DATA_MAP_END//DATA_MAP_deILV2_BIS

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RTone1TxF
 *
 *  Description:
 *    R_Tone1 is transmitted by the ATU-R.
 *    Upon receiving a GLAF character, the Tx will enter R_FLAG1_TX .
 *
 *  Prototype: void RTone1TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]    - (I)frequency domain samples, used in TxMultiTones()
 *      gs_TxAnPrev       - (O) DPSK symbol of the last bit
 *      gs_RxState        - (I) current RX state
 *      gl_TxSymbolCount  - (I) # symbol periods in current TX state
 *      gs_TxNextState    - (O) TX state that will begin next symbol period
 *
 *  Notes: implements state R_TONE1_TX
 *
 *-------------------------------------------------------------------
 *^^^
 */
void RTone1TxF(void) {

    /* ---- if timeout or tone loss in the Rx side, go back to the beginning ---- */
    if ( gs_RxState == R_C_SILENT1_RX ) {
        gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
    }

    /* ---- just write once to TxOutBuf, and leave it being transmitted ---- */
    if ( gl_TxSymbolCount == 0 ) {
        gs_TxSubStateCnt = 0;
      gs_TxAn_Prev = 1;   /*  initialize gs_TxAn_Prev */
      MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*gs_TxFftLength));

   // Perf_US_ALL_MultiTone_Activation (Start)
      // Send UpCarSet so that if Annex B is enabled, we do not send US GHS
      // tones in ISDN band. New Rule:
      // If G992xB (and any combination of other modes) - use US toneset B43
      // and NO other carriers in ISDN band
   // As per new requirement( D.Telecom-/Stefan/Joerg/Sriram): Send the Upstream Carrier Set B43+J43
   // for following set Annex Configurations.
      /**************************************************************************************
      (i) Annex-B + J or (ii) ETSI Annex-C + J or (iii) Annex-B + ETSI Annex-C + J
      **************************************************************************************/

      // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (Start)
      // For Annex J mode or For Annex B+J mode, use only J43 tones for GHS when
   // the GHS carrier set is set for only J43 (i.e. the request is for using only J43 tones)
   // Otherwise, use B43 tones in GHS
   if ((gul_ModeControl & STAT_ConfigMode_AnnexJ_ALL) ||
      ((gul_ModeControl & STAT_ConfigMode_AnnexB_ALL) && (gul_ModeControl & STAT_ConfigMode_AnnexJ_ALL)))
      // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (End)
   {
      //XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start_End)
      if((gs_GhsCarSetCfg & US_GHS_CARRIER_SET_B43_B43C_J43) == US_GHS_CARRIER_SET_J43)
      {
            TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetA43_J43_A43c,
                          NUM_CARRIERS_IN_SET, TX_NEG165DBM);
      }
      else
      {
            TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetB43,
                          NUM_CARRIERS_IN_SET, TX_NEG165DBM);
      }
   }
      else if (gul_ModeControl & STAT_ConfigMode_AnnexB_ALL)
      {
         TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetB43,
                          NUM_CARRIERS_IN_SET, TX_NEG165DBM);
      }
      else  // Annex A/I/J/L/M mode supported, send gsa_UpCarSetA43_J43_A43c
      {
         TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetA43_J43_A43c,
                          NUM_CARRIERS_IN_SET, TX_NEG165DBM);
      }
   // Perf_US_ALL_MultiTone_Activation (End)
    }

    /* ---- if a GALF is received, move to R_FLAG1_TX ---- */
    if (gs_RxNextState == R_C_FLAG1_RX ) {
   /* Delay the transmission of the first octet of FLAG in order to
   align the transmitted octets to the received octets. The Tx and
   Rx octets are aligned so that the echo resulting from a TX bit
   transition lies within the two symbols that the receiver
   discards in the neighborhood of each RX bit transition. This way
   the echo will not affect the symbols that are used to
      demodulate the information. */
      if(gs_TxSubStateCnt++ == gs_HSAlignment)
      {
         gs_TxNextState = R_FLAG1_TX;
         gpF_TxStateFunc = (PtrToFunc)RFlag1TxF;
      }
    }

}   /*  RTone1TxF */

