/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RTonesReqTxF.c
*
*
*------------------------------------------------------------------------
*/
// ******************************************************************
// RTonesReqTxF.c
//
// History
//
// 20/08/2010  Sriram Shastry: CNXT D57 proposes higher DS PCB in C_MSG_PCB in short loops.
//                     Although ASE sends required R_MSG_PCB based on calculation,
//                     D57 always takes the higher one between these two. Therefore,
//                     we got no-connect in TR100A2 fixed rate tests in short loops
//                     with FB noise. The workaround is to retrain and cut Tx power.
//                     This fix will improve the DS rate performance in short loops
//                     as well.
//                     Grep for SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut
//
// 31/05/2010 Nihar :Send "B43" & "J43" activation tones for "AnnexB + AnnexJ" multi mode
//          Grep for Perf_US_ALL_MultiTone_Activation
//
// 08/07/2010  Nihar: Added code to increase DS performance with TI in DMT mode on short loops with strong noise
//                  Use US-PCB starting from G.Hs to reduce DS-PCB
//             grep for  IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB
//
//09/02/2012 Balabath: XTSE-status (STAT 1) must be updated during init/training/showtime according to following table:
//           1. while sending out G.Hs activation tones: (XTSE-status = all G.Hs modes as configured by API, e.g. DMT-Anx-A + BIS-AnxA + PLUS-AnxA + VDSL, NO T1.413)
//          2. while sending out T1.413 activation signal: (XTSE-status = T1.413 mode)
//          3. in G.Hs: (XTSE-status = all G.Hs modes as configured by API, e.g. DMT-Anx-A + BIS-AnxA + PLUS-AnxA + VDSL)
//          4. in ADSL training: (XTSE-status = ADSL mode of current training, i.e. outcome of modeselect in G.HS or T1.413)
//          5. in T1.413 training: (XTSE-status = T1.413 mode)
//          6. in ADSL showtime: (XTSE-status = ADSL mode, same as 4.)
//          7. in T1.413 showtime: (XTSE-status = T1.413 mode)
//          For code changes grep for "XDSLRTFW-415 Enh_all_all_STAT1_update"
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
//
  // 10/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
  //      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
  //      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
  //      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
  //          to avoid US/DS link drop due to polit tone corruption.
  //      (3) Limited US max bits/bin to 8.
  //      The above changes are protected by PLSE CO vendor ID and CMV
  //      info 103 26 0x0800 with default value 0 (Disabled).
  //      Enabling the CMV bit may introduce side-effects for both US and DS performance.
  //      It is only recommended for AT&T profiles with the capped US/DS lower data rates
  //      attached in the Jira entry.
  //         Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
  //
// *********************************************************************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "RSilent1TxF.h"
#include "memsetbf.h"


#ifdef  ISDN  // Only for Annex - B
#define TX_PWR_PLUS_6_DB       (32690)  // tx power boost by 6.0dB
#define TX_PWR_PLUS_5_DB       (29135)  // tx power boost by 5.0dB
#define TX_PWR_PLUS_4_DB       (25967)  // tx power boost by 4.0dB
#define TX_PWR_PLUS_3_DB       (23143)  // tx power boost by 3.0dB
#endif


/*^^^
*------------------------------------------------------------------------
*
*  Name: RTonesReqTxF
*
*  Description:
*     R_Tones_Req is transmitted as an activation request of a
*     G.hs session. When C_Tones is received in response, the Tx state moves
*     to R_Silent1_Tx.
*
*  Prototype: RTonesReqTxF(void);
*
*  Input Arguments: none
*
*  Output Arguments: none
*
*  Returns: none
*
*  Global Variables Used:
*      gl_TxSymbolCount  - number of symbold in current Tx state
*      gs_TxAn_Prev      - phase of previous DPSK symbol
*      gs_RxState        - Rx state
*      gs_TxNextState    - next Tx state
*      gs_TxToneBuf[]    - frequency domain samples, used in TxMultiToneSetUp()
*      gusa_txgain[]     - (I) used for power cutback
*      gus_TxSineGain    - (O) used for powercutback
*     gTxLoadingFunction - loads TxSineGain
*
*  Notes: implements state R_TONES_REQ_TX
*
*------------------------------------------------------------------------
*^^^
*/
//SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (START)
#ifndef ISDN   // Only for Anx-A
//
#define MINUS_HALF_DB        (15467)
#define MINUS_6_DB           (8211)
#define MINUS_3_DB           (11599)
#define MINUS_8_DB           (6523)
#define MINUS_12_DB           (4115)
//SMS00822444 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut (END)
#endif // ifndef ISDN

//SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (END)
void RTonesReqTxF(void) {

   int32 l_temp;
   int i;

   if ( gl_TxSymbolCount == 0 ) {

      gs_TxAn_Prev = 1;

      // gus_TxSineGain = gusa_txgain[gs_UC];
#ifdef  ISDN  // Only for Annex - B
      // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (Start)
      // if we run through these lines for the first time: set the TxGain_NoCutback_default value to the init/cmv-modified gain
      if (gus_TxGain_NoCutBack_default == 0)
      gus_TxGain_NoCutBack_default = gus_TxGain_NoCutBack;
      //During HS Tx Power was cut by the required amount based on the Loop length
      //estimated in RCREV1

      //Tx Power cut back and boost is defined from 0 to 6dB
      //Reduce G.Hs signal (and Reverb) by gs_Persis_CurrGHsTxPCB dB
      gt_INFX_CMV.us_TxPwrCutDMTforDSPCB = gusa_TxPwrCut_Table[gs_Persis_CurrGHsTxPCB];
      //Amount of Tx Power Reduction linked to CMV for Readability
      //The value "x" must be in Q.14 format, i.e 20*log10(x/2^14)
      gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack_default * gt_INFX_CMV.us_TxPwrCutDMTforDSPCB) >> 14);
      // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (End)
      // XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (START)
      // Boost G.hs Tx power by 6dB for ECI/M41/Vinax CO to detect R-TONE1 over 3.8km at DTAG
      if (gft_workaround_ECIM41_VNX == 1)
         gus_TxGain_NoCutBack = (int16) (((int32) gus_TxGain_NoCutBack_default * TX_PWR_PLUS_4_DB) >> 14);
      // XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (END)


#endif // ifdef ISDN

#ifndef  ISDN  // Only for Annex - A
      // if we run through these lines for the first time: set the
      // TxGain_NoCutback_default value to the init/cmv-modified gain
      //ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START)
      //Cutback Tx power by 4 dB to workaround linkdrop issue
      //gus_TxGain_NoCutBack = 5793 for ASE, i.e. 20log(5793/4096) = 3dB
      //20log(3655/5793) = -4dB
      if (gft_workaround_ECI_PLSE == TRUE)
         gus_TxGain_NoCutBack_default = 3655; //3655=5793*0.631
      //ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (END)
      if (gus_TxGain_NoCutBack_default == 0)
      gus_TxGain_NoCutBack_default = gus_TxGain_NoCutBack;
      //Sriram IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (START)
      //CNXT D57 proposes higher DS PCB in C_MSG_PCB in short loops.
      //Although ASE sends required R_MSG_PCB based on calculation,
      //D57 always takes the higher one between these two. Therefore,
      //we got no-connect in TR100A2 fixed rate tests in short loops
      //with FB noise. The workaround is to retrain and cut Tx power if
      //CO is CNXT D57, loop length is <= ~750m

      //We will cut Tx power if the counter is less than 3. The counter
      //will be cleared after passing GHS. If we fail GHS for 3 times, Tx
      //power will be recovered even if the cutpower flag is set.

      else if (gft_shortloop_cutpower_counter < 3)
      {
         switch (gus_shortloop_cutpower)
         {
         case 12:
            gus_TxGain_NoCutBack =
            (int16) (((int32) gus_TxGain_NoCutBack_default * MINUS_12_DB) >> 14);
            gft_shortloop_cutpower_counter ++;
            break;
         case 8:
            gus_TxGain_NoCutBack =
            (int16) (((int32) gus_TxGain_NoCutBack_default * MINUS_8_DB) >> 14);
            gft_shortloop_cutpower_counter ++;
            break;
         case 6:
            gus_TxGain_NoCutBack =
            (int16) (((int32) gus_TxGain_NoCutBack_default * MINUS_6_DB) >> 14);
            gft_shortloop_cutpower_counter ++;
            break;
         case 3:
            gus_TxGain_NoCutBack =
            (int16) (((int32) gus_TxGain_NoCutBack_default * MINUS_3_DB) >> 14);
            gft_shortloop_cutpower_counter ++;
            break;
         default:
            gus_TxGain_NoCutBack =
            (int16) (((int32) gus_TxGain_NoCutBack_default * MINUS_HALF_DB) >> 14);
            gft_shortloop_cutpower_counter = 0;
            break;
         }
      }
      else
      {
         gus_TxGain_NoCutBack =
         (int16) (((int32) gus_TxGain_NoCutBack_default * MINUS_HALF_DB) >> 14);
         gft_shortloop_cutpower_counter = 0;
      }
      //SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (END)
#endif // ifndef ISDN

      gus_TxSineGain = gus_TxGain_NoCutBack;
      for (i=0; i< gs_UC; i++)
      {
         l_temp = (int32)gus_TxSineGain*gus_TxGainCutBackFactor;
         gus_TxSineGain = (int16)(l_temp >>15);
      }

      AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);

   }

   /* ---- inverting phase every 16ms ---- */
   if ( (gl_TxSymbolCount % TIME_16MS) == 0 ) {
      gs_TxAn_Prev = -gs_TxAn_Prev;
      // Note: A43/A43c/J43 have all same Upstream Carrier Sets
      MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*gs_TxFftLength));

      // Perf_US_ALL_MultiTone_Activation (Start)
      // Send UpCarSet so that if Annex B is enabled, we do not send US GHS
      // tones in ISDN band. New Rule:
      // If G992xB (and any combination of other modes) - use US toneset B43
      // and NO other carriers in ISDN band
      // As per new requirement( D.Telecom-/Stefan/Joerg/Sriram): Send the Upstream Carrier Set B43+J43
      // for following set Annex Configurations.
      /**************************************************************************************
      (i) Annex-B + J or (ii) ETSI Annex-C + J or (iii) Annex-B + ETSI Annex-C + J
      ***************************************************************************************/
        // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (Start)
        // For Annex J mode or For Annex B+J mode, use only J43 tones for GHS when
      // the GHS carrier set is set for only J43 (i.e. the request is for using only J43 tones)
      // Otherwise, use B43 tones in GHS
      if ((gul_ModeControl & STAT_ConfigMode_AnnexJ_ALL) ||
         ((gul_ModeControl & STAT_ConfigMode_AnnexB_ALL) && (gul_ModeControl & STAT_ConfigMode_AnnexJ_ALL)))
        // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (End)
      {
         //XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start_End)
         if((gs_GhsCarSetCfg & US_GHS_CARRIER_SET_B43_B43C_J43) == US_GHS_CARRIER_SET_J43)
         {
            TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetA43_J43_A43c,
                        NUM_CARRIERS_IN_SET, (int16) (TX_NEG165DBM * gs_TxAn_Prev) );
         }
         else
         {
            TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetB43,
                        NUM_CARRIERS_IN_SET, (int16) (TX_NEG165DBM * gs_TxAn_Prev) );
         }
      }
      else if (gul_ModeControl & STAT_ConfigMode_AnnexB_ALL)
      {
         TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetB43,
                     NUM_CARRIERS_IN_SET, (int16) (TX_NEG165DBM * gs_TxAn_Prev) );
      }
      else  // Annex A/I/J/L/M mode supported, send gsa_UpCarSetA43_J43_A43c
      {
         TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetA43_J43_A43c,
                     NUM_CARRIERS_IN_SET, (int16) (TX_NEG165DBM * gs_TxAn_Prev) );
      }
      // Perf_US_ALL_MultiTone_Activation (End)
   }

   /* ---- if timeout in the Rx side, go back to the beginning ---- */
   if ( gs_RxState == R_C_SILENT1_RX ) {
      gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
   }

   /* ---- if C_Tones is received, move to R_SILENT1_TX ---- */
   if ( gs_RxState == R_C_GALF1_RX ) {
      gs_TxNextState = R_SILENT1_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent1TxF;
   }

}   /*  RTonesReqTxF */

