/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: SetPgaForToneDetection.c
*
*-------------------------------------------------------------------------------
*/

#include "typedef.h"
#include "gdata.h"
#include "hndshk_Data.h"
#include "afe.h"
#include "fifo.h"
#include "memcopy.h"
#include "pga_set.h"
#include "platform.h"
#include "cmv.h"
#include "SetPgaForToneDetection.h"
#include "hndshk_Data.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"



 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name : BgCheckMaxFreqDomain()
 *
 * Description: Find max magnitude of any freq domain
 *          value during one frame(real or imag).
 *               It also detects if the loop is echo dominant.
 *
 *
 *  Prototype:   void BgCheckMaxFreqDomain();
 *
 *  Input Arguments: none
 *       -
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gsa_RxToneBuf_sav[i]
 *      gs_MaxFreqDomainValue
 *    guc_PgaState
 *
 *------------------------------------------------------------------------
 *^^^
 */


C_SCOPE void BgCheckMaxFreqDomain(void)
{
  int16 s_min_pga = 0;
  int16 i; /*** setting it to int causes problem and modem gets stuck in handshake ***/
  int16 s_maxvalue, s_value, *psa_Tone;

  gs_MaxFreqDomainValue = 0;
  s_maxvalue = 0;

/* Exclude the DC component */
  psa_Tone = gpsa_RxToneBuf_sav + 2;

  for (i=2; i<(gs_RxNumTones<<1); i++)
  {
   s_value = *psa_Tone++;

   if(s_value < 0)
      s_value = -s_value;

   if(s_maxvalue < s_value)
      s_maxvalue = s_value;
  }

#if 0
  /* Calculate the power at the third US handshake tone */
  l_pwr = (int32)gpsa_RxToneBuf_sav[2*gsa_UpCarSet[2]]*gpsa_RxToneBuf_sav[2*gsa_UpCarSet[2]]
                 + (int32)gpsa_RxToneBuf_sav[2*gsa_UpCarSet[2]+1]*gpsa_RxToneBuf_sav[2*gsa_UpCarSet[2]+1];
#endif

  /* The current threshold gl_Ghs_ReferencePower_EchoLoop */
  /* was captured for non-ISDN mode */
  //if (l_pwr > gl_Ghs_ReferencePower_EchoLoop)
  //  gft_EchoLoop = TRUE;
  gft_EchoLoop = FALSE; //Turn this off for now since it isnt fully understood

  gs_MaxFreqDomainValue = s_maxvalue;
  guc_PgaState = TRAINING_DONE;

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : BgStepDownPga()
 *
 * Description:
 *    Steps down the Rx path gain by an amount as specified by variable
 *    gs_pgaStepDownValue(<=6dB). Note that the calling function needs to do
 *    the following:
 *    - Set gs_pgaStepDownValue and reset guc_PgaState to TRAINING_IN_PROGRESS.
 *    - The calling function needs to wait until the flag guc_PgaState is set to
 *    TRAINING_DONE + one additional DMT symbol for loading functions to execute
 *
 *    Note: Step down should be <= 6dB, in steps of 1 dB
 *
 *    Note: This pga step down helper routine has the capability to Step up the pga
 *    value as well by specifying a negative value to gs_pgaStepDownValue variable.
 *    However, the step up functionality is not used in modem code currently, and is
 *    neither fully implemented (ie. does not increase tdq exponent after hitting max pga)
 *    nor fully tested.
 *
 *  Prototype:
 *       void BgStepDownPga();
 *
 *  Input Arguments: gs_pgaStepDownValue in Q8.8 format
 *       -
 *  Output Arguments: none
 *
 *  Return: none
 *
 *
 *  Global Variables Used:
 *       gus_GhsPgaSetDown
 *       gs_PGA_required
 *       gft_EagleAfe_UseHighFreqBoost - Eagle AFE only
 *      guc_PgaState
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void BgStepDownPga(void)
{
   gs_PGA_required = gs_PGA_set - gs_pgaStepDownValue;



   /* If required PGA is smaller than min_pga, adjust the exponent of TDQ */
    if(gs_PGA_required < gs_min_pga_setting)
   {
      if(gs_pre_tdq_h_exp < UPPERBOUND_TDQEXP)
   {
      gs_pre_tdq_h_exp++;  /* Cutbacks using TDQ exponents are in 6.02 dB steps */
      gs_PGA_required += 0x0605; /* account for the additional tdq cutback by increasing pga */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
   }
   }

   AFED_BgPGA();
    AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
    guc_PgaState = TRAINING_DONE;
}

 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name : SetPgaForToneDetection
 *
 * Description: Check PGA level and incrementally reduce it in the
 *               background while trying to detect C-TONES.
 *
 *  Prototype:
 *       void SetPgaForToneDetection();
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *
 *  Global Variables Used:
 *       gsa_RxToneBuf_save
 *       gs_MaxFreqDomainValue
 *      guc_PgaState
 *       gs_SetPgaForTones_State
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void SetPgaForToneDetection(void)
{
   static s_Wait2_Cnt;

   switch (gs_SetPgaForTones_State)
   {

   case SETPGATONES_CHECKLEVEL:
      MemCopyWords(gpsa_RxToneBuf_sav, 0, gsa_RxToneBuf, 0, (int16)(2*gs_RxNumTones));
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgCheckMaxFreqDomain);
      guc_PgaState = TRAINING_IN_PROGRESS;
      gs_SetPgaForTones_State = SETPGATONES_WAIT1;
      break;

   case SETPGATONES_WAIT1:
      // Wait for background task to complete.
         if (guc_PgaState == TRAINING_DONE)
         {
            // If magnitude is too high, step down the PGA;
            if (gs_MaxFreqDomainValue > GHS_MAX_FREQ_DOMAIN_VALUE_REF)
            {
            if (gs_MaxFreqDomainValue > 30000) {      // Danger: hacked in.(TNT)
               gs_pgaStepDownValue = 0x0c00;
//             gus_GhsPgaSetDown += 2;
            }
            else if (gs_MaxFreqDomainValue > 2*GHS_MAX_FREQ_DOMAIN_VALUE_REF) {
               gs_pgaStepDownValue = 0x0600;
//             gus_GhsPgaSetDown += 2;
            }

            else {
               gs_pgaStepDownValue = 0x0300;
//             gus_GhsPgaSetDown++;
            }
            gs_SetPgaForTones_State = SETPGATONES_STEPDOWN;
         }
         else
            gs_SetPgaForTones_State = SETPGATONES_LEVEL_OK;
      }
      break;

   case SETPGATONES_STEPDOWN:

      // 1. Start background task that decreases the PGA.
      guc_PgaState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgStepDownPga); // Resets PGA in background.
      gs_SetPgaForTones_State = SETPGATONES_WAIT2;
      s_Wait2_Cnt = 0;
      break;

   case SETPGATONES_WAIT2:
      // Wait for background task to complete and for PGA change to propagate to Rx tone buffer.
      s_Wait2_Cnt++;
      if ((guc_PgaState == TRAINING_DONE) && (s_Wait2_Cnt > 2))
         gs_SetPgaForTones_State = SETPGATONES_CHECKLEVEL;
      break;

   case SETPGATONES_LEVEL_OK:
      gs_SetPgaForTones_State = SETPGATONES_CHECKLEVEL;
      break;
   }

}
