/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
// *****************************************************************************
// SetSelectedMode.c
//
// History
//
//09/02/2012 Balabath: XTSE-status (STAT 1) must be updated during init/training/showtime according to following table:
//           1. while sending out G.Hs activation tones: (XTSE-status = all G.Hs modes as configured by API, e.g. DMT-Anx-A + BIS-AnxA + PLUS-AnxA + VDSL, NO T1.413)
//          2. while sending out T1.413 activation signal: (XTSE-status = T1.413 mode)
//          3. in G.Hs: (XTSE-status = all G.Hs modes as configured by API, e.g. DMT-Anx-A + BIS-AnxA + PLUS-AnxA + VDSL)
//          4. in ADSL training: (XTSE-status = ADSL mode of current training, i.e. outcome of modeselect in G.HS or T1.413)
//          5. in T1.413 training: (XTSE-status = T1.413 mode)
//          6. in ADSL showtime: (XTSE-status = ADSL mode, same as 4.)
//          7. in T1.413 showtime: (XTSE-status = T1.413 mode)
//          For code changes grep for "XDSLRTFW-415 Enh_all_all_STAT1_update"
//
// *****************************************************************************
#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#include "RQuietEF1TxF.h"
#include "RQuietTxF_bis.h"
#include "RQuiet2TxF.h"
#include "const.h"
#include "gdata_bis.h"

#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "RCQuietRxF_BIS.h"
#include "RCQuiet2RxF.h"




/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: SetSelectedModeAnnex
 *
 *  Description:
 *    Populate f/w variable with selected mode and annex
 *
 *  Prototype: void SetSelectedModeAnnex(int32);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *
 *-------------------------------------------------------------------
 *^^^
 */
void SetSelectedModeAnnex(int32 l_SelectedMode)
{
   InfoField_t *pt_MS_Info;

   // We only need to save one BIS info depends on who selects the mode, either Tx or Rx
   if(gpt_TxInfo->uc_Type == M_MS)
      pt_MS_Info = gpt_TxInfo;

   else if(gpt_RxInfo->uc_Type == M_MS)
      pt_MS_Info = gpt_RxInfo;

    if (l_SelectedMode & HS_CHECK_2ND_32BITS){
        //We are using the input "l_SelectedMode" as the second
        //32bits variable
      if((l_SelectedMode & G992_5_M))
      {
         STATArray[STAT_Mode1] |= STAT_ConfigMode_G992_5_M;
         gl_SelectedMode = MODE_G992_5 | ANNEX_M;
#ifdef ENABLE_ALL_HDLC_OVHD
         memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9923xInfo[G992_5_ANNEX_M], sizeof(Adsl2AllInfo_t));
#endif
      }
    }
    else{//l_SelectedMode & HS_CHECK_2ND_32BITS
    //we are using "l_SelectedMode" as the first 32 bits variable.

#ifndef ISDN

   if(l_SelectedMode & G992_1_A)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_1_A;
      gl_SelectedMode = MODE_G992_1 | ANNEX_A;
   }
#else

   if(l_SelectedMode & G992_1_B)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_1_B;
      gl_SelectedMode = MODE_G992_1 | ANNEX_B;
   }

#endif

   if(l_SelectedMode & G992_2_AB)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_2_AB;
      gl_SelectedMode = MODE_G992_2 | ANNEX_A ;
   }

#ifndef ISDN

   if(l_SelectedMode & G992_3_A)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_3_A;
      gl_SelectedMode = MODE_G992_3 | ANNEX_A;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_A], sizeof(Adsl2AllInfo_t));
#endif
   }
   if(l_SelectedMode & G992_3_I)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_3_I;
      gl_SelectedMode = MODE_G992_3 | ANNEX_I;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_I], sizeof(Adsl2AllInfo_t));
#endif
   }
   if (l_SelectedMode & G992_3_L)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_3_L;
      gl_SelectedMode = MODE_G992_3 | ANNEX_L;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_A], sizeof(Adsl2AllInfo_t));
#endif
   }

#else

   if(l_SelectedMode & G992_3_B)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_3_B;
      gl_SelectedMode = MODE_G992_3 | ANNEX_B;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_B], sizeof(Adsl2AllInfo_t));
#endif
   }
   if(l_SelectedMode & G992_3_J)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_3_J;
      gl_SelectedMode = MODE_G992_3 | ANNEX_J;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_J], sizeof(Adsl2AllInfo_t));
#endif
   }

#endif//ISDN



   if(l_SelectedMode & G992_3_M)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_3_M;
      gl_SelectedMode = MODE_G992_3 | ANNEX_M;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9923xInfo[G992_3_ANNEX_M], sizeof(Adsl2AllInfo_t));
#endif
   }

#ifndef ISDN
   if(l_SelectedMode & G992_5_A)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_5_A;
      gl_SelectedMode = MODE_G992_5 | ANNEX_A;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9925xInfo[G992_5_ANNEX_A], sizeof(Adsl2AllInfo_t));
#endif
   }
   if(l_SelectedMode & G992_5_I)
   {
      STATArray[STAT_Mode1] |= STAT_ConfigMode_G992_5_I;
      gl_SelectedMode = MODE_G992_5 | ANNEX_I;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9925xInfo[G992_5_ANNEX_I], sizeof(Adsl2AllInfo_t));
#endif
   }

#else

   if(l_SelectedMode & G992_5_B)
   {
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_5_B;
      gl_SelectedMode = MODE_G992_5 | ANNEX_B;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9925xInfo[G992_5_ANNEX_B], sizeof(Adsl2AllInfo_t));
#endif
   }

   if(l_SelectedMode & G992_5_J)
   {
      STATArray[STAT_Mode1] |= STAT_ConfigMode_G992_5_J;
      gl_SelectedMode = MODE_G992_5 | ANNEX_J;
#ifdef ENABLE_ALL_HDLC_OVHD
      memcpy(&gt_BisInfoSave, pt_MS_Info->pta_G9925xInfo[G992_5_ANNEX_J], sizeof(Adsl2AllInfo_t));
#endif
   }

#endif //ISDN



    }//l_SelectedMode & HS_CHECK_2ND_32BITS
   //XDSLRTFW-2191(Start_End)
   gl_ADSL_Annex_Mode = gl_SelectedMode;
// set STAT_MACRO State after MODE has been set
   if (gft_FlagDiagMode)
   {
      STATArray[STAT_MacroState] = STAT_LoopDiagMode;
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_LoopDiagMode;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_DIAG_MODE;
      gl_SelectedMode |= LINK_DIAG;
      gft_FlagDiagMode = FALSE;
   }
   else
   {
      STATArray[STAT_MacroState] = STAT_FullInitState;
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_FullInitState;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_FULL_INIT;
   }

   if (gl_SelectedMode & MODE_ADSL1)
      gft_ModemType = G_DMT;
   else {
      gft_ModemType = G_DMT_BIS;
      //XDSLRTFW-1815 : DS CRCs and drop from showtime
      //IKNS CO4 doesn't support 1 bit loading, workaround is to change to 2
      if ( (gs_CurrentCoChipset == IKNS_CO_CHIPSET) &&
         (gt_INFX_CMV.us_OperatorSpBits7 & CMV_TO_ENABLE_IKNS_CO4_FIX) )
      {
         gs_RxMinBitsPerTone_BIS_TCM = RX_MIN_BITS_PER_TONE;
      }
      //XDSLRTFW-1815 : DS CRCs and drop from showtime
   }
}
