/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hndshk.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// hndshk.c
//
// History
//
// 31/7/2010 Nihar: It was seen at FT that the CNXT D57 Dslam was configured to INP = 2.0 but it was only sending
//             this INP in the CL message and not the MS message. Since we use the MS message,
//              we were always training at INP=0.
//              By default, this fix is enabled. To disable it reset bit 8 of INFO 103 1
//              Grep for IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading
//
// 05/08/2010 Nihar : Indicated the support for erasure decoding reporting capability in CLR Msg.
//             Also set the variable during MS Message if CO ( CL Msg.) has also indicate the Capability
//             of erasure decoding reporting and INP support.
//       Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 10/08/2010 Hanyu/bhadra : Enabled RS coding for INP=0/Delay=2ms against CNXT D57 and E67
//                    FW to get higher DS rate in TR-100 test. By default, its enabled.
//                   To disable this, cw INFO 103 0 0x0080 (which in turn forces the no. of
//                   check bytes equal to 0 if delay <= 2ms)
//                   Grep for SMS00768526 IOP_DS_BisPlus_CNXT_D57E67_RS_INP0DELAY2MS
//
// 10/08/2010 Nihar/Bhadra: Against CNXT E67 firmware, it was found that min 1/S0
//          value should be <= 3,if minINP < 1, otherwise we see CRCs/FECs on short loops.
//          Also if Max Delay is less than (or equal)to 2ms,Force Reed solomon to Zero.
//          By default, this fix is enabled, but can be disabled by cw INFO 103 0 0x0080.
//          This fix gets rid of CRC/FECs on low-delay profile against CNXT,
//          but it also costs us performance. The CRCs were seen on Munich setup against E67
//          but not in Milpitas setup.
//          On disabling this fix, the previous fix wherein the min-delay is forced to 3ms
//          if the min-delay in configured = 2ms against CNXT.
//          This is probably a bug on the CO side.
//          Grep for IOP_DS_BisPlus_CNXT_FramingLimitation
//
// 20/8/2010 Sriram Shastry : Moved SelectMode() from Handshake Page 1 to handshake Page 2
//          to free up program  memory in handshake page 1
//
// 20/08/2010 Sriram Shastry : PrepareCLR_Bis () from Handshake Page 1 to
//   handshake Page 2 to free up program  memory in handshake page 1
//
// 20/08/2010 Sriram Shastry: Fix for disabling the detection of B43 and J43 carrier set with OPTN 25, bitmask 0x4000.
//    By default, this cmv bit is ONE(enable the detection). Besides the fix, in addition to the B43 detection in C-TONES,
//    which is based on power difference between B43 tones and its neighboring tones, we also use B43
//    carrier set to decode C-GLAF1 and C-FLAG1 to double confirm if B43 tones are really transmitted from CO site.
//    Only if B43 carrier set are detected in C-TONES, and C-GLAF1 and C-FLAG1 are correctly decoded, then we think
//    B43 are really transmitted from CO site. It also means CO may support AnnexM mode.
//    Grep for SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection
//
//  29/09/2010 Nihar: Prevent VDSL FW to start if AFE register is fused to a defined value.
//                          This is a way to use the VR9 as AR10 till the time AR10 is officially available.
//                      Grep for XDSLRTFW-178
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
//
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// 30/12/2011 Sriram Shastry : Indicate VDSL2 annex bit and the corresponding Full CLR code points in handshake  during Full CLR message.
//    Grep for  XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg
//
// 03/02/2012 Sriram Shastry : Send the VDSL Code points in Short CLR message with full transmit capability.
//    Grep for  Enhc_AB_ALL_ALL_ALL_VDSL_HSK_InADSLShortCLR_Msg
//
// 13/03/2012 Sriram Shastry : Bug fix to avoid no link against Broadcom CO in ADSL1 mode.
// 1.R-CLR  : CLR message has ADSL1,ADSL2,ADSL2p and VDSL2 Mode ( NPAR2,SPAR2,NPAR3)
// 2.O-CL has only G.dmt Annex support
// 3.R-CLR(Segment), CLR message has ADSL1 ( NPAR2,SPAR2 & NPAR3) Octets i.e. CPE functions as G.DMT only
//    Grep for XDSLRTFW-426 IOP_ALL_ADSL1_BDCM_TxADSL1Octets_VDSLHSK
//
// 13/03/2012 Sriram Shastry : Bug fix to avoid no link against Broadcom CO in ADSL1 mode.
//       1.R-CLR  : CLR message has ADSL1,ADSL2,ADSL2p and VDSL2 Mode ( NPAR2,SPAR2,NPAR3)
//      2.O-CL: has only G.dmt Annex support
//      3.R-CLR(Segment): CLR message has ADSL1 ( NPAR2,SPAR2 & NPAR3) Octets, ADSL2 ( NPAR2,SPAR2 & NPAR3) Octets, ADSL2p ( NPAR2,SPAR2 & NPAR3)
//       Octets i.e. CPE functions as Multimode but No VDSL2 Annex mode bit.
//    Grep for XDSLRTFW-426 IOP_ALL_ADSL1_BDCM_TxADSL1_ADSL2_ADSL2p_Octets_VDSLHSK
//
// 13/03/2012 Kannan: 06/04/2010 Bhadra: Added code for universal ReTx(G.inp section A.2.2) as per Amd5 of G.HS.
//                Code was added under the CMV info 110 0 (0x100) =>CMV_BIT_INDICATE_RETX
//                    Grep for SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod to see changes.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasure decoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 18/06/2014 Prashant:
//          1. At Function "SelectMode_Bis" for "switch(guca_temp_Spar2_Octet2 & 0x30)" case 0xff will never occur so,
///            this is cleaned-up
//             No Grep Pattern is used (Jira: XDSLRTFW-971)
//
// 06/02/2015 Vinay : Added CMV DSL 0 Bit#3 (Mask:0x0008) to enable octet 2 of NPar2 of G993.2 in GHs and is enabled by default
//                    Grep for XDSLRTFW-1624
//
// 14/04/2014 Hanyu: Ported ADSLRTFW-1391: Ciena CNX5 doesn't support Sp=1/4 and drops link
//            right after Showtime. We have to disable Sp=1/4 for Catena/Ciena
//            CO vendor ID (CTNW) in our FW. As a result, the max DS data rate
//            is limited to ~24Mbps.
//            Grep for XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_OneOverS_Limitation
//
// 12/10/2015 Vinay: Added code to support G.Fast in ADSL G.Hs session.
//            Grep for XDSLRTFW-2298
//
// 13/1/2017 Shriram Shastry : The CPE could not link up in G.DMT mode with 4.17.18.7 UGW7.1.1 [PPA API driver info: 96.32.7.3.0.0.4]
//          When  FW makes transition from VDSL to ADSL and CO is configued in ADSL1 Mode,
//          FW is 'NOT' communicating the required TC-Mode and  autonomous message to DSL API. Moved the  function call common for  all hndshk mode and T1413.
//          Simplified the  implementation. Moved  Bonding  exception out of  for  loop.
//          Grep for XDSLRTFW-3068
//
// 05/10/2017 Abu Rahman
//            XDSLRTFW-3546: ADSLx AnxB mode: Ghs session start declaration at wrong place
//            C-GALF message (value 0x81) is the first definitive message transmitted by CO in Ghs Session. If CPE successfully
//            decodes the C-GALF signal, there is more likelihood that CO starts it Ghs session. Declare start of Ghs session
//            through "stat 0 0" CMV after successful decoding of C-FLAG message.
//            This declaration is now common across all ADSL annexes.
//            Grep for XDSLRTFW-3546
// ******************************************************************
#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#include "ppe_memmap.h"
#include "LL_IOf.h"
#include "str_memmap.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "hndshk2.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "gdata_bis.h"
#include "RCFlag1RxF.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


extern HS_Encode_ADSL2_t   gta_HS_ADSL2[];
extern FlagT gft_StopTssiInClr;
extern void PrepareCLR_Bis(Adsl2AllInfo_t *pt_BisInfo, uint8 s_annex, FlagT ft_BisOrPlus);

/* ============================================*/
/* static variable declarations */
/* ============================================*/
DATA_MAP_deILV2_BIS
int16 gs_ReAlignSubState;                             /*  substate variable */
int16 gs_RxSymCnt;                                       /*  RX symbol count */
FlagT gft_SymbolReAlignRequired = FALSE;                    /*  flag indicating symbol re-alignment is required */
int16 gs_TxOctetCnt = 0;                                 /*  counts number of octets in a given TxSubState */
int16 gs_RxOctetCnt = 0;                                 /*  counts number of octets in a given RxSubState */
uint8 guc_RxGalfCnt = 0;   // counts the number of C_GALF2 octets
DATA_MAP_END//DATA_MAP_deILV2_BIS

int16 TestPhaseTransition(int16 s_SubBit);
int16 MapInputtoINPConst(int16 s_inputMinINP);

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: PrepareCLR
 *
 *  Abstract: Sets up parameters for a CLR
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */

void PrepareCLR(void)
{
    int i, j;
    HS_Encode_ADSL2_t *pt;
    Adsl2AllInfo_t *pt1;

// Not removed for now, This Code can be still used to force ADSL1 mode
#if 0//ndef ISDN
    // XDSLRTFW-2033
    //Act like a ADSL1 modem.
      if((gft_preferredADLS1Mode == TRUE) &&(gs_hsk_tone_power_dB < 1100)) // very long loops(17.5kft) BT  500-700 seen
      {
         gul_ModeControl &= ~STAT_ConfigMode_ADSL2_ALL;
         gft_ModemType = G_DMT;
         //gft_SendShortCLR = FALSE; // done inside the below fn
         InitializeInfoField( gpt_TxInfo );
      }
      else if(gft_preferredADLS2Mode == TRUE)
      {
         gul_ModeControl &= (~ OPTN_ConfigMode_G992_3_L);
      }

#endif

    gpt_TxInfo->uc_Type = M_CLR;
    gpt_TxInfo->uc_ID_NPar1 = 0;  /*  no parameters set */

    /* ---- net data rate and data flow characteristic   ---- */
    gpt_TxInfo->uc_ID_SPar1[0] = 0 ;      // the previous ones had zero values at ID_Npar2: //NDR_UP | NDR_DN | DFC_UP | DFC_DN;
   // XDSLRTFW-426 IOP_ALL_ADSL1_BDCM_TxADSL1Octets_VDSLHSK(Start_End)
   uint8 uc_SI_SPar1_ORed;

    /* ----- relative power characteristics ---- */
    /* Not transmitted, since they are zero (nominal level).  If non-zero values are populated
     * in cnfgmult.h and InitializeInfoField(), then set the appropriate bits here */
    gpt_TxInfo->uc_ID_SPar1[1] = 0;



#ifdef ADSL_BONDING
   // Revisit this section(Handle with care) it is disabling the some of the octets
   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (Start)
   if (gt_Bonding_DiscAggr_Control.s_PCS_control & 0x1)
   {
      // XDSLRTFW-3548 (Start)
      STATArray[STAT_MacroState] = STAT_BondingCLR;
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_BondingCLR;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_BONDING_CLR;
      // XDSLRTFW-3548 (End)
      PrepareCLR_BONDING();
   }
   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (End)
#endif

   gpt_TxInfo->uc_ID_SPar1[3] = 0;

    /* ---- Standard Information parameters ---- */
    gpt_TxInfo->uc_SI_NPar1 = SILENT_PERIOD;  /*  needs to be set in a CLR message */
#ifndef ISDN
    if (gft_disableAnnexL == 1)
   {
      gul_ModeControl &= (~ OPTN_ConfigMode_G992_3_L);
   }

    if (gpt_TxInfo->uc_SI_SPar1[0] & G992_1_A)
    {

        gpt_TxInfo->uc_SI_1A_SPar2  = SUBCH_INFO ;
        // We don't send (SPECTRUM_UP|SPECTRUM_DN), because we need common settings for all COs and Centillium chokes on them

        gpt_TxInfo->uc_SI_1A_NPar2  = R_ACK1 | R_ACK2 | CLEAR_EOC_G997_1;

        if ( (OPTNArray[OPTN_DMTLinkControl] & OPTN_ATM_TransferMode) != 0)
            gpt_TxInfo->uc_SI_1A_NPar2    |=  ATM;
        else if( (OPTNArray[OPTN_DMTLinkControl] & OPTN_STM_TransferMode) != 0)
            gpt_TxInfo->uc_SI_1A_NPar2    |=  STM;
        else
            gpt_TxInfo->uc_SI_1A_NPar2    |=  ATM; /* default is ATM */

        gpt_TxInfo->uc_1A_SubChan1 =  guc_DS_BearerChannels;
        gpt_TxInfo->uc_1A_SubChan2 =  guc_US_BearerChannels;


    }
#else
    if (gpt_TxInfo->uc_SI_SPar1[0] & G992_1_B)
    {
        gpt_TxInfo->uc_SI_1B_SPar2  = SUBCH_INFO | SPECTRUM_UP | SPECTRUM_DN;

        gpt_TxInfo->uc_SI_1B_NPar2  = R_ACK1 | R_ACK2 | UPSTREAM_1_32_DMT | CLEAR_EOC_G997_1;

        if ( (OPTNArray[OPTN_DMTLinkControl] & OPTN_ATM_TransferMode) != 0)
            gpt_TxInfo->uc_SI_1B_NPar2    |=  ATM;
        else if( (OPTNArray[OPTN_DMTLinkControl] & OPTN_STM_TransferMode) != 0)
            gpt_TxInfo->uc_SI_1B_NPar2    |=  STM;
        else
            gpt_TxInfo->uc_SI_1B_NPar2    |=  ATM; /* default is ATM */
        gpt_TxInfo->uc_1B_SubChan1 =  guc_DS_BearerChannels;
        gpt_TxInfo->uc_1B_SubChan2 =  guc_US_BearerChannels;
    }
#endif//ISDN

   // XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(Start_End)
   // Below code routine has been moved to Cache for program memory optimization( To File hs_mesg.c)
   GLite_PrepareCLR();
#if 0
    if (gpt_TxInfo->uc_SI_SPar1[0] & G992_2_AB)
    {
        gpt_TxInfo->uc_SI_2AB_SPar2 = SPECTRUM_UP | SPECTRUM_DN;

#ifdef INCLUDE_FASTRETRAIN_CODE
        gpt_TxInfo->uc_SI_2AB_NPar2  = R_ACK1 | R_ACK2 | FAST_RETRAIN | CLEAR_EOC_G997_1;
#else
        gpt_TxInfo->uc_SI_2AB_NPar2  = R_ACK1 | R_ACK2 | CLEAR_EOC_G997_1;
#endif

        if ((OPTNArray[OPTN_DMTLinkControl] & OPTN_RS16Support_Disable) == 0)
            gpt_TxInfo->uc_SI_2AB_NPar2    |=  RS16;
        else
            gpt_TxInfo->uc_SI_2AB_NPar2    &=  ~RS16;

    }
#endif
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(End)
    /* ============================================*/
    /* Prepare BIS Capabilities */
    /* ============================================*/
    pt = gta_HS_ADSL2;
    for (i=0 ; i<NUM_KNOWN_ADSL2_SPAR1_BITS ; i++)
    {
        if (gpt_TxInfo->uc_SI_SPar1[pt->SI_SPar1_idx] & pt->SI_Spar1_anx_bit)
        {
            if (pt->bis_plus == 0) //BIS mode
            {
                pt1 = gpt_TxInfo->pta_G9923xInfo[pt->anx];
                j = 0;
            }
            else //PLUS mode
            {
                pt1 = gpt_TxInfo->pta_G9925xInfo[pt->anx];
                j = 1;
            }
            PrepareCLR_Bis(pt1, pt->anx, (FlagT)j);
        }
        pt++;
    }//i
    //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(start)
#ifdef HERC_API
    // XDSLRTFW-178 (Start_End)
    if (gft_NoVDSLIndication == 0)
    {
        if(OPTNArray[OPTN_AlgControl3] & CMV_TO_SEND_VDSL_MODES_IN_SHORT_CLR)
        {
            /* ============================================*/
            /* Prepare VDSL Capabilities */
            /* ============================================*/
            if ((gpt_TxInfo->uc_SI_SPar1[1] & (uint8)(T1_MCM_VDSL >> 8)) || (gpt_TxInfo->uc_SI_SPar1[4] & G993_1_ANSI_T1_424))
                gpt_TxInfo->uc_SI_G993_1_NPar2 = 0;// G9931_OPTUP | G9931_OPTDOWN | G9931_PSDRED | G9931_PTM | G9931_ATM | G9931_CLEAREOC;

            if (gpt_TxInfo->uc_SI_SPar1[4] & G993_2)
            {
                gpt_TxInfo->uc_SI_G993_2_NPar2_01 = 0; // G9932_ALL_DIGITAL | G9932_DS_VIRT_NOISE | G9932_LINEPROBE | G9932_LOOPDIAG;
                //XDSLRTFW-1624(START_END)
                gpt_TxInfo->uc_SI_G993_2_NPar2_02 =0; // G9935_FRIENDLY |AELEM | RESERVED |
            }
        }
    }

    //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(End)

// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(Start)
// Enhc_AB_ALL_ALL_ALL_VDSL_HSK_InADSLShortCLR_Msg(Start_End)
// Below code is added to append G.993.2 Annex-Bit in the Full VDSL Message.i.e. us_SI_Spar1[4] has VDSL2 support
// Send VDSL2 Annex-bit in the Short CLR message only
   if( ((OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_G993_2) != 0) &&(gft_SendShortCLR == TRUE))
   {
      gpt_TxInfo->uc_SI_SPar1[4] |= G993_2;
   }
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(End)

   // SPar1 Octet 5: G9701
   if (OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_G9701)
   {
      gpt_TxInfo->uc_SI_SPar1[4] |= G9701;   // Set to G.9701
   }

   //XDSLRTFW-426 IOP_ALL_ADSL1_BDCM_TxADSL1Octets_VDSLHSK(Start)
   // VR9 FW 5.4.4.3.1.1
#ifdef FORCE_ADSL1_BRCMCO
   if ((gft_SendShortCLR == FALSE)&&(gs_CurrentCoChipset==BDCM_CO_CHIPSET)&& (gpt_TxInfo->uc_SI_SPar1[4] & G993_2)){

      for (i=2, uc_SI_SPar1_ORed=0 ; i<NUM_SI_SPAR1_OCTETS; i++) {   // See CO's ADSL2 and ADSL2p mode octets
         uc_SI_SPar1_ORed |= gpt_RxInfo->uc_SI_SPar1[i] ;
      }
      if (uc_SI_SPar1_ORed==0)
      {
         gul_ModeControl &= (STAT_ConfigMode_G992_1_ALL|STAT_ConfigMode_G992_2_ALL) ;
         for (i=2 ; i<NUM_SI_SPAR1_OCTETS ; i++) {
         gpt_TxInfo->uc_SI_SPar1[i] = 0 ;       // Force CPE to ADSL1 mode
         }
      }
   }
#else
      // XDSLRTFW-426 IOP_ALL_ADSL1_BDCM_TxADSL1Octets_VDSLHSK(End)
      // IOP_ALL_ADSL1_BDCM_TxADSL1_ADSL2_ADSL2p_Octets_VDSLHSK(Start)
      // VR9 FW 5.4.4.4.1.1

      //XDSLRTFW-1983
      //Issue with BRCM version 0x939B - workaround
      // If this Flag is carrying some garbage, reset to 0
       if (gft_ATM_PTM_MisMatch_TTNet != 1)
      gft_ATM_PTM_MisMatch_TTNet = 0;

      //gft_DisableVDSL2InCLR = 0;
      //In VDSL2 training we see VDSL-ATM. As Not supported for TTNET
      //We switch to ADSL binary with Switching error code in VDSL
      //As we switch to ADSL Binary, VDSL2 code point is removed from Short & Full CLR
      //to get stable connection in ADSL
      if ( ((gft_ATM_PTM_MisMatch_TTNet == 1) && (gpt_TxInfo->uc_SI_SPar1[4] & G993_2)) ||
         ((gft_SendShortCLR == FALSE) &&
         (gs_CurrentCoChipset==BDCM_CO_CHIPSET) && (gpt_TxInfo->uc_SI_SPar1[4] & G993_2)) )
      {

      for (i=2, uc_SI_SPar1_ORed=0 ; i<NUM_SI_SPAR1_OCTETS; i++) {   // See CO's ADSL2 and ADSL2p mode octets
         uc_SI_SPar1_ORed |= gpt_RxInfo->uc_SI_SPar1[i] ;
      }
      if (uc_SI_SPar1_ORed==0)
      {
         for (i=2 ; i<NUM_SI_SPAR1_OCTETS ; i++) {
         gpt_TxInfo->uc_SI_SPar1[4] &= ~(G993_2) ;       // Force CPE to ADSL2,ADSL2p modebut exclude VDSL2 code Annex mode
         }
             //A Global Variable to check disabling VDSL2 in CLR ADSL
         gft_DisabledVDSL2InCLR = 1;
      }
      }
   // IOP_ALL_ADSL1_BDCM_TxADSL1_ADSL2_ADSL2p_Octets_VDSLHSK(End)
#endif

   // XDSLRTFW-2298 (Start)
   //===== Spar1 Octet 5: G.993.2 VDSL2 ===========
   if(gpt_TxInfo->uc_SI_SPar1[4] & G9701)
   {
      // SI NPar2 Octet1
      // According to table 11.69 of ITU-T G.994.1 standard

      gpt_TxInfo->G_Fast_Info.uc_SI_NPar2 = (gul_OperationModeCapable_G_Fast & 0x3F);
      gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_01 = ((gul_OperationModeCapable_G_Fast >> 8) & 0x3F);
      gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_02 = ((gul_OperationModeCapable_G_Fast >> 16) & 0x3F);

      // Profiles
      if (gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_01 & G_Fast_Profiles)
      {
         gpt_TxInfo->G_Fast_Info.uc_Profiles |= G_Fast_Profile_106;
      }
      else
      {
         gpt_TxInfo->G_Fast_Info.uc_Profiles &= ~G_Fast_Profile_106;
      }

      // Duration of Channel Discovery 1-1
      if ( gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_01 & G_Fast_Duration_Channel_Discovery)
      {
         gpt_TxInfo->G_Fast_Info.uc_duration_channel_discovery = 0x3;
      }
      else
      {
         gpt_TxInfo->G_Fast_Info.uc_duration_channel_discovery = 0;
      }

      // Number of symbols in TDD  frame
      if (gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_02 & G_Fast_Symbol_Period_TDD_Frame)
      {
         gpt_TxInfo->G_Fast_Info.uc_symbol_period_TDD_frame =36;
      }
   }
   // XDSLRTFW-2298 (End)

#endif
    CopyInfoField( gpt_TxInfo, gpt_TxInfoSave, TRUE );    /*  save CLR for later use */
#ifdef LEAVE_TRAIL
    CopyInfoField (gpt_TxInfoSave, &gt_TrailTxInfoSave, FALSE); /* save CLR for debug usage */
#endif
}   /*  PrepareCLR */


// Sriram : Moved to Hndshk Page2

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: SelectMode_Bis
 *
 *  Abstract: Selects Bis or BisInfo mode of operation based on exchaned MS message
 *
 *  Parameters :
 *      pt_BisInfo - Bis or BisPlus information structure containing mode select message.
 *      pt_TxBisInfo - Bis or BisPlus information structure of TxInfoSave
 *      pt_RxBisInfo - Bis or BisPlus information structure of RxInfoSave
 *      s_MultFactor - 1 for Bis and 2 for Plus mode. It multiplies the data rate when writing
 *                     into gt_handshake_bis structure.
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *
 *-------------------------------------------------------------------
 *^^^
 */
// XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
 // Added for debug purpose
 uint8 guca_temp_Spar2_Octet2 = 0;
void SelectMode_Bis( Adsl2AllInfo_t *pt_BisInfo, Adsl2AllInfo_t *pt_TxBisInfo, Adsl2AllInfo_t *pt_RxBisInfo, int16 s_MultFactor )
{
    int i,j, s_BisOrPlus;
    int16 s_temp;
    uint8* puca_BreakFreq;

    ////////////////////////////////////////////////////
    // Check whether we should do some special BIS mode
    ////////////////////////////////////////////////////
    if ((pt_BisInfo->uc_SI_NPar2[0] & DIAGNOSTICS_MODE) == DIAGNOSTICS_MODE)
    {
        // Don't update Macro state as yet. This is updated after MODE has been set
        gft_FlagDiagMode = 1;
    }
    else if ((pt_BisInfo->uc_SI_NPar2[0] & SHORT_INIT) == SHORT_INIT)
    {
        gft_farEndSISupport = TRUE;

        // Also, we do not select short initialization as linking mode just yet.
        // We shall go through one link of full initialization and
        // subsequent links shall be short initialization.
        STATArray[STAT_MacroState] = STAT_FullInitState;
        gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_FullInitState;
        gusa_HercADSL_MONIMap_Curr[0] = MONI_FULL_INIT;
    }
    // Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting ( Start)
    else
    {
       STATArray[STAT_MacroState] = STAT_FullInitState;
       gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_FullInitState;
       gusa_HercADSL_MONIMap_Curr[0] = MONI_FULL_INIT;
    }
#ifdef ISDN
    /////////////////////////////////////////////////////////
    // In Annex B, check whether tones 1 to 32 are supported
    /////////////////////////////////////////////////////////
    if ((pt_BisInfo->uc_SI_NPar2[0] & UPSTREAM_1_32_BIS) != 0)
    {
        gft_Tones1To32Support = TRUE;
    }
#endif

    ////////////////////////////////////////////////////
    // Tie the handshake variables to full initialization to be used in bit loading
    ////////////////////////////////////////////////////
    gt_HandshakeBis.s_MinMSGDSOverheadRate      = pt_BisInfo->t_Overhead.s_DSMSGOvhdMinRate;

    s_BisOrPlus = s_MultFactor-1;


    if (gt_hsc.s_CL_Exchanged)   // Only if CLR/CL exchanged, else the below variables will use values from last CLR/CL exchange
    {
        int s_NumTssi;

        // At this point, we have the consistent values between CLR/CL.

#ifndef ISDN
        // We can over-ride whatever US spectrum/mask we agreed with the CO, through CMV OPTN_AnnexControl. Currently only for 3A/3L
        if (OPTNArray[OPTN_AnnexControl] & OPTN_Force_US_PSD_control)
        {
            i = OPTNArray[OPTN_AnnexControl] >> 12 ;
            gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A] = i;
            STATArray[STAT_Misc] |= i<<12 ;

            pt_TxBisInfo->t_PMD_NPar3_US.s_NOMPSD     = gsa_US_NOMPSD_G9923A[i];
            pt_TxBisInfo->t_PMD_NPar3_US.s_MAXNOMPSD  = gsa_US_MAXNOMPSD_G9923A[i];
            pt_TxBisInfo->t_PMD_NPar3_US.s_MAXNOMATP  = gsa_US_MAXNOMATP_G9923A[i];

            puca_BreakFreq = (uint8*)(void *)pt_TxBisInfo->t_PMD_NPar3_US.pus_BreakFreq;
            for (j = 0; j < NUM_US_TSSI_VALUES_INITIAL_CLR; j++)
            {
                puca_BreakFreq[j] = guca_US_TssiIndex_G9923A[i][j];
                pt_TxBisInfo->t_PMD_NPar3_US.pf_InSprtSet[j>>3] = gfta_US_SprtSet_G9923A[i][j>>3];
                pt_TxBisInfo->t_PMD_NPar3_US.puc_tssi[j] = guca_US_TssiValue_G9923A[i][j];
            }
        }
#else //ISDN
        // XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (START)
        if (gus_workaround_bits & XDSLRTFW1842_ADSL2P_ANXB_POWER_BOOST)
        {
            puca_BreakFreq = (uint8*)(void *)pt_TxBisInfo->t_PMD_NPar3_US.pus_BreakFreq;
            for (j = 0; j < NUM_US_TSSI_VALUES_INITIAL_CLR; j++)
            {
                puca_BreakFreq[j] = guca_US_TssiIndex_G9925B_XDSLRTFW1842[j];
                pt_TxBisInfo->t_PMD_NPar3_US.pf_InSprtSet[j>>3] = gfta_US_SprtSet_G9925B_XDSLRTFW1842[j>>3];
                pt_TxBisInfo->t_PMD_NPar3_US.puc_tssi[j] = guca_US_TssiValue_G9925B_XDSLRTFW1842[j];
            }
        }
       // XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (END)
#endif
        // Save the GHS PMD info into the final PMD structure

        // Spectral Bound Info
        gt_TxPMDControl.s_NOMPSD_US = pt_TxBisInfo->t_PMD_NPar3_US.s_NOMPSD;
        gt_TxPMDControl.s_MAXNOMPSD_US = pt_TxBisInfo->t_PMD_NPar3_US.s_MAXNOMPSD;
        gt_TxPMDControl.s_MAXNOMATP_US = pt_TxBisInfo->t_PMD_NPar3_US.s_MAXNOMATP;
        gt_TxPMDControl.s_NOMPSD_DS = pt_RxBisInfo->t_PMD_NPar3_DS.s_NOMPSD;
        gt_TxPMDControl.s_MAXNOMPSD_DS = pt_RxBisInfo->t_PMD_NPar3_DS.s_MAXNOMPSD;
        gt_TxPMDControl.s_MAXNOMATP_DS = pt_RxBisInfo->t_PMD_NPar3_DS.s_MAXNOMATP;

        // DS Spectral Shape Info
        gt_GHS_DSTssiInfo.s_NumBrkptkept = gsa_num_DS_Tssi_brkpt_kept[s_BisOrPlus]; // Index 0 for ADSL2.
        gt_GHS_DSTssiInfo.s_NumBrkptRcvd = gsa_num_DS_Tssi_brkpt[s_BisOrPlus];

        s_NumTssi = gt_GHS_DSTssiInfo.s_NumBrkptkept;
        memcpy(&(gt_GHS_DSTssiInfo.usa_Brkpt), pt_RxBisInfo->t_PMD_NPar3_DS.pus_BreakFreq, s_NumTssi*sizeof(int16));
        memcpy(&(gt_GHS_DSTssiInfo.uca_Tssi), pt_RxBisInfo->t_PMD_NPar3_DS.puc_tssi, s_NumTssi);
        for (i = 0; i < (s_NumTssi+7)/8; i++)
            gt_GHS_DSTssiInfo.uca_Si[i] = pt_RxBisInfo->t_PMD_NPar3_DS.pf_InSprtSet[i];

        // US Spectral Shape Info
        gt_GHS_USTssiInfo.s_NumBrkptkept = gsa_num_USTssi_Xmitted[s_BisOrPlus];

        gt_GHS_USTssiInfo.s_NumBrkptRcvd = gsa_num_US_Tssi_brkpt[s_BisOrPlus];
        s_NumTssi = gt_GHS_USTssiInfo.s_NumBrkptkept;

        puca_BreakFreq = (uint8*)(void *)pt_TxBisInfo->t_PMD_NPar3_US.pus_BreakFreq;
        for (i = 0; i < s_NumTssi; i++)
        {
            gt_GHS_USTssiInfo.uca_Brkpt[i] = puca_BreakFreq[i];
            gt_GHS_USTssiInfo.uca_Tssi[i] = pt_TxBisInfo->t_PMD_NPar3_US.puc_tssi[i];
            gt_GHS_USTssiInfo.uca_Si[i>>3] = pt_TxBisInfo->t_PMD_NPar3_US.pf_InSprtSet[i>>3];
        }

        gt_HandshakeBis.s_NumDSLatencyPaths = 0;
        for(i=0; i<NUM_DS_LATENCY_PATHS; i++)
        {
            /* this information is not transmitted in an MS message but is calculated here to be used in our training code later */
            /* check if co and cpe support latency path i, downstream.  */

            if( ((pt_TxBisInfo->uc_SI_SPar2[2*(i+1)+1] & LATENCY_PATH_DN) !=0) && ((pt_RxBisInfo->uc_SI_SPar2[2*(i+1)+1] & LATENCY_PATH_DN) !=0) )
            {

                // Max R, D for LP0 are not included in CL message, for LP0 always set MS info to CLR info.
                /* compare Max R. Select the minimum of the CO and CPE max R */

                if(i == 0)
                {
                    pt_BisInfo->ta_DSLatencyPath[0].s_MaxRandD = (pt_TxBisInfo->ta_DSLatencyPath[0].s_MaxRandD & 0xFF00);
                    pt_BisInfo->ta_DSLatencyPath[0].s_MaxRandD |= (pt_TxBisInfo->ta_DSLatencyPath[0].s_MaxRandD & 0xFF);

                    //compare S0min and choose the appropriate one
                    if (pt_TxBisInfo->ta_DSLatencyPath[0].s_OneOverS0min  <= pt_RxBisInfo->ta_DSLatencyPath[0].s_OneOverS0min)
                        pt_BisInfo->ta_DSLatencyPath[0].s_OneOverS0min = pt_TxBisInfo->ta_DSLatencyPath[0].s_OneOverS0min;
                    else
                        pt_BisInfo->ta_DSLatencyPath[0].s_OneOverS0min = pt_RxBisInfo->ta_DSLatencyPath[0].s_OneOverS0min;

                    //calculate the supported D0 mask
                    pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask = pt_TxBisInfo->ta_DSLatencyPath[0].s_D0Mask & pt_RxBisInfo->ta_DSLatencyPath[0].s_D0Mask;

                    gt_HandshakeBis.s_DS_SupportedDValuesLP0 = pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask;

                    gt_HandshakeBis.s_OneOverSminADSL2 = pt_BisInfo->ta_DSLatencyPath[0].s_OneOverS0min;

                    for (j = 0; j <14; j++)
                    {
                        //eliminate the unsupported D value
                        if (((pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask>>j) & 1) == 0)
                            gs_supportedDvalues[13-j] = 0;
                    }
                }
                else
                {
                    if((pt_TxBisInfo->ta_DSLatencyPath[i].s_MaxRandD >> 8) <= (pt_RxBisInfo->ta_DSLatencyPath[i].s_MaxRandD >> 8))
                        pt_BisInfo->ta_DSLatencyPath[i].s_MaxRandD = (pt_TxBisInfo->ta_DSLatencyPath[i].s_MaxRandD & 0xFF00);
                    else
                        pt_BisInfo->ta_DSLatencyPath[i].s_MaxRandD = (pt_RxBisInfo->ta_DSLatencyPath[i].s_MaxRandD & 0xFF00);

                    /* compare Max D. Select the minimum of the CO and CPE max D */

                    if((pt_TxBisInfo->ta_DSLatencyPath[i].s_MaxRandD & 0xFF) <= (pt_RxBisInfo->ta_DSLatencyPath[i].s_MaxRandD & 0xFF))
                        pt_BisInfo->ta_DSLatencyPath[i].s_MaxRandD |= (pt_TxBisInfo->ta_DSLatencyPath[i].s_MaxRandD & 0xFF);
                    else
                        pt_BisInfo->ta_DSLatencyPath[i].s_MaxRandD |= (pt_RxBisInfo->ta_DSLatencyPath[i].s_MaxRandD & 0xFF);
                }

                /* compare Max rates. Select the minimum of the CO and CPE max overhead rates */
                if(pt_TxBisInfo->ta_DSLatencyPath[i].s_MaxDataRate  <= pt_RxBisInfo->ta_DSLatencyPath[i].s_MaxDataRate)
                    pt_BisInfo->ta_DSLatencyPath[i].s_MaxDataRate = pt_TxBisInfo->ta_DSLatencyPath[i].s_MaxDataRate;
                else
                    pt_BisInfo->ta_DSLatencyPath[i].s_MaxDataRate = pt_RxBisInfo->ta_DSLatencyPath[i].s_MaxDataRate;

                gt_HandshakeBis.s_NumDSLatencyPaths += 1; /* indicates the number of latency paths supported by both co and cpe in downstream */
                gt_HandshakeBis.sa_DS_MaxCheckbytesLP[i] = 2*(pt_BisInfo->ta_DSLatencyPath[i].s_MaxRandD >> 8);
                gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[i] = 1<<(pt_BisInfo->ta_DSLatencyPath[i].s_MaxRandD & 0xFF);
                /* data rate is doubled in g992_5 mode compared to g992_3 mode because */
                /* according to g994.1 spec, data rate is multiplied by 8000 in g992_5 mode */
                /* while data rate is multiplied by 4000 in g992_3 mode */
                gt_HandshakeBis.sa_DS_MaxDataRateLP[i]      = s_MultFactor*pt_BisInfo->ta_DSLatencyPath[i].s_MaxDataRate;

            }
        }
    }
   /* XDSLRTFW-3068 */
   gt_ADSL_TcMode_Reprt.us_FW_TC_mode = 0;      // Initialize only for  Bis & Plus Mode. For g.DMT initialize [ATM -ONLY]in the statein1.c
   /* XDSLRTFW-3068 */
    for(i=0; i<NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
    {
        uint8 uc_octet;
        int16 s_type, s_index = 1;

        uc_octet = (pt_BisInfo->uc_SI_SPar2[2*(i+1)]); // i = 0--> Spar2 Octet 3, i = 1 -->Spar2 Octet 5


        /* look at standard info field SPar2's appropriate octet to see if bearer channel i is of type STM, ATM or PTM type */
        s_type = -1;

        /* XDSLRTFW-3068 */
        for (j = 0; j < 3; j++)  // for 3 TPS-TC type eg. STM, ATM & PTM
        {

           if ((uc_octet & (0x1<<(2*j))) == (0x1<<(2*j)))
           {

              if (uc_octet & (0x01))                        // Downstream STM TPS-TC #0
              {
                 s_index = 0;
                 s_type = (STM_TC_MODE);
              }

              if (uc_octet & (0x04))                        // Downstream ATM TPS-TC #0
              {
                 s_index = 1;
                 s_type = (ATM_TC_MODE);
                 gt_ADSL_TcMode_Reprt.us_FW_TC_mode = ATM_TC;
              }

              if (uc_octet & (0x10))                        // Downstream PTM TPS-TC #0
              {
                 s_index = 2;
                 s_type = (PTM_TC_MODE);
                 gt_ADSL_TcMode_Reprt.us_FW_TC_mode = EFM_TC;
              }
           }
        } // End for (j =0 ...
      /* XDSLRTFW-3068 */

        if (s_type == -1)
        {
            gt_HandshakeBis.sa_DS_BCActive[i]            = FALSE;
            gt_HandshakeBis.sa_DS_MinNetDataRateBC[i]    = 0;
            gt_HandshakeBis.sa_DS_MaxNetDataRateBC[i]    = 0;
            gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[i]  = 0;
            gt_HandshakeBis.sa_DS_MaxLatencyBC[i]        = 0;
            gt_HandshakeBis.sa_DS_BerBC[i]               = 0;
            gt_HandshakeBis.sa_DS_MinINPBC[i]            = 0;
            gt_HandshakeBis.sa_DS_TransferModeBC[i]         = 0;
            guca_DS_TransferMode_bis[i]                  = 0;
        }
        else
        {
            /* Bearer channel i is active */
            gt_HandshakeBis.sa_DS_BCActive[i]            = TRUE;
            /* data rate is doubled in g992_5 mode compared to g992_3 mode because */
            /* according to g994.1 spec, data rate is multiplied by 8000 in g992_5 mode */
            /* while data rate is multiplied by 4000 in g992_3 mode */

            gt_HandshakeBis.sa_DS_MinNetDataRateBC[i]    = s_MultFactor * pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[s_index].s_MinNetDataRate;
            gt_HandshakeBis.sa_DS_MaxNetDataRateBC[i]    = s_MultFactor * pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[s_index].s_MaxNetDataRate;
            gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[i]  = s_MultFactor * pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[s_index].s_MinResNetDataRate;

            // the following code is added according to the corrigendum(Jan. 03), which proposed Max Latecy (in the range of [0~63]) to be 0 has
            /// special meaning as no limit boundary
            // after handshake, we should interprete the special s_MaxLatency value in Handshake exchange as our internal value
            if (pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[s_index].s_MaxLatency == 0)
                pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[s_index].s_MaxLatency = 1024;

            gt_HandshakeBis.sa_DS_MaxLatencyBC[i]        = (pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[s_index].s_MaxLatency);
            gt_HandshakeBis.sa_DS_BerBC[i]               = (pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[s_index].uc_MaxBER);
            gt_HandshakeBis.sa_DS_TransferModeBC[i]         = (uint8)s_type;
            guca_DS_TransferMode_bis[i]                  = (uint8)s_type;
            //  INP
            s_temp = (pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[s_index].s_IMAxINP);
            gt_HandshakeBis.sa_DS_MinINPBC[i] = MapInputtoINPConst(s_temp);

            // Fix for Tiscali problem seen against CNXT(GSPN) CO for which minINP sent during
            // CL != minINP sent during MS message by the CO, so we consider only the minINP sent
            // during CL message due to a strange configuration problem with the DSLAM.

            // IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading (START)
            if ((gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
                    (gt_INFX_CMV.s_DFE_Options & CMV_DFE_CHOOSE_MININP_FROM_CL_CNXT_ENABLE))
            {
                // here we paste guc_CL_minINP for both Bearer Channels to minINP to be used in Bitloading
                gt_HandshakeBis.sa_DS_MinINPBC[i] = MapInputtoINPConst(guc_CL_minINP);
            }
            // IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading (END)
        }

        /* look at standard info field SPar2's appropriate octet to see if bearer channel i is of type STM, ATM or PTM type */
        s_type = -1;

        for (j = 0; j < 3; j++)
        {
            if ((uc_octet & (0x2<<(2*j))) == (0x2<<(2*j)))
            {
                s_type = (0x8<<j);
            }
        }


        if (s_type == -1)
        {
            guca_US_TransferMode_bis[i]                  = 0;
        }
        else
        {
            /* Bearer channel i is active */
            guca_US_TransferMode_bis[i]                  = (uint8)s_type;
        }
    }

   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)
#ifdef ADSL_BONDING
   if((gt_ADSL_TcMode_Reprt.us_FW_TC_mode == ATM_TC) && (gt_Bonding_DiscAggr_Control.s_PCS_control))
   {
      // Set up the exception code if TPS-TC mode is ATM
      gus_ExceptionCode = E_CODE_BONDING_FAILURE;  //E_CODE_GHS_FE_NOT_BONDABLE
   }
#endif
   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(End)

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Start
#ifdef UNV_RETX_GHS
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      uint8 uc_octet;
      int16 s_type;
     // gt_HandshakeBis.s_NumDSLatencyPaths = 2;
      uc_octet = (pt_BisInfo->uc_SI_SPar2[3]);  // SPar2 Octet 4

      /* look at standard info field SPar2's appropriate octet to see if bearer channel i is of
         type ATM or PTM type ReTx*/
      for (j = 0; j < 2; j++)
      {
         s_type = -1;
         if ((uc_octet & (0x4 << j)) == (0x4 << j))
         {
            s_type = (0x10 << j);
         }
         if(s_type != -1)
         {
            gt_HandshakeBis.sa_DS_BCActive[0] = TRUE;
            gt_HandshakeBis.sa_DS_TransferModeBC[0] = (uint8) s_type;
            guca_DS_TransferMode_bis[0] = (uint8) s_type;

         }
      }
   /* XDSLRTFW-3068 */
   // XDSLRTFW-3298 (Start) R7AMR6: No sync against NVLT-G in ADL2p when ds ReTx is enabled on CO side

   if (uc_octet & (0x04))                        // Downstream ATM TPS-TC #0 RETX
   {
      gt_ADSL_TcMode_Reprt.us_FW_TC_mode = ATM_TC;
   }

   if (uc_octet & (0x08))                        // Downstream PTM TPS-TC #0 RETX
   {
      gt_ADSL_TcMode_Reprt.us_FW_TC_mode = EFM_TC;
   }
   // XDSLRTFW-3298 (End) R7AMR6: No sync against NVLT-G in ADL2p when ds ReTx is enabled on CO side
   /* XDSLRTFW-3068 */


//XDSLRTFW-1025 FEATURE_DS_BisPlus_ALL_Disable_SRA_for_ReTx (Start)
//      OPTNArray[OPTN_OLRControl_DS] &= ~OPTN_EnableAutoSRA; //SRA disabled for ReTx
//XDSLRTFW-1025 FEATURE_DS_BisPlus_ALL_Disable_SRA_for_ReTx (End)
#if 0
      //FEATURE_ALL_BisPlus_ALL_Univ_Retx_DFEtoPPE Start
      gpt_ReTxXmemConfigInfo->ul_ReTxEnable = gt_ReTxConfigInfo.ft_ReTxOn;
      //Disable reboot creteria due to NCD.
      gt_INFX_FW_REBOOT_CMV.s_RebootCriteria &= ~CMV_REBOOT_RX_CELL_DELINEATION;
      //FEATURE_ALL_BisPlus_ALL_Univ_Retx_DFEtoPPE End
      //UReTx F6 engg release (2.4.5.2.1.1) doesnot support
      //DS_AutoSRA, PM_L2 & US_SRA
      //Disable downstream AuToSRA
      OPTNArray[OPTN_OLRControl_DS] &= ~OPTN_EnableAutoSRA;
      //Disable downstream PM L2 mode
      OPTNArray[OPTN_OLRControl_DS] |= OPTN_DisableL2Mode;
      //Disable upstream SRA
      OPTNArray[OPTN_OLRControl_DS] |= OPTN_DisableUSSRA;
#endif
   }
#if 0
   else
      gpt_ReTxXmemConfigInfo->ul_ReTxEnable = 0;
   //FEATURE_ALL_BisPlus_ALL_Univ_Retx_DFEtoPPE Start
   // Initialise Service specific ReTx to 0 in DFE<-> PPE interface.
   gpt_ReTxXmemConfigInfo->ul_ServiceSpecificReTx = 0;
#endif
   //FEATURE_ALL_BisPlus_ALL_Univ_Retx_DFEtoPPE End
#endif //#ifdef UNV_RETX_GHS
   //SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

    if (TESTArray[TEST_Control2] & TEST_OverWriteMSwithCNFG_ADSL2)
    {
        // For LP0, map the cnfg cmv  values  which are sent in CLR into gt_HandshakeBis structure

        s_temp = (pt_TxBisInfo->ta_DSBearerChannel[0].ta_TpsTcType[1].s_IMAxINP);

        gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = (pt_TxBisInfo->ta_DSBearerChannel[0].ta_TpsTcType[1].s_MaxLatency);

        // Map Input INP CLR value
        gt_HandshakeBis.sa_DS_MinINPBC[0] = MapInputtoINP_CLR(s_temp);
    }
    /*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
    guc_PtmOctet_DS_BC0 = pt_BisInfo -> uc_PtmOctet_DS_BC0;
    guc_PtmOctet_US_BC0 = pt_BisInfo -> uc_PtmOctet_US_BC0;
#endif //if defined DANUBE_PTM_SUPPORT
    /*********************************PTM CHANGES*************************************/

    // AR8_TF: IOP_DS_BisPlus_CNXT_FramingLimitation (Start)
#ifndef ISDN   // Only for Anx-A
    if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
    {
        for (j = 0; j < 1; j++) // up to now for Latency path 0 only
        {
            // SMS00768526: IOP_DS_BisPlus_CNXT_D57E67_RS_INP0DELAY2MS (START)
            // if minINP<2, limit S=1/3
            if (gt_HandshakeBis.sa_DS_MinINPBC[j] < 2 * 1)
            {
                gt_HandshakeBis.s_OneOverSminADSL2 = 3;
                if ((gt_HandshakeBis.sa_DS_MaxLatencyBC[j] <= 2) &&   // if maxDelay <= 2ms
                        ((gt_INFX_CMV.us_OperatorSpBits & CMV_TO_DISABLE_CNXT_D57E67_BISPLUS_RS_DELAY2MS)==0))
                {
                    // Force the no. of check bytes = 0, to get rid of CRC/FECs but
                    // this costs us performance.
                    gt_HandshakeBis.sa_DS_MaxCheckbytesLP[j] = 0;
                }
                // if maxDelay = 2ms, set to 3ms to get R=2 and D=32
                if ((gt_HandshakeBis.sa_DS_MaxLatencyBC[j] == 2) &&
                        ((gt_INFX_CMV.us_OperatorSpBits & CMV_TO_DISABLE_CNXT_D57E67_BISPLUS_RS_DELAY2MS)!=0))
                {
                    // If maxDelay=1 or 2 ms, RA (rate adaptation) code will select R=0 and D=1 as fast path.
                    // Set maxDelay=3ms to get RS coding with interleaving D > 1. This is a workaround to avoid changing RA code.
                    // To enable this, cw INFO 103 0 0x0080 defined as CMV_TO_DISABLE_CNXT_D57E67_BISPLUS_RS_DELAY2MS
                    gt_HandshakeBis.sa_DS_MaxLatencyBC[j] = 3;
                }
            }
            // SMS00768526: IOP_DS_BisPlus_CNXT_D57E67_RS_INP0DELAY2MS (END)
        }  // for (...
    }

   //XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_OneOverS_Limitation (START)
   //Limit 1/Sp to 3 for CTNW DSLAMs to avoid link drop.
   if (gs_CurrentCoChipset == CTNW_CO_CHIPSET)
   {
     gt_HandshakeBis.s_OneOverSminADSL2 = 3;
   }
   //XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_OneOverS_Limitation (END)
#endif // ifndef ISDN
    // AR8_TF: IOP_DS_BisPlus_CNXT_FramingLimitation (End)

}


/*^^^
*------------------------------------------------------------------------
*
 *  Name: RxSymbolReAlign
 *
 *  Description:
 *    Realigns bit boundaries using incoming FLAG and GALF characters
 *
 *  Prototype: void RxSymbolReAlign(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]                - input of IFFT, used in RxBit()
 *      gs_RxToneBuf[]                 - frequency domain samples, used in RxBit()
 *      guc_RxOctet                    - (I/O) current octet being transmitted
 *      gs_RxState                     - (I) current RX state
 *      gs_RxSubState                  - (I/O) current RX substate
 *      gs_RxSubStateCnt               - (I/O) # symbols in current RX substate
 *      gl_RxSymbolCount               - (I) # symbol periods in current RX state
 *      gs_RxNextState                 - (O) RX state that will begin next symbol
 *                                       period
 *
 *  Substates:
 *      RX_SYMBOL_REALIGN_FILL_BUFFER  - Fills up gt_RxSymbolBuf.
 *      RX_SYMBOL_REALIGN_DETECT_ZERO  - Detects SYMBOLS_PER_BIT DMT symbols with no
 *                                       phase reversal (a ZERO bit).
 *      RX_SYMBOL_REALIGN_DETECT_ONE   - Detects a DMT symbol with a phase reversal
 *                                       (beginning of a ONE bit).
 *      RX_SYMBOL_REALIGN_RECEIVE_BITS - the RxBit function is called as additional
 *                                       DMT symbols are acquired, and the resulting
 *                                       bits are stored in guc_RxOctet until a total
 *                                       of SYMBOLS_PER_OCTET DMT symbols have been
 *                                       aquired.
 *
 *  Notes: none
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define RX_SYMBOL_REALIGN_FILL_BUFFER  (0)
#define RX_SYMBOL_REALIGN_DETECT_ZERO  (1)
#define RX_SYMBOL_REALIGN_DETECT_ONE   (2)
#define RX_SYMBOL_REALIGN_RECEIVE_BITS (3)

void RxSymbolReAlign(void)
{

    int16 s_SubBit;
    int16 s_Vote;
    int16 s_SymCnt;     /*  local symbol count, which will copy gl_RxSymbolCount or gs_RxSymCnt */

    if (gs_RxState == R_C_GALF1_RX)
        s_SymCnt = (int16) gl_RxSymbolCount;
    else /*  (gs_RxState == R_C_HS_MSG_RX) */
        s_SymCnt = gs_RxSymCnt;

    switch (gs_ReAlignSubState)
    {

        /* =============================================== */
        /* fill up gt_RxSymbolBuf */
        /* =============================================== */
    case RX_SYMBOL_REALIGN_FILL_BUFFER:

        s_SubBit = s_SymCnt & MODULO_BY_8_MASK;
        gs_RxSubStateCnt++;
        GetSymbol( s_SubBit );

        if ( gs_RxSubStateCnt >= SYMBOLS_PER_BIT )
        {
            gs_RxSubStateCnt   = 0;
            gs_ReAlignSubState = RX_SYMBOL_REALIGN_DETECT_ZERO;
        }

        break;

        /* =============================================== */
        /* detect zero bit (no phase change) */
        /* =============================================== */
    case RX_SYMBOL_REALIGN_DETECT_ZERO:

        s_SubBit = s_SymCnt & MODULO_BY_8_MASK;
        GetSymbol( s_SubBit );
        s_Vote = TestPhaseTransition( s_SubBit );

        if ( s_Vote < 0 )
            gs_RxSubStateCnt++;
        else
            gs_RxSubStateCnt = 0;

        /* ---- check for SYMBOLS_PER_BIT consecutive symbos without phase reversal ---- */
        if (gs_RxSubStateCnt >= SYMBOLS_PER_BIT)
        {
            gs_RxSubStateCnt   = 0;
            gs_ReAlignSubState = RX_SYMBOL_REALIGN_DETECT_ONE;
        }

        break;

        /* =============================================== */
        /* detect first phase reversal */
        /* =============================================== */
    case RX_SYMBOL_REALIGN_DETECT_ONE:

        s_SubBit = s_SymCnt & MODULO_BY_8_MASK;
        GetSymbol( s_SubBit );
        s_Vote = TestPhaseTransition( s_SubBit );

        /* ---- if first phase reversal (binary 1 of a bit) detected, ---- */
        /* ---- initiailize for next substate                         ---- */
        if ( s_Vote >= 0 )
        {

            // Initialize the received octet
            guc_RxOctet = 0;

            // Reset averaging buffer
            RxAvgCarrierTones(1);

            if ( gs_RxState == R_C_GALF1_RX )
                gs_RxSubStateCnt = 2 - SYMBOLS_PER_BIT; /*  we assume first phase change is  */
            /* the LSB of the previous GALF */
            else /*  if ( gs_RxState == R_C_HS_MSG_RX ) */
                gs_RxSubStateCnt = SYMBOLS_PER_BIT + 2; /*  we assume the first bit of a flag, */
            /*  which is 0, is already received at this point. */

            // Start decoding octet. Note that the '1' we just detected will be decoded again
            // and put into guc_RxOctet. When we are trying to detect GALF (in R_C_GALF1_RX) this
            // bit is eventually discarded because it belongs to the previous octet. When we are
            // trying to detect FLAG it is preserved. This is controlled by the initial value
            // of gs_RxSubStateCnt above.
            s_SubBit = gs_RxSubStateCnt & MODULO_BY_8_MASK;
            RxBit( s_SubBit );

            gs_ReAlignSubState = RX_SYMBOL_REALIGN_RECEIVE_BITS;
        }

        break;

        /* =============================================== */
        /* after the detection of the first phase reversal */
        /* =============================================== */
    case RX_SYMBOL_REALIGN_RECEIVE_BITS:

        gs_RxSubStateCnt++;

        s_SubBit = gs_RxSubStateCnt & MODULO_BY_8_MASK;

        RxBit( s_SubBit );

        /* ---- one full octet received ---- */
        if ( gs_RxSubStateCnt == (SYMBOLS_PER_OCTET - 1) )
        {

#ifdef DEBUG_GHS
            printf( "Rx\t%x\n", guc_RxOctet );
#endif

            switch ( gs_RxState )
            {
            case R_C_GALF1_RX:
                if ( guc_RxOctet == GALF )
                {
                    //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
#ifndef ISDN
                    if ((guc_AnnexMCarSet_Detect & 0x1) && (guc_RxOctet != guc_RxOctet_B43))
                        guc_AnnexMCarSet_Detect &= 0xfe;
#endif
                    //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
                    gs_RxNextState = R_C_FLAG1_RX;
                    gpF_RxStateFunc = (PtrToFunc)RCFlag1RxF;

                    // XDSLRTFW-3546: ADSLx AnxB mode: Ghs session start declaration at wrong place
                    // C-GALF message (value 0x81) is the first definitive message transmitted by CO in Ghs Session. If CPE successfully
                    // decodes the C-GALF signal, there is more likelihood that CO starts it Ghs session. Declare start of Ghs session
                    // through "stat 0 0" CMV after successful decoding of C-FLAG message.
                    // This declaration is now common across all ADSL annexes.
                    STATArray[STAT_MacroState] = STAT_GhsState;
                    gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_GhsState;
                    gusa_HercADSL_MONIMap_Curr[0] = MONI_GHS;
                }
                else    /*   if failed, retry symbol alignment */
                {
                    gs_RxSubStateCnt   = 0;
                    gs_ReAlignSubState = RX_SYMBOL_REALIGN_FILL_BUFFER;
                }

                break;

            default: /*  case R_C_HS_MSG_RX: */
                if ( guc_RxOctet == FLAG )
                {
                    gft_SymbolReAlignRequired = FALSE;
                    gs_RxSymCnt = -1; /*  resetting counter upon locking on a FLAG */
                    gs_RxSubStateCnt   = 0; /*  reset counter */
                }
                else    /*   if failed, retry symbol alignment */
                {
                    gs_RxSubStateCnt   = 0;
                    gs_ReAlignSubState = RX_SYMBOL_REALIGN_FILL_BUFFER;
                }

                break;

            }   /*  switch (gs_RxState) */
        }

        break;

    }    /*  switch (gs_RxSubState) */

}   /*  RxSymbolReAlign */

#undef RX_SYMBOL_REALIGN_FILL_BUFFER
#undef RX_SYMBOL_REALIGN_DETECT_ZERO
#undef RX_SYMBOL_REALIGN_DETECT_ONE
#undef RX_SYMBOL_REALIGN_RECEIVE_BITS

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: TestPhaseTransition
 *
 *  Description: function to test phase transition, take moving
 *               averages for current bit symbol and last bit symbol, then
 *               vote on hard decision (note that gta_RxSymbolBuf is a circular buffer)
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 TestPhaseTransition(int16 s_SubBit)
{

    int  i;
    int s_Vote;
    int16 s_WindowLen;
    int16 s_StartIdx;
    int32 l_Product;

    s_Vote      = 0;
    s_WindowLen = RX_SYMBOL_BUF_SIZE >> 1;  /*  half the buffer length */
    s_StartIdx  = ( s_SubBit - s_WindowLen + RX_SYMBOL_BUF_SIZE ) & MODULO_BY_8_MASK;

    for ( i = 0; i < NUM_CARRIERS_IN_SET; i++ )
    {
        gt_RxCurrentSymbol[i] = MovingAvg( gta_RxSymbolBuf[i], RX_SYMBOL_BUF_SIZE, s_SubBit, s_WindowLen );
        gt_RxLastSymbol[i]    = MovingAvg( gta_RxSymbolBuf[i], RX_SYMBOL_BUF_SIZE, s_StartIdx, s_WindowLen );

        //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
        //Update the current and last symbol with B43 carrier set.
#ifndef ISDN
        gt_RxCurrentSymbol_B43[i] =
            MovingAvg(gta_RxSymbolBuf_B43[i], RX_SYMBOL_BUF_SIZE, s_SubBit,
                      s_WindowLen);
        gt_RxLastSymbol_B43[i] =
            MovingAvg(gta_RxSymbolBuf_B43[i], RX_SYMBOL_BUF_SIZE, s_StartIdx,
                      s_WindowLen);
#endif
        //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
        /*  Real part of a complex product ( Current_Symbol * Conjugate(Last_Symbol) ) is positive? */
        l_Product = (int32) gt_RxCurrentSymbol[i].s_X * (int32) gt_RxLastSymbol[i].s_X;
        l_Product += (int32) gt_RxCurrentSymbol[i].s_Y * (int32) gt_RxLastSymbol[i].s_Y;
        if ( l_Product >= 0 )
            s_Vote--;   /*  no phase change if positive */
        else
            s_Vote++;   /*  inverted phase if negative  */
    }

    return(s_Vote);

}   /* TestPhaseTransition */

/*^^^
 *------------------------------------------------------------------------
 *

  Name : MapInputtoINPConst(int16 s_inputMinINP)

  Description: Maps the handshake input INP value to 2 * ActualINP
            value.

  Inputs : ta_TpsTcType[s_index].s_IMAxINP :Handshake INP value

 *------------------------------------------------------------------------
 *^^^
 */

int16 MapInputtoINPConst(int16 s_inputMinINP)
{
    int16 s_shift;
    int16 s_ActualMinINP;

    // For MinINP value: 0,1/2,1 frame, input exchanged value is 2 * ActualINP

    if (s_inputMinINP <=2)
        return(s_inputMinINP);

    // Divide into two groups : INP 2, 4, 8, 16 into one group and INP 3, 5-7, 9-15 into another

    if ((s_inputMinINP & 0x03) == 0x03)
    {
        if ((s_inputMinINP & 0xF0) == 0)
        {
            // INP 2,4,8,16
            // Bits 4-7 being zero, imply INP is a power of 2, bits 2&3 can be used
            // decide INP

            // MinINP =  2, 0x00000011
            // MinINP =  4, 0x00000111
            // MinINP =  8, 0x00001011
            // MinINP = 16, 0x00001111

            s_shift = ( s_inputMinINP >> 2);
            s_ActualMinINP = (2 << s_shift);
        }
        else
        {
            //INP 3, 5-7, 9-15
            // Bits 4-7 directly detremine INP value

            s_ActualMinINP = (s_inputMinINP >> 4);
        }

        return (s_ActualMinINP * 2);
    }
    return(-1); //FAIL
}
