/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hndshk1.c
 *
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// hndshk1.c
//
// History
//
// 29/09/2010 Nihar: Prevent VDSL FW to start if AFE register is fused to a defined value.
//                          This is a way to use the VR9 as AR10 till the time AR10 is officially available.
//                      Grep for XDSLRTFW-178
//
// ******************************************************************
#include "common.h"
#include "string.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "afe.h"
#include "hndshk1.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "TxTneSt.h"
#include "hndshk_Data.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


extern HS_Encode_ADSL2_t   gta_HS_ADSL2[];


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: InitializeInfoField
 *
 *  Abstract: Initializes an information field structure
 *
 *  InitializeInfoField() - Initialize an Information Field structure
 *
 *  Parameters:
 *      InfoField *t_I: information structure to be initialized
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *          guca_MultimodeSetting
 *
 *-------------------------------------------------------------------
 *^^^
 */
C_SCOPE void InitializeInfoField(InfoField_t * t_I)
{

    int i;
    HS_Encode_ADSL2_t *pt;

    // Important: there are some gpt_TxInfo BIS information are intialized in InitGlobalVariables().
    // The reason for not putting them into this function is that those information could
    // be specifically set by mp file and we don't want to overwrite them with default values
    // which should be put here. Please check before you thought they are missed in this function.

    t_I->uc_Type           = 0;         /*  message type field */
    if (OPTNArray[OPTN_GhsControl] & OPTN_Ghs_Rev1)
    {
        t_I->uc_Rev        = 1;        /* For CO's (e.g. ADLT-Q) that cannot handle Rev>1 even in CLR */
    }
    else
    {
        t_I->uc_Rev        = REVISION;  /*  revision number field */
    }

    /* ==== Vendor ID field ==== */
    t_I->us_Country        = guca_ne_G9941_VendorID[0]<<8 | guca_ne_G9941_VendorID[1];   /*  T.35 country code (2 octets) */
    t_I->ul_Provider       = guca_ne_G9941_VendorID[2]<<24|guca_ne_G9941_VendorID[3]<<16|guca_ne_G9941_VendorID[4]<<8|guca_ne_G9941_VendorID[5];      /*  provider code (Vendor ID, 4 octets) */
    t_I->us_VendorInfo     = guca_ne_G9941_VendorID[6]<<8 | guca_ne_G9941_VendorID[7];              /*  vendor specific information (2 octets) */


    /* ==== ID Parameter field ==== */
    t_I->uc_ID_NPar1       = 0;

    memset(t_I->uc_ID_SPar1, 0, NUM_ID_SPAR1_OCTETS);

    /* ---- Npar2 ---- */
    if(t_I->uc_ID_SPar1[0] != 0)
    {
        t_I->uc_UpMaxNDR       = MAX_NET_DATARATE_US;    /*  maximum net data rate upstream 2M */
        t_I->uc_UpMinNDR       = MIN_NET_DATARATE_US;    /*  minimum net data rate upstream 64k */
        t_I->uc_UpAvgNDR       = AVG_NET_DATARATE_US;    /*  average net data rate upstream 832k */

        t_I->uc_DnMaxNDR       = MAX_NET_DATARATE_DS;    /*  maximum net data rate downstream 12M */
        t_I->uc_DnMinNDR       = MIN_NET_DATARATE_DS;    /*  minimum net data rate downstream 64k */
        t_I->uc_DnAvgNDR       = AVG_NET_DATARATE_DS;    /*  average net data rate downstream 6M */

        t_I->uc_UpMaxLat       = MAX_LATENCY_US;    /*  maximum latency upstream given in ms, but note that */
        /*  in general physical units are not represented linearly */
        /*  in ms (see Table 16 of G.hs) */
        t_I->uc_UpAvgLat       = AVG_LATENCY_US;    /*  average latency upstream given in ms, but note that */
        /*  in general physical units are not represented linearly */
        /*  in ms (see Table 17 of G.hs) */
        t_I->uc_DnMaxLat       = MAX_LATENCY_DS;    /*  maximum latency downstream given in ms, but note that */
        /*  in general physical units are not represented linearly */
        /*  in ms (see Table 18 of G.hs) */
        t_I->uc_DnAvgLat       = AVG_LATENCY_DS;    /*  average latency downstream given in ms, but note that */
        /*  in general physical units are not represented linearly */
        /*  in ms (see Table 19 of G.hs) */
    }
    else
    {
        t_I->uc_UpMaxNDR       = 0;
        t_I->uc_UpMinNDR       = 0;
        t_I->uc_UpAvgNDR       = 0;

        t_I->uc_DnMaxNDR       = 0;
        t_I->uc_DnMinNDR       = 0;
        t_I->uc_DnAvgNDR       = 0;

        t_I->uc_UpMaxLat       = 0;
        t_I->uc_UpAvgLat       = 0;

        t_I->uc_DnMaxLat       = 0;
        t_I->uc_DnAvgLat       = 0;

    }

    if (gul_ModeControl & OPTN_ConfigMode_G992_1_B)
    {
        t_I->uc_ID_NPar2_O11   = LPF_EISDN;         /*  ATU-R splitter information */
        t_I->uc_ID_NPar2_O12   = HPF_EISDN;         /*  ATU-C splitter information */
    }
    else
    {
        t_I->uc_ID_NPar2_O11   = LPF_VOICE;         /*  ATU-R splitter information */
        t_I->uc_ID_NPar2_O12   = HPF_VOICE;         /*  ATU-C splitter information */
    }

    /* They are going to be transmitted only if enabled in PrepareCLR() !!! */
    t_I->uc_UpA43Attenuation = RELATIVE_POWER_LEVEL_A43_UP;
    t_I->uc_DnA43Attenuation = RELATIVE_POWER_LEVEL_A43_DN;
    t_I->uc_UpB43Attenuation = RELATIVE_POWER_LEVEL_B43_UP;
    t_I->uc_DnB43Attenuation = RELATIVE_POWER_LEVEL_B43_DN;
    t_I->uc_UpC43Attenuation = RELATIVE_POWER_LEVEL_C43_UP;
    t_I->uc_DnC43Attenuation = RELATIVE_POWER_LEVEL_C43_DN;

    t_I->uc_UpA4Attenuation = RELATIVE_POWER_LEVEL_A4_UP;
    t_I->uc_DnA4Attenuation = RELATIVE_POWER_LEVEL_A4_DN;
    t_I->uc_UpA43cAttenuation = RELATIVE_POWER_LEVEL_A43c_UP;
    t_I->uc_DnA43cAttenuation = RELATIVE_POWER_LEVEL_A43c_DN;
   //XDSLRTFW-2893
    t_I->uc_ID_SPar1[2] = 0;
#ifdef ADSL_BONDING
      t_I->uc_BondingNP2 = 0;
      t_I->uc_BondingSP2 = 0;
      // if bonding is enabled, then initialize the Standard Info Field
      // in function PrepareCLR_BONDING
#endif //ADSL_BONDING
   //----------------------------
    t_I->uc_UpJ43Attenuation = RELATIVE_POWER_LEVEL_J43_UP;
    t_I->uc_DnJ43Attenuation = RELATIVE_POWER_LEVEL_J43_DN;

    t_I->uc_UpB43cAttenuation = RELATIVE_POWER_LEVEL_B43c_UP ;
    t_I->uc_DnB43cAttenuation = RELATIVE_POWER_LEVEL_B43c_DN ;


    /* ==== Standard Information Field ==== */
    t_I->uc_SI_NPar1       = SILENT_PERIOD;

    memset(t_I->uc_SI_SPar1, 0, NUM_SI_SPAR1_OCTETS);

    if ( (gul_ModeControl & OPTN_ConfigMode_G992_1_A) != 0)
        t_I->uc_SI_SPar1[0] |= G992_1_A;
    if ( (gul_ModeControl & OPTN_ConfigMode_G992_2_AB) != 0)
        t_I->uc_SI_SPar1[0] |= G992_2_AB;


    if (gul_ModeControl & OPTN_ConfigMode_G992_1_B)
    {
        t_I->uc_SI_SPar1[0] |= (G992_1_B);
    }

    //for BIS/PLUS, we use a loop to do the stuff
    pt = gta_HS_ADSL2;
    for (i=0 ; i<NUM_KNOWN_ADSL2_SPAR1_BITS ; i++)
    {
        if ((gul_ModeControl & pt->cfgmode) != 0)
        {
            t_I->uc_SI_SPar1[pt->SI_SPar1_idx] |= pt->SI_Spar1_anx_bit;
        }
        pt++;
    }//i
    //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(Start)
#ifdef HERC_API
    // XDSLRTFW-178 (Start_End)
    if (gft_NoVDSLIndication == 0)
    {
        // VDSL modes
        //some confusion about which bit shall indicate VDSL1
        if(OPTNArray[OPTN_AlgControl3] & CMV_TO_SEND_VDSL_MODES_IN_SHORT_CLR)
        {
            // SPar1 Octet 2: G991_2_A, G991_2_B, MCM VDSL, SCM VDSL
            if ((gul_ModeControl & (OPTN_ConfigMode_T1_MCM_VDSL<<16)) != 0)
                t_I->uc_SI_SPar1[1] |= (uint8)(T1_MCM_VDSL >> 8); //set to VDSL 1

            if ((gul_ModeControl & (OPTN_ConfigMode_G993_1<<16)) != 0)//set to VDSL 1
                t_I->uc_SI_SPar1[4] |= G993_1_ANSI_T1_424; // Set to G993.1/ANSI T1.424

            // set to VDSL2
            if ( (gul_ModeControl & (OPTN_ConfigMode_G993_2<<16)) != 0)
                t_I->uc_SI_SPar1[4] |= G993_2;
        }
    }
#endif

    // If any ADSL2 bits are set, send short CLR first if OPTN_GhsControl points to it
    gft_SendShortCLR = FALSE;

    if (OPTNArray[OPTN_GhsControl] & OPTN_RTMMode_ShortCLR)
    {
        if (gul_ModeControl & STAT_ConfigMode_ADSL2_ALL)
            gft_SendShortCLR = TRUE ;
#ifdef HERC_API
        if ((gul_ModeControl & STAT_ConfigMode_VDSL_ALL) &&
                (OPTNArray[OPTN_AlgControl3] & CMV_TO_SEND_VDSL_MODES_IN_SHORT_CLR)
           )
            gft_SendShortCLR = TRUE ;
#endif
    }
    //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(End)
#ifndef ISDN
    if (t_I->uc_SI_SPar1[0] & G992_1_A)
    {
        /* ---- G992.1 Annex A specific Par2 and Par3 ---- */

        t_I->uc_SI_1A_NPar2    = ATM | STM | R_ACK2 | CLEAR_EOC_G997_1;
        t_I->uc_SI_1A_SPar2    = SUBCH_INFO | SPECTRUM_UP | SPECTRUM_DN;

        /* ---- NPar3 ----  */
        t_I->uc_1A_SubChan1    = AS0_DN;            /*  AS0 downstream */
        t_I->uc_1A_SubChan2    = LS0_UP;            /*  LS0 upstream */
        t_I->uc_1A_UpMinSpect  = (uint8) gs_TxFirstChannel;  /*  spectrum minimum frequency upstream */
        t_I->uc_1A_UpMaxSpect  = (uint8) gs_TxLastChannel;   /*  spectrum maximum frequency upstream */
        t_I->uc_1A_DnMinSpect  = (uint8) gs_RxFirstChannel;  /*  spectrum minimum frequency downstream */
        t_I->uc_1A_DnMaxSpect  = (uint8) RX_LAST_CHANNEL;   /*  spectrum maximum frequency downstream */
    }
#else
    if (t_I->uc_SI_SPar1[0] & G992_1_B)
    {
        t_I->uc_SI_1B_NPar2    = ATM | STM | R_ACK2 | CLEAR_EOC_G997_1;
        t_I->uc_SI_1B_SPar2    = SUBCH_INFO | SPECTRUM_UP | SPECTRUM_DN;

        /* ---- NPar3 ----  */
        t_I->uc_1B_SubChan1    = AS0_DN;            /*  AS0 downstream */
        t_I->uc_1B_SubChan2    = LS0_UP;            /*  LS0 upstream */
        t_I->uc_1B_UpMinSpect  = (uint8) 33;  /*  spectrum minimum frequency upstream */
        t_I->uc_1B_UpMaxSpect  = (uint8) 60;   /*  spectrum maximum frequency upstream */
        t_I->uc_1B_DnMinSpect  = (uint8) 64;  /*  spectrum minimum frequency downstream */
        t_I->uc_1B_DnMaxSpect  = (uint8) gs_RxLastChannel;   /*  spectrum maximum frequency downstream */

    }
#endif//ISDN

    if (t_I->uc_SI_SPar1[0] & G992_2_AB)
    {
        /* ---- G992.2 Annex A/B specific Par2 and Par3 ---- */

#ifdef INCLUDE_FASTRETRAIN_CODE
        t_I->uc_SI_2AB_NPar2   = R_ACK2 | FAST_RETRAIN | RS16 | CLEAR_EOC_G997_1;
#else
        t_I->uc_SI_2AB_NPar2   = R_ACK2 | RS16 | CLEAR_EOC_G997_1;
#endif
        t_I->uc_SI_2AB_SPar2   = SPECTRUM_UP | SPECTRUM_DN;

        /* ---- NPar3 ----  */
        t_I->uc_2AB_UpMinSpect = (uint8) gs_TxFirstChannel;  /*  spectrum minimum frequency upstream */
        t_I->uc_2AB_UpMaxSpect = (uint8) gs_TxLastChannel;   /*  spectrum maximum frequency upstream */
        t_I->uc_2AB_DnMinSpect = (uint8) gs_RxFirstChannel;  /*  spectrum minimum frequency downstream */

        if ( gul_ModeControl & OPTN_ConfigMode_G992_2_AB )
            t_I->uc_2AB_DnMaxSpect = 127;    /*  spectrum maximum frequency downstream for lite only */
        else
            t_I->uc_2AB_DnMaxSpect = (uint8) gs_RxLastChannel;    /* spectrum maximum frequency downstream */
        /* defined as 255 in G992.1-config.h  */
    }



    /* ==== Non-Standard Information Field ==== */
    t_I->uc_NumBlock       = 0;                 /*  number of non-standard blocks */
    for ( i = 0; i < MAX_NUM_NS_BLOCK; i++ )
    {
        t_I->ta_NS_Info[i].uc_NSLen = 0;
    }
}   /*  InitializeInfoField */


