/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hndshk2.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// hndshk2.c
//
// History
//
// 20/08/2010 Sriram Shastry: Fix for disabling the detection of B43 and J43 carrier set with OPTN 25, bitmask 0x4000.
//    By default, this cmv bit is ONE(enable the detection). Besides the fix, in addition to the B43 detection in C-TONES,
//    which is based on power difference between B43 tones and its neighboring tones, we also use B43
//    carrier set to decode C-GLAF1 and C-FLAG1 to double confirm if B43 tones are really transmitted from CO site.
//    Only if B43 carrier set are detected in C-TONES, and C-GLAF1 and C-FLAG1 are correctly decoded, then we think
//    B43 are really transmitted from CO site. It also means CO may support AnnexM mode.
//    Grep for SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection
//
// ******************************************************************

#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "hndshk2.h"
#include "detect.h"
#include "hndshk_Data.h"
#include "memsetbf.h"

void GetSymbol(int16 s_SubBit)
{
   int i;

   for ( i = 0; i < NUM_CARRIERS_IN_SET; i++ ) {
      gta_RxSymbolBuf[i][s_SubBit].s_X = gsa_RxToneBuf[ 2*gsa_DnCarSet[i] ];
      gta_RxSymbolBuf[i][s_SubBit].s_Y = gsa_RxToneBuf[ 2*gsa_DnCarSet[i] + 1 ];
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
//Store the Rx symbols with B43 carrier set.
#ifndef ISDN
      gta_RxSymbolBuf_B43[i][s_SubBit].s_X = gsa_RxToneBuf[2 * gsa_DnCarSetB43_J43[i]];
      gta_RxSymbolBuf_B43[i][s_SubBit].s_Y = gsa_RxToneBuf[2 * gsa_DnCarSetB43_J43[i] + 1];
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
   }
}   /*  GetSymbol */

/********************************************************************************************

  Prototype: void RxAvgCarrierTones(int16 s_reset)

  Description: Function to compute average of HS carriers over FOUR frames.

  Input Arguments:

   s_reset 0 = add to average buffer gt_RxCurrentSymbol
         non-zero = reset average buffer

  Output Arguments:

   N/A

********************************************************************************************/
void RxAvgCarrierTones(int16 s_reset)
{
   int i;

   if(s_reset) {
      MemSetBuffer((short *)(void *)&gt_RxCurrentSymbol,0,0,NUM_CARRIERS_IN_SET*sizeof(Complex_t));
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
#ifndef ISDN
      MemSetBuffer((short *)(void *)&gt_RxCurrentSymbol_B43, 0, 0,
                   NUM_CARRIERS_IN_SET * sizeof(Complex_t));
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
   }
   else {
      for ( i = 0; i < NUM_CARRIERS_IN_SET; i++ ) {
         gt_RxCurrentSymbol[i].s_X += (gsa_RxToneBuf[ 2*gsa_DnCarSet[i] ] + 0x02) >> 2;
         gt_RxCurrentSymbol[i].s_Y += (gsa_RxToneBuf[ 2*gsa_DnCarSet[i] + 1 ] + 0x02) >> 2;
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
//Update the current symbol with B43 carrier set.
#ifndef ISDN
         gt_RxCurrentSymbol_B43[i].s_X +=
            (gsa_RxToneBuf[2 * gsa_DnCarSetB43_J43[i]] + 0x02) >> 2;
         gt_RxCurrentSymbol_B43[i].s_Y +=
            (gsa_RxToneBuf[2 * gsa_DnCarSetB43_J43[i] + 1] + 0x02) >> 2;
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
      }
   }
}
