/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hndshk_Data.c
 *
 *   Global variables associated with hndshk.c.
 *
 *------------------------------------------------------------------------
 */
 //****************************************************************************
//hndshk_Data.c
//
// History
//
//  20/04/2010 Sriram Shastry: Fix for disabling the detection of B43 and J43 carrier set with OPTN 25, bitmask 0x4000.
//             By default, this cmv bit is ONE(enable the detection). Besides the fix, in addition to the B43 detection in C-TONES,
//             which is based on power difference between B43 tones and its neighboring tones, we also use B43
//             carrier set to decode C-GLAF1 and C-FLAG1 to double confirm if B43 tones are really transmitted from CO site.
//             Only if B43 carrier set are detected in C-TONES, and C-GLAF1 and C-FLAG1 are correctly decoded, then we think
//             B43 are really transmitted from CO site. It also means CO may support AnnexM mode.
//             Grep for SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection
//
// 13/03/2012 Kannan: 06/04/2010 Bhadra:   Added code for uinversal ReTx(G.inp section A.2.2) as per Amd5 of G.HS.
//                      Added variables gft_ReTx_ATM_PTM,gft_ReTx_MS_incorrect for validity of MS message in UnivReTx.
//                      Grep for SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod to see changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 10/25/2016 Abu Rahman: XDSLRTFW-2882 : Wrong HS tone selection in case of DPBO (ADSL)
//          A new CTone Detection algorithm is developed which uses Average power of the CTones and their neighboring tones
//            instead of Average constellations of those tones (used in previous implementation).
//            New Tone Detection algorithm is described in GhsCToneDetectionAlgorithm() section.
//            Grep for XDSLRTFW-2882
//*****************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "data_alloc.h" /*** For Socrates ***/
#include "const.h"
#include "typedef_bis.h"

#define _HNDSHK_DATA_H
#include "hndshk_Data.h"

/* =============================================== */
/* global variable declarations */
/* =============================================== */
DATA_MAP_deILV2_BIS
HandShakeControl_t  gt_hsc;                                 /*  handshake control structure */

// Flag indicate the reason code that cause CLR resend
FlagT  gft_SendShortCLR;

// Flag indicate the first CL message or not
FlagT gft_FirstCL;

// Flag indicate the VDSL modes are set in CL
FlagT gft_VDSL_set;

// Used for online detection of GHS carrier set
int16 gs_DetectGhsCarrierSet_State, gs_DetectGhsCarrierSet_AccumCount;
int16 gft_DetectGhsCarrierSet_TonesDetected;
int16 gsa_DetectGhsCarrierSet_DetectCount[NUM_UNIQUE_DS_GHS_CARRIERS_SETS];
/*  carrier set frequencies (see Table 1 of G.994.1) */
/*  subcarriers in the A43 carrier set of the 4.3125 kHz signalling family */
CONSTANT int16 gsa_UpCarSetA43_J43_A43c[NUM_CARRIERS_IN_SET] = {9,17,25};
CONSTANT int16 gsa_UpCarSetB43[NUM_CARRIERS_IN_SET] = {37,45,53};
CONSTANT int16 gsa_DnCarSetA43[NUM_CARRIERS_IN_SET] = {40,56,64};
CONSTANT int16 gsa_DnCarSetB43_J43[NUM_CARRIERS_IN_SET] = {72,88,96};
CONSTANT int16 gsa_DnCarSetA43c[NUM_CARRIERS_IN_SET] = {257,293,337};
/*  subcarriers in the C43 carrier set of the 4.3125 kHz signalling family */
CONSTANT int16 gsa_UpCarSetC43[NUM_CARRIERS_IN_SET] = {7,9,9};
CONSTANT int16 gsa_DnCarSetC43[NUM_CARRIERS_IN_SET] = {12,14,64};

// Flag to indicate to set up or not to set up the Spar1 bit of ID field with Relative power
// levels of A43c and J43 carriers
FlagT gft_SkipSetUpOfA43cJ43_InIDField = 0;

DATA_MAP_END//DATA_MAP_deILV2_BIS

/* we shall set this online by inspecting C_Tones for all possible GHS DS carrier sets */
int16 *gsa_DnCarSet;


DATA_BULK_DATA2_BEGIN
//XDSLRTFW-2882 : Wrong HS tone selection (Start)
uint32 gula_GhsTonePower[9] = {0};      // Contains average tone power values in linier format
uint32 gula_GhsToneNoisePower[9] = {0}; // Contains avegage neighboring tones noise power value in linier format

GhsCToneInfo_t gt_GhsCToneInfo[9];
int16 gs_DetectedCTones = -1;  // -1 : No CTones, 0: A43 CTones, 1: B43 CTones, 2: A43C/B43C CTones
int16 gsa_ChannelEstimateBkp[1024]; // XDSLRTFW-3974 holds a copy of the signal during the first channel estimation
//XDSLRTFW-2882 : Wrong HS tone selection (End)

//XDSLRTFW-3706 VRx518 R4 ADSL AnnexA compilation problem (Start)
// Move variables from persistent memory to BULK_DATA2 memory
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
Complex_t gt_RxCurrentSymbol_B43[NUM_CARRIERS_IN_SET];  /* current bit symbol for RX */
Complex_t gt_RxLastSymbol_B43[NUM_CARRIERS_IN_SET]; /* last bit symbol for RX */
Complex_t gta_RxSymbolBuf_B43[NUM_CARRIERS_IN_SET][RX_SYMBOL_BUF_SIZE];
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
//XDSLRTFW-3706 VRx518 R4 ADSL AnnexA compilation problem (End)


DATA_MAP_END


uint8 guca_FE_ModeCapabilities[6];

DATA_MAP_deILV2_BIS
Complex_t gt_RxCurrentSymbol[NUM_CARRIERS_IN_SET];             /*  current bit symbol for RX */
Complex_t gt_RxLastSymbol[NUM_CARRIERS_IN_SET];                /*  last bit symbol for RX */
uint8 gft_WholeTxMsgComplete; /* flag indicate that we have whole tx msg complete or not. TRUE: complete */
int16 gs_MsgOctetCnt;         /* the actual msg octet count in transmision */
int16 gs_MsgOffset; // msg segment offset, we have to record the offset of each msg segment in the actual complete msg
DATA_MAP_END

int16 gs_TxAn_Prev;                                   /*  last bit symbol for xceiver */
uint8 guc_TxOctet;                                    /*  Octet buffers for Tx */
uint8 guc_RxOctet;                                    /*  Octet buffers for Rx */

//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
#ifndef ISDN
uint8 guc_RxOctet_B43;
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
DATA_MAP_deILV1_BIS  //guca_HndshkBuf is now the only buffer that exist in deILV1_BIS
// Map the handshake data memory into Data Interleave Buffer (Socrates Only)
uint8 guca_HndshkBuf[8704];
DATA_MAP_END

/* ---- message arrays ---- */
uint8* gpuca_RxMsgBuf;  //size: MESSAGE_BUF_LEN                /*  received octets are first stored in this buffer */
uint8* gpuca_DecodeBuf; //size: DECODE_BUF_LEN                 /*  message decoding is performed on this buffer */
uint8* gpuca_TxMsgBuf;  //size: MESSAGE_BUF_LEN                /*  current message segment being transmitted */
int16 gs_TxMsgBufCnt;                                 /*  number of octets in a message to be transmitted */
int16 gs_RxMsgBufCnt;                                 /*  number of octets of a received message frame segment */
int16 gs_DecodeBufCnt;                                /*  number of octets in a total message being decoded */

/* ---- structures containing information fields ---- */
InfoField_t* gpt_RxInfo;                                    /*  Rx side */
InfoField_t* gpt_RxInfoSave;                                /*  to save a RxInfo for monitoring purpose */
InfoField_t* gpt_TxInfo;                                    /*  Tx side */
InfoField_t* gpt_TxInfoSave;                                /*  to save a TxInfo for monitoring purpose */
int16        gs_MaxMsgLen;                                              /*  maximum message length */
uint8    guc_TxHSMsg_SegmentCnt;                         // Tx Msg Segment counter
uint8    guc_RxHSMsg_SegmentCnt;                         // Rx Msg Segment counter
FlagT gft_TxRetransmit_Msg;                                    // Flag indicate we are requested to retransmit last msg segment
FlagT gft_RxRetransmit_Msg;                                    // Flag indicate we received the retransmitted msg segment we ask for
uint8 guc_RxHSReqRtx_cnt;                                   // The received HS REQ_RTX msg counter
uint8 guc_TxHSReqRtx_cnt;                                   // The transmitted HS REQ_RTX msg counter

/* --- structure of handshake info that are just for printing test trail file --- */
/* The reason that we have to specify the static global arrays below is that we are now putting
 the handshake information arrays into re-useable buffer, which will be updated before handshake
 and after handshake. Therefore, the handshake information will lost when the handshake finishes,
 which is impossible for generating trail file in connectivity tests. So we add the following
 extra buffers to save the handshake information just for trail-printing purpose.*/
DATA_MAP_SIM   /*** Socrates symbol for mapping data below to simulation memory ***/
#ifdef LEAVE_TRAIL
InfoField_t  gt_TrailRxInfoSave;                      /* RxInfo saved */
InfoField_t  gt_TrailTxInfoSave;                      /* TxInfo saved */
InfoField_t  gt_TrailMSInfo;                                    /* MS Info */

/* The global variables below are the actual buffers to save the Vendor Spec in the trail Rx, Tx Info */
/* Note: in InfoField_t, there is a phantom pointer to a buffer, trying to save Vendor Spec. But */
/* it does't have actual address until it is initialized to the address below. */
uint8 guca_RxSaveNSVendorSpec[MAX_NUM_NS_BLOCK][MAX_NS_VENDOR_INFO_LEN];/* RxInfo saved */
uint8 guca_TxSaveNSVendorSpec[MAX_NS_VENDOR_INFO_LEN];               /* TxInfo saved */

Adsl2AllInfo_t gta_TrailRxSaveG9923xInfo[NUM_G992_3_ANNEX_SUPPORTED];          /* substructure of BIS info */
Adsl2AllInfo_t gta_TrailRxSaveG9925xInfo[NUM_G992_5_ANNEX_SUPPORTED];         /* substructure of BIS info */
Adsl2AllInfo_t gta_TrailTxSaveG9923xInfo[NUM_G992_3_ANNEX_SUPPORTED];          /* substructure of BIS info */
Adsl2AllInfo_t gta_TrailTxSaveG9925xInfo[NUM_G992_5_ANNEX_SUPPORTED];         /* substructure of BIS info */
Adsl2AllInfo_t gta_TrailMSInfoG9923xInfo[NUM_G992_3_ANNEX_SUPPORTED];          /* substructure of BIS info */
Adsl2AllInfo_t gta_TrailMSInfoG9925xInfo[NUM_G992_5_ANNEX_SUPPORTED];         /* substructure of BIS info */
#endif
DATA_MAP_END   /*** Socrates symbol for mapping data above to simulation memory ***/


/*** Socrates BIS handshake debug info ****/
DATA_MAP_deILV2_BIS
int16 gs_MS_source = -1;                              /* Flag to indicate who send MS */

Complex_t gta_RxSymbolBuf[NUM_CARRIERS_IN_SET][RX_SYMBOL_BUF_SIZE];  /*  memory of complex valued DMT symbols */

DATA_MAP_END
                                                   /*  for designated carrier bins in Rx */
uint16 gus_GhsPgaSetDown;/* indicates how many times pga was reduced from its initial value in handshake */
int16 gs_MaxFreqDomainValue;
uint8 guc_PgaState;
int16 gs_SetPgaForTones_State;
int16* gpsa_RxToneBuf_sav;

int16 gs_US_PwrCutback_EchoLoop;
int16 gs_us_cutback;
int16 gs_Initial_PGA_AnnexL;
FlagT gft_EchoLoop;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
#ifdef UNV_RETX_GHS
FlagT gft_ReTx_ATM_PTM;
#endif
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

//Variables for LATN estimation in GHS
int32 gl_hsk_tone_power;
int16 gs_hsk_tone_power_dB;
int16 gs_hsk_tone_power_dB_PCB; // CTones power with considering power cutback used by CO during G.hs.
//XDSLRTFW-3487(Start)
// Debug Variables
int16 gs_hsk_tone_power_threshold = 0x4297; // MINIMUM_GHS_TONE_PWR_AT_1100M = 0x4297 defined in hndshk_Data.h
uint8 guca_dbg_BlackOutTones[4] = {0xFF,0xFF,0xFF,0xFF};
//XDSLRTFW-3487(End)

//int16 gs_hsk_power_dB_Comp; // Used for matching Reference platforms "gs_hsk_tone_power_dB" used for several fixes so matching with Ref platforms required for ex; DSPCB
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
#ifdef UNV_RETX_GHS
FlagT gft_ReTx_MS_incorrect;
#endif
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

// Number of cleardown flags before the GALFs are sent (in the usual RT initiated cleardown)
int16 gs_num_cleardown_flags = NUM_CLEARDOWN_FLAG ;
int16 gs_num_cleardown_flags_short = 5 ;           // triggered against BDCM

/* These variables are used in handshake to indicate if the co modem on the other side */
/* implements older handshake spec or not. The new spec transmits >1 octets in the  */
/* SPar1 of identification field where as the old on transmits only 1 octet */
uint8 guc_Received_Only_One_Octet_In_ID_Field;
uint8 guc_Received_Only_One_Octet_In_SI_Field;

DATA_MAP_deILV2_BIS

uint8 guc_DecodeMsgState;  /* global variable to indicate the status of bkgd DecodeMessage */
uint8 guc_MsgHandlerState; /* global variable to indicate the status of bkgd HSMsgHandler */

DATA_MAP_END

#if defined(DANUBE) || defined(ADSL_62)
DATA_MAP_ILV1_GHS
#else
DATA_BULKO2_BEGIN
#endif

HS_Encode_ADSL2_t   gta_HS_ADSL2[NUM_KNOWN_ADSL2_SPAR1_BITS] = {
   /*
   Format:
   {octet, bit in octet, idx in ADSL2 struct, Bis/Plus, t_hsc.SelectedMode, CnfigBit(0:not supported)}
   Note:
   octet, bit and CnfgBit have to be properly set for ALL members !!!
   */
#ifndef ISDN

    {2, G992_3_A>>16, G992_3_ANNEX_A,  0, G992_3_A_FULL_INIT,  OPTN_ConfigMode_G992_3_A},
    {2, G992_3_B>>16, 0,            0, G992_3_B_FULL_INIT,  0},
    {2, G992_3_I>>16, G992_3_ANNEX_I,  0, G992_3_I,         OPTN_ConfigMode_G992_3_I},
    {2, G992_3_J>>16, 0,            0, G992_3_J,         0},
   {2, G992_4_A>>16, 0,          0, G992_4_A,         0},
   {2, G992_4_I>>16, 0,          0, G992_4_I,         0},
   {2, 0x40,      0,          0, 0,             0},

    {3, G992_5_A>>24, G992_5_ANNEX_A,  1, G992_5_A,         OPTN_ConfigMode_G992_5_A},
    {3, G992_5_B>>24, 0,            1, G992_5_B,         0},
    {3, G992_5_I>>24, G992_5_ANNEX_I,  1, G992_5_I,         OPTN_ConfigMode_G992_5_I<<16},
    {3, G992_3_M>>24, G992_3_ANNEX_M,  0, G992_3_M,         OPTN_ConfigMode_G992_3_M},
    {3, G992_5_J>>24, 0,            1, G992_5_J,         0},
   {3, 0x20,      0,          0, 0,             0},
   {3, 0x40,      0,          0, 0,             0},

    {4, G992_5_M,    G992_5_ANNEX_M,   1, G992_5_M|HS_CHECK_2ND_32BITS, OPTN_ConfigMode_G992_5_M<<16}

#else // ISDN

    {2, G992_3_A>>16, 0,            0, G992_3_A_FULL_INIT,  0},
    {2, G992_3_B>>16, G992_3_ANNEX_B,  0, G992_3_B_FULL_INIT,  OPTN_ConfigMode_G992_3_B},
    {2, G992_3_I>>16, 0,            0, G992_3_I,         0},
    {2, G992_3_J>>16, G992_3_ANNEX_J,  0, G992_3_J,         OPTN_ConfigMode_G992_3_J},
   {2, G992_4_A>>16, 0,          0, G992_4_A,         0},
   {2, G992_4_I>>16, 0,          0, G992_4_I,         0},
   {2, 0x40,      0,          0, 0,             0},

    {3, G992_5_A>>24, 0,            1, G992_5_A,         0},
    {3, G992_5_B>>24, G992_5_ANNEX_B,  1, G992_5_B,         OPTN_ConfigMode_G992_5_B},
    {3, G992_5_I>>24, 0,            1, G992_5_I,         0},
    {3, G992_3_M>>24, G992_3_ANNEX_M,  0, G992_3_M,         OPTN_ConfigMode_G992_3_M},
    {3, G992_5_J>>24, G992_5_ANNEX_J,  1, G992_5_J,         OPTN_ConfigMode_G992_5_J<<16},
   {3, 0x20,      0,          0, 0,             0},
   {3, 0x40,      0,          0, 0,             0},

    {4, G992_5_M,    G992_5_ANNEX_M,   1, G992_5_M|HS_CHECK_2ND_32BITS, OPTN_ConfigMode_G992_5_M<<16}

#endif

/*
#ifndef ISDN
    {2, G992_3_A>>16, G992_3_ANNEX_A, 0, G992_3_A_FULL_INIT, OPTN_ConfigMode_G992_3_A},
    {2, G992_3_I>>16, G992_3_ANNEX_I, 0, G992_3_I, OPTN_ConfigMode_G992_3_I},
    {3, G992_3_M>>24, G992_3_ANNEX_M, 0, G992_3_M, OPTN_ConfigMode_G992_3_M},
    {3, G992_5_A>>24, G992_5_ANNEX_A, 1, G992_5_A, OPTN_ConfigMode_G992_5_A},
    {3, G992_5_I>>24, G992_5_ANNEX_I, 1, G992_5_I, OPTN_ConfigMode_G992_5_I<<16},
    {4, G992_5_M, G992_5_ANNEX_M, 1, G992_5_M | HS_CHECK_2ND_32BITS, OPTN_ConfigMode_G992_5_M<<16}
#else//ISDN
    {2, G992_3_B>>16, G992_3_ANNEX_B, 0, G992_3_B_FULL_INIT, OPTN_ConfigMode_G992_3_B},
    {2, G992_3_J>>16, G992_3_ANNEX_J, 0, G992_3_J, OPTN_ConfigMode_G992_3_J},
    {3, G992_3_M>>24, G992_3_ANNEX_M, 0, G992_3_M, OPTN_ConfigMode_G992_3_M},
    {3, G992_5_B>>24, G992_5_ANNEX_B, 1, G992_5_B, OPTN_ConfigMode_G992_5_B},
    {3, G992_5_J>>24, G992_5_ANNEX_J, 1, G992_5_J, OPTN_ConfigMode_G992_5_J<<16},
    {4, G992_5_M, G992_5_ANNEX_M, 1, G992_5_M | HS_CHECK_2ND_32BITS, OPTN_ConfigMode_G992_5_M<<16}
#endif//ISDN
*/
};
DATA_MAP_END//DATA_BULKO2_BEGIN

