/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_mesg.c
 *
 *   Message handling functions used in Handshaking.
 *
 *-------------------------------------------------------------------------
 */
#include <string.h>
#include "common.h"
#include "hndshk_Data.h"



/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: CopyInfoField
 *
 *  Abstract:
 *
 *  CopyInfoField() - Copy source Information Field structure to a
 *  to a target Information Field
 *
 *  Parameters:
 *      InfoField *t_Source : information to be copied from
 *      InfoField *t_Target : information to be copied to
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *    The third argument (s_CopyNS) is used to control the copying of the
 *    NonStandard information.  Typically it is TRUE, except for the copying
 *    of the debug gt_Trail... structures, where it is not DM-efficient to
 *    allocate the necessary buffers.
 *-------------------------------------------------------------------
 *^^^
 */
void CopyInfoField(InfoField_t *t_Source, InfoField_t *t_Target, int16 s_CopyNS) {

    int i;
   uint8*  puc_temp_NSVendorSpec[5];
   Adsl2AllInfo_t *pta_G9923xInfo[NUM_G992_3_ANNEX_SUPPORTED];
   Adsl2AllInfo_t *pta_G9925xInfo[NUM_G992_5_ANNEX_SUPPORTED];

    /* ==== Save Non-Standard Information Vendor Spec Field ==== */
   if (s_CopyNS) {
      for (i = 0; i < t_Source->uc_NumBlock; i++)
         puc_temp_NSVendorSpec[i] = t_Target->ta_NS_Info[i].puca_NSVendorSpec;
   }

    /* ==== Save Adsl2AllInfo Field ==== */
   for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED ; i++) {
      pta_G9923xInfo[i] = t_Target->pta_G9923xInfo[i];
   }
   for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED ; i++) {
      pta_G9925xInfo[i] = t_Target->pta_G9925xInfo[i];
   }

    /* ==== Memcopy entire Info Field ==== */
   memcpy(t_Target, t_Source, sizeof(InfoField_t));

    /* ==== Restore Adsl2AllInfo Field ==== */
   for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED ; i++) {
      t_Target->pta_G9923xInfo[i] = pta_G9923xInfo[i];
      memcpy(t_Target->pta_G9923xInfo[i], t_Source->pta_G9923xInfo[i], sizeof(Adsl2AllInfo_t));
   }
   for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED ; i++) {
      t_Target->pta_G9925xInfo[i] = pta_G9925xInfo[i];
      memcpy(t_Target->pta_G9925xInfo[i], t_Source->pta_G9925xInfo[i], sizeof(Adsl2AllInfo_t));
   }

    /* ==== Restore Non-Standard Information Vendor Spec Field ==== */
   if (s_CopyNS) {
      for ( i = 0; i < t_Target->uc_NumBlock; i++ ) {
         t_Target->ta_NS_Info[i].puca_NSVendorSpec = puc_temp_NSVendorSpec[i];
         memcpy(t_Target->ta_NS_Info[i].puca_NSVendorSpec, t_Source->ta_NS_Info[i].puca_NSVendorSpec, MAX_NS_VENDOR_INFO_LEN);
      }
   }

}   /*  CopyInfoField */



