/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_mesg.c
 *
 *   Message handling functions used in Handshaking.
 *
 *-------------------------------------------------------------------------
 */
// ******************************************************************
//  hs_mesg.c
//
// History
//
// 05/08/2010 Nihar : As per Amend2 to  G.994.1 standard New encoding and decoding Par2 level structure is added
//          to support coding guideline for NPar2 Block. Last decoded octet is terminated with the Delimiter.
//          Also Extract the 5th bit to receive INP Reporting from CO
//       Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
//  16/07/2010 Bhadra/Sriram : Feature development, Support optional upstream interleaver depth in a standard complaint way.
//              Added new code pointer as per Amendment 3 to G.994.1 standard. New code pointers supporting US PMS-TC Latency
//              path#0 indicating NPAR3 Octets in CLR Msg . It Tx D0 max values supported value are  2,6,14
//              Also added NPAR3 octet for decoding the US PMS-TC Latency#0 in CL Msg.
//          Grep for XDSLRTFW-148: Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth
//
// 31/7/2010 Nihar: It was seen at FT that the CNXT D57 Dslam was configured to INP = 2.0 but it was only sending
//             this INP in the CL message and not the MS message. Since we use the MS message,
//              we were always training at INP=0.
//              By default, this fix is enabled. To disable it reset bit 8 of INFO 103 1
//              Grep for IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading
//
// 27/07/2010 Nihar/Bhadra: Send TI (TSTC) vendor-id along with TI's non-standard information
//                   when connecting against TI-AC7 and send Aware (AWRE) vend-id when
//                   connecting against CNXT in ADSL2/2+ mode after a reboot for better US performance.
//                   Grep for IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid
//
// 10/08/10   ChihWen/Bhadra: Ignoring multiple bits in MS identification/Standard field Spar1,
//               taking the bit appearing in both CL and MS instead
//               Grep for R3_P1: IOP_DS_ALL_CNXT_IgnoreMultBitsMsDELT
//
// 12/08/2010 AdeelJ/Sriram/Bhadra: To use the existing SRA code for 1 step SRA based on CMV
//           INFO 103 20 bit mask 0x0001.The SRA step size is increased
//           to maximum if this cmv is set.
//             In this file we conditionally bypass framing check for one step SRA.
//             Grep for SMS01221899 Feature_DS_All_All_EnableOneStepSRA
//
// 10/08/2010 Nihar: Send IFFT size in NPar3 message for ADSL2/2+ against all COs
//                   Grep for IOP_ALL_BisPlus_ALL_SendIFFTSizeInNPar3
//
// 20/04/2010 Sriram Shastry: Fix for disabling the detection of B43 and J43 carrier set with OPTN 25, bitmask 0x4000.
//    By default, this cmv bit is ONE(enable the detection). Besides the fix, in addition to the B43 detection in C-TONES,
//    which is based on power difference between B43 tones and its neighboring tones, we also use B43
//    carrier set to decode C-GLAF1 and C-FLAG1 to double confirm if B43 tones are really transmitted from CO site.
//    Only if B43 carrier set are detected in C-TONES, and C-GLAF1 and C-FLAG1 are correctly decoded, then we think
//    B43 are really transmitted from CO site. It also means CO may support AnnexM mode.
//    Grep for BugFix_ALL_ALL_ALL_DisableB43J43Detection
//
//  29/09/2010 Nihar: Prevent VDSL FW to start if AFE register is fused to a defined value.
//                          This is a way to use the VR9 as AR10 till the time AR10 is officially available.
//                      Grep for XDSLRTFW-178
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
//
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// 15/07/2011 Kannan: T1413 bring up and T1413 mode loop length estimation.
//           Grep for XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup
//
// 9/09/2011 Anantha Ramu: Added feature to try GHS MAX_ALLOWED_GHS_FAILS times before trying T1413
//                         if T1413 is one of the configured modes in CPE.
//                         Grep for  XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL
//
// 17/11/11 ChihWen/Bhadra: SRA fail against CNXT Annex-A LC (FW E67.1.64). To fix it,
//                => send GHS non-standard info in CLR as AR7 (FW 7.04.03) when against CNXT Annex-A LC.
//                => do not send spectrum bound/shaping when against CNXT Annex-A LC
//             By default, its disabled. To enable it, cw INFO 103 1 0x4000
//             Grep for SMS00805497 IOP_DS_BisPlus_CNXT_SRAFailGhsNonStandard
//
// 30/12/2011 Sriram Shastry : Indicate VDSL2 annex bit and the corresponding Full CLR code points in handshake  during Full CLR message
//    Grep for  XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg
//
// 23/12/2011 Sabrina Y/Balabath : To improve US performance, retrain and switch to Aware VID
//            for IKNS DSLAMs.
//            Grep for XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE
//
// 17/01/2012 Shakil: Issue: When CNXT-CO is configured with INP>2 the resulting DS INP used for the framing
//    parameter generation is always INP=2. This happens only with CNXT-DSLAMs.
//    Root cause:From CO_CL message Octet #8: 0x0E (bits 2-3 are bits 0-1 of INP-coding)
//    Octet #9: 0x41 (bits 0-5 are bits 2-7 of INP-coding).The CNXT workaround IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading
//    stores the INP information of C-CL in a global variable guc_CL_minINP and uses this input instead of the C-MS INP
//    data for bitloading. FW stores the data in guc_CL_minINP after analysing octet #8 (bits 0-1 of complete INP coding)
//    but unfortunately before decoding octet #9 which contains bits 2-7 of the INP coding. So all information of octet #9 - meaning all INP>2 settings will be decoded to INP=2.
//    Solution: Move global variable guc_CL_minINP after decoding of octet #9
//          Grep for XDSLRTFW-386 IOP_DS_BisPlus_CNXT_WrongINPConfig
//
// 12/12/2011 Vinjam: CMV controls to enable/disable upstream enhanced framing feature moved to DSL 13 Bit-1 (Mask: 0x0002)
//        Grep for XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup
//
//// 10/01/2012:Balabath:Enhance_DM_Optimisation
//
// 17/01/2012 Shakil: Issue: When CNXT-CO is configured with INP>2 the resulting DS INP used for the framing
//    parameter generation is always INP=2. This happens only with CNXT-DSLAMs.
//    Root cause:From CO_CL message Octet #8: 0x0E (bits 2-3 are bits 0-1 of INP-coding)
//    Octet #9: 0x41 (bits 0-5 are bits 2-7 of INP-coding).The CNXT workaround IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading
//    stores the INP information of C-CL in a global variable guc_CL_minINP and uses this input instead of the C-MS INP
//    data for bitloading. FW stores the data in guc_CL_minINP after analysing octet #8 (bits 0-1 of complete INP coding)
//    but unfortunately before decoding octet #9 which contains bits 2-7 of the INP coding. So all information of octet #9 - meaning all INP>2 settings will be decoded to INP=2.
//    Solution: Move global variable guc_CL_minINP after decoding of octet #9
//          Grep for XDSLRTFW-386 IOP_DS_BisPlus_CNXT_WrongINPConfig
//
// 03/02/2012 Sriram Shastry : Send the VDSL Code points in Short CLR message with full transmit capability.
//    Grep for  Enhc_AB_ALL_ALL_ALL_VDSL_HSK_InADSLShortCLR_Msg
// 13/03/2012 Kannan: 08/04/2010 Bhadra: Added code for uinversal ReTx(G.inp section A.2.2) as per Amd5 of G.HS.
//                      Code was added under the CMV info 110 0 (0x100) =>CMV_BIT_INDICATE_RETX
//                      Grep for SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod to see changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 07/06/2012: Vinjam/Sriram: Added code to extract the virtual noise break points from CL message.
//       Added CMV control (DSL 0 Bit-0(0x1)) for sending virtual noise feature's
//             support in CLR message & to extract the number of virtual noise break points in CL message.
//    Number of downstream virtual noise break points are stored in "gus_NumbDsVnBrkPoints".
//             Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 09/11/2012 Bhadra ported from ADSLRTFW-1403(ChihWen): Workaround for the handshaking failure against FG10 BDCM CO.
//            FG10 BDCM CO will drop the link (sending NAK-CD) once CLR (multi-mode with AnnexM) is received.
//            So the workaround is to clear AnnexM in CLR once it is BDCM CO and B43 carrier is not correctly detected/decoded.
//            Grep for XDSLRTFW-546 IOP_GHS_ClearAnnexMinCLR

//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline.
//            To avoid long training times in ADSL mode and too early false mode switches to VDSL binary,
//             FW sends the intentional retrain information (using a global variable guc_Forced_Retrain) to SW/DSL API.
//            Code changes connected to Jira XDSLRTFW-248" and Jira XDSLRTFW-255)
//             Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
// 5/4/2013 Enable images for Cnxt .. send only single image
//          XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 31/07/2013 Vinjam : if vectoring information is send in SPAR2 then send corresponding vectoring information and Delimter2 in NPAR3.
//                     Bug was, Delimter2 was not set in NPAR3 along with vectoring information.
//                     Grep for XDSLRTFW-1128 Bug_AB_All_All_All_AddDelimter2ToNpar3
//
// 13/09/2013 Prashant : Fix for XDSLRTFW-1228 - G.Hs code pointer for upstream vectoring support is not transmitted in ADSL mode.
//                     Grep for XDSLRTFW-1228 Feature_AB_All_All_All_SendUSVectorCodePointerInGHs
//
// 24/01/2014 Balabath :- Correction of bugs and implementation as per the ErasureDecoding implementation
//                      -Change of Default settings of DSL 1 0 CMV settings
//                      - IOP issues resolved with EBLT-C
//                      for Code Changes grep for " XDSLRTFW-1502 "
// 12/02/2015 : Ported ADSLRTFW-745 (SMS00778928): Retrain for CTLM VID so that we can send the TI VID
//                 Grep for: XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID
//
// 21/03/2014 Prashant :- Fix for XDSLRTFW-1653 - Link fails in G.Hs (continously) if DS ReTx feature is enabled on Vinax Rev 2.2M
//                        As per the the G.inp statndard section "A.2.1.2" If  the Downstream  ATM  TPS-TC  #0  RETX  or  the Downstream
//                        PTM  TPS-TC #0  RETX Spar(2) bit  is  set  to  ONE  in  the  MS  message,  then  all Downstream  STM  TPS-TC  #n,
//                   Downstream ATM TPS-TC #n, and Downstream PTM TPS-TC #n Spar(2) bits (for n = 0, 1, 2, and 3) shall be set to ZERO
//                in the MS message, But with Vinax Rev2.2 Co these bits are set in MS message causing CPE to drop link
//                with "E_CODE_GHS_DS_STM_ATM_PTM_SetInReTx" Exception. Right now the code for raising this exception is commented
//                        out to proceed further with parsing of ghs messages.
//                        Grep for XDSLRTFW-1653
//
// 03/07/2014 Fuss : Skip reserved bit of ID_SPar1 octet 1 (Note: In array it is element 0)
//                   Grep for XDSLRTFW-1892
//
// 06/02/2015 Vinay : Added NPar2 octet 2 to convey AELEM capability in GHs VDSL Part.
//                    Grep for XDSLRTFW-1624
//
// 24/03/14 Hanyu: Ported ADSLRTFW-745 (SMS00778928): Retrain for CTLM VID so that we can send the TI VID
//                 Grep for: XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID
//
// 24/03/14 Hanyu: Ported ADSLRTFW-1419: It takes Litespan D4EP, with all ports enabled, ~60s to restart
//            if there is any retrains during training. To meet customer requirements,
//            we made following two changes.
//            1. Took out the unnecessary retrain for all non-CTLM DSLAMs during GHS.
//            2. Added CMV bit-14 of info 103 26 to control the retrain logic for
//            TIVID change with GHS0000 DSLAMs.
//            By default, this CMV is set to 1 (enabled).
//            For LiteSpan D4EP DSLAM with all ports enabled, this bit should be set
//            to 0 to shorten training time after power up.
//            Grep for XDSLRTFW-1590 IOP_A_DS_ALL_ShortenTrainingTime_AfterPowerup
//
// 25/03/2014 Hanyu: Ported ADSLRTFW-1392: Marconi MX QDC-1 sends out an undefined G.994.1
//            Vendor ID in CL standard field and "ALCB" only in non-standard
//            field. FW has to link this CO to ALCB and apply a special sync
//            symbol scaling to avoid link drop.
//            Grep for XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4
//
//  30/3/2015 Sriram Shastry:Jira XDSLRTFW-1843 :CPE  is unable to  link in ADSL2/ADSL2P under Multi-mode configuration.
//  Solution is force CPE  to  G.DMT  mode after 3 fails attempts during  training in ADSL2/ASDL2P mode.
//    Grep for  XDSLRTFW-1843
//
// 12/10/2015 Vinay: Added code to support G.Fast in ADSL G.Hs session.
//            Grep for XDSLRTFW-2298
// *******************************************************************************************************************************************

#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ghs.h"
#include "ifft_fix.h"
#include "hndshk_Data.h"
#include "spectral_shape_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "trail.h"
#include "cmv.h"
#include "states.h"
#include "DebugBuffer.h"
#include "hndshk1.h"
#include "act_T1413.h"
#include "const.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


extern HS_Encode_ADSL2_t   gta_HS_ADSL2[];


/* =============================================== */
/* static function prototypes */
/* =============================================== */
int16 FormStandard(  InfoField_t *t_Info, uint8 uca_M[], int16 idx );
int16 FormNonStandard( InfoField_t *t_Info, uint8 uca_M[], int16 idx );
int16 DecodeStandard( uint8 uca_M[], int16 idx, int16 s_MsgLen, InfoField_t *t_Info );
int16 DecodeNonStandard( uint8 uca_Msg[], int16 idx, int16 s_MsgLen, InfoField_t *t_Info );

int16 FormPmdSpectrumBoundParameters(PMD_Type_t *pt_PmdType, uint8 *puc_M, int16 idx);
int16 FormPmdSpectrumShapeParameters(PMD_Type_t *pt_PmdType, uint8 *puc_M, int16 idx, int16 s_num_tssi_values);
//XDSLRTFW-1502 (start_end)
int16 FormTpsTCParameters(TPS_TC_Type_t *pt_TpsTcType, uint8 *puc_M, int16 idx, uint16 type ,int16 s_isDS);
int16 FormPmsTCParameters(PMS_TC_LatencyPath_t *pt_LatencyPath, uint8 *puc_M, int16 idx);
int16 DecodePmdSpectrumBoundParameters(PMD_Type_t *pt_PmdType, uint8 *puc_M, int16 idx, int16 s_MsgLen);
//XDSLRTFW-1502 (start_end)
int16 DecodeTpsTCParameters(TPS_TC_Type_t *pt_TpsTcType, TPS_TC_Type_t *pt_TpsTcType_Tx, uint8 *puc_M, int16 idx, int16 s_MsgLen, uint16 type, int l_isDS, int l_isPlus, uint8 uc_msg);
int16 DecodePmsTCParameters(PMS_TC_LatencyPath_t *pt_PmsTcLatencyPath, uint8 *puc_M, int16 idx, int16 s_MsgLen);
void ZeroTpsTCParameters(TPS_TC_Type_t *pt_TpsTcType);
int16 AddTpsTcInfo(int16 s_bc, Adsl2AllInfo_t *pt_BisInfo, uint8 *puc_M, int16 idx);
int16 AddPmsTcInfo(int16 s_lp, Adsl2AllInfo_t *pt_BisInfo, uint8 *puc_M, int16 idx);
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
#ifdef UNV_RETX_GHS
int16 AddReTxTpsTcInfo(
   int16 s_bc,
   Adsl2AllInfo_t * pt_BisInfo,
   uint8 * puc_M,
   int16 idx);
#endif
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
// Below code is commented as it is not initialized. VDSL2 Firmware does not send this code in its CLR message.So ADSL Full CLR with VDSL2 CLR code
// points are mimced.
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(Start)
#ifdef VDSL2_HSK
void PackBandInfo2MsgBuf(uint8 uca_M[], int16 *ps_idx, uint8 *uca_BandInfo, uint8 uc_NumBands);
#endif
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(End)
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start_End)
#ifdef ADSL_BONDING
void PrepareCLR_BONDING(void);
#endif
//Enhance_DM_Optimisation (start) moved to gdata.c
//uint8 guc_temp_vdsl2_mode[3] = {0};
//uint8 guc_temp_vdsl2_mode1 =0x3F;
//Enhance_DM_Optimisation (end) moved to gdata.c
/*
 *------------------------------------------------------------------------
 *
 *  Name: FormMessage
 *
 *  Abstract:
 *
 *  FormMessage() - Enclose an information field in an arrary.
 *  Block delimiters, FCS, and octet transparency are handled.
 *
 *  Parameters:
 *      const InfoField *t_Info : information to be packed
 *      uint8 uca_Msg[]         : output arrary containing the information
 *
 *  Returns:    Number of octets encoded into an array including FCS, octets
 *              inserted for octet transparency, and prefix and postfix FLAGs.
 *
 *  Global Variables Used: none
 *
 *------------------------------------------------------------------------
 */
int16 FormMessage( InfoField_t *t_Info, uint8 uca_Msg[] )
{

    int idx, i, s_maxMsgLen;
    idx = 0;

    gft_WholeTxMsgComplete = FALSE;
    gs_MsgOffset = 0;
    gs_MsgOctetCnt     = 0;

    if (t_Info->uc_Type == M_CLR) s_maxMsgLen = MAX_COMPLETE_CLR_MESSAGE_LEN;
    else  s_maxMsgLen = MAX_COMPLETE_MESSAGE_LEN;

    // Whenver we start to form new msg, reset the Tx msg segment counter first
    guc_TxHSMsg_SegmentCnt = 0;

    gt_hsc.s_TxNSBCnt = 0;  /*  reset nonstandard block counter */


    /* ---- Message type field ---- */
    uca_Msg[idx++] = t_Info->uc_Type;

    /* ---- Revision number ---- */
    if (((gs_CurrentCoChipset == GENERIC_CO_CHIPSET) || (gs_CurrentCoChipset == ALA_CO_CHIPSET))   && (gpt_RxInfoSave->uc_Rev==1))
    {
        uca_Msg[idx++] = 1;         // G.dmt ALAs cannot handle MS with Revision number greater than 1
    }
    else
    {
        uca_Msg[idx++] = t_Info->uc_Rev;
    }


#ifndef ISDN   // Only for Annex-A
    // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (Start)
   if ((gft_USPerf_AC7 == 0x1) && (gft_SendShortCLR == FALSE))
        // Sriram : Send TI NSIF Only for Full CLR i.e transmit NSIF info
        // after Standard information is transmitted,
   {
        // Send the Non-Standard information to AC7, otherwise it see the CPE as only AR5!
        t_Info->uc_ID_NPar1 = NON_STANDARD;
        t_Info->uc_NumBlock = 1;
        t_Info->ta_NS_Info[0].uc_NSLen = 0x0B;
        t_Info->ta_NS_Info[0].puca_NSVendorSpec[0] = 0x0E; // AR7 Annex-A
        t_Info->ta_NS_Info[0].puca_NSVendorSpec[1] = 0x00;
        t_Info->ta_NS_Info[0].puca_NSVendorSpec[2] = 0x00;
        t_Info->ta_NS_Info[0].puca_NSVendorSpec[3] = 0x00;
        t_Info->ta_NS_Info[0].puca_NSVendorSpec[4] = 0x80; // To differentiate AR8 from AR7 for
        // future AC7 firmware
   }
    // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (End)
   // SMS00805497 IOP_DS_BisPlus_CNXT_SRAFailGhsNonStandard (Start)
   if ((gft_SRAIop_CNXT == 0x1) && (t_Info->uc_Type == M_CLR) && (gt_INFX_CMV.s_DFE_Options & CMV_TO_ENABLE_CNXT_SRA_FIX))
   {
      t_Info->uc_ID_NPar1 = NON_STANDARD;
      t_Info->uc_NumBlock = 1;

      t_Info->ta_NS_Info[0].uc_NSLen = 0x16;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[0] = 0x0E;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[1] = 0x07;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[2] = 0x04;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[3] = 0x03;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[4] = 0x10;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[5] = 0xE0;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[6] = 0x00;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[7] = 0x01;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[8] = 0x2F;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[9] = 0x00;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[10] = 0x00;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[11] = 0x00;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[12] = 0x00;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[13] = 0x00;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[14] = 0x00;
      t_Info->ta_NS_Info[0].puca_NSVendorSpec[15] = 0x00;
   }
   // SMS00805497 IOP_DS_BisPlus_CNXT_SRAFailGhsNonStandard (End)

#endif

    /* ==== Vendor ID (required only for CL and CLR messages) ==== */
    switch (t_Info->uc_Type)
    {

    case M_CLR :
        /* ---- 2 country code octets, with the most significant octet first ---- */
        uca_Msg[idx++] = (uint8) ( t_Info->us_Country >> 8 );
        uca_Msg[idx++] = (uint8) ( t_Info->us_Country );

        /* ---- 4 vendor ID octets, with the most significant octet first ---- */
        for ( i = 0; i < 4; i++ )
        {
            uca_Msg[idx++] = (uint8) ( t_Info->ul_Provider >> ((3-i) * 8) );
        }
        /* ---- 2 octets of vendor specific information ---- */
        uca_Msg[idx++] = (uint8) ( t_Info->us_VendorInfo >> 8 );
        uca_Msg[idx++] = (uint8) ( t_Info->us_VendorInfo );

        break;

    }   /*  switch */


    /* ---- Service and Channel parameters, Standard and Non-Standard Information ---- */
    /* ---- only for MS, CL, CLR messges                                          ---- */
    switch (t_Info->uc_Type)
    {
    case M_CLR :
    case M_MS  :

        idx = FormStandard( t_Info, uca_Msg, (int16)idx); /*  parameters and standard */
        // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (Start)
#ifndef ISDN   // Only for Annex-A
        // In cases where the MS is sent by CPE, we check whether its ADSL2/2+ and the CO vendor-id
        // is TI/CNXT, then the AC7/CNXT flag is set,
        // since we need the US improvements in 2 & 2+ only as in DMT, the US performance of the
        // AR7 is almost same as that of Danube.
        if (t_Info->uc_Type == M_MS)
        {
            int32 l_fe_VendorID_Check;  // Added the 32 bit local var. for TI/CNXT Vendor id//

            // Extract the provider  code (Vendor ID, 4 octets), Workaround for TI  AC7/CNXT vendor ID
            l_fe_VendorID_Check = (guca_fe_G9941_VendorID[2] << 24) | (guca_fe_G9941_VendorID[3] << 16) |
                                  (guca_fe_G9941_VendorID[4] << 8) | (guca_fe_G9941_VendorID[5]);

            // Disable the AC7/CNXT woarkaround flag because, this workaround is not needed in DMT
            if (gpt_TxInfoSave->uc_SI_SPar1[0] & G992_1_A)
            {
                if (gft_USPerf_AC7)
                {
                    gft_USPerf_AC7 = 0;
                    // Drop the link using exception handler.
                    // Exception codes have been set earlier, where l_SelectedMode was set
                    gs_RxNextState = FAIL_RX;
                    gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                    gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
                    gus_ExceptionCode  = E_CODE_IOP_FIX_1;
                    //bhadra_set_flag
                }
               // SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (START)
               if ((l_fe_VendorID_Check == GHS_GSI_ID) && (gft_StartDMT_CNXT == FALSE))
               {
                  gft_StartDMT_CNXT = TRUE;
               }
               // SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (END)
              //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START)
              // If the VID is 0x0000 (certain CTLM DSLAMs), set the interop flag and restart
              if  ((l_fe_VendorID_Check == 0) && (!gft_USCRC_CTLM))
              {
                //XDSLRTFW-1590 IOP_A_DS_ALL_ShortenTrainingTime_AfterPowerup (START)
                //Here we use flag gft_SyncScalingForGenericCOinDMT to distinguish
                //STM and CTLM with GHS0000.
                if (gft_SyncScalingForGenericCOinDMT == 0) //This is indeed CTLM and requires VID change
                {
                   gft_USCRC_CTLM = 1;
                   //Drop the link using exception handler.
                   gus_ExceptionCode = E_CODE_IOP_CHANGE_VID_TSTC;
                   gs_RxNextState = FAIL_RX;
                   gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                   gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
                }
                else if (gt_INFX_CMV.us_OperatorSpBits4 & CVM_TO_Enable_GHS0000_TIVID_Retrain)
                {//if gft_SyncScalingForGenericCOinDMT is set, the CO is STM. Then we check
                 //the CMV and decide retrain or not
                   gft_USCRC_CTLM = 1;
                   //Drop the link using exception handler.
                   gus_ExceptionCode = E_CODE_IOP_CHANGE_VID_TSTC;
                   gs_RxNextState = FAIL_RX;
                   gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                   gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
                }
                //XDSLRTFW-1590 IOP_A_DS_ALL_ShortenTrainingTime_AfterPowerup (END)
              }

              // If we were in CTLM interop mode and no longer with a CTLM DSLAM, exit the interop mode
              if  ((l_fe_VendorID_Check != 0) && (gft_USCRC_CTLM))
              {
                 gft_USCRC_CTLM = 0;
                 //Drop the link using exception handler.
                 gus_ExceptionCode = E_CODE_IOP_RESET_CHANGE_VID_FLAG;
                 gs_RxNextState = FAIL_RX;
                 gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                 gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
              }
              //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (END)

                if ((l_fe_VendorID_Check == GHS_GSI_ID) && (!gft_DSPerf_CNXT))
                {
                    if ((gt_INFX_CMV.
                            s_DFE_Options & CMV_TO_FORCE_TI_VENDORID_CNXT) ==
                            CMV_TO_FORCE_TI_VENDORID_CNXT)
                    {
                        gft_DSPerf_CNXT = 1;
                    }
                    if (gft_DSPerf_CNXT)
                    {
                        // Set the flag,if we detect the CNXT DSLAM//
                        // Drop the link using exception handler.
                        // Exception codes have been set earlier, where l_SelectedMode was set
                        gs_RxNextState = FAIL_RX;
                        gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                        gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
                        gus_ExceptionCode = E_CODE_IOP_FIX_5;
                    }
                }
            }
            // Extract the TI/CNXT DSLAM vendor id and check the flag
            // Enable the AC7/CNXT woarkaround flag because, this workaround is needed in ADSL2/2+
            if ((gpt_TxInfoSave->uc_SI_SPar1[2] & (G992_3_A >> 16)) ||
                    (gpt_TxInfoSave->uc_SI_SPar1[3] & (G992_5_A >> 24)))
            {
                if ((l_fe_VendorID_Check == GHS_TI_ID) && (!gft_USPerf_AC7))
                {
                    gft_USPerf_AC7 = 1;   // Set the flag,if we detect the TI DSLAM//
                    // Drop the link using exception handler.
                    // Exception codes have been set earlier, where l_SelectedMode was set
                    gs_RxNextState = FAIL_RX;
                    gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                    gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
                    gus_ExceptionCode  = E_CODE_IOP_FIX_6;
                }
               // SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (Start)
               if ((l_fe_VendorID_Check == GHS_GSI_ID) && (gft_StartDMT_CNXT == TRUE))
               {
                  gft_StartDMT_CNXT = FALSE;
                  gs_RxNextState = FAIL_RX;
                  gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                  gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
                  gus_ExceptionCode = E_CODE_IOP_FIX_7;
               }
               // SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (END)

                if (gft_DSPerf_CNXT)
                {
                    gft_DSPerf_CNXT = 0;
                    // Drop the link using exception handler.
                    // Exception codes have been set earlier, where l_SelectedMode was set
                    gs_RxNextState = FAIL_RX;
                    gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                    gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
                    gus_ExceptionCode  = E_CODE_IOP_FIX_8;

                }
              //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START)
              // This fix does not apply in ADSL2/2+
              if  (gft_USCRC_CTLM)
              {
                 gft_USCRC_CTLM = 0;
                 //Drop the link using exception handler.
                 gus_ExceptionCode = E_CODE_IOP_RESET_CHANGE_VID_FLAG;
                 gs_RxNextState = FAIL_RX;
                 gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                 gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
              }
              //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (END)
            }
        }
#endif // ifndef ISDN
        // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (End)

        if ( ((t_Info->uc_ID_NPar1 & NON_STANDARD) != 0) && (idx < s_maxMsgLen) )
            idx = FormNonStandard( t_Info, uca_Msg, (int16)idx ); /*  non standard */

        break;
    }


    // If length greater than allocated buffer, set an ExceptionCode that will lead into Cleardown
    if (idx > MESSAGE_BUF_LEN)
    {
        gus_ExceptionCode = E_CODE_GHS_TX_MSGBUF_OVERFLOW ;
    }



    /* ---- return the whole lenth (No. of octets) of the message ---- */
    return ( idx );

}   /*  FormMessage */

/*
 *------------------------------------------------------------------------
 *
 *  Name: FormStandard_Bis
 *
 *  Abstract:
 *
 *  Enclose Bis or BisPlus components of standard information field in an arrary.
 *
 *  Parameters:
 *      const InfoField *t_Info : information to be packed
 *      uint8 uca_M[]           : output arrary containing the information
 *      idx                     : index of the starting position of the message array
 *
 *  Returns:
 *      idx                     : index of the ending position of the message array
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 */
int16 FormStandard_Bis(Adsl2AllInfo_t *pt_BisInfo, uint8* uca_M, int16 idx, FlagT ft_BisOrPlus )
{

    int i;
    uint8 *puca_Max_Num_STM_TPS_TC[2] = {&pt_BisInfo->uc_DS_Max_Num_STM_TPS_TC, &pt_BisInfo->uc_US_Max_Num_STM_TPS_TC};
    uint8 *puca_Max_Num_ATM_TPS_TC[2] = {&pt_BisInfo->uc_DS_Max_Num_ATM_TPS_TC, &pt_BisInfo->uc_US_Max_Num_ATM_TPS_TC};
    uint8 *puca_Max_Num_PTM_TPS_TC[2] = {&pt_BisInfo->uc_DS_Max_Num_PTM_TPS_TC, &pt_BisInfo->uc_US_Max_Num_PTM_TPS_TC};

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   //if((OPTNArray[OPTN_StateMachineCtrl] & OPTN_Enable_DS_VirtualNoise) == OPTN_Enable_DS_VirtualNoise)
   if((gs_DSL_FeaturesControl & DSL_Enable_DS_VirtualNoise) == DSL_Enable_DS_VirtualNoise)
   {
      pt_BisInfo->uc_SI_NPar2[0] |= VIRTUAL_NOISE;    // No Npar2 octets for VN in CLR Routine//
   }
   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

    // SMS00847294:Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting ( Start)
    //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
   // XDSLRTFW-1502 (start_end)
   if(((gs_DSL_EDcontrol & DSL_Enable_ERASUREDECODING_REPORTING) == DSL_Enable_ERASUREDECODING_REPORTING)
       &&(gft_SendShortCLR == FALSE)
      )
   {
        // New tree structure is added below. Reference to G.994.1 standard
        // tree struture coding guideline for NPar2 Block. Last decoded octet is termi-
        // nated with the Delimiter.
      for (i = 0; i < NUM_SI_NPAR2_OCTETS; i++)
         uca_M[idx++] = pt_BisInfo->uc_SI_NPar2[i];
      uca_M[idx - 1] |= DELIMIT_2;
   }
   else
   {
      uca_M[idx++] = pt_BisInfo->uc_SI_NPar2[0] | DELIMIT_2;   // Regular Code
   }
    // SMS00847294:Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting ( End)

    if (gft_SendShortCLR==FALSE)    // shortCLR doesn't send SI_SP2
    {
#ifndef ISDN
         // BT loops 17.5kft 600/700/800 go with ADSL2 mode.
         // side effect unknown, anyway with CNXT ADSL2 mode gives better US/DS than READL2.
         if((gt_INFX_CMV.us_OperatorSpBits7 & CMV_CNXT_ATT_CONTROL)
            )
         {
            if((gs_CurrentCoChipset == GSI_CO_CHIPSET)
                &&(gs_CurrentCoVendorID == 0x10 )
                && (gs_hsk_tone_power_dB < 1100)
               )
            {
               gft_CNXT_A_LongLoops = TRUE;
               gs_TX_IMAGE_NYQ = 0x204;// to send proper Values of IFFT and fill
               if(((gt_INFX_CMV.us_OperatorSpBits7 & CMV_TO_FORCE_ADSL2_MODE) ||(gft_pAnnexLBTLoops_CNXT == TRUE))
               &&(gs_hsk_tone_power_dB >100) //hsk power between 100 and 1100
               )
               {
                  //Disable annex L
                  if ((pt_BisInfo->uc_SI_SPar2[0] & PSD_MASK) != 0 )
                  {
                     pt_BisInfo->uc_SI_SPar2[0] &= ~PSD_MASK;
                     gft_CNXT_ANNEXL_ADSL2 = TRUE;
                  }
               }
            }
            if (((gs_CurrentCoChipset == BDCM_CO_CHIPSET)||(gs_CurrentCoChipset == GSI_CO_CHIPSET))
                 && (gs_hsk_tone_power_dB < 2000)
                )
            {
               gt_INFX_CMV.us_OperatorSpBits7 |= CMV_COMB2_PILOT_Fix;
            }

         }

#endif
         //XDSLRTFW-2033 (end)
        for(i=0; i<NUM_SI_SPAR2_OCTETS; i++)
            uca_M[idx++] = pt_BisInfo->uc_SI_SPar2[i];

        uca_M[idx-1] |= DELIMIT_2;

        /* ---- SI_NPar3 ---- */
        if ( (pt_BisInfo->uc_SI_SPar2[0] & SPECTRUM_BOUNDS_UP) != 0 )
        {
            idx = FormPmdSpectrumBoundParameters(&(pt_BisInfo->t_PMD_NPar3_US), uca_M, idx);
        }
        if ( (pt_BisInfo->uc_SI_SPar2[0] & SPECTRUM_SHAPE_UP) != 0 )
        {

            idx = FormPmdSpectrumShapeParameters(&(pt_BisInfo->t_PMD_NPar3_US), uca_M, idx, gsa_num_USTssi_Xmitted[ft_BisOrPlus]);
        }
        if ( (pt_BisInfo->uc_SI_SPar2[0] & TX_IMAGE_NYQ) != 0 )
        {
            // IOP_ALL_BisPlus_ALL_SendIFFTSizeInNPar3 (Start)
#ifndef ISDN   // Only for Anx-A
            if (gft_Enable_IFFT64)
                //(b6b5b4b3) = n, with 1 ? n ? 15 indicates that N = 2^n & b2b1 = 01 complex conjugate of the base band signal
                pt_BisInfo->uc_TxSignalNyq |= IFFT64_CMPLX_CONJ_BB_SIGNAL;  // 64 Point IFFT 0x19
            else
         // XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf(START)
            #ifndef ADSL_62
                //(b6b5b4b3) = n, with 1 < n < 15 indicates that N = 2^n & (b2b1 = 10): zero filled;
                pt_BisInfo->uc_TxSignalNyq |= IFFT128_ZERO_FILLED; // 128 Point IFFT 0x1E
            #else
                pt_BisInfo->uc_TxSignalNyq |= IFFT512_CMPLX_CONJ_BB_SIGNAL; // 512 Point IFFT
            #endif
            //XDSLRTFW-2033 (start)
            //  IDFT size
            if(gs_TX_IMAGE_NYQ & 1)
               pt_BisInfo->uc_TxSignalNyq = (6<<2);   //  64 =>6
            else if(gs_TX_IMAGE_NYQ & 2)
               pt_BisInfo->uc_TxSignalNyq = (7<<2);   //128 =>7
            else if(gs_TX_IMAGE_NYQ & 4)
               pt_BisInfo->uc_TxSignalNyq = (8<<2);   //256 =>8
            else if(gs_TX_IMAGE_NYQ & 8)
               pt_BisInfo->uc_TxSignalNyq =  (9<<2);  //512=>9
            // Filling
            if(gs_TX_IMAGE_NYQ & 0x100)
               pt_BisInfo->uc_TxSignalNyq |= 1;       //conjugate
            else if(gs_TX_IMAGE_NYQ & 0x200)
               pt_BisInfo->uc_TxSignalNyq |= 2;       //zero fill
            else if(gs_TX_IMAGE_NYQ & 0x400)
            {
               pt_BisInfo->uc_TxSignalNyq &= ~3;       //None of the above
            }
            //XDSLRTFW-2033 (end)
         // XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf(End)
            uca_M[idx++] = pt_BisInfo->uc_TxSignalNyq | DELIMIT_2;
#else // ifndef ISDN
            uca_M[idx++] = pt_BisInfo->uc_TxSignalNyq | DELIMIT_2;
#endif // ifndef ISDN
            // IOP_ALL_BisPlus_ALL_SendIFFTSizeInNPar3 (End)
        }

        // If the SPar2 bit for Sub mode PSD mask is set, send associated NPar3 octets
        if ((pt_BisInfo->uc_SI_SPar2[0] & PSD_MASK) != 0 )
        {
            uca_M[idx++] = pt_BisInfo->uca_PSD_Mask[0];
            uca_M[idx++] = pt_BisInfo->uca_PSD_Mask[1] | DELIMIT_2;
        }

        /* DS overhead data rate */
        if ( (pt_BisInfo->uc_SI_SPar2[1] & OH_DATARATE_DN) != 0 )
            uca_M[idx++] = ((uint8)((pt_BisInfo->t_Overhead.s_DSMSGOvhdMinRate-1) & 0x3F)) | DELIMIT_2;

        /* US overhead data rate */
        if ( (pt_BisInfo->uc_SI_SPar2[1] & OH_DATARATE_UP) != 0 )
            uca_M[idx++] = ((uint8)((pt_BisInfo->t_Overhead.s_USMSGOvhdMinRate-1) & 0x3F)) | DELIMIT_2;

        /* max number of downstream TPS-TC functions of each type */
        for (i = 0; i < 2; i++)
        {
            if ( (pt_BisInfo->uc_SI_SPar2[1] & (0x4<<i)) != 0 )
            {
                uca_M[idx] = (*(puca_Max_Num_STM_TPS_TC[i]) & 0x7);        /* bits 1 to 3 */
                uca_M[idx++] = ((*(puca_Max_Num_ATM_TPS_TC[i]) & 0x7) << 3);  /* bits 4 to 6 */
                uca_M[idx++] = (*(puca_Max_Num_PTM_TPS_TC[i]) & 0x7) | DELIMIT_2;/* bits 1 to 3 */
            }
        }

        /* add tps-tc, pms-tc info, both US and DS, to uca_M */
        for (i = 0; i < MAX_BEARER_CHANNEL; i++)
        {
            idx = AddTpsTcInfo((int16)i, pt_BisInfo, uca_M, idx);

            idx = AddPmsTcInfo((int16)i, pt_BisInfo, uca_M, idx);
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
#ifdef UNV_RETX_GHS
      // Add Npar3 param here for Retransmiaaion if (i == 0);ie., bearer #0
         if(gt_ReTxConfigInfo.us_ReTxConfigOptionBits & CMV_BIT_INDICATE_RETX)
         {
            if(i == 0)
            {
               idx = AddReTxTpsTcInfo((int16) i, pt_BisInfo, uca_M, idx);
            }
         }
#endif
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
        }

    } //if (gft_SendShortCLR==FALSE)

    uca_M[idx-1] |= DELIMIT_1;

    return(idx);

}

/*
 *------------------------------------------------------------------------
 *
 *  Name: FormStandard
 *
 *  Abstract:
 *
 *  Enclose standard information field in an arrary.
 *
 *  Parameters:
 *      const InfoField *t_Info : information to be packed
 *      uint8 uca_M[]           : output arrary containing the information
 *      idx                     : index of the starting position of the message array
 *
 *  Returns:
 *      idx                     : index of the ending position of the message array
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 */
int16 FormStandard(  InfoField_t *t_Info, uint8 uca_M[], int16 idx )
{

   int i, j;
   FlagT ft_ID_SPar1end;
   HS_Encode_ADSL2_t *pt;
   Adsl2AllInfo_t *pt1;
   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start_End)
   // Increased the array size
   uint8 *puca_Attenuation[12] = {&t_Info->uc_UpA43Attenuation,
                                  &t_Info->uc_DnA43Attenuation,
                                  &t_Info->uc_UpB43Attenuation,
                                  &t_Info->uc_DnB43Attenuation,
                                  &t_Info->uc_UpC43Attenuation,
                                  &t_Info->uc_DnC43Attenuation,
                                  &t_Info->uc_UpA4Attenuation,
                                  &t_Info->uc_DnA4Attenuation,
                                  &t_Info->uc_UpA43cAttenuation,
                                  &t_Info->uc_DnA43cAttenuation,
                                  &t_Info->uc_UpJ43Attenuation,
                                  &t_Info->uc_DnJ43Attenuation
                                 };
   uint8 *puca_SI_NPar2[5] = {&t_Info->uc_SI_1A_NPar2, &t_Info->uc_SI_1B_NPar2, &t_Info->uc_SI_1C_NPar2,
                              &t_Info->uc_SI_2AB_NPar2, &t_Info->uc_SI_2C_NPar2
                             };
   uint8 *puca_SI_SPar2[5] = {&t_Info->uc_SI_1A_SPar2, &t_Info->uc_SI_1B_SPar2, &t_Info->uc_SI_1C_SPar2,
                              &t_Info->uc_SI_2AB_SPar2, &t_Info->uc_SI_2C_SPar2
                             };
   uint8 *puca_SI_SubChan1[3] = {&t_Info->uc_1A_SubChan1, &t_Info->uc_1B_SubChan1, &t_Info->uc_1C_SubChan1};
   uint8 *puca_SI_SubChan2[3] = {&t_Info->uc_1A_SubChan2, &t_Info->uc_1B_SubChan2, &t_Info->uc_1C_SubChan2};
   uint8 *puca_SI_MinSpec[5][2] = {&t_Info->uc_1A_UpMinSpect, &t_Info->uc_1A_DnMinSpect,
                                   &t_Info->uc_1B_UpMinSpect, &t_Info->uc_1B_DnMinSpect,
                                   &t_Info->uc_1C_UpMinSpect, &t_Info->uc_1C_DnMinSpect,
                                   &t_Info->uc_2AB_UpMinSpect,&t_Info->uc_2AB_DnMinSpect,
                                   &t_Info->uc_2C_UpMinSpect, &t_Info->uc_2C_DnMinSpect
                                  };

   uint8 *puca_SI_MaxSpec[5][2] = {&t_Info->uc_1A_UpMaxSpect, &t_Info->uc_1A_DnMaxSpect,
                                   &t_Info->uc_1B_UpMaxSpect, &t_Info->uc_1B_DnMaxSpect,
                                   &t_Info->uc_1C_UpMaxSpect, &t_Info->uc_1C_DnMaxSpect,
                                   &t_Info->uc_2AB_UpMaxSpect,&t_Info->uc_2AB_DnMaxSpect,
                                   &t_Info->uc_2C_UpMaxSpect, &t_Info->uc_2C_DnMaxSpect
                                  };
   uint8 uc_SI_SPar1_ORed ;


   for (i=2, uc_SI_SPar1_ORed=0 ; i<NUM_SI_SPAR1_OCTETS; i++)        // Look at ADSL2 bits only
   {
       uc_SI_SPar1_ORed |= t_Info->uc_SI_SPar1[i] ;
   }


   /* ==== Service and Channel parameters (for CL, CLR, MS only) ==== */
   uca_M[idx++] = t_Info->uc_ID_NPar1 | DELIMIT_1;

//XDSLRTFW-2893 (start)
        if ((guc_ClrControl & CLR_SEND_NOT_BONDING_INFO) == 0)
        {
            // Set to FALSE will send more than 1 octet in ID SPAR1
            guc_Received_Only_One_Octet_In_ID_Field = FALSE;
        }

        if ((uc_SI_SPar1_ORed == 0) || (guc_Received_Only_One_Octet_In_ID_Field == TRUE))
        {
           guc_ClrControl |= CLR_SEND_ONE_OCTET_ID_SPAR1;
            //clear the ID_SPar1[1] to ID_SPar1[NUM_ID_SPAR1_OCTETS-1]
            memset(&(t_Info->uc_ID_SPar1[1]), 0, (int16)(NUM_ID_SPAR1_OCTETS-1));
            uca_M[idx++] = t_Info->uc_ID_SPar1[0] | DELIMIT_1;
        }
        else
        {
            // If we are ADSL2/+, able to send all ID_SPar1 octets
            for(i=0; i<NUM_ID_SPAR1_OCTETS; i++)
            {
            uca_M[idx++] = t_Info->uc_ID_SPar1[i];

                for (j=i+1, ft_ID_SPar1end=TRUE ; j<NUM_ID_SPAR1_OCTETS; j++)
                {
                    if (t_Info->uc_ID_SPar1[j] != 0)
                        ft_ID_SPar1end = FALSE ;
                }

                if (ft_ID_SPar1end==TRUE)
                {
                    uca_M[idx-1] |= DELIMIT_1 ;
               break ;
            }
         }
      }

      /* ---- ID_NPar2 ---- */
      if ( (t_Info->uc_ID_SPar1[0] & NDR_UP) != 0 )
      {
         uca_M[idx++] = t_Info->uc_UpMaxNDR;
         uca_M[idx++] = t_Info->uc_UpMinNDR;
         uca_M[idx++] = t_Info->uc_UpAvgNDR | DELIMIT_2 | DELIMIT_1;
      }
      if ( (t_Info->uc_ID_SPar1[0] & NDR_DN) != 0 )
      {
         uca_M[idx++] = t_Info->uc_DnMaxNDR;
         uca_M[idx++] = t_Info->uc_DnMinNDR;
         uca_M[idx++] = t_Info->uc_DnAvgNDR | DELIMIT_2 | DELIMIT_1;
      }
      if ( (t_Info->uc_ID_SPar1[0] & DFC_UP) != 0 )
      {
         uca_M[idx++] = t_Info->uc_UpMaxLat;
         uca_M[idx++] = t_Info->uc_UpAvgLat | DELIMIT_2 | DELIMIT_1;
      }
      if ( (t_Info->uc_ID_SPar1[0] & DFC_DN) != 0 )
      {
         uca_M[idx++] = t_Info->uc_DnMaxLat;
         uca_M[idx++] = t_Info->uc_DnAvgLat | DELIMIT_2 | DELIMIT_1;
      }
      if ( (t_Info->uc_ID_SPar1[0] & R_SPLITTER) != 0 )
      {
         uca_M[idx++] = t_Info->uc_ID_NPar2_O11 | DELIMIT_2 | DELIMIT_1;
      }
      if ( (t_Info->uc_ID_SPar1[0] & C_SPLITTER) != 0 )
      {
         uca_M[idx++] = t_Info->uc_ID_NPar2_O12 | DELIMIT_2 | DELIMIT_1;
      }

      // TX attenuation: UpA43, DnA43, UpB43, DnB43, UpC43 and DnC43
      for (i = 0; i < 6; i++)
      {
         if ((t_Info->uc_ID_SPar1[1] & (0x1<<i)) != 0)
         {
            uca_M[idx++] = *(puca_Attenuation[i]) | DELIMIT_2 | DELIMIT_1;
         }
      }
      // TX attenuation: UpA4, DnA4, UpA43c and DnA43c
      for (i = 0; i < 4; i++)
      {
         if ((t_Info->uc_ID_SPar1[2] & (0x1<<i)) != 0)
         {
            uca_M[idx++] = *(puca_Attenuation[6+i]) | DELIMIT_2 | DELIMIT_1;
         }
      }
      //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)
#ifdef ADSL_BONDING
      if ((t_Info->uc_ID_SPar1[2] & BONDING) != 0)
      {
         uca_M[idx++] = t_Info->uc_BondingNP2 | DELIMIT_2;
         uca_M[idx++] = t_Info->uc_BondingSP2 | DELIMIT_2;
         // Remote discovery register
         if ( (t_Info->uc_BondingSP2 & BONDING_PME_DISCOVERY) != 0 )
         {
            for (i=0 ; i<9; i++)
            {
               uca_M[idx++] = t_Info->uca_BondingDisc[i];
            }
            uca_M[idx-1] |= DELIMIT_2;
         }
         // PME Aggr register
         if ( (t_Info->uc_BondingSP2 & BONDING_PME_AGGREGATION) != 0 )
         {
            for (i=0 ; i<6 ; i++)
            {
               uca_M[idx++] = t_Info->uca_BondingAggr[i];
            }
            uca_M[idx-1] |= DELIMIT_2;
         }
         // PME ID register
         if ( (t_Info->uc_BondingSP2 & BONDING_PME_IDENTIFICATION) != 0 )
         {
            uca_M[idx++] = t_Info->uc_BondingId | DELIMIT_2;
         }
         uca_M[idx-1] |= DELIMIT_1;
      }
#endif
      //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(End)

      // TX attenuation: UpJ43 and DnJ43
      for (i = 0; i < 2; i++)
      {
         if ( (t_Info->uc_ID_SPar1[2] & (0x1<<(5+i))) != 0 )
         {
            uca_M[idx++] = *(puca_Attenuation[10+i]) | DELIMIT_2 | DELIMIT_1;
         }
      }


   /* ==== Standard information ==== */
   uca_M[idx++] = t_Info->uc_SI_NPar1 | DELIMIT_1;

   if (uc_SI_SPar1_ORed  || (guc_Received_Only_One_Octet_In_SI_Field == FALSE) )
   {
      for (i=0 ; i<NUM_SI_SPAR1_OCTETS ; i++)
      {
         uca_M[idx++] = t_Info->uc_SI_SPar1[i];
      }
      uca_M[idx-1] |= DELIMIT_1;
   }
   else
   {
        uca_M[idx++] = t_Info->uc_SI_SPar1[0] | DELIMIT_1;
        guc_ClrControl |= CLR_SEND_ONE_OCTET_SI_SPAR1;
   }

   /* ============================================*/
   /* Form Standard Information */
   /* ============================================*/
   // cover almost all the Annex here from SI SPar1 octet1
   // i = 0: G992.1 AnnexA
   //     1: G992.1 AnnexB
   //     2: G992.1 AnnexC
   //     3: G992.2 AnnexA/B
   //     4: G992.2 AnnexC
   for (i = 0; i < 5; i++)
   {
      if ( (t_Info->uc_SI_SPar1[0] & (0x1<<i) ) != 0 )
      {
         uca_M[idx++] = *(puca_SI_NPar2[i]) | DELIMIT_2;

         if (gft_SendShortCLR==FALSE)     // shortCLR doesn't send SI_SP2
         {
            /* Do NOT send an empty SPar2, for Alcatel interoperability */
            if (*(puca_SI_SPar2[i]))
               uca_M[idx++] = *(puca_SI_SPar2[i]) | DELIMIT_2;

            /* ---- SI_NPar3 ---- */
            if ( (*(puca_SI_SPar2[i]) & SUBCH_INFO) != 0 )
            {
               uca_M[idx++] = *(puca_SI_SubChan1[i]);
               uca_M[idx++] = *(puca_SI_SubChan2[i]) | DELIMIT_2;
            }
            for (j = 0; j < 2; j++)
            {
               if ( (*(puca_SI_SPar2[i]) & (0x02<<j)) != 0 )
               {
                  uca_M[idx++] = ( *(puca_SI_MinSpec[i][j]) >> 6) & 0x03;       /*  take 2 MSB's */
                  uca_M[idx++] = *(puca_SI_MinSpec[i][j])        & 0x3F;       /*  take remaining 6 bits */
                  uca_M[idx++] = (*(puca_SI_MaxSpec[i][j]) >> 6) & 0x03;       /*  take 2 MSB's */
                  uca_M[idx++] = (*(puca_SI_MaxSpec[i][j]) & 0x3F) | DELIMIT_2;/*  take remaining 6 bits */
               }
            }
         }//   if (gft_SendShortCLR==FALSE)

         uca_M[idx-1] |= DELIMIT_1;
      }
   }
   //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(Start)
#ifdef HERC_API
   // XDSLRTFW-178 (Start_End)
   if (gft_NoVDSLIndication == 0)
   {
      if(OPTNArray[OPTN_AlgControl3] & CMV_TO_SEND_VDSL_MODES_IN_SHORT_CLR)
      {
         // For each VDSL mode, if spar1, then write npar2 | Delimit1 | Delimit2.
         if (gpt_TxInfo->uc_SI_SPar1[1] & (uint8)(T1_MCM_VDSL >> 8))
            //gpt_TxInfo->uc_SI_G993_1_NPar2 = G9931_OPTUP | G9931_OPTDOWN | G9931_PSDRED | G9931_PTM | G9931_ATM | G9931_CLEAREOC;
            uca_M[idx++] = t_Info->uc_SI_G993_1_NPar2 | DELIMIT_1 | DELIMIT_2;
      }
   }
#endif
   //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(End)
   pt = gta_HS_ADSL2;
   for (i=0 ; i<NUM_KNOWN_ADSL2_SPAR1_BITS ; i++)
   {
      if ((t_Info->uc_SI_SPar1[pt->SI_SPar1_idx] & pt->SI_Spar1_anx_bit) != 0)
      {
         if (pt->bis_plus == 0) //BIS
         {
            pt1 = t_Info->pta_G9923xInfo[pt->anx];
            j = 0;
         }
         else //PLUS
         {
            pt1 = t_Info->pta_G9925xInfo[pt->anx];
            j = 1;
         }
         idx = FormStandard_Bis(pt1, uca_M, (int16)idx, (uint8)j);
      }
      pt++;
   }//i

   // XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(START)
#ifdef HERC_API
   // Enhc_AB_ALL_ALL_ALL_VDSL_HSK_InADSLShortCLR_Msg(Start_End)
   if ((gpt_TxInfo->uc_SI_SPar1[4] & G993_2) && (gft_SendShortCLR == TRUE))
   {
      guc_temp_vdsl2_mode1 = gpt_TxInfo->uc_SI_SPar1[4] & 0xFF; //TODO: Remove Debug Code

      gpt_TxInfo->uc_SI_G993_2_NPar2_01  = All_DIGITAL_MODE;
      uca_M[idx++] = (gpt_TxInfo->uc_SI_G993_2_NPar2_01);//| DELIMIT_2);    // Value is 1

      //XDSLRTFW-2490 (Start)
      if ((gs_DSL_FeaturesControl & DSL_EnableAELEM) || (gus_DsmCtrlCmv & G9935_ANX_Y_VECTOR_FULL_FRIENDLY_ENABLED))
      {
         gpt_TxInfo->uc_SI_G993_2_NPar2_02 = 0;
         if(gs_DSL_FeaturesControl & DSL_EnableAELEM)
         {
            gpt_TxInfo->uc_SI_G993_2_NPar2_02 |= G9932_AELEM_SUPPORT;         // Ghs_Npar2_Oct2_Bit1
         }
         if(gus_DsmCtrlCmv & G9935_ANX_Y_VECTOR_FULL_FRIENDLY_ENABLED)
         {
            gpt_TxInfo->uc_SI_G993_2_NPar2_02 |= G9932_VECTOR_FULL_FRIENDLY;  // Ghs_Npar2_Oct2_Bit2
         }
         uca_M[idx++] = gpt_TxInfo->uc_SI_G993_2_NPar2_02 ; // Value is 0x42
      }
      uca_M[idx-1] |= DELIMIT_2; // Add delimeter
      //XDSLRTFW-2490 (End)

      // 0x11     // SI_Spar2_Octet-1
      gpt_TxInfo->uc_SI_SPar2_01 = guc_VDSL2_SI_Spar2_Octet1;
      uca_M[idx++] = gpt_TxInfo->uc_SI_SPar2_01;// SI_Spar2_Octet1   = 0x11

      //XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start)
      if (gus_DsmCtrlCmv & G9935_COMPLETE_VECTORING_ENABLED)
      {
         guc_VDSL2_SI_Spar2_Octet2 |= G9935_G_VECTOR_MASK;        //// Table 11.68.0.1 G.994.1
      }
      //XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (End)

      // 0x43     // SI_Spar2_Octet-2
      gpt_TxInfo->uc_SI_SPar2_02 = guc_VDSL2_SI_Spar2_Octet2;
      uca_M[idx++] = (gpt_TxInfo->uc_SI_SPar2_02 | DELIMIT_2);


      if ( (gpt_TxInfo->uc_SI_SPar2_01 & V2_PROFILES) != 0 )
      {
         // SI_Npar3_Octet1: 0x3F = (Profile 8a,8b,8c,8d)
         uca_M[idx++]  = (gs_Vdsl2_Profile_Supported & (V2_PROFILE_12B | V2_PROFILE_12A |
                                                        V2_PROFILE_8D|V2_PROFILE_8C|V2_PROFILE_8B|V2_PROFILE_8A));
         // SI_Npar3_Octet2: 0x47 = (Profile 17a,30a,35b)
         uca_M[idx++]  = (((gs_Vdsl2_Profile_Supported >> 6) & (0x38|V2_PROFILE_35B|V2_PROFILE_30A|V2_PROFILE_17A)) |
                           DELIMIT_2);
      }

      //RFI bands
      // Below code is commented as it is not initialized. VDSL2 Firmware does not send this code in its CLR message.So ADSL Full CLR with VDSL2 CLR code
      // points are mimced.
#ifdef VDSL2_HNDSHK
      if ( (gpt_TxInfo->uc_SI_SPar2_01 & V2_RFI_BANDS) != 0 )
      {
         PackBandInfo2MsgBuf(uca_M, &idx, gpt_TxInfo->uca_RFIBands, (uint8)gs_NumOfRFIBands);
      }
#endif
      //DFT size
      if ( (gpt_TxInfo->uc_SI_SPar2_01 & V2_DFT_SIZE) != 0 )
      {
         // 0x4D      SI_Npar3_Octet-2
         uca_M[idx++]  = ((guc_Initial_IDFT_size & 0xD )| DELIMIT_2);
      }

      //CE Length
      // Below code is commented as it is not initialized. VDSL2 Firmware does not send this code in its CLR message.So ADSL Full CLR with VDSL2 CLR code
      // points are mimced.
#ifdef VDSL2_HNDSHK
      if ( (gpt_TxInfo->uc_SI_SPar2_01 & V2_CE_LENGTH) != 0 )
      {
         uca_M[idx++] = gla_CELength & 0x3F;
         uca_M[idx++] = ((gla_CELength >> 6)& 0x3F);
         uca_M[idx++] = (((gla_CELength >> 12)& 0x3F) | DELIMIT_2);
      }
#endif

      // 0x43     // SI_Spar2_Octet-2
      // Annex A US0 PSD
      if ( (gpt_TxInfo->uc_SI_SPar2_02 & ANNEX_A_US0)!= 0 )
      {
         // 0x3F     // SI_Npar3_Octet-1
         uca_M[idx++]  = (guc_Annex_A_US0_EU_32_52 & 0x3F);
         // 0x07     // SI_Npar3_Octet-2
         uca_M[idx++]  = (guc_Annex_A_US0_EU_56_64 & 0x7);
         // 0x3F     // SI_Npar3_Octet-3
         uca_M[idx++]  = (guc_Annex_A_US0_ADLU_32_52  & 0x3F);
         // 0x07     // SI_Npar3_Octet-4
         uca_M[idx++]  = (guc_Annex_A_US0_ADLU_56_64 & 0x7);
         // 0x43     // SI_Npar3_Octet-5
         uca_M[idx++]  =  (((guc_US0_supported_profile_12b_17a) & 0x3)| DELIMIT_2); // End of SI_Npar3_Octet-5 for  Annex A US0 profile
      }

      // Annex B US0 PSD
      if ( (gpt_TxInfo->uc_SI_SPar2_02 & ANNEX_B_US0)!= 0 )
      {
         // 0x07     // SI_Npar3_Octet-1
         uca_M[idx++]  =  ((guc_Annex_B_US0_Profile_25_138KHzA_276KHzM_120_276KHz) & 0x7 );
         // 0xC3     // SI_Npar3_Octet-2     // End of VDSL2-FullCLR message
         uca_M[idx++]  =  (((guc_Annex_B_US0_Profile_12b_17a) & 0x3) | DELIMIT_2 );
      }

      // Annex C US0 PSD
      // Below code is commented as it is not initialized. VDSL2 Firmware does not send this code in its CLR message.So ADSL Full CLR with VDSL2 CLR code
      // points are mimced.
#ifdef VDSL2_HNDSHK
      if( (gpt_TxInfo->uc_SI_SPar2_02 & ANNEX_C_US0)!= 0 )
      {
         // 0x03     // SI_Npar3_Octet-1
         uca_M[idx++]  =  ((guc_Annex_C_US0_Profile_25_138KHzb_276KHzb_type) & 0x3);
         // 0x03     // SI_Npar3_Octet-2
         uca_M[idx++]  =  ((guc_Annex_C_US0_Profile_25_138KHzco_276KHzco_type) & 0x3);
         // 0xC3     // SI_Npar3_Octet-2     // End of VDSL2-FullCLR message
         uca_M[idx++]  =  (((guc_Annex_C_US0_Profile_12b_17a) & 0x3) | DELIMIT_2);
      }
#endif

      //XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start)
      if(guc_VDSL2_SI_Spar2_Octet2 & G9935_G_VECTOR_MASK)
      {
         // refer to Table 11.68.10 of G.994.1
         // 0x01     // SI_Npar3_Octet-1
         //XDSLRTFW-1128 Bug_AB_All_All_All_AddDelimter2ToNpar3
         // XDSLRTFW-1228 Feature_AB_All_All_All_SendUSVectorCodePointerInGHs (Start)
         // uca_M[idx++]  =  (G9935_DS_VECTORING_ENABLED  | DELIMIT_2);
         uca_M[idx++]  =(G9935_US_VECTORING_ENABLED | G9935_DS_VECTORING_ENABLED | DELIMIT_2);
         // XDSLRTFW-1228 Feature_AB_All_All_All_SendUSVectorCodePointerInGHs (End)
      }
      //XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (End)

      uca_M[idx-1] |= DELIMIT_1;
      // 0x43     // SI_Spar2_Octet-2
   }
#endif
   // XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(End)
   // XDSLRTFW-507 IOP_ALL_ALL_ALL_HNSHKT1413_LongTrain_HSStuck (Start)
   // Search for the Annex-bit in the Spar1 Octet.If No Annex is set quit Handshake

   gft_Anx_InformationSet = FALSE;
   //XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start_End)
   for (i = 0; i < NUM_SI_SPAR1_OCTETS; i++)
   {
      if (t_Info->uc_SI_SPar1[i] > 0)
      {
         gft_Anx_InformationSet = TRUE;
      }
   }
   if (gft_Anx_InformationSet == FALSE)
   {
      //Quit HNSK , as no Anx-Bit is set in Full CLR//
      gus_ExceptionCode = E_CODE_GHS_NearEnd_NoAnnexFound;//E_CODE_GHS_NoCommonMode;  //E_CODE_GHS_NearEnd_NoAnnexFound .. Mapped to FW_FailCode
      gs_RxNextState = FAIL_RX;           // Force the  Rx to FAIL State
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
      gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
      //guc_NoCommon_CL_CLR_Message_AnnexBitSet++;

   }
   // XDSLRTFW-507 IOP_ALL_ALL_ALL_HNSHKT1413_LongTrain_HSStuck (End)

   // XDSLRTFW-2298 (Start)
   // Form the G.Fast standard information
   if ( gpt_TxInfo->uc_SI_SPar1[4] & G9701)
   {
      uca_M[idx++] = gpt_TxInfo->G_Fast_Info.uc_SI_NPar2;

      // SPar2 octet 1
      uca_M[idx++] = gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_01;

      // SPar2 octet 2
      uca_M[idx++] = gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_02;

      // SPar2 octet 3
      uca_M[idx++] = gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_03 | DELIMIT_2;

      // NPar3 octets
      // Profile
      if (gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_01 & G_Fast_Profiles)
      {
         uca_M[idx++] = gpt_TxInfo->G_Fast_Info.uc_Profiles | DELIMIT_2;
      }

      // Duration of Channel discovery 1-1
      if ( gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_01 & G_Fast_Duration_Channel_Discovery)
      {
         uca_M[idx++] = gpt_TxInfo->G_Fast_Info.uc_duration_channel_discovery | DELIMIT_2;
      }

      // Number of symbols in TDD  frame
      if (gpt_TxInfo->G_Fast_Info.uc_SI_SPar2_02 & G_Fast_Symbol_Period_TDD_Frame)
      {
         uca_M[idx++] = gpt_TxInfo->G_Fast_Info.uc_symbol_period_TDD_frame | DELIMIT_2;
      }
      uca_M[idx-1] |= DELIMIT_1;
   }
   // XDSLRTFW-2298 (End)
   return (idx);

}   /*  FormStandard */

/*
 *------------------------------------------------------------------------
 *
 *  Name: FormNonStandard
 *
 *  Abstract:
 *
 *  Enclose non-standard information field in an arrary.
 *
 *  Parameters:
 *      const InfoField *t_Info : information to be packed
 *      uint8 uca_M[]           : output arrary containing the information
 *      idx                     : index of the starting position of the message array
 *
 *  Returns:
 *      idx                     : index of the ending position of the message array
 *
 *  Global Variables Used:
 *      gt_hsc.s_TxNSBCnt       : Number of non-standard blocks transmitted so far
 *
 *  Notes: each non-standard block needs be less than or equal to 64 octets
 *          except for the first block that needs to be less than or equal to 63 octets.
 *
 *------------------------------------------------------------------------
 */
int16 FormNonStandard(InfoField_t *t_Info, uint8 uca_M[], int16 idx )
{

    int i, s_maxMsgLen;
    const NonStandardBlock_t *pt_NSB;

    if (t_Info->uc_Type == M_CLR) s_maxMsgLen = MAX_COMPLETE_CLR_MESSAGE_LEN;
    else  s_maxMsgLen = MAX_COMPLETE_MESSAGE_LEN;

    if ( (t_Info->uc_ID_NPar1 & NON_STANDARD) != 0 )
    {

        /* ---- attach number of total blocks at the beginning of the first block ---- */
        if ( gt_hsc.s_TxNSBCnt == 0)
            uca_M[idx++] = t_Info->uc_NumBlock;

        /* ---- pack as many blocks within MAX_MESSAGE_LEN limit ---- */
        while ( ( gt_hsc.s_TxNSBCnt < t_Info->uc_NumBlock ) &&
                ( (idx + t_Info->ta_NS_Info[gt_hsc.s_TxNSBCnt].uc_NSLen) < s_maxMsgLen ) )
        {

            pt_NSB = &( t_Info->ta_NS_Info[ gt_hsc.s_TxNSBCnt ] );
            uca_M[idx++] = pt_NSB->uc_NSLen;
            /* ---- 2 country code octets, with the most significant octet first ---- */
            uca_M[idx++] = (uint8) ( t_Info->us_Country >> 8 );
            uca_M[idx++] = (uint8) ( t_Info->us_Country );

            /* ---- 4 vendor ID octets, with the most significant octet first ---- */
            for ( i = 0; i < 4; i++ )
                uca_M[idx++] = (uint8) ( t_Info->ul_Provider >> ((3-i) * 8) );

            /* ---- Vendor specific information ---- */
            for ( i = 0; i < (pt_NSB->uc_NSLen - 6); i++ )
                uca_M[idx++] = pt_NSB->puca_NSVendorSpec[i];

            gt_hsc.s_TxNSBCnt++;

        }   /*  while */

    }   /*  if */

    return ( idx );

}   /*  FormNonStandard         */

/*
 *------------------------------------------------------------------------
 *
 *  Name: DecodeMessage
 *
 *  Abstract:
 *
 *  DecodeMessage() - Check FCS and decode received message
 *
 *  Input Arguments:
 *      uint8 uca_Msg[]     - array of received message octets
 *      InfoField_t *t_I    - pointer to a InfoField structure that holds
 *                            the decoded information
 *
 *  Returns:
 *      returns the following error code:
 *      DECODE_SUCCESS          - decoding successfully done
 *      FCS_ERROR               - FCS error
 *      INVALID_MESSAGE         - invalid message
 *      INCOMPLETE_STANDARD     - only a partial standard information is received
 *      INCOMPLETE_NON_STANDARD - only a partial non-standard information is received
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 */

void DecodeMessage(void)
{

    int    idx, i;
    int16   s_MsgLen;
    int16   s_ReturnCode;
    uint16  us_FCS;
    uint8   *uca_M;
    uint8   *uca_Msg;
    InfoField_t *t_Info;


    s_ReturnCode = 0; /*  initialize */

    /* ========================================== */
    /* ==== Octet transparency and FCS check ==== */
    /* ==== then append to gpuca_DecodeBuf. ==== */
    /* ========================================== */

    uca_Msg = gpuca_RxMsgBuf;
    t_Info = gpt_RxInfo;

    uca_M = gpuca_DecodeBuf+gs_DecodeBufCnt; /*  setting where to append */
    idx = i = 0;        /*  initialize indeces */
    us_FCS = 0xFFFF;    /*  initialize to all binary 1's */

    while (uca_Msg[idx] != FLAG)
    {
        if ((i >= gs_MaxMsgLen + FCS_LEN) || (gs_DecodeBufCnt + i >= DECODE_BUF_LEN))
        {
            // If we are here, we are going to overflow _and_ we want to fail at overflow
            s_ReturnCode = GHS_MESSAGE_OVERFLOW ;
            goto return_from_decodemessage;
        }

        /* ---- octet transparency ---- */
        if ( uca_Msg[idx] == 0x7D )
        {
            idx++;
            uca_M[i] = uca_Msg[idx++] ^ 0x20;
        }
        else
        {
            uca_M[i] = uca_Msg[idx++];
        }

        /* ---- FCS check ---- */
        us_FCS = CalcCRC_Byte( uca_M[i], us_FCS, FCS_GEN_POLY );
        i++;

        /* ---- to ensure maximum message length (one segment) and decode buffer length ---- */
        if ( ((i >= gs_MaxMsgLen + FCS_LEN) || (gs_DecodeBufCnt + i >= DECODE_BUF_LEN))
                && (OPTNArray[OPTN_GhsControl]&OPTN_DisableFailOnRxOvfl) )
        {
            // Go on to try to decode (probably incomplete) message
            break;
        }
    }   /*  while */

#ifdef DEBUG_TRACES
    // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   //for debug purpose, log GHS messages recieved
   LogMessages(4,END_OF_THE_MSG,(uint16)uca_M[0], (uint16)i, uca_M, DEBUG_BUFFER_DELIMITER_GHS_RX_MSG);
   //gft_PauseOff=0;
   //Pause(0x49);
#endif //#ifdef DEBUG_TRACES

#ifdef DEBUG_STREAMING
    DSH_SendEvent(DSH_EVT_GHS_RX,(uint8)i,&uca_M[0]);
#endif

    /* ---- check for invalid message ---- */
    if (i+gs_DecodeBufCnt < MIN_MESSAGE_LEN)
    {
        s_ReturnCode = INVALID_MESSAGE;
#ifdef DEBUG_TRACES
      // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
      //for debug purpose, log GHS messages recieved
      LogMessages(1,END_OF_THE_MSG,DEBUG_BUFFER_DELIMITER_GHS_RX_MSG_INVALID);
#endif  //#ifdef DEBUG_TRACES

        goto return_from_decodemessage;
    }
    /* ---- check for FCS error ---- */
    else if (us_FCS != MAGIC_FCS_CHECK)
    {
        s_ReturnCode = FCS_ERROR;
#ifdef DEBUG_TRACES
      // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
      //for debug purpose, log GHS messages recieved
      LogMessages(1,END_OF_THE_MSG,DEBUG_BUFFER_DELIMITER_GHS_RX_MSG_FCS_ERROR);
#endif //#ifdef DEBUG_TRACES
        goto return_from_decodemessage;
    }

    /* ============================== */
    /* ==== Proceed, if no error ==== */
    /* ============================== */

    gs_RxMsgBufCnt   = i - FCS_LEN;         /*  number of data octets in current message segment NOT including FCS */
    gs_DecodeBufCnt += gs_RxMsgBufCnt;      /*  number of data octets in a total message */

    s_MsgLen         = gs_DecodeBufCnt;
    uca_M            = &gpuca_DecodeBuf[0];  /*  decoding starts from the beginning */


    /* ========================================================== */
    /* ==== for a standard message frame (the first segment) ==== */
    /* ========================================================== */

    idx = 0;

    /* ---- Message type and Revision number fields ---- */
    t_Info->uc_Type = uca_M[idx++];
    t_Info->uc_Rev  = uca_M[idx++];

    /* ---- Vendor ID (required only for CL and CLR messages) ---- */
    switch (t_Info->uc_Type)
    {
    case M_CL  :
#ifdef TEST_HS_DECODE
    case M_CLR:
#endif
        /* ---- 2 country code octets, with the most significant octet first ---- */
        t_Info->us_Country = uca_M[idx++];
        guca_fe_G9941_VendorID[0] = uca_M[idx-1];

        t_Info->us_Country <<= 8;
        t_Info->us_Country |= uca_M[idx++];
        guca_fe_G9941_VendorID[1] = uca_M[idx-1];

        /* ---- 4 vendor ID octets, with the most significant octet first ---- */
        t_Info->ul_Provider = uca_M[idx++];
        guca_fe_G9941_VendorID[2] = uca_M[idx-1];

        for ( i = 0; i < 3; i++ )
        {
            t_Info->ul_Provider <<= 8;
            t_Info->ul_Provider |= uca_M[idx++];

            guca_fe_G9941_VendorID[3+i] = uca_M[idx-1];
        }
        gul_fe_G994VendorID = t_Info->ul_Provider;

        /* ---- 2 octets of vendor specific information ---- */
        t_Info->us_VendorInfo = uca_M[idx++];
        guca_fe_G9941_VendorID[6] = uca_M[idx-1];

        t_Info->us_VendorInfo <<= 8;
        t_Info->us_VendorInfo |= uca_M[idx++];

        guca_fe_G9941_VendorID[7] = uca_M[idx-1];

        {
            int32   ul_fe_VendorID_Check;       //Added the 32 bit local var. for CTLM Vendor id//

            ul_fe_VendorID_Check = (guca_fe_G9941_VendorID[2]<<24)|(guca_fe_G9941_VendorID[3]<<16)|(guca_fe_G9941_VendorID[4]<<8)|(guca_fe_G9941_VendorID[5]);      /*  Extract the provider code (Vendor ID, 4 octets), Workaround for CTLM vendor id*/

#ifdef WORKAROUND_CTLM_VENDORID
            //Below 1 line added for testing thw work around logic with geminax co line card
            //if ((ul_fe_VendorID_Check == GHS_IFTN_ID) && (gft_WorkAround_CTLM_chipset == 0))  //Extract the CTLM DSLAM vendor id and check the flag

            //Extract the CTLM DSLAM vendor id and check the flag

            if (((ul_fe_VendorID_Check != GHS_CTLM_ID2)&&(ul_fe_VendorID_Check != GHS_CTLM_ID))
                    && (gft_WorkAround_CTLM_chipset == 1))
            {
                gft_WorkAround_CTLM_chipset = 0;
                gus_ExceptionCode = E_CODE_GHS_Dis_CTLMWorkAroundforNon_CTLM;
                gs_RxNextState = FAIL_RX;
                gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                gt_hsc.s_State = R_HS_EXIT;
                //XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start_End)
                guc_Forced_Retrain = 0x1;
            }

            if (((ul_fe_VendorID_Check == GHS_CTLM_ID2)||(ul_fe_VendorID_Check == GHS_CTLM_ID))
                    && (gft_WorkAround_CTLM_chipset == 0)
                    && ((OPTNArray[OPTN_GhsControl] & OPTN_DisableCTLMVendorIDChange) == 0))
            {

                //Below 1 line added for testing thw work around logic with geminax co line card

                //gs_CurrentCoChipset = IFTN_CO_CHIPSET;
                gft_WorkAround_CTLM_chipset = 0x1;       //Set the flag,if we detect the CTLM DSLAM//
                //Observation: Clear down is not working as expected for DMT mode
                //Initiate_NAK_CD() ;           //Do the clear down//
                //Drop the link using exception handler.
                //Exception codes have been set earlier, where l_SelectedMode was set
                gus_ExceptionCode = E_CODE_GHS_Dis_CTLMWorkAroundfor_CTLM;
                gs_RxNextState = FAIL_RX;
                gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                gt_hsc.s_State = R_HS_EXIT;           // so that Tx doesn't try to go on
                //XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start_End)
                guc_Forced_Retrain = 0x2;
            }
#endif
//XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (START)
//If the CO is IKNS, retrain and switch to AWRE VID.
#ifndef ISDN   // Only for Annex-A
           if ((ul_fe_VendorID_Check == GHS_IKNS_ID) &&
                gft_WorkAround_IKNS_US_Perf == 0)
           {
              gft_WorkAround_IKNS_US_Perf = 1;
              gus_ExceptionCode = E_CODE_GHS_IKNS_USPerf_ToAWRE_VID;
              gs_RxNextState = FAIL_RX;
              gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
              gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
           }
           //If the CO is not IKNS and the flag is set, retrain and
           //switch back to IFTN VID.
           if ((ul_fe_VendorID_Check != GHS_IKNS_ID) &&
                gft_WorkAround_IKNS_US_Perf != 0)
           {
              gft_WorkAround_IKNS_US_Perf = 0;
              gus_ExceptionCode = E_CODE_GHS_IKNS_USPerf_ToAWRE_VID;
              gs_RxNextState = FAIL_RX;
              gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
              gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
           }
#endif // #ifndef ISDN
//XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (END)

         //XDSLRTFW-1983
         //Issue with BRCM version 0x939B - workaround
         //We disable the workaround if the Vendor Specific Info
         //doesn't match the VDSL2 stored part, to allow possible VDSL2 training
         //gus_VendorSpecific_Info and gft_ATM_PTM_MisMatch_TTNet
         //are stored in VDSL2 Binary (PERSISTANT_COMMON) as we see the Mis match
           if(  (gft_ATM_PTM_MisMatch_TTNet == 1) &&
            (gus_VendorSpecific_Info != t_Info->us_VendorInfo) )
         {
         gft_ATM_PTM_MisMatch_TTNet = 0;
         }
         //XDSLRTFW-1983
        }

        break;

    case M_REQ_RTX:
        /* ---- 2 octets of retransmission information block ---- */
        t_Info->uc_last_received_msg_type = uca_M[idx++];
        t_Info->uc_request_msg_segment_index = uca_M[idx++];
        break;

    default:
        break;

    }   /*  switch (vendor ID) */

    /* ---- Service and Channel parameters, Standard and Non-Standard Information ---- */
    /* ---- only for MS, CL, CLR messges                                          ---- */
    switch (t_Info->uc_Type)
    {
    case M_MS :
    case M_CL :
#ifdef TEST_HS_DECODE
    case M_CLR:
#endif
        idx = DecodeStandard( uca_M, (int16)idx, s_MsgLen, t_Info ); /*  parameters and standard */
        // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (Start)
#ifndef ISDN   // Only for Annex-A
        // In cases where the MS is sent by CO, we check whether its ADSL2/2+ and the CO vendor-id
        // is TI/CNXT, then the AC7/CNXT flag is set,
        // since we need the US improvements in 2 & 2+ only as in DMT, the US performance of the
        // AR7 is almost same as that of Danube.
        if (t_Info->uc_Type == M_MS)
        {
            int32 l_fe_VendorID_Check;  // Added the 32 bit local var. for TI/CNXT Vendor id

            // Extract the provider  code (Vendor ID, 4 octets), Workaround for TI  AC7/CNXT vendor ID
            l_fe_VendorID_Check = (guca_fe_G9941_VendorID[2] << 24) | (guca_fe_G9941_VendorID[3] << 16) |
                                  (guca_fe_G9941_VendorID[4] << 8) | (guca_fe_G9941_VendorID[5]);

            // Disable the AC7/CNXT woarkaround flag because, this workaround is not needed in DMT
            // or if not AC7/CNXT
            if (!((gpt_RxInfoSave->uc_SI_SPar1[2] & (G992_3_A >> 16)) ||
                    (gpt_RxInfoSave->uc_SI_SPar1[3] & (G992_5_A >> 24)))) // Not ADSL2/2+ mode
            {
                if ((gft_USPerf_AC7) && (l_fe_VendorID_Check != GHS_TI_ID))
                {
                    gft_USPerf_AC7 = 0;
                    // Drop the link using exception handler.
                    // Exception codes have been set earlier, where l_SelectedMode was set
                    gs_RxNextState = FAIL_RX;
                    gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                    gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
                    //bhadra_set_flag
                }
               if ((l_fe_VendorID_Check == GHS_GSI_ID) && (gft_StartDMT_CNXT == FALSE))
               {
                  gft_StartDMT_CNXT = TRUE;
               }

              //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START)
              // If the VID is 0x0000 (certain CTLM DSLAMs), set the interop flag and restart
              if  ((l_fe_VendorID_Check == 0) && (!gft_USCRC_CTLM))
              {
                 gft_USCRC_CTLM = 1;
                 //Drop the link using exception handler.
                 gus_ExceptionCode = E_CODE_IOP_CHANGE_VID_TSTC;
                 gs_RxNextState = FAIL_RX;
                 gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                 gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
              }

              // If we were in CTLM interop mode and no longer with a CTLM DSLAM, exit the interop mode
              if  ((l_fe_VendorID_Check != 0) && (gft_USCRC_CTLM))
              {
                 gft_USCRC_CTLM = 0;
                 //Drop the link using exception handler.
                 gus_ExceptionCode = E_CODE_IOP_RESET_CHANGE_VID_FLAG;
                 gs_RxNextState = FAIL_RX;
                 gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                 gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
              }
              // XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (END)
                if ((l_fe_VendorID_Check == GHS_GSI_ID) && (!gft_DSPerf_CNXT))
                {
                    if ((gt_INFX_CMV.
                            s_DFE_Options & CMV_TO_FORCE_TI_VENDORID_CNXT) ==
                            CMV_TO_FORCE_TI_VENDORID_CNXT)
                    {
                        gft_DSPerf_CNXT = 1;
                    }
                    if (gft_DSPerf_CNXT)
                    {
                        // Set the flag,if we detect the CNXT DSLAM//
                        // Drop the link using exception handler.
                        // Exception codes have been set earlier, where l_SelectedMode was set
                        gs_RxNextState = FAIL_RX;
                        gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                        gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
                        //bhadra_set_flag
                    }
                }

            }
            // Extract the TI/CNXT DSLAM vendor id and check the flag
            // Enable the AC7/CNXT woarkaround flag because, this workaround is needed in ADSL2/2+
            else   // ADSL2/2+ mode
            {
                if ((l_fe_VendorID_Check == GHS_TI_ID) && (!gft_USPerf_AC7))
                {
                    gft_USPerf_AC7 = 1;   // Set the flag,if we detect the TI DSLAM//
                    // Drop the link using exception handler.
                    // Exception codes have been set earlier, where l_SelectedMode was set
                    gs_RxNextState = FAIL_RX;
                    gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                    gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
                    //bhadra_set_flag
                }
                //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
                // Move this setting to Source\Bis\Algorithms\bitload_bis.c
                // SMS01221899 Feature_DS_All_All_EnableOneStepSRA (START)
                //if ((gt_INFX_CMV.us_OperatorSpBits2 & CMV_TO_ENABLE_ONE_STEP_SRA))
                //    TESTArray[TEST_OLR_SRA_DeltaLpchange] = 0x7fff; // corresponds to maximum value for SRA step size
                // This ensures that the SRA will complete in 1 step
                // because comparison of required step will always be less than
                // this max value
                // SMS01221899 Feature_DS_All_All_EnableOneStepSRA (END)
                //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)
                // SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (Start)
               if ((l_fe_VendorID_Check == GHS_GSI_ID) && (gft_StartDMT_CNXT == TRUE))
               {
                  gft_StartDMT_CNXT = FALSE;
                  gs_RxNextState = FAIL_RX;
                  gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                  gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
               }
               // SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (END)
                if ((gft_DSPerf_CNXT) && (l_fe_VendorID_Check != GHS_GSI_ID))
                {
                    gft_DSPerf_CNXT = 0;

                    // Drop the link using exception handler.
                    // Exception codes have been set earlier, where l_SelectedMode was set
                    gs_RxNextState = FAIL_RX;
                    gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                    gt_hsc.s_State = R_HS_EXIT; // so that Tx doesn't try to go on
                    //bhadra_set_flag
                }
              //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START)
              // This fix does not apply in ADSL2/2+
              if  (gft_USCRC_CTLM)
              {
                 gft_USCRC_CTLM = 0;
                 //Drop the link using exception handler.
                 gus_ExceptionCode = E_CODE_IOP_CHANGE_VID_TSTC;
                 gs_RxNextState = FAIL_RX;
                 gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                 gt_hsc.s_State = R_HS_EXIT;            // so that Tx doesn't try to go on
              }
              //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (END)
            }
        }
#endif // ifndef ISDN
        // IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (End)

        if ( idx == 0 )
        {
            guc_RxHSMsg_SegmentCnt++;

            s_ReturnCode = INCOMPLETE_STANDARD;
            goto return_from_decodemessage; /*  note that gs_DecodeBufCnt is not reset here */
        }

        if ( (t_Info->uc_ID_NPar1 & NON_STANDARD) != 0 )
        {
            if (idx < s_MsgLen)
            {
                idx = DecodeNonStandard( uca_M, (int16)idx, s_MsgLen, t_Info ); /*  non standard */
                if ( idx == 0 )
                {
                    s_ReturnCode = INCOMPLETE_NON_STANDARD;
                    goto return_from_decodemessage; /*  note that gs_DecodeBufCnt is not reset here */
                }
#ifndef ISDN   // Only for Annex-A
              // 1. Set ALA2-CO: (these COs transmit 0x00 vendor ID and GHS_ALA_ID in NSIF)
              // 2. Enable the SyncScaling for ALA2-COs
              if ((t_Info->ta_NS_Info[0].NSIF_VendorID == GHS_ALA_ID)
              //SMS01261911 SMS01246527 IOP_A_DS_ADSL1_ALA3_CheckAuxPilot_Medley (START)
              //Litespan 2k DSLAM sends 0xFF00 vender ID and GHS_ALA_ID in NSIF
              && ((gpt_RxInfo->ul_Provider == GHS_0000_ID)||(gpt_RxInfo->ul_Provider == GHS_FF00_ID)
              //SMS01261911 SMS01246527 IOP_A_DS_ADSL1_ALA3_CheckAuxPilot_Medley (END)
              //XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (START)
              //Marconi MX QDC-1 sends 0x80000 vender ID and GHS_ALA_ID in NSIF
                  ||(gpt_RxInfo->ul_Provider == GHS_80000_ID)))
              //XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (END)
#else // Only for Anx-B
              if ((t_Info->ta_NS_Info[0].NSIF_VendorID == GHS_ALA_ID) &&
                  (gs_CurrentCoChipset == GENERIC_CO_CHIPSET))
#endif // ifndef ISDN
                {
                    gft_SyncScalingForGenericCOinDMT = 0x1;  // Enable the flag upon detecting the NSIF information and Generic CO chip set
#ifndef ISDN   // Only for Annex-A
                   //SMS01261911 SMS01246527 IOP_A_DS_ADSL1_ALA3_CheckAuxPilot_Medley (START)
                   if(gpt_RxInfo->ul_Provider == GHS_0000_ID)
                     gs_CurrentCoChipset = ALA2_CO_CHIPSET;
                   //XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (START)
                   else if (gpt_RxInfo->ul_Provider == GHS_FF00_ID)
                     gs_CurrentCoChipset = ALA3_CO_CHIPSET;
                   //SMS01261911 SMS01246527 IOP_A_DS_ADSL1_ALA3_CheckAuxPilot_Medley (END)
                   else
                     gs_CurrentCoChipset = ALA4_CO_CHIPSET;
                   //XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (END)
#endif // ifndef ISDN
                }

            }
            else
            {
                s_ReturnCode = INCOMPLETE_NON_STANDARD;
                goto return_from_decodemessage; /*  note that gs_DecodeBufCnt is not reset here */
            }
        }
        else
        {
            t_Info->uc_NumBlock = 0;
        }

        break;

    }   /*  switch */

    gs_DecodeBufCnt = 0;    /*  reset for next message */
    s_ReturnCode = DECODE_SUCCESS;
    guc_RxHSMsg_SegmentCnt = 0;  // reset Rx msg segment counter

return_from_decodemessage:

    if (s_ReturnCode == DECODE_SUCCESS)
        // at this point, we should clear DecodeBuffer in case the previous remain can
        // affect the next received msg
        memset(gpuca_DecodeBuf, 0, DECODE_BUF_LEN);

    gt_hsc.s_DecodeResult = s_ReturnCode;
    guc_DecodeMsgState = HS_DECODE_MSG_DONE;

}   /*  DecodeMessage */

/*
 *------------------------------------------------------------------------
 *
 *  Name:   SkipExtraOctet, and
 *       CheckIncompleteMsg
 *
 *  Abstract:
 *
 * ---- Macro to ignore extra octets if there are any
 * ---- Checking for an incomplete message is needed here
 * ---- to prevent possible infinite loop
 *
 *  Input Arguments:
 *      uint8 uca_M[]       - array of received message octets
 *      idx                 - index of the starting position of the message array
 *      s_MsgLen            - total number of octets in uca_M
 *
 *  Returns:
 *      idx                 - index of the ending position of the message array
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 */
int16 SkipCountExtraOctet(uint8 uca_M[], int16 idx, int16 s_MsgLen, uint8 *puc_ExtraBits)
{
    // DELIMIT_N = 1<<DELIM_LOC => s_delim_loc=6 for DELIMIT_2, 7 for DELIMIT_1

    int i ;

    while ( (uca_M[idx-1] & DELIMIT_1) == 0 )
    {
        for (i=0 ; i<7 ; i++)
        {
            if (uca_M[idx]>>i & 0x1)
                (*puc_ExtraBits)++ ;
        }
        idx++;
        /* check for incomplete message */
        if ( idx > s_MsgLen )
            break;
    }
    return(idx);
}


int16 SkipExtraOctet( uint8 uca_M[], int16 idx, int16 s_MsgLen, int16 s_delimiter )
{

    while ( (uca_M[idx-1] & s_delimiter) == 0 )
    {
        idx++;
        /* check for incomplete message */
        if ( idx > s_MsgLen )
            break;
    }
    return(idx);
}

/*---- macro to check if a message is incomplete ----*/
#define CheckIncompleteMsg( idx, MsgLen, stdEnd ) {  \
        if ( (idx) > (MsgLen) && (!stdEnd) )                  \
            return (0);                          \
    }



/*
 *------------------------------------------------------------------------
 *
 *  Name: int16 DecodeStandard_Bis(uint8 uca_M[], int16 idx, int16 s_MsgLen, Adsl2AllInfo_t *pt_BisInfo, FlagT ft_BisOrPlus,uint8 uc_msg )
 *
 *
 *  Abstract: decode standard information
 *
 *  Input Arguments:
 *      uint8 uca_M[]       - array of received message octets
 *      Adsl2AllInfo_t *pt_BisInfo    - pointer to a Bis or BisPlus component of InfoField
 *      idx                 - index of the starting position of the message array
 *      s_MsgLen            - total number of octets in uca_M
 *    ft_BisOrPlus      - Flag indicates ADSL2 or ADSL2+, 0: ADSL2; 1: ADSL2+
 *
 *  Returns:
 *      idx                 - index of the ending position of the message array
 *                            It is set to zero if the current message is not complete.
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 */
#define ENABLE_TSSI_COMPARE
#ifndef BIS_CODESWAP
extern int16 gs_COTSSI_NumOfBrkpts;
#endif
//XDSLRTFW-1502 (start_end)
int16 DecodeStandard_Bis(uint8 uca_M[], int16 idx, int16 s_MsgLen, Adsl2AllInfo_t *pt_BisInfo, Adsl2AllInfo_t *pt_BisInfo_Tx, FlagT ft_BisOrPlus, uint8 uc_msg  )
{

   int i, j,k; //SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Start_End //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)
   PMD_Type_t *pta_PMD_NPar3[2] =
      { &(pt_BisInfo->t_PMD_NPar3_US), &(pt_BisInfo->t_PMD_NPar3_DS) };
   uint16 us_Max_NUM_Tssi[2] =
      { MAX_NUM_US_TSSI_VALUES, MAX_NUM_DS_TSSI_VALUES };
   int16 *psa_Num_Tssi[2] = { &gsa_num_US_Tssi_brkpt[ft_BisOrPlus],
      &gsa_num_DS_Tssi_brkpt[ft_BisOrPlus]
   };
   int16 *psa_Num_Tssi_Kept[2] = { &gsa_num_US_Tssi_brkpt_kept[ft_BisOrPlus],
      &gsa_num_DS_Tssi_brkpt_kept[ft_BisOrPlus]
   };
   int16 *psa_MSGOvhdMinRate[2] = { &pt_BisInfo->t_Overhead.s_DSMSGOvhdMinRate,
      &pt_BisInfo->t_Overhead.s_USMSGOvhdMinRate
   };
   uint8 *puca_Max_Num_STM_TPS_TC[2] = { &pt_BisInfo->uc_DS_Max_Num_STM_TPS_TC,
      &pt_BisInfo->uc_US_Max_Num_STM_TPS_TC
   };
   uint8 *puca_Max_Num_ATM_TPS_TC[2] = { &pt_BisInfo->uc_DS_Max_Num_ATM_TPS_TC,
      &pt_BisInfo->uc_US_Max_Num_ATM_TPS_TC
   };
   uint8 *puca_Max_Num_PTM_TPS_TC[2] = { &pt_BisInfo->uc_DS_Max_Num_PTM_TPS_TC,
      &pt_BisInfo->uc_US_Max_Num_PTM_TPS_TC
   };
    int16 us_BreakFreq, us_Tssi;
    uint8 ft_InSprtSet, *puca_BreakFreq = NULL;
    FlagT ft_NoExtendedFrame_CL;
   //XDSLRTFW-1080 : IOP_GHS_WorkAround (start_end)
    uint8 uc_TPSTC_Type = 0;
    int s_shift;
    //XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_End)
    uint8 uc_Flag1 = 0, uc_tempMaxVal = 0,uc_temppwrtwo = 0;
    // XDSLRTFW-1502  (start)
    for(i=0; i<NUM_SI_NPAR2_OCTETS; i++)
    {
        pt_BisInfo->uc_SI_NPar2[i] = uca_M[idx++] & NEG_DELIMIT_2;
        if((uc_msg == M_MS) &&(i == 1))
            gt_ErasureDecoding_Reprt.ft_Report_ED = (pt_BisInfo->uc_SI_NPar2[i] & REPORT_ED);
        if ((uca_M[idx-1] & DELIMIT_2) != 0)
            break;
    }

    idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_2);
    CheckIncompleteMsg(idx, s_MsgLen, 0);
    // XDSLRTFW-1502 (end)

    // Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting ( End)

    /* ---- check if level 2 parameter ends here ---- */
    if ( (uca_M[idx-1] & DELIMIT_1) != 0 )
        return(idx);

    /* first reset SPar2 octets info in hnshk msg structure */
    for (i = 0; i < NUM_SI_SPAR2_OCTETS; i++)
        pt_BisInfo->uc_SI_SPar2[i] = 0;

    for(i=0; i<NUM_SI_SPAR2_OCTETS; i++)
    {
        pt_BisInfo->uc_SI_SPar2[i] = uca_M[idx++] & NEG_DELIMIT_2;
        if ((uca_M[idx-1] & DELIMIT_2) != 0)
            break;
    }

    idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
    CheckIncompleteMsg(idx, s_MsgLen, 0);

    for (j = 0; j < 2; j++)
    {
        /* decode upstream spectrum bounds info */
        if ( (pt_BisInfo->uc_SI_SPar2[0] & (0x1<<(2*j))) != 0 )
        {
            idx = DecodePmdSpectrumBoundParameters(pta_PMD_NPar3[j] , uca_M, idx, s_MsgLen);

            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 ); /* skip any  extra octets received */
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }
        else
        {
            pta_PMD_NPar3[j]->s_NOMPSD    = 0;
            pta_PMD_NPar3[j]->s_MAXNOMPSD = 0;
            pta_PMD_NPar3[j]->s_MAXNOMATP = 0;
        }



        /* decode spectrum shaping info */
        if ( (pt_BisInfo->uc_SI_SPar2[0] & (0x1<<(2*j+1))) != 0 )
        {
            for (i = 0; i < (us_Max_NUM_Tssi[j]+7)/8; i++)
                pta_PMD_NPar3[j]->pf_InSprtSet[i] = 0;

            i=0;
            *(psa_Num_Tssi[j]) = 0;
            *(psa_Num_Tssi_Kept[j]) = 0;
            if (j == 0)
                puca_BreakFreq = (uint8*)(void *)pta_PMD_NPar3[j]->pus_BreakFreq;
            while (1)
            {
                // we are using new G.HS standard to code/decode tssi info, i.e., 4octets per pair
                us_BreakFreq = (uca_M[idx++] & NEG_DELIMIT_2) << 6;  /* bits 7 to 12 */
                us_BreakFreq |=  (uca_M[idx++] & NEG_DELIMIT_2) ; /* bits 1 to 6 */
                ft_InSprtSet = (uca_M[idx] & 0x20) >> 5; /*Indication bit */
                us_Tssi    = ((uca_M[idx++] & NEG_DELIMIT_2) & 0x1)<< 6; /* bit 7 */
                us_Tssi     |=  uca_M[idx++] & NEG_DELIMIT_2;        /* bits 1 to 6 */

                /* to protect against possible overflow, i.e., the received tssi info is more than the array we defined can contain */

                // !!ysun: Maybe we can optimize Tssi logging by taking advantage of GHS msg segmentation.
                // The reason is that if we get overflow, Tssi info is definitely transmitted in multiple msg segments
                // So we can get info, like how many brk points CO actually sent to us, when we get the complete Tssi info
                // We can decide how to log the Tssi at that point. For example, we can make sure that the breakpoints we
                // saved at least should contain the first and last tone in the SUPPORTEDset.
                // For now, we can save up to 32 brkpts in US, and 50 in DS.
                if (i < us_Max_NUM_Tssi[j])
                {
                    if (j == 0)
                        puca_BreakFreq[i] = (uint8)us_BreakFreq;
                    else
                        pta_PMD_NPar3[j]->pus_BreakFreq[i] = us_BreakFreq;

                    s_shift = i & 0x7;
                    pta_PMD_NPar3[j]->pf_InSprtSet[i>>3] |= ((ft_InSprtSet & 0x1) << (s_shift));

                    pta_PMD_NPar3[j]->puc_tssi[i]= (uint8)us_Tssi;

                    *(psa_Num_Tssi_Kept[j]) = i+1;
                }


                i++;
                *(psa_Num_Tssi[j]) = i;

                /* ---- check if level 3 spectrum shaping parameter ends here ---- */
                if ( (uca_M[idx-1] & DELIMIT_2) != 0 )
                {
                    break;
                }

                // break out if there is infinite loop
                CheckIncompleteMsg(idx, s_MsgLen, 0);
            }
        }
    }

#ifndef BIS_CODESWAP
    if (TESTArray[TEST_ReconfigControl] & TEST_USTssi_Inconsistency)
    {
        pt_BisInfo->uc_SI_SPar2[0] |= SPECTRUM_SHAPE_UP;
        gsa_num_US_Tssi_brkpt[ft_BisOrPlus] = gs_COTSSI_NumOfBrkpts;
        if (gs_COTSSI_NumOfBrkpts > MAX_NUM_US_TSSI_VALUES)
            gsa_num_US_Tssi_brkpt_kept[ft_BisOrPlus] = MAX_NUM_US_TSSI_VALUES;
        else
            gsa_num_US_Tssi_brkpt_kept[ft_BisOrPlus] = gs_COTSSI_NumOfBrkpts;
    }
#endif


    /* decode transmit signal images above nyquist frequency */
    if ( (pt_BisInfo->uc_SI_SPar2[0] & TX_IMAGE_NYQ) != 0 )
    {
        pt_BisInfo->uc_TxSignalNyq      = (uca_M[idx++] & NEG_DELIMIT_2) ;

        idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
        CheckIncompleteMsg(idx, s_MsgLen, 0);
    }
    else
    {
        pt_BisInfo->uc_TxSignalNyq  = 0;
    }

    //Decode the Submode PSD mask if SPar2 bit set
    if ( (pt_BisInfo->uc_SI_SPar2[0] & PSD_MASK) != 0 )
    {
        pt_BisInfo->uca_PSD_Mask[0] = (uca_M[idx++] & NEG_DELIMIT_2);

        // If the last octet(s) in the NPar3 block is 0, it is allowed not transmitting it
        // if the delimit bit is set at the previous octet.
        if ((uca_M[idx-1] & DELIMIT_2) == 0 )
            pt_BisInfo->uca_PSD_Mask[1] = uca_M[idx++] & NEG_DELIMIT_2;
        else
            pt_BisInfo->uca_PSD_Mask[1] = 0;

        idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
        CheckIncompleteMsg(idx, s_MsgLen, 0);
    }


    /* overhead data rate */
    for (j = 0; j < 2; j++)
    {
        if ( (pt_BisInfo->uc_SI_SPar2[1] & (0x1<<j)) != 0 )
        {
            *(psa_MSGOvhdMinRate[j]) = (uca_M[idx++] & NEG_DELIMIT_2)+1;
            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }
    }

    /* maximum number of TPS-TC functions of each type */
    for (j = 0; j < 2; j++)
    {
        if ( (pt_BisInfo->uc_SI_SPar2[1] & (0x1 << (j+2))) != 0 )
        {
            *(puca_Max_Num_STM_TPS_TC[j]) = (uca_M[idx++] & 0x07);
            *(puca_Max_Num_ATM_TPS_TC[j]) = (uca_M[idx-1] & NEG_DELIMIT_2) >> 3;

            if ((uca_M[idx-1] & DELIMIT_2) == 0)
                *(puca_Max_Num_PTM_TPS_TC[j]) = (uca_M[idx++] & NEG_DELIMIT_2);
            else //all zero value can be omitted
                *(puca_Max_Num_PTM_TPS_TC[j]) = 0;

            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }
    }

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
    for (i=5 ; i<6; i++)   //Starting "i" value changed from "4" to "5". Inline with ARx firmware.
    {                //Chnage in "i" vaalue helped to extract the valid number of downstream virtual noise break points.
        if ( (pt_BisInfo->uc_SI_SPar2[1] & (0x1<<i)) != 0 )
      {
        //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
        if ((i == 5) && ((gs_DSL_FeaturesControl & DSL_Enable_DS_VirtualNoise) == DSL_Enable_DS_VirtualNoise))
        {
           gus_NumbDsVnBrkPoints = (uca_M[idx++] & NEG_DELIMIT_2);   // 0x45 Npar3 Decoding,We Rx 5 Bp by def.
        }
        else
        {
           idx++;
        }
        //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

         idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_2);
         CheckIncompleteMsg(idx, s_MsgLen, 0);
      }
   }


    for (i = 0; i < MAX_BEARER_CHANNEL; i++)
    {

        for (j = 0; j < 3; j++)
        {
            /* DS TPS-TC type */
            if ( (pt_BisInfo->uc_SI_SPar2[2*(i+1)] & (0x1 << (2*j))) != 0 )
            {
                //XDSLRTFW-1502 (start_end)
               idx = DecodeTpsTCParameters(&pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j], &pt_BisInfo_Tx->ta_DSBearerChannel[i].ta_TpsTcType[j], uca_M, idx, s_MsgLen, (int16)j, 1, ft_BisOrPlus , uc_msg);

                /*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
                if((i==0) && (j==2))
                {
                  pt_BisInfo ->uc_PtmOctet_DS_BC0 = guc_PtmOctet;
                  //XDSLRTFW-1080 : IOP_GHS_WorkAround (start)
                  #ifdef ISDN
                  uc_TPSTC_Type |= TPSTC_FUNC_PTM_DN;
                  #endif
                  //XDSLRTFW-1080 : IOP_GHS_WorkAround (end)
                }
#endif//if defined DANUBE_PTM_SUPPORT
                /*********************************PTM CHANGES*************************************/
                idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );       /* skip any extra octets received */
                CheckIncompleteMsg(idx, s_MsgLen, 0);
            }
            else
                ZeroTpsTCParameters(&pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j]);

            /* US TPS-TC type */
            if ( (pt_BisInfo->uc_SI_SPar2[2*(i+1)] & (0x1 << (2*j+1))) != 0 )
            {
                //XDSLRTFW-1502 (start_end)
               idx = DecodeTpsTCParameters(&pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j], &pt_BisInfo_Tx->ta_USBearerChannel[i].ta_TpsTcType[j], uca_M, idx, s_MsgLen, (int16)j, 0, ft_BisOrPlus, uc_msg);

                /*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
                if((i==0) && (j==2))
                {
                  pt_BisInfo ->uc_PtmOctet_US_BC0 = guc_PtmOctet;
                  //XDSLRTFW-1080 : IOP_GHS_WorkAround (start)
                  #ifdef ISDN
                  uc_TPSTC_Type |= TPSTC_FUNC_PTM_US;
                  #endif
                  //XDSLRTFW-1080 : IOP_GHS_WorkAround (end)
                }
#endif//if defined DANUBE_PTM_SUPPORT
                /*********************************PTM CHANGES*************************************/
                idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );       /* skip any extra octets received */
                CheckIncompleteMsg(idx, s_MsgLen, 0);
            }
            else
            {
                ZeroTpsTCParameters(&pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j]);
            }

        }
         //XDSLRTFW-1080 : IOP_GHS_WorkAround (start)
//#ifdef ISDN
         if(((uc_TPSTC_Type & TPSTC_FUNC_PTM)!= 0)
             &&((uc_TPSTC_Type & TPSTC_FUNC_ATM)== 0)
             &&(gft_NoVDSL_CLR == FALSE)
            )
         {
            gft_NoVDSL_CLR = TRUE;
            guc_Forced_Retrain = TRUE;
            //Quit HNSK , PTM mode indication intentional Retrain
            gus_ExceptionCode = E_CODE_GHS_ALL_PTM_ENABLED;
            gs_RxNextState = FAIL_RX;      // Force the  Rx to FAIL State
            gus_ExceptionState = gs_RxState;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
            gt_hsc.s_State = R_HS_EXIT;

         }
//#endif
         //XDSLRTFW-1080 : IOP_GHS_WorkAround (end)


        /* PMS-TC parameters */
        /* DS latency path */
        if ( (pt_BisInfo->uc_SI_SPar2[2*(i+1)+1] & LATENCY_PATH_DN) != 0 )
        {

            if (i == 0)
            {
                pt_BisInfo->ta_DSLatencyPath[0].s_MaxDataRate  = (uca_M[idx++] & NEG_DELIMIT_2) << 6; /* max net data rate, bits 12 to 7 */
                if ( (uca_M[idx-1] & DELIMIT_2) == 0 )
                {
                    pt_BisInfo->ta_DSLatencyPath[0].s_MaxDataRate |=  uca_M[idx++] & NEG_DELIMIT_2;   /* max net data rate, bits 1 to 6 */
                    if ((uca_M[idx-1] & DELIMIT_2) == 0)
                    {
                        ft_NoExtendedFrame_CL = FALSE;

                        //continue with S0 min
                        pt_BisInfo->ta_DSLatencyPath[0].s_OneOverS0min = (uca_M[idx++] & NEG_DELIMIT_2) + 1;

                        if (!gft_DisableExtendedFrame)
                            gft_GHS_S0min_Negotiated = TRUE;

                        if ((uca_M[idx-1] & DELIMIT_2) == 0)
                        {
                            //continue with D0 supported
                            pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask = uca_M[idx++] & NEG_DELIMIT_2;
                            if((uca_M[idx-1] & DELIMIT_2) == 0)
                            {
                                pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask |= (uca_M[idx++] & NEG_DELIMIT_2)<<6;
                                //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (Start)
#ifdef ADSL_62
                                //Extract the Support for 24K dilv buffer size
                                if (((uca_M[idx] & IlV_MEMSIZE_BYTES24KB) && (gt_INFX_CMV.us_Ena_Extended_D_IFX & MASK_ENA_EXT_ILV_BUF)) &&
                                        ((gpt_RxInfo->uc_SI_SPar1[3] & (G992_5_B >> 24)) ||
                                         (gpt_RxInfo->uc_SI_SPar1[3] & (G992_5_I >> 24))  ||
                                         (gpt_RxInfo->uc_SI_SPar1[3] & (G992_5_A >> 24))  ||
                                         (gpt_RxInfo->uc_SI_SPar1[3] & (G992_5_J >> 24))  ||
                                         (gpt_RxInfo->uc_SI_SPar1[4] & (G992_5_M))))
                                {
                                    gft_Ilv_Buf24k = TRUE;          // Kept for Debug purpose
                                    gl_DS_Intlv_buf_size = 24000;
                                }
#endif
                                //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory(End)
                                if((uca_M[idx-1] & DELIMIT_2) == 0)
                                    pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask |= (uca_M[idx++] & NEG_DELIMIT_2)<<12;
                            }
                        }
                        else
                            pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask = 0;
                    }
                    else
                    {
                        ft_NoExtendedFrame_CL = TRUE;

                    }
                }
                else
                {
                    ft_NoExtendedFrame_CL = TRUE;
                }

                if (ft_NoExtendedFrame_CL)
                {
                    //Set S0min and D0 mask to be default values
                    if (ft_BisOrPlus)
                        pt_BisInfo->ta_DSLatencyPath[0].s_OneOverS0min = 3;
                    else
                        pt_BisInfo->ta_DSLatencyPath[0].s_OneOverS0min = 2;

                    pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask = 0;
                }
            }
            else
                idx = DecodePmsTCParameters(&pt_BisInfo->ta_DSLatencyPath[i], uca_M, idx, s_MsgLen);

            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }

        /* US latency path */
        if ( (pt_BisInfo->uc_SI_SPar2[2*(i+1)+1] & LATENCY_PATH_UP) != 0 )
        {
            if ( i == 0)
            {
                pt_BisInfo->ta_USLatencyPath[0].s_MaxDataRate  = (uca_M[idx++] & NEG_DELIMIT_2) << 6; /* max net data rate, bits 12 to 7 */
                if ( (uca_M[idx-1] & DELIMIT_2) == 0 )
                    pt_BisInfo->ta_USLatencyPath[0].s_MaxDataRate |=  uca_M[idx++] & NEG_DELIMIT_2;      /* max net data rate, bits 1 to 6 */
                //XDSLRTFW-148: SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start)
                // upstream PMS-TC enhanced interleaver depth, Extract NPAR3 Octet Latency path #0
                //XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup (Start_End)
                if (gt_ApiOptions.us_Opt_Offset0 & CMV_TO_ENABLE_US_INLV_DEPTH_STD)
                {
                    if((uca_M[idx - 1] & DELIMIT_2) == 0)
                    {

                        gt_Optional_US_InlvDepth.us_US_D0Max_Rx_CL = (uca_M[idx++] & NEG_DELIMIT_2);   // 0x3F
                        uc_temppwrtwo  = gt_Optional_US_InlvDepth.us_US_D0Max_Rx_CL & 0x30;  // Extract 6 to 5 bits

                        if(uc_temppwrtwo == 0)        // Extract 6 to 5
                        {
                            uc_tempMaxVal = gt_Optional_US_InlvDepth.us_US_D0Max_Rx_CL & 0x0F;  // Extract 4 to 1

                            if((uc_tempMaxVal == 2) || (uc_tempMaxVal == 6) || (uc_tempMaxVal == 0xE))
                            {
                                gt_Optional_US_InlvDepth.us_US_D0Max_Rx_CL = uc_tempMaxVal;
                                uc_Flag1 = 1;
                            }
                        }

                        if(uc_Flag1 == 0)
                        {
                            gt_Optional_US_InlvDepth.us_US_D0Max_Rx_CL = 0;         // For Non Zero D0_Max_  set Def 8
                        }
                    }
                }
                //XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (End)
            }
            else
                idx = DecodePmsTCParameters(&pt_BisInfo->ta_USLatencyPath[i], uca_M, idx, s_MsgLen);

            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }
      /*Decode ReTxinformation here */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
      k = 2;
#ifdef UNV_RETX_GHS
      if((i == 0) && (gt_ReTxConfigInfo.us_ReTxConfigOptionBits & CMV_BIT_INDICATE_RETX))
      {
         //Decode ATM-TM TPS-TC #0 RETX in downstream Npar3
         k++;

         if ((pt_BisInfo->uc_SI_SPar2[3] & TPSTC_RETX_ATM_DN) != 0)
         {

            // This byte is reserved and should be zero.
            gt_ReTxConfigInfo.ft_ReTxOn = 1;
            pt_BisInfo->uc_Atm_ReTx0_DS = (uca_M[idx++] & NEG_DELIMIT_2);
            idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_2);
            CheckIncompleteMsg(idx, s_MsgLen, 0);
         }
         //Decode PTM-TM TPS-TC #0 RETX in downstream Npar3
         k++;
         if ((pt_BisInfo->uc_SI_SPar2[3] & TPSTC_RETX_PTM_DN) != 0)
         {
            gt_ReTxConfigInfo.ft_ReTxOn = 1;
            pt_BisInfo->uc_Ptm_ReTx0_DS = (uca_M[idx++] & NEG_DELIMIT_2);
            pt_BisInfo->uc_Ptm_ReTx0_DS &= 0x3; // (Bit1|Bit0) only
            idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_2);
            CheckIncompleteMsg(idx, s_MsgLen, 0);
         }
         //check for valid MS message
         if( gpt_RxInfo->uc_Type == M_MS)
         {
            if((pt_BisInfo->uc_SI_SPar2[3]&TPSTC_RETX_ATM_PTM_DN)
                == TPSTC_RETX_ATM_PTM_DN)
            {
               //Both DS ATM TPS-TC #0 RETX and DS PTM TPS-TC#0 RETX are set in MS
               //This setting is not valid
               gft_ReTx_ATM_PTM = 1;
               gus_ExceptionCode = E_CODE_GHS_ReTx_DS_ATM_PTM_BOTH_ENABLED;
            }
        }
        else gt_ReTxConfigInfo.ft_ReTxOn = 0;
      }
#endif
      for (j = k; j < 6; j++)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
        {
            if ( (pt_BisInfo->uc_SI_SPar2[2*(i+1)+1] & (0x1<<j)) != 0 )
            {
                idx++ ;
                idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_2);
                CheckIncompleteMsg(idx, s_MsgLen, 0);
            }
        }
    }

    idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
    CheckIncompleteMsg(idx, s_MsgLen, 1);
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
//verification of MS message
// XDSLRTFW-1653 (Start)
#if 0
#ifdef UNV_RETX_GHS
   if( (gpt_RxInfo->uc_Type == M_MS)&& (gt_ReTxConfigInfo.us_ReTxConfigOptionBits & CMV_BIT_INDICATE_RETX ))
   {
      if(pt_BisInfo->uc_SI_SPar2[3]& TPSTC_RETX_ATM_PTM_DN)
      {
         //If the Downstream ATM TPS-TC #0 RETX or the Downstream PTM TPS-TC #0 RETX
         // Spar(2) bit is set to ONE in the MS message, then all Downstream STM TPS-TC #n,
         //Downstream ATM TPS-TC #n, and Downstream PTM TPS-TC #n Spar(2) bits
         //(for n = 0, 1, 2,and 3) shall be set to ZERO in the MS message.
         // Reference A2.2 of G.inp
         for (i = 0; i < MAX_BEARER_CHANNEL; i++)
         {
            for (j = 0; j < 3; j++)
            {
               if ((pt_BisInfo->uc_SI_SPar2[2 * (i + 1)] & (0x1 << (2 * j))) != 0)
               {
                  gft_ReTx_MS_incorrect = 1;
                  gus_ExceptionCode = E_CODE_GHS_DS_STM_ATM_PTM_SetInReTx;
                  break;
               }
            }
            if(gft_ReTx_MS_incorrect == 1) break;
         }
      }
   }
#endif //UNV_RETX_GHS
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
#endif
// XDSLRTFW-1653 (End)
    return(idx);

}

/*
 *------------------------------------------------------------------------
 *
 *  Name: DECODE_STANDARD
 *
 *  Abstract: decode standard information
 *
 *  Input Arguments:
 *      uint8 uca_M[]       - array of received message octets
 *      InfoField_t *t_I    - pointer to a InfoField structure that holds
 *                            the decoded information
 *      idx                 - index of the starting position of the message array
 *      s_MsgLen            - total number of octets in uca_M
 *
 *  Returns:
 *      idx                 - index of the ending position of the message array
 *                            It is set to zero if the current message is not complete.
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 */
#define NUM_ID_ATTEN_FIELDS      11
int16 DecodeStandard( uint8 uca_M[], int16 idx, int16 s_MsgLen, InfoField_t *t_Info )
{
#ifndef ISDN   // Only for Anx-A
    // R3_P1: AR8_TF: IOP_DS_ALL_CNXT_IgnoreMultBitsMsDELT (Start_End)
    InfoField_t *pt_RxCL;
#endif // ifndef ISDN
    uint8 uc_temp,uc_spar1_common, remainderSkipped;
    int i, j;

    uint8 *puca_MaxNDR[2] = {&t_Info->uc_UpMaxNDR, &t_Info->uc_DnMaxNDR};
    uint8 *puca_MinNDR[2] = {&t_Info->uc_UpMinNDR, &t_Info->uc_DnMinNDR};
    uint8 *puca_AvgNDR[2] = {&t_Info->uc_UpAvgNDR, &t_Info->uc_DnAvgNDR};
    uint8 *puca_MaxLat[2] = {&t_Info->uc_UpMaxLat, &t_Info->uc_DnMaxLat};
    uint8 *puca_AvgLat[2] = {&t_Info->uc_UpAvgLat, &t_Info->uc_DnAvgLat};
    uint8 *puca_Splitter[2] = {&t_Info->uc_ID_NPar2_O11, &t_Info->uc_ID_NPar2_O12};

    uint8 uc_AttenReserved;
    HS_ID_Atten_t ta_Attenuation[NUM_ID_ATTEN_FIELDS] =
    {
        {1, RELATIVE_POWER_LEVEL_UP_A43,  &t_Info->uc_UpA43Attenuation},
        {1, RELATIVE_POWER_LEVEL_DN_A43,  &t_Info->uc_DnA43Attenuation},
        {1, RELATIVE_POWER_LEVEL_UP_B43,  &t_Info->uc_UpB43Attenuation},
        {1, RELATIVE_POWER_LEVEL_DN_B43,  &t_Info->uc_DnB43Attenuation},
        {1, RELATIVE_POWER_LEVEL_UP_C43,  &t_Info->uc_UpC43Attenuation},
        {1, RELATIVE_POWER_LEVEL_DN_C43,  &t_Info->uc_DnC43Attenuation},
        {1, RELATIVE_POWER_LEVEL_RESERVED,&uc_AttenReserved},
        {2, RELATIVE_POWER_LEVEL_UP_A4,   &t_Info->uc_UpA4Attenuation},
        {2, RELATIVE_POWER_LEVEL_DN_A4,   &t_Info->uc_DnA4Attenuation},
        {2, RELATIVE_POWER_LEVEL_UP_A43c, &t_Info->uc_UpA43cAttenuation},
        {2, RELATIVE_POWER_LEVEL_DN_A43c, &t_Info->uc_DnA43cAttenuation},
    };

    HS_ID_Atten_t *pt_HS_ID_Atten ;

    uint8 *puca_SI_NPar2[5] = {&t_Info->uc_SI_1A_NPar2, &t_Info->uc_SI_1B_NPar2, &t_Info->uc_SI_1C_NPar2,
                               &t_Info->uc_SI_2AB_NPar2, &t_Info->uc_SI_2C_NPar2
                              };
    uint8 *puca_SI_SPar2[5] = {&t_Info->uc_SI_1A_SPar2, &t_Info->uc_SI_1B_SPar2, &t_Info->uc_SI_1C_SPar2,
                               &t_Info->uc_SI_2AB_SPar2, &t_Info->uc_SI_2C_SPar2
                              };
    uint8 *puca_SI_SubChan1[5] = {&t_Info->uc_1A_SubChan1, &t_Info->uc_1B_SubChan1, &t_Info->uc_1C_SubChan1, &uc_temp, &uc_temp};
    uint8 *puca_SI_SubChan2[5] = {&t_Info->uc_1A_SubChan2, &t_Info->uc_1B_SubChan2, &t_Info->uc_1C_SubChan2, &uc_temp, &uc_temp};
    uint8 *puca_SI_MinSpec[5][2] = {&t_Info->uc_1A_UpMinSpect, &t_Info->uc_1A_DnMinSpect,
                                    &t_Info->uc_1B_UpMinSpect, &t_Info->uc_1B_DnMinSpect,
                                    &t_Info->uc_1C_UpMinSpect, &t_Info->uc_1C_DnMinSpect,
                                    &t_Info->uc_2AB_UpMinSpect,&t_Info->uc_2AB_DnMinSpect,
                                    &t_Info->uc_2C_UpMinSpect, &t_Info->uc_2C_DnMinSpect
                                   };

    uint8 *puca_SI_MaxSpec[5][2] = {&t_Info->uc_1A_UpMaxSpect, &t_Info->uc_1A_DnMaxSpect,
                                    &t_Info->uc_1B_UpMaxSpect, &t_Info->uc_1B_DnMaxSpect,
                                    &t_Info->uc_1C_UpMaxSpect, &t_Info->uc_1C_DnMaxSpect,
                                    &t_Info->uc_2AB_UpMaxSpect,&t_Info->uc_2AB_DnMaxSpect,
                                    &t_Info->uc_2C_UpMaxSpect, &t_Info->uc_2C_DnMaxSpect
                                   };
    HS_Encode_ADSL2_t *pt;
    Adsl2AllInfo_t *pt1, *pt2;
    //ParaDyne_Multimode
#ifndef ISDN
    int32   ul_fe_VendorID_ShortCLR;   /*Added the 32 bit local var for Fix for BRCM chipset multimode issue start Palak*/    // Sriram
#endif
    /*  *************************************************************** */
    /*  **** Service and Channel parameters (for CL, CLR, MS only) **** */
    /*  *************************************************************** */

    //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
   //XDSLRTFW-546 IOP_GHS_ClearAnnexMinCLR (Start_End)
#ifndef ISDN
    uint16 us_fe_VersionID_ShortCLR;
#endif
    //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
    memset(t_Info->uc_ID_SPar1, 0, NUM_ID_SPAR1_OCTETS);
    memset(t_Info->uc_SI_SPar1, 0, NUM_SI_SPAR1_OCTETS);

    for (i=0 ; i<NUM_SI_SPAR2_OCTETS ; i++)
    {
        t_Info->pta_G9923xInfo[0]->uc_SI_SPar2[i] = 0 ;
        t_Info->pta_G9925xInfo[0]->uc_SI_SPar2[i] = 0 ;
    }

    t_Info->uc_ID_NPar1 = uca_M[idx++] & NEG_DELIMIT_1;
    idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
    CheckIncompleteMsg(idx, s_MsgLen, 0);
    for(i=0; i<NUM_ID_SPAR1_OCTETS; i++)
    {
        t_Info->uc_ID_SPar1[i] = uca_M[idx++] & NEG_DELIMIT_1;
        if ((uca_M[idx-1] & DELIMIT_1) != 0)
            break;
    }

    if (i>=1)
        guc_Received_Only_One_Octet_In_ID_Field = FALSE; /* this indicates the CO is implementing the new spec. So, we also transmit three octets in this field */
    else
        guc_Received_Only_One_Octet_In_ID_Field = TRUE; /* this indicates the CO is implementing the old spec. So, we also transmit only one octet in this field */

    t_Info->uc_ID_SPar1_ExtraBits = 0;
    idx = SkipCountExtraOctet(uca_M, idx, s_MsgLen, &t_Info->uc_ID_SPar1_ExtraBits);
    CheckIncompleteMsg(idx, s_MsgLen, 0);

    /* ---- ID_NPar2 ---- */
    // Net Data Rate info
    for (i=0 ; i<2 ; i++)
    {
        *puca_MaxNDR[i] = 0;
        *puca_MinNDR[i] = 0;
        *puca_AvgNDR[i] = 0;

        if ( (t_Info->uc_ID_SPar1[0] & (0x1<<i)) != 0 )
        {

            uc_temp = uca_M[idx++] & NEG_DELIMIT_2;

            /* bits 1 to 6 all equal to 1 is Reserved by ITU-T and bits 1 to 6 all equal to 0 is Unspecified by terminal */
            if ( (uc_temp != NEG_DELIMIT_2) && (uc_temp != 0))
                *(puca_MaxNDR[i]) = uc_temp;

            if ( (uca_M[idx-1] & DELIMIT_2) == 0 )
            {
                uc_temp = uca_M[idx++] & NEG_DELIMIT_2;
                if ((uc_temp != NEG_DELIMIT_2) && (uc_temp != 0) )
                    *(puca_MinNDR[i])  = uc_temp;
            }

            if ( (uca_M[idx-1] & DELIMIT_2) == 0 )
            {
                uc_temp = uca_M[idx++] & NEG_DELIMIT_2;
                if ((uc_temp != NEG_DELIMIT_2) && (uc_temp != 0) )
                    *(puca_AvgNDR[i]) = uc_temp;
            }
            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }
    }

    // Data flow characteristics
    for (i=0 ; i<2 ; i++)
    {
        *puca_MaxLat[i] = 0;  // Zero denotes "unspecified by terminal" (see Table 18 of G.hs)
        *puca_AvgLat[i] = 0;  // Zero denotes "unspecified by terminal" (see Table 18 of G.hs)

        if ( (t_Info->uc_ID_SPar1[0] & (0x1<<(i+2))) != 0 )
        {
            uc_temp = uca_M[idx++] & NEG_DELIMIT_2;

            /* bits 1 to 6 all equal to 1 is Reserved by ITU-T and bits 1 to 6 all equal to 0 is Unspecified by terminal */
            if( (uc_temp != NEG_DELIMIT_2) && (uc_temp != 0))
                *(puca_MaxLat[i])  = uc_temp;

            if ( (uca_M[idx-1] & DELIMIT_2) == 0 )
            {
                uc_temp = uca_M[idx++] & NEG_DELIMIT_2;
                if( (uc_temp != NEG_DELIMIT_2) && (uc_temp != 0) )
                    *(puca_AvgLat[i]) = uc_temp;
            }

            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }

    }

    // Splitter info
    for (i=0 ; i<2 ; i++)
    {
        if ( (t_Info->uc_ID_SPar1[0] & (0x1 << (i+4))) != 0 )
        {
            *(puca_Splitter[i]) = uca_M[idx++] & NEG_DELIMIT_2;

            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }
        else
        {
            *(puca_Splitter[i]) = 0;
        }
    }

    // XDSLRTFW-1892 start_end
    // Need to skip octets corresponding to the reserved bit of t_Info->uc_ID_SPar1
    // in case it is set in the future.
    if ( (t_Info->uc_ID_SPar1[0] & 0x40) != 0 )
    {
       idx++ ;
       idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_1);
       CheckIncompleteMsg(idx, s_MsgLen, 0);
    }

   // Relative power info
   pt_HS_ID_Atten = ta_Attenuation ;
   for (i=0 ; i<NUM_ID_ATTEN_FIELDS ; i++)
   {
      if (t_Info->uc_ID_SPar1[pt_HS_ID_Atten->ID_SPar1_idx] & pt_HS_ID_Atten->ID_Spar1_bit)
      {
         remainderSkipped = uca_M[idx] & DELIMIT_2;
         *pt_HS_ID_Atten->puc_Atten = (uca_M[idx++] & NEG_DELIMIT_2);

         // XDSLRTFW-4229 Increasing DS FEC in ADSL2+B with Adtran LC
         // In case of B43 DS the power level consists of 2 octets (clipped attenuation + remainder)
         // These two octets need to be summed up in order to get the actual attenuation
         if ((t_Info->uc_ID_SPar1[pt_HS_ID_Atten->ID_SPar1_idx] & RELATIVE_POWER_LEVEL_DN_B43) && (pt_HS_ID_Atten->ID_SPar1_idx == 1))
         {
            // Only consider second octet with B43 i.e. Spar1_idx = 1, third octet with J43 will be handled outside this loop after bonding section
            if (remainderSkipped == FALSE)
            {
               // Only add the remainder if it was transmitted, i.e. no level 2 delimiting bit set
               *pt_HS_ID_Atten->puc_Atten += (uca_M[idx++] & NEG_DELIMIT_2);
            }
         }

         idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_1);
         CheckIncompleteMsg(idx, s_MsgLen, 0);
      }
      else   // If no information is sent, assume 0 attenuation for attenuation fields.
      {
         *pt_HS_ID_Atten->puc_Atten = 0;
      }
      pt_HS_ID_Atten++ ;
   }

//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (Start)
#ifdef ADSL_BONDING
   if ( (t_Info->uc_ID_SPar1[2] & BONDING) != 0)
   {
      // Bonding NPar2
      t_Info->uc_BondingNP2 = uca_M[idx++] & NEG_DELIMIT_2;

      // Moved to ResponseCL
      //if ((t_Info->uc_BondingNP2 & BONDING_ETHERNET)!=0)
      //{
      //   gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x1;      //Remote PAF supported
      //}

      idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
      CheckIncompleteMsg(idx, s_MsgLen, 0);

      // Bonding Spar2
      if ( (uca_M[idx-1] & DELIMIT_1) == 0 )
      {
         t_Info->uc_BondingSP2 = uca_M[idx++] & NEG_DELIMIT_2;

         idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
         CheckIncompleteMsg(idx, s_MsgLen, 0);

         // We care (for the time being) only for the last 3 LSB's of Bonding SPar2, so no need to count extra bits etc.
         // Upon finishing processing the 3 known bits, we just skip until we see DELIMIT_1 (end of Bonding whole Par2/3 block)

         // BONDING_PME_DISCOVERY NPar3
         if ( (t_Info->uc_BondingSP2 & BONDING_PME_DISCOVERY) != 0)
         {
            for (i=0; i<9; i++)
            {
               t_Info->uca_BondingDisc[i] = uca_M[idx++] & NEG_DELIMIT_2;
               // If -for any reason- NPar2 ends unexpectedly, just exit this block
               if (uca_M[idx-1] & DELIMIT_2)
                  break;
            }
            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
         }

         // BONDING_PME_AGGREGATION NPar3
         if ( (t_Info->uc_BondingSP2 & BONDING_PME_AGGREGATION) != 0)
         {
            for (i=0; i<6; i++)
            {
               t_Info->uca_BondingAggr[i] = uca_M[idx++] & NEG_DELIMIT_2;
               // If -for any reason- NPar2 ends unexpectedly, just exit this block
               if (uca_M[idx-1] & DELIMIT_2)
                  break;
            }
            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
         }

         // BONDING_PME_IDENTIFICATION NPar3
         // Note: Is only allowed to be send by the CPE. Skip it!!
         // Added as a place holder
         if ( (t_Info->uc_BondingSP2 & BONDING_PME_IDENTIFICATION) != 0)
         {
            //DebugTrail1(2,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF03, (int16)uca_M[idx]);
            t_Info->uc_BondingId = uca_M[idx++] & NEG_DELIMIT_2;
         }


         idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
         CheckIncompleteMsg(idx, s_MsgLen, 0);
      } // end Bonding Spar2
   } // end Bonding
#else
   //Need to skip octets corresponding to the bonding bit (bit 5)of t_Info->uc_ID_SPar1_03
   if ( (t_Info->uc_ID_SPar1[2] & BONDING) != 0)
   {
      // idx -> Bonding NPar2
      idx++ ;
      // idx -> Bonding SPar2
      idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
      CheckIncompleteMsg(idx, s_MsgLen, 0);
   }
#endif
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (End)

   if ( (t_Info->uc_ID_SPar1[2] & RELATIVE_POWER_LEVEL_UP_J43) != 0)
   {
      t_Info->uc_UpJ43Attenuation = (uca_M[idx++] & NEG_DELIMIT_2);

      idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
      CheckIncompleteMsg(idx, s_MsgLen, 0);
   }
   if ( (t_Info->uc_ID_SPar1[2] & RELATIVE_POWER_LEVEL_DN_J43) != 0)
   {
      remainderSkipped = uca_M[idx] & DELIMIT_2;
      t_Info->uc_DnJ43Attenuation = (uca_M[idx++] & NEG_DELIMIT_2);

      // XDSLRTFW-4229 Increasing DS FEC in ADSL2+B with Adtran LC
      // In case of B43 DS the power level consists of 2 octets (clipped attenuation + remainder)
      // These two octets need to be summed up in order to get the actual attenuation
      if (remainderSkipped == FALSE)
      {
         // Only add the remainder if it was transmitted, i.e. no level 2 delimiting bit set
         t_Info->uc_DnJ43Attenuation += (uca_M[idx++] & NEG_DELIMIT_2);
      }

      idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
      CheckIncompleteMsg(idx, s_MsgLen, 0);
   }

   // bits of uc_ID_SPar1[3]:
   if ( (t_Info->uc_ID_SPar1[3] & RELATIVE_POWER_LEVEL_UP_B43c) != 0)
   {
      t_Info->uc_UpB43cAttenuation = (uca_M[idx++] & NEG_DELIMIT_2);

      idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
      CheckIncompleteMsg(idx, s_MsgLen, 0);
   }
   if ( (t_Info->uc_ID_SPar1[3] & RELATIVE_POWER_LEVEL_DN_B43c) != 0)
   {
      t_Info->uc_DnB43cAttenuation = (uca_M[idx++] & NEG_DELIMIT_2);

      idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
      CheckIncompleteMsg(idx, s_MsgLen, 0);
   }

   // First, check and skip unused bits of uc_ID_SPar1[3]:
   for (i=2 ; i<7; i++)
   {
      if ( (t_Info->uc_ID_SPar1[3] & (0x1<<i)) != 0 )
      {
         idx++ ;
         idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_1);
         CheckIncompleteMsg(idx, s_MsgLen, 0);
      }
   }

   for (i=0 ; i<t_Info->uc_ID_SPar1_ExtraBits; i++)
   {
      idx++ ;
      idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_1);
      CheckIncompleteMsg(idx, s_MsgLen, 0);
   }

    /*  ****************************** */
    /*  **** Standard information **** */
    /*  ****************************** */

    t_Info->uc_SI_NPar1 = uca_M[idx++] & NEG_DELIMIT_1;

    idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
    CheckIncompleteMsg(idx, s_MsgLen, 0);

    for(i=0; i<NUM_SI_SPAR1_OCTETS; i++)
    {
        t_Info->uc_SI_SPar1[i] = uca_M[idx++] & NEG_DELIMIT_1;
        if ((uca_M[idx-1] & DELIMIT_1) != 0)
            break;
    }
   // Proper Code flow should be first finish SPAR1 octets Rx
   // becasue "i" value is used in below statement
    if (i>=1)
        guc_Received_Only_One_Octet_In_SI_Field = FALSE; /* this indicates the CO is implementing the new spec. So, we also transmit three octet in this field */
    else
        guc_Received_Only_One_Octet_In_SI_Field = TRUE; /* this indicates the CO is implementing the old spec. So, we also transmit only one octet in this field */

    t_Info->uc_SI_SPar1_ExtraBits = 0;
    idx = SkipCountExtraOctet(uca_M, idx, s_MsgLen, &t_Info->uc_SI_SPar1_ExtraBits);
    CheckIncompleteMsg(idx, s_MsgLen, 0);

    if (gft_FirstCL && (t_Info->uc_Type == M_CL))
    {

        memcpy(guca_FE_ModeCapabilities, t_Info->uc_SI_SPar1, NUM_SI_SPAR1_OCTETS);
        //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(Start)
#ifdef HERC_API
        // XDSLRTFW-178 (Start_End)
        if (gft_NoVDSLIndication == 0)
        {
            // Added code here becasue when No VDSL modes are set in CLR msg, The complete CL message
            // from Vinax(VDSL2 mode) is coming wrongly.Second segment started receiving before Tx M_ACK2.
            // Resulting in CL decoding completely wrong.
            // But when VDSL modes are set the CL message decode is O.k.
         //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup (START - END)
         //Decoding  of VDSL support need not be CMV protected, comment is required for
         //Multimode testing i.e ADSL1, ADSL2/2+, T1413 & VDSL modes.
//            if(OPTNArray[OPTN_AlgControl3] & CMV_TO_SEND_VDSL_MODES_IN_SHORT_CLR)
//            {
                uc_spar1_common = 0;
                for(i=0; i<NUM_SI_SPAR1_OCTETS; i++)
                {
                    uc_spar1_common |= (t_Info->uc_SI_SPar1[i] & gpt_TxInfoSave->uc_SI_SPar1[i]);
                }
                if(uc_spar1_common == 0)
                {
                     //Quit HNSK , No Common modes between CO & CPE
                     gl_ADSL_Annex_Mode =0; // XDSLRTFW-2191(Start_End)
                     gus_ExceptionCode = E_CODE_GHS_NoCommonMode;
                     // XDSLRTFW-1843(Start)
                     guc_IFTN_CRC_MISMATCH_ERR_cnt = 0;
                     guc_IFTN_DMT_T1413_Train_Cnt  = 0;
                     // XDSLRTFW-1843(End)
                     gs_RxNextState = FAIL_RX;      // Force the  Rx to FAIL State
                     gus_ExceptionState   = gs_RxState;
                     gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                     gt_hsc.s_State = R_HS_EXIT;

                }
                else if(((t_Info->uc_SI_SPar1[1]) & (gpt_TxInfoSave->uc_SI_SPar1[1]) & (uint8)(T1_MCM_VDSL>>8))||
                        ((t_Info->uc_SI_SPar1[4]) & (gpt_TxInfoSave->uc_SI_SPar1[4]) & G993_1_ANSI_T1_424 )||
                        ((t_Info->uc_SI_SPar1[4]) & (gpt_TxInfoSave->uc_SI_SPar1[4]) & G993_2))
                {
                  gl_ADSL_Annex_Mode =0; // XDSLRTFW-2191(Start_End)
                    gft_VDSL_set = TRUE;
                    //Quit HNSK , VDSL mode is set on CO side,So load VDSL binary.
                    gus_ExceptionCode = E_CODE_GHS_VDSL_SUPPORT_FAREND;
                  gs_RxNextState = FAIL_RX;      // Force the  Rx to FAIL State
                    gus_ExceptionState = gs_RxState;
                    gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                    gt_hsc.s_State = R_HS_EXIT;
            }

         //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup (START - END)
        }
#endif
        //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(End)
    }
    // R3_P1: AR8_TF: IOP_DS_ALL_CNXT_IgnoreMultBitsMsDELT (Start)
#ifndef ISDN   // Only for Anx-A
    if ((t_Info->uc_Type == M_MS) && (gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
            (gs_CurrentCoVendorID == 0x0F))

    {
        pt_RxCL = gpt_RxInfoSave;
        for (i = 0; i < NUM_SI_SPAR1_OCTETS; i++)
        {
            t_Info->uc_SI_SPar1[i] &= pt_RxCL->uc_SI_SPar1[i];
        }
    }
#endif // ifndef ISDN
    // R3_P1: AR8_TF: IOP_DS_ALL_CNXT_IgnoreMultBitsMsDELT (End)


#ifndef ISDN   // R3_P1: IOP_ALL_ALL_BDCM_ParadyneAnnexM

    /*  Extract the provider code (Vendor ID, 4 octets) */
    ul_fe_VendorID_ShortCLR =
        (guca_fe_G9941_VendorID[2] << 24) | (guca_fe_G9941_VendorID[3] << 16) |
        (guca_fe_G9941_VendorID[4] << 8) | (guca_fe_G9941_VendorID[5]);

    //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
   //XDSLRTFW-546 IOP_GHS_ClearAnnexMinCLR (Start_End)
    us_fe_VersionID_ShortCLR = (guca_fe_G9941_VendorID[6] << 8) | (guca_fe_G9941_VendorID[7]);
    //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)

    // If guc_AnnexMCarSet_Detect is set and BDCM co then Start with Annex M only esle Annex A

    // SPar1[0] = 0x0; // ( , 1I, 1H, 2C ;; 2AB, 1C, 1B, 1A)
    // SPar1[1] = 0x0; // (~VDSL/SHDSL)
    // SPar1[2] = 0x0; // ( , , 4I, 4A ;; 3J, 3I, 3B, 3A)
    // SPar1[3] = 0x8; //( , , , 5J ;; 3M, 5I, 5B, 5A)
    // SPar1[4] = 0x1; //( ;; , , , 5M)
    //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
    //The Paradyne BRCM CO has GHS version 0x610c, which will not indicate AnnexM mode in CL even
    //it supports AnnexM mode. The only way is to detect B43 carrier set to see if CO does
    //want to sync up in AnnexM mode. If B43 carrier set is detected, then we will try AnnexM only CLR first.
    //The B43 tone detection is based on B43 tones detection and correctly decoded C-GLAF1 and C-FLAG1 with B43
    //carrier set.
   //XDSLRTFW-546 IOP_GHS_ClearAnnexMinCLR (START)
   //The GHS scenario with the workaround against several CO could be as below.
   //  1. ZyXEL Calix CO (version = 0x938f, multi-mode with AnnexM), CPE (OPTN 25 bitmask(0x4000) is zero or one)
   //    - CPE send CLR with DMT A, BIS A/L/M, PLUS A/M.
   //    - CO send CL with PLUS A.
   //    - CPE send CLR with DMT A, BIS A/L/M, PLUS A/M (guc_AnnexMCarSet_Detect = 1).
   //    - sync up in PLUS M mode.
   //
   //  2. ZyXEL Calix CO (version = 0x938f, multi-mode without AnnexM), CPE (OPTN 25 bitmask(0x4000) is zero or one)
   //    - CPE send CLR with DMT A, BIS A/L/M, PLUS A/M.
   //    - CO send CL with PLUS A.
   //    - CPE send CLR with DMT A, BIS A/L/M, PLUS A/M (guc_AnnexMCarSet_Detect = 1).
   //    - sync up in PLUS A mode.
   //
   //  3. Lantiq FG10 (version = 0x544d, multi-mode with/without AnnexM), CPE (OPTN 25 bitmask(0x4000) is zero or one)
   //    - CPE send CLR with DMT A, BIS A/L/M, PLUS A/M.
   //    - CO send CL with DMT A.
   //    - CPE send CLR with DMT A, BIS A/L, PLUS A (guc_AnnexMCarSet_Detect = 0).
   //    - sync up in PLUS A mode.
   //
   //  4. Arcadyan Paradyne CO (version = 0x610c, multi-mode with AnnexM), CPE (OPTN 25 bitmask(0x4000) is zero or one)
   //    - CPE send CLR with DMT A, BIS A/L/M, PLUS A/M.
   //    - CO send CL with DMT A.
   //    - CPE send CLR with BIS M, PLUS M (guc_AnnexMCarSet_Detect = 1).
   //    - sync up in PLUS M mode.
   //
   //  5. Arcadyan Paradyne CO (version = 0x610c, multi-mode without AnnexM), CPE (OPTN 25 bitmask(0x4000) is zero or one)
   //    - CPE send CLR with DMT A, BIS A/L/M, PLUS A/M.
   //    - CO send CL with DMT A.
   //    - CPE send CLR with DMT A, BIS A/L, PLUS A (guc_AnnexMCarSet_Detect = 0).
   //    - sync up in PLUS A mode.

   if ( (gft_SendShortCLR == TRUE) &&
        (ul_fe_VendorID_ShortCLR == GHS_BDCM_ID) &&
        ((us_fe_VersionID_ShortCLR <= 0x610c) ||
         ((OPTNArray[OPTN_AlgControl3] & CMV_TO_ENABLE_ANNEXM_B43_J43_TONES_BRCM) &&
          (us_fe_VersionID_ShortCLR != (uint16)0x938f))) &&
        (((!(gpt_RxInfo->uc_SI_SPar1[3] & (G992_3_M >> 24))) &&
         (gpt_TxInfo->uc_SI_SPar1[3] & (G992_3_M >> 24))) ||
        ((!(gpt_RxInfo->uc_SI_SPar1[4] & (G992_5_M))) &&
         (gpt_TxInfo->uc_SI_SPar1[4] & (G992_5_M)))) )
   //XDSLRTFW-546 IOP_GHS_ClearAnnexMinCLR (END)
   //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
    {

        // New Proposal to detect the Annex-M mode bit along with carrier set detect
        //if(guc_AnnexMCarSet_Detect & 3)   // Orginal Code is commented out as it was going for A43C tones set
        //if((guc_AnnexMCarSet_Detect & 3) == 1)   // verified this logic at vodafone lab  b43_j43, Not clear A43C
        // SMS00931191:BugFix_ALL_ALL_BRCM_IncorrectLink_T1413_InsdofAdsl2Plus (Start_End)
        //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
        if (guc_AnnexMCarSet_Detect & 0x01)
            //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
        {
            // Annex M mode only, Clear Annex A bits
            gpt_TxInfo->uc_SI_SPar1[0] = 0;
            gpt_TxInfo->uc_SI_SPar1[1] = 0;
            gpt_TxInfo->uc_SI_SPar1[2] = 0;
            gpt_TxInfo->uc_SI_SPar1[3] = 8;
            // gpt_TxInfo->uc_SI_SPar1[4] = 1;

            guc_AnnexMCarSet_Detect |= 0x80;

        }
        else
        {
            // Annex A mode only, Clear Annex M bits
            gpt_TxInfo->uc_SI_SPar1[3] &= 0xF7;

            gpt_TxInfo->uc_SI_SPar1[4] &= 0xFE;

            guc_AnnexMCarSet_Detect |= 0x40;

        }
    }

#endif      //ParaDyne_Multimode


    /* ============================================*/
    /* Decode Standard Information */
    /* ============================================*/
    // cover almost all the Annex here from SI SPar1 octet1
    // i = 0: G992.1 AnnexA
    //     1: G992.1 AnnexB
    //     2: G992.1 AnnexC
    //     3: G992.2 AnnexA/B
    //     4: G992.2 AnnexC
    for (i = 0; i < 5; i++)
    {
        while ( (t_Info->uc_SI_SPar1[0] & (0x1 << i)) != 0 )
        {

            *(puca_SI_NPar2[i]) = uca_M[idx++] & NEG_DELIMIT_2;
            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);

            /* ---- check if level 2 parameter ends here ---- */
            if ( (uca_M[idx-1] & DELIMIT_1) != 0 )
                break;

            *(puca_SI_SPar2[i]) = uca_M[idx++] & NEG_DELIMIT_2;
            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);

            /* ---- SI_NPar3 ---- */
            if ( (*(puca_SI_SPar2[i]) & SUBCH_INFO) != 0 )
            {
                *(puca_SI_SubChan1[i])     = uca_M[idx++] & NEG_DELIMIT_2;
                if ( (uca_M[idx-1] & DELIMIT_2) == 0 )
                    *(puca_SI_SubChan2[i]) =  uca_M[idx++] & NEG_DELIMIT_2;
                else
                    *(puca_SI_SubChan2[i]) = 0;

                idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
                CheckIncompleteMsg(idx, s_MsgLen, 0);
            }
            else
            {
                *(puca_SI_SubChan1[i]) = 0;
                *(puca_SI_SubChan2[i]) = 0;
            }

            for (j = 0; j < 2; j++)
            {
                if ( ( (*(puca_SI_SPar2[i]))& (0x1 << (j+1))) != 0 )
                {
                    *(puca_SI_MinSpec[i][j]) = (uca_M[idx++] & NEG_DELIMIT_2) << 6;

                    if ( (uca_M[idx-1] & DELIMIT_2) == 0 )
                        *(puca_SI_MinSpec[i][j]) |=  uca_M[idx++] & NEG_DELIMIT_2;
                    else
                        *(puca_SI_MinSpec[i][j]) &=  ~NEG_DELIMIT_2;

                    if ( (uca_M[idx-1] & DELIMIT_2) == 0 )
                        *(puca_SI_MaxSpec[i][j])  = (uca_M[idx++] & NEG_DELIMIT_2) << 6;
                    else
                        *(puca_SI_MaxSpec[i][j])  = 0;

                    if ( (uca_M[idx-1] & DELIMIT_2) == 0 )
                        *(puca_SI_MaxSpec[i][j]) |=  uca_M[idx++] & NEG_DELIMIT_2;
                    else
                        *(puca_SI_MaxSpec[i][j]) &=  ~NEG_DELIMIT_2;

                    idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_2 );
                    CheckIncompleteMsg(idx, s_MsgLen, 0);
                }
                else
                {
                    *(puca_SI_MinSpec[i][j]) = 0;
                    *(puca_SI_MaxSpec[i][j]) = 0;
                }
            }

            idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
            CheckIncompleteMsg(idx, s_MsgLen, 0);
            break;
        }   /*  while */
    }

    // Bits 0x60 of SPar1[0] and whole SPar[1] we don't support:
    for (i=5 ; i<7; i++)
    {
        if (t_Info->uc_SI_SPar1[0] & (0x1<<i))
        {
            idx++ ;
            idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_1);
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }
    }
    for (i=0 ; i<7; i++)
    {
        if (t_Info->uc_SI_SPar1[1] & (0x1<<i))
        {
            idx++ ;
            idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_1);
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }
    }

    pt = gta_HS_ADSL2;
    for (i=0 ; i<NUM_KNOWN_ADSL2_SPAR1_BITS ; i++)
    {
        if ( (t_Info->uc_SI_SPar1[pt->SI_SPar1_idx] & pt->SI_Spar1_anx_bit) != 0 )
        {
            /* If we can handle this annex: */
            if (pt->cfgmode)
            {
                // Non-zero value means we can handle it
                if (pt->bis_plus == 0) //BIS mode
                {
                    pt1 = t_Info->pta_G9923xInfo[pt->anx];
                    pt2 = gpt_TxInfo->pta_G9923xInfo[pt->anx];
                    j = 0;
                }
                else //PLUS mode
                {
                    pt1 = t_Info->pta_G9925xInfo[pt->anx];
                    pt2 = gpt_TxInfo->pta_G9925xInfo[pt->anx];
                    j = 1;
                }

                //XDSLRTFW-1502 (start_end)
               idx = DecodeStandard_Bis(uca_M, (int16)idx, s_MsgLen, pt1, pt2, (uint8)j,t_Info->uc_Type);
            }
            else
            {
                // pt->cfgmode=0 means we cannot handle this annex, skip Par2 block
                idx++ ;       // There has to be at least one octer for this block
                idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_1);
                CheckIncompleteMsg(idx, s_MsgLen, 0);
            }

            /* check for incomplete message */
            if (idx == 0)
            {
                return(0);
            }
        }
        pt++;//to the next
    }//i


    // First, check and skip unused bits of uc_SI_SPar1[4]:
    for (i=1 ; i<7 ; i++)
    {
        if ( (t_Info->uc_SI_SPar1[4] & (0x1<<i)) != 0 )
        {
            idx++ ;        // There has to be at least one octer for this block
            idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_1);
            CheckIncompleteMsg(idx, s_MsgLen, 0);
        }
    }

    for (i=0 ; i<t_Info->uc_SI_SPar1_ExtraBits; i++)
    {
        idx++ ;         // There has to be at least one octer for this block
        idx = SkipExtraOctet(uca_M, idx, s_MsgLen, DELIMIT_1);
        CheckIncompleteMsg(idx, s_MsgLen, 0);
    }

    idx = SkipExtraOctet( uca_M, idx, s_MsgLen, DELIMIT_1 );
    CheckIncompleteMsg(idx, s_MsgLen, 1);

    return (idx);

}   /*  DecodeStandard */

/*
 *------------------------------------------------------------------------
 *
 *  Name: DecodeNonStandard
 *
 *  Abstract: Check FCS and decode received non-standard information
 *
 *  Input Arguments:
 *      uint8 uca_M[]       - array of received message octets
 *      InfoField_t *t_I    - pointer to a InfoField structure that holds
 *                            the decoded information
 *      idx                 - index of the starting position of the message array
 *      s_MsgLen            - total number of octets in uca_M
 *
 *  Returns:
 *      idx                 - index of the ending position of the message array
 *                            It is set to zero if the current message is not complete.
 *
 *  Global Variables Used:
 *      gt_hsc.s_TxNSBCnt : Number of non-standard blocks transmitted so far
 *
 *------------------------------------------------------------------------
 */
int16 DecodeNonStandard( uint8 uca_M[], int16 idx, int16 s_MsgLen, InfoField_t *t_Info )
{

    int               i;
    int16              s_NSB_Cnt;
    NonStandardBlock_t *pt_NSB = NULL;


    s_NSB_Cnt = 0;  /*  initialize */
    t_Info->uc_NumBlock = uca_M[idx++];

    while ( s_NSB_Cnt < t_Info->uc_NumBlock )
    {

        /* Check if any octets are available for this block, so that at least NSLen is valid */
        if (idx >= s_MsgLen)
        {
            idx = 0 ;
            break ;
        }

        /* If more NS blocks than we have storage for, then just keep overwriting our last stored one */
        if (s_NSB_Cnt < MAX_NUM_NS_BLOCK)
        {
            pt_NSB             = &( t_Info->ta_NS_Info[ s_NSB_Cnt ] );
        }
        pt_NSB->uc_NSLen   = uca_M[idx++];


        /* Check for enough octets, now that block length is known */
        if (idx+pt_NSB->uc_NSLen > s_MsgLen)
        {
            idx = 0;
            break;
        }

        //Sriram : decode NSIF Vendor ID. This info is used to By pass Sync scaling for DMT mode
//XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (START)
//#ifdef NSIF_INFINEON


        pt_NSB->NSIF_SpecialPattern = (uint16 )uca_M[idx++] << 8;
        pt_NSB->NSIF_SpecialPattern |= (uint16) uca_M[idx++];

        pt_NSB->NSIF_VendorID = (uint32)uca_M[idx++] <<24;     // A
        pt_NSB->NSIF_VendorID |= (uint32)uca_M[idx++] << 16;   // L
        pt_NSB->NSIF_VendorID |= (uint32)uca_M[idx++] << 8;    // C
        pt_NSB->NSIF_VendorID |= (uint32)uca_M[idx++] ;        // B

//#else
        /* Country and provider code should be the same as in the initial part of the message - Skip */
//        idx += 6 ;
//#endif
//XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (END)

        /* ---- Vendor specific information ---- */
        for ( i = 0; i < pt_NSB->uc_NSLen - 6; i++ )
        {
            if (i < MAX_NS_VENDOR_INFO_LEN)
            {
                pt_NSB->puca_NSVendorSpec[i] = uca_M[idx++];
            }
            else
            {
                /* If length of block more than we have storage for, just don't store the extra part*/
                idx++ ;
            }
        }

        s_NSB_Cnt++;

    }   /*  while */

    return (idx);

}   /*  DecodeNonStandard */



/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: FormPmdSpectrumBoundParameters
 *
 *  Abstract:
 *
 *  FormPmdSpectrumBoundParameters() - form the PMD spectrum bound parameters from a structure to
 *  an array to be transmitted as a handshake message
 *
 *
 *  Parameters:
 *      PMD_Type_t     *pt_PmdType : information to be transmitted from
 *      uint8 *puc_M : information to be copied into and eventually transmitted
 *    int16  idx:    index into the buffer puc_M[]
 *    int16  idx:    return the updated index into the buffer puc_M[]
 *
 *  Returns: idx
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */
int16 FormPmdSpectrumBoundParameters(PMD_Type_t *pt_PmdType, uint8 *puc_M, int16 idx)
{
    puc_M[idx++] = (pt_PmdType->s_NOMPSD >> 6) & 0x07;         /* take 3 MSB's */
    puc_M[idx++] = pt_PmdType->s_NOMPSD & 0x3F;             /* take remaining 6 bits */
    puc_M[idx++] = (pt_PmdType->s_MAXNOMPSD >> 6) & 0x07;      /* take 3 MSB's */
    puc_M[idx++] = pt_PmdType->s_MAXNOMPSD & 0x3F;          /* take remaining 6 bits */
    puc_M[idx++] = (pt_PmdType->s_MAXNOMATP >> 6) & 0x07;      /* take 3 MSB's */
    puc_M[idx++] = (pt_PmdType->s_MAXNOMATP & 0x3F) | DELIMIT_2;/* take remaining 6 bits */

    return(idx);
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: FormPmdSpectrumShapeParameters
 *
 *  Abstract:
 *
 *  FormPmdSpectrumShapeParameters() - form the PMD spectrum shape parameters from a structure to
 *  an array to be transmitted as a handshake message
 *
 *
 *  Parameters:
 *      PMD_Type_t     *pt_PmdType : information to be transmitted from
 *      uint8 *puc_M : information to be copied into and eventually transmitted
 *    int16  idx:    index into the buffer puc_M[]
 *    int16 s_num_tssi_values:   no. of tssi values to be transmitted
 *    int16  idx:    return the updated index into the buffer puc_M[]
 *
 *  Returns: idx
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */
int16 FormPmdSpectrumShapeParameters(PMD_Type_t *pt_PmdType, uint8 *puc_M, int16 idx, int16 s_num_tssi_values)
{
    int i, s_value, s_shift;
    uint8 uc_Si;
    uint8 *puca_CLR_USTssiIndex;

    puca_CLR_USTssiIndex = (uint8*)(void *)pt_PmdType->pus_BreakFreq;

    for(i=0; i<s_num_tssi_values; i++)
    {
        // we are using new G.HS standard to code/decode tssi info, i.e., 4 octets per pair
        s_value = puca_CLR_USTssiIndex[i];
        puc_M[idx++] = (s_value >> 6) & 0x3F;   /* take 6 MSB's */
        puc_M[idx++] = (s_value & 0x3F); /* take 6 LSB's */

        s_shift = i & 0x7;
        uc_Si = (pt_PmdType->pf_InSprtSet[i>>3]>>s_shift) & 0x1;

        puc_M[idx++] = (uc_Si<<5) | ((pt_PmdType->puc_tssi[i] >> 6) & 0x01);  /* combining 1bit indication bit and one msb (bit 7) of log_tssi */
        puc_M[idx++] = pt_PmdType->puc_tssi[i] & 0x3F;            /* take remaining 6 bits */

    }
    puc_M[idx-1] |= DELIMIT_2;

    return(idx);
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: FormPmsTCParameters
 *
 *  Abstract:
 *
 *  FormPmsTCParameters() - form the PMS TC parameters from a structure to
 *  an array to be transmitted as a handshake message
 *
 *
 *  Parameters:
 *      PMS_TC_LatencyPath_t *pt_LatencyPath : information to be transmitted from
 *      uint8 *puc_M : information to be copied into and eventually transmitted
 *    int16  idx:    index into the buffer puc_M[]
 *    int16  idx:    return the updated index into the buffer puc_M[]
 *
 *  Returns: idx
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */
int16 FormPmsTCParameters(PMS_TC_LatencyPath_t *pt_LatencyPath, uint8 *puc_M, int16 idx)
{
    puc_M[idx++] = (uint8)((pt_LatencyPath->s_MaxDataRate >> 6) & 0x3F);   /* max net data rate, bits 12 to 7 */
    puc_M[idx++] = (uint8)(pt_LatencyPath->s_MaxDataRate & 0x3F);       /* max net data rate, bits 6 to 1 */
    puc_M[idx++] = (uint8)((pt_LatencyPath->s_MaxRandD >> 8) & 0xF);    /* max R, bits 4 to 1 */
    puc_M[idx++] = ((uint8)((pt_LatencyPath->s_MaxRandD) & 0x7)) | DELIMIT_2;/* max D, bits 3 to 1 */

    return(idx);
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: DecodePmdSpectrumBoundParameters
 *
 *  Abstract:
 *
 *  DecodePmdSpectrumBoundParameters() - For a particular bearer channel,
 *  decodes the received PMD spectrum bound parameters in the handshake message
 *  and puts in the array of type PMD_Type_t
 *
 *
 *  Parameters:
 *      uint8 *puc_M : information to be decoded from
 *    int16  idx:    index into the input buffer puc_M[]
 *      PMD_Type_t:     *pt_PmdType : information to be copied to
 *    int16  idx:    return the update index into the buffer puc_M[]
 *
 *  Returns: idx
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */

#define ExtendSignBit(s_Value)  s_Value = (s_Value & 0x0100)? (s_Value | 0xFE00): s_Value

int16 DecodePmdSpectrumBoundParameters(PMD_Type_t *pt_PmdType, uint8 *puc_M, int16 idx, int16 s_MsgLen)
{
    int i;
    int16 *psa_bytes[3];

    psa_bytes[0] = &(pt_PmdType->s_NOMPSD);
    psa_bytes[1] = &(pt_PmdType->s_MAXNOMPSD);
    psa_bytes[2] = &(pt_PmdType->s_MAXNOMATP);

    for (i = 0; i < 3 ; i++)
    {
        if (i == 0)
            *(psa_bytes[0]) = (puc_M[idx++] & NEG_DELIMIT_2) << 6;   /* max nominal psd, bits 7 to 9 */
        else
        {
            if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
                *(psa_bytes[i]) = (puc_M[idx++] & NEG_DELIMIT_2) << 6;  /* max nominal psd, bits 7 to 9 */
            else
                *(psa_bytes[i])  = 0;
        }

        if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
            *(psa_bytes[i]) |=  puc_M[idx++] & NEG_DELIMIT_2;  /* max nominal psd, bits 1 to 6 */

        // extend the sign bit (MAXNOMPSD could be negative value)
        ExtendSignBit(*(psa_bytes[i]));
    }

    return(idx);
}
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: DecodeTpsTCParameters
 *
 *  Abstract:
 *
 *  DecodeTpsTCParameters() - For a particular bearer channel, decodes the received TPS TC parameters in the handshake message
 *  and puts in the array of type TPS_TC_Type_t
 *
 *
 *  Parameters:
 *      uint8 *puc_M : information to be decoded from
 *    int16  idx:    index into the input buffer puc_M[]
 *      TPS_TC_Type_t *pt_TpsTcType : information to be copied to
 *    int16  idx:    return the update index into the buffer puc_M[]
 *
 *  Returns: idx
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */

#define MAX_LIMIT_RATE   (0xFFF)
//XDSLRTFW-1502 (start_end)
int16 DecodeTpsTCParameters(TPS_TC_Type_t *pt_TpsTcType, TPS_TC_Type_t *pt_TpsTcType_Tx,uint8 *puc_M, int16 idx, int16 s_MsgLen, uint16 type, int l_isDS, int l_isPlus, uint8 uc_msg)
{

    int tempValue, tempValue1;
    int16 *psa_DataRate[3], *psa_DataRate_Tx[3];
    int i, l_index;

    psa_DataRate[0] = &pt_TpsTcType->s_MinNetDataRate;
    psa_DataRate[1] = &pt_TpsTcType->s_MaxNetDataRate;
    psa_DataRate[2] = &pt_TpsTcType->s_MinResNetDataRate;

    psa_DataRate_Tx[0] = &pt_TpsTcType_Tx->s_MinNetDataRate;
    psa_DataRate_Tx[1] = &pt_TpsTcType_Tx->s_MaxNetDataRate;
    psa_DataRate_Tx[2] = &pt_TpsTcType_Tx->s_MinResNetDataRate;

    for (i = 0; i < 3; i++)
    {
        if (i == 0)
            tempValue = (puc_M[idx++] & NEG_DELIMIT_2) << 6;      /* data rate, bits 12 to 7 */
        else
        {
            if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
                tempValue = (puc_M[idx++] & NEG_DELIMIT_2) << 6;  /* data rate, bits 12 to 7 */
            else
                tempValue = 0;
        }

        if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
            tempValue  |=  puc_M[idx++] & NEG_DELIMIT_2;    /* data rate, bits 1 to 6 */

        //For Globespan CO, needs to compare the data rates contained in the CLs. It has been found that
        //if CO sends CL in multiple times, (e.g., with shortCLR On, or resending CLR in AnnexL, CO would
        //double the DS/US min and max rate in each following CL after the first initial one).
        if ((l_isPlus == 0) && (gpt_RxInfo->ul_Provider == GHS_GSI_ID) && (guca_fe_G9941_VendorID[7] < 0x0F))
        {
            l_index = l_isDS*3 + i;
            if (((i==0) && (tempValue > (*(psa_DataRate_Tx[i]))))
                    || ((i==1) && (tempValue < (*(psa_DataRate_Tx[i])))))
            {
                //save the initial rate configuration from the first CL message
                if (gusa_CL_RcvdCnt[l_index] ==0)
                {
                    (*(psa_DataRate_Tx[i])) = tempValue;

                    if ((l_isDS == 0) && (i == 1))
                    {
                        //for US, to prevent the limited rate from being as capped rate case when min == max,
                        //the final rate from MS could end up as min > max. CO would treat it as capped rate,
                        //we intentionally add 8kbps to max rate to make sure CO will not treat it as capped rate.
                        tempValue1 = tempValue;
                        if ((*(psa_DataRate_Tx[0])) == tempValue1)
                            (*(psa_DataRate_Tx[i])) +=2;
                        else
                        {
                            //for US, to prevent the capped rate case when min = max/(2x), x is an integer number from 1 to max#of CL received,
                            //the final rate from MS could end up as fixed rate, i.e, min = max, we intentionally substract 4kbps
                            //from the initial rate to make sure CO will not treat it as fixed rate.
                            while(tempValue1!=0)
                            {
                                tempValue1 >>= 1;
                                if ((*(psa_DataRate_Tx[0])) == tempValue1)
                                    break;
                            }

                            if (tempValue1 != 0)
                                (*(psa_DataRate_Tx[i])) -=1;
                        }
                    }
                }
                else
                {
                    //check whether the following CL messages doubled the rate values contained in the previous CL
                    //if yes, ignore the value that doubled (or not doubled because reached the max limit already)
                    //and only use the initial value
                    tempValue1 = tempValue;
                    while(tempValue1!=0)
                    {
                        tempValue1 >>= 1;
                        if( (*(psa_DataRate_Tx[i])) == tempValue1)
                            break;
                    }

                    if ((tempValue == MAX_LIMIT_RATE) || (tempValue1 != 0))
                        tempValue = (*(psa_DataRate_Tx[i]));
                }
                gusa_CL_RcvdCnt[l_index]++;
            }
        }
        *(psa_DataRate[i]) = tempValue;
    }

    if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
        pt_TpsTcType->s_MaxLatency  = puc_M[idx++] & NEG_DELIMIT_2;/* max latency */
    else
        pt_TpsTcType->s_MaxLatency = 0;

    // the following code is added according to the corrigendum(Jan. 03), which proposed Max Latecy (in the range of [0~63]) to be 0 has
    /// special meaning as no limit boundary
    if (pt_TpsTcType->s_MaxLatency == 0)
        pt_TpsTcType->s_MaxLatency = 1024;

    if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
    {
        pt_TpsTcType->uc_MaxBER =  puc_M[idx++] & 0x3;      /* bit 1, 2 forBER */

        tempValue = (puc_M[idx-1] >>2) & 0x3;
        pt_TpsTcType->s_IMAxINP = tempValue;
        // SMS00847294:Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting Start
        /* Ensure EDR CMV and ED_HW CMV are enabled */
      //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
      //XDSLRTFW-1502 (start)
        if((l_isDS) &&(uc_msg == M_MS))
        {
            gt_ErasureDecoding_Reprt.ft_INP_no_erasure_not_reqd = ((puc_M[idx - 1] >> 4) & 0x1);
        }
      //XDSLRTFW-1502 (end)
        // SMS00847294:Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting End
        if (type == TPSTC_TYPE_ATM) // if ATM, there is additional IMA_Flag parameter
        {
            tempValue = (puc_M[idx-1]>>5) & 0x1;
            pt_TpsTcType->s_IMAxINP |=(tempValue<<8);
        }
        //XDSLRTFW-386 IOP_DS_BisPlus_CNXT_WrongINPConfig (Start)
        // IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading (START)
        // Fix for Tiscali problem seen against CNXT(GSPN) CO for which minINP sent during
        // CL != minINP sent during MS message by the CO, so we consider only the minINP sent
        // during CL message due to a strange configuration problem with the DSLAM.
        //if ( (gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
        //        (gt_INFX_CMV.s_DFE_Options & CMV_DFE_CHOOSE_MININP_FROM_CL_CNXT_ENABLE))
        //{
        //    if ((gpt_RxInfo->uc_Type == M_CL) && (l_isDS))
        //    {
        //        guc_CL_minINP = (uint8) pt_TpsTcType->s_IMAxINP;
        //    }
        //}
        // IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading (END)
        //XDSLRTFW-386 IOP_DS_BisPlus_CNXT_WrongINPConfig (End)
    }
    else
    {
        pt_TpsTcType->uc_MaxBER  = 0;
        pt_TpsTcType->s_IMAxINP = 0;
    }

    // There could be bits 3 -7  for INP in next octate (though not mandatory)
    if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
    {
        tempValue =  puc_M[idx++] & 0x3F;    /* bits 0-5 are for INP bits 3 -7 */
        pt_TpsTcType->s_IMAxINP  |= (tempValue << 2);
    }
    /*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
    if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
    {
        guc_PtmOctet = puc_M[idx++] & NEG_DELIMIT_2;
    }
#endif//if defined DANUBE_PTM_SUPPORT
    /*********************************PTM CHANGES*************************************/

        //XDSLRTFW-386 IOP_DS_BisPlus_CNXT_WrongINPConfig (Start)
        // IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading (START)
        // Fix for Tiscali problem seen against CNXT(GSPN) CO for which minINP sent during
        // CL != minINP sent during MS message by the CO, so we consider only the minINP sent
        // during CL message due to a strange configuration problem with the DSLAM.
        if ( (gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
                (gt_INFX_CMV.s_DFE_Options & CMV_DFE_CHOOSE_MININP_FROM_CL_CNXT_ENABLE))
        {
            if ((gpt_RxInfo->uc_Type == M_CL) && (l_isDS))
            {
                guc_CL_minINP = (uint8) pt_TpsTcType->s_IMAxINP;
            }
        }
        // IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading (END)
       //XDSLRTFW-386 IOP_DS_BisPlus_CNXT_WrongINPConfig (End)

      gt_Decoded_ProfileInfo_t.s_MAX_DATA_RATE_US=*psa_DataRate[1];
      gt_Decoded_ProfileInfo_t.s_MIN_DATA_RATE_US=*psa_DataRate[0];
      gt_Decoded_ProfileInfo_t.s_INP_erasure_US=pt_TpsTcType->s_IMAxINP;
    return(idx);
}
#undef MAX_LIMIT_RATE //   (0xFFF)

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: DecodePmsTCParameters
 *
 *  Abstract:
 *
 *  DecodePmsTCParameters() - For a particular bearer channel, decodes the received PMS TC parameters in the handshake message
 *  and puts in the array of type PMS_TC_Type_t
 *
 *
 *  Parameters:
 *      uint8 *puc_M : information to be decoded from
 *    int16  idx:    index into the input buffer puc_M[]
 *      PMS_TC_Type_t *pt_PmsTcType : information to be copied to
 *    int16  idx:    return the update index into the buffer puc_M[]
 *
 *  Returns: idx
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */

int16 DecodePmsTCParameters(PMS_TC_LatencyPath_t *pt_PmsTcLatencyPath, uint8 *puc_M, int16 idx, int16 s_MsgLen)
{
    pt_PmsTcLatencyPath->s_MaxDataRate  = (puc_M[idx++] & NEG_DELIMIT_2) << 6;   /* max net data rate, bits 12 to 7 */
    if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
        pt_PmsTcLatencyPath->s_MaxDataRate |=  puc_M[idx++] & NEG_DELIMIT_2;  /* max net data rate, bits 1 to 6 */
    else
    {
        //we should also consider the zero value of R and D
        pt_PmsTcLatencyPath->s_MaxRandD = 0;
    }

    if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
        pt_PmsTcLatencyPath->s_MaxRandD  = (puc_M[idx++] & NEG_DELIMIT_2) << 8;     /* max R */
    else
        pt_PmsTcLatencyPath->s_MaxRandD  = 0x0;

    if ( (puc_M[idx-1] & DELIMIT_2) == 0 )
        pt_PmsTcLatencyPath->s_MaxRandD   |= puc_M[idx++] & NEG_DELIMIT_2;       /* max D */
    else
        pt_PmsTcLatencyPath->s_MaxRandD |= 0x0;

    return(idx);
}
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: ZeroTpsTCParameters
 *
 *  Abstract:
 *
 *  ZeroTpsTCParameters() - initializes to zero the structure TPS_TC_Type_t
 *
 *
 *  Parameters:
 *      TPS_TC_Type_t *pt_TpsTcType : structure to be zeroed out
 *
 *  Returns: none
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */

void ZeroTpsTCParameters(TPS_TC_Type_t *pt_TpsTcType)
{
    pt_TpsTcType->s_MinNetDataRate = 0;
    pt_TpsTcType->s_MaxNetDataRate = 0;
    pt_TpsTcType->s_MinResNetDataRate = 0;
    pt_TpsTcType->s_MaxLatency = 0;
    pt_TpsTcType->uc_MaxBER = 0;
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: int16 AddPmsTcInfo(int16 s_lp, InfoField_t *pt_Info, uint8 *puc_M, int16 idx)
 *
 *  Abstract:
 *
 *  AddPmsTcInfo() - For a particular latency path, form the PMS TC parameters from a structure to
 *  an array to be transmitted as a handshake message
 *
 *
 *  Parameters:
 *    int16 s_lp:    latency path or PMS_TC function number (0, 1, 2, 3)
 *      InfoField_t  *pt_Info : information to be transmitted from
 *      uint8 *puc_M : information to be copied into and eventually transmitted
 *    int16  idx:    index into the buffer puc_M[]
 *
 *  Returns: idx
 *    int16  idx:    return the updated index into the buffer puc_M[]
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */
int16 AddPmsTcInfo(int16 s_lp, Adsl2AllInfo_t *pt_BisInfo, uint8 *puc_M, int16 idx)
{
    int i, j;
    PMS_TC_LatencyPath_t *pta_LP[2] = {&(pt_BisInfo->ta_DSLatencyPath[s_lp]), &(pt_BisInfo->ta_USLatencyPath[s_lp])};

    //XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_End)
    uint8 uc_D0_Max_Supported, uc_Flag = 0;
    i = 2*(s_lp+1)+1;

    /* PMS-TC parameters */
    for (j = 0; j < 2; j++)
    {
        if ( (pt_BisInfo->uc_SI_SPar2[i] & (0x1<<j)) != 0 )
        {
            if (s_lp == 0)
            {
                puc_M[idx++] = ( pta_LP[j]->s_MaxDataRate >> 6) & 0x3F; /* max net data rate, bits 12 to 7 */
                puc_M[idx++] = ( pta_LP[j]->s_MaxDataRate & 0x3F);   /* max net data rate, bits 6 to 1 */
                //XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start)
                //XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup (Start_End)
                if((gt_ApiOptions.us_Opt_Offset0 & CMV_TO_ENABLE_US_INLV_DEPTH_STD) &&(j == 1)) // Add only for US PMS
                {
                    if((gt_Optional_US_InlvDepth.us_US_D0Max_Tx_CLR & 0x30) == 0)   // Tx Bit 5 & 4 NPAR3 PMS-TC
                    {
                        uc_D0_Max_Supported = gt_Optional_US_InlvDepth.us_US_D0Max_Tx_CLR & 0x0F; // Tx Bit 3 & 0 NPAR3 PMS-TC

                        if((uc_D0_Max_Supported == 2) || (uc_D0_Max_Supported == 6) ||(uc_D0_Max_Supported == 0xE))
                        {
                            puc_M[idx++] = uc_D0_Max_Supported;
                            uc_Flag = 1;
                        }
                    }
                    if(uc_Flag == 0)
                    {
                        gt_Optional_US_InlvDepth.us_US_D0Max_Tx_CLR = 0; // Default value
                        puc_M[idx++] = gt_Optional_US_InlvDepth.us_US_D0Max_Tx_CLR;
                    }
                }
                //XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (End)
                if ((!gft_DisableExtendedFrame) && (j==0))
                {
                    puc_M[idx++] = ( pta_LP[j]->s_OneOverS0min - 1) & 0xF;
                    puc_M[idx++] = ( pta_LP[j]->s_D0Mask) & 0x3F;
                    puc_M[idx++] = ( pta_LP[j]->s_D0Mask>>6) & 0x3F;
                    //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory(Start)
#ifdef ADSL_62
                    // Tx 24k dilv buffer size support
                    if(gt_INFX_CMV.us_Ena_Extended_D_IFX & MASK_ENA_EXT_ILV_BUF)
                    {
                        puc_M[idx] |= IlV_MEMSIZE_BYTES24KB;    // Indicate the Suprt for 24000 Ilv memory bytes
                        puc_M[idx++] = puc_M[idx] |( ( pta_LP[j]->s_D0Mask>>12) & 0x3)| DELIMIT_2;
                    }
                    else
                    {
                        puc_M[idx++] =( ( pta_LP[j]->s_D0Mask>>12) & 0x3)  | DELIMIT_2;
                    }
#else
                    puc_M[idx++] =( ( pta_LP[j]->s_D0Mask>>12) & 0x3)  | DELIMIT_2;
#endif
                    //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory( End)
                }
                else
                    puc_M[idx-1] |= DELIMIT_2;  /* max net data rate, bits 6 to 1 */

            }
            else
                idx = FormPmsTCParameters(pta_LP[j], puc_M, idx);
        }
    }
    return(idx);
}
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: int16 AddReTxTpsTcInfo(int16 s_bc, InfoField_t *pt_Info, uint8 *puc_M, int16 idx)
 *
 *  Abstract:
 *
 *  AddReTxTpsTcInfo() - For a particular bearer channel(only for 0),
 *    form the TPS TC parameters from a structure to
 *    an array to be transmitted as a handshake message
 *
 *
 *  Parameters:
 *    int16 s_bc:    bearer channel or TPS_TC function number (0)
 *      InfoField_t  *pt_Info : information to be transmitted from
 *      uint8 *puc_M : information to be copied into and eventually transmitted
 *    int16  idx:    index into the buffer puc_M[]
 *    int16  idx:    return the updated index into the buffer puc_M[]
 *
 *  Returns: idx
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */
#ifdef UNV_RETX_GHS
int16 AddReTxTpsTcInfo(
   int16 s_bc,
   Adsl2AllInfo_t * pt_BisInfo,
   uint8 * puc_M,
   int16 idx)
{
   uint8 uc_octet,mask;

   uc_octet = pt_BisInfo->uc_SI_SPar2[3];
   mask = TPSTC_RETX_ATM_DN;

      /* ATM TPS-TC #0 RETX in DS for #s_bc =0 */
      if ((uc_octet & mask) != 0)
      {
         puc_M[idx++] |= DELIMIT_2;
      }
      mask <<= 1;
/*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
         guc_PtmOctet =
            (gt_INFX_CMV.us_PTM_Options_Indicated & PTM_DS_OPTIONS) >> 6;
#endif // if defined DANUBE_PTM_SUPPORT
/*********************************PTM CHANGES*************************************/
      //guc_PtmOctet >> 3 is
      //(CMV_PTM_64_65_OCTET_ENCAP_SHORT_US|CMV_PTM_64_65_OCTET_ENCAP_PRE_US)
      /* PTM TPS-TC #0 RETX in DS for #s_bc =0 */
      if ((uc_octet & mask) != 0)
      {
         puc_M[idx] = (guc_PtmOctet >> 3) & 0x3;
         puc_M[idx++] |= DELIMIT_2;
      }
   return (idx);
}
#endif //UNV_RETX_GHS
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)


//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (Start)
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : PrepareCLR_BONDING()
 *
 *  Author  : Sriram Shastry
 *
 *  Abstract: Sets up new parameters for CLR.Set up the CLR parameter for ADSL BONDING
 *
 *  Returns : None
 *
 *  Global Variables Used:
 *-------------------------------------------------------------------*/
#ifdef ADSL_BONDING

volatile uint16 gus_WaitForBondingDataCnt;


void PrepareCLR_BONDING(void)
{
   int16 s_continue;
   //----------------------------------
   // if bonding is enabled,
   // 1. set macrostate to notify network processor
   // that the phy requires access to the bonding registers.
   // 2. (not shown) network processor notes macro state,
   // reads status to determine command type (set, clear, get),
   // updates registers if necessary, sends CONTINUE
   // message
   // 3. (not shown) PHY receives continue message and
   // updates the bonding registers with the received data
   // and clears the WaitForBondingData flag
   // 4. reset macrostate to GHS
   // 5. place bonding information into data TxInfo
   //
   //----------------------------------


   if (gt_Bonding_DiscAggr_Control.s_PCS_control & 0x1)
   {
      //----------------------------------
      // set macrostate to GHS_BONDING_CLR
      //----------------------------------

      //gsa_IndirectStat0[0] = STAT_BondingCLR;
      //STATArray[STAT_MacroState] = STAT_BondingCLR; //moved to Hndshk.c
      //gs_MONI_ModemStat_Status = MONI_BONDING_CLR;
      //gsa_HercADSL_MONIMap_Curr[0] = MONI_BONDING_CLR;


      //----------------------------------
      // wait for Network Processor to process
      // any pending commands and return
      // remote discovery register and aggregate data
      //----------------------------------
#ifndef TARGET_COCOMO
        // reset continue bit
        gt_Bonding_Continue.s_continue &= ~0x1;
#endif //TARGET_COCOMO

 #if HANDLE_BONDING_IN_PHY
// #if 1
        // simulate the setting of the bit by network processor .
        gt_Bonding_Continue.s_continue |= 0x1;
#endif
        // !! Note: Needs to use volatile here. Otherwise compiler
        // will optimize out the memory read.
        s_continue = *(volatile int16*)(&(gt_Bonding_Continue.s_continue));
      while ((s_continue & 1) == 0)
      {
         gus_WaitForBondingDataCnt++;
         s_continue = *(volatile int16*)(&(gt_Bonding_Continue.s_continue));
      }
   //----------------------------------
   // Update TxInfo bonding NPar3 params:
   //----------------------------------
    //XDSLRTFW-2893
      if ((guc_ClrControl & CLR_SEND_NOT_BONDING_INFO) == 0)
      {
         gpt_TxInfo->uc_ID_SPar1[2] |= BONDING; // set  this for Bonding
         gpt_TxInfo->uc_BondingNP2 |= BONDING_ETHERNET;
         gpt_TxInfo->uc_BondingSP2 |= (BONDING_PME_DISCOVERY | BONDING_PME_AGGREGATION);
         // Enable below if condition for BDCM CPE like implementation
         // ie., set PME ID in Second CLR(ie., along with PME aggregation)
         if(guc_ClrControl & CLR_SEND_BONDING_PME_ID)
         {
            gpt_TxInfo->uc_BondingSP2 |= (BONDING_PME_IDENTIFICATION);
         }
         InitializeInfoField_Bonding_NPar3(gpt_TxInfo);
      }
   }
      // set macrostate back to STAT_GhsState
      //----------------------------------
      // gsa_IndirectStat0[0] = STAT_GhsState;
      STATArray[STAT_MacroState] = STAT_GhsState;
      // gs_MONI_ModemStat_Status = MONI_STAT_GHS;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_GHS;
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_GhsState;
}
#endif   // ifdef ADSL_BONDING
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (End)

//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
/*========================================================================================*/
/*  Name: Activation_T1413_StateMachine
 *
 *  Abstract:
 *  The following routine is called for T1413 activation purpose.
 *
 *
 *
 *  Parameters:
 *
 *
 *
 *  Returns:
 *      None                     :
 *
 *  Global Variables Used:
 */
/*========================================================================================*/

void Activation_T1413_StateMachine()
{

   gs_TxNextState = R_ACT_REQ_TX;
   gpF_TxStateFunc = (PtrToFunc) RActReqTxF;

   gs_RxNextState = R_C_ACT_RX;
   gpF_RxStateFunc = (PtrToFunc) RCActRxF;

}
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)

/*========================================================================================*/
/*  Name: G.Lite Message in Capability List Reqst. message
 *
 *  Abstract:
 *  The following routine is called for G.Lite CLR Msg.
 *
 *
 *
 *  Parameters:
 *
 *
 *
 *  Returns:
 *      None                     :
 *
 *  Global Variables Used:
 */
/*========================================================================================*/
// Below code routine has been moved to Cache for program memory optimization( From File hndshk.c)
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(Start)
void GLite_PrepareCLR(){

   if (gpt_TxInfo->uc_SI_SPar1[0] & G992_2_AB)
    {
        gpt_TxInfo->uc_SI_2AB_SPar2 = SPECTRUM_UP | SPECTRUM_DN;

#ifdef INCLUDE_FASTRETRAIN_CODE
        gpt_TxInfo->uc_SI_2AB_NPar2  = R_ACK1 | R_ACK2 | FAST_RETRAIN | CLEAR_EOC_G997_1;
#else
        gpt_TxInfo->uc_SI_2AB_NPar2  = R_ACK1 | R_ACK2 | CLEAR_EOC_G997_1;
#endif

        if ((OPTNArray[OPTN_DMTLinkControl] & OPTN_RS16Support_Disable) == 0)
            gpt_TxInfo->uc_SI_2AB_NPar2    |=  RS16;
        else
            gpt_TxInfo->uc_SI_2AB_NPar2    &=  ~RS16;

    }

}

/*========================================================================================*/
/*  Name: G.993.2 Message in Capability List Reqst. message
 *
 *  Abstract:
 *  The following routine is called for G.993.2 Standard CLR Msg.
 *
 *
 *
 *  Parameters:
 *
 *
 *
 *  Returns:
 *      None                     :
 *
 *  Global Variables Used:
 */
/*========================================================================================*/
#ifdef VDSL2_HNDSHK
 // Below code is commented out due to non initialization of Code pointer routine. It is not clear
 // at this point about the routine is required in Message or not.
void PackBandInfo2MsgBuf(uint8 uca_M[], int16 *ps_idx, uint8 *uca_BandInfo, uint8 uc_NumBands)
{
   int16 i, idx, s_tones;

   idx = *ps_idx;

   //G993.2 GHS spec. specifies that each tone is represented by 13 bits (i.e., 3 bytes).
   //We do not want to apply this change to the VDSL1 for the backward compatibility
      s_tones = uc_NumBands*6;

   for(i=0; i<s_tones; i++)
      uca_M[idx++] = uca_BandInfo[i];

   uca_M[idx-1] |= DELIMIT_2;

   *ps_idx = idx;
}
#endif
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(End)

