/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_mesg_bis.c
 *
 *   Message handling functions used in Handshaking.
 *
 *-------------------------------------------------------------------------
 */
#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ghs.h"
#include "ifft_fix.h"
#include "hndshk_Data.h"
#include "spectral_shape_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: FormTpsTCParameters
 *
 *  Abstract:
 *
 *  FormTpsTCParameters() - For a particular bearer channel, form the TPS TC parameters from a structure to
 *  an array to be transmitted as a handshake message
 *
 *
 *  Parameters:
 *      TPS_TC_Type_t *pt_TpsTcType : information to be transmitted from
 *      uint8 *puc_M : information to be copied into and eventually transmitted
 *    int16  idx:    index into the buffer puc_M[]
 *    int16  idx:    return the updated index into the buffer puc_M[]
 *      uint16 type    the type of TPS-TC function (such as STM, ATM or PTM)
 *
 *  Returns: idx
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */
 //XDSLRTFW-1502 (start_end)
C_SCOPE int16 FormTpsTCParameters(TPS_TC_Type_t *pt_TpsTcType, uint8 *puc_M, int16 idx, uint16 type, int16 s_isDS)
{
   int l_idx;
   int16 uc_temp;

   l_idx = idx;

   puc_M[l_idx++] = (uint8)((pt_TpsTcType->s_MinNetDataRate >> 6) & 0x3F); /* min net data rate, bits 12 to 7 */
   puc_M[l_idx++] = (uint8)(pt_TpsTcType->s_MinNetDataRate & 0x3F);        /* min net data rate, bits 1 to 6 */
   puc_M[l_idx++] = (uint8)((pt_TpsTcType->s_MaxNetDataRate >> 6) & 0x3F); /* max net data rate, bits 12 to 7 */
   puc_M[l_idx++] = (uint8)(pt_TpsTcType->s_MaxNetDataRate & 0x3F);        /* max net data rate, bits 1 to 6 */
   puc_M[l_idx++] = (uint8)((pt_TpsTcType->s_MinResNetDataRate >> 6) & 0x3F);/* min reserved net data rate, bits 12 to 7 */
   puc_M[l_idx++] = (uint8)(pt_TpsTcType->s_MinResNetDataRate & 0x3F);     /* min reserved net data rate, bits 1 to 6 */

   // the following code is added according to the corrigendum(Jan. 03), which proposed Max Latecy (in the range of [0~63]) to be 0 has
   /// special meaning as no limit boundary
   if (pt_TpsTcType->s_MaxLatency>63)
      pt_TpsTcType->s_MaxLatency = 0;
   puc_M[l_idx++] = (uint8)(pt_TpsTcType->s_MaxLatency); /* max latency */

   puc_M[l_idx] = (uint8)(pt_TpsTcType->uc_MaxBER) & 0x03;  //Bit 1, 2 is Error_max

   uc_temp = pt_TpsTcType->s_IMAxINP;

   // if cmv to overwrite GHS is set, send '0' in the message. It should logically change to 0xFF later
   // but will do that once this feature is implemented by other COs.
   // set it to zero as we are also putting IMA is disabled

   if (TESTArray[TEST_Control2] & TEST_OverWriteMSwithCNFG_ADSL2)
      uc_temp= 0;

   puc_M[l_idx] |= ((uint8)(uc_temp) << 2) &0x0F;  //Bit 3, 4 is INP_min

   //XDSLRTFW-1502 (start)
   // Npar3 octet_8 of TPS-TC
   // enable trust me bit Bit#5 of NPAR3_octet8
   if ((gs_DSL_EDcontrol & DSL_Enable_ERASUREDECODING_REPORTING)&&(s_isDS))
   {
      puc_M[l_idx] |= (uint8)(1<< 4);
   }
   //XDSLRTFW-1502 (end)

   if (type == TPSTC_TYPE_ATM) // if ATM, there is additional IMA_Flag parameter
   {
      puc_M[l_idx] |= (uint8)((uc_temp>>8) & 0x01) << 5; // bit 6 is IMA_Flag
   }

   // following code is added according to new Amendment increasing INP range.
   // INP could be 8 bits, defining INP protection of 0-16 frames
   // Higher 6 bits are put in the next octate (bits 0-5)
   l_idx++;
   puc_M[l_idx] = ((uint8)(uc_temp>>2) ) & 0x3F;  //Bit 0-5 are INP_min (bits 3-7)
/*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
   if (type == TPSTC_TYPE_PTM)
   {
      l_idx++;
      puc_M[l_idx++]  |= guc_PtmOctet|DELIMIT_2;
   }
   else
   {
      puc_M[l_idx++]  |= DELIMIT_2;
   }

#else//if defined DANUBE_PTM_SUPPORT
/*********************************PTM CHANGES*************************************/
   puc_M[l_idx++]  |= DELIMIT_2;
/*****************************************PTM CHANGES**************************************/
#endif//if defined DANUBE_PTM_SUPPORT
/*********************************PTM CHANGES*************************************/
   idx = (int16)l_idx;
   return(idx);
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: int16 AddTpsTcInfo(int16 s_bc, InfoField_t *pt_Info, uint8 *puc_M, int16 idx)
 *
 *  Abstract:
 *
 *  AddTpsTcInfo() - For a particular bearer channel, form the TPS TC parameters from a structure to
 *  an array to be transmitted as a handshake message
 *
 *
 *  Parameters:
 *    int16 s_bc:    bearer channel or TPS_TC function number (0, 1, 2, 3)
 *      InfoField_t  *pt_Info : information to be transmitted from
 *      uint8 *puc_M : information to be copied into and eventually transmitted
 *    int16  idx:    index into the buffer puc_M[]
 *    int16  idx:    return the updated index into the buffer puc_M[]
 *
 *  Returns: idx
 *
 *  Global Variables Used: None
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */

C_SCOPE int16 AddTpsTcInfo(int16 s_bc, Adsl2AllInfo_t *pt_BisInfo, uint8 *puc_M, int16 idx)
{

   int i, j, mask;
   uint8 uc_octet;

   i = 2*(s_bc+1);

   uc_octet = pt_BisInfo->uc_SI_SPar2[i];
   mask = TPSTC_FUNC_STM_DN;

   for (j=0 ; j<3; j++)
   {
      /* DS TPS-TC #s_bc */
      if ( (uc_octet & mask) != 0 ) {
/*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
      guc_PtmOctet = (gt_INFX_CMV.us_PTM_Options_Indicated & PTM_DS_OPTIONS) >> 6;
#endif//if defined DANUBE_PTM_SUPPORT
/*********************************PTM CHANGES*************************************/
      //XDSLRTFW-1502 (start_end)
      idx = FormTpsTCParameters(&pt_BisInfo->ta_DSBearerChannel[s_bc].ta_TpsTcType[j], puc_M, idx, (uint16)j, 1);
      }

      mask <<= 1;

      /* US TPS-TC #s_bc */
      if ( (uc_octet & mask) != 0 ) {
/*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
         guc_PtmOctet = gt_INFX_CMV.us_PTM_Options_Indicated & PTM_US_OPTIONS;
#endif//if defined DANUBE_PTM_SUPPORT
/*********************************PTM CHANGES*************************************/
      //XDSLRTFW-1502 (start_end)
      idx = FormTpsTCParameters(&pt_BisInfo->ta_USBearerChannel[s_bc].ta_TpsTcType[j], puc_M, idx, (uint16)j, 0);
      }

      mask <<= 1;

   }

   return (idx);
}

