/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_misc.c
 *
 *   Miscellaneous operations used in Handshaking.
 *
 *-------------------------------------------------------------------------
 */
// *-------------------------------------------------------------------------
// hs_misc.c
//
// History
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// *-------------------------------------------------------------------------
#include "common.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "hndshk_Data.h"
#include "ifft_fix.h"
#include "ghs.h"
#include "cmv.h"
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start_End)
#ifdef ADSL_BONDING
#include "gdata.h"
#endif

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: MovingAvg
 *
 *  Description:
 *    Calculates a moving average of complex valued data in a circula buffer
 *
 *  Parameters:
 *      ta_Buf[]    -   circular buffer containing complex valued data
 *      s_BufLen    -   total length of ta_Buf
 *      s_Idx       -   starting index of average
 *      s_WindowLen -   length of moving average window
 *
 *  Returns:
 *      complex valued moving average result
 *
 *  Notes:
 *      The data buffer ta_Buf is complex valued and circular.
 *
 *-------------------------------------------------------------------
 *^^^
 */
Complex_t MovingAvg( Complex_t ta_Buf[], int16 s_BufLen, int16 s_Idx, int16 s_WindowLen ) {

    int      i;
    Complex_t t_Result;


    t_Result.s_X = t_Result.s_Y = 0;    /*  initialize */

    for ( i = 0; i < s_WindowLen; i++ ) {
        t_Result.s_X += ta_Buf[s_Idx].s_X >> 2;    /*  no rounding to prevent overflow */
        t_Result.s_Y += ta_Buf[s_Idx].s_Y >> 2;    /*  in case the value is saturated */
        s_Idx--;
        if ( s_Idx < 0 )    /*  circulate index */
            s_Idx = s_BufLen - 1;
    }

    return (t_Result);

}   /*  MovingAvg */

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: InitializeHSC
 *
 *  Description:
 *    Initialize Handshake Control structure
 *
 *  Parameters:
 *      pt_hsc - pointer to a HandShakeControl_t structure
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *-------------------------------------------------------------------
 *^^^
 */
void InitializeHSC( HandShakeControl_t *pt_hsc ) {
   /* first check which initial message CPE will start in handshake session */
   if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_INIT_MASK)==OPTN_RTInitTxMsg_CLR){
      gt_hsc.s_InitialMsg = START_WITH_CLR;
   }
   else if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_INIT_MASK)==OPTN_RTInitTxMsg_MR){
      gt_hsc.s_InitialMsg = START_WITH_MR;
   }
   else if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_INIT_MASK)==OPTN_RTInitTxMsg_MS){
      gt_hsc.s_InitialMsg = START_WITH_MS;
   }
   else if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_INIT_MASK)==OPTN_RTInitTxMsg_MP){
      gt_hsc.s_InitialMsg = START_WITH_MP;
   }
   else
   {
      gt_hsc.s_InitialMsg = START_WITH_CLR;  // back to default value
   }
    pt_hsc->s_State             = R_HS_INITIAL;
     pt_hsc->s_DecodeResult      = DECODE_SUCCESS;
    pt_hsc->l_SelectedMode      = NOT_SELECTED;
    pt_hsc->s_TxMsgComplete     = FALSE;
    pt_hsc->s_RxMsgComplete     = FALSE;
    pt_hsc->s_CL_Exchanged      = FALSE;
    pt_hsc->s_TxNSBCnt          = 0;
    pt_hsc->s_RxNSBCnt          = 0;

}   /*  InitializeHSC */
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)
#ifdef ADSL_BONDING
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : InitializeInfoField_Bonding_NPar3
 *  Author : Sriram Shastry
 *  Abstract :
 *    InitializeInfoField_Bonding_NPar3() - Initialize NPar3 Discovery and PME aggregation fields
 *
 *  Parameters:
 *      InfoField_t *t_I : information structure to be initialized
 *
 *  Returns: None
 *
 *-------------------------------------------------------------------
 *^^^
 */
C_SCOPE void InitializeInfoField_Bonding_NPar3(InfoField_t *t_I)
{
   // Discovery register
   t_I->uca_BondingDisc[0] = 0;
   t_I->uca_BondingDisc[1] = (gt_Bonding_Continue.sa_DiscCode[0] >> 10) & 0x3F;
   t_I->uca_BondingDisc[2] = (gt_Bonding_Continue.sa_DiscCode[0] >>  4) & 0x3F;
   t_I->uca_BondingDisc[3] = (gt_Bonding_Continue.sa_DiscCode[0] <<  2) & 0x3C
      | (gt_Bonding_Continue.sa_DiscCode[1] >>  14) & 0x03 ;
   t_I->uca_BondingDisc[4] = (gt_Bonding_Continue.sa_DiscCode[1] >>  8) & 0x3F;
   t_I->uca_BondingDisc[5] = (gt_Bonding_Continue.sa_DiscCode[1] >>  2) & 0x3F;
   t_I->uca_BondingDisc[6] = (gt_Bonding_Continue.sa_DiscCode[1] <<  4) & 0x30
      | (gt_Bonding_Continue.sa_DiscCode[2] >>  12) & 0x0F ;
   t_I->uca_BondingDisc[7] = (gt_Bonding_Continue.sa_DiscCode[2] >>  6) & 0x3F;
   t_I->uca_BondingDisc[8] = (gt_Bonding_Continue.sa_DiscCode[2] >>  0) & 0x3F;

   // PME aggregation register
   t_I->uca_BondingAggr[0] = (gt_Bonding_Continue.sa_PMEAggr_data[0] >>  14) & 0x03 ;
   t_I->uca_BondingAggr[1] = (gt_Bonding_Continue.sa_PMEAggr_data[0] >>  8) & 0x3F;
   t_I->uca_BondingAggr[2] = (gt_Bonding_Continue.sa_PMEAggr_data[0] >>  2) & 0x3F;
   t_I->uca_BondingAggr[3] = (gt_Bonding_Continue.sa_PMEAggr_data[0] <<  4) & 0x30
      | (gt_Bonding_Continue.sa_PMEAggr_data[1] >>  12) & 0x0F ;
   t_I->uca_BondingAggr[4] = (gt_Bonding_Continue.sa_PMEAggr_data[1] >>  6) & 0x3F;
   t_I->uca_BondingAggr[5] = (gt_Bonding_Continue.sa_PMEAggr_data[1] >>  0) & 0x3F;
   t_I->uc_BondingId  = (gus_Bonding_PME_ID & 0x1F) ;     // XDSLRTFW-2382 (Start_End)

}

#endif   // #ifdef ADSL_BONDING
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(End)

