/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_resp.c
 *
 *   Functions that are used to decide how to respond to received messages
 *   in a G.hs session.
 *
 *-------------------------------------------------------------------------
 */

// ******************************************************************
// hs_resp.c
//
// History
//
// 18/08/2010 Veena/Sabrina/Bhadra : Against some Calix CNXT DSLAM, with mask EU60, the US rate was
//            1.4 Mbps at null loop in Annex M mode. The workaround is to send TI VID
//            in long CLR against CNXT DSLAM in AnnexM to improve US rate performance.
//            Grep for SMS01501979 SMS01368330 IOP_M_US_BisPlus_CNXT_TIVIDforBetterUSRate
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// 23/12/2011 Sabrina Y/Balabath : To improve US performance, retrain and switch to Aware VID
//            for IKNS DSLAMs.
//            Grep for XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE
//
// 23/12/2013 Balabath: Improvement of US Data rates at short loops from the HOL labs.
// Solution : try to match signal shape same as Danube by using new TSSI pointers.
// And also communicate the tssi break points in handshake
// This gave improvement around 60kbps. For code changes
//          Grep for "XDSLRTFW-1445:Enhancement_US_BISPlus_CNXT_USPerf_MidrangeLoops
//
// 25/03/2014 Hanyu: Ported ADSLRTFW-1392: Marconi MX QDC-1 sends out an undefined G.994.1
//            Vendor ID in CL standard field and "ALCB" only in non-standard
//            field. FW has to link this CO to ALCB and apply a special sync
//            symbol scaling to avoid link drop.
//            Grep for XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4
//
// 10/04/2014 Sriram Shastry: To reduce the training time against CNX5, the
//            following two changes are introduced.
//            1. Remove US bounds/TSSI information from long CLR.
//            2. Remove the additional long CLR which is due to the CPE
//               preferred US PSD MASK is not matched with CO in the G.hs
//               Annex L message. When this happends, CPE just takes the
//               information from CL and doesn't need to send back to CO.
//            This is protected by CMV info 103 26 0x100. The default value
//            is 0 (Disabled.)
//            Grep for ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS
//
// 10/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
//      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
//      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
//      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
//          to avoid US/DS link drop due to polit tone corruption.
//      (3) Limited US max bits/bin to 8.
//      The above changes are protected by PLSE CO vendor ID and CMV
//      info 103 26 0x0800 with default value 0 (Disabled).
//      Enabling the CMV bit may introduce side-effects for both US and DS performance.
//      It is only recommended for AT&T profiles with the capped US/DS lower data rates
//      attached in the Jira entry.
//         Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
// 12/10/2015 Vinay: Added code to support G.Fast in ADSL G.Hs session.
//            Grep for XDSLRTFW-2298
//
// 10/10/2017 Abu Rahman
//            XDSLRTFW-3511 : VRX518 ADSL(2/2+) C-Comb based Loop Length Estimation with considering PCB for ISDN
//            Include Ghs PCB information from CL identification field in Ghs CTone power measurement which
//            is used for Ghs based loop length estimation. This Modification is done only for ISDN mode.
//            Grep for XDSLRTFW-3511
// 27/08/2018 Stefan Krause
//            XDSLRTFW-3841 - VRX518 stuck in line state 300 in ADSL-ATM, ADSL-PTM and AUTOMODE
//            GHs is stuck in an endless loop if the previous GHs session was terminated by CO
//            by sending a "NAK-EF" command (The Rx-Message structure is not re-initialized - so
//            GHs will be terminated by FW automatically once the tone-detection phase is passed
//            and the message handler HSMsgHandler gets started.
//            Resetting (at least the header) of the Rx-Msg structure resolves the problem
// Grep for XDSLRTFW-3841
// ******************************************************************
#include "common.h"
#include "gdata.h"
#include "rt_state.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "cmv.h"
#include "hndshk_Data.h"
#include "string.h"
#include "gdata_bis.h"
#include "trail.h"
#include "tssi_rx.h"
#include "bitload_const.h"
#include "spectral_shape_bis.h"
// IOP_DS_BisPlus_BDCM_DoubleTraining SMS00851057 SMS00881320 (begin)
#ifndef ISDN         // Only for Annex-A
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START_END)
#include "states.h"
#endif   // #ifndef ISDN
// IOP_DS_BisPlus_BDCM_DoubleTraining SMS00851057 SMS00881320 (end)

#define DIFFERENT_PREF_MODE        (0x0001)
#define HIGHER_CLR_US_PMD          (0x0002)
#define DIFFERENT_TSSI_INFO        (0x0004)
#define LOG_CLRSAVED          (0x0008)
#define LOG_NEWCLR_BEFOREMODIFYING  (0x0010)
#define LOG_NEWCLR_AFTERMODIFYING   (0x0020)

//HSMsgHandler substate functions. Each one corresponds to one G.HS ATU_R state (see G.HS standard Figure 12.2)
void R_HS_INITIAL_state (void);
void R_HS_SEND_MR_state (void);
void R_HS_SEND_MS_state (void);
void R_HS_SEND_CLR_state (void);
void R_HS_MS_OK_state (void);
void R_HS_CL_OK_state (void);
void R_HS_PARTIAL_MS_state (void);
void R_HS_PARTIAL_CL_state (void);
void R_HS_NOT_READY_state (void);
void R_HS_NOT_SUPPORTED_state (void);
void R_HS_NOT_UNDERSTOOD_state (void);
void R_HS_RESTART_state (void);
void R_HS_SEND_MP_state (void);           // new state in Rev 2
void R_HS_RETRANSMIT_state (void);  // new state in Rev 3

// function pointer arrays to all HSMsgHandler substate functions
void (*MsgHandler_states []) (void) = { &R_HS_INITIAL_state,
                              &R_HS_SEND_MR_state,
                              &R_HS_SEND_MS_state,
                              &R_HS_SEND_CLR_state,
                              &R_HS_MS_OK_state,
                              &R_HS_CL_OK_state,
                              &R_HS_PARTIAL_MS_state,
                              &R_HS_PARTIAL_CL_state,
                              &R_HS_NOT_READY_state,
                              &R_HS_NOT_SUPPORTED_state,
                              &R_HS_NOT_UNDERSTOOD_state,
                              &R_HS_RESTART_state,
                              &R_HS_SEND_MP_state,
                              &R_HS_RETRANSMIT_state
                           };


/* =============================================== */
/* static function prototypes */
/* =============================================== */
void  Do_ClearDown();
void  PrepareMS();
void  PrepareCLR();
void  ResponseToMS();
void  ResponseToCL();

#ifndef TARGET_HW
#define PREPAREMS_BIS
#endif

#ifdef PREPAREMS_BIS
void FormTpsTcSpar2ForMSMessage(TPS_TC_Type_t *pt_Info_TpsTcType, TPS_TC_Type_t *pt_TxCL_TpsTcType, TPS_TC_Type_t *pt_RxCL_TpsTcType, uint16 type);
#endif

FlagT  Compare_CL_CLR();
extern HS_Encode_ADSL2_t   gta_HS_ADSL2[]; //XDSLRTFW-1445:Enhancement_US_BISPlus_CNXT_USPerf_MidrangeLoops(Start_End)


void Modify_USSpectralShape(void);
// SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (START)
// move gft_StopTssiInClr here to be referenced by R_HS_CL_OK_state
FlagT gft_StopTssiInClr = 0;  // default don't stop tssi.
// SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (END)

//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start_End)
void StoreInfoField_Bonding_NPar3(InfoField_t *t_I, uint8 uc_FieldToStore);

void EnterFailStates(uint32);

int16 isCLPreferredPSDMask(Adsl2AllInfo_t *pt_RxAnnex)
{
   int16 us_PSD_Mask = 0;
   int i, s_value, s_shift;
   if(pt_RxAnnex->uc_SI_SPar2[0] & PSD_MASK)
   {
      for (i = 0; i < 9; i++)
      {
         s_value = pt_RxAnnex->uca_PSD_Mask[i/6];
         s_shift = i - i/6*6;
         if (s_value & (1<<s_shift))
            us_PSD_Mask = i;
      }
   }
   else
   {
      us_PSD_Mask = EU32_PSDMASK;
   }
   return (us_PSD_Mask);
}

FlagT isUpdatedCLRSpectrumBoundInfo(Adsl2AllInfo_t *pt_CLR_Adsl2AllInfo, Adsl2AllInfo_t *pt_CLRSaved_Adsl2AllInfo, Adsl2AllInfo_t *pt_CLSaved_Adsl2AllInfo)
{
   // Always log the info from CO first for debug purpose
   DebugTrail(6, DEBUG_LOG_GHSCLINFO, 0x7FFF, HIGHER_CLR_US_PMD, pt_CLSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD, pt_CLSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD, pt_CLSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP, 0x7FFF);
   DebugTrail(6, DEBUG_LOG_GHSCLINFO, 0x7FFF, LOG_CLRSAVED, pt_CLRSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD, pt_CLRSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD, pt_CLRSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP, 0x7FFF);
   DebugTrail(6, DEBUG_LOG_GHSCLINFO, 0x7FFF, LOG_NEWCLR_BEFOREMODIFYING, pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD, pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD, pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP, 0x7FFF);

   //compare PMD US info, see note 1 above
   if ((pt_CLSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD < pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD) ||
      (pt_CLSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD < pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD) ||
      (pt_CLSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP < pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP))

   {

      // shall we do the validation check before assign the values here? --ysun
      // Save CO's PMD US values and prepare to resend CLR with the updated PMD value
      pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD = pt_CLSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD;      /*  Upstream nominal PSD */
      pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD = pt_CLSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD;  /*  Upstream maximum PSD */
      pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP = pt_CLSaved_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP;   /*  Upstream maximum aggregrate transmit power */

      DebugTrail(6, DEBUG_LOG_GHSCLINFO, 0x7FFF, LOG_NEWCLR_AFTERMODIFYING, pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD, pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD, pt_CLR_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP, 0x7FFF);

      return(TRUE);
   }

   return(FALSE);
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: Compare_CL_CLR
 *
 *  Abstract: Compare CL/CLR content after the exchange
 *          Decide how to respond to the received message
 *
 *  Returns: Flag indicate whether we should resend CLR or not, it also indicates what causes resending CLR so that
 *           we can check internally
 *           0x0000:  Do not need to resend CLR
 *           0x0001:  CLR/CL have different mode (BIS A/L specific), which will trigger retransmit the CLR with different PSD mask
 *           0x0002:  CLR has US PMD values higher than the ones contained in CL
 *           0x0004.  CLR/CL have different US Tssi info
 *
 * The CLR resending could be caused by a single one reason above or the combination of them.
 *
 *  Global Variables Used:
 *          gpt_RxInfo             - (I) received CL message
 *          gpt_TxInfo             - (O) message to be transmitted in response
 *          gpt_TxInfoSave         - (O) a duplicate of the received message
 *
 *-------------------------------------------------------------------
 *^^^
 */
#define ENABLE_TSSI_COMPARE
#ifndef BIS_CODESWAP
extern int16 gs_COTSSI_NumOfBrkpts;
#endif


FlagT  Compare_CL_CLR()
{
   int i, j, k, l;
   uint8* puc_index;
    int16 us_PSD_Mask, s_num_USTssi_Xmitted;
   FlagT ft_retCode;

    Adsl2AllInfo_t *pt_RxAnnex;
    Adsl2AllInfo_t *pt_TxAnnex1;
    int16 *ps_PSDMask;
   uint16 usa_CL_BrkptIdx[MAX_NUM_US_TSSI_VALUES], usa_CLR_BrkptIdx[MAX_NUM_US_TSSI_VALUES];
   Adsl2AllInfo_t** pta_RxInfoSave[2] = {&(gpt_RxInfoSave->pta_G9923xInfo[0]), &(gpt_RxInfoSave->pta_G9925xInfo[0])};
   Adsl2AllInfo_t** pta_TxInfo[2] = {&(gpt_TxInfo->pta_G9923xInfo[0]), &(gpt_TxInfo->pta_G9925xInfo[0])};
   Adsl2AllInfo_t** pta_TxInfoSave[2] = {&(gpt_TxInfoSave->pta_G9923xInfo[0]), &(gpt_TxInfoSave->pta_G9925xInfo[0])};
   int sa_NUM_ANNEX_SUPPORTED[2] = {NUM_G992_3_ANNEX_SUPPORTED, NUM_G992_5_ANNEX_SUPPORTED};


   // initialize the return code
   ft_retCode = 0;


   /****************************************************/
   /* Check for inconsistency in sub-modes */
   /****************************************************/

   // We 'could' optimize the below comparison by putting it in a loop NUM_G992_x_ANNEX_SUPPORTED

#ifndef ISDN

   // if CL chooses a different BIS AnnexA/L sub-mode than one indicated in CLR msg
   if (gpt_RxInfoSave->uc_SI_SPar1[2] & (G992_3_A>>16) &&
      gpt_TxInfoSave->uc_SI_SPar1[2] & (G992_3_A>>16))
   {

      us_PSD_Mask = DEFAULT_G992_3A_PSDMASK;    // Default unless Annex L is chosen.

      if(gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_A]->uc_SI_SPar2[0] & PSD_MASK)
      {
         gft_AnxL_PSD_selected = 1;
         // See if an AnnexL US PSD mask is indicated.  No more than one of these should be set.
         if (gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_A]->uca_PSD_Mask[0] & PSD_US_WIDE_SPECTRUM)
            us_PSD_Mask = REACHEXT_G992_3L_USPSDMASK1;
         else if (gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_A]->uca_PSD_Mask[0] & PSD_US_NARROW_SPECTRUM)
            us_PSD_Mask = REACHEXT_G992_3L_USPSDMASK2;

         if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
         {  // Special US tssi for Globespan give better US rates.
            memcpy(guca_US_TssiIndex_G9923A[REACHEXT_G992_3L_USPSDMASK1], guca_US_TssiIndex_G9923L_M1_GSPN, NUM_US_TSSI_VALUES_INITIAL_CLR);
            memcpy(guca_US_TssiIndex_G9923A[REACHEXT_G992_3L_USPSDMASK2], guca_US_TssiIndex_G9923L_M2_GSPN, NUM_US_TSSI_VALUES_INITIAL_CLR);
            memcpy(guca_US_TssiValue_G9923A[REACHEXT_G992_3L_USPSDMASK1], guca_US_TssiValue_G9923L_GSPN, NUM_US_TSSI_VALUES_INITIAL_CLR);
            memcpy(guca_US_TssiValue_G9923A[REACHEXT_G992_3L_USPSDMASK2], guca_US_TssiValue_G9923L_GSPN, NUM_US_TSSI_VALUES_INITIAL_CLR);
            memcpy(gfta_US_SprtSet_G9923A[REACHEXT_G992_3L_USPSDMASK1], gfta_US_SprtSet_G9923L_GSPN, NUM_US_TSSI_VALUES_INITIAL_CLR>>3);
            memcpy(gfta_US_SprtSet_G9923A[REACHEXT_G992_3L_USPSDMASK2], gfta_US_SprtSet_G9923L_GSPN, NUM_US_TSSI_VALUES_INITIAL_CLR>>3);
         }
      }


         // log the preferred PSD mask info in CL msg
      DebugTrail(4, DEBUG_LOG_GHSCLINFO, 0x7FFF, DIFFERENT_PREF_MODE, us_PSD_Mask, 0x7FFF);

      // Compare the CL mode with our internal preferred mode
      if (us_PSD_Mask != gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A])
      {
         // update the CPE preferred mode by CO preferred mode 'coz we are slaves :-(((
         gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A] = us_PSD_Mask;

         // Update the TSSi paramters and prepare to resend CLR
         puc_index = (uint8*)(void *)gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->t_PMD_NPar3_US.pus_BreakFreq;
         for (i = 0; i < gsa_num_USTssi_Xmitted[0]; i++)
            *(puc_index++) = guca_US_TssiIndex_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]][i];
         memcpy(gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->t_PMD_NPar3_US.pf_InSprtSet, &gfta_US_SprtSet_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]][0], gsa_num_USTssi_Xmitted[0]>>3);
         memcpy(gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->t_PMD_NPar3_US.puc_tssi, &guca_US_TssiValue_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]][0], gsa_num_USTssi_Xmitted[0]);

         // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
         gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->t_PMD_NPar3_US.s_NOMPSD     = gsa_US_NOMPSD_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]];    /*  Upstream nominal PSD */
         gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->t_PMD_NPar3_US.s_MAXNOMPSD  = gsa_US_MAXNOMPSD_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]]; /*  Upstream maximum PSD */
         gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->t_PMD_NPar3_US.s_MAXNOMATP  = gsa_US_MAXNOMATP_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]]; /*  Upstream maximum aggregrate transmit power */

         //ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS (START)
         //For CNX5 DSLAM, skip the steps to send the information copied
         //from CL back to CO due to the mismatch of US PSD mask.
         if (!gft_CTNW_Shorten_GHS)
            ft_retCode |= DIFFERENT_PREF_MODE;
         //ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS (END)


#ifdef LEAVE_TRAIL
         GhsLeaveTrail((int16)DIFFERENT_PREF_MODE, gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A], 0, "CLR Resend", 0, NULL);
#endif
      }
   }

#else//ISDN

   // if CL chooses a different Plus AnnexJ sub-mode than one indicated in CLR msg
   if ((gpt_RxInfoSave->uc_SI_SPar1[3] & (G992_5_J>>24) &&
      gpt_TxInfoSave->uc_SI_SPar1[3] & (G992_5_J>>24))
        ||
        (gpt_RxInfoSave->uc_SI_SPar1[2] & (G992_3_J>>16) &&
      gpt_TxInfoSave->uc_SI_SPar1[2] & (G992_3_J>>16)))

   {

        //Now we know Annex-J is selected, and we assume
        //G992.3J andG992.5J use the same table for its PSD mask stuff.
        if (gpt_RxInfoSave->uc_SI_SPar1[2] & (G992_3_J>>16) &&
            gpt_TxInfoSave->uc_SI_SPar1[2] & (G992_3_J>>16)) {
            //3.J
            pt_RxAnnex = gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_J];
            pt_TxAnnex1 = gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_J];;
            ps_PSDMask = &(gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_J]);
         s_num_USTssi_Xmitted = gsa_num_USTssi_Xmitted[0];
        }
        else{
            //5.J
            pt_RxAnnex = gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_J];
            pt_TxAnnex1 = gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_J];;
            ps_PSDMask = &(gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_J]);
         s_num_USTssi_Xmitted = gsa_num_USTssi_Xmitted[1];
        }

      us_PSD_Mask = isCLPreferredPSDMask(pt_RxAnnex);

      // log the preferred PSD mask info in CL msg
      DebugTrail(4, DEBUG_LOG_GHSCLINFO, 0x7FFF, DIFFERENT_PREF_MODE, us_PSD_Mask, 0x7FFF);

      // Compare the CL mode with our internal preferred mode
      if (us_PSD_Mask != *ps_PSDMask)
      {
         // update the CPE preferred mode by CO preferred mode 'coz we are slaves :-(((
         *ps_PSDMask = us_PSD_Mask;

         // Update the TSSi paramters and prepare to resend CLR
         puc_index = (uint8*)(void *)pt_TxAnnex1->t_PMD_NPar3_US.pus_BreakFreq;
         for (i = 0; i < s_num_USTssi_Xmitted; i++)
            *(puc_index++) = guca_US_TssiIndex_AnnexJ[*ps_PSDMask][i];

         memcpy(pt_TxAnnex1->t_PMD_NPar3_US.pf_InSprtSet, &gfta_US_SprtSet_AnnexJ[*ps_PSDMask][0], s_num_USTssi_Xmitted>>3);
         memcpy(pt_TxAnnex1->t_PMD_NPar3_US.puc_tssi, &guca_US_TssiValue_AnnexJ[*ps_PSDMask][0], s_num_USTssi_Xmitted);

         // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
         pt_TxAnnex1->t_PMD_NPar3_US.s_NOMPSD      = gsa_US_NOMPSD_AnnexJ[*ps_PSDMask];      /*  Upstream nominal PSD */
         pt_TxAnnex1->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_AnnexJ[*ps_PSDMask];  /*  Upstream maximum PSD */
         pt_TxAnnex1->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_AnnexJ[*ps_PSDMask];  /*  Upstream maximum aggregrate transmit power */

         ft_retCode |= DIFFERENT_PREF_MODE;

#ifdef LEAVE_TRAIL
         GhsLeaveTrail((int16)DIFFERENT_PREF_MODE, *ps_PSDMask, 0, "CLR Resend", 0, NULL);
#endif
      }

      gs_AnnexBMJPSDMaskIdx = *ps_PSDMask;
   }

#endif//ISDN

   // if CL chooses a different BIS AnnexM sub-mode than one indicated in CLR msg
   if ((gpt_RxInfoSave->uc_SI_SPar1[3] & (G992_3_M>>24) &&
      gpt_TxInfoSave->uc_SI_SPar1[3] & (G992_3_M>>24))
        ||
        (gpt_RxInfoSave->uc_SI_SPar1[4] & (G992_5_M) &&
      gpt_TxInfoSave->uc_SI_SPar1[4] & (G992_5_M)))
   {
        //Now we know Annex-M is selected, and we assume
        //G992.3M andG992.5M use the same table for its PSD mask stuff.
        if (gpt_RxInfoSave->uc_SI_SPar1[3] & (G992_3_M>>24) &&
            gpt_TxInfoSave->uc_SI_SPar1[3] & (G992_3_M>>24)) {
            //3.M
            pt_RxAnnex = gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_M];
            pt_TxAnnex1 = gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_M];;
            ps_PSDMask = &(gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]);
         s_num_USTssi_Xmitted = gsa_num_USTssi_Xmitted[0];
        }
        else{
            //5.M
            pt_RxAnnex = gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_M];
            pt_TxAnnex1 = gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_M];;
            ps_PSDMask = &(gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M]);
         s_num_USTssi_Xmitted = gsa_num_USTssi_Xmitted[1];
       }

      us_PSD_Mask = isCLPreferredPSDMask(pt_RxAnnex);

      // log the preferred PSD mask info in CL msg
      DebugTrail(4, DEBUG_LOG_GHSCLINFO, 0x7FFF, DIFFERENT_PREF_MODE, us_PSD_Mask, 0x7FFF);

      // Compare the CL mode with our internal preferred mode
      if (us_PSD_Mask != *ps_PSDMask)
      {
         // update the CPE preferred mode by CO preferred mode 'coz we are slaves :-(((
         *ps_PSDMask = us_PSD_Mask;

         // Update the TSSi paramters and prepare to resend CLR
         puc_index = (uint8*)(void *)pt_TxAnnex1->t_PMD_NPar3_US.pus_BreakFreq;
         for (i = 0; i <s_num_USTssi_Xmitted; i++)
            *(puc_index++) = guca_US_TssiIndex_AnnexM[*ps_PSDMask][i];

         memcpy(pt_TxAnnex1->t_PMD_NPar3_US.pf_InSprtSet, &gfta_US_SprtSet_AnnexM[*ps_PSDMask][0], s_num_USTssi_Xmitted>>3);
         memcpy(pt_TxAnnex1->t_PMD_NPar3_US.puc_tssi, &guca_US_TssiValue_AnnexM[*ps_PSDMask][0], s_num_USTssi_Xmitted);

         // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
         pt_TxAnnex1->t_PMD_NPar3_US.s_NOMPSD      = gsa_US_NOMPSD_AnnexM[*ps_PSDMask];      /*  Upstream nominal PSD */
         pt_TxAnnex1->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_AnnexM[*ps_PSDMask];  /*  Upstream maximum PSD */
         pt_TxAnnex1->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_AnnexM[*ps_PSDMask];  /*  Upstream maximum aggregrate transmit power */

         ft_retCode |= DIFFERENT_PREF_MODE;

#ifdef LEAVE_TRAIL
         GhsLeaveTrail((int16)DIFFERENT_PREF_MODE, *ps_PSDMask, 0, "CLR Resend", 0, NULL);
#endif
      }

      gs_AnnexBMJPSDMaskIdx = *ps_PSDMask;
   }

   /****************************************************/
   /* Check for inconsistency in spectrum bound/shape */
   /****************************************************/
   // As BIS/BIS+spec specified, we should further on check the PMD spectrum bounds and shape consistency
   // as well once we have COMMON mode i.e., make sure
   // 1. If CO specifies US TSSI in CL msg, US TSSI in the CLR msg matches the one sent in CL
   // 2. NOMPSDus, MAXNOMPSDus and MAXNOMATPus levels in the CLR msg shall be no higher than the corresponding levels in the CL msg
   // If one of the above is not met, we should recalcuate and resend CLR as well.
   // check for inconsistency in spectrum bound
   for (k = 0; k < 2; k++)
   {
      for (i = 0; i < sa_NUM_ANNEX_SUPPORTED[k]; i++)
      {
         if (((*(pta_RxInfoSave[k]+i))->uc_SI_SPar2[0]) & SPECTRUM_BOUNDS_UP)    // if CO transmit US PMD info
         {
            if (isUpdatedCLRSpectrumBoundInfo(*(pta_TxInfo[k]+i), *(pta_TxInfoSave[k]+i), *(pta_RxInfoSave[k]+i)) &&
               (((*(pta_TxInfoSave[k]+i))->uc_SI_SPar2[0]) & SPECTRUM_BOUNDS_UP))
            {
               ft_retCode |= HIGHER_CLR_US_PMD;
#ifdef LEAVE_TRAIL
               GhsLeaveTrail(HIGHER_CLR_US_PMD, 0, 0, "CLR Resend", 0, *(pta_TxInfo[k]+i));
#endif
            }
         }
      }
   }


   // check for inconsistency in spectrum shape
#ifdef ENABLE_TSSI_COMPARE


   for (l = 0; l < 2; l++)
   {
      for ( i = 0; i < sa_NUM_ANNEX_SUPPORTED[l]; i++)
      {
         if(((*(pta_RxInfoSave[l]+i))->uc_SI_SPar2[0]) & SPECTRUM_SHAPE_UP)   // if CO transmit US tssi info
         {
            int s_index, s_final_index, s_shift, s_Si;
            PMD_Type_t t_Index;
            TxToneFlags p_CLR_SUPPORTEDset_US, p_CL_SUPPORTEDset_US;
            uint8 *puca_CLR_USTssiIdx, *pfta_CLR_USSi, *puca_CLR_USTssi;
            uint8 *puca_CLR_USTssiIdx2, *pfta_CLR_USSi2, *puca_CLR_USTssi2;
            uint8 *puca_CL_USTssiIdx, *pfta_CL_USSi, *puca_CL_USTssi;
            int s_PrevSi, s_CurSi, ft_AddPrevPoint, ft_AddCurPoint, s_Condition1, s_Condition2;

            //1) Generate two bit arrays (one bit per tone) for US, CLR_SupportedSet and CL_SupportedSet_US,
            //based on the SUPPORTEDset of CLR message and the US SUPPORTEDset of CL message
            t_Index = (*(pta_RxInfoSave[l]+i))->t_PMD_NPar3_US;
            puca_CL_USTssiIdx = (uint8*)(void *)t_Index.pus_BreakFreq;
            for (j = 0; j < gsa_num_US_Tssi_brkpt_kept[l]; j++)
            {
               usa_CL_BrkptIdx[j] = puca_CL_USTssiIdx[j];
            }

            pfta_CL_USSi = t_Index.pf_InSprtSet;
            puca_CL_USTssi = t_Index.puc_tssi;

            t_Index = (*(pta_TxInfoSave[l]+i))->t_PMD_NPar3_US;
            puca_CLR_USTssiIdx = (uint8*)(void *)t_Index.pus_BreakFreq;
            for (j = 0; j < gsa_num_USTssi_Xmitted[l]; j++)
            {
               usa_CLR_BrkptIdx[j] = puca_CLR_USTssiIdx[j];
            }

            for (j=0 ; j<TX_NUM_TONES ; j++){
               CLEARTONEFLAG(p_CL_SUPPORTEDset_US, j);
               CLEARTONEFLAG(p_CLR_SUPPORTEDset_US, j);
            }

            pfta_CLR_USSi = t_Index.pf_InSprtSet;
            puca_CLR_USTssi = t_Index.puc_tssi;


            DefineSupportedSet(p_CLR_SUPPORTEDset_US, TX_NUM_TONES, (int16 *)(void *)usa_CLR_BrkptIdx, pfta_CLR_USSi, gsa_num_USTssi_Xmitted[l]);
            DefineSupportedSet(p_CL_SUPPORTEDset_US, TX_NUM_TONES, (int16 *)(void *)usa_CL_BrkptIdx, pfta_CL_USSi, gsa_num_US_Tssi_brkpt_kept[l]);


            //2) Verify the received CL US Tssi breakpoints, update the CLR US Tssi bit array for the tones
            //which must be removed from the US supported set,
            for (j = 0; j < TX_NUM_TONES; j++)
            {
               if(IS_TONEFLAGSET(p_CLR_SUPPORTEDset_US, j) && !IS_TONEFLAGSET(p_CL_SUPPORTEDset_US, j))
               {
                  CLEARTONEFLAG(p_CLR_SUPPORTEDset_US, j);
                  if (gsa_num_USTssi_Xmitted[l] < MAX_NUM_US_TSSI_VALUES)
                     ft_retCode |= DIFFERENT_TSSI_INFO;
                  else
                  {
                     //we will continue with Handshake if there is no more memory to add
                     //new breakpoint.
                     gt_hsc.s_DecodeResult = TSSI_BreakPoint_OVERFLOW;
#ifdef LEAVE_TRAIL
               GhsLeaveTrail(TSSI_BreakPoint_OVERFLOW, 0, 0, "Ignore Difference", 0, NULL);
#endif
                  }
               }
            }

            //3) Scan through updated CLR US Tssi Si array.  If all values are 1, then supported sets are consistent,
            //no changes need to be made and CLR does not need to be resent.  Otherwise consider adding tones as
            //new breakpoints:
            // For each tone i,
            //i.  If Si[i-1] = 1 and Si[i] = 0, then do two things:
            //    -  If no existing breakpt at i-1 and i>0, add a breakpoint to CLR_SupportedSetUS at tone i-1
            //       with SupportedSetUS = 1 and tssi=126.
            //    -  Add a breakpt at tone i with SupportedSetUS = 0 and tssi=126.  Or if a breakpt already exists,
            //       set its SupportedSet value to 0 but don't change its tssi value.
            //ii. If Si[i-1] = 0 and Si[i] = 1, then do two things:
            //    -  Add a breakpt at tone i-1 with SupportedSetUS = 0 and tssi=126.  Or if a breakpt already exists,
            //       set its SupportedSet value to 0 but don't change its tssi value.
            //    -  If no existing breakpt at i, and i is a valid tone, add a breakpoint to
            //       CLR_SupportedSetUS at tone i with SupportedSetUS = 1 and tssi=126.
            s_index = gsa_num_USTssi_Xmitted[l];
            if (ft_retCode & DIFFERENT_TSSI_INFO)
            {
               for (j = 1; j < TX_NUM_TONES; j++)
               {
                  s_PrevSi = IS_TONEFLAGSET(p_CLR_SUPPORTEDset_US, j-1);
                  s_CurSi = IS_TONEFLAGSET(p_CLR_SUPPORTEDset_US, j);
                  if (s_PrevSi ^ s_CurSi)
                  {
                     ft_AddPrevPoint = TRUE;
                     ft_AddCurPoint = TRUE;
                     for (k = 0; k < s_index; k++)
                     {
                        if (puca_CLR_USTssiIdx[k] == (j-1))
                           ft_AddPrevPoint = FALSE;
                        if (puca_CLR_USTssiIdx[k] == j)
                           ft_AddCurPoint = FALSE;
                     }

                     s_shift = s_index & 0x7;
                     if (ft_AddPrevPoint)
                     {
                        puca_CLR_USTssiIdx[s_index] = j-1;
                        pfta_CLR_USSi[s_index>>3] |= s_PrevSi<<s_shift;
                        s_index++;
                     }

                     //protect the case we don't have enough data memory to save the new breakpoint
                     if (s_index == MAX_NUM_US_TSSI_VALUES)
                        break;

                     s_shift = s_index & 0x7;
                     if (ft_AddCurPoint)
                     {
                        puca_CLR_USTssiIdx[s_index] = j;
                        pfta_CLR_USSi[s_index>>3] |= s_CurSi<<s_shift;
                        s_index++;
                     }

                     //protect the case we don't have enough data memory to save the new breakpoint
                     if (s_index == MAX_NUM_US_TSSI_VALUES)
                        break;
                  }
               }

               //combine CLR and CL
               //4) At the end, the code scans through the updated US Tssi breakpoint array and sorts the breakpoints
               //in the numerical order. At the same time, updates the  counter variable called gsa_num_USTssi_Xmitted.
               s_final_index = 0;
               puca_CLR_USTssiIdx2 = gt_GHS_USTssiInfo.uca_Brkpt;
               pfta_CLR_USSi2 = gt_GHS_USTssiInfo.uca_Si;
               puca_CLR_USTssi2 = gt_GHS_USTssiInfo.uca_Tssi;
               k = 0;
               j = gsa_num_USTssi_Xmitted[l];

               while (s_final_index < MAX_NUM_US_TSSI_VALUES)
               {
                  s_Condition1 = k < gsa_num_USTssi_Xmitted[l];
                  s_Condition2 = j < s_index;
                  s_shift = s_final_index & 0x7;
                  if ((s_Condition1 && s_Condition2 && puca_CLR_USTssiIdx[k] < puca_CLR_USTssiIdx[j])
                     ||(s_Condition1 && !s_Condition2))
                  {
                     puca_CLR_USTssiIdx2[s_final_index] = puca_CLR_USTssiIdx[k];
                     puca_CLR_USTssi2[s_final_index] = puca_CLR_USTssi[k];
                     s_Si = IS_TONEFLAGSET(p_CLR_SUPPORTEDset_US, puca_CLR_USTssiIdx[k]);
                     pfta_CLR_USSi2[s_final_index>>3] |= (s_Si<<s_shift);
                     k++;
                  }
                  else if((s_Condition1 && s_Condition2 && puca_CLR_USTssiIdx[k] >= puca_CLR_USTssiIdx[j])
                     ||(!s_Condition1 && s_Condition2))
                  {
                     puca_CLR_USTssiIdx2[s_final_index] = puca_CLR_USTssiIdx[j];
                     puca_CLR_USTssi2[s_final_index] = 126;
                     s_Si = IS_TONEFLAGSET(p_CLR_SUPPORTEDset_US, puca_CLR_USTssiIdx[j]);
                     pfta_CLR_USSi2[s_final_index>>3] |= (s_Si<<s_shift);
                     j++;
                  }
                  else
                     break;

                  s_final_index++;
               }

               gsa_num_USTssi_Xmitted[l] = s_final_index;
               for (j = 0; j < s_final_index; j++)
               {
                  puca_CLR_USTssiIdx[j] = puca_CLR_USTssiIdx2[j];
                  puca_CLR_USTssi[j] = puca_CLR_USTssi2[j];
                  pfta_CLR_USSi[j>>3] = pfta_CLR_USSi2[j>>3];
               }

#ifdef LEAVE_TRAIL
               GhsLeaveTrail(DIFFERENT_TSSI_INFO, 0, 0, "CLR Resend", 0, NULL);
#endif
            }
      }
   }
   }//for (l=0; l<2; i++).
#endif //ENABLE_TSSI_COMPARE

    return (ft_retCode);
}


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: HSMsgHandler
 *
 *  Abstract: Message Exchange state machine.
 *          Decide how to respond to the received message.
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *          gpt_RxInfo             - (I) received message
 *          gpt_TxInfo             - (O) message to be transmitted in response
 *          gpt_RxInfoSave         - (O) a duplicate of the received message
 *          gs_RxState             - (I) current Rx State
 *          guc_EscFromFR_Flag     - (I)
 *          guc_EscToFR_Flag       - (O)
 *          guc_SilenceRequestFlag - (O)
 *          guc_NoCommonModeFlag   - (O)
 *
 *-------------------------------------------------------------------
 *^^^
 */
DATA_MAP_deILV2_BIS
uint8 guc_NotUnderstood;    /*  flag to indicate message not understood */
DATA_MAP_END//DATA_MAP_deILV2_BIS

void Indicate_NoTxMessage(void)
{
   /* Indicate nothing to transmit */
   gs_MsgOctetCnt = 0;
   gs_MsgOffset = 0;
   gs_TxMsgBufCnt = 0;
}


void Initiate_NAK_CD(void)
{
   gpt_TxInfo->uc_Type  = M_NAK_CD;
   gs_TxMsgBufCnt     = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
   gt_hsc.s_NextState = R_HS_NOT_UNDERSTOOD;
}

void HSMsgHandler(void)
{

   guc_NotUnderstood  = FALSE;

   /* ---- if FCS error, trensmit NAK_EF and return to the beginning ---- */
   switch (gt_hsc.s_State)
   {

      /* ---- these states do not receive any message, so no FCS error ---- */
      case R_HS_INITIAL         :
      case R_HS_MS_OK           :
      case R_HS_CL_OK           :
      case R_HS_RESTART         :
      case R_HS_NOT_READY       :
      case R_HS_NOT_SUPPORTED   :
      case R_HS_NOT_UNDERSTOOD  :
      break;

      default:
         if (gt_hsc.s_DecodeResult == FCS_ERROR)
         {
            gpt_TxInfo->uc_Type  = M_NAK_EF;
            gs_TxMsgBufCnt     = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
            //gus_ExceptionCode = E_CODE_GHS_NearEnd_EF ;
            gt_hsc.s_NextState = R_HS_RESTART;
            guc_MsgHandlerState = HS_MSG_HANDLER_DONE;
            //XDSLRTFW-3841(Start)
            // Always transition back to the Ready state if a GHs session cannot be finished properly
            STATArray[STAT_MacroState] = STAT_ReadyState;
            gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ReadyState;
            gusa_HercADSL_MONIMap_Curr[0] = MONI_READY;

            // VRX518 stuck in line state 300 in ADSL-ATM, ADSL-PTM and AUTOMODE
            // The message type of structure gpt_RxInfo needs to be cleared.
            // If it is not cleared the next GHs session will automatically stop here before decoding
            // the first CL message as we call the Ghs message handler immediately after having
            // detected the 1st CO FLAG signal (after receiving activation tones).
            // Here we check for the Rx-Message header even if have not yet received any CO GHs message
            // in the ongoing GHs session.
            gpt_RxInfo->uc_Type = 0x00;
            //XDSLRTFW-3841(End)

            return;
         }
         else if (gt_hsc.s_DecodeResult == GHS_MESSAGE_OVERFLOW)
         {
            //gus_ExceptionCode = E_CODE_GHS_RX_MSGBUF_OVERFLOW ;
            Initiate_NAK_CD() ;
            guc_MsgHandlerState = HS_MSG_HANDLER_DONE;
            return ;
         }
      break;
   }


   /*  **************************************** */
   /*  **** common responses of all states **** */
   /*  **************************************** */

   /* ==== handling NAK_EF, NAK_CD, and not-understood message ==== */
   if( gpt_RxInfo->uc_Type == M_NAK_EF)
   {
      /* ---- NAK_EF handling ( errored frame received by ATU-C ) ---- */
      Indicate_NoTxMessage() ;
      //gus_ExceptionCode = E_CODE_GHS_FarEnd_EF;
      gt_hsc.s_NextState    = R_HS_EXIT;
      gt_hsc.l_SelectedMode = RESTART_HS;
      //XDSLRTFW-3841(Start)
      // Always transition back to the Ready state if a GHs session cannot be finished properly
      STATArray[STAT_MacroState] = STAT_ReadyState;
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ReadyState;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_READY;

      // VRX518 stuck in line state 300 in ADSL-ATM, ADSL-PTM and AUTOMODE
      // The message type of structure gpt_RxInfo needs to be cleared.
      // If it is not cleared the next GHs session will automatically stop here before decoding
      // the first CL message as we call the Ghs message handler immediately after having
      // detected the 1st CO FLAG signal (after receiving activation tones).
      // Here we check for the Rx-Message header even if have not yet received any CO GHs message
      // in the ongoing GHs session.
      gpt_RxInfo->uc_Type = 0x00;
      //XDSLRTFW-3841(End)
      guc_MsgHandlerState = HS_MSG_HANDLER_DONE;
      return;
   }
   else if (gpt_RxInfo->uc_Type == M_NAK_CD)
   {
      /* ---- NAK_CD handling ( message not understoodd by ATU-C ) ---- */
      //Indicate_NoTxMessage() ;
      Do_ClearDown();
      //gus_ExceptionCode = E_CODE_GHS_FarEnd_CD;
      gt_hsc.s_NextState    = R_HS_EXIT;
      gt_hsc.l_SelectedMode = RESTART_VIA_CLEARDOWN;

      guc_MsgHandlerState = HS_MSG_HANDLER_DONE;
      return;
   }
   else if (gpt_RxInfo->uc_Type == M_REQ_RTX)
   {
      guc_RxHSReqRtx_cnt++;

      /* ---- REQ_RTX handling ( errored segment frame retransmission request received by ATU-R ) ---- */
      if ((guc_RxHSReqRtx_cnt > MAX_REQ_RTX_NUMBER) || ((guc_RxHSReqRtx_cnt <= MAX_REQ_RTX_NUMBER) &&
      // check whether the request msg is match with our record
      ((gpt_RxInfo->uc_last_received_msg_type != gpt_TxInfo->uc_Type) ||
      (gpt_RxInfo->uc_request_msg_segment_index != (guc_TxHSMsg_SegmentCnt -1)))))
      {
         // reset retransmission related variables
         gft_TxRetransmit_Msg = FALSE;
         guc_RxHSReqRtx_cnt = 0;

         // transmit NAC_CD to do clear down
         Initiate_NAK_CD() ;
         gus_ExceptionCode = E_CODE_GHS_RETX_ERROR;
      }
      else
      {
         // we will start to retransmit the last msg segment we transmitted
         gft_TxRetransmit_Msg = TRUE;
      }
      guc_MsgHandlerState = HS_MSG_HANDLER_DONE;
      return;
   }

    /*  ********************************** */
    /*  **** State specific responses **** */
    /*  ********************************** */
   if ((gt_hsc.s_State == R_HS_INITIAL) && (gt_hsc.s_CL_Exchanged == TRUE))
   {
      // check whether we should resend CLR by comparing CLR/CL

      if(!Compare_CL_CLR())
      {
         if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_RESP_MASK)==OPTN_RTRespTxMsg_MR)
         {
            gt_hsc.s_InitialMsg = START_WITH_MR;
         }
         else if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_RESP_MASK)==OPTN_RTRespTxMsg_MS)
         {
            gt_hsc.s_InitialMsg = START_WITH_MS;
         }
         else if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_RESP_MASK)==OPTN_RTRespTxMsg_MP)
         {
            gt_hsc.s_InitialMsg = START_WITH_MP;
         }
         else
         {
            //default Bis CPE always send MR when CLR/CL exchange is done
            if (gul_ModeControl & STAT_ConfigMode_ADSL2_ALL)
               gt_hsc.s_InitialMsg = START_WITH_MR;
            else
               gt_hsc.s_InitialMsg = START_WITH_MS;  //DMT default CPE send MS
         }
      }
      else
      {
         // generate a new CLR based on the new Preferred mode
         gt_hsc.s_InitialMsg = START_WITH_CLR;

         // reset exchange flag
         gt_hsc.s_CL_Exchanged = FALSE;
      }
   }

   (*MsgHandler_states[gt_hsc.s_State - R_HS_INITIAL])();

   /* ---- Check whether Message not understood ---- */
   if ( guc_NotUnderstood == TRUE )
   {
      if ( gpt_RxInfo->uc_Rev <= REVISION )
      {
         Initiate_NAK_CD();
         gus_ExceptionCode = E_CODE_GHS_NearEnd_CD ;
      }
      else
      {
         gpt_TxInfo->uc_Type  = M_NAK_NS;
         gs_TxMsgBufCnt     = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
         gt_hsc.s_NextState = R_HS_NOT_SUPPORTED;
      }
   }
   // If the HS state function formed a message that overflew the Tx buffer:
   if ((gus_ExceptionCode==E_CODE_GHS_TX_MSGBUF_OVERFLOW) && (gpt_TxInfo->uc_Type!=M_NAK_CD))
   {
      // The second check is that we don't reenter this function (and keep resending M_NAK_CD),
      // when MsgHandler is called after the completion of the first M_NAK_CD
      Initiate_NAK_CD() ;
   }

   guc_MsgHandlerState = HS_MSG_HANDLER_DONE;
}


/* ==== processing for R_HS_INITIAL ==== */
void R_HS_INITIAL_state ()
{
   switch (gt_hsc.s_InitialMsg) {

        case START_WITH_CLR:
            PrepareCLR();
            gt_hsc.s_NextState = R_HS_SEND_CLR;
            break;

        case START_WITH_MS:
            PrepareMS();
            gt_hsc.s_NextState = R_HS_SEND_MS;
            break;

        case START_WITH_MR:
            gpt_TxInfo->uc_Type  = M_MR;
            gt_hsc.s_NextState = R_HS_SEND_MR;
            break;

         /* new state from Revision 2 */
      case START_WITH_MP:
            gpt_TxInfo->uc_Type  = M_MP;
         //should provide a similar MS message for mode proposal here, we think.
         //PrepareMP();
            gt_hsc.s_NextState = R_HS_SEND_MP;
            break;

        }

        gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}


    /* ==== processing for R_HS_SEND_MS (ATU-R selects a mode of operation) ==== */
void R_HS_SEND_MS_state()
{

   switch ( gpt_RxInfo->uc_Type ) {

        case M_NAK_NR:
        case M_NAK_NS:
         Indicate_NoTxMessage() ;
            gt_hsc.s_NextState = R_HS_INITIAL;
            guc_received_ACK2_count = 0;

            break;

        case M_ACK1:
         Do_ClearDown();
         gs_MS_source = ATU_R;
            gt_hsc.l_SelectedMode = SelectMode( gpt_TxInfo );       /*  Select mode of operation based on xmitted MS message */
            guc_received_ACK2_count = 0;

            break;

        case M_ACK2:
            if(gft_WholeTxMsgComplete == FALSE) // yes, we also know we haven't sent complete msg yet
                gt_hsc.s_NextState = R_HS_SEND_MS;
            else // sorry, we believe we've already sent complete msg. Sth must by wrong in transmition, then.
                guc_NotUnderstood = TRUE;

            break;

        case M_REQ_MR:
            gpt_TxInfo->uc_Type  = M_MR;
            gs_TxMsgBufCnt     = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
            gt_hsc.s_NextState = R_HS_SEND_MR;
            guc_received_ACK2_count = 0;

            break;

        case M_REQ_CLR:
            PrepareCLR();

            gs_TxMsgBufCnt     = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );

            gt_hsc.s_NextState = R_HS_SEND_CLR;
            guc_received_ACK2_count = 0;

            break;

        default:
            guc_NotUnderstood = TRUE;
            guc_received_ACK2_count = 0;

            break;
        }
}


    /* ==== processing for R_HS_CL_OK ==== */
void R_HS_CL_OK_state()
{
   int i ;
   uint8 uc_SI_SPar1_ORed ;
   //XDSLRTFW-1445:Enhancement_US_BISPlus_CNXT_USPerf_MidrangeLoops (Start)
   int32 l_CommonMode = 0;

#ifndef ISDN   // Only for Annex-A
   HS_Encode_ADSL2_t *pt;
   Adsl2AllInfo_t *pt_BisPlusInfo;
   int16 ii;
#endif

   //XDSLRTFW-1445:Enhancement_US_BISPlus_CNXT_USPerf_MidrangeLoops (End)

   //------------------
   // ADSL_BONDING
   //------------------
   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)
   //XDSLRTFW-2893 (start)
   FlagT ft_BondingDoubleExhange = FALSE;

#ifdef ADSL_BONDING
   uint16 us_PME_BitPosition;
    InfoField_t *pt_RxCL;   // received capability list of the other party
    InfoField_t *pt_TxCL;   // transmitted capability list of CPE

    pt_RxCL = gpt_RxInfo;
    pt_TxCL = gpt_TxInfoSave;

   if ((pt_RxCL->uc_ID_SPar1[2] & BONDING) &&
      (pt_RxCL->uc_BondingNP2 & BONDING_ETHERNET) &&
      (pt_TxCL->uc_BondingNP2 & BONDING_ETHERNET))
   {

      //DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF10);

      // Clear all 4 disc and aggr set/clear status bits,
      // which means it's a 'get' commmand by default
      gt_Bonding_DiscAggr_Status.s_PAF_status &= ~(0x40 | 0x20 | 0x10 | 0x8);

      if( (pt_RxCL->uc_BondingSP2 & BONDING_PME_DISCOVERY)
           &&((gul_fe_G994VendorID != GHS_CXSY_ID) || ((gul_fe_G994VendorID == GHS_CXSY_ID) && (!(pt_RxCL->uc_BondingSP2 & BONDING_PME_AGGREGATION))))
         )
      {
         // PME discovery command
         StoreInfoField_Bonding_NPar3(pt_RxCL, BONDING_PME_DISCOVERY);

#if 0
         DebugTrail1(7,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF11,
               gt_Bonding_DiscAggr_Control.sa_DiscCode[0],
               gt_Bonding_DiscAggr_Control.sa_DiscCode[1],
               gt_Bonding_DiscAggr_Control.sa_DiscCode[2],
               gt_Bonding_DiscAggr_Status.sa_DiscCode[0],
               gt_Bonding_DiscAggr_Status.sa_DiscCode[1],
               gt_Bonding_DiscAggr_Status.sa_DiscCode[2]);
#endif

         // See whether to set or clear Discovery register:
         if (pt_RxCL->uca_BondingDisc[0] & 0x1)
         {
            // clear if same
            //DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF12);

            // Indicate Discovery Clear if Same
            gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x40;
            // Clear if Same is mutually exclusive with Set if Clear, therefore reset Set if Clear bit
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x20;

#if HANDLE_BONDING_IN_PHY
            if ( (gt_Bonding_DiscAggr_Status.sa_DiscCode[0] == gt_Bonding_Continue.sa_DiscCode[0]) &&
               (gt_Bonding_DiscAggr_Status.sa_DiscCode[1] == gt_Bonding_Continue.sa_DiscCode[1]) &&
               (gt_Bonding_DiscAggr_Status.sa_DiscCode[2] == gt_Bonding_Continue.sa_DiscCode[2]) )
            {
               gt_Bonding_Continue.sa_DiscCode[0] = 0;
               gt_Bonding_Continue.sa_DiscCode[1] = 0;
               gt_Bonding_Continue.sa_DiscCode[2] = 0;
               //DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF13);

            }
#endif
         }
         else
         {

               //DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF14);

               // Indicate Discovery Clear if Same
               gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x20;
               // Set if Clear is mutually exclusive with Clear if Same, therefore reset Clear if Same bit
               gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x40;
               //DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)gt_Bonding_DiscAggr_Status.s_PAF_status);


#if HANDLE_BONDING_IN_PHY
            // set if clear
            if ( (gt_Bonding_Continue.sa_DiscCode[0] == 0) &&
               (gt_Bonding_Continue.sa_DiscCode[1] == 0) &&
               (gt_Bonding_Continue.sa_DiscCode[2] == 0) )
            {
               gt_Bonding_Continue.sa_DiscCode[0] = gt_Bonding_DiscAggr_Status.sa_DiscCode[0];
               gt_Bonding_Continue.sa_DiscCode[1] = gt_Bonding_DiscAggr_Status.sa_DiscCode[1];
               gt_Bonding_Continue.sa_DiscCode[2] = gt_Bonding_DiscAggr_Status.sa_DiscCode[2];

               //DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF15);

            }
#endif
         }

#if HANDLE_BONDING_IN_PHY
         // Update TxInfo bonding NPar3 params:
         InitializeInfoField_Bonding_NPar3(pt_TxCL);
#endif
         ft_BondingDoubleExhange = TRUE;
         guc_ClrControl |= CLR_SEND_BONDING_PME_ID;
      }
      else if (pt_RxCL->uc_BondingSP2 & BONDING_PME_AGGREGATION)
      {
         // PME aggregation command
         if (gul_fe_G994VendorID == GHS_CXSY_ID)
         {
            // Force to indicate bonding bit to workaround CNXT CO issue in CO CL message
            pt_RxCL->uca_BondingAggr[5] |= 0x01;
            gt_Bonding_Continue.sa_PMEAggr_data[1] |= 0x0001;
         }

         StoreInfoField_Bonding_NPar3(pt_RxCL, BONDING_PME_AGGREGATION);
               //DebugTrail1(3,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF16,(int16)gt_Bonding_DiscAggr_Status.sa_PMEAggr_data[0],(int16)gt_Bonding_DiscAggr_Status.sa_PMEAggr_data[1]);


         // See whether to set or clear PME Aggr register bit:
         us_PME_BitPosition = (gt_Bonding_DiscAggr_Control.s_PCS_control >> 8) & 0x1F;
         if (pt_RxCL->uca_BondingAggr[5] & 0x1)
         {

            //DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF17);

#if HANDLE_BONDING_IN_PHY
            // Set bit
            // Also updating the bit on the control variable (cnfg cmv)
            if (us_PME_BitPosition < 16)
               gt_Bonding_Continue.sa_PMEAggr_data[1] |= (1<<us_PME_BitPosition);
            else
               gt_Bonding_Continue.sa_PMEAggr_data[0] |= (1<<(us_PME_BitPosition-16));
#endif

            // Indicate PME aggr. Set command received
            gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x8;
            // Aggr. Set and Clear are mutually exclusive, therefore reset Clear status bit
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x10;
            // Reset previous Discovery Clear if Same status.
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x40;
         }
         else
         {

            //DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF18);

#if HANDLE_BONDING_IN_PHY
            // Clear bit
            if (us_PME_BitPosition < 16)
               gt_Bonding_Continue.sa_PMEAggr_data[1] &= ~((uint16)(1<<us_PME_BitPosition));
            else
               gt_Bonding_Continue.sa_PMEAggr_data[0] &= ~((uint16)(1<<(us_PME_BitPosition-16)));
#endif
            // Indicate PME aggr. Clear (i.e. set 0) command received
            gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x10;
            // Aggr. Set and Clear are mutually exclusive, therefore reset Set status bit
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x8;
            // Reset previous Discovery Set if Clear status.
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x20;
         }

#if HANDLE_BONDING_IN_PHY
         // Update TxInfo bonding NPar3 params:
         InitializeInfoField_Bonding_NPar3(pt_TxCL);
#endif
         ft_BondingDoubleExhange = TRUE;
      }

   }
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(End)
#endif   // ifdef ADSL_BONDING

   //gpt_RxInfoSave updated in "ResponseToCL"
   for (i=2, uc_SI_SPar1_ORed=0 ; i<NUM_SI_SPAR1_OCTETS; i++)
   {     // Look at ADSL2 bits only
      uc_SI_SPar1_ORed |= gpt_RxInfoSave->uc_SI_SPar1[i] ;
   }

   if (gft_SendShortCLR == TRUE)
   {
      // Eliminate SI_Spar1 fields that the CO doesn't support (compliant short CLR):
      // Not against Broadcom (pre 4.7.05 reply with DMT-only to a short CLR) -
      // - if the Broadcom replies with any ADSL2 mode, then it is compliant (post 4.7.05 Broadcom release)
      if  ( !((gs_CurrentCoChipset==BDCM_CO_CHIPSET)&&(uc_SI_SPar1_ORed==0)) )
      {
         for (i=0 ; i<NUM_SI_SPAR1_OCTETS ; i++) {
            gpt_TxInfo->uc_SI_SPar1[i] &= (gpt_RxInfoSave->uc_SI_SPar1[i] & 0x7F) ;
         }
      }
      if  ( !((gs_CurrentCoChipset==BDCM_CO_CHIPSET)&&(gt_hsc.s_CL_Exchanged==FALSE)) )
      {
         // If we are (among else) DMT and the other side is DMT-only, make us behave us DMT-only.
         // The check will happen for Broadcom as well, as long full CLRs have been exchanged
         if ( (gul_ModeControl & (STAT_ConfigMode_G992_1_ALL|STAT_ConfigMode_G992_2_ALL)) &&
               (uc_SI_SPar1_ORed==0) )
         {
            // Force our modem to behave as DMT-only
            gul_ModeControl &= (STAT_ConfigMode_G992_1_ALL|STAT_ConfigMode_G992_2_ALL) ;
            for (i=2 ; i<NUM_SI_SPAR1_OCTETS ; i++)
            {
               gpt_TxInfo->uc_SI_SPar1[i] = 0 ;
            }
            // Check if we don't want to send the BONDING capablity
            //Important TBD //bhadra
#if 0
            if ((gt_Bonding_DiscAggr_Control.s_PCS_control & 0x1) &&
                   ((guc_ClrControl & CLR_SEND_NOT_BONDING_INFO) == 0))
            {
                //Resend CLR without Bonding capability
                guc_ClrControl |= CLR_SEND_NOT_BONDING_INFO;
                //tf_ReStartGhs = TRUE;
            }
#endif
         }
      }
#ifdef ISDN
      // In AnB BIS/PLUS mode, if Conexant CO,
      // Last three breakpoints of US Tssi is changed to supported set with no attenuation
      // By default they are not in supported set.
      if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
      {
         for (i=5; i<NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
         {
            guca_US_TssiValue_G9923B[0][i] = 0;
            gfta_US_SprtSet_G9923B[0][0] |= (1<<i);

            guca_US_TssiValue_G9925B[0][i] = 0;
            gfta_US_SprtSet_G9925B[0][0] |= (1<<i);
         }
      }
#endif
#ifndef ISDN   // Only for Annex-A
      if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
      {
         // SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (START)
         if (gft_StartDMT_CNXT == FALSE)
         {
            gft_USPerf_CNXT = 1;
            guca_ne_G9941_VendorID[2] = 0x41;   // A
            guca_ne_G9941_VendorID[3] = 0x57;   // W
            guca_ne_G9941_VendorID[4] = 0x52;   // R
            guca_ne_G9941_VendorID[5] = 0x45;   // E
            gpt_TxInfo->ul_Provider = guca_ne_G9941_VendorID[2]<<24 | guca_ne_G9941_VendorID[3]<<16 |
                        guca_ne_G9941_VendorID[4]<<8|guca_ne_G9941_VendorID[5];      // provider code (Vendor ID, 4 octets)

            //XDSLRTFW-1445:Enhancement_US_BISPlus_CNXT_USPerf_MidrangeLoops ( Start)
            pt = gta_HS_ADSL2;
            for (ii=0 ; ii<NUM_KNOWN_ADSL2_SPAR1_BITS ; ii++)
            {
               // For ADSL2 mode indicated in MS, we need to be sure that we also support it (i.e. sent them in CLR),
               // and that the CO did send information about them in CL;; otherwise, we choose l_SelectedMode = NOT_SELECTED
               if ( (gpt_TxInfo->uc_SI_SPar1[pt->SI_SPar1_idx] & pt->SI_Spar1_anx_bit)
                  && (gpt_RxInfoSave->uc_SI_SPar1[pt->SI_SPar1_idx] & pt->SI_Spar1_anx_bit) )
               {
                  l_CommonMode = pt->smode;
               }
               pt++;
            }

            if ((gs_CurrentCoVendorID == 0x0010) && ((gt_INFX_CMV.s_DFE_Options & CMV_TO_ENABLE_CNXT_SRA_FIX)))
            {
               gft_SRAIop_CNXT = 1;
            // XDSLRTFW-1445:Enhancement_US_BISPlus_CNXT_USPerf_MidrangeLoops(Start)
               if(l_CommonMode == G992_5_A)
               {
               // Send US  Tssi in 5A Mode,during R-CLR Msg.
               // Switching R-Vendor Identionfication has no impact on US Performance against Connexant E67 Vesion 0x10code at HOL[ZTE] Lab.
               // Cable bundle was used in the Lab Testing.
               // Enable US Tssi indication during  R-CLR. It helps in attaining stable rates[avoid run2run variation]
               gft_StopTssiInClr = 0;
               pt_BisPlusInfo = gpt_TxInfo->pta_G9925xInfo[0];
               pt_BisPlusInfo->t_PMD_NPar3_US.pus_BreakFreq = (uint16*)(void *)guca_US_TssiIndex_G9925A_GSI_Intracom;
               pt_BisPlusInfo->t_PMD_NPar3_US.puc_tssi = guca_US_TssiValue_G9925A_GSI_Intracom;

               guca_ne_G9941_VendorID[2] = 0x49;   // I
               guca_ne_G9941_VendorID[3] = 0x46;   // F
               guca_ne_G9941_VendorID[4] = 0x54;   // T
               guca_ne_G9941_VendorID[5] = 0x4E;   // N
               gpt_TxInfo->ul_Provider = guca_ne_G9941_VendorID[2]<<24 | guca_ne_G9941_VendorID[3]<<16 |
               guca_ne_G9941_VendorID[4]<<8|guca_ne_G9941_VendorID[5];      // provider code (Vendor ID, 4 octets)
               // XDSLRTFW-1445:Enhancement_US_BISPlus_CNXT_USPerf_MidrangeLoops(End)
               }
               else
               {
                  gft_StopTssiInClr = 1;
               }
            }
            //XDSLRTFW-1445:Enhancement_US_BISPlus_CNXT_USPerf_MidrangeLoops (End)
      }
      else
      {
         guca_ne_G9941_VendorID[2] = 0x49;   // I
         guca_ne_G9941_VendorID[3] = 0x46;   // F
         guca_ne_G9941_VendorID[4] = 0x54;   // T
         guca_ne_G9941_VendorID[5] = 0x4E;   // N
         gpt_TxInfo->ul_Provider = guca_ne_G9941_VendorID[2]<<24 | guca_ne_G9941_VendorID[3]<<16 |
                     guca_ne_G9941_VendorID[4]<<8|guca_ne_G9941_VendorID[5];      // provider code (Vendor ID, 4 octets)

         gft_SRAIop_CNXT = 0;
         gft_StopTssiInClr = 0;
      }
      // SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (END)
      //SMS01501979 SMS01368330 IOP_M_US_BisPlus_CNXT_TIVIDforBetterUSRate (START)
      //Switch to TI VID to improve US rate performance
      //if the CO is CNXT chepset and both CO and CPE support AnnexM
      if ((gpt_RxInfoSave->uc_SI_SPar1[3] & (G992_3_M >> 24) &&
         gpt_TxInfoSave->uc_SI_SPar1[3] & (G992_3_M >> 24)) ||
        (gpt_RxInfoSave->uc_SI_SPar1[4] & (G992_5_M) &&
         gpt_TxInfoSave->uc_SI_SPar1[4] & (G992_5_M)))
      {
         guca_ne_G9941_VendorID[2] = 0x54;
         guca_ne_G9941_VendorID[3] = 0x53;
         guca_ne_G9941_VendorID[4] = 0x54;
         guca_ne_G9941_VendorID[5] = 0x43;
         gpt_TxInfo->ul_Provider = guca_ne_G9941_VendorID[2]<<24 | guca_ne_G9941_VendorID[3]<<16 |
                        guca_ne_G9941_VendorID[4]<<8|guca_ne_G9941_VendorID[5];      // provider code (Vendor ID, 4 octets)
      }
      //SMS01501979 SMS01368330 IOP_M_US_BisPlus_CNXT_TIVIDforBetterUSRate (END)

   }

   //ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop(START)

   //US Tx power cutback by 4dB on all loops to workaround US linkdrop
   //due to Pulsecom COs sync symbol detection failure at 16kft loop.
   if (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_ECI_PLSE_IOP_ATT)
   {
      if ((gs_CurrentCoChipset == ECI_PLSE_CO_CHIPSET) &&
            (gft_workaround_ECI_PLSE == FALSE))
      {
         gft_workaround_ECI_PLSE = TRUE;
         gs_RxNextState = R_C_SILENT1_RX;
         gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;
         gs_TxNextState = R_SILENT0_TX;
         gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
      }
      else if ((gs_CurrentCoChipset != ECI_PLSE_CO_CHIPSET) && (gft_workaround_ECI_PLSE))
      {
         gft_workaround_ECI_PLSE = 0;
         gs_RxNextState = R_C_SILENT1_RX;
         gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;
         gs_TxNextState = R_SILENT0_TX;
         gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
      }
   }
   if ((gs_CurrentCoChipset == CTNW_CO_CHIPSET) &&
            (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_CTNW_SHORTEN_GHS))
   {
         gft_CTNW_Shorten_GHS = 1;
   }

#endif

   }


   if ((ft_BondingDoubleExhange == TRUE) || (gft_SendShortCLR == TRUE) )
   {
      //DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF19);
      if (gft_SendShortCLR == TRUE)
      {
         gft_SendShortCLR = FALSE ;
      }
      else
      {
         pt_RxCL->uc_BondingSP2 = 0; //clear Spar2 indication if set earlier
      }
      gt_hsc.s_InitialMsg = START_WITH_CLR;
      gt_hsc.s_CL_Exchanged = FALSE;
   }
   else
   {
      gt_hsc.s_CL_Exchanged = TRUE;
   }
//XDSLRTFW-2893 (end)
   // we reset Msg octet count to be 0
   Indicate_NoTxMessage() ;
   gt_hsc.s_NextState    = R_HS_INITIAL;
}

    /* ==== processing for R_HS_SEND_MR ==== */
void R_HS_SEND_MR_state()
{
    switch ( gpt_RxInfo->uc_Type ) {

        case M_MS:
            ResponseToMS();
            break;

        case M_REQ_MS:
            PrepareMS();
         gft_WholeTxMsgComplete = FALSE;
            gt_hsc.s_NextState = R_HS_SEND_MS;
            break;

        case M_REQ_CLR:
            PrepareCLR();
         gft_WholeTxMsgComplete = FALSE;
            gt_hsc.s_NextState = R_HS_SEND_CLR;
            break;

        default:
            guc_NotUnderstood = TRUE;
            break;
        }

        gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}


   /* ==== processing for R_HS_SEND_MP ==== */
// temporarily set to be the same content as SEND_MR
void R_HS_SEND_MP_state()
{
   switch ( gpt_RxInfo->uc_Type ) {

      case M_MS:
         ResponseToMS();
         break;

      case M_REQ_MS:
         PrepareMS();
         gft_WholeTxMsgComplete = FALSE;
         gt_hsc.s_NextState = R_HS_SEND_MS;
         break;

      case M_REQ_CLR:
         PrepareCLR();
         gft_WholeTxMsgComplete = FALSE;
         gt_hsc.s_NextState = R_HS_SEND_CLR;
         break;

      default:
         guc_NotUnderstood = TRUE;
         break;
   }

   gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}


    /* ==== processing for R_HS_SEND_CLR ==== */
void R_HS_SEND_CLR_state()
{
 switch ( gpt_RxInfo->uc_Type ) {

        case M_CL:
            ResponseToCL();
            guc_received_ACK2_count = 0;
         gs_TxMsgBufCnt     = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
            break;

        case M_ACK2:
            if(gft_WholeTxMsgComplete == FALSE) // yes, we also know we haven't sent complete msg yet
                gt_hsc.s_NextState = R_HS_SEND_CLR;
            else // sorry, we believe we've already sent complete msg. Sth must by wrong in transmition, then.
                guc_NotUnderstood = TRUE;

            break;

        default:
            guc_NotUnderstood = TRUE;
            break;
        }
}


    /* ==== processing for R_HS_MS_OK ==== */
void R_HS_MS_OK_state()
{
        gt_hsc.s_NextState = R_HS_EXIT;   /*  indicate eend of HS message exchange */
}

    /* ==== processing for R_HS_RESTART ==== */
void R_HS_RESTART_state()
{
        gt_hsc.s_NextState = R_HS_EXIT;  /*  indicate end of HS message exchange */
        gt_hsc.l_SelectedMode = RESTART_HS;
}

    /* ==== processing for R_HS_NOT_READY, R_HS_NOT_SUPPORTED ==== */
void R_HS_NOT_READY_state()
{
   // we reset Msg octet count to be 0
   Indicate_NoTxMessage() ;
   gt_hsc.s_NextState = R_HS_INITIAL;
}


void R_HS_NOT_SUPPORTED_state()
{
   // we reset Msg octet count to be 0
   Indicate_NoTxMessage() ;
   gt_hsc.s_NextState = R_HS_INITIAL;
}

    /* ==== processing for R_HS_NOT_UNDERSTOOD ==== */
void R_HS_NOT_UNDERSTOOD_state()
{
   // we reset Msg octet count to be 0
   Indicate_NoTxMessage() ;
   gt_hsc.s_NextState    = R_HS_EXIT; /*  cleardown */
   gt_hsc.l_SelectedMode = RESTART_VIA_CLEARDOWN;
}

    /* ==== processing for R_HS_PARTIAL_MS ==== */
void R_HS_PARTIAL_MS_state()
{
        ResponseToMS();
        gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}

    /* ==== processing for R_HS_PARTIAL_CL ==== */
void R_HS_PARTIAL_CL_state()
{
        ResponseToCL();
        gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}


// New state of Rev 3
void R_HS_RETRANSMIT_state (void)
{

}


void  Do_ClearDown()
{
   int i;

   /* ---- form message array ---- */
   for ( i = 0; i < gs_num_cleardown_flags; i++ ) { /*  xmitting FLAGs */
      gpuca_TxMsgBuf[i] = FLAG;
   }
   for ( i = 0; i < NUM_CLEARDOWN_GALF; i++ ) { /*  xmitting GALFs */
      gpuca_TxMsgBuf[i+gs_num_cleardown_flags] = GALF;
   }
   gs_MsgOctetCnt = 0;
   gs_MsgOffset = 0;
   gs_TxMsgBufCnt = gs_num_cleardown_flags + NUM_CLEARDOWN_GALF;

   gt_hsc.s_NextState    = R_HS_EXIT;   /*  indicate end of HS message exchange */

}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: ResponseToMS
 *
 *  Abstract: Decide how to respond to MS message
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *          gpt_RxInfo             - (I) received message
 *          gpt_TxInfo             - (O) message to be transmitted in response
 *          guc_EscFromFR_Flag     - (I)
 *          guc_EscToFR_Flag       - (O)
 *          guc_SilenceRequestFlag - (O)
 *          guc_CL_Exchange_Flag   - (I)
 *          guc_NoCommonModeFlag   - (O)
 *          gt_StateMachCntrl      - (O)
 *
 *  Notes: Does not receive additional Non-Standard Information, unless the current
 *          state is R_HSHS_PARTIAL_MS, i.e. Non-Standard Info already began.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void ResponseToMS(void) {

    /* ---- recieve all the segments if any                              ---- */
    /* ---- This condition may need to be changed vendor discretionarily ---- */
    if ( (gt_hsc.s_DecodeResult == INCOMPLETE_STANDARD)
      || (gt_hsc.s_DecodeResult == INCOMPLETE_NON_STANDARD) ) {
        gpt_TxInfo->uc_Type  = M_ACK2;
        gt_hsc.s_NextState = R_HS_PARTIAL_MS;
    }

    /* ---- otherwise select mode of operation and exit handshake ---- */
    else {
      /* first check whether we at least get one CL/CLR exchange */
        if ( gt_hsc.s_CL_Exchanged == FALSE ) {
            /* ---- If capabilities haven't been exchanged, indicate Not Supported Mode ---- */
               gpt_TxInfo->uc_Type  = M_NAK_NS;
               gt_hsc.s_NextState = R_HS_NOT_SUPPORTED;
      }
      else {
        /* ---- select mode of operation based on received MS message ---- */
         gs_MS_source = ATU_C;
         gt_hsc.l_SelectedMode = SelectMode( gpt_RxInfo );

        /* --------- G.Fast ------------*/
        if (gt_hsc.l_SelectedMode == G9701)
        {
           EnterFailStates(E_CODE_G_FAST_SWITCH);
        }

        /* ---- accept selected mode ---- */
         if ( gt_hsc.l_SelectedMode != NOT_SELECTED ) {
            gpt_TxInfo->uc_Type  = M_ACK1;
            gt_hsc.s_NextState = R_HS_MS_OK;
         }
         else {
            /* ---- If capabilities have been exchanged, indicate Not Supported Mode ---- */
               gpt_TxInfo->uc_Type  = M_NAK_NS;
               gt_hsc.s_NextState = R_HS_NOT_SUPPORTED;
            }
        }

    }   /*  else (select mode) */

}   /*  ResponseToMS */


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: PrepareMS_Bis
 *
 *  Abstract: Sets up Bis or BisPlus parameters for an MS message
 *
 *  Parameters:
 *
 *      pt_BisInfo - Bis or BisPlus information structure of TxInfo
 *      pt_TxBisInfo - Bis or BisPlus information structure of TxInfoSave
 *      pt_RxBisInfo - Bis or BisPlus information structure of RxInfoSave
 *
 *  Returns: None
 *
 *
 *  Global Variables Used:
 *
 *-------------------------------------------------------------------
 *^^^
 */
#ifdef PREPAREMS_BIS
void PrepareMS_Bis( Adsl2AllInfo_t *pt_BisInfo, Adsl2AllInfo_t *pt_TxCL_BisInfo, Adsl2AllInfo_t *pt_RxCL_BisInfo )
{
   int i, j, k;
   int16 *sa_MSGOvhdMinRate[4] = {&pt_RxCL_BisInfo->t_Overhead.s_DSMSGOvhdMinRate, &pt_TxCL_BisInfo->t_Overhead.s_DSMSGOvhdMinRate,
   &pt_RxCL_BisInfo->t_Overhead.s_USMSGOvhdMinRate, &pt_TxCL_BisInfo->t_Overhead.s_USMSGOvhdMinRate};

   int16 *sa_Final_MSGOvhdMinRate[2] = {&pt_BisInfo->t_Overhead.s_DSMSGOvhdMinRate, &pt_BisInfo->t_Overhead.s_USMSGOvhdMinRate};

   uint8 *puca_MaxNum_TpsTc[18] = {&pt_BisInfo->uc_DS_Max_Num_STM_TPS_TC, &pt_RxCL_BisInfo->uc_DS_Max_Num_STM_TPS_TC, &pt_TxCL_BisInfo->uc_DS_Max_Num_STM_TPS_TC,
                        &pt_BisInfo->uc_DS_Max_Num_ATM_TPS_TC, &pt_RxCL_BisInfo->uc_DS_Max_Num_ATM_TPS_TC, &pt_TxCL_BisInfo->uc_DS_Max_Num_ATM_TPS_TC,
                        &pt_BisInfo->uc_DS_Max_Num_PTM_TPS_TC, &pt_RxCL_BisInfo->uc_DS_Max_Num_PTM_TPS_TC, &pt_TxCL_BisInfo->uc_DS_Max_Num_PTM_TPS_TC,
                        &pt_BisInfo->uc_US_Max_Num_STM_TPS_TC, &pt_RxCL_BisInfo->uc_US_Max_Num_STM_TPS_TC, &pt_TxCL_BisInfo->uc_US_Max_Num_STM_TPS_TC,
                        &pt_BisInfo->uc_US_Max_Num_ATM_TPS_TC, &pt_RxCL_BisInfo->uc_US_Max_Num_ATM_TPS_TC, &pt_TxCL_BisInfo->uc_US_Max_Num_ATM_TPS_TC,
                        &pt_BisInfo->uc_US_Max_Num_PTM_TPS_TC, &pt_RxCL_BisInfo->uc_US_Max_Num_PTM_TPS_TC, &pt_TxCL_BisInfo->uc_US_Max_Num_PTM_TPS_TC};


   TPS_TC_BearerChannel_t* pta_BearerChannel[6] = {pt_BisInfo->ta_DSBearerChannel, pt_TxCL_BisInfo->ta_DSBearerChannel, pt_RxCL_BisInfo->ta_DSBearerChannel,
   pt_BisInfo->ta_USBearerChannel, pt_TxCL_BisInfo->ta_USBearerChannel, pt_RxCL_BisInfo->ta_USBearerChannel};

   /* PMD spar2 bits are set to 0 for an MS message */
   for(i=0; i<NUM_SI_SPAR2_OCTETS; i++)
      pt_BisInfo->uc_SI_SPar2[i] = 0;

   //NTR, Short Init
   for (i = 0; i < 1; i++)
   {
      if ((pt_RxCL_BisInfo->uc_SI_NPar2 & (0x1<<i)) && (pt_TxCL_BisInfo->uc_SI_NPar2 & (0x1<<i)))
      {
         pt_BisInfo->uc_SI_NPar2 |= (0x1<<i);
      }
      else
      {
         pt_BisInfo->uc_SI_NPar2 &= ~(0x1<<i);
      }
   }

   // Diagnostics mode: either one (CO or CPE) set diagnostics mode, MS then should select diag mode.
   if ((pt_RxCL_BisInfo->uc_SI_NPar2 & DIAGNOSTICS_MODE) || (pt_TxCL_BisInfo->uc_SI_NPar2 & DIAGNOSTICS_MODE))
   {
      pt_BisInfo->uc_SI_NPar2 |= DIAGNOSTICS_MODE;
   }
   else
   {
      pt_BisInfo->uc_SI_NPar2 &= ~(DIAGNOSTICS_MODE);
   }

#ifdef ISDN
   /* Indicate support for upstream tones 1 to 32 iff both CO and CPE support this feature (Annex B specific). */
   if ((pt_RxCL_BisInfo->uc_SI_NPar2 & UPSTREAM_1_32_BIS) && (pt_TxCL_BisInfo->uc_SI_NPar2 & UPSTREAM_1_32_BIS))
   {
      gpt_TxInfo->uc_SI_1B_NPar2 |= UPSTREAM_1_32_BIS;
   }
   else
   {
      gpt_TxInfo->uc_SI_1B_NPar2 &= ~UPSTREAM_1_32_BIS;
   }
#endif

   /* G992.3 AnnexL PSD Mask indication */
   if ( (( pt_RxCL_BisInfo->uc_SI_SPar2[0] & PSD_MASK ) && ( pt_TxCL_BisInfo->uc_SI_SPar2[0] & PSD_MASK )) != 0 )
   {
      pt_BisInfo->uca_PSD_Mask[0] = pt_RxCL_BisInfo->uca_PSD_Mask[0];
      pt_BisInfo->uca_PSD_Mask[1] = pt_RxCL_BisInfo->uca_PSD_Mask[1];

      if ((pt_BisInfo->uca_PSD_Mask[0]) && (pt_BisInfo->uca_PSD_Mask[1]))
         pt_BisInfo->uc_SI_SPar2[0] |= PSD_MASK;
   }
   else
   {
      pt_BisInfo->uca_PSD_Mask[0] = 0;
      pt_BisInfo->uca_PSD_Mask[1] = 0;
   }

   /* PMS-TC parameters */
   // overhead data rate
   for (i = 0; i < 2; i++)
   {
      if (( pt_RxCL_BisInfo->uc_SI_SPar2[1] & (0x1<<i) ) && ( pt_TxCL_BisInfo->uc_SI_SPar2[1] & (0x1<<i) ))
      {
         *(sa_Final_MSGOvhdMinRate[i]) = MAX((*(sa_MSGOvhdMinRate[2*i])), (*(sa_MSGOvhdMinRate[2*i+1])) );
         pt_BisInfo->uc_SI_SPar2[1] |= (0x1<<i);
      }
      else
      {
         *(sa_Final_MSGOvhdMinRate[i]) = 0;
      }
   }

   // Max. No. of TPS-TC funcs of each type
   for (i = 0; i < 2; i++)
   {
      if (( pt_RxCL_BisInfo->uc_SI_SPar2[1] & (0x4<<i) ) && ( pt_TxCL_BisInfo->uc_SI_SPar2[1] & (0x4<<i)))
      {
         *(puca_MaxNum_TpsTc[i*9]) = MIN(*(puca_MaxNum_TpsTc[i*9+1]), *(puca_MaxNum_TpsTc[i*9+2]));
         *(puca_MaxNum_TpsTc[i*9+3]) = MIN(*(puca_MaxNum_TpsTc[i*9+4]), *(puca_MaxNum_TpsTc[i*9+5]));
         *(puca_MaxNum_TpsTc[i*9+6]) = MIN(*(puca_MaxNum_TpsTc[i*9+7]), *(puca_MaxNum_TpsTc[i*9+8]));

         // According to the standard, we shouldn't include MAXTYPE of TPS-TC info in the message info
         //pt_BisInfo->uc_SI_SPar2[1] |= MAX_NUM_DS_TPSTC_FUNC_OF_EACH_TYPE;
      }
      else
      {
         *(puca_MaxNum_TpsTc[i*9]) = 0;
         *(puca_MaxNum_TpsTc[i*9+3]) = 0;
         *(puca_MaxNum_TpsTc[i*9+6]) = 0;
         // According to the standard, we shouldn't include MAXTYPE of TPS-TC info in the message info
         //pt_BisInfo->uc_SI_SPar2[1] &= ~MAX_NUM_DS_TPSTC_FUNC_OF_EACH_TYPE;
      }
   }


   /* TPS-TC parameters */
   for (k = 0; k < 2; k++)
   {
      for (j = 0; j < 3; j++)
      {
         for(i=0; i< *(puca_MaxNum_TpsTc[3*j+k*9]); i++)
         {
            if ((pt_TxCL_BisInfo->uc_SI_SPar2[2*(i+1)] & ((0x1+k)<<(2*j))) && (pt_RxCL_BisInfo->uc_SI_SPar2[2*(i+1)] & ((0x1+k)<<(2*j))))
            {
               pt_BisInfo->uc_SI_SPar2[2*(i+1)] |= ((0x1+k)<<(2*j));
               FormTpsTcSpar2ForMSMessage(&((*(pta_BearerChannel[k*3])).ta_TpsTcType[j]), &((*(pta_BearerChannel[k*3+1])).ta_TpsTcType[j]), &((*(pta_BearerChannel[k*3+2])).ta_TpsTcType[j]), (uint16)j);
            }
         }
      }
   }

}
#endif //ifdef PREPAREMS_BIS

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: PrepareMS
 *
 *  Abstract: Sets up parameters for an MS message
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *-------------------------------------------------------------------
 *^^^
 */
/* ---- macro to indicate no common mode ---- */
void IndicateNoCommonMode() {
    gpt_TxInfo->uc_ID_NPar1 &= ~NON_STANDARD;
    gpt_TxInfo->uc_SI_NPar1  = 0;
   memset (gpt_TxInfo->uc_SI_SPar1, 0, NUM_SI_SPAR1_OCTETS);
}

void PrepareMS(void) {

    InfoField_t *pt_RxCL;   /*  received capability list of the other party */
    InfoField_t *pt_TxCL;   /*  transmitted capability list of cpe */
   uint16 usSpar1_01;

   uint8 uca_BearerChannel_Supported[2] = {NUM_DS_BEARER_CHANNELS_SUPPORTED, NUM_US_BEARER_CHANNELS_SUPPORTED};

    pt_RxCL = gpt_RxInfoSave;   /*  use saved CL of the other party */
    pt_TxCL = gpt_TxInfoSave;   /*  use saved CL of cpe */

    gpt_TxInfo->uc_Type = M_MS;
    gpt_TxInfo->uc_ID_NPar1 = 0;  /*  no parameters in this field */

    gpt_TxInfo->uc_SI_NPar1 = 0;  /* Silence period for MS should be set to 0 */

    /* ---- net data rate and data flow characteristic   ---- */
    /*  do not include splitter information in MS message */
   /*   gpt_TxInfo->uc_ID_SPar1[0] = NDR_UP | NDR_DN | DFC_UP | DFC_DN; */
   // reset Identification field SPar1 octets
   memset(gpt_TxInfo->uc_ID_SPar1, 0, NUM_ID_SPAR1_OCTETS);

   // reset Standard Info SPar1 octets
   memset(gpt_TxInfo->uc_SI_SPar1, 0, NUM_SI_SPAR1_OCTETS);

    /* ---- select common mode if CLR and CL have been exchanged ---  */
    if ( gt_hsc.s_CL_Exchanged == TRUE ) {
        /* if CPE's CL and CO's CL has a non-zero ID_SPar1 octet, then use CO's ID_SPar1 in the
         MS message as this data is of informative purposes only and does not affect CPE's performance.
         This way we will not limit our CPE talking to only a few CO's.  (It is commented out here
      since this will cause overwriting pt_RxCL.   */
   /* if ( (pt_RxCL->uc_ID_SPar1[0] == 0) || (pt_TxCL->uc_ID_SPar1[0] == 0) )
            gpt_TxInfo->uc_ID_SPar1[0] = 0;
      else
            gpt_TxInfo->uc_ID_SPar1[0] = pt_RxCL->uc_ID_SPar1[0];
     */


      /* ---- then try if G.992.1 Annexs capable ---- */
#ifndef ISDN
      /* ============================================*/
      /* Prepare MS G992_1 Annex A */
      /* ============================================*/
      if ( ((pt_RxCL->uc_SI_SPar1[0] & G992_1_A) && (pt_TxCL->uc_SI_SPar1[0] & G992_1_A)) == 1 ) {

            gpt_TxInfo->uc_SI_SPar1[0] = G992_1_A;

            if ( ((pt_RxCL->uc_SI_1A_NPar2 & R_ACK1) && ( pt_RxCL->uc_SI_1A_NPar2 & R_ACK2) && (pt_TxCL->uc_SI_1A_NPar2 & R_ACK1) && (pt_TxCL->uc_SI_1A_NPar2 & R_ACK2) ) != 0 ) {
                /*  if both Atu-R and Atu_C can support both R_ACK1 and R_ACK2, select cpe's prefered mode  */
            if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_PilotOnDecTraining_DMT)
               gpt_TxInfo->uc_SI_1A_NPar2 = R_ACK2;
            else
               gpt_TxInfo->uc_SI_1A_NPar2 = R_ACK1;
            }
            else if ( (( pt_RxCL->uc_SI_1A_NPar2 & R_ACK1 ) && ( pt_TxCL->uc_SI_1A_NPar2 & R_ACK1 )) != 0 )
                gpt_TxInfo->uc_SI_1A_NPar2 = R_ACK1;
            else if ( (( pt_RxCL->uc_SI_1A_NPar2 & R_ACK2 ) && ( pt_TxCL->uc_SI_1A_NPar2 & R_ACK2 )) != 0 )
                gpt_TxInfo->uc_SI_1A_NPar2 = R_ACK2;
            else
                IndicateNoCommonMode();

            if ( ((pt_RxCL->uc_SI_1A_NPar2 & ATM) && (pt_RxCL->uc_SI_1A_NPar2 & STM) && (pt_TxCL->uc_SI_1A_NPar2 & ATM) && (pt_TxCL->uc_SI_1A_NPar2 & STM) ) != 0 ) {

                /*  if both Atu-R and Atu_C can support both ATM and STM, select the one that  */
                /*  higher layer dictates */

            if ( (OPTNArray[OPTN_DMTLinkControl] & OPTN_ATM_TransferMode) != 0)
               gpt_TxInfo->uc_SI_1A_NPar2    |=  ATM;
            else if( (OPTNArray[OPTN_DMTLinkControl] & OPTN_STM_TransferMode) != 0)
               gpt_TxInfo->uc_SI_1A_NPar2    |=  STM;
            else
               gpt_TxInfo->uc_SI_1A_NPar2    |=  ATM;

            }
            else if ( (( pt_RxCL->uc_SI_1A_NPar2 & ATM ) && ( pt_TxCL->uc_SI_1A_NPar2 & ATM )) != 0 )
                gpt_TxInfo->uc_SI_1A_NPar2 |= ATM;
            else if ( (( pt_RxCL->uc_SI_1A_NPar2 & STM ) && ( pt_TxCL->uc_SI_1A_NPar2 & STM )) != 0 )
                gpt_TxInfo->uc_SI_1A_NPar2 |= STM;
            else
                IndicateNoCommonMode();

            if ( (( pt_RxCL->uc_SI_1A_NPar2 & CLEAR_EOC_G997_1 ) && ( pt_TxCL->uc_SI_1A_NPar2 & CLEAR_EOC_G997_1 )) == 1 )
                gpt_TxInfo->uc_SI_1A_NPar2 |= CLEAR_EOC_G997_1;

            else
                gpt_TxInfo->uc_SI_1A_NPar2 &= ~CLEAR_EOC_G997_1;

            gpt_TxInfo->uc_SI_1A_SPar2 = 0;  /*  no need for spectrum information for an MS message */
        }
#else
      /* ============================================*/
      /* Prepare MS G992_1 Annex B */
      /* ============================================*/
      if ( ((pt_RxCL->uc_SI_SPar1[0] & G992_1_B) && (pt_TxCL->uc_SI_SPar1[0] & G992_1_B)) == 1 ) {

         gpt_TxInfo->uc_SI_SPar1[0] = G992_1_B;

            if ( ((pt_RxCL->uc_SI_1B_NPar2 & R_ACK1) && ( pt_RxCL->uc_SI_1B_NPar2 & R_ACK2) && (pt_TxCL->uc_SI_1B_NPar2 & R_ACK1) && (pt_TxCL->uc_SI_1B_NPar2 & R_ACK2) ) != 0 ) {
                /*  if both Atu-R and Atu_C can support both R_ACK1 and R_ACK2, select cpe's prefered mode */
            if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_PilotOnDecTraining_DMT)
               gpt_TxInfo->uc_SI_1B_NPar2 = R_ACK2;
            else
               gpt_TxInfo->uc_SI_1B_NPar2 = R_ACK1;
            }
            else if ( (( pt_RxCL->uc_SI_1B_NPar2 & R_ACK1 ) && ( pt_TxCL->uc_SI_1B_NPar2 & R_ACK1 )) != 0 )
                gpt_TxInfo->uc_SI_1B_NPar2 = R_ACK1;
            else if ( (( pt_RxCL->uc_SI_1B_NPar2 & R_ACK2 ) && ( pt_TxCL->uc_SI_1B_NPar2 & R_ACK2 )) != 0 )
                gpt_TxInfo->uc_SI_1B_NPar2 = R_ACK2;
            else
                IndicateNoCommonMode();

         /* Indicate support for upstream tones 1 to 32 iff both CO and CPE support this feature. */
         if ((pt_RxCL->uc_SI_1B_NPar2 & UPSTREAM_1_32_DMT) && (pt_TxCL->uc_SI_1B_NPar2 & UPSTREAM_1_32_DMT))
         {
            gpt_TxInfo->uc_SI_1B_NPar2 |= UPSTREAM_1_32_DMT;
         }
         else
         {
            gpt_TxInfo->uc_SI_1B_NPar2 &= ~UPSTREAM_1_32_DMT;
         }

            if ( ((pt_RxCL->uc_SI_1B_NPar2 & ATM) && (pt_RxCL->uc_SI_1B_NPar2 & STM) && (pt_TxCL->uc_SI_1B_NPar2 & ATM) && (pt_TxCL->uc_SI_1B_NPar2 & STM) ) != 0 ) {

                /*  if both Atu-R and Atu_C can support both ATM and STM, select the one that  */
                /*  higher layer dictates */

            if ( (OPTNArray[OPTN_DMTLinkControl] & OPTN_ATM_TransferMode) != 0)
               gpt_TxInfo->uc_SI_1B_NPar2    |=  ATM;
            else if( (OPTNArray[OPTN_DMTLinkControl] & OPTN_STM_TransferMode) != 0)
               gpt_TxInfo->uc_SI_1B_NPar2    |=  STM;
            else
               gpt_TxInfo->uc_SI_1B_NPar2    |=  ATM;

            }
            else if ( (( pt_RxCL->uc_SI_1B_NPar2 & ATM ) && ( pt_TxCL->uc_SI_1B_NPar2 & ATM )) != 0 )
                gpt_TxInfo->uc_SI_1B_NPar2 |= ATM;
            else if ( (( pt_RxCL->uc_SI_1B_NPar2 & STM ) && ( pt_TxCL->uc_SI_1B_NPar2 & STM )) != 0 )
                gpt_TxInfo->uc_SI_1B_NPar2 |= STM;
            else
                IndicateNoCommonMode();

            if ( (( pt_RxCL->uc_SI_1B_NPar2 & CLEAR_EOC_G997_1 ) && ( pt_TxCL->uc_SI_1B_NPar2 & CLEAR_EOC_G997_1 )) == 1 )
                gpt_TxInfo->uc_SI_1B_NPar2 |= CLEAR_EOC_G997_1;

            else
                gpt_TxInfo->uc_SI_1B_NPar2 &= ~CLEAR_EOC_G997_1;

            gpt_TxInfo->uc_SI_1B_SPar2 = 0;  /*  no need for spectrum information for an MS message */
        }
#endif//ISDN
        /* ---- then, try if G.992.2 Annex A/B is capable ---- */
      else if ( ((pt_RxCL->uc_SI_SPar1[0] & G992_2_AB) && (pt_TxCL->uc_SI_SPar1[0] & G992_2_AB)) == 1 ) {

            gpt_TxInfo->uc_SI_SPar1[0] = G992_2_AB;

            if ( ((pt_RxCL->uc_SI_2AB_NPar2 & R_ACK1) && (pt_RxCL->uc_SI_2AB_NPar2 & R_ACK2) && (pt_TxCL->uc_SI_2AB_NPar2 & R_ACK1) && (pt_TxCL->uc_SI_2AB_NPar2 & R_ACK2)) != 0 ) {
                /*  if both Atu-R and Atu_C can support both R_ACK1 and R_ACK2, select cpe's prefered mode */
            if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_PilotOnDecTraining_DMT)
               gpt_TxInfo->uc_SI_2AB_NPar2 = R_ACK2;
            else
               gpt_TxInfo->uc_SI_2AB_NPar2 = R_ACK1;
            }
            else if ( (( pt_RxCL->uc_SI_2AB_NPar2 & R_ACK1 ) && ( pt_TxCL->uc_SI_2AB_NPar2 & R_ACK1 )) != 0 )
                gpt_TxInfo->uc_SI_2AB_NPar2 = R_ACK1;

            else if ( (( pt_RxCL->uc_SI_2AB_NPar2 & R_ACK2 ) && ( pt_TxCL->uc_SI_2AB_NPar2 & R_ACK2 )) != 0 )
                gpt_TxInfo->uc_SI_2AB_NPar2 = R_ACK2;

            else
                IndicateNoCommonMode();

            if ( (( pt_RxCL->uc_SI_2AB_NPar2 & RS16 ) && ( pt_TxCL->uc_SI_2AB_NPar2 & RS16 )) != 0 )
                gpt_TxInfo->uc_SI_2AB_NPar2 |= RS16;
            else
                gpt_TxInfo->uc_SI_2AB_NPar2 &= ~RS16;

#ifdef INCLUDE_FASTRETRAIN_CODE
         if ( (( pt_RxCL->uc_SI_2AB_NPar2 & FAST_RETRAIN ) && ( pt_TxCL->uc_SI_2AB_NPar2 & FAST_RETRAIN )) != 0 )
         {
            if ( gft_EscFromFR_Flag == FALSE )
               gpt_TxInfo->uc_SI_2AB_NPar2 |= FAST_RETRAIN;
            else
               gpt_TxInfo->uc_SI_2AB_NPar2 &= ~FAST_RETRAIN;
         }
#else
            gpt_TxInfo->uc_SI_2AB_NPar2 &= ~FAST_RETRAIN;
#endif

            if ( (( pt_RxCL->uc_SI_2AB_NPar2 & CLEAR_EOC_G997_1 ) && ( pt_TxCL->uc_SI_2AB_NPar2 & CLEAR_EOC_G997_1 )) != 0 )
                gpt_TxInfo->uc_SI_2AB_NPar2 |= CLEAR_EOC_G997_1;
            else
                gpt_TxInfo->uc_SI_2AB_NPar2 &= ~CLEAR_EOC_G997_1;

            gpt_TxInfo->uc_SI_2AB_SPar2 = 0;  /*  no need for spectrum information for an MS message */
        }


#ifdef PREPAREMS_BIS

      /* ---- try if G.992.5 Annexs capable ---- */
#ifndef ISDN
      /* ============================================*/
      /* Prepare MS G992_5 Annex A */
      /* ============================================*/
      else if ( ((pt_RxCL->uc_SI_SPar1[3] & (G992_5_A >> 24)) && (pt_TxCL->uc_SI_SPar1[3] & (G992_5_A >> 24))) == 1 ) {

            gpt_TxInfo->uc_SI_SPar1[3] = (G992_5_A >> 24);

         PrepareMS_Bis(gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A], gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_A], gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_A]);

        }
      /* ============================================*/
      /* Prepare MS G992_5 Annex I */
      /* ============================================*/
      else if ( ((pt_RxCL->uc_SI_SPar1[3] & (G992_5_I >> 24)) && (pt_TxCL->uc_SI_SPar1[3] & (G992_5_I >> 24))) == 1 ) {

            gpt_TxInfo->uc_SI_SPar1[3] = (G992_5_I >> 24);

         PrepareMS_Bis(gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_I], gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_I], gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_I]);

        }
#else
      /* ============================================*/
      /* Prepare MS G992_5 Annex B */
      /* ============================================*/

      else if ( ((pt_RxCL->uc_SI_SPar1[3] & (G992_5_B >> 24)) && (pt_TxCL->uc_SI_SPar1[3] & (G992_5_B >> 24))) == 1 ) {

            gpt_TxInfo->uc_SI_SPar1[3] = (G992_5_B >> 24);

         PrepareMS_Bis(gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B], gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_B], gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_B]);

        }

      /* ============================================*/
      /* Prepare MS G992_5 Annex J */
      /* ============================================*/
      else if ( ((pt_RxCL->uc_SI_SPar1[3] & (G992_5_J >> 24)) && (pt_TxCL->uc_SI_SPar1[3] & (G992_5_J >> 24))) == 1 ) {

            gpt_TxInfo->uc_SI_SPar1[3] = (G992_5_J >> 24);

         PrepareMS_Bis(gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_J], gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_J], gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_J]);

        }

#endif//ISDN
      /* ============================================*/
      /* Prepare MS G992_5 Annex M */
      /* ============================================*/
      else if ( ((pt_RxCL->uc_SI_SPar1[4] & (G992_5_M)) && (pt_TxCL->uc_SI_SPar1[4] & (G992_5_M))) == 1 ) {

            gpt_TxInfo->uc_SI_SPar1[4] = (G992_5_M);

         PrepareMS_Bis(gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_M], gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_M], gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_M]);

        }

      /* ---- try if G.992.3 Annexs capable ---- */
#ifndef ISDN
      /* ============================================*/
      /* Prepare MS G992_3 Annex A/L */
      /* ============================================*/
      else if ( ((pt_RxCL->uc_SI_SPar1[2] & (G992_3_A >> 16)) && (pt_TxCL->uc_SI_SPar1[2] & (G992_3_A >> 16))) == 1 ) {

         gpt_TxInfo->uc_SI_SPar1[2] = (G992_3_A >> 16);

         PrepareMS_Bis(gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A], gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_A], gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_A]);

      }
      /* ============================================*/
      /* Prepare MS G992_3 Annex I */
      /* ============================================*/
      else if ( ((pt_RxCL->uc_SI_SPar1[2] & (G992_3_I >> 16)) && (pt_TxCL->uc_SI_SPar1[2] & (G992_3_I >> 16))) == 1 ) {

         gpt_TxInfo->uc_SI_SPar1[2] = (G992_3_I >> 16);

         PrepareMS_Bis(gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_I], gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_I], gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_I]);

      }
#else// ISDN
      /* ============================================*/
      /* Prepare MS G992_3 Annex B */
      /* ============================================*/
      else if ( ((pt_RxCL->uc_SI_SPar1[2] & (G992_3_B >> 16)) && (pt_TxCL->uc_SI_SPar1[2] & (G992_3_B >> 16))) == 1 ) {

         gpt_TxInfo->uc_SI_SPar1[2] = (G992_3_B >> 16);

         PrepareMS_Bis(gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B], gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_B], gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_B]);

      }
      else if ( ((pt_RxCL->uc_SI_SPar1[2] & (G992_3_J >> 16)) && (pt_TxCL->uc_SI_SPar1[2] & (G992_3_J >> 16))) == 1 ) {

         gpt_TxInfo->uc_SI_SPar1[2] = (G992_3_J >> 16);

         PrepareMS_Bis(gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_J], gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_J], gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_J]);

      }

#endif//ISDN
      /* ============================================*/
      /* Prepare MS G992_3 Annex M */
      /* ============================================*/
      else if ( ((pt_RxCL->uc_SI_SPar1[3] & (G992_3_M >> 24)) && (pt_TxCL->uc_SI_SPar1[3] & (G992_3_M >> 24))) == 1 ) {

            gpt_TxInfo->uc_SI_SPar1[3] = (G992_3_M >> 24);

         PrepareMS_Bis(gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_M], gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_M], gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_M]);
      }
#endif   //#ifdef PREPAREMS_BIS
       /* ---- only supports G.992.1 Annex A and G.992.2 Annex A/B ---- */
        else
            IndicateNoCommonMode();

    }   /*  CL exchanged */

    /* ---- select best mode if CLR and CL are not exchanged yet ---- */
    else
   {
#ifndef ISDN
      if ( (gul_ModeControl & OPTN_ConfigMode_G992_1_A) != 0)
         gpt_TxInfo->uc_SI_SPar1[0] |= G992_1_A;
#else
      if ( (gul_ModeControl & OPTN_ConfigMode_G992_1_B) != 0)
         gpt_TxInfo->uc_SI_SPar1[0] |= G992_1_B;
#endif
      if ( (gul_ModeControl & OPTN_ConfigMode_G992_2_AB) != 0)
         gpt_TxInfo->uc_SI_SPar1[0] |= G992_2_AB;


      usSpar1_01 = (uint16) gpt_TxInfo->uc_SI_SPar1[0] & (uint16) (G992_1_A | G992_1_B | G992_1_C);

      if (usSpar1_01)   /* if G992_1 */
      {
#ifndef ISDN
         if(gpt_TxInfo->uc_SI_SPar1[0] & G992_1_A)
         {
            gpt_TxInfo->uc_SI_1A_NPar2 = CLEAR_EOC_G997_1;

            if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_PilotOnDecTraining_DMT)
               gpt_TxInfo->uc_SI_1A_NPar2    |=  R_ACK2;
            else
               gpt_TxInfo->uc_SI_1A_NPar2    |=  R_ACK1;

            if ( (OPTNArray[OPTN_DMTLinkControl] & OPTN_ATM_TransferMode) != 0)
               gpt_TxInfo->uc_SI_1A_NPar2    |=  ATM;
            else if( (OPTNArray[OPTN_DMTLinkControl] & OPTN_STM_TransferMode) != 0)
               gpt_TxInfo->uc_SI_1A_NPar2    |=  STM;

            /* no need for spectrum information for an MS message */
            gpt_TxInfo->uc_SI_1A_SPar2 = 0;
         }
#else
         if(gpt_TxInfo->uc_SI_SPar1[0] & G992_1_B)
         {
            gpt_TxInfo->uc_SI_1B_NPar2 = CLEAR_EOC_G997_1;

            if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_PilotOnDecTraining_DMT)
               gpt_TxInfo->uc_SI_1B_NPar2    |=  R_ACK2;
            else
               gpt_TxInfo->uc_SI_1B_NPar2    |=  R_ACK1;

            if ( (OPTNArray[OPTN_DMTLinkControl] & OPTN_ATM_TransferMode) != 0)
               gpt_TxInfo->uc_SI_1B_NPar2    |=  ATM;
            else if( (OPTNArray[OPTN_DMTLinkControl] & OPTN_STM_TransferMode) != 0)
               gpt_TxInfo->uc_SI_1B_NPar2    |=  STM;
            else
               gpt_TxInfo->uc_SI_1B_NPar2    |=  ATM;

                /* no need for spectrum information for an MS message */
            gpt_TxInfo->uc_SI_1B_SPar2 = 0;
         }
#endif//ISDN

      } // if (usSpar1_01) /* if G992_1 */
      else
      {
         if(gpt_TxInfo->uc_SI_SPar1[0] & G992_2_AB)
         {
            gpt_TxInfo->uc_SI_2AB_NPar2 = CLEAR_EOC_G997_1;

            if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_PilotOnDecTraining_DMT)
               gpt_TxInfo->uc_SI_2AB_NPar2    |=  R_ACK2;
            else
               gpt_TxInfo->uc_SI_2AB_NPar2    |=  R_ACK1;

            if ( (OPTNArray[OPTN_DMTLinkControl] & OPTN_RS16Support_Disable) == 0)
               gpt_TxInfo->uc_SI_2AB_NPar2    |=  RS16;
            else
               gpt_TxInfo->uc_SI_2AB_NPar2    &=  ~RS16;

#ifdef INCLUDE_FASTRETRAIN_CODE
            if (gft_EscFromFR_Flag == FALSE)
               gpt_TxInfo->uc_SI_2AB_NPar2 |= FAST_RETRAIN;
            else
               gpt_TxInfo->uc_SI_2AB_NPar2 &= ~FAST_RETRAIN;
#else
                gpt_TxInfo->uc_SI_2AB_NPar2 &= ~FAST_RETRAIN;
#endif
            /* no need for spectrum information for an MS message */
            gpt_TxInfo->uc_SI_2AB_SPar2 = 0;
         }

      } // else
   }
   //XDSLRTFW-1658 SMS01261908 SMS001231692 IOP_US_ADSL1_A_CIENA_LINKDROP (START)
   #ifndef ISDN
   if (gs_CurrentCoChipset == CTNW_CO_CHIPSET)
   {
      gpt_TxInfo->uc_SI_1A_NPar2 &= ~CLEAR_EOC_G997_1;
      gpt_TxInfo->uc_SI_2AB_NPar2 &= ~CLEAR_EOC_G997_1;
   }
   #endif
   //XDSLRTFW-1658 SMS01261908 SMS001231692 IOP_US_ADSL1_A_CIENA_LINKDROP (END)
}   /*  PrepareMS */

#undef IndicateNoCommonMode

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: ResponseToCL
 *
 *  Abstract: Decide how to respond to a CL message
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *  Notes: Always receive additional Non-Standard Information for a CL message
 *
 *-------------------------------------------------------------------
 *^^^
 */
void ResponseToCL(void) {

    /* ---- recieve all the segments if any                              ---- */
    /* ---- This condition may need to be changed vendor discretionarily ---- */
    if ( (gt_hsc.s_DecodeResult == INCOMPLETE_STANDARD)
      || (gt_hsc.s_DecodeResult == INCOMPLETE_NON_STANDARD) )
    {
        gpt_TxInfo->uc_Type  = M_ACK2;
        gt_hsc.s_NextState = R_HS_PARTIAL_CL;
    }
    else
   {
       if (gpt_RxInfo->uc_SI_SPar1[4] == G9701)
       {
          EnterFailStates(E_CODE_G_FAST_SWITCH);
          return;
       }

      else
      {

        CopyInfoField( gpt_RxInfo, gpt_RxInfoSave, TRUE );    /*  save for later use or monitoring */
         if (gft_FirstCL)
         {
            gft_FirstCL = FALSE;
            memcpy(guca_FE_ModeCapabilities, gpt_RxInfo->uc_SI_SPar1, NUM_SI_SPAR1_OCTETS);
         }
#ifdef LEAVE_TRAIL
         CopyInfoField (gpt_RxInfoSave, &gt_TrailRxInfoSave, FALSE); /* save CL for debug usage */
#endif

         uint16 us_platform = (gpt_RxInfoSave->us_VendorInfo >> 12) & 0x000F;


         // Populate CO vendor variable, for use later in training/showtime
         switch (gpt_RxInfoSave->ul_Provider)
         {

         case GHS_ADI_ID:
            // Check 1st Vendor-specific octet of NS block: contains Ver. number of chip code
            if (gpt_RxInfo->ta_NS_Info[0].puca_NSVendorSpec[0] >= 0x40) {  //CO with 4.0 and above: Anaconda
               gs_CurrentCoChipset = ANCDA_CO_CHIPSET;
            }
            else {
               gs_CurrentCoChipset = ADI_CO_CHIPSET;
            }
            break;
         case GHS_ALA_ID:
            gs_CurrentCoChipset = ALA_CO_CHIPSET;
            break;
         case GHS_AWRE_ID:
         case GHS_OPTI_ID:
            gs_CurrentCoChipset = AWRE_CO_CHIPSET;
            break;
         case GHS_BDCM_ID:
            gs_CurrentCoChipset = BDCM_CO_CHIPSET;
            gs_num_cleardown_flags = gs_num_cleardown_flags_short ;
            break;
         case GHS_CTLM_ID:
            gs_CurrentCoChipset = CTLM_CO_CHIPSET;
            gs_num_cleardown_flags = gs_num_cleardown_flags_short ;
            break;
         case GHS_GSI_ID:
            gs_CurrentCoChipset = GSI_CO_CHIPSET;
            break;
         case GHS_IFTN_ID:
            gs_CurrentCoChipset = IFTN_CO_CHIPSET;
            if (!gft_AnxL_PSD_selected)
            {
               Modify_USSpectralShape(); // This uses a spectral shape that is better for older geminaxCO's
            }           // (function located at bottom of file).
 #ifdef ISDN
            if(us_platform < VINAX_REV_2_M_PLATFORM)
            {
               gs_hsk_power_dB_VendorComp = (int16)0x466;//0xFB9A; // 4.4dB more observed compensated for the same
               //gs_hsk_tone_power_dB += gs_hsk_power_dB_VendorComp;
            }
 #endif

            break;
         case GHS_TI_ID:
         case GHS_TI4000C:
            gs_CurrentCoChipset = TI_CO_CHIPSET;
            break;
         case GHS_CTNW_ID:
            gs_CurrentCoChipset = CTNW_CO_CHIPSET;
            break;

#ifndef ISDN   // Only for Anx-A
           // in DMT-, BIS-, and PLUS-mode a 0x00 vendor-ID indicates:
           // - if a the G.Hs NSIF shows GHS_ALA_ID: ALA2-DSLAM
           // - else: CTLM DSLAM
           // => for both cases we set here CTLM vendor ID and change it to
           // ALA2 after decoding of the NSIF
        case GHS_0000_ID:
           gs_CurrentCoChipset = CTLM_CO_CHIPSET;
           gs_num_cleardown_flags = gs_num_cleardown_flags_short;
           break;
        //SMS01261911 SMS01246527 IOP_A_DS_ADSL1_ALA3_CheckAuxPilot_Medley (START)
        //Litespan 2k DSLAM sends 0xFF00 vender ID and GHS_ALA_ID in NSIF
        //and C-CL is sent twice. If GHS_ALA_ID is already seen in NSIF,
        //set ALA3 VID to recognize Litespan STM
        case GHS_FF00_ID:
          if (gft_SyncScalingForGenericCOinDMT == 1)
            gs_CurrentCoChipset = ALA3_CO_CHIPSET;
          break;
        //SMS01261911 SMS01246527 IOP_A_DS_ADSL1_ALA3_CheckAuxPilot_Medley (END)

        //XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (START)
        //The logic below is to set ALA4 VID to recognize Marconi STM.
        //Currently this VID is not used, but it may be utilized for Marconi IOP
        //features later.
        case GHS_80000_ID:
          if (gft_SyncScalingForGenericCOinDMT == 1)
            gs_CurrentCoChipset = ALA4_CO_CHIPSET;
          break;
        //XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (END)

//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START)
        case GHS_ECI_ID:
           gs_CurrentCoChipset = ECI_PLSE_CO_CHIPSET;
           break;
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (END)

#endif // ifndef ISDN

        //XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (START)
        case GHS_IKNS_ID:
           gs_CurrentCoChipset = IKNS_CO_CHIPSET;
           break;
        //XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (END)
         default:
            gs_CurrentCoChipset = GENERIC_CO_CHIPSET;
            gs_num_cleardown_flags = gs_num_cleardown_flags_short ;
            break;
      }
      if (gs_CurrentCoChipset != IFTN_CO_CHIPSET)
      {
      //XDSLRTFW-623 BugFix_T1413_Ghs_Xtalk_Activation_Stuck (START)
      #ifndef ISDN
      //Reset counter if CO VID is received except for IFTN due to more xtalk.
      //It'll be reset later in Rx init state.
         guc_Ghs_fails_count = 0;
      #endif
      //XDSLRTFW-623 BugFix_T1413_Ghs_Xtalk_Activation_Stuck (END)

      }
      // save the CO vendor ID
      gs_CurrentCoVendorID =  gpt_RxInfoSave->us_VendorInfo;

      // XDSLRTFW-3511 (Start) C-Comb based loop length estimation with considering PCB for ISDN
      // DS PCB used by CO for CL.  Assumed to be the same for all of G.hs.
      gc_GhsDS_PCB = 0; // No PCB (Initialization)

      if (gs_DetectedCTones == A43_CTonesDetected) // A43 CTone Set PCB
      {
         gc_GhsDS_PCB = gpt_RxInfoSave->uc_DnA43Attenuation;
      }
      else if (gs_DetectedCTones == B43_CTonesDetected) // B43 CTone Set PCB
      {
         gc_GhsDS_PCB = gpt_RxInfoSave->uc_DnB43Attenuation;
      }
      else if (gs_DetectedCTones == A43C_B43C_CTonesDetected) // A43C/B43C CTone Set PCB
      {
         //Both A43C and B43C use same CTones(257,293,337) on DS direction.
         //A43C is used by ADSL Annex A and B43C used by ADSL AnnexB (ISDN)
#ifdef ISDN
         gc_GhsDS_PCB = gpt_RxInfoSave->uc_DnB43cAttenuation; //B43C CTone Set PCB
#else
         gc_GhsDS_PCB = gpt_RxInfoSave->uc_DnA43cAttenuation; //A43C CTone Set PCB
#endif
      }

#ifdef ISDN  // AnnexB
      // loop estimation during GHS including PCB information received from CL identification message.
      // Assuming flat PCB on all CTones
       gs_hsk_tone_power_dB_PCB  = gs_hsk_tone_power_dB +((uint16)gc_GhsDS_PCB << 7); // gc_GhsDS_PCB in 0.5dB step (5.1 dB format)
       

#else  // POTS (AnnexA)
       /*
       !!!THIS IS A BUGGY IMPLEMENTATION!!!
       !!!Please refer to jira XDSLRTFW-3521 : Anomalies in algorithm and in uses of comb tone power based loop
       !!!length estimation (not yet solved!)
       !!!After fixing the issue this #ifdef ISDN and the #else path need to be revised
       */
       // limited only POTS to satisfy the old implementation!
       gc_GhsDS_PCB = gpt_RxInfoSave->uc_DnA43Attenuation; // DS PCB used by CO for CL.  Assumed to be the same for all of G.hs (A43 CTone Set PCB)
       gs_hsk_tone_power_dB_PCB  = gs_hsk_tone_power_dB +((uint16)gc_GhsDS_PCB << 9); // gs_GhsDS_PCB in 0.5dB step (AnnexA only)
       
#endif
       // XDSLRTFW-3511 (End)

        gpt_TxInfo->uc_Type  = M_ACK1;
        gt_hsc.s_NextState = R_HS_CL_OK;
         gs_cl_bonding = gpt_RxInfo->uc_ID_SPar1[2];
#ifdef ADSL_BONDING
         if ( ((gpt_RxInfo->uc_ID_SPar1[2] & BONDING)!=0) && ((gpt_RxInfo->uc_BondingNP2 & BONDING_ETHERNET)!=0) )
         {
                   gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x1;      //Remote PAF supported
         }
#endif

      }
   }
}   /*  ResponseToCL */


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: FormTpsTcSpar2ForMSMessage
 *
 *  Abstract: form the TPS-TC parameters in the SPar2 of an MS message comparing the corresponding
 *            values in the CL and CLR of the CO and CPE respectively
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */
#ifdef PREPAREMS_BIS // comment it as CPE does not do Mode Select
void FormTpsTcSpar2ForMSMessage(TPS_TC_Type_t *pt_Info_TpsTcType, TPS_TC_Type_t *pt_TxCL_TpsTcType, TPS_TC_Type_t *pt_RxCL_TpsTcType, uint16 type)
{

   uint8 CO_tempValue, CPE_tempValue;

   /* compare Min rates. Select the maximum of the CO and CPE min net data rates */
   if(pt_TxCL_TpsTcType->s_MinNetDataRate >= pt_RxCL_TpsTcType->s_MinNetDataRate)
      pt_Info_TpsTcType->s_MinNetDataRate = pt_TxCL_TpsTcType->s_MinNetDataRate;
   else
      pt_Info_TpsTcType->s_MinNetDataRate = pt_RxCL_TpsTcType->s_MinNetDataRate;

   /* compare Max rates. Select the minimum of the CO and CPE max net data rates */
   if(pt_TxCL_TpsTcType->s_MaxNetDataRate <= pt_RxCL_TpsTcType->s_MaxNetDataRate)
      pt_Info_TpsTcType->s_MaxNetDataRate = pt_TxCL_TpsTcType->s_MaxNetDataRate;
   else
      pt_Info_TpsTcType->s_MaxNetDataRate = pt_RxCL_TpsTcType->s_MaxNetDataRate;

   /* compare Min reserved rates. Select the maximum of the CO and CPE min reserved data rates */
   if(pt_TxCL_TpsTcType->s_MinResNetDataRate >= pt_RxCL_TpsTcType->s_MinResNetDataRate)
      pt_Info_TpsTcType->s_MinResNetDataRate = pt_TxCL_TpsTcType->s_MinResNetDataRate;
   else
      pt_Info_TpsTcType->s_MinResNetDataRate = pt_RxCL_TpsTcType->s_MinResNetDataRate;

   /* compare Max latencies. Select the minimum of the CO and CPE max latencies */
   if(MIN((pt_TxCL_TpsTcType->s_MaxLatency), (pt_RxCL_TpsTcType->s_MaxLatency)) == 0) // for special meaning of Max Delay
      pt_Info_TpsTcType->s_MaxLatency = MAX((pt_TxCL_TpsTcType->s_MaxLatency), (pt_RxCL_TpsTcType->s_MaxLatency));
   else
      pt_Info_TpsTcType->s_MaxLatency = MIN((pt_TxCL_TpsTcType->s_MaxLatency), (pt_RxCL_TpsTcType->s_MaxLatency));

   /* compare Max bit error rates. Select the minimum of the CO and CPE max bit error rates */
   if((pt_TxCL_TpsTcType->uc_MaxBER) <= (pt_RxCL_TpsTcType->uc_MaxBER))
      pt_Info_TpsTcType->uc_MaxBER = pt_RxCL_TpsTcType->uc_MaxBER;
   else
      pt_Info_TpsTcType->uc_MaxBER = pt_TxCL_TpsTcType->uc_MaxBER;

   /* compare Min INP vale. Select the maximum of the CO and CPE INP_min */
   CPE_tempValue = pt_TxCL_TpsTcType->s_IMAxINP & 0xFF;
   CO_tempValue= pt_RxCL_TpsTcType->s_IMAxINP & 0xFF;

   pt_Info_TpsTcType->s_IMAxINP = MAX(CO_tempValue, CPE_tempValue);

   if (type == TPSTC_TYPE_ATM) // if ATM, there is additional IMA_Flag parameter
   {
      CPE_tempValue = (pt_TxCL_TpsTcType->s_IMAxINP >>8) & 0x1;
      CO_tempValue= (pt_RxCL_TpsTcType->s_IMAxINP >>8) & 0x1;

      pt_Info_TpsTcType->s_IMAxINP |= (MAX(CO_tempValue, CPE_tempValue)<<8);
   }
}
#endif

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: Modify_USSpectralShape
 *
 *  Abstract: Modify US Tssi used for Geminax CO.  On loops with
 *          high noise form tones >32. It is best not to send Tssi
 *          that is pretty low.

*        Since the Tssi part of the CLR messages are initialized at LinkStart
*        We need to reinitialize those values as well.

 *  Returns: None
 *
 *  Global Variables Used: guca_US_TssiValue_G9923A   ,guca_US_TssiValue_G9925A
 *                   guca_US_TssiIndex_G9923A  guca_US_TssiIndex_G9925A
 *
 *  Notes:     This was the line used to try this
         // new {1, 3, 5, 6, 31, 33, 44, 60},
         // new {35, 34, 32, 0, 0, 34, 54, 62},

         //   old {1, 3, 5, 6, 31, 38, 39, 60},
         // {35, 34, 32, 0, 0, 0/20, 127, 127 },

 *       It may also be possible to use   the function InitGlobalVariables2_BisPlusInfoTx
 *       to save some prog mem also. (but since tis is cache a section of that function is repeated here.
 *-------------------------------------------------------------------
 *^^^
 */


uint8 guc_gmnxTone38Val= 20;  // default -10 dB.
// SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (START)
// move gft_StopTssiInClr above to be referenced by R_HS_CL_OK_state
//FlagT gft_StopTssiInClr = 0;  // default don't stop tssi.
// SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (END)


void Modify_USSpectralShape(){
#ifndef ISDN

   int16 s_annex =  G992_3_ANNEX_A;
   int i, s_index;
   uint8 *puca_CLR_USTssiIndex, *puca_CLR_USTssiValue, *puca_USTssiIndex,  *puca_USTssiValue ;

   // First check that it is a geminax build that needs special attention.
    int16 s_CurrentCoVendorID =  gpt_RxInfoSave->us_VendorInfo;
   int16 s_majorVer = (s_CurrentCoVendorID>>12)&0xf;
   int16 s_minorVer = (s_CurrentCoVendorID>>4)&0xff;
   int16 s_buildCode = s_CurrentCoVendorID&0xf;

   // Proceed with the Tssi change only if it is an official release and
    // if it is 04.xx.xx  or  a release prior to 07.1B.xx
    if ( (s_buildCode != 0xf)    &&
      (( s_majorVer == 0x4  ||  (s_majorVer == 0x7 && s_minorVer < 0x1b) )) )
   {


   for (i=0;i<2;i++)
   {
   // SET UP POINTERS TO THE RELEVANT DATA BUFFERS
   if (i==0)  {
      // 3A data
      // pointer to spectral shape array.
      puca_USTssiIndex = guca_US_TssiIndex_G9923A[DEFAULT_G992_3A_PSDMASK];
      puca_USTssiValue = guca_US_TssiValue_G9923A[DEFAULT_G992_3A_PSDMASK];
      // calculate address in gpusa_CLR... array that was initialized in linkstart.
       s_index = G992_3_ANNEX_A * MAX_NUM_US_TSSI_VALUES;
      puca_CLR_USTssiIndex = (uint8*)(void *)gpusa_CLR_USTssiIndex + s_index;
      puca_CLR_USTssiValue = gpuca_CLR_USTssiValue + s_index;
      }
   else
   {  // 5A data
      // pointer to spectral shape array
      puca_USTssiIndex = guca_US_TssiIndex_G9925A[DEFAULT_G992_5A_PSDMASK];
      puca_USTssiValue = guca_US_TssiValue_G9925A[DEFAULT_G992_5A_PSDMASK];
      // calculate address in gpusa_CLR... array that was initialized in linkstart
      s_index = MAX_NUM_US_TSSI_VALUES*NUM_G992_3_ANNEX_SUPPORTED+ G992_5_ANNEX_A*MAX_NUM_US_TSSI_VALUES;
      puca_CLR_USTssiIndex = (uint8*)(void *)gpusa_CLR_USTssiIndex + s_index;
      puca_CLR_USTssiValue = gpuca_CLR_USTssiValue + s_index;
   }

   // OVERWRITE THE DATA.

   // INDICES
   puca_USTssiIndex[5]  = 38;    // overwrite spectral shape array.
      puca_CLR_USTssiIndex[5] = 38;    // overwrite CLR array.

   puca_CLR_USTssiIndex[6] = 39;
    puca_USTssiIndex[6]    = 39;

   // VALUES
      puca_USTssiValue[5]  = guc_gmnxTone38Val; // overwrite spectral shape array.
   puca_CLR_USTssiValue[5] = guc_gmnxTone38Val; // overwrite CLR array

   puca_USTssiValue[6]  = 127;
   puca_CLR_USTssiValue[6] = 127;

   puca_USTssiValue[7]  = 127;
   puca_CLR_USTssiValue[7] = 127;

   }  // for i
  } // if ver
#endif
}

#undef DIFFERENT_PREF_MODE
#undef HIGHER_CLR_US_PMD
#undef DIFFERENT_TSSI_INFO

