/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_rx.c
 *
 *   Receiver operations for Handshaking.
 *
 *-------------------------------------------------------------------------
 */

// ******************************************************************
// hs_rx.c
//
// History
//
// 12/04/2010 Sriram Shastry: Fix for disabling the detection of B43 and J43 carrier set with OPTN 25, bitmask 0x4000.
//    By default, this cmv bit is ONE(enable the detection). Besides the fix, in addition to the B43 detection in C-TONES,
//    which is based on power difference between B43 tones and its neighboring tones, we also use B43
//    carrier set to decode C-GLAF1 and C-FLAG1 to double confirm if B43 tones are really transmitted from CO site.
//    Only if B43 carrier set are detected in C-TONES, and C-GLAF1 and C-FLAG1 are correctly decoded, then we think
//    B43 are really transmitted from CO site. It also means CO may support AnnexM mode.
//    Grep for SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection
//
// ******************************************************************
#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "hndshk_Data.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "find_sintbl.h"
#include "memsetbf.h"
#include "arctan.h"
#include "dsp_op.h"
#include "dsp_op2.h"

#define FFT_LEN_1024 1024

/* =============================================== */
/* constants used by this file only */
/* =============================================== */
#define SUBBIT_START        (1)     /*  subbit index from which measurements are averaged for a bit */
#define SUBBIT_END          (6)     /*  subbit index to which measurements are averaged for a bit */

/* =============================================== */
/* static function prototypes */
/* =============================================== */
int16 DemodBit( Complex_t t_RxCurrentSymbol[], Complex_t t_RxLastSymbol[] );

//#define DEBUG_HANDSHAKE_DEMOD_CODE

#ifdef DEBUG_HANDSHAKE_DEMOD_CODE
   int16 gsa_RxToneBuf40_debug[2*8*4]; // can collect upto 4 octets
   int16 gsa_RxToneBuf64_debug[2*8*4];
   int16 gs_RxState_debug = 0, gs_State_debug = 0, gs_StartCnt_debug = 0, gs_CollectNumSymbols_debug = 0;
   int32 gl_debug_cnt_hndshk = 0, gl_debug_cnt_hndshk1 = 0;
   int16 gsa_RxToneBuf40_debug1[2*8*4];
   int16 gsa_RxToneBuf64_debug1[2*8*4];
   int32 gl_debug_cnt_debug1 = 0;
   int16 gsa_subbit_debug[8*4];
   int32 gl_debug_cnt_hndshk2 = 0;
#endif


/*
 *------------------------------------------------------------------------
 *
 *  Name: DemodBit
 *
 *  Abstract: Demodulates a bit.
 *
 *  Demodulates one bit of information out of the current and last received bit
 *  symbols.
 *
 *  Parameters:
 *          t_RxCurrentSymbol[]    -   measured tones of current bit symbol
 *          t_RxLastSymbol[]       -   measured tones of the last bit symbol
 *
 *  Returns:
 *          s_bn                   -   determined bit ( 0 or 1 )
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 */
int16 DemodBit( Complex_t t_RxCurrentSymbol[], Complex_t t_RxLastSymbol[] ) {

    int  i;
   int s_Vote;
    int32 l_ProductX;


   s_Vote = 0;

    for ( i = 0; i < NUM_CARRIERS_IN_SET; i++ ) {

        /* ---- real part of a complex product ( Current_Symbol * Conjugate(Last_Symbol) ) ---- */
        l_ProductX =  (int32)t_RxCurrentSymbol[i].s_X * t_RxLastSymbol[i].s_X
                      + (int32)t_RxCurrentSymbol[i].s_Y * t_RxLastSymbol[i].s_Y;

        ( l_ProductX >= 0 )?    s_Vote-- : s_Vote++ ; /*  hard decision and voting (1 for 1, -1 for 0) */
    }

    /* ---- majority vote ---- */
    return (int16)( ( s_Vote >= 0 ) ?  1 : 0 );

}   /*  DemodBit */

/*
 *------------------------------------------------------------------------
 *
 *  Name: RxBit
 *
 *  Abstract: Receive a bit and fill up guc_RxOctet from the LSB
 *            Update gs_RxAn_Prev
 *            Right shift guc_RxOctet by one bit to get ready for next bit
 *
 *  Parameters:
 *      int16   s_SubBit  -   current subbit index
 *
 *  Returns:     None
 *
 *  Global Variables Used:
 *      guc_RxOctet       - (O)   current octet being transmitted
 *      gs_RxAn_Prev      - (I,O) Last An symbol for DPSK purpose
 *      gsa_RxSubBiBuf    - (O)
 *      gsa_RxToneBuf[]   - (I)   frequency domains sampples used in TxTones().
 *
 *------------------------------------------------------------------------
 */
void RxBit(int16 s_SubBit) {

    int  i;
    int16 s_bn;

   int16 s_x, s_y, s_angle, s_angle_neg, s_index;
   int16 s_r, s_exp1, s_quot_mantissa, s_quot_exponent;
    int32 l_tmp_angle ;

#ifdef DEBUG_HANDSHAKE_DEMOD_CODE
   int16 x_debug[3], y_debug[3];
#endif


#ifdef DEBUG_HANDSHAKE_DEMOD_CODE
   if ( (gs_RxState == gs_RxState_debug) && (gt_hsc.s_State == gs_State_debug) )
   {
      if ( gl_debug_cnt_hndshk < (int32) (2*gs_CollectNumSymbols_debug) )
      {
         gsa_subbit_debug[gl_debug_cnt_hndshk2++] = s_SubBit;
         gsa_RxToneBuf40_debug[gl_debug_cnt_hndshk] = gsa_RxToneBuf[ 2*40 ];
         gsa_RxToneBuf64_debug[gl_debug_cnt_hndshk++] = gsa_RxToneBuf[ 2*64 ];

         gsa_RxToneBuf40_debug[gl_debug_cnt_hndshk] = gsa_RxToneBuf[ 2*40+1];
         gsa_RxToneBuf64_debug[gl_debug_cnt_hndshk++] = gsa_RxToneBuf[ 2*64+1];

      }
   }
#endif

    /* ---- reset variables at the beginning of averaging ---- */
    if ( s_SubBit == SUBBIT_START ) {
      MemSetBuffer((short *)(void *)&gt_RxCurrentSymbol,0,0,NUM_CARRIERS_IN_SET*sizeof(Complex_t));
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
//Reset content of current symbol to zero.
#ifndef ISDN
      MemSetBuffer((short *)(void *)&gt_RxCurrentSymbol_B43, 0, 0,
                   NUM_CARRIERS_IN_SET * sizeof(Complex_t));
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
    }

   /* ---- calc vector sum of normalized received tones for
      (SUBBIT_END-SUBBIT_START+1) center subbits.
       Notes: the normalization of the amplitude results in averaging the
       angle of the received tones, instead of the amplitude.  This seems much
       more robust in tough, echo loops.  An alternative is to filter out the two,
       out of 6, most extreme values in received Real/Imag parts, and the latter
       method (MedianFiltering) perfoms equally well as the former (Average Angle):
       i.e. no demodulation errors even at 18Kft with 200 tap.  Since the former
       is better PM-wise (and it can also be applied to the 'moving average' of
       the testing for phase transition), it is the one to be checked in.
   */
   if ( (SUBBIT_START <= s_SubBit) && (s_SubBit <= SUBBIT_END) )
    {
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
#ifndef ISDN
      for (i = NUM_CARRIERS_IN_SET*2 - 1; i >= 0; i--)
#else
      for ( i = NUM_CARRIERS_IN_SET-1; i >= 0; i-- )
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
      {
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
#ifndef ISDN
   if (i <= (NUM_CARRIERS_IN_SET - 1))
   {
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
         s_x = gsa_RxToneBuf[2 * gsa_DnCarSet[i]];
         s_y = gsa_RxToneBuf[2 * gsa_DnCarSet[i] + 1];
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
#ifndef ISDN
        }
        else
        {
         s_x = gsa_RxToneBuf[2 * gsa_DnCarSetB43_J43[i-NUM_CARRIERS_IN_SET]];
         s_y = gsa_RxToneBuf[2 * gsa_DnCarSetB43_J43[i-NUM_CARRIERS_IN_SET] + 1];
        }
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)

            s_angle = FastAtan(s_y, s_x) ;          // angle of received tone sample
            if (s_angle < 0) {
                s_angle = -s_angle ;
                s_angle_neg = 1 ;
            }
            else {
                s_angle_neg = 0 ;
            }

            // pi (256-th entry in gsaSinTbl) is 25736 (8192*pi. 8192=1 radian). Divide 2*s_angle by 201 (i.e. by 256/25736)
            // Numerator/denominator need to have leading bit of 1 (after sign);  0xC9 = 201
            l_tmp_angle = (int32) s_angle ;
            s_exp1 = -norm_l(l_tmp_angle) ;
            l_tmp_angle <<= -s_exp1 ;
            s_exp1 += 1;                                       // 2*s_angle
            s_r = Divide_32by16bit(l_tmp_angle, s_exp1,(0xC9<<7), -7, &s_quot_mantissa, &s_quot_exponent) ;

            // make the final exponent 0 ; mantissa should be between [0,256].
         s_quot_mantissa >>= -s_quot_exponent;
            if ((s_angle_neg) && (s_quot_mantissa)) {
                s_index = 512 - s_quot_mantissa ;
            }
            else {
                s_index = s_quot_mantissa;
            }

            // get new (normalized) quadrature coefficients for the received angle
         if(gs_RxFftLength == (int16) FFT_LEN_1024)
            s_y = findSinTbl((int16)(2*s_index));      // sin(angle)
         else
            s_y = findSinTbl(s_index) ;      // sin(angle)

            s_index += 128 ;               // cos(angle) = sin(angle+pi/2)
            if (s_index > 511) {
                s_index -= 512 ;
            }

         if(gs_RxFftLength == (int16)FFT_LEN_1024)
            s_x = findSinTbl((int16)(2*s_index));
         else
            s_x = findSinTbl(s_index);

//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
#ifndef ISDN
   if (i <= (NUM_CARRIERS_IN_SET - 1))
   {
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
            // normalized quadrature coefs pose no problem of underflow
         gt_RxCurrentSymbol[i].s_X += s_x>>3 ;         // since accum-ing more than 4, we need >>3
         gt_RxCurrentSymbol[i].s_Y += s_y>>3 ;
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
#ifndef ISDN
        }
   else
   {
         gt_RxCurrentSymbol_B43[i-NUM_CARRIERS_IN_SET].s_X += s_x >> 3;
         gt_RxCurrentSymbol_B43[i-NUM_CARRIERS_IN_SET].s_Y += s_y >> 3;
        }
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)

#ifdef DEBUG_HANDSHAKE_DEMOD_CODE
         x_debug[i] = s_x;
         y_debug[i] = s_y;
#endif

      }
   }

#ifdef DEBUG_HANDSHAKE_DEMOD_CODE
   if ( (gs_RxState == gs_RxState_debug) && (gt_hsc.s_State == gs_State_debug) )
   {
      if ( gl_debug_cnt_hndshk1 < (int32) (2*gs_CollectNumSymbols_debug) )
      {
         gsa_RxToneBuf40_debug1[gl_debug_cnt_hndshk1] = x_debug[0];
         gsa_RxToneBuf64_debug1[gl_debug_cnt_hndshk1++] = x_debug[2];

         gsa_RxToneBuf40_debug1[gl_debug_cnt_hndshk1] = y_debug[0];
         gsa_RxToneBuf64_debug1[gl_debug_cnt_hndshk1++] = y_debug[2];

      }
   }
#endif


    /* ---- one full bit received ---- */
    if ( s_SubBit == (SYMBOLS_PER_BIT - 1)  ) {

        /* --- demodulate one bit ---- */
        s_bn = DemodBit( gt_RxCurrentSymbol, gt_RxLastSymbol );

        /* ---- update guc_RxOctet ---- */
        guc_RxOctet  >>= 1;
        guc_RxOctet   |= (s_bn == 1)?    0x80 : 0 ;

        /* ---- update gt_RxLastSymbol ---- */
        for ( i = 0; i < NUM_CARRIERS_IN_SET; i++ ) {
            gt_RxLastSymbol[i] = gt_RxCurrentSymbol[i];
        }

//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
//Demodulate the bits into guc_RxOctet_B43 with B43 carrier set.
#ifndef ISDN
      /* --- demodulate one bit ---- */
      s_bn = DemodBit(gt_RxCurrentSymbol_B43, gt_RxLastSymbol_B43);

      /* ---- update guc_RxOctet ---- */
      guc_RxOctet_B43 >>= 1;
      guc_RxOctet_B43 |= (s_bn == 1) ? 0x80 : 0;

      /* ---- update gt_RxLastSymbol ---- */
      for (i = 0; i < NUM_CARRIERS_IN_SET; i++)
      {
         gt_RxLastSymbol_B43[i] = gt_RxCurrentSymbol_B43[i];
      }
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
    }   /*  if */

}   /*  RxBit */

/*  undefine constants used only in this file */
#undef SUBBIT_START
#undef SUBBIT_END
#undef FFT_LEN_1024
