/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_tx.c
 *
 *   Transmitter operations for Handshaking.
 *
 *-------------------------------------------------------------------------
 */
// ******************************************************************
// hs_tx.c
//
// History
// 31/05/2010 Nihar :Send "B43" & "J43" activation tones for "AnnexB + AnnexJ" multi mode
//          Grep for Perf_US_ALL_MultiTone_Activation
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
//
// 16/05/2013 Naveen: if bit#5 of CNFG 45 is set then send then send only J43 (Tones: 9 ,17, 25)US Activation tones
//             else send B43 (Tones: 37, 45, 53) US Activation tones in HSK
//             Use Annex J Mask9 US Tx filter when send B43 or J43(Because  passband of  will both J43 and B43 tones
//                instead of default  annex 5B mode filter in HSK)
//            Grep for XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs
//
// ******************************************************************

#include "common.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "hndshk_Data.h"
#include "ifft_fix.h"
#include "TxMTnSt.h"
#include "cmv.h"
#include "memsetbf.h"

/*
 *------------------------------------------------------------------------
 *
 *  Name: TxBit
 *
 *  Abstract: Transmit the LSB of guc_TxOctet
 *            Update gs_TxAn_Prev
 *            Right shift guc_TxOctet by one bit to get ready for next bit transmission
 *
 *  Parameters: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      guc_TxOctet       - (I,O) current octet being transmitted
 *      gs_TxAn_Prev      - (I,O) Last An symbol for DPSK purpose
 *      gsa_TxToneBuf[]   - (O)   frequency domains samples
 *                          above two are used in TxMultiTones().
 *
 *------------------------------------------------------------------------
 */
void TxBit(void) {

    int16 s_bn;
    int16 s_An;
    int16 s_TxGain;

    /* ==== if beginning one bit transmission ==== */
    if ( (gl_TxSymbolCount & MODULO_BY_8_MASK) == 0 ) {
        /* ---- transmit a subbit symbol ---- */
        s_bn = (int16) ( guc_TxOctet & LSB_MASK );          /*  take the bit to be xmitted */
        s_An = (s_bn == 0)?  gs_TxAn_Prev : -gs_TxAn_Prev ; /*  differential encoding     */
        s_TxGain = (int16) ( s_An * TX_NEG165DBM );
      MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*gs_TxFftLength));

   // Perf_US_ALL_MultiTone_Activation (Start)
      // Send UpCarSet so that if Annex B is enabled, we do not send US GHS
      // tones in ISDN band. New Rule:
      // If G992xB (and any combination of other modes) - use US toneset B43
      // and NO other carriers in ISDN band
   // As per new requirement( D.Telecom-/Stefan/Joerg/Sriram): Send the Upstream Carrier Set B43+J43
   // for following set Annex Configurations.
      /**************************************************************************************
      (i) Annex-B + J or (ii) ETSI Annex-C + J or (iii) Annex-B + ETSI Annex-C + J
      ***************************************************************************************/

      // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (Start)
      // For Annex J mode or For Annex B+J mode, use only J43 tones for GHS when
   // the GHS carrier set is set for only J43 (i.e. the request is for using only J43 tones)
   // Otherwise, use B43 tones in GHS
   if ((gul_ModeControl & STAT_ConfigMode_AnnexJ_ALL) ||
      ((gul_ModeControl & STAT_ConfigMode_AnnexB_ALL) && (gul_ModeControl & STAT_ConfigMode_AnnexJ_ALL)))
      // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (End)
   {
      //XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start_End)
      if((gs_GhsCarSetCfg & US_GHS_CARRIER_SET_B43_B43C_J43) == US_GHS_CARRIER_SET_J43)
      {
              TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetA43_J43_A43c,
                               NUM_CARRIERS_IN_SET, s_TxGain);
      }
      else
      {
         TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetB43,
                               NUM_CARRIERS_IN_SET, s_TxGain);
      }
   }
      else if (gul_ModeControl & STAT_ConfigMode_AnnexB_ALL)
      {
          TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetB43,
                           NUM_CARRIERS_IN_SET, s_TxGain);
      }
      else  // Annex A/I/J/L/M mode supported, send gsa_UpCarSetA43_J43_A43c
      {
         TxMultiToneSetUp((CONSTANT int16 *) gsa_UpCarSetA43_J43_A43c,
                          NUM_CARRIERS_IN_SET, s_TxGain);
      }
   // Perf_US_ALL_MultiTone_Activation (End)
        gs_TxAn_Prev = s_An; /*  update for differential encoding */
        guc_TxOctet >>= 1;   /*  update for next bit */
    }

}   /*  TxBit */

