/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hndshk.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
//------------------------------------------------------------------------
// tmnt_hndshk.c
//
// History
//
// 24/04/2013 Mahesh: Increase handshake PSD by 0.7dB
//             XDSLRTFW-912: Perf_DS_AnxA_All_GhsBoost
//
// 13/1/2017 Shriram Shastry : The CPE could not link up in G.DMT mode with 4.17.18.7 UGW7.1.1 [PPA API driver info: 96.32.7.3.0.0.4]
//          When  FW makes transition from VDSL to ADSL and CO is configued in ADSL1 Mode,
//          FW is 'NOT' communicating the required TC-Mode and  autonomous message to DSL API. Moved the  function call common for  all hndshk mode and T1413
//          Grep for XDSLRTFW-3068
//-----------------------------------------------------------------------
#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#include "RQuietEF1TxF.h"
#include "RQuietTxF_bis.h"
#include "RQuiet2TxF.h"

#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "RCQuietRxF_BIS.h"
#include "RCQuiet2RxF.h"



// For real time debug purpose
FlagT gft_StopGhs = 0;
extern void EnterFailStates (uint32 ul_error);

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: TerminateHandshakeTx
 *
 *  Description:
 *    Terminate handshake and jump to next Tx state according to
 *    handshake result.
 *
 *  Prototype: void TerminateHandshakeTx(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *          gt_hsc
 *          gs_TxNextState
 *
 *  Notes: used in RGalf2TxF() and RFlag2TxF()
 *
 *-------------------------------------------------------------------
 *^^^
 */
void TerminateHandshakeTx(void) {

#ifndef TARGET_HW
   /* In full mode only, override selected mode and restart
   * handshake via cleardown after first g.hs sample session */
   if (OPTNArray[OPTN_GhsControl] & OPTN_GHS_ST_GHS){
      if (gul_ModeControl == OPTN_ConfigMode_G992_1_A){
         if(gs_HandShake_Cnt == 1){
            gt_hsc.l_SelectedMode = RESTART_VIA_CLEARDOWN;
         }
      }
   }
#endif

   // For real time debug purpose
// if (gft_StopGhs)
//    Pause(1);

#ifndef ISDN
//XDSLRTFW-912: Perf_DS_AnxA_All_GhsBoost[Start_End]
// restore back vargain to original value
   //XDSLRTFW-3184 (START_END)
   //gus_TxGain_NoCutBack = 5462;
#endif

   switch (gt_hsc.l_SelectedMode)
   {
    /* ---- no common mode can be selected. shut down. ---- */
      case NO_COMMON_MODE:
           //EnterFailStates(E_CODE_GHS_NoCommonMode);
           gs_TxNextState = FAIL_TX;
           gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
           /* set exception handler variables */
           gus_ExceptionState   = gs_TxState;
           gus_ExceptionCode = E_CODE_GHS_NoCommonMode_MS;
        break;
    case SILENCE:
         //EnterFailStates(E_CODE_GHS_SILENT);
         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
         /* set exception handler variables */
         gus_ExceptionState   = gs_TxState;
         gus_ExceptionCode = E_CODE_GHS_SILENT;
      break;
    case RESTART_VIA_CLEARDOWN:
        /*  gt_hsc.l_SelectedMode is reset in R_C_TONES_RX state */
#if 0
        gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
#endif

         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
         /* set exception handler variables */
         gus_ExceptionState   = gs_TxState;
         gus_ExceptionCode = E_CODE_GHS_FarEnd_CD;
      break;

    /* ---- escape to fast retrain --- */
    case G992_2_AB_ESC_TO_FR:

        gs_TxNextState = R_QUIET_EF1_TX;
      gpF_TxStateFunc = (PtrToFunc)RQuietEF1TxF;
        break;

    case G992_5_A:
    case G992_5_B:
   case G992_3_J:
   case G992_5_J:
   case G992_3_A_FULL_INIT:
   case G992_3_B_FULL_INIT:
   case G992_3_L_FULL_INIT:
   case G992_3_M:
    case G992_3_I:
    case G992_5_I:
    case (G992_5_M | HS_CHECK_2ND_32BITS):
      gs_TxNextState = R_QUIET1_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RQuiet1TxF_BIS;
      break;

    /* ---- proceed to tranceiver training ---- */
    default: /*  case G_992_2_AB_FULL_INIT or G_992_1_A: */
        gs_TxNextState = R_QUIET2_TX;
      gpF_TxStateFunc = (PtrToFunc)RQuiet2TxF;
        break;

    }   /*  switch */

#ifndef TARGET_HW
   /* For both full and lite modes, override the chosen tx next state
   * and proceed to tx done states (omit full inititialization) after
   * second g.hs sample session */

   if (OPTNArray[OPTN_GhsControl] & OPTN_GHS_ST_GHS)
   {
      if(gs_HandShake_Cnt == 2){
         gs_TxNextState = gs_TxDoneState;
         gpF_TxStateFunc = (PtrToFunc)EmptyState;
      }
   }
#endif

}   /*  TerminateHandshakeTx */

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: TerminateHandshakeRx
 *
 *  Description:
 *    Terminate handshake and jump to next Rx state according to
 *    handshake result.
 *
 *  Prototype: void TerminateHandshakeRx(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *          gt_hsc
 *          gs_RxNextState
 *
 *  Notes: used in RCGalf2TxF() and RCFlag2TxF()
 *
 *-------------------------------------------------------------------
 *^^^
 */
void TerminateHandshakeRx(void)
{

   /* In full mode only, override selected mode and restart
   * handshake via cleardown after first g.hs sample session */

#ifndef TARGET_HW
   if (OPTNArray[OPTN_GhsControl] & OPTN_GHS_ST_GHS)
   {
      if (gul_ModeControl == OPTN_ConfigMode_G992_1_A)
      {
         if(gs_HandShake_Cnt == 1)
         {
               gt_hsc.l_SelectedMode = RESTART_VIA_CLEARDOWN;
         }
      }
   }
#endif
      // BRCM CO transmits proper GHs tone power in CL message. This is trustable and needs to be considered in all required 
      // algorithms to ensure that the tone power of the GHs tones has no impact on the following ADSL training
      // Replace gs_hsk_tone_power_dB with gs_hsk_tone_power_dB_PCB after G.Hs. gs_hsk_tone_power_dB is independent of the used tone-shaping
      gs_hsk_tone_power_dB      = gs_hsk_tone_power_dB_PCB;      // XDSLRTFW-4103(Start_End)
   // For real time debug purpose
   if (gft_StopGhs)
      Pause(2);

   switch (gt_hsc.l_SelectedMode)
   {
      /* ---- no common mode can be selected. shut down. ---- */
      case NO_COMMON_MODE:
         EnterFailStates(E_CODE_GHS_NoCommonMode_MS);
        break;
      case SILENCE:
         EnterFailStates(E_CODE_GHS_SILENT);
         break;
      case RESTART_VIA_CLEARDOWN:
         EnterFailStates(E_CODE_GHS_FarEnd_CD);
#if 0
         /*  gt_hsc.l_SelectedMode is reset in R_C_TONES_RX state */
            gs_RxNextState         = R_C_SILENT1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;

            /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
            gs_TxNextState = R_SILENT0_TX;
            gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
#endif
         break;

      /* ---- escape to fast retrain --- */
      case G992_2_AB_ESC_TO_FR:

         gt_hsc.l_SelectedMode = NOT_SELECTED; /*  reset */
         gs_RxNextState = R_C_QUIET_EF1_RX;
         gpF_RxStateFunc = (PtrToFunc)RCQuietEF1RxF;
         break;

      case G992_5_A:
      case G992_5_B:
      case G992_3_J:
      case G992_5_J:
      case G992_3_A_FULL_INIT:
      case G992_3_B_FULL_INIT:
      case G992_3_L_FULL_INIT:
      case G992_3_M:
      case G992_3_I:
      case G992_5_I:
      case (G992_5_M | HS_CHECK_2ND_32BITS):
         gt_hsc.l_SelectedMode = NOT_SELECTED; /*  reset */

         //For ADSL2, ADSL2P mode: Autonomous message requesting for desired TC driver
         //is moved to RQuiet2TxF_BIS(). This will allow time for API/MEI driver to
         //read out bonding information.
         //Set_AutoMsg_FW_PPE_TcMode();   /* XDSLRTFW-3068 */

         gs_RxNextState = R_C_QUIET1_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCQuiet1RxF_BIS;
         break;

      /* ---- proceed to tranceiver training ---- */
      default: /*  case G992_2_AB_FULL_INIT or G992_1_A: */
         gt_hsc.l_SelectedMode = NOT_SELECTED; /*  reset */

         //Initiate sending autonomous message requesting for desired TC driver
         //(i.e. ATM or PTM/EFM) to be loaded
         Set_AutoMsg_FW_PPE_TcMode();  /* XDSLRTFW-3068 */

         gs_RxNextState = R_C_QUIET2_RX;

#ifdef BIS_CODESWAP
         gpF_RxStateFunc = (PtrToFunc)RCQuiet2RxF_CW;
#else
         gpF_RxStateFunc = (PtrToFunc)RCQuiet2RxF;
#endif
         break;

   }   /*  switch */

#ifndef TARGET_HW
   /* For both full and lite modes, override the chosen rx next state
   * and proceed to rx done states (omit full inititialization) after
   * second g.hs sample session.   If CO goes to done states first,
   * processing is halted before CPE goes to DONE_RX */

   if (OPTNArray[OPTN_GhsControl] & OPTN_GHS_ST_GHS) {
      if(gs_HandShake_Cnt == 2){
         gs_RxNextState = gs_RxDoneState;
         gpF_RxStateFunc = (PtrToFunc)EmptyState;
      }
   }
#endif

}   /*  TerminateHandshakeRx */



