/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ADSL_FEATURE_MAP_H
#define _ADSL_FEATURE_MAP_H

// ******************************************************************
// ADSLFeatureMap.h
//
// History
//
// ******************************************************************


#define ADSL_FEATURE_SUPPORTED          (1)
#define ADSL_FEATURE_NOT_SUPPORTED      (0)

//Refer to CMV 'DSL 19' in Message Spec ver 3.1

// XDSLRTFW-3636 (Start)
//Parameter 3
#define ADSL_FEATURE_NTR                              (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_FEATURE_CI_POLICY                        (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_FEATURE_PRE_EMPTION_AND_SHORT_PACKETS    (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_FEATURE_COUNTER_INHIBITING               (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_FEATURE_SHORT_INIT                       (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_FEATURE_DS_RETX_SRA                      (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_FEATURE_DS_RETX_PTM_BONDING              (ADSL_FEATURE_SUPPORTED)
#define ADSL_FEATURE_PTM_OFFCHIP_BONDING              (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_FEATURE_ANNEX_I                          (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_FEATURE_AFE_POWER_DOWN                   (ADSL_FEATURE_SUPPORTED)   // XDSLRTFW-3648 (Start_End)

//Parameter 4
// Reserved for future usage

//Parameter 5
// Reserved for internal features
// XDSLRTFW-3636 (End)

#endif // _ADSL_FEATURE_MAP_H
