/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DSLENGIN_H
#define _DSLENGIN_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             dslengin.h
 * DESCRIPTION:      Header file that defines the API to the DSL Engine.  The DSL Engine
 *                must implement all of the functions declared here.  The implementation
 *                details will be engine-specific.
 *
 **********************************************************************/

// ******************************************************************
// DSLEngin.h
//
// History
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
// ******************************************************************

#include "typedef.h"
#include "showtime.h"
#include "showtime_tc_dmt.h"
#include "showtime_tc_bis.h"

/***************************************************************************
*
* These functions define the common DSL Engine API.
* NOTE: Functions of type 'extern LoadingFunction'
* are queued and executed later using the task-layer AddFunctionToFifo() and
* ExecuteQueuedLoadingFunctions() functions.  These loading functions should not
* be called directly, i.e. they should only be executed as part of a call to
* ExecuteQueuedLoadingFunctions().
*
***************************************************************************/

#ifndef ADSL_62
void DisableTxInterrupt(int16 source);
void DisableRxInterrupt(int16 source);
void EnableTxInterrupt(int16 source);
void EnableRxInterrupt(int16 source);
#else //#ifdef ADSL62
void DisableTxInterrupt(uint32 ul_bitmask);
void EnableTxInterrupt(uint32 ul_bitmask);
void DisableRxInterrupt(uint32 ul_bitmask);
void EnableRxInterrupt(uint32 ul_bitmask);
void EnableTSC();
void DisableTSC();
void CopyPilotTone(int16 *buf, int16 s_toneIndex);
void ReadAccumulatedReIm(void);
#endif


FlagT isDataPumpRunComplete(int16 s_TxRx, int16 s_mask);
void ClearEventRegister(int16 s_TxRx, uint16 us_mask);
void Trigger_IFFT(void);
void Trigger_QAM(void);
void LoadTxFrameBuffer(int16 s_bc, uint8 *puc_txbertbuffer, int16 s_txbertbufferreadaddr, uint16 *ps_bytesloaded);
void GetRxFrameBuffer(int16 s_bc, uint8 *puca_databuffer, int16 *ps_databufferindex);
void LoadTxOutBuffer(int16 *ps_data, int16 ndata);
void GetTxOutBuffer(int16 *ps_data, int16 ndata);

extern LoadingFunction Disable_IFFT_Reordering;
extern LoadingFunction Enable_IFFT_Reordering;

#ifdef ADSL_62
extern LoadingFunction Disable_IFFT;
extern LoadingFunction Enable_IFFT;
extern LoadingFunction Disable_FFT;
extern LoadingFunction Enable_FFT;
#endif
LoadingFunction InsertRxCP;
extern LoadingFunction RemoveRxCP;
extern LoadingFunction AdjustAlignmentForward;
extern LoadingFunction MedleyAdjustAlignment;
extern LoadingFunction LoadFDQ;
extern LoadingFunction LoadDDFDQ;
extern LoadingFunction SetDecimatorPhase;

#ifdef AMAZON_SE
extern LoadingFunction UpdateRTV;
#endif

extern LoadingFunction LoadTxBitSwap;
extern LoadingFunction LoadRxBitSwap;

extern LoadingFunction LoadFDQPilot;
extern LoadingFunction DisableFDQ;

LoadingFunction InsertTxCP;
extern LoadingFunction RemoveTxCP;

void CopyTone(int16 *buf, int16 s_toneIndex);
void GetRxTime(int16 *ps_data, int16 ndata);
void GetRxTones(int16 *psa_OutBuf, int16 s_FirstTone, int16 s_NumTones);
void GetRxData(int16 *psa_buffer, int16 s_logicalBuffer, int16 s_offset, int16 s_numTones);


#ifdef AMAZON_SE
void Get_Rx_RTV_Data(int16 *psa_buffer, int16 s_RTVn, int16 s_numTones);
void GetPilotTone(int16 *gsa_RxPilotTone);
#endif

#ifdef ISI_ANALYSIS_ON
void GetRxCP(void);
#endif

#ifdef HW_SNR_FDQ
void ResetNoisePowerBuffer(void);
void ReadAccumulatedNoise(void);
#endif

#ifdef USE_ENGINE_FOR_BG_FFTS
   extern LoadingFunction SetRxAllManualStart;
   extern LoadingFunction SaveCascadeSettings;
   extern LoadingFunction RestoreCascadeSettings;
   extern LoadingFunction LoadEngineFFTInput;
   extern LoadingFunction EnableFFTDoneInt;
   extern LoadingFunction SaveInterruptSource;
   extern LoadingFunction RestoreInterruptSource;
   void GetEngineFFTResult(void);
#endif

extern LoadingFunction Trigger_EngineFFT;

extern LoadingFunction MaskRxInput;
extern LoadingFunction UnmaskRxInput;
extern LoadingFunction LoadTxSineGain;
#ifdef ADSL_62
extern LoadingFunction SetTxSineGainUnity;
extern LoadingFunction ConfigRTVBuf0_train_Accum;
extern LoadingFunction ConfigRTVBuf0_ReIm_Accum;
extern LoadingFunction ConfigRTVBuf0_train;
extern LoadingFunction ConfigRTVBuf1_SFDQ_OUT;
extern LoadingFunction RestoreRtvCaptureModeSetting;
extern LoadingFunction EnableLatchPilot;
extern LoadingFunction DisableLatchPilot;
extern LoadingFunction ClearTxZephyrRegs;
extern LoadingFunction ClearRxZephyrRegs;

#ifdef HW_VECPOW_ACCUM
extern LoadingFunction TriggerVectorPower;
extern LoadingFunction ReadVectorPower;
#endif //HW_VECPOW_ACCUM

#endif

extern void Reconfig_STR_FW(uint32 s_mode);
extern void Reconfig_POTS_TxHPF(void);
extern void Reconfig_Interp1_TxLPF(void);

#ifndef ADSL_62
extern LoadingFunction Reconfig_STR_SMODE;
extern LoadingFunction ReconfigDecim_LPF;
#else
extern LoadingFunction Reconfig_DFE_SampleRate;
extern LoadingFunction Reconfig_PostGHS;
#endif

extern LoadingFunction Reconfig_DFE_Rx;
extern LoadingFunction Reconfig_DFE_Tx;
extern LoadingFunction ReconfigDecim2_HPF;
#ifdef DANUBE
extern LoadingFunction LoadDecim2_Bypass;
#endif
void ReorderDEC(int16 *ps_data);
void RescaleDEC(void);
void Reconfig_RxFftLength(int16 s_FftLength);
extern LoadingFunction Reconfig_IRI;
void Reconfig_IRI_IFFT_Size(void);

#ifdef ADSL_62
extern LoadingFunction UnmaskDECOutput;
extern LoadingFunction LoadDECTDQ;
extern LoadingFunction LoadDECDelay;
#endif //ADSL_62
extern LoadingFunction LoadTDQ;
extern LoadingFunction UnityTDQ;
extern LoadingFunction LoadTDQExp;
extern LoadingFunction LoadDEC;
extern LoadingFunction LoadUnityDEC;
extern LoadingFunction ClearDEC;
extern LoadingFunction SetPGA;
extern LoadingFunction SetInitialPgaToMax;

extern LoadingFunction ClearAEC;
extern LoadingFunction LoadAEC;

void RxDataPumpMisc_DMT(void);
void RxDataPumpMisc_TCA_BIS(void);
void RxDataPumpMisc_TCB_BIS(void);

void InitEngine(void);
void InitModemEngine_PostHandshake(void);
void UpdateTxParameters(void);
void UpdateRxParameters(void);

extern LoadingFunction TxDataPumpSetUp;
extern LoadingFunction RxDataPumpSetUp;

extern LoadingFunction OLR_TxLoadTables;
extern LoadingFunction OLR_TxDataPumpSetup;
extern LoadingFunction OLRPM_RxLoadTables;
extern LoadingFunction OLRPM_RxIridiaReconfigDataPumpSetup;
extern LoadingFunction OLRPM_RxAZIReconfigDataPumpSetup;
extern void OLRPM_RxFftReconfigDataPumpSetup(void);
extern LoadingFunction PML2ToL0_RestoreRxL0Config;
extern LoadingFunction OLRPM_RxReadTables;
extern LoadingFunction ReverbSegueDetectorSetup;
extern void ReverbSegueDetectorSelect(int16 s_signalType);
extern void ReverbSegueDetectorDisable(void);
extern void PreSelectReverbSegueDetector(void);
extern FlagT isReverbSegueDetected(int16 s_signalType);

extern LoadingFunction EnableTxFastFraming;
extern LoadingFunction EnableTxIntlvFraming;
extern LoadingFunction DisableTxFraming;
extern LoadingFunction DisableRxFraming;

void SetManualFFT(void);
void ResetManualFFT(void);

extern LoadingFunction ResetRxAlign;

extern LoadingFunction MoveToFdqDoneInt;
extern LoadingFunction MoveToFrameStartInt;
extern LoadingFunction EnableFFTDoneInt;
extern LoadingFunction EnableIFFTDoneInt;
extern LoadingFunction DisableIFFTDoneInt;

extern LoadingFunction Enable_FFT_Reordering;
extern LoadingFunction Disable_FFT_Reordering;

void Enable_MTEtoDFE_TxRx(void);
extern LoadingFunction Enable_MTE_Tx;
extern LoadingFunction Enable_MTE_TxDT;
extern LoadingFunction Enable_TX_FCI_DONE_Int;

#ifdef ADSL_62
extern LoadingFunction EnableTxPms;
extern LoadingFunction DisableTxPms;
#endif



extern LoadingFunction ChangeCapturedToneIdx;
extern LoadingFunction Enable_MTE_Rx;
extern LoadingFunction Disable_MTE_Tx;
extern LoadingFunction Disable_MTE_Rx;
extern LoadingFunction Reset_MTE_Overflow;

extern LoadingFunction EnableFDQDoneInterrupt;
extern LoadingFunction DisableFDQDoneInterrupt;

extern LoadingFunction EnableFDQDoneNTC_EnableGetRxTones;
extern LoadingFunction DisableFDQDoneNTC_DisableGetRxTones;

extern LoadingFunction EnableQAMDoneInterrupt;
extern LoadingFunction DisableQAMDoneInterrupt;

extern LoadingFunction EnableFrameStartInterrupt;
extern LoadingFunction DisableFrameStartInterrupt;

extern LoadingFunction UpdateNumBuffersToRotate;
extern LoadingFunction UpdateLogicalBuffer1ProcBlocks;
extern LoadingFunction UpdateLogicalBuffer2ProcBlocks;
extern LoadingFunction GetSingleDummyFDQInterrupt;
extern LoadingFunction GetSingleDummyFStartInterrupt;

void DoRxFFTBufferScenarioTransition(int16 s_currStateLen, int16 s_currStateSymbolCount);

extern LoadingFunction TxHwSequenceGenerationSetup;
extern LoadingFunction TxHwSequenceGenerationTeardown;

extern LoadingFunction SetFFTScaling;
extern LoadingFunction SetIFFTScaling;

void StartTxTimer(uint16 timerdelay);
uint32 ReadTxTimer();
void SetAutoTxTimer(uint16 timerdelay);
void StartRxTimer(uint16 timerdelay);
uint32 ReadRxTimer();
void SetAutoRxTimer(uint16 timerdelay);

/* API functions that reads and resets Iridia, Strymon overflow registers */
void  ReadAndClearHWOverflow(uint16 *pus_IRI_Tx_Ovflw, uint16 *pus_IRI_Rx_Ovflw, uint16 *pus_STR_Ovflw);

void TriggerAAI_Tx(void);

#ifdef PPE_ENGINE
uint32 CompWrapAroundCounterDiff(uint32 *pul_pre_data, uint32 *pul_curr_data);
#endif
// Get Tx ATM Cell counters
uint32 GetTxIdleCellCnt(int16 s_bc);
uint32 GetTxNonIdleCellCnt(int16 s_bc);

// Get Rx ATM Cell counters
uint16 Get_ATM_Status(int16 s_bc);
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
uint16 Get_PTM_Status(int16 s_bc);
void Get_ATM_Counters(int16 s_bc);
void Get_Rx_PTM_Counters(int16 s_bc,uint32 *pula_CntBuf);
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)
void ResetARCellCnt(int16 s_bc);
void ResetATCellCnt(int16 s_bc);


void GetRSErrorCnt(void);
void GetRSErrorCnt_BIS(int16 s_LatencyPath);
void GetCRCErrorCnt(void);
void GetCRCErrorCnt_BIS(int16 s_LatencyPath);
void SendCorruptCRC_BIS(int16 s_LatencyPath);
void SendCorruptCRC_DMT(int16 s_LatencyPath);

void StartAlphaeusTx(void);
FlagT CopyBC0CellToBC1(int);



int16 GetEocMessage(uint16 *);
void GetAocMessage(uint16 *);
/* copy received indicator bits into 32-bit global variable for HWE, empty for SWE */
void GetIndicatorBits(void);

void GetDECAdaptationRxData(void);
void GetDECAdaptationTxData(void);
extern LoadingFunction LoadDECAdaptationTxOffset;
extern LoadingFunction ActivateDECAdaptationRxCapture;
extern LoadingFunction SupressDECAdaptationRxCapture;
extern LoadingFunction EnableOutBandSignalInsertion;
extern LoadingFunction DisableOutBandSignalInsertion;
extern LoadingFunction DownloadDECCoef;

#ifdef ADSL_62
extern LoadingFunction SetRxSyncFrame;
#endif
extern LoadingFunction GetDECAdaptationRxOffset;

int16 ShowTimeInlvHandler_TX(void);
int16 ShowTimeFastHandler_TX(void);

void TxSyncFrameSetup(void);
void TxSyncFrameTearDown(void);
void RxSyncFrameSetup(void);
void RxSyncFrameTearDown(void);

void TriggerFFT(void);
int16 CalcBitsInTxRateBuffer(int16 s_LatencyPath);
int16 CalcBitsInRxRateBuffer(int16 s_LatencyPath);
void GetTxMuxFrameCnts(int16 *psa_TxMuxFrameCount);
void UpdateRxMuxFrameCount(int16 s_LatencyPath);
void GetTxMuxInlvFrameCnt(int16 *ps_intlcnt);
void GetRxMuxInlvFrameCnt(int16 *ps_intlcnt);
void GetTxFastFrameCounter(int16 *ps_fastcnt);
void GetRxFastFrameCounter(int16 *ps_fastcnt);
void GetBCTxFrameBufferStartAddr(int16 s_numBearerChannel, uint16 *pus_fbxStartAddr);
void GetBCRxFrameBufferStartAddr(int16 s_numBearerChannel, uint16 *pus_fbxStartAddr);

void WriteOverHeadByte(void);
void WriteIndicatorBits(void);

int16 GetTxFramingByteCnts(int16 s_LatencyPath);
int16 GetRxFramingByteCnts(int16 s_LatencyPath);

void StartTxDataPump_DMT(void);
void StartTxDataPump_BIS(void);
void StartRxDataPump_BIS(void);
void StartRxDataPump_DMT(void);
int16 isRxLatencyPathEnabled(int16 s_LatencyPath);

void EnableTxPath(int16 s_LatencyPath);
void EnableRxIntlvPath(void);
void DisableRxIntlvPath(void);
void EnableRxFastPath(void);
void DisableRxFastPath(void);
void EnableAlphaeusRxPath(int16 s_lp);
void EnableAlphaeusTxPath(int16 s_lp);

void GetTxLpBits(int16 s_LatencyPath, int16 *ps_BitsLp);
void SaveQamOutputState(void);
void RestoreQamOutputState(void);
void UpdateRxRateBufWptrBitFifo(int16 s_LatencyPath, uint16 us_rxRateBufWptr, uint16 us_rxBitFifo);
void get_rx_gainscale_shift(int8 *puca_bat, int16 s_num_channels, int16 *psa_RxGainScaleShifts);
void do_rx_consdec(int16 *psa_qam_output, int16 *psa_fdq_output, int16 s_first_channel, int16 s_last_channel);

void SetUpTxIfftScaling(void);
void Update64PtIfftDecTrainCorrSequence(void);
void SetUpTxRateBufferPointers(uint16 us_Tx_Inlv_Size);
void SetUpRxTonesRegister(uint16 us_MinToneIndex, uint16 us_MaxToneIndex);
void SetUpRxRateBufferPointers(uint16 us_Rx_Inlv_Size);
void Configure_RxFFTLength(int16 s_RxFftLength, uint16 *us_data);
void Configure_TCM_Bits(uint16 us_Rx_Tcm_Num1bits, uint16 us_Rx_1Bit_Index);
void ReadRxTonesRegister(uint16 *pus_minTone, uint16 *pus_maxTone);
void ReadRxTcmControlRegister(uint16 *pus_Tcm_Num1bits, uint16 *pus_1Bit_Index);

#ifdef DANUBE
//Background Functions
extern BkgdFunction BgIlvReconfig;
extern BkgdFunction BgDilvReconfig;
extern BkgdFunction BgIlvInit;
extern BkgdFunction BgDilvInit;
#endif

#ifdef DANUBE_WB
void Erasure_Reconfig(void);
#endif
extern void Calculate_DiscardFrame_Threshold(void);
/***************************************************************************
*
* These functions are not part of the common DSL Engine API and these declarations
*  will eventually   be moved elsewhere.
*
***************************************************************************/


/***********************************
These come from states.c
***********************************/
extern LoadingFunction AdjustPathGain;

void afe_reset();
void afe_init();



void CollectIbInfo(void);



#endif   /* _DSLENGIN_H */

