/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DEBUGBUFFER_H
#define _DEBUGBUFFER_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: eoc.h
;
;  Header file for constants and data types in DebugBuffer.c
;
*****************************************************************************/
#include "gdata.h"

#ifdef DEBUG_TRACES

//-----------------Functions -------------------------------------------------


int32 LogMessages(int16 s_count,int16 s_Write_type, ... );
int32 LogMessageSegments(int16 s_Write_type,uint16 us_Msg_length,uint8 *puc_data,uint32 ul_delimiter);
void Init_DebugBuf_variables();
void RequestSwap_DebugBuff_GHS_OR_TRAINING_Tomem();
void updateShowtimeBuffSuperframe(void);
void updateShowtimeBuffSymbol(void);
void updateShowtimeBuffSymbol_BIS(void);
int32 LogShowtimeData(uint8 *puc_base_addr , uint16 us_num_bytes);
void RequestSwap_DebugBuff_ShowTime_Tomem(int32 *pl_addr_source ,int16 s_size_bytes);
void  Decode_Config_Info(void);

#ifdef DEBUG_STREAMING
/// DTI background handler, called by event system
/**
   If the queues fill level is other than 0 the next entry indicated by the queue's read index
   is sent. If the stream exceeds the payload size of the mailbox system it is fragmented into
   several messages. To keep track of the fragments the status and length information of the entry
  is updated in the queue. Same applies to the data pointer. Once it's done the read index is
   incremented.

   @return A non zero value will tell the background thread to schedule the service again.

*/
extern void DSH_BgService( void );

extern void DSH_FgService( void );


/**
   Send small pieces of data as one buffered stream. This is not a feature to stream
   large data. A typical size of data is around a few bytes only.

   @param uc_EventId      use one of DSH_EVT_
   @param uc_BlockSize    the number of bytes to read
   @param p_Data          pointer to data

   @return 0 on success, -1 on error
*/

extern int32 DSH_SendEvent(uint8 uc_EventId, uint8 uc_BlockSize, void * p_Data);

/// Add a debug message to the queue
/**
   Add a debug stream to the handler. The request might be skipped if the stream id's mask bit is not set.
   In this case the function returns successfull but it won't stream the data.
   Checks whether the requested stream is enabled for the current channel or corresponds to the IPTC debug stream data forwarding function
   and then add the stream data to the debug stream handlers queue. If the debug handlers queue is full
   an autonomuous message "HMH_EVT_DBG_BUFFER_OVERFLOW" is send to the host and the function
   returns with error code "-1" without adding data to the queue.

   @note The stream's data memory is owned by the caller. The DSH module and the subsequent HMH module will only
           share a pointer to the memory. Thus if the caller overwrites the memory befor it has been sent by
           the HMH module, the stream will be corrupted.

   @note For future notice: To make debug streaming corruption safe it would need to copy the memory chunk
           between DSH and HMH module. As debug streaming wasn't safe in the past (Vinax Rev2) it was decided
           to save the work and the resources to make it safe. If corrupt debug streaming ever becomes
           a problem in the future take this notice as a point to start.

   @note      Stream Id "DSH_IPTC_DBG_DATA_FORWARD" is treated special - the stream Id is not checked against the stream enable mask in
                  tCmdDbgDebugStreamConfigure and against the channels global debug stream enable mask - it is always forwarded to the host.
                  This fulfills the requirements for IPTC Debug stream forwarding which contains debug stream data for all channels of the data processing slice
                  and shall therefore happen transparently regardless of this channels stream enable mask.

   @param us_StreamID     one of the above defined IDs
   @param uc_BlockSize    length of debug stream data in bytes
   @param p_Data        pointer to debug stream data

   @return StreamNum+1, or 0 if debug streams on this channel are globally disabled or if the data could be successfully queued in, -1 if the queue is full
*/

int32 DSH_SendStream(uint16 us_StreamID, uint16 uc_BlockSize, void * p_Data);

#endif
//----------------------------------------------------------------------------
//----------------- Buffer Size and Memory Management ------------------------

#define DEBUG_INTERNAL_BUFFER_MAX_SIZE_BYTES 4000
#define SDRAM_RAW_DUMP_SHOWTIME_START_INDEX 2000
#define DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES 2000
#define RAW_DUMP_MAX_SDRAM_SIZE_BYTES 20000
#define SDRAM_RAW_DUMP_SHOWTIME_SIZE_BYTES 18000

//---------------------------------------------------------------------------


//-----------------------Delimiters------------------------------------------


#define DEBUG_BUFFER_DELIMITER_REPEAT_EVERY_X_SYM 0xAEAEAEAE
#define DEBUG_BUFFER_DELIMITER_SYC_SYM_START 0xEFEFEFEF
#define DEBUG_BUFFER_DELIMITER_SYC_SYM_END 0xFBFBFBFB

#define DEBUG_BUFFER_DELIMITER_GHS_START 0xCDCDCDCD
#define DEBUG_BUFFER_DELIMITER_GHS_TX_MSG 0x77777777
#define DEBUG_BUFFER_DELIMITER_GHS_RX_MSG 0x88888888
#define DEBUG_BUFFER_DELIMITER_GHS_RX_MSG_INVALID 0x88898889
#define DEBUG_BUFFER_DELIMITER_GHS_RX_MSG_FCS_ERROR 0x888A888A
#define DEBUG_BUFFER_DELIMETER_GHS_END 0xDBDBDBDB
#define DEBUG_BUFFER_DELIMITER_ADSL 0xEEEEEEEE
#define DEBUG_BUFFER_DELIMETER_TRAINING_END 0xBCBCBCBC

//----------------------------------------------------------------------------


//--------------------------Message Identifiers-------------------------------
#define C_MSG_FMT_MSG 0x0180
#define C_MSG_PCB_MSG 0x0181
#define R_MSG_FMT_MSG 0x0102
#define R_MSG_PCB_MSG 0x0103
#define C_MSG1_MSG 0x0184
#define R_MSG1_MSG 0x0105
#define C_MSG2_MSG 0x0186
#define R_MSG2_MSG 0x0107
#define C_RATES1_DMT_MSG 0x0080
#define C_MSG1_DMT_MSG 0x0081
#define R_RATES1_DMT_MSG 0x0002
#define R_MSG1_DMT_MSG 0x0003
#define R_MSG_RA_DMT_MSG 0x0004
#define R_RATES_RA_DMT_MSG 0x0005
#define C_RATES_RA_DMT_MSG 0x0086
#define C_MSG_RA_DMT_MSG 0x0087
#define R_MSG2_DMT_MSG 0x0008
#define R_RATES2_DMT_MSG 0x0009
#define C_MSG2_DMT_MSG 0x008A
#define C_RATES2_DMT_MSG 0x008B

#define END_OF_THE_MSG 0x1212
#define NOT_END_OF_MSG 0x5555

//-------------------------------------------------------------------
// Debug Buffer - Error/condition Identifiers
//-------------------------------------------------------------------
#define NO_SPACE_INTERNAL_BUFFER 0x0F
#define NO_DMA_ERROR_DEBUG 0x0000
#define INTERNAL_BUFFER_FULL 0xBBBB
#define EXCEEDS_MAX_ARGUMENTS 0x0005
#define NO_DEBUG_BUFFER_ERROR 0x0001
#define STOP_SHOW_TIME_CAPTURE 2
#define SHOW_TIME_CAPTURE_ENABLE_CHECK 0x0002
#define GHS_TRAINING_CAPTURE_ENABLE_CHECK 0x0001
#define STOP_GHS_TRAINING_CAPTURE 1
#define LOG_PER_X_SYMBOL_DEBUG_BUFFER 44

//-------------------------------------------------------------------

#endif // #ifdef DEBUG_TRACES
#endif //#ifndef
