/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef T1413_H
#define T1413_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: T1413.h
;
;  This is a header file containing macro definitions used by ADSL CPE Modem
;  compliant with T1413 Issue2 standard
;
;***************************************************************************/
// *****************************************************************************
// T1413.h
//
// History
//
// 26/07/2010 Bhadra: Added Constant "MAX_ALLOWED_GHS_TRIES" for compilation
//       Grep for SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop
//
// 26/07/2010 Nihar/Bhadra: Bug fix for initializing the gs_CurrentCoChipset
//                 in T1.413 mode.
//                 Grep for IOP_ALL_T1413_ALL_AddVendID
//
// 26/07/2010 Ram/Bhadra:   Added vendor ID for CNXT D57 T1.413 Vendor ID
//                 Grep for IOP_CNXT_T1413_ALL_AddD57VendID
//
// 08/02/2012:US rates are very low (~400kbps) upto 2km with Ikanos ISAM NVLT-C in T1413 mode.
//            This appears to be Ikanos TEQ problems. Problems were seen even after merging
//            XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement. Options
//            analogcutback,64 tone FFT etc., didn't help. VendorID change to TI resolves this.
//            And also clear the variable "gft_NVLTC_T1413_fix" in persistent memory.
//       For code changes Grep for XDSLRTFW-414 Enh_US_T1413_TIVID_Switch

// *****************************************************************************

#ifndef ISDN
// TONES FOR RX
#define C_T1413_TONE 72
#define C_ACT1_TONE     48
#define C_ACT2_TONE     44
#define C_ACT3_TONE     52
#define C_ACT4_TONE     60
#define C_REVEILLE_TONE    56

// Tones for TX
#define  R_ACT_REQ_TONE 8
#define R_ACK1_TONE     10
#define R_ACK2_TONE     12
#define R_ACK3_TONE     14
#define R_PILOT_TONE 16

#else
// TONES FOR RX
#define C_T1413_TONE 82  //copy from GMX A053
#define C_ACT2m_TONE 74
#define C_ACT2e_TONE    76
#define C_REVEILLE_TONE    78

// Tones for TX
#define  R_ACT_REQ_TONE 42
#define R_ACK1m_TONE 44
#define R_ACK1e_TONE 46
#define R_ACK2m_TONE 48
#define R_ACK2e_TONE 50
#endif
// Transmit power for R_ACT_REQ, R_ACK,
#define POWER_LEVEL_HIGH      0x3CCF               //-1.65dBm
#define POWER_LEVEL_LOW    0x615             //0x3CCF*0.1, 20 dB lower


// State Length

#define R_ACT_REQ_TX_LEN            (1024)
#define R_ACT_REQ_ACT_TX_HALFLEN    (64)
#define R_ACT_REQ_ACT_TX_LEN        (128)
#define R_ACT_REQ_QUIET_MIN_LEN        (128)
#define R_QUIET1_TX_LEN             (240000)
#define R_QUIET2_MIN_LEN            (128)
#define R_ACK_TX_HALFLEN            (64)
#define R_ACK_TX_LEN             (128)

// Detection length
#define  R_C_ACT_DET_CNT               (4)
#define RX_REVEILLE_DET_CNT            (8)
#define R_C_QUIET2_DET_CNT          (8)
#define R_T1413_QUIET2_TX_TIMEOUT         (4000)
//IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop(Start_End)
#define MAX_ALLOWED_GHS_TRIES    (2)
// C_ACT signals corresponding to tones above
#define C_ACT1    1
#define C_ACT2    2
#define C_ACT3    3
#define C_ACT4    4
#define C_ACT_TONE            5  // indicate detecting C_T1413_TONE

//C_ACT signals accumulation symbols
#define CACT_LOG2_NUM_ACCUM_SYMBOLS (4)

//--------------defines for RMsgs -----------------------------------------//
#define T1413_VENDOR_ID       (0x0000) // (16 bits) Not Aware's T1.413 Vendor ID (0x000B), for confusion wih 910
#define T1413_REV_NO       (0x1)    // T1413 Reviion number, {001} for ISSUE 2 (3 bits)
#define T1413_VENDOR_REV_NO      (0x1)    // Vendor's revision number (5 bits)
#define T1413_EES_FLAG        (0x1)    // Expanded exchange sequence (1 bits), should set to 1

//Vendor ID code based on T1.413 AnnexD spec
#define T1413_ADI_ID   (0x1C)
#define T1413_ALA_ID   (0x22)
#define T1413_AWRE_ID  (0xB)
#define T1413_CTLM_ID  (0x50)
#define T1413_GSI_ID   (0x39)
#define T1413_IFTN_ID  (0x4C)  //Siemens
#define T1413_TI_ID    (0x4)

// IOP_ALL_T1413_ALL_AddVendID (Start)
#ifndef ISDN   // Only for Anx-A
#define T1413_GSI_ID1   (0x46)
#define T1413_ECI_ID (0x2D)
#define T1413_BRCM_ID   (0x54)
#define T1413_CTLM_COPPER_ID  (0xB6DB)
#define T1413_BRCM_ERICY_ID      (0x4D54)
#define T1413_GSI_ID2  (0x9)
#define T1413_IKANOS_ID   (0x53) ////XDSLRTFW-414 Enh_US_T1413_TIVID_Switch (start_end)
#endif // ifndef ISDN
// IOP_ALL_T1413_ALL_AddVendID (End)
#endif      //ifndef T1413_H
