/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VDSL_FEATURE_MAP_H
#define _VDSL_FEATURE_MAP_H

// ******************************************************************
// VDSLFeatureMap.h
//
// History
// 26/11/2012 Varun : Updated the features supported in VDSL DSL 20.
//                    Grep for XDSLRTFW-1412
//
// 01/12/2015 Ram: Updated VDSL Feature map with R9 release content
// ******************************************************************


#define VDSL_FEATURE_SUPPORTED          (1)
#define VDSL_FEATURE_NOT_SUPPORTED      (0)


//Refer to CMV 'DSL 20' in Message Spec ver 2.7 - Sec 6.4.7, 6.4.8

//Parameter 2
#define VDSL_Feature_ATM_Off_Chip_Bonding                     (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_ATM_On_Chip_Bonding                      (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_Feature_PTM_OffChip_Bonding_BACP                 (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_Feature_PTM_OnChip_Bonding_BACP                  (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_Feature_PTM_OffChip_Bonding_GHS_Based            (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_PTM_OnChip_Bonding_GHS_Based             (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_Feature_Profile_30                               (VDSL_FEATURE_SUPPORTED)


//Parameter 3
#define VDSL_Feature_NTR                                      (VDSL_FEATURE_SUPPORTED)
//XDSLRTFW-1619: VDSL_CI_Policy1_2 (Start/End)
#define VDSL_Feature_CIPolicy                                 (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_PreEmption_And_ShortPkts                 (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_Feature_DELT                                     (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_Dual_Latency                             (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_Feature_VirtualNoise                             (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_Erasure_Decoding_Force_INP               (VDSL_FEATURE_NOT_SUPPORTED)

//XDSLRTFW-1412(START)
#define VDSL_Feature_G_INP_ReTx_US_DS_SRA                     (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_G_INP_ReTx_DS_SRA                        (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_G_INP_ReTx_US_DS                         (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_G_INP_ReTx_DS                            (VDSL_FEATURE_SUPPORTED)
//XDSLRTFW-1412(END)

#define VDSL_Feature_SOS                                      (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_Feature_SRA                                      (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_BitSwap                                  (VDSL_FEATURE_SUPPORTED)

//Parameter 4
#define VDSL_Feature_AELEM                                    (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_AEC                                      (VDSL_FEATURE_NOT_SUPPORTED)    //2nd DAC
#define VDSL_Feature_MicroFilterDetection_And_HybridData      (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_RealTimeTrace                            (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_Feature_ClearEOC                                 (VDSL_FEATURE_NOT_SUPPORTED)

//Parameter 5
#define VDSL_Feature_Profile_35b                              (VDSL_FEATURE_SUPPORTED)
#define VDSL_Feature_ExchngOfTransceiver_IDs                  (VDSL_FEATURE_SUPPORTED)
#ifdef VECTORING_BUILD
   #define VDSL_Feature_Vectoring                                (VDSL_FEATURE_SUPPORTED)        //Fully Standard Compliant
#else
   #define VDSL_Feature_Vectoring                                (VDSL_FEATURE_NOT_SUPPORTED)        //Fully Standard Compliant
#endif

#endif // _VDSL_FEATURE_MAP_H
