/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: afe.h
*
*-------------------------------------------------------------------------------
*/

#ifndef _AFE_H
#define _AFE_H

#include "typedef.h"

/**********************************************************************
 * Memory map for AFE block
 **********************************************************************/

#define     SIMULATOR_PGA_ADDR   (0x8700) // used by task layer to set gf_Pga
                                         // in exec layer

#define     AFE_BASE_ADDR     (0x703A)

#define AFE_ADDR_OFFSET       (0)
#define AFE_RDATA_OFFSET      (1)
#define AFE_WDATA_OFFSET      (2)
#define AFE_CONFIG_OFFSET     (3)
#ifndef STRYMON_10
#define AFE_MODE_SEL_OFFSET         (4)
#define AFE_SERIAL_CONFIG_OFFSET (5)
#endif

#define         AFE_TCR_0_ADDR          (0x7037)
#define         AFE_TCR_1_ADDR          (0x7038)
#define         AFE_TCR_2_ADDR          (0x7039)
#define         AFE_ADDR_ADDR           (AFE_BASE_ADDR + AFE_ADDR_OFFSET)
#define         AFE_RDATA_ADDR          (AFE_BASE_ADDR + AFE_RDATA_OFFSET)
#define         AFE_WDATA_ADDR          (AFE_BASE_ADDR + AFE_WDATA_OFFSET)
#define         AFE_CONFIG_ADDR         (AFE_BASE_ADDR + AFE_CONFIG_OFFSET)
#define         AFE_MODE_SEL_ADDR       (AFE_BASE_ADDR + AFE_MODE_SEL_OFFSET)
#define         AFE_SERIAL_CONFIG_ADDR  (AFE_BASE_ADDR + AFE_SERIAL_CONFIG_OFFSET)
// end of AFE memory map



#define AFE_MODE_DATAPATH_DSP8101   (0)
#define AFE_MODE_FUJITSU_MB86626 (1)
#define AFE_MODE_SILABS_Si3100      (2)
#define AFE_MODE_INFINEON_PEB22715  (3)
#define AFE_MODE_FUJITSU_MB86627 (4)
#define AFE_MODE_ADI_AD648X         (5)

/* Function Prototypes */

void WriteAfe(int16 addr, int16 data);
int16 ReadAfe(int16 addr);
extern BkgdFunction BgPGA;
#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
extern int16 AmazonACalcAGC1(int16 s_PGA_required);
extern int16 AmazonACalcAGC2(int16 s_PGA_required);
#endif   /* End of #ifdef AMAZON_AFE */
void AdjustPathGain(void);
extern LoadingFunction Reconfig_AFE;









#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
/****************************************************/
/* Danube-A register definitions */
/****************************************************/
#define DANUBEA_CHIP_ID       (0x0)
#define DANUBEA_POWER_DOWN    (0x1)
#define DANUBEA_SOFT_RESETS      (0x2)
#define DANUBEA_CLOCK_CONTROL (0x3)
#define DANUBEA_TX_CONF       (0x4)
#define DANUBEA_PGA_SET       (0x5)
#define DANUBEA_HYB_SET_B     (0x6)
#define DANUBEA_HYB_SET_A     (0x7)
#define DANUBEA_LEV_DET       (0x8)
#define DANUBEA_HPF_EQ_SET    (0x9)
#define DANUBEA_DIGITAL_RX    (0xA)
#define DANUBEA_DIGITAL_TX    (0xB)
#define DANUBEA_STATUS        (0xC)

#define DANUBEA_LPBK       (0x40)
#define     DAC_LOOP_BIT            (0x200)
#define DANUBEA_TEST       (0x41)
#define DANUBEA_LD_OPT        (0x42)
#define DANUBEA_DAC_OPT       (0x43)
#define DANUBEA_PGA1_OPT      (0x44)
#define DANUBEA_PGA2_OPT      (0x45)
#define DANUBEA_ADC_OPT0      (0x46)
#define DANUBEA_ADC_OPT1      (0x47)
#define DANUBEA_ADC_OPT2      (0x48)
#define DANUBEA_ADC_OPT3      (0x49)
#define DANUBEA_ADC_OPT4      (0x4A)
#define DANUBEA_BIAS       (0x4B)
#define DANUBEA_OSC           (0x4C)
/****************************************************/
/* Other definitions */
/****************************************************/
#define HPF_ON_AGC1_MARGIN (0x0600)
#define MIN_AGC1_GAIN      (0xFA00)
#define MIN_AGC2_GAIN      (0xFE00)
#define HPF_ON          (0xEFFF)
#define HPF_OFF            (0x1000)
#define EQUALIZER_ON    (0x0300)
#define EQUALIZER_OFF      (0xFCFF)
#define EQUALIZER_MASK     (0x0300)
#define HPF_ON_OFF_MASK    (0x1000)
#define HPF_FREQ_MASK      (0x000F)
#define EQ_HPF_FREQ_MASK   (0x030F)
#define ANALOG_GAIN_DB     (0xFC00)

/****************************************************/
/* Variable externs */
/****************************************************/
extern int16 gs_HybA;
extern int16 gs_HybB;
extern int16 gs_HPF_init;

#else /* Else for #ifdef DANUBE_AFE */
/****************************************************/
/* Amazon-A register definitions */
/****************************************************/
#define AMAZONA_ID_VERSION    (0x0)
#define AMAZONA_POWER_DOWN    (0x1)
#define AMAZONA_SOFT_RESET    (0x2)
#define AMAZONA_CLOCK_CONTROL (0x3)
#define AMAZONA_TX_CONFIG     (0x4)
#define AMAZONA_AGC_SETTING      (0x5)
#define AMAZONA_HYBRID_SETTING0  (0x6)
#define AMAZONA_HYBRID_SETTING1  (0x7)
#define AMAZONA_HYBRID_SETTING2  (0x8)
#define AMAZONA_HPF_EQ_SETTING   (0x9)
#define AMAZONA_RX_FILT_SETTING  (0xA)
#define AMAZONA_TX_FILT_SETTING  (0xB)
#define AMAZONA_STATUS        (0xC)
#define AMAZONA_FUSES         (0x40)
#define AMAZONA_LOOPS         (0x41)
#define AMAZONA_TEST_MODES    (0x42)
#define AMAZONA_LD_OPTION0    (0x43)
#define AMAZONA_LD_OPTION1    (0x44)
#define AMAZONA_DAC_OPTION    (0x45)
#define AMAZONA_AGC1_HYB_OPTION  (0x46)
#define AMAZONA_AGC2_OPTION      (0x47)
#define AMAZONA_ADC_OPTION0      (0x48)
#define AMAZONA_ADC_OPTION1      (0x49)
#define AMAZONA_PLL_OPTION    (0x4A)
#define AMAZONA_BIAS_OPTION      (0x4B)
/****************************************************/
/* Other definitions */
/****************************************************/
#define HPF_ON_AGC1_MARGIN (0x0600)
#define MIN_AGC1_GAIN      (0xFA00)
#define MIN_AGC2_GAIN      (0xFE00)
#define HPF_ON          (0xDFFF)
#define HPF_OFF            (0x2000)
#define EQUALIZER_ON    (0x1800)
#define EQUALIZER_OFF      (0xE7FF)
#define EQUALIZER_MASK     (0x1800)
#define HPF_ON_OFF_MASK    (0x2000)
#define HPF_FREQ_MASK      (0x00FF)
#define EQ_HPF_FREQ_MASK   (0x18FF)
#define ANALOG_GAIN_DB     (0xFC00)
/****************************************************/
/* Amazon-A register settings  */
/****************************************************/
#define TX_CONFIG_POTSAnnexM (0x246)
#define TX_CONFIG_ISDNAnnexM (0x244)
#define TX_CONFIG_POTSAnnexA (0x242)
#define POTS_HYBRID0    (0x0539)
#define ISDN_HYBRID0    (0x0E8D)
#endif   /* End of #ifdef/#else DANUBE_AFE */
/****************************************************/
/* Function declarations */
/****************************************************/

/****************************************************/
/* Variable externs */
/****************************************************/
extern int16 gs_AmazonA_HPFAtten;
extern int16 gs_HPFEq_Reg_Setting;
extern int16 gsa_Amazon_BisRxAFEFiltEqOff_dB[];
extern int16 gsa_Amazon_PlusRxAFEFiltEqOff_dB[];
extern int16 gsa_Amazon_PlusRxAFEFiltEqOn_dB[];
extern int16 gs_MinValBisChan_AmazonEqOff;
extern int16 gs_MinValPlusChan_AmazonEqOff;
extern int16 gs_MinValPlusChan_AmazonEqOn;
#endif   /* End of #ifdef AMAZON_AFE */

#ifdef VINAX_ADSL_AFE
#define AI_CONFIG_REG_CONTENTS (0x00B84C31)
#endif

#endif
