/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _AOC_H
#define _AOC_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: aoc.h
;
;  This file is the head file for doing AOC operations.
;
*****************************************************************************/


/* ======================= Define Constants =================================// */
/* ============================================================================================= */
/* ============================================================================================= */
/* AOC parameters */
/* ============================================================================================= */
/* ============================================================================================= */

/* Rx message decoder states */
#define AOC_SEARCH_FOR_MESSAGE   (0)
#define AOC_COMPARE_MESSAGES  (1)

/* message headers */
#define AOC_STUFFING_BYTE     (0x00)      /* stuffing byte pattern */
#define AOC_HEADER_UTC        (0xF0)      /* unable to compile */
#define AOC_HEADER_EBSR       (0xFC)      /* extended bit swap request */
#define AOC_HEADER_BSR        (0xFF)      /* bit swap request */
#define AOC_HEADER_BSA        (0xFF)      /* bit swap acknowledge */
#define AOC_HEADER_PMR        (0x03)      /* profile management request */
#define AOC_HEADER_PMA        (0x03)      /* profile management acknowledge */

/* message length */
#define AOC_MSG_UTC_LEN       1        /* unable to compile  */
#define AOC_MSG_EBSR_LEN      13       /* extended bit swap request */
#define AOC_MSG_BSR_LEN       9        /* bit swap request  */
#define AOC_MSG_BSA_LEN       3        /* bit swap acknowledge */
#define AOC_MSG_PMR_LEN       3        /* profile management request */
#define AOC_MSG_PMA_LEN       3        /* profile management acknowledge */

/* message command fields */
#define AOC_CMD_PMR           (0x01)      /* profile management request */
#define AOC_CMD_PMA           (0x02)      /* profile management acknowledge */
#define AOC_CMD_DO_NOTHING    (0x00)      /* do nothing */
#define AOC_CMD_BIT_INC1      (0x01)      /* increase the number of allocated bits by 1 */
#define AOC_CMD_BIT_DEC1      (0x02)      /* decrease the number of allocated bits by 1 */
#define AOC_CMD_PWR_INC1      (0x03)      /* increase the transmitted power by 1 dB */
#define AOC_CMD_PWR_INC2      (0x04)      /* increase the transmitted power by 2 dB */
#define AOC_CMD_PWR_INC3      (0x05)      /* increase the transmitted power by 3 dB */
#define AOC_CMD_PWR_DEC1      (0x06)      /* decrease the transmitted power by 1 dB */
#define AOC_CMD_PWR_DEC2      (0x07)      /* decrease the transmitted power by 2 dB */
#define AOC_CMD_BSA           (0xFF)      /* bit swap acknowledge */

/* message type (represnted in different numbers) */
#define AOC_MSG_ID_UTC        (0)         /* unable to compile */
#define AOC_MSG_ID_PMR        (1)         /* profile management request */
#define AOC_MSG_ID_PMA        (2)         /* profile management acknowledge */
#define AOC_MSG_ID_BSR        (3)         /* bit swap request */
#define AOC_MSG_ID_BSA        (4)         /* bit swap acknowledge */
#define AOC_MSG_ID_EBSR       (5)         /* extended bit swap request */
#define AOC_MSG_ID_UNDEFINED  (6)         /* undefined message */

/* others */
#define AOC_MIN_NUM_STUFFING_BYTES  20    /* min. number of stuffing bytes between messages */
#define AOC_MAX_MSG_LENGTH       13    /* maximum msg length in byte */
#define AOC_NUM_MSG_HEADERS         6     /* no. of different valid message headers */
#define AOC_MSG_REPEAT_CNT       5     /* no. of times for the same message to be sent repeatively */
#define  AOC_TX_TIMEOUT          2000  /* = 500msec/250usec, AOC TX timeout in DMT symbols */
#define AOC_INFINITY          0x7FFF   /* represent number infinity */

#define AOC_FAIL_OF_UTC       (0)         /* tx message fails due to receiving UTC */
#define AOC_FAIL_OF_TIMEOUT      (1)         /* tx message fails due to timeout */
#define AOC_FAIL_OF_UNMATCH      (2)         /* tx message fails due to receiving unmatching acknowlege */

#define AOC_NEW_MSG           (1)         /* search for new message */
#define AOC_CONT_MSG       (0)         /* continue with the current message */

#define MAX_SFRAME_COUNT      (256)    /* The maximum super frame count + 1 */
#define NEG_SNR_MARGIN_FOR_BIT_SWAP    (3<<8)   /* dB in @8.8 format) */
                                    /* negative SNR margin */
#define POS_SNR_MARGIN_FOR_BIT_SWAP    (3<<8)   /* dB in @8.8 format) */
                                    /* positive SNR margin */

#define NUM_SUPERFRAMES_WT_FOR_BITSWAP    50 /* number of super frames to wait */

/* the following parameters are calculated as 512*10^(del_gain/20)*(2^5), */
/* i.e., 10^(del_gain) in Q2.14 format */
/* where del_gain is the fine gain change sent from BSR or EBSR  */
/* (which can be 1, 2, 3 or -1, -2, -3 dB) */
#define BS_GAIN_INC1 0x47CF      /* 512*10^(1/20) * (2^5) */
#define BS_GAIN_INC2 0x5092      /* 512*10^(2/20) * (2^5) */
#define BS_GAIN_INC3 0x5A67      /* 512*10^(3/20) * (2^5) */
#define BS_GAIN_DEC1 0x390A      /* 512*10^(-1/20) * (2^5) */
#define BS_GAIN_DEC2 0x32D6      /* 512*10^(-2/20) * (2^5) */
#define BS_GAIN_DEC3 0x2D4F      /* 512*10^(-3/20) * (2^5) */

#define AOC_TX_MAX_RETRIES    1  /* maximum no. of times that same message is retried */


#define TIME_TO_SEND_PMR         (59)  /* number of superframes to wait for */

#define NEW_AOC_MESSAGE 0x100          /* packed bit created to indicate new valid aoc message */

//Internal error code for DMT US bitswap
#define REQ_BEFORE_FINISH_PREV_BITSWAP  (0x0001)
#define REQ_INVALID_TONE            (0x0002)
#define REQ_INVALID_INC_Bi          (0x0004)
#define REQ_INVALID_DEC_Bi          (0x0008)
#define REQ_INVALID_INC_Gi          (0x0010)
#define REQ_INVALID_DEC_Gi          (0x0020)
#define REQ_INVALID_COMMAND            (0x0040)
#define REQ_INVALID_1BITTONE        (0x0080)
#define REQ_INVALID_L_TCM_OFF       (0x0100)
#define REQ_INVALID_L_TCM_ON        (0x0200)

/* ======================= Define Structures =================================// */

/* Structure containing TX AOC message variables */
typedef struct {
   int16 s_msg_timer;            /* message timer in DMT symbols */
   uint8 uc_msg_retry_count;        /* message retry (resent) count */
   uint8 uc_msg_length;          /* message length in bytes */
   uint8   uc_msg_flag;          /* flag indicating the status of this message */
                              /* which can be OUTSTANDING, FAIL or SUCCEED    */
   uint8 uc_msg_id;              /* message identifier */
    uint8   uc_reason_of_fail;         /* reason of fail (either UTC is received or timeout occurs) */
   uint8 uca_msg_body[AOC_MAX_MSG_LENGTH]; /* message body buffer */

} AocMsgStruc_t;

//Structure containing TX AOC handler variables
typedef struct {
   uint8 uc_msg_repeat_count;    //count for message sent repeatively
   uint8 uc_next_byte;           //index of the byte to be sent
   uint8 uc_stuffing_byte_count;    //count for number of stuffing bytes sent
   uint8 uc_outstanding_msg_count;  //count of number of outstanding messages
   uint8 uc_nonoutstanding_msg_count;  //count of number of nonoutstanding messages
   uint8 uca_AOC_outbuf[AOC_MAX_MSG_LENGTH];    //AOC TX output buffer
   AocMsgStruc_t  *pt_nonoutstanding_msg; //pointer to TX nonoutstanding message
   AocMsgStruc_t  *pt_outstanding_msg; //pointer to possible additional outstanding message
} TxAocHandlerStruc_t;

/* Structure containing RX AOC handler variables */
typedef struct {
   uint8 uc_outstanding_msg_count;  /* outstanding message count */
   AocMsgStruc_t  *pt_current_msg;  /* pointer to the current RX outstanding message */
} RxAocHandlerStruct_t;

typedef struct {
   uint8 uca_msg_body[AOC_MAX_MSG_LENGTH]; /* message body buffer */
   uint8 uc_SuperframeCount;           /* super frame number after which  */
                                 /* bit swap takes place */
} BitSwapInfoStruc_t;


#endif /* _AOC_H */
