/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   BERT.H
 *
 *   Description:  definitions for soft BERT funtionality
 *
 *------------------------------------------------------------------------
 */

#ifndef _BERT_H
#define _BERT_H

/**********************************************************************
 * STRUCTURES
 **********************************************************************/
typedef struct {
    uint16  *us_patt_ptr;       /* pointer to start of BERT sequence */
    int16    s_patt_cnt;         /* offset to next byte of BERT sequence       */
    int16    s_patt_len;         /* # bytes in BERT sequence */
    uint32  ul_bit_err_rt;      /* (1 / error insert rate), 0 = no insert */
    uint32  ul_bit_err_cnt;     /* # bits since last error */

} TXBERTDEF;

typedef struct {
    uint16  *us_patt_ptr;       /* pointer to start of BERT sequence */
    int16    s_patt_cnt;         /* offset to next byte of sequence */
    int16    s_patt_len;         /* # bytes in BERT sequence */
    uint32  ul_num_bit_errs;    /* # bit errors received */
    uint32  ul_num_sframes;     /* # of complete super frames received */
    int16   s_num_frames;       /* # of frames in current super frame */
    int16   s_num_bytes;        /* # of bytes per frame */
    int16    s_pattern_sync;     /*  = TRUE if rx synchronized w/ BERT pattern */
    int16   s_num_err_bytes;    /* consecutive recieved bytes w/ errors */
    uint32  ul_candidate;       /* memory of rx data used during pattern sync */


} RXBERTDEF;

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#define FIREBIRD_511 0                    /*  Fireberd 511 PN sequence */
#define PN512        1                    /*  PN512 PN sequence */
#define PN64         2                    /*  PN64 PN sequence */

/**********************************************************************
 * MACRO FOR ENABLING BERT DATA FILE GENERATION FOR BIS
 **********************************************************************/
//#define DEBUG_BIS  1
extern void WriteTxBERTDataToFile(int16, uint8*, int16);
extern void ReadRxBERTDataToFile(int16, uint8*, int16);

/**********************************************************************
 * FUNCTION PROTOTYPES
 **********************************************************************/

/* === rx_bert.c ===// */
extern void Init_Rx_Bert(RXBERTDEF*, int16);
extern void Rx_BERT_PN(RXBERTDEF*, uint8*, int16);

/* New BERT code */
/* Functions for getting the PN sequence from the RX frame buffer in the task layer */
extern void RxBERTSetup(void);
extern void RxPNSequenceSetup(void);
extern void RxPNSequence(void);

/* === tx_bert.c ===// */
extern void Init_Tx_Bert(TXBERTDEF*, int16, uint32);
extern void Tx_BERT_PN(TXBERTDEF*, uint8*, int16);

/* New BERT code */
/* Functions for loading the PN sequence into the TX frame buffer in the task layer */
extern void TxBERTSetup(void);
extern void TxPNSequenceSetup(void);
extern void TxPNSequence(void);

/**********************************************************************
 * GLOBAL VARIABLES
 **********************************************************************/

extern int16 gsa_BERT_ErrorTable[256];
extern uint16  gusa_Fireberd511[32];
extern TXBERTDEF gta_TxBertStat[NUM_US_BEARER_CHANNELS];    /* Tx BERT states (in a structure) */
extern RXBERTDEF gta_RxBertStat[NUM_DS_BEARER_CHANNELS];    /* Rx BERT states (in a structure) */
extern int16 gs_do_bert;
extern int16 gs_bert_sf_cnt;

extern uint8 guc_BERT_DELAY;

#endif /* _BERT_H */

