/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _BITLOAD_H
#define _BITLOAD_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             bitload.h
 * DESCRIPTION:      Header file for doing bit loading.
 *
 **********************************************************************/

#include "typedef.h"
#include "config.h"
#include "const.h"

/**********************************************************************
 * VARIABLES
 **********************************************************************/
extern int16 gs_TotalBitsSupported;                /* total no. of bits supported */

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

void AddCodingGainToSnr(int16 *psa_SnrInBuf, int16 s_CodingGain, int16 *psa_SnrOutBuf, int16 s_path);

FlagT AllocFixedRates(int16 s_GainsEnabled, int16 s_BitsToAllocate, int16 s_MaxBits, uint8 *psa_RxBat, int16 s_RxExtraBits, uint16 *pus_ncloaded);

int16 FindChWithSmallestMargin(int16 s_min_bits_per_tone);
int16 FindChWithLargestMargin(int16 s_min_bits_per_tone);
void CalcMarginsAndGains(int16 s_GainsEnabled, uint8 *psa_RxBat, int16 *psa_RxFineGains, int16 *ps_RxAvMargin, int16 *ps_RxAvFineGain, int16 *ps_RxMinMargin);
int16 GetCodingGain(int16 s_R);
int16 GetCodingGain_BIS(int16 s_R, int16 s_D);

#endif /* _BITLOAD_H */


