/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _BITLOAD2_H
#define _BITLOAD2_H

#include "typedef.h"

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             bitload2.h
 * DESCRIPTION:      Header file including the subset of bitloading functions
 *                   required during FR.
 *
 **********************************************************************/

int16 FindChWithLargestFGain(void);

FlagT InitBitloading(int16 s_path);

void OffsetSNRRequired(int16 Margin, int16* psa_SNRRequired);

int16 ChooseFineGains_BIS(uint8 *psa_RxBat, int16 *psa_RxFineGains, int32 *pl_SumFGainLinSq, int32 *pl_SumGiSqTssiSq, int16 s_MaxLp, int16 s_Flag_NoBatCh, int16 s_path) ;

FlagT AllocateBiGi_desiredLp_Bis(int16 s_GainsEnabled, uint8 *psa_RxBat, int16 s_MaxBits, int32 l_SumFineGaindB, int32 *pl_SumFGainLinSq ,int32 *pl_SumGiSqTssiSq, int16 *psa_RxFineGains, int16 *ps_RxExtraBits, uint16 *pus_ncloaded,  int16 s_TargetLp, int16 s_path);
int16 ChooseFineGains_DMT(uint8 *psa_RxBat, int16 *psa_RxFineGains, int32 *pl_SumFineGainsdB, int16 us_ncloaded);

int16 CalcMaxBits(int16 s_GainsEnabled, uint8 *psa_RxBat, int16 *psa_RxFineGains, int16 *ps_RxExtraBits, uint16 *pus_ncloaded, int16 *ps_RxAvFineGain, int16 s_TargetLp, int16 s_path);

int16 IncreaseBAT(int16 s_GainsEnabled, uint8 *psa_RxBat, int16 *psa_RxFineGains, int16 *ps_RxExtraBits, uint16 *pus_ncloaded, int16 *ps_RxAvFineGain, int16 s_finalLp);
void CalcAvgSnrMargin(int16 s_FirstTone, int16 s_LastTone, int16 *psa_SnrBuf, uint8 *psa_RxBat, int16 *psa_RxFineGains, int16 *ps_RxAvMargin, int16 *ps_RxMinMargin);
void AddTwoCGToSnr(int16 *psa_CodingGain, int16 *psa_RxToneOrder, int16 *psa_InputSnrBuf, int16 *psa_OutputSnrBuf);
int16 QuickAverage(int32 l_numerator, int16 s_denominator);
int16 ComputeMarginPerTone(int16 s_SNR, int16 s_BitAlloc, int16 s_FineGain, int16 *ps_RxChannelsAllocated);
int16 CalcAvgMargin(void);
void  ComputeSumFGainLinSq(uint16 *pus_ncloaded, int32 *pl_SumFGainLinSq, int32 *pl_SumGiSqTssiSq);
void AdjustTcmCodingGains(int16 s_R);
int16 Reduce1bitDMT( int16 *s_DeltaSumbi, uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 *pus_ncloaded,int16  *psa_SNRBuffer,int16 s_MinBitsPerToneToConsider, RxToneFlags p_ActiveTones_ToConsider, RxToneFlags p_ModifiedTones);
#endif
