/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _BITLOAD_CONST_H
#define _BITLOAD_CONST_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             bitload_const.h
 * DESCRIPTION:      Header file containing constants and macros related to bitloading.
 *
 **********************************************************************/
// ******************************************************************
// bitload_const.h
//
// History
// 20/08/2010  Sriram Shastry. Looplength definition for 3kft and 5kft
//                     Grep for SMS00801609 PERF_DS_Plus_BDCM_CGainCheating5T1
//*******************************************************************

#define LARGEST_MARGIN  (0)
#define SMALLEST_MARGIN (1)

#define NEG_INFINITY_DB ((int16) 0x8000)  // Actually -128dB in 8.8dB format, but used to represent log(0).  Inverse log of this value shoudl be 0.

// Macros for manipulating the RxToneFlags datatype
#define SETTONEFLAG(ToneFlagArray, ToneIndex)      ToneFlagArray[(ToneIndex)>>3] |= 1 << ((ToneIndex)&0x7)
#define CLEARTONEFLAG(ToneFlagArray, ToneIndex)    ToneFlagArray[(ToneIndex)>>3] &= ~(1 << ((ToneIndex)&0x7))
#define ORTONEFLAG(ToneFlagArray, ToneIndex, Flag) ToneFlagArray[(ToneIndex)>>3] |= ((Flag) << ((ToneIndex)&0x7))
#define IS_TONEFLAGSET(ToneFlagArray, ToneIndex)   ((ToneFlagArray[(ToneIndex)>>3] >> ((ToneIndex)&0x7)) & 0x1)

// Return codes for ChangeBat functions
#define CHGBAT_RETCODE_VIOLATES_MARGIN 1
#define CHGBAT_RETCODE_CANT_CHANGE_LP  2

#endif /* _BITLOAD_CONST_H */


