/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _BITLOAD_DMT_H
#define _BITLOAD_DMT_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             bitload_dmt.h
 * DESCRIPTION:      Header file for doing DMT bit loading.
 *
 **********************************************************************/

#include "typedef.h"
#include "config.h"
#include "const.h"

/**********************************************************************
 * VARIABLES
 **********************************************************************/
extern int16 gs_RxMinMargin;                    /* minimum SNR margin in Q8.8 */
extern int16 gs_RxAvFineGain;                   /* average fine gain in Q8.8  */

/* the following rate option variables may be reconfigured by high layer application */
extern uint16 gus_RS_Overhead;

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
void SelectRateOptionForRMsgRA(void);
BkgdFunction SelectRateOptionForRMsg2;
FlagT VerifyRateWithOneCG(int16 s_TotalBytes, int16 s_CodingGain, int16 s_path);
int16 CalcCheckSum(uint16 s_InputValue, uint16 s_MaxValue);
BkgdFunction BgMedleyBitload;

#endif /* _BITLOAD_DMT_H */


