/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CMV_H
#define _CMV_H
/*******************************************************************************
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: cmv.h
*
*  CMV address and bit field definitions
*
*******************************************************************************/
// ******************************************************************
// cmv.h
//
// History
//
// 19/04/2010 Nihar: For debugging purposes it's very helpfull to have information
//            about the previous exception state/code available. So, put previous
//            Exc.Code/State into persistent memory and map it to CMVs
//            cr STAT 22 0 -> Prev. Exception State
//            cr STAT 23 0 -> Prev. Exception Code
//            Grep for Feature_ALL_ALL_ALL_PrevExceptionsCMV
//
// 22/04/2010 Nihar: Low US performance on long loops with Ericsson 312 (BRCM based)
//                    On long white-noise loops the US performance is too low because of echo effects
//                    Increase US performance by blacking out DS tones on long loops
//                    use gs_PGA_required_In_RCComb1 for loop-length estimation (as G.HS estimation not
//                    yet implemented)
//                    Unfortunately this estimation works only if no ISDN noise is present on CPE side
//                    DTAG is currently testing without ISDN noise
//                    loop length:                           1500 1700 1800 1900 2000 2500 3000 3500 4000
//                    gs_PGA_required_In_RCComb1 (ISDN off):   1B   1E   21   21   24   2A   30   39   3C
//                    gs_PGA_required_In_RCComb1 (ISDN on):    1B   1E   21   21   21   21   21   21   21
//             By default, the fix is enabled based on vendor & vendor specific information
//             To disable it, reset bit 9 of OPTN 25 0
//                    Grep for IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout
//
// 31/05/2010 Nihar :Send "B43" & "J43" activation tones for "AnnexB + AnnexJ" multi mode
//          Grep for Perf_US_ALL_MultiTone_Activation
//
// 31/05/2010 Nihar: In Annex J, if mask upto tone 60 or less is selected then DS start tone
//             changed to 61. This feature enabled (default) by CMV info 103 1 bit 12.
//             Grep for Feature_US_BisPlus_ALL_StartDSFromTone61AnxJ
//
//
// 03/06/2010 Bhadra: CMV INFO 107 is used to know the status of AFE, DFE and 3 GLP interface(VR9)
//                    underflow overflow and not ready condtions.
//                    Grep for "Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status"
//
// 21/06/2010 Bhadra : Added new CMV group "DSL".
//                      Grep for  Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP
//
// 16/07/2010 Sriram/Bhadra : Added new code pointers to support Amendment 3 to G.994.1 for Optional US interleaver depth.
//             OPTN 25 0 Bit-13 (mask: 0x2000) to enable/disable the upstream enhanced framing feature.
//             (acts like a master control switch) (1).   0 = disabled (default) (2).   1 = enabled.
//             CNFG 45 0 ==> Upstream D0 max value supported in CLR message (Allowed values: 2, 6 & 14 R/W).
//                  Default value: 0x8
//             CNFG 45 1 ==> Upstream D0 max value received in CL message for LP0 ( Read Only)
//             Grep for XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//             Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 22/07/2010 Bhadra/Vinjam Srinivas/Palaksha: Code changes to maximise the  DS SNRM instead of INP protection
//             (Min INP will be anyways will be met).
//             The changes includes changing Dp and Rp loops run from Min value to Max value instead of
//             Max to min values for Fixed and Limited rate cases.
//             Allotted a new CMV "INFO 103 20 0x40" to favour DS Margin over DS INP.
//             This change takes into effect only if Bit #6 in cmv INFO 103 20 is Set to 1
//             Grep for XDSLRTFW-139:SMS00839860 PERF_DS_BisPlus_DSmarginIncrease
//                or code pointer "CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE"
//
// 31/7/2010 Nihar: It was seen at FT that the CNXT D57 Dslam was configured to INP = 2.0 but it was only sending
//             this INP in the CL message and not the MS message. Since we use the MS message,
//              we were always training at INP=0.
//              By default, this fix is enabled. To disable it reset bit 8 of INFO 103 1
//              Grep for IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading
//
// 31/7/2010 Nihar: Modification done to reduce US PCB requested by CO by 3 dB in case of CNXT CO & ADSL2+ mode.
//           The fix enabled/Disabled through bit #8(0x100) of cmv INFO 103 0. By Default Disabled
//       Grep for PERF_US_BisPlus_CNXT_Reduce_US_PCB_By_3_dB
//
//
// 22/07/2010 Nihar: Limit DS PCB to 6 dB for short loops in presence
//                   of strong noise. Grep for PERF_DS_BisPlus_CNXT_LimitDSPCB
//
// 22/07/2010 Nihar: Move the Tx power boost by 1dB from R-Quiet1 Tx to R-Reverb1 Tx
//              only against CNXT COs as they were giving more PCB otherwise. For
//                   all other COs, it stays here. To enable it for CNXT, cw INFO 103 0 0x4
//                   Grep for PERF_US_ALL_ALL_TxPwrBoost1dB
//
// 26/07/2010 Nihar: Logic to add extra DS PCB to boost the DS data rate
//                   for short loops in Plus mode. All hashdefines/constants
//                   used as part of this logic are derived from experimentation results.
//                   By default its disabled. To enable it cw INFO 103 1 0x0040
//                   Grep for PERF_DS_PLUS_ALL_GeneralizedPcb
//
// 05/08/2010 Nihar : Added cmv bit3 for Erasure decoding reporting feature with the new CMV group "DSL"
//             Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 26/07/10  Bhadra/Kannan: Added extra defines for Unity TDQ
//                    Grep for "PERF_DS_Bis_CNXT_ForceUnityTDQ" to check the changes.
//
// 26/07/2010 ChihWen/Palaksha/Bhadra: In Huawei lab against a CNXT CO (H33EADB, B02D111/D57.1.10),
//       Xtalk-like noise will make CPE falsely detect C-Tone, and fail later in handshaking.
//       Here we increase tone detect scale from 3 to 8 in handshaking.And force to DMT mode
//       or T1413 mode when measured power in RCGlaf1 is lower than 21dB when against
//       CNXT CO (version number = 0x07 or 0x0b).
//       This fix is controlled by Bit#8 (0x0100) of CMV OPTN 25 0 (0 = feature disabled 1 = feature enabled)
//       Grep for SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop
//
// 27/07/2010 Nihar/Bhadra: CMV defined to Send TI (TSTC) vendor-id when
//                   connecting against CNXT in ADSL1 mode after a reboot for better DS performance.
//                   This is based on CMV INFO 103 1 0x0200(bit 9)
//                   Grep for IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid
//
// 10/08/2010 Hanyu/Bhadra: Added cmv bit to disable RS coding for CNXT/D57/E67 in ADSL2/2+ INP=0/Delay=2ms.
//                   By default, its enabled. To disable this, cw INFO 103 0 0x0080
//                   Grep for SMS00768526 IOP_DS_BisPlus_CNXT_D57E67_RS_INP0DELAY2MS or
//                   SMS00815166 IOP_DS_BisPlus_CNXT_FramingLimitation
//
// 11/08/2010 Hanyu/Bhadra: Added a cmv bit2 of INFO 103 20 to enable the C-Pilot1 detection fix
//                    with UT900CNXT/D57/Rev7 DSLAM at Netcom.
//                    By default, this fix is disabled. To enable it cw INFO 103 20 0x0004
//                    Grep for SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det
//
// 11/08/2010 Nihar/Bhadra: Its found that against Conexant E67 & D79 firmware versions in T1.413 mode
//            needs US pilot tone, but the CPE firmware by default only sends this on the
//            Sync frames. This leads to link drop immediately after reaching Showtime.
//            The fix is 'not' to send zero gain on the US pilot tone (16) in T1.413 mode
//            against Conexant CO. This fix is CMV controlled, and can be disabled by
//          cw INFO 103 0 0x1000
//            Grep for IOP_T1413_CNXT_SendValidGainOnUSPilot
//
// 12/08/2010 AdeelJ/Sriram/Bhadra: To use the existing SRA code for 1 step SRA based on CMV
//           INFO 103 20 bit mask 0x0001.The SRA step size is increased
//           to maximum if this cmv is set.
//             In this file we conditionally bypass framing check for one step SRA.
//             Grep for SMS01221899 Feature_DS_All_All_EnableOneStepSRA
//
// 19/08/2010 AdeelJ/Palaksh/Bhadra: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               define bit position for Interop cmv CMV_TO_ENABLE_CNXT_US_RateImprovement
//               Bit#13(Mask0x2000) of  CMV INFO 103 20 used to enable/Disable US performance enhancement fix.
//             By Default Fix will be OFF(Bit will ZERO)
//               Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 25/08/2010 Nihar: Added Noise for Tx Medley to Alcatel ADLT-J STM FG10 CO
//                    to avoid aggressive US Bit loading and to Improve the
//                    US Margin. By default, its enabled. To disable it,
//                    set bit 3 of INFO 103 0.
//                    Grep for IOP_US_DMT_ALCATEL_AddNoiseToTxMedleyToImproveUsMargin
//
// 25/08/2010 Nihar: Enhance DS Data rate in 5T1 Noise loops for Alcatel CO's in DMT mode
//                    using Noise Margin Separation Calculation. By default, its enabled.
//                    To disable it, set bit 10 of INFO 103 0
//                    grep for PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate.
//
// 06/10/2010 Bhadra/AdeelJ: Modified Reverb and MEDLEY SNR calculation so that it does not discard
//             REIN affected frames if a cmv info 103 23: bitmask 0x0020 is set. i.e. the functionality is
//             reverted to the older one without REIN detection. This will cause lower
//             data rates in presence of REIN, but still higher than specified in TR-100
//             REIN noise tests. The positive aspect is that we dont have to worry about
//             maintaining margin in Showtime. This cmv is specific for FT like scenarios where
//             the DS margin was going low to an unacceptable level in presence of REIN noise.
//             In this file the bitmask for cmv info 103 23:0x0020 is defined.
//        Grep for SMS01501984 SMS01294435 Feature_DS_BisPlus_ALL_DisableTrainingREINDetection
//
// 06/10/2010 Bhadra:   Add   0.2dB more DS margin to pass margin verification tests at FT based on
//                      bit 7 of CMV INFO 103 1 ie(0x0080). By default this CMV is disabled.
//                      Grep for "PERF_US_ALLannexA_New_FTspeciffic "
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 22/03/2011 Vinjam: Added "ARX208" support through DSL CMV.
//            Grep for XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// 24/06/2011 Kannan: Noise margin separation changes for BT loops, Added 2dB NMSA for BT >= 700ft.
//                    These changes are taken from Danube.
//                   Grep for XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA
//
// 09/08/2011 Vinjam: Added new bitfields for "LOM", "OOS" & "ESE" in "CMV PLAM 0 0" (as per VR9 message spec).
//                    Also added hash defines for "System error codes" & 'Sub Error Codes" for
//                    near-end failures in show time (as per VR9 message specification).
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 18/04/2011 Sriram: Use the special TSSI set to improve the US rates against CNXT DSLAMs with FW version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 30/8/2011 Vinjam: Integrated "DSL_PPE_CLOCK_CONTROL" code from VR9 VDSL2 code (544316)
//          Add PPE clock change CMV as DSL 15. Bits 0:1 are the new clock setting,
//           Bit 4 is a trigger bit that will be cleared by FW after the register write is done.
//           Grep for XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL
//
// 06/9/2011 Vinjam: Added a new CMV bit to PLAM 0 0 Bit-14 (mask: 0x4000) to indicate "LOS due to burst of DS CRC"
//           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 06/09/2011 Vinjam: Added a new Sub error code "SUB_ERROR_CODE_EXCESS_DOWNSTREAM_CRC_ERRORS" to indicate link drop
//            due to excess downstream CRC errors.
//            Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 06/9/2011 Vinjam: Added new CMV bits to "TEST 29" to suppress failure reporting of "ES90", "SES30", "ESE", "OOS" & "LOF" to ME
//           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
//  19/09/2011 Sriram Shastry : Disable Power Management L2,L3 mode, Seamless rate adaptation ( US & DS direction) as a part of R43. delivery
//             This is done as per project management requirement. They are only check box feature for R4.3 release. SRA & PM L2 mode
//             features are functionally not verified.
//
//    Grep for :   IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode

// 28/09/2011 Raghu : XDSLRTFW-316  PLL BW is changed based on SNR during Medley.
//                    This change in the bandwidth helps to reduce the DS CRC
//                    caused glitches introduced by TX SRC.
//                    Grep : XDSLRTFW-316
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 23/09/2011 Kannan: Added a CMV bit to Bypass single Lp reduction bit during bitswap
//                    against CNXT CO.
//                   Grep for XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
//
// 27/09/2011 Kannan: Added 2 CMV bits (Bit10 & 9 of into 103 27) for LpReduction to do the bitswap
//                    in plus mode against CNXT CO.
//                   Grep for XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
//
// 09/11/2011 Shakil/Bhadra: Downshift SRA was not performed due to Max Delay constraints. In certain interleaved
//             profiles LQ CPE trains with maximum Delay. When Downshift SRA is triggered line rate (Lp)
//             cannot decrease anymore as it will violate the max delay according to the following equations.
//             Sp = 8*NFEC/Lp
//             Delay = Sp*Dp/4 ms
//             proposed solution is to detect such cases after the first framing calculation and recalculate
//             the framing to incorporate the Downshift SRA into account so that we do not violate the delay
//             constraints after SRA completes. This algorithm is trigerred only if SRA is enabled and
//             max_delay > 1 ms (interleaved profile)
//             Grep for ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved
//

// 09/11/2011 ChihWen/Bhadra: The fix for "ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved":
//       1. The orginal code will start the searching (for max delta_Lp) from 2880, which will take very long time
//          to find the max delta_Lp and fail the training. The maximum allowed starting point (for max delta_Lp)
//          is set to 2000, which will take about 15384 symbols (from 12642 to 28026).
//       2. Considering the max_Lp (Lp + max_delta_Lp) and min_Lp (Lp - min_delta_Lp) before requesting SRA.
//       3. The searching for SRA will be enabled when it is BDCM CO or INFO 103 26 bitmask(0x0400) being one (it is zero by default).
//       Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 17/11/11 ChihWen/Bhadra: SRA fail against CNXT Annex-A LC (FW E67.1.64). To fix it,
//                => send GHS non-standard info in CLR as AR7 (FW 7.04.03) when against CNXT Annex-A LC.
//                => do not send spectrum bound/shaping when against CNXT Annex-A LC
//             By default, its disabled. To enable it, cw INFO 103 1 0x4000
//             Grep for SMS00805497 IOP_DS_BisPlus_CNXT_SRAFailGhsNonStandard
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Added new microstate STAT and CMV INFO 121 structure for NLNF measurement.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect
//
// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//       for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
// 15/12/2011 Balabath: Use gs_hsk_tone_pwr_dB to estimate loop length.
//            Grep for XDSLRTFW-366 FEATURE_ALL_DS_ALL_LoopEstimate_HSK_POWER
//
//04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380 Feature_US_BisPlus_All_USSRA_CMVRemap
//
// 21/02/2012 Balabath:Too low DS Rate and too high DS SNRM in the SingTel
//            SRA Profile / ADSL2+ Mode / Huawei MA5600 / H568ADGG / BDCM Line card.
//            The reason for this is this DSLAM doesn't support extended interleaverdepths and 1/S0min is received
//            as 3. with SRA profiles and sraoffset set to 14 dB, and gs_deltaLp_max = 2400 as input
//            the framing parameters computed results very low Lp becasue of delay(1/S0min) constraints.
//             Similar behaviour is observed with other DSLAMs also in SRA profiles with cmv info 26 bit10(0x400)
//             and 1/S0min as 3 The solution is to force 1/S0min to 4 which results much higher Lp while entering showtime
//            And the meets 1/S0min constraints also.For results check the JIRA XDSLRTFW-422
//             Risk: CRC's may be observed becasue of 1/S0min voilations if HW support is not there in DSLAMs.
//           For code changes grep for XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min
//
//  22/12/2011 AdeelJ/Balabath: Fix for "DS CRCs in Sparnex Long Loops at Telefonica"
//          DS CRCs observed in loop reach tests at long loops
//          In this file we check the looplength and increase the margin correction
//            in order to compensate for the loss of Data Rate incurred by increasing the
//            DS INP.
//              DS INP was increased to 1 in these cases as it was observed that the noise
//            causing CRCs has impulse like behavior.
//            This Change is protected by mode (ADSL2+) Annex (A), loop >= 2300m
//            and cmv (INFO 26 0 :0x0020)
//            In future check should be added for Sparnex Simulator
//          Grep for ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs
//
// 12/12/2011 Vinjam/Kannan: STAT cmv added to read the Selected Annex M/J mask in the
//        Tx direction. Integarted code changes to VR9 R4.3 ADSL Firmware.
//       Grep for "XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask".
//
// 12/12/2011 Vinjam: CMV controls to enable/disable upstream enhanced framing feature moved to DSL 13 Bit-1 (Mask: 0x0002)
//        Grep for XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup
// 12/01/2012 Kannan: Added CMV bit in "INFO 103 27" Bit14 & 15 (0xC000) to enable/disable
//            64pt IFFT emulation for TI & CNXT in T1413 mode. It is enabled by default.
//            Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
//
//12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero.
//                Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                   0: disabled (default)
//                   1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                   0 -> GHS Activation startup (Default)
//                   1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
// 31/01/2012 Vinjam: CMV Remap for "HERC OPTN 15 0" to "SOC OPTN 2 0" for
//            enabling/disabling US BitSwap & DS BitSwap
//            Grep for XDSLRTFW-395 Feature_All_All_All_BitSwap_CMVRemap
//
//    20/01/2012 Shakil: T1413 indication value (cr stat 0 0 -> 11) was wrong for VR9 since this value is already used
//       in VDSL. Therefore the proposed value was 14 instread of 11
//       For code changes grep for XDSLRTFW-385 Bug_T1413_Indication_valueChanged
//
// 30/01/2012 Raghu: Add margin fudge of 1dB to increase the DS data rates to meet
//          telefonica requirements. This is controlled by CMV info 103 27 bit13(0x2000).
//          and will be enabled for CNXT /IKANOS DSLAMs for above 9kft. For code changes
//          Grep for   XDSLRTFW-383 Enh_DS_ADSL2_CNXTIKNS_DSRate
//
// 02/02/2012 Sabrina/Balabath: It's seen in the field that AR9 has quite low DS
//            rates compared to AR7 with the ABLT-D BRCM DSLAM. Looks like
//            the CO sends out a low MAXNOMATP (-3dB) in GHS. We use this
//            parameter as a constrain during bitloading. Therefore, the
//            finegains are all -2.5dB on the tones with bits loaded and
//            the DS rate is low. By checking the AR7 code, it's not using
//            this parameter at all. In order to improve the DS performance,
//            the workaround is to set his parameter to 0 against BRCM
//            in ADSL2+ mode. This feature is CMV protected.
//            info 103 26 0x010 Disabled by default
//            Grep for XDSLRTFW-406  IOP_A_DS_Plus_BRCM_Set_MAXNOMATP_ToZero
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 17/02/2012 Kannan: Aux Pilot SNR threshold is CMV controlled and is reduced from 16dB to
//            10dB to make it work on long 24DSL 16kft and FSAN Class B noise case at 3250m.
//            Grep for Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold
//
// 23/02/2012 Sriram Shastry : Disable PLL bandwidth to reduce DS CRC for 24DSL noise CPE margin verification test.It was observed that if
//      RxAvgmargin drops from 3.5 dB to 2.5 dB , we see Burst of DS CRC's  as a result Sync is Lost.
//      Grep for : Enhc_DS_ALL_ALL_ByPassPLLBWIncrease
//
// Raghu:INP = 8 REIN Test Failure against some DSLAMs only with 60pps impulse rate.
//    New procedure is uesd for choosing the tones used for Sync symbol detection in Showtime.
//    a) We avoid consecutive tones to be used for detection. We go for block interleave type of tone selection and the depth 8 tones
//    b) Try to choose tones with more than 12 bit allocation in the first iteration.  Next iteration reduce the bit allocation threshold by 2
//    Step a & b are done till number of tones needed for Reverb Segue detection is completed
//    For Code changes grep for "XDSLRTFW-374 (ADSLRTFW-1361): IOP_DS_PLUS_FR_TelefonicaOnSite_INP_REIN_Tests (start)"
//
// 21/12/2011 Raghu:Stress test (FT stress test) has a marginal fail (1.07 e-07 instead of 1.0 e-07) on the
//                      Lucent Stinger linecard A2P72-HBI.
//                      1) Increase number of frames used for SNR averaging from 512 to 2048 When the margin
//                      goes below 2dB.
//                      2) Block size used for updating SNR and FDQ are inreased from 32 to 48 to reduces the
//                      response time which got increased due to increase in the frames used for averaging.
//                      Currently this is enabled only for CNXT DSLAMS.
//                      For code changes grep for XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 04/06/2012 Shakil: New feature implemented where we detect REIN noise at training and change framing
//          accordingly taking erasure decoding into account to increase stability in presence of REIN
//          even if the minINP exchanged during GSK was not enough to sustain the REIN. The background
//          of this feature was a test requirement from FT EMC lab at Laneon where the minINP and maxdelay
//          configured was 2 and 16ms respectively whereas REIN in the line was 4-5 DMT symbol duration.
//          In the regular condition considering erasure we may protect maximum 3 DMT symbol REIN therefore
//          resulting huge DS CRCs and link drop. With the new feature we could dynamically detect REIN at
//          CSilent1 state during handshake and increase the INP taking erasure into account while cap the
//          delay maximum to 8 ms and achieved CRC free stable link without sacrifising too much data rate
//          since we also ignore REIN affected symbols before bitloading and medley SNR calculation.There are
//          two parts of the implmentation
//          1. Detect REIN during GSK and adapt framing  prior to bitloading at Medley. It is controlled by
//                INFO 103 28 bitmask 0x200 and disabled by default (bitmask 0x200-> 0 disabled, 1 enabled)
//          2. Ignore REIN affected symbols for bitloading: No CMV controlled. Enabled by default
//          Grep for XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING
//
//
// 14/06/2012 Kannan:
//          1. Added ReTx Structure into the CMV.
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 07/06/2012 Vinjam: Added a new CMV "INFO 114" to point to the downstream virtual noise break points.
//       CMV to control Downstream virtual noise feature is "DSL 0 Bit-0".
//                   Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// 21/06/2012 Raghu M Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//                Default use new algorithm to decide on discard frame.
//
// 26/06/2012 Ram: Added code for mapping of ReTX Status counters to CMV CNTR 43,44 and
//                 CMV RATE 2
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 04/07/2012 Vinjam: Code pointers to enable/disable PM L2 using HERC CMV MONI 4 0 0x100
//                   PM L2 enable "HERC MONI 4 0 Bit-8" is remapped to "SOC OPTN    15 0 Bit-9 (inverted logic)"
//                   Grep for XDSLRTFW-403: Enhancement_ALL_BisPLus_ALL_L2_HercCMVreMap
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
//
//
// 31/07/2012 Sriram Shastry : Allow API to write to Herc cmv CNTR for near end performance monitoring counter
// like, ecs,es,ses,los,crc & fec.
//          CMV setting : DSL 13 0 bit Maks 8, Disabled by default ( 0= disabled ,1 = Enabled )
//             Grep for : XDSLRTFW-425 IOP_ALL_DS_ALL_NECNTR_CMVWrite
// 04/07/2012 Anantha: Added new CMV bits to "TEST 29" to suppress failure reporting of LCD and NCD to ME
//                MONI_LCD_FAILURE_BC0 and BC1 definition changed to make consistent with CMV doccument
////           Cleaned up LCD NCD related definition
//             grep pattern XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Trigger
//
// 07/08/2012 Vinjam: Added a CMV "TEST 40 0 0x1" to force upstream fine gains to unity (0x2000) to measure CPE Tx PSD.
//            Grep for XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement
//
// 23/08/2012 Vinjam: Added a structure "gt_InteropOptions" for Interop bits common to ADSL/VDSL, attached to "CMV DSL 19"
//            Grep for "XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI"
//
// 29/8/2012 Vinjam: Changed CMV (from "TEST 40 0 0x1" to "TEST 28 0 0x2") to force upstream fine gains to unity
//            CMV is changed to keep it same across ARx & VRx platforms.
//            Grep for XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement
//
// 07/9/2012 Vinjam: Renamed "CMV_TO_SUPPRESS_HercCNTRtoSOCPLAM_SWWRITEOPTION" to "CMV_TO_SUPPRESS_CRC_FEC_WriteBackOption".
//                   Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 17/09/2012 Ram: Added code to support the foll CMVs
//                 "CNFG 80" -> Enable/Disable ReTx mode during G.HS
//                 "INFO 229" -> ReTx DS Showtime Status: ReTx On/OFF
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229"
//
// 18/9/2012 Vinjam: CMV to control the "CRC/FEC counter write-back" is changed to DSL 22
//           Reason: DSL 19 is already reserved for "ADSL_Feature_Map" as per VR9 Message Specification (CMD_ADSL_FeatureMapGet).
//           Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 24/12/2012 ChihWen/Vinjam: Integration of R3.5 dying Gasp code changes to R5.2.
//            Overwrite one time the Tx IB FIFO with LPR indication when dying gasp event is happening (GPIO pin 15), so that the LPR will be indicated
//       in the next US OHC frame. The reason for doing so was that there could be one OHC frame delay between the dying gasp event and
//       the time when Tx IB FIFO was empty. This delay would cause one OHC frame later for indicating LPR.
//             Grep for XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR
//
// 24/12/2012 Vinjam: Change in CMV. CMV_TO_ENABLE_LINK_DROP_FOR_DYING_GASP is moved from "OPTN 25 0 0x4000" to "OPTN 16 0 0x0001"
//       Grep for XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR
//
// 08/11/2012 Anantha: Test CMV to control bitswap improvement changes
//                   Grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
// 03/09/2012 Anantha:  Added definition to fetch T1413 vendor id and revision num through INFO CMV.
//              changed INFO CMV pointer array ize
//          Grep pattern XDSLRTFW-496: Feature_T1413_Info
//
// 28/12/2012 Mahesh: Updated with latest msg cat ver 1.9 for L2 Amd 4 changes.
//          Grep for XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4
//
// 07/01/2013 Ram: Added fix for JIRA 459. Implementing 'CMV CNTR 51'
//                Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// 10/01/2013 Vinjam: Relocated "SOC OPTN 25" CMVs to "SOC OPTN 33" &
//            Added a new CMV "OPTN 33 0 0x0400" to Fix an issue with C-TREF1 detection in long loops
//            Reason: As per VRx message spec, "OPTN 25" is reserved for "Polling" far-end counters
//            Grep for XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33
//
// 16/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by FW
//                 Added a new variable to implement CMV 'DSL 19' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 04/02/2013 Sooraj: Added Support for CMV "OPTN 25" to control EOC polling.
//            Grep for XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Inturn, "enale/disable" of "optional upstream interleaver depth" feature is moved to "CMV CNFG 46".
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
//            Also grep for XDSLRTFW-699 XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth
//
// 07/02/2013 Vinjam: Selection of B43/J43 tone set is moved from "CMV INFO 103 1 0x02000" to "CMV CNFG 45"
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 07/02/2013 Vinjam: Send "Vector" code pointer in "VDSL2 code pointers" in ADSL G.Hs Short CLR Message.
//            Vector feature is enabled using "CMV CNFG 82". If enabled, then set "SPAR2 OCTET2 Bit-3(0x8)" & NPAR3 OCTET1 Bit-0(0x1).
//            Grep for XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs
//
// 20/2/2013 Vinjam : Changed "CNFG_0_SIZE" from "28" to "22" to get some free space in BULK_DATA_RAM_DMSWAP.
//           As per VRx Msg Spec, "CMV CNFG 0" has only 18 elements. Firmware implementation has some holes. So allottted "22".
//           Memory optimization changes are done during XDSLRTFW-731 FIX_All_All_All_EnableBitSwapsAsPerVRxMsgSpec (Start_End)
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//                 Added a new variable to implement CMV 'DSL 20' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 27/02/2013 Mahesh: Added crystal drive changes for Jira - XDSLRTFW -561
//                       new CMV DSL 25 added & also added placeholder for DSL -23/24
//                       Grep for XDSLRTFW-561 Enhancement_All_All_All_FreqOffset
// 22-04-2012 Anantha: Added test CMV to control enabling disabling of show time pilot tone averaging
//             grep for XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg
//
// 16/05/2013 Anantha Ramu : Added code to invoke changes corresponding to XDSLRTFW-336, when Lucent Stinger DSLAM is connected.
//                   Used CMV INFO 103 28 bit 13 to enable the changes
//                           Grep for XDSLRTFW-679 Enhance_US_BisPlus_LucentStinger_US_Rate_Improvement
//
// 24/5/2013 Vinjam: Added mapping of "HERC CMV INFO 85" to "Showtime SNR with out Virtual Noise" and the existing
//                   HERC/SOC CMV INFO 85 (INFO_RX_CLEAR_EOC) is moved to HERC/SOC CMV INFO 130
//                   Grep for XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85
//
// 27/5/2013 Vinjam: Resolve HERC CMV CNFG 17 conflict.
//           As per VRx Message Spec, CNFG 17 is meant for enabling/disabling the bonding, Where as the firmware uses Socrates CMV CNFG 17 for Tx_BPN.
//           To resolve the CMV conflict, CNFG_tx_Cnfg_Bpn is moved to CNFG 47. Also code cleaned up for "HERC CMV CNFG 17.
//            Grep for XDSLRTFW-230 Bug_All_All_All_ResolveCnfg17Conflict
//
// 27/5/2013 Vinjam: Added CMV remap for INFO 221 using Hercules CMV dictionary entry
//            Grep for XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221
//
// 28/5/2013 Vinjam: Incorporated the review comment as per CRXDSLRTFW-24. Increased the size of INFO_221_SIZE to "6" (as per VRx Message Spec)
//            Grep for XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221
//
// 07/05/2013 Hanyu: Ported ChihWen: To avoid the lower DS sync-up rate against BDCM CO (in some SRA test cases), the searching for maximum gs_deltaLp_max
//                is modified to make DS rate not too much less than the original DS rate (when gs_deltaLp_max = 0).
//                The exact DS rate degradation can be controlled by OPTN 33 0, it is 5 by default, which means at most 5 percent rate degradation.
//            Grep for XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate
//
// 12/06/2013 Balbath: Link drops when there is a change number of 1bit loaded tones after bitswap.
//             Link drops were observed with Annex M mode only, AnnexA cases seems fine
//             Did experiments by disabling one bit tone modifications during bit-swap, and link is stable.
//             Required RX_MIN_ADDR (IR_ACT_ADDRD) programming to be (gs_RxFirstChannel-1) when No. of 1 bit
//             tones are not multiple of 4. With this fix, AnnexM link is stable.
//             Triggering of continuous bitswaps in these profiles: to be decided ?
//             Grep for XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops
//
// 19/06/2013 Anantha Ramu: two members added to the CMV CNTR 43. Hence CNTR_43_SIZE changed from 8 to 12.
//             Grep for XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters.
//
//  19/06/2013 Balabath:Avoid triggering of continuous bitswaps in these profiles: Removed the
//  code changes that overwrites "gs_RxDesiredMargin"(ie., Target Margin).
//    These code changes are moved under CMV OPTN 36 (OPTN_SRA_IOP_BITS 36) bit#2(mask 0x0004)
//  Grep for XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops.
//
// 26/06/2013 Ram: Added new CMV DSL 31 to read G.Hs Handshake Control structure using DCT
//            Grep for XDSLRTFW-361 Enh_All_All_All_GetHandshakeControlInfo
//
// 08/04/2013 ChihWen:
//            Optimize the code for SRA, which are mainly as below.
//            1. Modify gs_MaxRateLp/gs_MinRateLp to be the max/min Lp complying to all framing constraints(including max/min net rate) when framing check is enabled(INFO 103 26 bitmask(0x400)),
//               gs_MaxRateLp/gs_MinRateLp will be the Lp with max/min net rate when framing check is not enabled.
//                2. Combine the framing check in isValidFramingConfiguration and RShowtimeRxF_BIS. The combined framing check will refer to gs_MaxRateLp/gs_MinRateLp.
//                3. Optimize the CMV setting related to SRA.
//                4. Add two CMV to enable/disable the checking for min INP, and max delay when searching delta Lp in training.
//            Grep for XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode
//
//
// 04/12/2013 Sriram Shastry: It  has seen in DTAG lab that due to  Xtalk from neighbouring  line , there is false Ctone detection
//             Fine tuned GHs detection scale factor. cmv OPTN 33 0 bit 13 (0x2000) enabled by default.
//              Grep for :  XDSLRTFW-1402 :IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413
//
// 13/03/2014 Sriram Shastry : Increase US data rate against  BRCM CO for A.1.4.3 24 HDSL NEXT impairment_testprofile AU_RA_L_30000K
//          Grep for XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise
//
// 29/09/2014 ChihWen: Workaround of ignoring MaxDsATP and decreasing 1 dB margin to pass the TR100A AWGN longer loops in Askey lab.
//            Grep for XDSLRTFW-2031 Enhc_A_DS_BisPlus_BRCM_WorkaroundForAskeyLabTesting
//
// 04/01/2015 Anantha Ramu: Added bit 12 to enable PLL fix for uncorrected DTUs.
//            Grep for XDSLRTFW-1223.
//
// 18/11/2014 : Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
//
// 06/02/2015 Vinay : Added CMV DSL 0 Bit#3 (Mask:0x0008) to enable octet 2 of NPar2 of G993.2 in GHs and is enabled by default
//                    Grep for XDSLRTFW-1624
// 06/08/2014 ChihWen: Lower Tx power by 1dB in order to boost DS PSD to increase DS rate on shorter loops in ADSL1 mode against BRCM CO.
//             Grep for XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower
//
// 06/08/2014 ChihWen: Enable noise margin separation against Vinax2 in the case when minINP >= 1, FB noise, and BIS mode.
//             Grep for XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM
//25/03/2014 Sriram Shastry: Changes done for "SMS01261908:Link drop issue during on-hook/off-hook in G.dmt with Catena/Ciena CNX-5 DSLAMs"
//          The fixed includes the following chanages from R3 code
//          1.Disabled Clear EOC indication in CPE G.hs MS for Ciena CO ID CTNW to avoid link drop during phone on-hook/off-hook
//             transitions with a splitter at CPE.
//          2.Reject Clear EOC request from the software(ME) for Catena CO in DMT Mode. This is done to avoid showtime
//             link drop(already there in R4,SMS00825442)
//          3.PLL re-aquisition into ADSL1 Rx C-Reverb3 to train PLL with reference pilot after DEC training state.
//          4.Bug fix in G.dmt only CPE with T1.413 only DSLAM
//             (already there in R4, UTP:SMS00903001)
//        Grep for XDSLRTFW-1658 R4-2 Annex A: SMS00825442 IOP_US_DMT_CATENA_ClearEocWorkaround
//
// 24/03/14 Hanyu: Ported ADSLRTFW-1419: It takes Litespan D4EP, with all ports enabled, ~60s to restart
//            if there is any retrains during training. To meet customer requirements,
//            we made following two changes.
//            1. Took out the unnecessary retrain for all non-CTLM DSLAMs during GHS.
//            2. Added CMV bit-14 of info 103 26 to control the retrain logic for
//            TIVID change with GHS0000 DSLAMs.
//            By default, this CMV is set to 1 (enabled).
//            For LiteSpan D4EP DSLAM with all ports enabled, this bit should be set
//            to 0 to shorten training time after power up.
//            Grep for XDSLRTFW-1590 IOP_A_DS_ALL_ShortenTrainingTime_AfterPowerup
//
// 27/03/14 Hanyu: Ported ADSLRTFW-1416: Added CMV bit-12 of info 103 26 to control the retrain logic for DS
//       performance tuning in TR-67 A.2/EU shor loops < 700m in SMS00822444 / XDSLRTFW-1682.
//       By default, this CMV bit is set to 1 (enabled).
//       For LiteSpan/CTLM DSLAM at AT&T lab, this CMV bit is disabled (0) to shorten training time.
//       Grep for XDSLRTFW-1592 IOP_A_DS_ADSL1_CTLM_AddCMV_TxPowerCut
//
// 31/03/2014 ChihWen: DS rate improvement against Adtran Geminax in DMT mode.
//                To improve the DS rate against Adtran Geminax in DMT mode, the solutions are below.
//                1. When preparing the parameters in R-MsgsRA, search the best R (>= 4) which will achieve highest K (best net rate),
//                   then set K in R-MsgsRA accordingly, but set R = 0, coding gain = 5.5 dB, and loaded tone number by the equation below.
//                   (loaded tone number) = 159 * (codeword size) - 232. This one-order equation is from (codeword size, loaded tone number)
//                   = (245,152) and (104,64). After receiving R-MsgsRA, Adtran Geminax will send C-RatesRA with proper options of R and K,
//                   in which AR9 will select the second or third option.
//                2. Report DS LOS when pilot power < gl_PilotTone_PwrThresh/256 instead of gl_PilotTone_PwrThresh due to link drop by CO.
//            This is controlled by CMV info 103 27 bit5 0x0020 and is disabled by default.
//            1: Enabled
//            0: Disabled (Default)
//                Grep for XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate
// 10/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
//      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
//      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
//      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
//          to avoid US/DS link drop due to polit tone corruption.
//      (3) Limited US max bits/bin to 8.
//      The above changes are protected by PLSE CO vendor ID and CMV
//      info 103 26 0x0800 with default value 0 (Disabled).
//      Enabling the CMV bit may introduce side-effects for both US and DS performance.
//      It is only recommended for AT&T profiles with the capped US/DS lower data rates
//      attached in the Jira entry.
//         Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
// 10/04/2014 Sriram Shastry: To reduce the training time against CNX5, the
//            following two changes are introduced.
//            1. Remove US bounds/TSSI information from long CLR.
//            2. Remove the additional long CLR which is due to the CPE
//               preferred US PSD MASK is not matched with CO in the G.hs
//               Annex L message. When this happends, CPE just takes the
//               information from CL and doesn't need to send back to CO.
//            This is protected by CMV info 103 26 0x100. The default value
//            is 0 (Disabled.)
//            Grep for ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS
//
//
// 10/04/2014 Sriram Shastry: Added the workaround requested by AT&T for their special profile
//                   on Alcatel BRCM DSLAMs (ABLT-D, ABLT-A and EBLT-K)
//                   in T1.413, G.dmt, G.lite and Annex L multimode, i.e.
//                   Multimode CPE needs to disable Annex L on short loops.
//                   This workaround is disabled by default with
//                   CMV bit7 = 0 for INFO 103 26.
//                   To enable it, set bit7 = 1 by cw INFO 103 26 0x0080.
//                   Grep for ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 07/05/2015 Sriram Shastry : Implement  Final Fail  state. Introduced Infinite_loop .  During  this  state, MEI and  PPE will have  no access to  ARC.
//          Grep for  : XDSLRTFW-2186
//
// 25/02/2015 Sriram Shastry : bug in bit-mapping for: STAT_512Bin_QLN_ON and STAT_OISDN_FB_NOISE
//         Grep for  XDSLRTFW-2600
//
// 19/12/2017 Chih-Wen: BER failed in TR100A 12ADSL2p DS FEXT MV test against Lucent Stinger.
//            In this test, new NMS was not kicked in. BER failed with 0.5dB more margin(optn 20 = 0xFF80).
//            BER passed with 1dB more margin(optn 20 = 0xFF00).
//
//            To kick in the fix of adding 1dB margin, the following conditions must be met.
//            1. ADSL2+ AnnexA.
//            2. CNXT CO.
//            3. FB noise is detected where STAT[STAT_Performance] sets "STAT_FBNoise" and "STAT_FBNoiseLowThreshold".
//               This is the case for TR100A 12ADSL2p DS FEXT MV test, TR100E FB RA 250m, 750m, 1250m.
//            4. STAT[STAT_Performance] does not set STAT_M90M100Noise. This is the case for TR100A 12ADSL2p DS FEXT MV test.
//
//            Grep for XDSLRTFW_3663_TR100A_MV_12ADSL2Plus_AddMargin
//
// ***********************************************************************************************************************************************

#include "cmv_data.h"

//==============================================================================
// DSL register address field definitions
//==============================================================================
//Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (START)
//XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (Start_End)
//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (Start_End)
//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start_end)
//XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start_End)
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start_End]
#define DSLMAP_SIZE                39
#define DSL_4_SIZE                 ((sizeof(AFEConfig_t)+1)/2) //XDSLRTFW-3705 (Start_End)

#define DSL_FeaturesControl        0
//DSL 0 : DSL_FeaturesControl =============================================================
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
#define DSL_Enable_DS_VirtualNoise       0x0001   //Enable virtual noise feature in downstream direction
#define DSL_Enable_US_VirtualNoise       0x0002   //Enable virtual noise feature in upstream direction
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

//SMS00147013 Feature_AB_DS_BisPlus_ALL_ShortInit (START)
#define DSL_EnableShortInit              0x0004 // if set, CPE will request Short Init in GHS
//SMS00147013 Feature_AB_DS_BisPlus_ALL_ShortInit (END)

// XDSLRTFW-1624(Start_End)
#define DSL_EnableAELEM                 (0x0008) //XDSLRTFW-2490 (Start_End)

//====================================================================================

#define DSL_EDcontrol              1
//DSL_EDcontrol==========================================================================
//XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
#define ERASURE_DECODING_DISABLE             (0x0000)
#define ERASURE_DECODING_ENABLE              (0x0001)
#define ERASURE_MAX_INP                      (0x0002)
//XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)
#define DSL_Enable_ERASUREDECODING_REPORTING (0x0004) //this bit should not be in use at present
//====================================================================================

#define DSL_PSDcontrol             2
#define DSL_DS_Pilot_Indexes       3
#define DSL_AFE_Reg_ReadWrite      4    //Using DSL_4_Map[] for handling CMV "DSL 4"; //XDSLRTFW-3705 (Start_End)
// XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start)
//#define RESERVED1                  5      //It may be updated whomever using it
#define DSL_LPR_TRIGGER            5
   #define DSL_ModemSendDyingGasp         0x1
// XDSLRTFW-201 Feature_US_ALL_ALL_LPR(end)
#define DSL_ADC_TRIM_READ_WRITE    6      //SMS00972960
#define DSL_STATUS_AFE_DFE_3GLP    7
#define DSL_HYBRID_TYPE          9
#define DSL_LD_MODE              10
//XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (Start_End)
#define DSL_AFE_ChipDetails        11
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (Start)
#ifdef ADSL_BONDING
#define DSL_BONDING_CONTINUE     12
#endif
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (End)
#define DSL_OPTIONS              13
//CMV DSL 13 0 BitMasks (i.e,gt_ApiOptions.us_Opt_Offset0 **************
   //XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup (Start)
   //DSL_OPTIONS 13
   //SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_End)
   #define CMV_TO_ENABLE_US_INLV_DEPTH_STD   0x0002

   //XDSLRTFW-364  Feature_DS_All_All_NLNF_FilterDetect_CMVRemap(start_end))
   //XDSLRTFW-364  Feature_DS_All_All_NLNF_FilterDetect (start_end)
   #define CMV_BIT2_TO_ENABLEE_NLNF_STARTUP           (0x0004)

   //XDSLRTFW-2442 (Start_End)
   #define CMV_TO_ENABLE_XO_LOW_OSC_DRIVE    (0x0008)

//XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup (End)
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
#define DSL_ADSL_HNSK_TC_MODE    14
#define DSL_PPE_CLOCK_CONTROL    15
//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (End)
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap(start)
#define DSL_NLNF_METRICS_IBS        16
#define DSL_LOOPLENGTH_ESTIMATION   17
#define DSL_HYBRID_INFO             18
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap(end)

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
#define DSL_ADSL_FEATURE_MAP        19
#define DSL_VDSL_FEATURE_MAP        20
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)

// XDSLRTFW-1792 (Start_End)
//New CMV 21 used for Operator Select
//0=No operator specific settings (Default)
//1=DTAG;
//2=BT
//3=Telefonica
//4=FT
//5=KPN
#define DSL_OPERATOR_SELECT         21
   //Master Control Bits
   #define NO_OPERATOR     (0)
   #define DTAG            (1)
   #define BT              (2)
   #define TELEFONICA      (3)
   #define FT              (4)
   #define KPN             (5)
   #define TELIASONERA     (6)
   #define FIBER_HOME      (7)
   #define CT              (8)
   #define TW              (9)
   #define VODAFONE        (10)
   #define COMLABS_NORWAY  (11)
   #define OTE_GREECE      (12)
   #define TELMEX          (13) //Telecom Mexico
   #define AT_T            (14) //AT&T USA //XDSLRTFW-3470 XDSLRTFW-2724 IOP_ALL_US_CNXT_DISABLE_AELEM_GHS (START_END)
   // XDSLRTFW-3631 (Start)
   #define SWISSCOM        (15)
   #define NETGEAR         (16)
   #define CTL             (17) //CenturyLink USA //XDSLRTFW-3470 XDSLRTFW-2724 IOP_ALL_US_CNXT_DISABLE_AELEM_GHS (START_END)
   // XDSLRTFW-3631 (End)
   #define TELECOM_ITALIA  (18)
   #define MT_HUNGARY      (19) // Magyar Telekom XDSLRTFW-3740 (Start_End)
   #define TTNET           (20) // Turk Telekom


//XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start)
#define DSL_INTEROP_OPTIONS         22
//#define CMV_TO_SUPPRESS_CRC_FEC_WriteBackOption (0x0001)
#define RESET_CRC_FEC_COUNTERS_AT_LINKSTART_TO_0_FOR_EOC_REPORTING (0x0001)


//XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH
//Bit 0 -> EFM Loaded = 0x1
//Bit 1 -> ATM Loaded = 0x2
#define DSL_TC_MODE_USED            23

#define DSL_FW_InternalControl      24
   #define DSL_ERASE_SRAM_VARS      (0x8000)

//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start]
#define DSL_CRYSTAL_OFFSET          25
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [End]

#define DSL_DEBUGBUFF_STATUS           (26)
#define DSL_DEBUGBUFF_GHS_TO_EXCHANGE  (27)
#define DSL_DEBUGBUF_SHOWTIME          (28)
#define DSL_DEBUGBUF_CONTROL           (29)

#define DSL_CONFIG_REINIT_THRESH       (30)
//XDSLRTFW-361 Enh_All_All_All_GetHandshakeControlInfo (Start_End)
#define DSL_HNSK_CONTROL_INFO          (31)

// Place holder from MCAT
#define DSL_APS_STATUS           (32)


// XDSLRTFW-3565 (Start_End)
// We are using DSL 34 to keep same message across ADSL and VDSL
#define DSL_PPE_CLOCK_CONFIGURE  (34)

// XDSLRTFW-3662 (Start)
#define DSL_PPA_FW_VERSION       (35)
#define DSL_PPE_FW_VERSION       (36)

// DSL 36
// Please refer the register DREG3 (PPE shared buffer address  0x7DC3) in document "PPE DSL Notifications", Sec 2.2.1 and point-b
// for the mask and reference value
#define PPE_FW_VERSION_MASK         0xFFFF0000
#define PPE_FW_VERSION_SHIFT         16
#define PPE_FW_VERSION_REFERENCE    0xA5A5
// XDSLRTFW-3662 (End)

//XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (End)

#define DSL_PREV_FAILSTATE                         (37) // DSL_37
#define DSL_PREV_EXCEPTION_CODES                   (38) // DSL_38

//=============================================================================================================
// INFO register address field definitions
//==============================================================================

#define INFOARRAY_SIZE              1

//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (START)
//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start_end)
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
//XDSLRTFW-496: Feature_T1413_Info(start_end)
//XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85 (Start_End)
#define INFOMAP_SIZE             131 // INFOMAP_SIZE should be 1 higher than index of last INFO CMV
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (END)


#ifdef HERC_API

//XDSLRTFW-970 : Changed info 203 size to 3 from 6
#define INFO_203_SIZE               (3)
#define INFO_209_SIZE               (1)
#define INFO_211_SIZE               (1)
#define INFO_212_SIZE               (1)
//XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221 (Start_End)
#define INFO_221_SIZE                   (6)

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (Start)
#define INFO_229_SIZE               (1)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (End)

// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
#define INFO_241_SIZE               (142)
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

//XDSLRTFW-3566 (Start_End)
// We are using DSL 34 to keep same message across ADSL and VDSL
#define INFO_244_SIZE               (1)

#endif

#define INFO_TxState             0
#define INFO_RxState             1
#define INFO_TxNextState            2
#define INFO_RxNextState            3
#define INFO_TxStateJumpFrom        4
#define INFO_RxStateJumpFrom        5

#define  INFO_FailureInfo           6     // Point to structure.
/*
{
    tx state at fail
    rx state at fail
    tx substate at fail
    rx substate at fail
    tx symbol cnt at fail
    rx symbol cnt at fail
*/
// JumpTo CMVs are no longer valid, they are also removed from MP files.
// Two new global variables "gpF_TxStateJumpTo" and "gpF_RxStateJumpTo"
// are initialized as pointers to the Done State.  The only way to change
// their values is by a "memory write" command in WinHost.

#define  INFO_DebugTrail               7     // &gsa_statestrail

#define INFO_ReverbSnrBuf           8
#define INFO_ReverbEchoSnrBuf       9
#define INFO_MedleySnrBuf           10
#define INFO_RxShowtimeSnrBuf       11
#define INFO_DECdelay               12
#define INFO_DECExponent            13
#define INFO_DECTaps             14
#define INFO_AECdelay               15
#define INFO_AECExponent            16
#define INFO_AECTaps             17
#define INFO_TDQExponent            18
#define INFO_TDQTaps             19
#define INFO_FDQExponent            20
#define INFO_FDQTaps             21
#define INFO_USBat                  22
#define INFO_DSBat                  23
#define INFO_USFineGains            24
#define INFO_DSFineGains            25
#define INFO_BitloadFirstChannel    26
#define INFO_BitloadLastChannel        27
#define INFO_neT1413VendorID        28    // T1413 Vendor ID: sent out in RMSG1 and EOC
#define INFO_feT1413VendorID        29    // T1413 Vendor ID: received in CMSG1 and EOC
#define INFO_RCMsgs1             30
#define INFO_RMsgs1                 31
#define INFO_RMsgRA                 32
#define INFO_RCMsgRA             33
#define INFO_RMsg2                  34
#define INFO_RCMsg2                 35
#define INFO_BitLoadOK              36
#define INFO_RCRates1               37
#define INFO_RRates1Tab             38
#define INFO_RMsgs1Tab              39
#define INFO_RMsgRATab              40
#define INFO_RRatesRA               41
#define INFO_RCRatesRA              42
#define INFO_RRates2             43
#define INFO_RCRates2               44
#define INFO_MemoryBasePtr          45    // Points to INFO_MemoryPtr (INFO 59).
#define INFO_RxBitSwapFlag          46
#define INFO_ExcessMarginReduction      47
#define INFO_ShowtimeSNRUpdateCount    48
#define INFO_ShowtimeFDQUpdateCount    49
#define INFO_ShowtimeDECUpdateCount    50
#define INFO_CopyRxBuffer           51
#define INFO_RxToneBuf              52
#define INFO_TxToneBuf                  53
#define INFO_Version             54 //firmware version
#define INFO_TimeStamp                  55
#define INFO_feSystemVendorID       56 // ADSL2 only: Received from CO in response to Inventory command from CPE.
#define INFO_feSystemSerialNum         57 // ADSL2 only: Received from CO in response to Inventory command from CPE.
#define INFO_feSystemVersionNum        58 // ADSL2 only: Received from CO in response to Inventory command from CPE.
#define INFO_MemoryPtr              59 // Points to memory.  Can be used to read memory using cr/cw when mr/mw not available. See also INFO 45.
#define INFO_neSystemVendorID           60   // ADSL1: EOC data register. ADSL2: Sent by CPE in response to Inventory command from CO.
#define INFO_neSystemVersionNum        61 // ADSL1: EOC data register. ADSL2: Sent by CPE in response to Inventory command from CO.
#define INFO_neSystemSerialNum         62 // ADSL1: EOC data register. ADSL2: Sent by CPE in response to Inventory command from CO.
#define INFO_DSBlackoutTone             63  // Pointer to guca_RMsgPCBTab[4]
#define INFO_feG9941VendorID        64 // ADSL1/ADSL2: Received during G.hs.
#define INFO_neG9941VendorID        65 // ADSL1/ADSL2: Sent during G.hs.
#define INFO_SelfTestResult            66  // 0-1: CPE, RT
#define INFO_feSystemCapabilities      67  // 7 bytes.  Far end system capabilities, extracted from 1st CL of most recent G.hs session.
#define  INFO_TestParamsDS          68
#define  INFO_TestParamsUS          69
#define INFO_LD_OtherDS             70 // Offset 0: Success/Fail Code, 1:Last State Xmitted, 2:HLIN Scale.
#define INFO_LD_OtherUS             71 // Offset 0:
#define INFO_HLIN_DS             72
#define INFO_HLIN_US             73 // Available in Loop Diagnostics mode only.
#define INFO_HLOG_DS             74
#define INFO_HLOG_US             75 // Available in Loop Diagnostics mode only.
#define INFO_QLN_DS              76
#define INFO_QLN_US              77 // Available in Loop Diagnostics mode only.
#define  INFO_SNR_US             78
#define  INFO_MeasuremtTimesDS            79 // Offset 0:Hlog,1:QlnDS,2:SnrDS
#define  INFO_MeasuremtTimesUS            80 // Offset 0:Hlog,1:QlnDS,2:SnrDS
#define INFO_ME_HDLC_TxBuffer    81 //
#define INFO_ME_HDLC_RxBuffer    82 //
#define INFO_ME_HDLC_Params         83 //
#define INFO_IMPULSE_NOISE_DET_PARAMS           84

//XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85 (Start_End)
#define INFO_SNR_DS                 85

#define  INFO_DebugTrail_Trigger    86
#define  INFO_DebugTrail_Collect    87
#define INFO_PCM_Interface          88  // PCM Data structure
#define INFO_TxMedleyFirstCh     89
#define INFO_TxMedleyLastCh         90
#define INFO_GPIO_Control        91
#define INFO_DerivedProps_LatencyPath_DS 92
#define INFO_DerivedProps_LatencyPath_US 93
#define INFO_NominalTxPower         94 // Format of this value is 4.12, so that 4096 = gain of 1.0.
#define INFO_US_OLRPMCnt         95  // US OLRPM Counter (no PM yet)
#define INFO_DS_OLRPMCnt         96  // DS OLRPM Counter (no PM yet)
#define INFO_ADI_CMV                97  // ADI specific cmv
#define INFO_DSHandshakeBIS         98
#define INFO_StructureSizeOffset 99
#define INFO_GHS_US_TSSI_INFO       100  // Info structure of G.HS US Tssi
#define INFO_GHS_DS_TSSI_INFO       101  // Info structure of G.HS DS Tssi
#define INFO_PMD_CONTROL         102  // Info structure gt_TxPMDControl
#define INFO_Infx_CMV            103   // Infx-specific cmv

#ifdef DANUBE
// reserved for Danube PPE
#define INFO_PPEATMRxCnt            104
#define INFO_PPEATMTxCnt            105
#ifdef TARGET_HW
#define INFO_RxMarginBuf            106
#endif // TARGET_HW
#endif // DANUBE
#define INFO_STATUS_AFE_OVF_UDF       107 //Reserved

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Start
//#define INFO_RETX_CONFIG_INFO     110  // Info structure gt_ReTxConfigInfo
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (END)

#ifdef DEBUG_STREAMING
// The INFO 115 is used to enable/disable  the  output  of  so-called  "debug  streams"  with  additional  debug  information
#define INFO_DEBUG_STREAM_CONTROL    115
   //@todo: AH shall we define this here?
   #define CMV_INFO115_CONTROL_MASK 0x0001
   #define CMV_INFO115_CONTROL_POS  0x0000

// The INFO 116 is used to write a bit mask to configure which messages are output in the debug stream
#define INFO_DEBUG_STREAM_CONFIGURE  116
// The INFO 117 is an auto message indicating a stream buffer overflow on the host controller
#define INFO_EVT_DBG_BUFFER_OVERFLOW 117
// The INFO 118 is an auto message containing debug stream content
#define INFO_EVT_DBG_DEBUG_STREAM    118
#endif

//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
#define INFO_BITSWAP_EVACUATION_THRESHOLD     119
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
// Defined for Telefonica debugging
//#define INFO_BG_TASK    120 //reserved
#define INFO_CTUNE_VAL    120 //reserved
#define INFO_DEBUG_VAR  121   //reserved
#define INFO_AFECHIP    122   //gus_AfeChipId
#define INFO_HYBIDX_FORCE     123   //HybIndex


//XDSLRTFW-496: Feature_T1413_Info(start)
#define INFO_VR9FeT1413VendorID                 124   // T1413 Vendor ID: received in CMSG1 and EOC
#define INFO_VR9NeT1413VendorID                 125   // T1413 Vendor ID: sent out in RMSG1 and EOC
#define INFO_VR9FeT1413RevisionNum              126   // T1413 Revision Number: recieved in RMSG1 and EOC
#define INFO_VR9NeT1413RevisionNum              127   // T1413 Revision Number: sent out in RMSG1 and EOC
#define INFO_VR9FeT1413VendorRevisionNum        128   // T1413 Vendor Revision Number: recieved in RMSG1 and EOC
#define INFO_VR9NeT1413VendorRevisionNum        129   // T1413 Vendor Revision Number: sent out in RMSG1 and EOC

//XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85 (Start_End)
#define INFO_RX_CLEAR_EOC                       130  //was 85

// XDSLRTFW-3974 Hlog reporting
#define DISABLE_BLACKOUT_HLOG_OF_TONES_WITH_LOW_SNR   (0x0001)

//XDSLRTFW-496: Feature_T1413_Info(end)

//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
//#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect
//#define INFO_NLNF_METRICS_IBS                 121
//#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE

// *************** --------------------------------------     ***************
// ***************       INFO_Infx_CMV = INFO 103 0            ***************
// *************** BitMasks used in INFX_CMV.us_OperatorSpBits ***************
#define CMV_TO_FORCE_KPN_TSSI_US_BIN_START               (0x0001) // XDSLRTFW-1792
#define CMV_TO_FORCE_UNITY_TDQ                           (0x0002) // CMV to force unity TDQ against CNXT in ADSL2/2+ mode for no CRCs / PERF_DS_Bis_CNXT_ForceUnityTDQ
#define CMV_TO_DISABLE_DS_PCB                            (0x0004) // Boost 1dB Tx pwr from R-Reverb1 in ADSL2/2+ for lower DS PCB from CNXT COs / PERF_US_ALL_ALL_TxPwrBoost1dB
#define CMV_TO_DISABLE_TXMED_NOISE_ALC_DMT               (0x0008) // IOP_US_DMT_ALCATEL_AddNoiseToTxMedleyToImproveUsMargin (Start_End)
#define CMV_TO_DISABLE_CNXT_D57E67_BISPLUS_RS_DELAY2MS   (0x0080) // SMS00815166/SMS00768526: IOP_DS_BisPlus_CNXT_FramingLimitation / IOP_DS_BisPlus_CNXT_D57E67_RS_INP0DELAY2MS
#define CMV_ENABLE_IOP_CNXT_REDUCE_US_PCB_BY_3dB         (0x0100) // PERF_US_BisPlus_CNXT_Reduce_US_PCB_By_3_dB (START_END)
#define CMV_TO_DISABLE_5T1NOISE_ALC_DMT                  (0x0400) // PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (Start_End)
#define CMV_TO_DISABLE_USPILOT_CNXT                      (0x1000) // IOP_T1413_CNXT_SendValidGainOnUSPilot (Start_End)
#define CMV_TO_DISABLE_PERF_BT_LOOPS                     (0x4000) // XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START-END)
// *************** --------------------------------------     ***************


// *************** --------------------------------------     ***************
// ***************       INFO_Infx_CMV = INFO 103 1            ***************
// *************** BitMasks used in INFX_CMV.s_DFE_Options     ***************
#define FORCE_PTM_MASK                                 (0x0004)
#define DIS_BYTE_FLIP_MASK                             (0x0008)
#define CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE             (0x0040) // Masks used for Selecting MinINP from CL instead of MS against CNXT / PERF_DS_PLUS_ALL_GeneralizedPcb (Start_End)
#define CMV_INFX_DFE_FT_INTERP13_ENABLE                (0x0080) // bit 7 0x0080 //PERF_US_ALLannexA_New_FTspeciffic
#define CMV_DFE_CHOOSE_MININP_FROM_CL_CNXT_ENABLE      (0x0100) // IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading  (START_END)
#define CMV_TO_FORCE_TI_VENDORID_CNXT                  (0x0200) // BitMask used in INFX_CMV.s_DFE_Options for sending TI vendor ID when CNXT CO is detected. // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (Start)
#define DS_START_TONE_61                               (0x1000) // Start DS from tone 61 for Annex J mode if US mask upto tone 60 or lower is selected / Feature_US_BisPlus_ALL_StartDSFromTone61AnxJ (Start_End)
//#define ACTVATION_ANXB_TONES_FOR_ANXJ                (0x2000) // Selection of B/J tone set is moved to CNFG 45 0x0004 / XDSLRTFW-699 Fix_AB_US_All_GHsToneSetSelection
#define CMV_TO_ENABLE_CNXT_SRA_FIX                     (0x4000) // SMS00805497 IOP_DS_BisPlus_CNXT_SRAFailGhsNonStandard

#define DIS_FORCE_PTM                                  (0xFFFB)
// *************** --------------------------------------     ***************


// AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (End)
// Perf_US_ALL_MultiTone_Activation (Start_End)
// Use Annex-B Activation tones when Link Start's in Annex-J Mode

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Start
//CMV INFO 110 used for ReTx related configuration it points to "gt_ReTxConfigInfo"
//Bit masks used in INFO_RETX_CONFIG_INFO

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (Start)
//Changed the value from 0x10 to 0x1 to match HERC message spec. Hence it will not work in SOC mode
//unless some re-mapping is performed.
#define CMV_BIT_INDICATE_RETX                   (0x0001) //Indicate ReTx capability in GHS
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (End)
#define CMV_BIT_INDICATE_IFX_MAX_16K_RETX       (0x0040) //Use of 16K memory for IFX CO
#define SEND_LpRCC                              (0x0200) //Enable LpRCC
#define DIS_BAD_CW_INDICATION                   (0x0400) //Disable bad CW indication
//FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (Start_End)
#define CMV_CPARAMS_INP_FLAG                    (0x0800) //Request for repeated C-PARAMS
//XDSLRTFW-1223 (Start_End)
#define CMV_ENA_PLL_FIX_UNCORR_DTU              (0x1000) //Enabling PLL fix for uncorrected DTUs

//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)


//OPTN_Power_Management Bit definitions
#define OPTN_L2_Exit_Based_on_RFI      0x0001
#define OPTN_L2_DataRate_Towards_Max   0x0002
#define OPTN_L2_Amd4_Enable            (0x0010)

//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start)
// XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (START)
//BitMasks used in gt_nlnf_metrics_ibs.us_NlnfIbs = INFO 121 0
//located in persistent memory
//Bit-15 to disable NLNF measurement in modem startup
//#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//#define CMV_TO_DISABLE_NLNF_STARTUP           (0x8000)
//#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (END)
//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (end)

/**********************************PTM CHANGES**********************************/
#ifdef DANUBE_PTM_SUPPORT
//Element: INFX_CMV.us_PTM_Options_Indicated
#define PTM_US_OPTIONS (0x39)
#define PTM_DS_OPTIONS (0x39 << 6)

//Element: INFX_CMV.us_PTM_Options_Selected
#define CMV_PTM_HDLC_ENCAPSULATION_US        0x0001
#define CMV_PTM_64_65_OCTET_ENCAP_SHORT_US      0x0008
#define CMV_PTM_64_65_OCTET_ENCAP_PRE_US     0x0010
#define CMV_PTM_64_65_OCTET_ENCAP_SUPPORT_US 0x0020
#define CMV_PTM_HDLC_ENCAPSULATION_DS        0x0040
#define CMV_PTM_64_65_OCTET_ENCAP_SHORT_DS      0x0200
#define CMV_PTM_64_65_OCTET_ENCAP_PRE_DS     0x0400
#define CMV_PTM_64_65_OCTET_ENCAP_SUPPORT_DS 0x0800
#define CMV_PTM_SELECTED                  0x1000
#define CMV_ATM_SELECTED                  0x2000
#endif//if defined DANUBE_PTM_SUPPORT

//BitMasks used in INFX_CMV.us_OperatorSpBits2 = INFO 103 20 ***************
// SMS01221899 Feature_DS_All_All_EnableOneStepSRA (START_END)
#define CMV_TO_ENABLE_ONE_STEP_SRA            (0x0001)
//XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start _End)
#define CMV_CGALF1_TIMEOUT_SILENT1              0x0002

// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
// cmv bit to enable G.hs based C-Pilot1 Detector to avoid false detection
// due to C-Pilot1 xtlak in C-QUIET2 state in G.dmt mode.
#define CMV_TO_ENABLE_Ghs_CPilot1DetFix              (0x0004)
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)
// ADSLRTFW-918_XDSLRTFW-462_SMS00832206 IOP_DS_ANCDA_Gdmt_FBnoiseHighDSRate (START)
// cmv to enable DS rate improvement against ANCDA in AnnexA
// G.dmt mode with FB noise
#define CMV_TO_ENABLE_ANCDA_FB_DS_RATE_IMPROVE        (0x0008)
//  ADSLRTFW-918_XDSLRTFW-462_SMS00832206 IOP_DS_ANCDA_Gdmt_FBnoiseHighDSRate (END)
//XDSLRTFW-1692
//This CMV bit can be used for all general TX Cutback fixes
#define CMV_TO_ENABLE_TXCUTBACK                 (0x00010)
//XDSLRTFW-139:SMS00839860 PERF_DS_BisPlus_DSmarginIncrease(START)
#define CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE  (0x0040)
//SXDSLRTFW-139:SMS00839860 PERF_DS_BisPlus_DSmarginIncrease(END)
//SMS00911694 SMS00907672 IOP_DS_T1413_All_DSATNBias (START)
#define CMV_TO_ENABLE_T1413_DSATN_Bias               (0x1000)
//SMS00911694 SMS00907672 IOP_DS_T1413_All_DSATNBias (END)
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
#define CMV_TO_ENABLE_CNXT_US_RateImprovement        (0x2000)
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (END)
//SMS00919148 IOP_AB_DS_ALL_CReverb1Counter (START_END)
#define CMV_TO_ENABLE_CPILOT1Off_Detection           (0x8000)
//BitMasks used in INFX_CMV.us_OperatorSpBits3 = INFO 103 23 ***************
//SMS01501984 SMS01294435 Feature_DS_BisPlus_ALL_DisableTrainingREINDetection (START_END)
#define CMV_TO_DISABLE_REIN_ADAPTATION_TRAINING     (0x0020)
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
#define CMV_TO_ENABLE_FAST_BITSWAP        (0x0040)
#define CMV_TO_ENABLE_BITSWAP_EVACUATION  (0x0080)
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
//ADSLRTFW-1343 PERF_A_DS_PLUS_ALL_ATN_BenchmarkAR7 (Start_End)
#define CMV_TO_ENABLE_ADSL2PLUS_ATN_BenchmarkAR7    (0x8000)


//XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (Start_End)
//BitMasks used in INFX_CMV.us_OperatorSpBits4 = INFO 103 26 ***************
#define CMV_TO_ENABLE_CNXT_Midloop_USPerf        (0x0002)
//ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove (END)
//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (Start)
#ifdef ADSL_62
#define MASK_ENA_EXT_ILV_BUF  (0x0004) // Mask to enable Extended Ilv buffer
#endif
// XDSLRTFW-374 (ADSLRTFW-1361): IOP_DS_PLUS_FR_TelefonicaOnSite_INP_REIN_Tests (start_end)
#define CMV_TO_ENABLE_NEW_REVSEG_DET_TONE_SEL (0x0008)
//XDSLRTFW-406  IOP_A_DS_Plus_BRCM_Set_MAXNOMATP_ToZero (START_END)
#define CMV_TO_ENABLE_BRCM_MAXNOMATP_DS_SettoZero (0x0010)


//ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs
#define CMV_TO_ENABLE_FIX_Sparnex_DS_CRC (0x0020)

//ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL (START_END)
#define CMV_TO_ENABLE_ATT_DISABLE_ANNEXL_SHORTLOOP (0x0080)

//ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS (START_END)
#define CMV_TO_ENABLE_CTNW_SHORTEN_GHS             (0x100)
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop  (START_END)
#define CMV_TO_ENABLE_ECI_PLSE_IOP_ATT             (0x0800)

//XDSLRTFW-1592 IOP_A_DS_ADSL1_CTLM_AddCMV_TxPowerCut (START_END)
#define CMV_TO_ENABLE_CTLM_ShortLoop_TxPowerCut             (0x1000)

//ADSLRTFW-1419 IOP_A_DS_ALL_ShortenTrainingTime_AfterPowerup (START_END)
#define CVM_TO_Enable_GHS0000_TIVID_Retrain                 (0x4000)

//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START_END)
//#define CMV_TO_ENABLE_SRA_FRAMING_CHECK (0x0400) // removed and moved to info 103 29

//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (End)

//XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI - (START)
//BitMasks used in INFX_CMV.us_OperatorSpBits5 = INFO 103 27 ***************
//XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
#define CMV_TO_ENABLE_CNXT_USPerf_E67        (0x0010)
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START_END)
#define CMV_TO_ENABLE_GMX_DMT_DSPerf             (0x0020)
//XDSLRTFW-366 FEATURE_ALL_DS_ALL_LoopEstimate_HSK_POWER (start_end)
#define CMV_TO_ENABLE_HSK_BASED_LOOPLENGTH      0x0040
//CNXT CO's (E.67.1.78) &
//Stinger (SW Version - 9.9.2M02, Firmware Version - E.67.15.1)
//Supports Lp Reduction of more than 1bit, Tested with gs_REDUCE_LP_DELTA_BITSWAP = 20
//Bitswap worked. Hence this CMV bit may be enabled to bypass "gs_REDUCE_LP_DELTA_BITSWAP = 1"
//(E.67.1.78) & (E.67.15.1) both has the gs_CurrentCoVendorID = 0x10.
//The given below bit may enabled to do the bit swap faster.
#define CMV_TO_BYPASS_Bis_1bit_LpReduction_CNXT        (0x0100)
#define CMV_For_2Plus_LpReduction_CNXT                 (0x0600)
//CMV bit Bit10  Bit9
//          0     0    ==> 1 bit Lp Reduction
//          0     1    ==> 1 bit Lp Reduction  (default)
//          1     0    ==> 2  "
//          1     1    ==> 3  "
#define  CNXT_1BIT_LpREDUCTION         (1)
#define  CNXT_2BITS_LpREDUCTION        (2)
#define  CNXT_3BITS_LpREDUCTION        (3)
//XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI - (END)

//XDSLRTFW-316  PLL BW is changed based on SNR during Medley.
// This change in the bandwidth helps to reduce the DS CRC
// caused glitches introduced by TX SRC.
#define CMV_TO_BYPASS_PLL_BW_CHANGE_IN_SHOWTIME         (0x1000)

//PERF_US_T1413_T1&CNXT_64ptIFFT (START)
//This bit is enabled bydault to enable 64pt IFFT emulation for
//TI & CNXT CO's in T1413 mode, This helps to improve the US rate
//in T1413 mode and the US rate is close to G.dmt mode.
#define CMV_TO_USE_IFFT64           (0xC000)
//CMV bit Bit15  Bit14
//          0     0    ==> (0) 64pt IFFT emulation disabled
//          0     1    ==> (1) (default) 64pt IFFT emulation enabled to CNXT & TI in T1413 mode only
//          1     0    ==> (2) 64pt IFFT emulation enabled for G.DMT/T1413 mode for debug purpose
//          1     1    ==> (3) Reserved for feature use.
#define IFFT64_DISABLED                (0)
#define IFFT64_T1413_CNXT_TI_ENABLED    (1)
#define IFFT64_ADSL1_ENABLED        (2)
#define IFFT64_RESERVED             (3)
//PERF_US_T1413_T1&CNXT_64ptIFFT (END)

// XDSLRTFW-383 : Increase DS rates in VR9 against Luscent Stinger DSLAM in ADSL2/2plus mode for
// Stright gauge loops > 3000M / 9Kft
//XDSLRTFW-383 Enh_DS_ADSL2_CNXTIKNS_DSRate (start_End)
#define CMV_TO_ENABLE_DS_MARG_DELTA_3A_5A   (0x2000)
//BitMasks used in INFX_CMV.us_OperatorSpBits6 = INFO 103 28 ***************
//Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold (START)
//In order to search Aux Pilot Canditate, Min Reverb SNR required was 16dB
//(considering 16dB is enough to allot 2bit on the Aux Pilot Tone).
//But 24 DSL cross talk @ 16Kft& FSAN CLASS B @ 3250m noise cases at long loop,
//Pilot Tone 64 will be dominated these stong noises, but the Aux Pilot Tone candidates SNR's were
//less than 16dB, in these scenario, we need to get the link up. Hence Aux Pilot
//SNR threshold is reduced by 6dB, i.e to 10dB.  Reverb SNR measurement itself was done with
//Pilot tone 64 and SNR will improve later on during Medley with Aux Pilot.
//CMV bit Bit4, Bit3, Bit2, Bit1, Bit0
#define CMV_FOR_AUX_PILOT_MIN_SNR_MASK     (0x001F)
#define AUX_PILOT_MIN_SNR_THRESHOLD       (10) //10 dB
//Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold (END)
// Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(Start_End)
#define CMV_TO_DISABLE_PLL_BW_CHANGE_IN_SHOWTIME (0x0020)
// XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest (start_end)
#define CMV_TO_ENABLE_EXTRA_Log2NumShowtimeSNRTrainingSymbols (0x0040)

//ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise(Start_End)
#define CMV_TO_INCREASE_TX_MEDLEY_NOISE_ADI           0x0080
// ADSLRTFW-1589 IOP_DS_ADSL1_CTLM_CodingGain_MarginShape(Start_End)

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Mask for enabling/disabling RFI notching
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
// Default use new algorithm to decide on discard frame.
#define CMV_TO_TOGGLE_NewAndOldDiscardFrameAlgo (0x01000)
#define CMV_TO_DISABLE_RFI_NOTCH (0x0100)
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End): Mask for enabling/disabling REIN detection and adaptation of framing
#define CMV_TO_ENABLE_REIN_DETECTION_TRAINING_AND_CHANGE_FRAMING (0x0200)
//XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower (START_END)
#define CMV_TO_ENABLE_LOWER_TX_POWER   (0x0400)
//XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM (START_END)
#define CMV_TO_ENABLE_NM_VINAX2           (0x0800)
//XDSLRTFW-679 Enhance_US_BisPlus_LucentStinger_US_Rate_Improvement (Start_End)
#define CMV_TO_ENABLE_IMPROVE_US_RATE_WITH_LUCENT_ST (0x2000)
//XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable(Start_End)
#define CMV_TO_ENABLE_DS_ST_STABLE_WITH_IKNS (0x4000)
// XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise(Start_End)
#define CMV_TO_ENABLE_PSDBoostUSPerf24HDSLNoise (0x8000)
//BitMasks used in gt_INFX_CMV.us_SRA_IOP_Bits = INFO 103 29 ***************
#define  CMV_SRA_ACHIEVE_TARGETMARGIN                 0x0001
#define  CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK      0x0002
#define  CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK           0x0004
#define  CMV_SRA_INP_FRAMING_CHECK                    0x0008

#define  CMV_TO_ENABLE_SRA_SEARCHING_DELTA_LP         0x0010
#define  CMV_TO_DISABLE_SRA_FRAMING_CHECK                0x0020
#define  CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK_DELTA_LP  0x0040
#define  CMV_TO_ENABLE_SRA_INP_CHECK_DELTA_LP         0x0080
#define  CMV_TO_ENABLE_SEARCHING_DELTA_MarginOverINP  0x0100
//XDSLRTFW-2066
#define  CMV_FT_ReTx_CG_Performance                   0x1000

//XDSLRTFW-2031 Enhc_A_DS_BisPlus_BRCM_WorkaroundForAskeyLabTesting (START_END)
#define CMV_TO_ENABLE_WORKAROUND_ASKEY_LAB            (0x4000)
//XDSLRTFW-1564 /XDSLRTFW-1665 (Start_End)
#define CMV_FOR_MARGIN_ON_15BITS_TONES                (0x8000)
//BitMasks used in gt_INFX_CMV.us_SRA_IOP_Bits = INFO 103 30 ***************
//XDSLRTFW-1815 : Fix for IKNS CO4 DS CRC
#define CMV_TO_ENABLE_IKNS_CO4_FIX           (0x0001)
//XDSLRTFW-2033 (start)
#define CMV_TO_NO_MARGIN_FUDGE_BTTESTs       (0x0002)
#define CMV_TO_FORCE_ADSL1_MODE              (0x0004)
#define CMV_TO_FORCE_ADSL2_MODE              (0x0008)
#define CMV_ForceRetrain_at_Reverb1          (0x0010)
#define CMV_TOReduceTxPowerBy_1dB            (0x0020)
//#define CMV_ImproveHybTraining_AnnexL        (0x0040)  // reserved for now
#define CMV_NoAFEMargin_AnnexLBT             (0x0080)
#define CMV_ReverbNoiseMarginFix             (0x0100)
//#define CMV_RMSG2Bins_Fix                    (0x0200)  // reserved for now
#define CMV_COMBDETECT_Bins_Fix              (0x0400)
#define CMV_COMB2_PILOT_Fix                  (0x0800)
#define CMV_COMB2_preSNR_Fix                 (0x1000)
#define CMV_CNXT_ATT_CONTROL                 (0x2000)
#define CMV_TO_FORCE_DSPCB_BDCM_ANNEXJ       (0x4000) //XDSLRTFW-2285 (Start_End)
#define CMV_ENABLE_NoiseMa_ISDN_FBNoise      (0x8000) //XDSLRTFW-2248 (Start_End)
//XDSLRTFW-2033 (end)
// Moved to operator bit
//#define CMV_MinOvhd_DataRate_32Kbps     (0x4000) //XDSLRTFW-2376


#ifdef DANUBE
//Mask for bits used/reserved for the INFX_CMV dfe options. cmv INFO 103,2
//Masks used for Selecting Upstream Spectrum as per CO Profile
#define  CMV_DFE_CO_SELECT_US_BAND_ENABLE 0x0010   // CO_Selectable_US_Band
//Mask for crc counter clearing
#define TR69COUNTER_SUPPORT               0x0020
#endif

#ifdef HERC_API
#define INFO_herc_feSystemCapabilities      203
#define INFO_FW_ImageInfoGet        209
#endif

#ifdef HERC_API
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
#define INFO_DS_VIRTUAL_NOISE    114
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)
#endif

#ifndef HERC_API
#define INFO_DS_Band_Ctrl  113
#define INFO_US_Band_Ctrl  114
#else
#define INFO_DS_Band_Ctrl  211
#define INFO_US_Band_Ctrl  212
#endif

//==============================================================================
// RATE register address field definitions
//==============================================================================

#define RATEMAP_SIZE             22

#define RATE_UsRate                 0
#define RATE_DsRate                 1

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
#define RATE_RETX_DsETR                2
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

#define RATE_AvgMargin              3
#define RATE_USFastBytes            4
#define RATE_USIntlBytes            5
#define RATE_USFastCheckBytes       6
#define RATE_USIntlCheckBytes       7
#define RATE_USIntlDepth            8
#define RATE_USSymCodeWord          9
#define RATE_USFastCodeWordSize        10
#define RATE_USIntlCodeWordSize        11
#define RATE_DSFastBytes            12
#define RATE_DSIntlBytes            13
#define RATE_DSFastCheckBytes       14
#define RATE_DSIntlCheckBytes       15
#define RATE_DSIntlDepth            16
#define RATE_DSSymCodeWord          17
#define RATE_DSFastCodeWordSize        18
#define RATE_DSIntlCodeWordSize        19
#define  RATE_DerivedFramingParamsDS      20
#define  RATE_DerivedFramingParamsUS      21

#ifdef HERC_API
#define  HERC_ADSL_RATE_TCM_ENABLED                0x100
#endif  // #ifdef HERC_API

//==============================================================================
// PLAM (Physical Layer Management) register address field definitions
// (See G997.1 for reference)
//==============================================================================

#define PLAMMAP_SIZE             47


#ifdef DO_PLAM
/*             */
/* Failure Flags  */
/*             */

#define PLAM_NearEndFailureFlags    0
#define PLAM_FarEndFailureFlags        1

/*                         */
/* Near End Failure Flags Bit Definitions */
/*                         */

/* ADSL Failures */
#define PLAM_LOS_FailureBit            0x0001
#define PLAM_LOF_FailureBit            0x0002
#define PLAM_LPR_FailureBit            0x0004
#define PLAM_RFI_FailureBit            0x0008  //Not used in the code
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
#define PLAM_LOM_FailureBit            0x0008  //as per VR9 message specification

/* ATM Failures */
#define PLAM_NCD_LP0_FailureBit        0x0010
#define PLAM_NCD_LP1_FailureBit        0x0020
#define PLAM_LCD_LP0_FailureBit        0x0040
#define PLAM_LCD_LP1_FailureBit        0x0080

#define PLAM_NCD_BC0_FailureBit        0x0100
#define PLAM_NCD_BC1_FailureBit        0x0200
#define PLAM_LCD_BC0_FailureBit        0x0400
#define PLAM_LCD_BC1_FailureBit        0x0800

//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
//PTM failure overlaid onto the ATM failure
#define PLAM_OOS_FailureBit            0x0400  //as per VR9 message specification
#define PLAM_ESE_FailureBit             0x2000  //as per VR9 message specification
#define PLAM_LOS_DueToCRC_FailureBit    0x4000  //Re-Use the LOS reboot criteria for droping the link due to "Burst of DS CRC"
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)


#define PLAM_LOLcalculated_FailureBit  0x4000


/*                */
/* Performance Counts   */
/*                */

#define PLAM_NearEndCrcCnt       2
#define PLAM_CorrectedRSErrors         3
#define PLAM_LongNearEndCrcCnt         4
#define PLAM_LongCorrectedRSErrors     5

#define PLAM_NearEndECSCnt          6
#define PLAM_NearEndESCnt           7
#define PLAM_NearEndSESCnt          8
#define PLAM_NearEndLOSSCnt            9
#define PLAM_NearEndUASLCnt            10

#define PLAM_NearEndHECErrCnt       11
#define PLAM_SEFCnt                 12

#define PLAM_NearEndHECTotCnt       16
#define PLAM_NearEndCDTotCnt_BuffFull   17
#define PLAM_NearEndCellTotCnt         18
#define  PLAM_NearEndIdleCellBitErrs      19
#define PLAM_NearEndSfCntLSW        20
#define PLAM_NearEndSfCntMSW        21

#define PLAM_FarEndFebeCnt          24
#define PLAM_LongFarEndFebeCnt         25
#define PLAM_LongFarEndFecCnt       26

#define PLAM_FarEndFecCnt        28

#define PLAM_FarEndFECSCnt          32
#define PLAM_FarEndESCnt            33
#define PLAM_FarEndSESCnt           34
#define PLAM_FarEndLOSSCnt          35
#define PLAM_FarEndUASLCnt          36

#define PLAM_FarEndHECErrCnt     37
#define PLAM_NearEndTxIdleCellCnt      38       // &gula_fe_idle_cell_cnt[0]
#define PLAM_NearEndTxNonIdleCellCnt   39    // &gula_fe_non_idle_cell_cnt[0]

#define PLAM_FarEndHECTotCnt        41
#define  PLAM_FarEndIdleCellBitErrs    42
#define PLAM_FarEndCellTotCnt       43

#define PLAM_SNRMargin_OneOverTen_dB_Resolution 45
#define PLAM_SNRMargin              46
///// WHEN DEFINING NEW PLAM CMVs, PLEASE USE AVAILABLE SLOTS < 46 RATHER THAN
// INCREASE THE SIZE OF THE PLAM ARRAY.
#endif /* DO_PLAM */

// XDSLRTFW-1481 (Start_End)
#define PLAM_5_SIZE          2

//==============================================================================
// CNTL register address and bit field definitions
//==============================================================================

#define CNTLARRAY_SIZE              5

#define CNTL_ModemControl           0
#define CNTL_ModemModeSwitch        1

#define CNTL_ME_HDLC             2 // Control of ME HDLC (Management-Entity initiated HDLC) functions.
#define CNTL_PM_Control             3 //ENABLE_L3_CODE
#define CNTL_ModemDying             4

//CNTL_ModemControl
#define CNTL_ModemReset             0x0
#define CNTL_ModemIdle              0x1 // Allows tests to read data when complete
#define CNTL_ModemStart             0x2
#define CNTL_FinalFailState               0x4   // XDSLRTFW-2186
#define CNTL_ModemStop              0xF
#define CNTL_ModemSleep             0x8 // configuration for sleep substate tests
//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#define CNTL_ModemNLNF              0x9   // configuration for NLNF measurement
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (END)
#define CNTL_ModemLoopback          0x10
#define CNTL_ExpilictRate           0x20 /* Bit 5 indicates Expicit Rate control */

//CNTL_ModemModeSwitch
#define MODESWITCH_SOFT_RESET       0
#define ONE_PORT_ADSL               0x1A
#define ONE_PORT_VDSL               0x1B
#define TWO_PORT_ADSL               0x2A
#define TWO_PORT_VDSL               0x2B

//CNTL_ME_HDLC             2     // Control of ME HDLC (Management-Entity initiated HDLC) functions.
#define CNTL_ME_HDLC_Send           0x0001   // Triggers sending of message in Tx Message Buffer.
#define CNTL_ME_HDLC_ReturnToIdle      0x0002   // Forces ME HDLC state to IDLE.
#define CNTL_ME_Start_PCM               0x0004  // Start PCM process
#define CNTL_ME_Start_FIFOCOPY          0x0008  // Start PCM FIFO loopback directly (instead of going to Electra)

//CNTL_PM_Control
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
//CNTL[3] CNTL_Request_L3
//Bit 0:      L3 Orderly Shutdown Request
//When enabled, the modem sends a L3 orderly shutdown request to the remote side.
//Bit 1:      Orderly Shutdown Request
//                When enabled, DSL-FW shuts down the DSL-link orderly. After shutdown DSL-FW changes Modem State to FAILSTATE.
#define CNTL_Request_L3             0x1      //ENABLE_L3_CODE
#define CNTL_OrderlyShutDown        0x2
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)



//CNTL_ModemDying
#define CNTL_ModemSendDyingGasp        0x1
//==============================================================================
// STAT register address and bit field definitions
//==============================================================================
// XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask (Start)
#define STATARRAY_SIZE              27
// XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask (End)
#ifdef HERC_API
// STAT 0, 1 and 5 are indirect CMV's
#define STAT_0_SIZE                 (2)
#define STAT_1_SIZE                 (2)
#define STAT_5_SIZE                 ((sizeof(HercADSL_FailStateInfo_t)+1)/2)
//XDSLRTFW-970 : Changed info 74 & info 76 size to 512 from 256
#define INFO_74_SIZE             (256)
#define INFO_76_SIZE             (256)

#endif

// STAT register address field
#define STAT_MacroState             0
#define STAT_Mode                1
#define STAT_DMTFramingMode            2
#define STAT_SleepState             3
#define STAT_Misc                4
#define STAT_FailureState           5
/************************************************************************************************
* STAT_OLRStatus provides status of OLR
*16-bit STAT_OLRStatus_DS
*  [1:0]    :  OLR status 00=IDLE,  01=OLR_IN_PROGRESS, 10=OLR_Completed, 11=OLR_Aborted
*  [3:2]:      Reserved
*  [5:4]:      OLR_Type (1:bitswap; 2: DRR; 3: SRA)
*  [7:6]:      Reserved
*  [10:8]:     >0=Request. 0=not.   For DS, # of request transmissions/retransmissions (3 bits).
*  [11]:    1=Receive Response, 0=not
*  [15:12]: Reserved
*********************************************************************************************
*/
#define STAT_OLRStatus_DS           6

/************************************************************************************************
* STAT_OLRStatus provides status of OLR
* 16-bit STAT_OLRStatus_US CMV
*  [1:0]    :  OLR status 00=IDLE,  01=OLR_IN_PROGRESS, 10=OLR_Completed, 11=OLR_Aborted
*  [3:2]:      Reserved
*  [5:4]:      OLR_Type (1:bitswap; 2: DRR; 3: SRA)
*  [7:6]:      Reserved
*  [8]:     1=Request Received. 0=not.
*  [10:9]:     Reserved
*  [11]:    1=Response Sent, 0=not
*  [15:12]: Reserved
*********************************************************************************************
*/
#define STAT_OLRStatus_US           7

/************************************************************************************************
* STAT_PMStatus provides status of PM
* 16-bit STAT_PMStatus CMV
*  [1:0]    :  PM Status 00=IDLE,  01=PM_IN_PROGRESS, 10=PM_Completed, 11=PM_Aborted
*  [2] :       0=ATU_R initiated PM; 1 = ATU_C initiated PM
*  [3]:     Reserved
*  [5:4]:      PM_Type (1:Simple Request; 2: L2 request; 3: L2 trim)
*  [7:6]:      Reserved
*  [10:8]:     >0=Request. 0=not.   # of request transmissions/retransmissions (3 bits).
*  [11]:    1=Response, 0=not
*  [15:12]: Reserved
*********************************************************************************************
*/
#define STAT_PMStatus               8

/*************************************************************
* 16-bit STAT_OLRError_DS, STAT_OLRError_US, STAT_PMError
* [3:0]:          OLR/PM response reason code
* [7:4]:          OLR/PM Internal error code
* [15:8]:         OLR/PM Reserved for future
*************************************************************
*/
#define STAT_OLRError_DS            9
#define STAT_OLRError_US            10
#define STAT_PMError             11

/*************************************************************
* 16-bit STAT_ACTIVEBCLP_DS, STAT_ACTIVEBCLP_US
* [7:0]:          indicate Active LP
* [15:8]:         indicate Active BC
*************************************************************
*/
#define STAT_ACTIVEBCLP_DS              12
#define STAT_ACTIVEBCLP_US              13

// STAT_ME_HDLC
// Bits 3:0 (Management-Entity HDLC status)
#define STAT_ME_HDLC             14
#define  STAT_ME_HDLC_IDLE          0x0
#define STAT_ME_HDLC_INVALID_MSG    0x1      // Message in ME-HDLC Tx Buffer has invalid header.
#define STAT_ME_HDLC_MSG_QUEUED        0x2      // Message accepted and queued for transmission.
#define STAT_ME_HDLC_MSG_SENT       0x3      // Message transmitted in overhead channel
#define STAT_ME_HDLC_RESP_RCVD         0x4      // Response received.
#define STAT_ME_HDLC_RESP_TIMEOUT      0x5      // Timed out waiting for response
#define STAT_ME_HDLC_RX_BUF_OVERFLOW   0x6      // Received hdlc msg. length is longer than the ME HDLC rx buffer length

// XDSLRTFW-1658 R4-2 Annex A: SMS00825442 IOP_US_DMT_CATENA_ClearEocWorkaround - Start
#define STAT_ME_HDLC_MSG_NOT_SUPPORTED 0x7   // Requested Message is not supported by the CPE
// XDSLRTFW-1658 R4-2 Annex A: SMS00825442 IOP_US_DMT_CATENA_ClearEocWorkaround - End
#define STAT_AFETYPE             16    // to hold the type of AFE
#define STAT_Mode1                  17      // hold the second word of config-mode bits(corresponding to OPTN_ModeControl1)
#define STAT_PowerMode              18    // holds the power management state, L0, L2
#define STAT_Performance            19    // holds performance related flags

#define  STAT_ME_PMREQ_STATUS       20    // Tells ME the result of its PM (L3) request.
#define  STAT_ME_PMREQ_ERROR           21    // Tells ME the result of its L3 request.

// SMS00813413 Feature_ALL_ALL_ALL_PrevExceptionsCMV (Start)
// Feature_ALL_ALL_ALL_PrevExceptionsCMV (Start)
// Previous exception state/code stored in persistent memory
#define STAT_PREV_EXCEPTION_STATE       22
#define STAT_PREV_EXCEPTION_CODE        23
// Feature_ALL_ALL_ALL_PrevExceptionsCMV (End)
// SMS00813413 Feature_ALL_ALL_ALL_PrevExceptionsCMV (End)

// XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask (Start)
#define STAT_SELECTED_ANX_MJ_MASK      24
// XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask (End)

/* XDSLRTFW-2600 */
#define STAT_QLN_Performance        25
#define STAT_BITSWAP_EVACUATION        26
/* XDSLRTFW-2600 */

// STAT_MacroState
// MacroState reflects the high level state of the modem
#define STAT_ResetState                 0x0000
#define STAT_ReadyState                 0x0001
#define STAT_FailState                  0x0002
#define STAT_DiagComplete               0x0003
#define STAT_GhsState                   0x0005
#define STAT_FullInitState              0x0006
#define STAT_ShowTimeState              0x0007
#define STAT_ShowTimeTCSyncState        0x0008
#define STAT_LoopDiagMode               0x0009
#define STAT_T1413                      0x000E
#define STAT_PreFailState               0x000F
#define STAT_BondingCLR                 0x0010
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start)
#define STAT_MFD                        0x0012
#define STAT_MFDComplete                0x0013
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (end)
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
#define STAT_DSL_POWER_DOWN             0x0014     // XDSLRTFW-3648 (Start_End)
#define STAT_TEST                       0x00F0

// To be deleted
#define STAT_InitState              0x0000
#define STAT_FastRetrainState       0x0008
#define STAT_IdleState              0x0003
#define STAT_QuietState             0x0004
#define STAT_ShortInit              0x000A
#define STAT_BondingExchangeComplete   0x0011

// STAT_Mode
// ConfigurationMode indicates the mode of the current ADSL Link. In general, a modem may use
// G.Hs or some other mechanism to negotiate the specific mode of operation.
// The OPTN_modeControl CMV is used to select a set of desired modes.
// The STAT_Mode CMV indicates which mode was actually selected.

#define STAT_ConfigMode_T1413       0x0001
#define STAT_ConfigMode_G992_2_AB      0x0002
#define STAT_ConfigMode_G992_1_A    0x0004
#define STAT_ConfigMode_G992_1_B    0x0008
#define STAT_ConfigMode_G992_1_C    0x0010
#define STAT_ConfigMode_G992_2_C    0x0020

#define STAT_ConfigMode_G992_3_A    0x0100
#define STAT_ConfigMode_G992_3_B    0x0200
#define STAT_ConfigMode_G992_3_I    0x0400
#define STAT_ConfigMode_G992_3_J    0x0800
#define STAT_ConfigMode_G992_3_L    0x1000
#define STAT_ConfigMode_G992_3_M    0x2000

#define STAT_ConfigMode_G992_5_B    0x4000
#define STAT_ConfigMode_G992_5_A    0x8000

//STAT_Mode1 (bit definitions for the newly appended mode word)
#define STAT_ConfigMode_G992_5_I    0x0001
#define STAT_ConfigMode_G992_5_J    0x0002
#define STAT_ConfigMode_G992_5_M    0x0004
#define STAT_ConfigMode_ETSI_AnnexC     0x0008
#define STAT_ConfigMode_G993_1         0x0100
#define STAT_ConfigMode_G993_2         0x0200
#define STAT_ConfigMode_T1_MCM_VDSL     0x0400

//Attention!!!: the following combined constants(bitmap) actually are for 32bits, because
//they are combined from bitmap for two 16bits as above(now, for G992.5.I/J/M).
//So never use them for things like OPTN[], STAT[], those 16bits map.
//They should be only used with gul_ModeControl(former gus_ModeControl).
//Code will be checked extensively for the usage of the following.
#define STAT_ConfigMode_G992_1_ALL     (STAT_ConfigMode_G992_1_A | STAT_ConfigMode_G992_1_B | STAT_ConfigMode_G992_1_C)
#define STAT_ConfigMode_G992_2_ALL     (STAT_ConfigMode_G992_2_AB | STAT_ConfigMode_G992_2_C)
#define STAT_ConfigMode_G992_3_ALL     (STAT_ConfigMode_G992_3_A | STAT_ConfigMode_G992_3_B | STAT_ConfigMode_G992_3_I | STAT_ConfigMode_G992_3_J | STAT_ConfigMode_G992_3_L | STAT_ConfigMode_G992_3_M)
#define STAT_ConfigMode_G992_5_ALL     (STAT_ConfigMode_G992_5_A | STAT_ConfigMode_G992_5_B | (STAT_ConfigMode_G992_5_I<<16) | (STAT_ConfigMode_G992_5_J<<16) | (STAT_ConfigMode_G992_5_M<<16))
#define STAT_ConfigMode_ADSL2_ALL      (STAT_ConfigMode_G992_3_ALL | STAT_ConfigMode_G992_5_ALL)
#define STAT_ConfigMode_AnnexA_ALL     (STAT_ConfigMode_G992_1_A | STAT_ConfigMode_G992_3_A | STAT_ConfigMode_G992_5_A)
#define STAT_ConfigMode_AnnexB_ALL     (STAT_ConfigMode_G992_1_B | STAT_ConfigMode_G992_3_B | STAT_ConfigMode_G992_5_B)
#define STAT_ConfigMode_AnnexI_ALL     (STAT_ConfigMode_G992_3_I | (STAT_ConfigMode_G992_5_I<<16))
#define STAT_ConfigMode_AnnexJ_ALL     (STAT_ConfigMode_G992_3_J | (STAT_ConfigMode_G992_5_J<<16))
#define STAT_ConfigMode_AnnexL_ALL     (STAT_ConfigMode_G992_3_L)
#define STAT_ConfigMode_AnnexM_ALL     (STAT_ConfigMode_G992_3_M | (STAT_ConfigMode_G992_5_M<<16))
#define STAT_ConfigMode_VDSL_ALL    (STAT_ConfigMode_G993_1<<16| STAT_ConfigMode_G993_2<<16 | STAT_ConfigMode_T1_MCM_VDSL<<16)

// STAT_DMTFramingMode
// FramingMode indicates the DMT framing mde negotiated during initialization. The framing mode
// status is not applicable in BIS mode and its value is undefined
#define STAT_FramingModeMask        0x0003

// STAT_Misc STAT_4
#define STAT_AllCodeSwapsDone          0x0002   // indicate that all codeswaps are done
#define STAT_OverlappedSpectrum        0x0008
#define STAT_TCM_DS                    0x0010
#define STAT_TDQ_at_1104               0x0020
#define STAT_T1413_Signal_Detected     0x0040
#define STAT_TCM_US                    0x0080
#define STAT_IFFT64_EMULATE_REVERB     0x0100  // indicates emulation of reverb on tones 33:64 in reverb1 and Reverb2
#define STAT_DSSRA_DNSHIFT_BLOCKED     0x0200
#define STAT_DSSRA_UPSHIFT_BLOCKED     0x0400
/* reserved
*  [14:12]: 000 = "normal"
*           001 = below downshift threshold but unable to downshift due to framing constraints
*           010 = above upshift threshold but unable to upshift due to framing constraints.
*           011 = reserved.
*/
#define STAT_AnnexL_US_Mask1_PSD        0x1000  //indicate we actually selected G992.3 AnnexL US PSD mask1
#define STAT_AnnexL_US_Mask2_PSD        0x2000  //indicate we actually selected G992.3 AnnexL US PSD mask2
#define STAT_CO_L3_REQ_GRANTED          0x4000  // Indicates CO has requested and we have granted transition to L3.



// STAT_FailureState
// when the MacroSTate indicates the fail state, FailureState provides a failure code\
// System Error Codes (7:0)
#define SYS_ERROR_OK                        0x00
#define SYS_ERROR_CONFIG_ERROR              0x01
#define SYS_ERROR_CONFIG_NOT_FEASIBLE       0x02
#define SYS_ERROR_COMM_ERROR                0x03
#define SYS_ERROR_CRC_ERROR                 0x04
#define SYS_ERROR_NOPEER                    0x05
#define SYS_ERROR_CHIPSET_ERROR             0x06
#define SYS_ERROR_UNKNOWN_ERROR             0x07
#define SYS_ERROR_RESERVED                  0x08
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
#define SYS_ERROR_SHOWTIME_NEAREND_FAILURE  0x10
#define SYS_ERROR_SHOWTIME_FAREND_FAILURE   0x11
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)

// System Sub Error Codes (15:8)
#define SUB_ERROR_UNKNOWN                   0x00
#define SUB_ERROR_CODE_CODESWAP_ERROR       0x01
#define SUB_ERROR_CODE_PSD_CONFIG_ERR       0x02
#define SUB_ERROR_CODE_US_MIN_RATE          0x03
#define SUB_ERROR_CODE_DS_MIN_RATE          0x04
#define SUB_ERROR_CODE_INIT_FAILURE         0x05
#define SUB_ERROR_CODE_NO_COMMON_MODE       0x06
#define SUB_ERROR_CODE_TIMEOUT              0x09
#define SUB_ERROR_CODE_VDSL_SUPPORT_FAREND  0x0A
#define SUB_ERROR_CODE_PORT_MODE            0x0B
#define SUB_ERROR_CODE_INTENTIONAL_RETRAIN  0x0E
#define SUB_ERROR_CODE_FALSE_HYBRID         0x0F
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
#define SUB_ERROR_CODE_LOSS_OF_SIGNAL               0x10
#define SUB_ERROR_CODE_LOSS_OF_FRAME                0x11
#define SUB_ERROR_CODE_LOSS_OF_POWER                0x12
#define SUB_ERROR_CODE_LOSS_OF_MARGIN               0x13
#define SUB_ERROR_CODE_EXCESSIVE_SEVERE_ERRORS      0x15
#define SUB_ERROR_CODE_OOS_BC0                      0x18  //valid for PTM only
#define SUB_ERROR_CODE_LCD_BC0                      0x20  //valid for ATM only
#define SUB_ERROR_CODE_NCD_BC0                      0x22  //valid for ATM only
#define SUB_ERROR_CODE_EXCESS_DOWNSTREAM_CRC_ERRORS 0x24
#define SUB_ERROR_CODE_PP_DRIVER                    0x25
#define SUB_S_INTENDED_LOCAL_SHUTDOWN              0x26  // S_INTENDED_LOCAL_SHUTDOWN  - API initiated shutdown
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)

//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (Start_End)
#if 0
#define E_CODE_GHS_FE_NOT_BONDABLE       (E_COMM        | (Esub_Timeout<<8) | (309<<16))  // FE expected to be bonding capable but it's not
#endif


//STAT_OLRStatus:
#define STAT_OLRPM_IDLE                 0x0000
#define STAT_OLRPM_IN_PROGRESS          0x0001
#define STAT_OLRPM_COMPLETE             0x0002
#define STAT_OLRPM_ABORTED              0x0003
#define STAT_OLRPM_RESPONSE            0x0800
//following #define can be used as a mask to clear first 2 bits
#define STAT_OLRPM_CLR_2BITS            0x0003

#define STAT_OLR_TYPE               0x0030   // Bitmask for OLR types
#define STAT_OLR_BITSWAP                0x0010
#define STAT_OLR_DRR             0x0020
#define STAT_OLR_SRA             0x0030

//STAT_PMStatus_US:
#define STAT_PM_CO_REQ                    0x0004
#define STAT_PM_SIMPLE_REQ                0x0010
#define STAT_PM_L2_REQ                    0x0020
#define STAT_PM_L2_TRIM_REQ               0x0030
#define STAT_PM_L3_SIMPLE_REQ             0x0040


// STAT_OLRError_DS, STAT_OLRError_US
//4 bit response reason code:
#define RESP_BUSY                0x01  // For OLR, L0,L2,L3 requests. Not valid response to L2 trim request.
#define RESP_INVALID_PARAMETERS        0x02  // For OLR, L0,L2, L2 trim, L3 requests.

#define RESP_NOT_ENABLED            0x03
#define RESP_NOT_SUPPORTED          0x04

//STAT_PMError
//4 bit response reason code:
#define RESP_STATE_NOT_DESIRED           0x03   // For L3, L0 requests.
#define RESP_INFEASIBLE_PARAMETERS       0x04   // For L2, L2 trim requests.


//STAT_OLRError 4-bit internal error code (common for OLR, CO-initiated PM and ME-initiated PM (L3))
#define REQ_INVALID_BiGi               0x10
#define REQ_INVALID_Lp                 0x20
#define REQ_INVALID_Bpn                0x30
#define REQ_INVALID_FRAMING_CONSTRAINT    0x40
#define REQ_NOT_IN_L0_STATE               0x50
#define REQ_NOT_IN_L2_STATE               0x60
#define REQ_INVALID_PCB                0x70
#define REQ_VIOLATES_MARGIN               0x80
#define SYNCFRAME_INDICATOR_TIMEOUT       0x90
#define  REQ_L3_RESPONSE_TIMEOUT          (SYNCFRAME_INDICATOR_TIMEOUT)
#define REQ_ACTION_DISABLED                 0xA0

#define REQ_VIOLATE_MAXLConstraint        0x0100
#define REQ_VIOLATE_MINLConstraint        0x0200
#define REQ_VIOLATE_CWSizeConstraint      0x0400

// STAT_ME_PMREQ_ERROR internal error codes


//STAT_ACTIVEBCLP_DS, STAT_ACTIVEBCLP_US
#define LP0_ACTIVE                      0x0001
#define LP1_ACTIVE                      0x0002
#define BC0_ACTIVE                      0x0100
#define BC1_ACTIVE                      0x0200

// STAT_AFETYPE
#define STAT_EAGLE_AD6480_AFE          0x00
#define STAT_EAGLE_AD6488_AFE          0x01
#define STAT_EAGLE_AD6790_AFE          0x02
#define STAT_SILABS_3101_AFE           0x10
#define STAT_SILABS_3110_AFE           0x11
#define STAT_AMAZON_AFE                0x20
#define STAT_DATAPATH_AFE              0x30
#define STAT_FUJITSU_MB86626_AFE       0x40
#define STAT_FUJITSU_MB86627_AFE       0x41
#define STAT_PMC_AFE                        0x50
#define STAT_VINAX_AFE                 0x60

// STAT_PowerMode
#define STAT_INIT_STATE                 0xFFFF //-1
#define STAT_PM_L0                  0x0000
#define STAT_PM_L2                  0x0002
#define STAT_PM_L3                  0x0003

// STAT_Performance
#define STAT_5T1Noise                     (0x0001)
#define STAT_24HDSLNoise                  (0x0002)
#define STAT_M140WhiteNoise               (0x0004)
#define STAT_LowNoise                     (0x0008)      // less than -140 dBm/Hz
#define STAT_VLowNoise                    (0x0010)      // much less than -140 dBm/Hz
#define STAT_M120WhiteNoise               (0x0020)         //XDSLRTFW-2510(Start_End)
#define STAT_FBNoise                      (0x0040)  // FB Noise present > -105dBm/Hz
#define STAT_M130M140WhiteNoise           (0x0080)
#define STAT_FBNoiseLowThreshold          (0x0100)  //This bit is used to indicate the present of FSANB noise. This one has lower threshold than bit 6 (STAT_FBNoise) and can be used for long loops (>2000m) as well.
#define STAT_M130WhiteNoise               (0x0200)
#define STAT_24DSLNoise                   (0x0400)   // 24DSL Noise present
#define STAT_STRONG_TIMEVARY_NOISE        (0x0800)
#define STAT_OISDN_FB_NOISE               (0x1000)
#define STAT_M90M100Noise                 (0x2000) //XDSLRTFW_3663_TR100A_MV_12ADSL2Plus_AddMargin


//STAT_ME_PMREQ_STATUS              20 // Tells ME the result of its PM (L3) request.
//Same as STAT_PM_STATUS with an addition definition as below
#define STAT_PM_L3_REQ              0x40

//STAT_ME_PMREQ_ERROR            21    // Tells ME the result of its L3 request.
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End)
//ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch (start_end)
// #define STAT_PREV_EXCEPTION_STATE    22   // No Bit fields is used //
// #define STAT_PREV_EXCEPTION_CODE     23  // No Bit fields is used //
// #define STAT_SELECTED_ANX_MJ_MASK    24  // No Bit fields is used //
/* XDSLRTFW-2600 */
// STAT_QLN_Performance             25
// bit-field
#define STAT_512Bin_QLN_ON       0x1

// STAT_BITSWAP_EVACUATION          26
// bit-field
#define STAT_BS_EVACUATION_ON       0x1
/* XDSLRTFW-2600 */

//==============================================================================
// TEST register address and bit field definitions
//==============================================================================
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)

// TEST register address field
#define TEST_Control                            0
#define TEST_Mode                               1
#define TEST_InitState                          2
#define TEST_TxConfigNum                        3
#define TEST_RxConfigNum                        4
#define TEST_BertSFCnt                          5
/* sleep mode configuration */
#define TEST_TxSubState                         6
#define TEST_RxSubState                         7
#define TEST_TxTestTone                         8
#define TEST_EncoderGain                        9
#define TEST_PGA_required                       10
#define TEST_BitSwapFromTone                    11
#define TEST_BitSwapToTone                      12

// New OLR BIS CMVs
#define TEST_ReconfigControl                    13
#define TEST_OLRBitGainTone                     14
#define TEST_OLR_Lp0Delta                       15
#define TEST_OLR_Lp1Delta                       16
#define TEST_OLR_BC0Delta                       17
#define TEST_OLR_BC1Delta                       18
//#define TEST_OLRBatDelta                      19
//#define TEST_OLRGainDelta                     20
#define TEST_OLR_SRA_SettlingTime               19 //AUTO_SRA
#define TEST_OLR_SRA_DeltaLpchange              20//AUTO_SRA

// New Iridia h/w based tx reverb/segue/medley sequence generation
#define TEST_HWSequenceGeneration               21
#define TEST_Control2                           22// Miscellaneous
#define TEST_ErrorGenerateType_US               23
#define TEST_ErrorDuration_US                   24
#define TEST_ErrorGenerateType_DS               25
#define TEST_ErrorDuration_DS                   26
#define TEST_SETPLATINUMCOFINEGAIN              27
#define TEST_Control3                           28
#define TEST_SuppressErrorReportingToME         29
#ifdef DANUBE
#define TEST_MODE_LOOPBACK                      30
#else
#define TEST_6488TrimThreshold                  30 // Note: In 1.5.x this was was for power cutback
#endif

#define TEST_TCR0setting                        31
#define TEST_OffsetRxCalibration                32 // Q9.7 ;; Positive value means 'hotter' board design -> adds to RxFiltComp
#define TEST_PCB_Delta_bis                      33 // Initializes gs_PCB_DS_Delta_bis

#if defined  (DANUBE_WB) ||defined (VR9_ERASURE)
#define TEST_ERASURE_WB3_control                34
#define TEST_ERASURE_METRIC_control             35
#define TEST_ERASURE_EFFECTIVE_INP_LP0          36
#define TEST_ERASURE_EFFECTIVE_INP_LP1          37
#endif

#define Test_DoublePGATraining                  38
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
#define Test_DisableBitSwapImprvmnt             39
//XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg(start_end)
#define Test_DisableShowClkAveraging            40
#define Test_ErasureGains                       41
#define Test_Erasure_HW_Block                   42 // XDSLRTFW-2126
#define TEST_GHS_LOG                            43 //XDSLRTFW-2358 (start)
#define TEST_FREEZE_CPE_TX                      44 //XDSLRTFW-1887
#define TEST_MSGDSOverheadRate                  45 // XDSLRTFW-2376
#define TEST_Control4                           46 // TEST_46  XDSLRTFW-4039
#define TESTARRAY_SIZE                          (TEST_Control4 + 1)

//XDSLRTFW-1887: (Start)
//Freeze CPE Tx in states as recommended in WT-138
#define TEST_FREEZE_CPE_TX_R_REVERB_2              (0x0001)
#define TEST_FREEZE_CPE_TX_R_REVERB_7              (0x0002)
#define TEST_FREEZE_CPE_TX_R_MEDLEY                (0x0004)
#define TEST_FREEZE_CPE_TX_SHOWTIME                (0x0008)
#define TEST_FREEZE_CPE_TX_SHOWTIME_UNITY_GAIN     (0x0010)
//XDSLRTFW-1887: (End)

// TEST_GHS_LOG
#define TEST_GHS_LOG_ENABLE                          (0x0001)
#define TEST_GHS_INC_THRESHOLD                       (0x0002)
#define HALT_AFTER_TONE_DETECTION                    (0x0008)
#define TEST_GHS_LOG_PREDETECTIOON                   (0x0010)
#define TEST_GHS_LOG_ALWAYS_USED_SYMBOLS             (0x0020)
// To control gft_GotoFailStateOnTimeOut_FromHandshake
#define TEST_GHS_LOG_NotToGoFailState                (0x0040)
#define TEST_GHS_LOG_TONE_BUF                        (0x4000)
#define TEST_GHS_LOG_US_TONES                        (0x8000)




// TEST_Control4
#define TEST_Control4_Autonomous_State_Event_Msg_Bit11_Mask  (0x0800)  // 1==> Enable Autonomous State Event Messaging, 0==> Disable Autonomous State Event Messaging (Default) ////XDSLRTFW-4039


// TEST_Control
#define TEST_ChannelControl            0x0001
#define TEST_EchoControl            0x0002
#define TEST_BertControl            0x0004
#define TEST_ConnControl            0x0008
#define TEST_StryControl            0x0010
#define TEST_BISUSTCMDisable        0x0020  // BIS US TCM Disable (for Showtime Only Tests)
#define TEST_SkipNoiseControl       0x0080
#define TEST_BertSFControl          0x0100
#define TEST_UpsampleControl        0x0200
#define TEST_AlphaeusControl        0x0400
#define TEST_ForceBitSwap           0x0800
#define TEST_TestBitSwap                0x1000
#define TEST_TestOLRPM              0x2000
#define TEST_AlphaeusTPEnable       0x8000  // Alphaeus transparent mode enable
#define TEST_RUN_ANYLIF_VR9            0X4000      // VR9 continue test with any LIF module

// TEST_InitState
#define TEST_GhsInitState           0x0000
#define TEST_TrainInitState            0x0001
#define TEST_ShowtimeInitState         0x0002
#define TEST_RetrainInitState       0x0003
#define TEST_T1413InitState            0x0004

// TEST_ReconfigControl
#define TEST_OvhdMessaging          0x0001
#define TEST_ForceBitswap           0x0002
#define TEST_TestBitswap            0x0004
#define TEST_TestOLR             0x0008
#define TEST_USTssi_Inconsistency       0x0010  //Test US Tssi Inconsistency

#define TEST_TestL2Timeout                              (0x0020)
#define TEST_TestL2TrimTimeout                          (0x0040)

#define TEST_ForceFR                                    0x1000

//TEST_HWSequenceGeneration
#define TEST_SwSequenceGeneration            0x0000
#define TEST_HwReverbSegueSequenceGeneration 0x0001
#define TEST_HwDMTMedleySequenceGeneration      0x0002
#define TEST_HwBISMedleySequenceGeneration      0x0004

// TEST_Control2
// Miscellaneous controls. To be defined.
#define TEST_ConnTypeBit0           0x0001   // Used together with TEST_ConnTypeBit1. Specifies which channel DLL is used. Must be used in conjunction with TEST_ConnControl. 00 = DLI, 01 = Sachmo, 10 = Sample-based DLI
#define TEST_ConnTypeBit1           0x0002
#define TEST_UseAlpBC1AsTPS0             0x0004  // Enable SW workaround for Utopia bug
#define TEST_ForceTestParamUpdates       0x0008  // Force showtime updates of PMD Test Params reported to CO, without requiring an UpdateTestParams message from CO.
#define TEST_DisableSRCUpdates         0x0010
#define TEST_ForceCWSize247            0x0020  // force CW size to be 247 for Infineon CO
#define TEST_DisableNomATP          0x0040  // Disable NomATP
#define TEST_UserDefinedCh          0x0080   // User define gs_TxMedleyFirstCh/gs_TxMedleyLastCh (applicable in DMT ONLY) and gs_RxBitLoadFirstChannel/gs_RxBitLoadLastChannel (applicable in all modes)
#define TEST_SINGLECRYSTALMODE         0x0100      // to set SRC value correctly for single crystal mode
#define TEST_AfeDynamicTrim            0x0200      // Use dynamic trim value on 6488
#define TEST_AfeNominalTrim            0x0400      // Use nominal trim value on 6488, if dynamic-original trim exceeds a certain threshold
#define TEST_AltPOTSTxHPF               0x0800      // Use this bit to use an alternative TxHPF for POTS to make
// some AFEs to be standard compliant on its PSD.
#define TEST_OverWriteMSwithCNFG_ADSL2 0x1000      // use this bit to overwrite gt_Handshakebis structure with CNFG CMV values over the MS values                                                  // some AFEs to be standard compliant on its PSD.
#define TEST_TrellisOnOff           0x2000      // when set code explores Trellis off, for INP=0, Latency = 1ms, single latency adaptive rate case


// TEST_ErrorGenerateType_US
// Used to force various US errors for testing. Bits 4:0  are used to enable different types of US errors.  Any combination
// of errors may be enabled simultaneously.
// Bit 15 indicates whether duration of errors specified in TEST_ErrorDuration_US is in units of time (seconds)
// or is an event count. Bits 14 to 5 are reserved
#define TEST_ErrorType_DurationUnits         0x8000      // 0 = event count, 1 = # of seconds
// The individual US events are as follows.
#define TEST_ErrorType_US_CRC             0x0001      // Send a bad CRC value
#define TEST_ErrorType_US_ATM_Payload        0x0002      // Induce one bit error in ATM payload.
#define TEST_ErrorType_US_ATM_Header         0x0004      // Send a bad HEC.
#define TEST_ErrorType_US_Sync_Symbol        0x0008      // Zero out sync symbol.
#define TEST_ErrorType_US_Power              0x0010      // Zero out entire Tx signal.
#define TEST_ErrorType_US_FEC                0x0020      // generate US FEC error

// TEST_ErrorDuration_US
// A 16-bit unsigned value indicating duration of errors.  Units depend on bit 15 of TEST_ErrorGenerateType_US and are either
// event count or seconds.  Writing a non-zero value to this location will initiate generation of errors.  This value will
// be automatically decremented by the code according to either the number of errors generated or the elapsed time.  When
// it reaches zero, error generation will stop.  The special value of 65535 will disable decrementing so that errors will
// be generated indefinitely.

// TEST_ErrorGenerateType_DS
// Used to force various DS errors for testing. Bits 6:0  are used to enable different types of DS errors. Any combination
// of errors may be enabled simultaneously.  These errors are induced by forcing error flags on or forcing error counters
// to increment.  The DS data is not changed.  Therefore it is possible to, for example, generate CRC errors without
// generating bit errors, which in reality could not happen.  Other unrealistic combinations are possible.
// Bit 15 indicates whether duration of errors specified in TEST_ErrorDuration_DS is in units of time (seconds)
// or is an event count. Bits 14 to 7 are reserved

// The individual US events are as follows.
#define TEST_ErrorType_DS_LPR             0x0001      // Loss of power
#define TEST_ErrorType_DS_ATM_Payload        0x0002      // Bit error in idle cell.
#define TEST_ErrorType_DS_LOM             0x0004      // Loss of margin
#define TEST_ErrorType_DS_ATM_Header         0x0008      // HEC error
#define TEST_ErrorType_DS_CRC             0x0010      //
#define TEST_ErrorType_DS_LOF             0x0020      // Loss of framing
#define TEST_ErrorType_DS_LOS             0x0040      // Loss of signal
#define TEST_ErrorType_DS_FEC             0x0080      // generate DS FEC error
#define TEST_ErrorType_DS_OCD             0x0100      // generate DS OCD error

// TEST_ErrorDuration_DS
// A 16-bit unsigned value indicating duration of errors.  Units depend on bit 15 of TEST_ErrorGenerateType_DS and are either
// event count or seconds.  Writing a non-zero value to this location will initiate generation of errors.  This value will
// be automatically decremented by the code according to either the number of errors generated or the elapsed time.  When
// it reaches zero, error generation will stop.  The special value of 65535 will disable decrementing so that errors will
// be generated indefinitely.

// TEST_SuppressErrorReportingToME

#define TEST_SuppressLOSFailureToME                   0x0001   //suppress reporting of LOS failure is implemented for both bis/plus and dmt
#define TEST_SuppressSNRMarginToME                 0x0002
#define TEST_SuppressCRCBasedLosToME               0x0004
#define TEST_SuppressFailStateToME                 0x0008   // suppress showtime to fail state transition
#define TEST_SuppressSEFTrigSNRMToME                0x0010 //suppress 10sec SEF trigger negative SNRM strategy to ME
#define TEST_SuppressShowtimeSNRUpdateCntStuckToME  0x0020 //suppress 10sec SNR update counter stuck trigger negative SNRM strategy to ME

//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
#define TEST_SuppressES90FailureToME                0x0040
#define TEST_SuppressSES30FailureToME               0x0080
#define TEST_SuppressESEFailureToME                 0x0100
#define TEST_SuppressOOSFailureToME                 0x0200
#define TEST_SuppressLOFFailureToME                 0x0400
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)
// XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start_End)
#define TEST_SuppressLPRFailureToME                 0x0800
//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
#define TEST_SuppressNCDFailureToME                 0x1000
#define TEST_SuppressLCDFailureToME                 0x2000

//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
// TEST_Control3
#define TEST_FineGainDisable                       (0x0001)
//XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement (Start_End)
#define TEST_ForceUpStreamFineGainsToUnity         (0x0002)
//ADSLRTFW-1582 FEATURE_DS_BisPlus_ALL_GainScaleInL2Mode_Amd4G9923 (Start_End)
#define TEST_L2ModeAmd4G9923_L2LpConditionDIS      (0x0004)
#define TEST_SuppressCRCIbToCO                     (0x0008) // ADSL1 only
#define TEST_SuppressLosIbToCO                     (0x0010) // All modes.
#define TEST_SuppressSefIbToCO                     (0x0020) // All modes.
#define TEST_SuppressCdIbToCO                      (0x0040) // All modes.
#define TEST_SuppressLprIbToCO                     (0x0080) // DSL2 only.
#define TEST_SuppressHecIbToCO                     (0x0100) // AADSL1 only.
#define TEST_SuppressPmdTestParamsToCO             (0x0200) // ADSL2 only: CPE will not update the following during showtime: 1)SNRM, 2)SNR, 3)ATTNDR.
#define TEST_SuppressPmsMngmtCntrsToCO             (0x0400) // ADSL2 only.  All counters will be reported as zero.  No effect on actual counts kept.
#define TEST_SuppressTpsMngmtCntrsToCO             (0x0800) // ADSL2 only.  All counters will be reported as zero.  No effect on actual counts kept.
// XDSLRTFW-1502 DSL 1 0 CMV must be used, this is discarded
//#define TEST_EnableErasure            (0x1000)
#define TEST_Control3_Test28_Bit12Mask             (0x1000) // Available to use!!
#define TEST_DisableAutoMsgTcMode                  (0x2000) // XDSLRTFW-3105 (Start_End)
#define TEST_Control3_A21OldLifHyb                 (0x4000)
#define TEST_DisableL3Mode                         (0x8000) // Disable L3 mode

#ifdef DANUBE
//TEST_MODE_LOOPBACK
#define TEST_ANALOG_LOOPBACK        1        // uses loop at DAC -> agc2 ->ADC.
#endif


//Test_DoublePGATraining
#define Test_Enable_DoublePGATraining_Xcvr   0x0001


#define Test_Erasure_HW_Block_ON             0x0001   // XDSLRTFW-2126
//==============================================================================
// OPTN register address and bit field definitions
//==============================================================================
//XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min (start_end)
#define OPTNARRAY_SIZE              36    //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start_End)


//#ifdef HERC_API

#define OPTN_0_SIZE                 (2)
#define OPTN_2_SIZE                 (3)

//XDSLRTFW-731 FIX_All_All_All_EnableBitSwapsAsPerVRxMsgSpec (Start_End)
//Memory optimization is done to get some free space in BULK_DATA_RAM_DMSWAP
#define CNFG_0_SIZE                 (22)  //was 28

//#endif



#define OPTN_ModeControl            0
#define OPTN_DMTLinkControl            1
#define OPTN_AlgControl             2
#define OPTN_GhsControl             3
/* Reserved                      4 */
#define OPTN_PwrManControl          5
#define OPTN_AnnexControl           6
#define OPTN_ModeControl1           7  /* this is for future use */
#define OPTN_FFTBufferControl       8
#define OPTN_StateMachineCtrl                       9
#define OPTN_Log2NumShowtimeFDQTrainingSymbols     10
#define OPTN_Log2NumShowtimeSNRTrainingSymbols     11
#define  OPTN_Log2NumShowtimeDECTrainingSymbols    12
#define OPTN_ATMAddrConfig                   13
#define OPTN_ATMNumCellConfig                14
#define OPTN_OLRControl_DS                   15
#ifdef HERC_API
//XDSLRTFW-380 Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
#define OPTN_15_SIZE          1
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
#define OPTN_25_SIZE          1
//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (start_end)
#define OPTN_28_SIZE          12   //as per VR9 Msg Spec, "HERC OPTN 28" contains "2 elements" (i.e. deltaTARSNRMds, deltaTARSNRMus)
#endif

#define OPTN_AlgControl2                     16
#define OPTN_FgainAdjust_ShortLoop                  17  //Fine gain adjust (dB) in short loop
#define OPTN_FgainAdjust_LongLoop                   18  //Fine gain adjust (dB) in long loop
#define OPTN_FgainAjust_Threshold                   19  //Fine gain adjust threshold. If ncloaded < this value, "long" loop positive fine
// gain adjustment will be applied.
// value of ncloaded below which fine gain adjust to positive avergae fine gain is made.
#define OPTN_MarginDelta                     20  //Margin delta (8.8 (dB); positive value means we bitload with less than CO-desired

#define OPTN_FgainAdjust_MedLoop                    21  //Fine gain adust (dB) in medium loop
#define OPTN_FgainAjust_Threshold2                  22  //Fine gain adjust threshold. If ncloaded > this value, "short" loop positive fine
// gain adjustment will be applied.
#define OPTN_MaxNomAtpAdjust                       23  //Max Nomatp adjust (dB) in 0.1 dB increments
#define OPTN_InterruptControl                       24  //ARC-MEI Interrupt control
//Note: OPTN_AlgControl3 is moved from "25" to "33" //XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33 (Start_End)
#define OPTN_CIPolicy                              26 // Bitload to maximize Margin or INP in fixed and limited rate case
#define OPTN_ExtraINP                               27  // Extra INP protection in fixed and limited rate case when OPTN_CIPolicy is 0.
#define OPTN_DesiredMarginAdjust                    28  // Desired margin adjustment for bis/plus mode, set in 0.1dB Resolution
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START_END)
#define OPTN_SRA_OFFSET                      29
#define OPTN_Power_Management                   31


//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
   // OPTN_TXPathControl - initialize to '0'
   // bit  0:  STATUS      (ReadOnly, 0: US-performance-code bypassed, 1: US-performance code used in training)
   // bit  1:  ENABLE_DMT  (not supported)
   // bit  2:  ENABLE_BIS  (not supported)
   // bit  3:  ENABLE_PLUS (0: disabled, 1: enabled, to be set by API)
#define OPTN_TXPathControl                         30  //
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)
//XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min (start)
#define  OPTN_31_RESERVED 31 //L2 exit bits
#define  OPTN_INVSMIN_SRA_NoOptIntlvDepth   32
//XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min (end)
/* Mode control defines the allowable operating modes of an ADSL link. In general, a modem may */
/* use G.Hs or some other mechanism to negotiate the specific mode of operation. */
/* The OPTN_ModeControl CMV is used to select a set of desired modes */
/* The STAT_ModeControl CMV indicates which mode was actually selected */

//XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33 (Start_End)
#define OPTN_AlgControl3                     33  //Miscellaneous controls
// XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (start_end)
#define  OPTN_SRA_RATE_DEGRADATION           34
// XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops (Start)
#define  OPTN_RX_FIRST_CHANNEL               35

//XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops (End)




// OPTN_ModeControl (OPTN 0)
#define OPTN_ConfigMode_T1413       0x0001
#define OPTN_ConfigMode_G992_2_AB      0x0002
#define OPTN_ConfigMode_G992_1_A    0x0004
#define OPTN_ConfigMode_G992_1_B    0x0008
#define OPTN_ConfigMode_G992_1_C    0x0010
#define OPTN_ConfigMode_G992_2_C    0x0020

#define OPTN_ConfigMode_G992_3_A    0x0100
#define OPTN_ConfigMode_G992_3_B    0x0200
#define OPTN_ConfigMode_G992_3_I    0x0400
#define OPTN_ConfigMode_G992_3_J    0x0800
#define OPTN_ConfigMode_G992_3_L    0x1000
#define OPTN_ConfigMode_G992_3_M    0x2000

#define OPTN_ConfigMode_G992_5_B    0x4000
#define OPTN_ConfigMode_G992_5_A    0x8000

// OPTN_ModeControl1 (OPTN 7)
// (bit definitions for the newly appended mode-control word)
//(A: US 6-31; M: US 6-+63; I: digital-A, J: digital-M)
#define OPTN_ConfigMode_G992_5_I    0x0001
#define OPTN_ConfigMode_G992_5_J    0x0002
#define OPTN_ConfigMode_G992_5_M    0x0004
#define OPTN_ConfigMode_ETSI_AnnexC     0x0008
#define OPTN_ConfigMode_G993_1          0x0100
#define OPTN_ConfigMode_G993_2          0x0200
#define OPTN_ConfigMode_T1_MCM_VDSL     0x0400
#define OPTN_ConfigMode_G9701           0x0800

/* DMTLinkControl (OPTN 1)
    controls a set of DMT specific parameters including framing mode, number of */
/* latency paths, S=1/2 disable, and dual latency disable */

// OPTN_DMTLinkControl (OPTN 1)
#define OPTN_FMMask                 0x000F
#define OPTN_FM0                 0x0000
#define OPTN_FM1                 0x0001
#define OPTN_FM2                 0x0002
#define OPTN_FM3                 0x0003
#define OPTN_SHALF_Disable          0x0100
#define OPTN_DualLatency_Disable    0x0200

#define OPTN_RS16Support_Disable    0x0400
#define OPTN_DiagMode_Enable        0x0800
#define OPTN_TransferModeMask       0xF000
#define OPTN_STM_TransferMode       0x1000
#define OPTN_ATM_TransferMode       0x2000

// OPTN_AlgControl (OPTN 2)
#define OPTN_DECDnldDisable            0x0001
#define OPTN_TDQDnldDisable            0x0002
#define OPTN_Run_TDQ_at_1104        0x0004
/* AEC download is disabled by default (temporary) */
#define OPTN_AECDnldDisable            0x0008
#define OPTN_DECAdaptDisable        0x0010
#define OPTN_DSAutoBitSwapDisable      0x0020      /* Enable internal logic based auto DS bitswaps */
#define OPTN_IFFT128_Enable            0x0040
#define OPTN_DECTaperDisable            0x0080
/* Medley Control */
#define OPTN_MedleyControlMask         0x0300
#define OPTN_MedleyTdqEnable        0x0100   /* Enables Medley Multi-tdq calculation */
#define OPTN_MedleyTdqOffEnable        0x0200   /* Enables TDQ-off case during Multi-tdq calculation */


#define OPTN_ForceFR             0x1000
#define OPTN_TCM_Disable            0x2000   /* The OPTN_TCM_Disable is used to control TCM for DMT. For BIS, it controls DS TCM only */
#define OPTN_USTssiDisable             0x4000   /* The OPTN_USTssiDisable bit is used to control tssi in US TX. */
#define OPTN_USBitSwapDisable       0x8000      /* Disable US bitswap */

// OPTN_GhsControl (OPTN 3)

/* **************************************************************************
* for OPTN_GhsControl, we will assign 16bit word as follows
* bit 0~3: set the control over which start(initial) message CPE will send:

        BIT: 2  1  0
            0  0  1  CLR
            0  1  0  MR
            0  1  1  MS
            1  0  0  MP

* bit 4~6: set the control over which message will be sent when we get at lease one CL/CLR exchange
        BIT: 5  4
            0  1  MS
            1  0  MR
            1  1  MP

* bit 8: set to send shortened CLR (no segmentation problems for the CO) in a DMT/BIS multimode startup

* bit 15: RT initiated G.hs sample sessions one through eight.  Session one is default.
        BIT: 15
            1  means session one

******************************************************************************/

#define OPTN_GHS_ST_GHS          0x8000
#define OPTN_GHS_INIT_MASK       0x000F
#define OPTN_GHS_RESP_MASK       0x00F0

#define OPTN_RTInitTxMsg_CLR     0x0001
#define OPTN_RTInitTxMsg_MR         0x0002
#define OPTN_RTInitTxMsg_MS            0x0003
#define OPTN_RTInitTxMsg_MP         0x0004

#define OPTN_RTRespTxMsg_MS            0x0010
#define OPTN_RTRespTxMsg_MR         0x0020
#define OPTN_RTRespTxMsg_MP           0x0030

#define OPTN_RTMMode_ShortCLR    0x0100
// 0x200 was CTLM interop up to Rel 1.5.x - keep it inactive for a while
#define OPTN_Ghs_Rev1            0x0400

#define OPTN_DelayCPilot1Det     0x1000
#define OPTN_DisableFailOnRxOvfl    0x2000
// When CTLM vendor ID detected in CL, fail G.hs and restart, next time
// sending AWRE vendor ID.  This results in better US rates in ADSL2/2+.
#define OPTN_DisableCTLMVendorIDChange    0x4000

// OPTN_PwrManControl
#define OPTN_PwrManWakeUpGhs           0x1
#define OPTN_PwrManWakeUpFR            0x2
#define OPTN_ExMarginRedDisable        0x4         /*  excess margin reduction using finegains*/
#define OPTN_MonitorToneGain           0x8         /*  Monitor Tone Gain*/

//    OPTN_AnnexControl

// G.992.3 Annex A/L1/L2 US PSD Mask preferred
#define OPTN_Force_US_PSD_control            0x0800         /* User-forced US PSD (currently should be used only for Annex 3A/L) */
#define OPTN_G992_3_AnnexA_PreferredModeMask 0x3000
#define OPTN_G992_3_AnnexA_PreferredModeA    0x0000         /* default AnnexA PSD mask */
#define OPTN_G992_3_AnnexA_PreferredModeL1      0x1000         /* AnnexL wide spectrum upstream PSD mask */
#define OPTN_G992_3_AnnexA_PreferredModeL2      0x2000         /* AnnexL narrow spectrum upstream PSD mask */

// OPTN_FFTBufferControl
#define OPTN_FFTBufferTrainControlMask    0x0007
#define OPTN_TrainScenario1               0x0001
#define OPTN_TrainScenario2               0x0002
#define OPTN_TrainScenario3               0x0003
#define OPTN_TrainScenario4               0x0004
#define OPTN_FFTBufferShowtimeControlMask 0x0070
#define OPTN_ShowtimeScenario1            0x0010
#define OPTN_ShowtimeScenario2            0x0020
#define OPTN_ShowtimeScenario3            0x0030
#define OPTN_ShowtimeScenario4            0x0040

// OPTN_StateMachineCtrl
#define OPTN_Skip_RLineProbe           0x0001    /* Bis only */
#define OPTN_ForceExplicitRate            0x0002
#define OPTN_EnableDiagMode               0x0004    /* Bis only */
#define OPTN_FFT1024_Enable               0x0008   // set rx fft length of 1024

#define OPTN_G992_5_14thOrderPRBS_Enable  0x0010   // if set, use 14th order prbs medley sequence in g992_5 mode
#define OPTN_EnableShortInit                0x0020  // if set, CPE will request Short Init in GHS
#define OPTN_FFT512_Enable_PostGHS        0x0040   // set rx fft length of 512 after G.HS
#define OPTN_IFFT64_Enable_PostGHS        0x0080   // set tx fft length of 64 after G.HS
#define OPTN_EnableDataOnPilot_Bis        0x0100   // enables data on pilot, valid for ADSL2/+ modes only
#define OPTN_IFFT64_DISABLE_PostGHS       0x0200   // forces IFFT to 128 ignoring vendor id.
#define OPTN_ForceEnableSmallerS            0x0800  // Force smaller S, for now, means S=1/4
#define OPTN_SONEFOURTH_ENABLE            0x1000  // Set S=1/4
#define OPTN_TssiCeil_Disable          0x2000  // disables tssi ceiling to work with CO's that havent implemented this
#define OPTN_PilotOnDecTraining_Bis       0x4000   // RT asks the CO to transmit a pilot tone during R-ECT instead of quiet (Bis)
#define OPTN_PilotOnDecTraining_DMT       0x8000   // RT asks the CO to transmit a pilot tone during R-ECT instead of quiet (DMT)


//OPTN_ATMAddrConfig (OPTN 13)
// Bits 4:0    are Utopia address for BC1
// Bits 9:5    are Utopia address for BC0
// Bits 13:12   byte flip control
#define OPTN_UTPADDR_BC1               0x001F
#define OPTN_UTPADDR_BC0                    0x03E0
#define OPTN_ATM_BYTEFLIP_DISABLE           0x1000
#define OPTN_ATM_BYTEFLIP_ENABLE            0x2000
#define OPTN_FORCE_UTPTXBYPASS            0x4000
#define OPTN_FORCE_UTPRXBYPASS            0x8000

//OPTN_ATMNumCellConfig (OPTN 14)
// Number of Rx ATM Cell buffers used.  Current max setting supported is 18.
#define OPTN_RX_BC0_NUM_CELL_PAGES           0x001F /* Bits 4:0.   */
// Number of Tx ATM Cell buffers used.  Current max setting supported is 9.
#define OPTN_TX_BC0_NUM_CELL_PAGES           0x0F00 /* Bits 11:8 */

//OPTN_OLRControl_DS (OPTN 15)
#define OPTN_Disable_MarginVal_OLR        0x0001 // disable margin validation OLR
// Not Used.  Reserved                 0x0002 // Formerly OPTN_HDLCMsgSegmentEnable.

//XDSLRTFW-395 Feature_All_All_All_BitSwap_CMVRemap (Start)
#ifdef HERC_API
#define OPTN_15_HERC_BitSwap_US           0x0010
#define OPTN_15_HERC_BitSwap_DS           0x0020
#endif
//XDSLRTFW-395 Feature_All_All_All_BitSwap_CMVRemap (End)

//XDSLRTFW-380 Feature_US_BisPlus_All_USSRA_CMVRemap (start)
#ifdef HERC_API
#define OPTN_15_HERC_AutoSRA_US           0x0002
#endif
//XDSLRTFW-380 Feature_US_BisPlus_All_USSRA_CMVRemap (end)
#define OPTN_EnableAutoSRA                  0x0004 //enable auto SRA
#define OPTN_ForceDSAutoBitswap_ADSL2     0x0008   /* Force DS bitswap by lowering thresholds */

// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (START)
#define OPTN_DisableUSSRA                  0x0100  // disable US SRA
#define OPTN_DisableL2Mode                 0x0200  // disable L2 mode
#define OPTN_DisableL3Mode                 0x0400  // disable L3 mode //feature shifted to test 28 and bit 15
// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (END)

// OPTN_AlgControl2 (OPTN 16)
#define OPTN_AlgControl2Reserved            0x000F  // Functionality removed from these bits
#define VRX518_Margin_delta_3L_BDCM          0x0001  // Remove margin for BDCM 3L

#define OPTN_6790_PerformHybTrain         0x0010   // Do the ADI 6790 AFE hybrid search train (o.w. go through normal 6488-like PGA train)
#define OPTN_Detect_LowNoise           0x0020   // Detect low noise (<-140 dBm/Hz) and bitload more conservatively by 3 dB
#define OPTN_MarginD_IntlvDMTonly         0x0040   // Enable MarginDelta only in DMT interleave path (otherwise everywhere)
#define OPTN_MarginD_SelectDMTonly        0x0080   // Enable MarginDelta only against BDCM/ALA in DMT
#define OPTN_ShortFGAdjust_allCOs         0x0100   // Enable (DMT) short loop FGainAdjust against all CO's - otherwise only ALA, BDCM
#define OPTN_EnableDGasp                    0x0200  // Enable Dying gasp
#define OPTN_ForceAutoBitswap          0x0400  /* Force Autobitswap always ON without making internal disable decision against some specific CO*/
#define OPTN_FavorINPOverRate          0x0800   // Favor INP = 2frames over rate in case handshake INP is less
#define OPTN_FdqAdaptDisable           0x1000      // Disable FDQ adaptation
#define OPTN_NoiSMA_VR9_oPOTS          0x2000   // Reserved for possible NoiSMA control
#define OPTN_NoiSMADisable             0x4000   // Set to 1 to disable NoiSMA
#define OPTN_AlcRevRedAdj              0x8000   // Set to 1 to disable use of extra reverb noise margin reduction on straight loops and 50ft bridgetaps and 17.5kft bridgetaps against Alcatel ADLT-J CO

//OPTN_InterruptControl                       24  //ARC-MEI Interrupt control
#define OPTN_ARC2MEI_Interrupt_Enable       0x0001  // Set to 1 to enable ARC to MEI general interrupt triggering

#ifdef HERC_API
#define OPTN_25_HERC_EocPollPrio1_ENABLE    0x0008
#define OPTN_25_HERC_EocPollPrio2_ENABLE    0x0010

//OPTN 28 (gt_HercADSL_OPTNMap_MarginControl)
// ADC Noise estimation
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN         0x0001 //(default)Enable will add new NMS vector to MEDLEY, and showtime adaptation of NMS Vector
#define OPTN_NoiseMarginChange_NM_Ctrl_ADC_MEDLEY_EN  0x0002 //Enable will compute ADC noise in Medley
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_DELTA      0x0004 // Enable will take AGC delta from OPTN 28 2 index
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_ST_Changes 0x0008 // Showtime changes
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_PllRef     0x0010 //(default) Enable will take backup of Pll Ref Tone in delta PGA and restrore in default
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_SNR_Save   0x0020 // (default)Save 3dB SNR in MedleySnr buffer/Copy Reverb SNR, Medley SNR
#define OPTN_NoiseMarginChange_NM_Ctrl_ECTTrain_DELTA 0x0040 // R-ECT training with +3dB ( not used)
#define OPTN_NoiseMarginChange_NM_Ctrl_ADC_REVERB_EN  0x0080 //(default)Enable will compute ADC noise in REVERB Rx only


//TxNoise measurement (PD Down)
#define OPTN_NoiseMarginChange_NM_Ctrl_TxNoise_REVERB       0x0100 //(default) Enable will compute Transmitter noise in REVERB Rx only
#define OPTN_NoiseMarginChange_NM_Ctrl_TxNoise_PILOT1       0x0200 //Enable will compute Transmitter noise in PILOT1
#define OPTN_NoiseMarginChange_NM_Ctrl_Tx_ReverbEcho_Meas   0x0400 //Enable will compute REVERB Echo measurement by sending REVERB signal in R-ECT
#define OPTN_NoiseMarginChange_NM_Ctrl_UseEchoSNR_For_Medley 0x0800 // ((default) Enable will take diff of REVERB QUIET and MEDLEY (ISI, linear echo will be included here)
#define OPTN_NoiseMarginChange_NM_Ctrl_No_ISINoise_Add         0x1000 // to reduce ISI noise in NMS computation
#define OPTN_NoiseMarginChange_NM_Ctrl_No_ADCNoise_Add         0x2000 // to reduce ADC noise in NMS computation
#define OPTN_NoiseMarginChange_NM_Ctrl_No_TxNoise_Add         0x4000  // to reduce TxNoise in NMS computation
#define OPTN_NoiseMarginChange_NM_Ctrl_compute_OldNMS_vec     0x8000



#endif

// OPTN_AlgControl3           33   //XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33 (Start_End)
//XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(Start_End)
#define CMV_TO_SEND_VDSL_MODES_IN_SHORT_CLR  0x0002
//ChihWen: bug fix of no sync when shine noise is injected (START_END)
#define CMV_TO_DISABLE_HW_SNR_FDQ         0x0008
//SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop.
#define CMV_TO_BoostGhsToneDetScale   0x0100
// IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout (Start)
#define CMV_TO_ENABLE_DTAG_US_PERF_DS_PERF 0x0200
// IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout (End)
#define CMV_TO_DETECT_CTREF_LONG_LOOPS 0x0400   //XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33 (Start_End)

//XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication (START)
#define CMV_TO_ENABLE_AFE_FAIL_EXCEPTION 0x0800
//XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication (END)
#define CMV_TO_ENABLE_FRACTIONAL_INP_FRAMEWORK 0x1000
// IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413(Start)
#define CMV_TO_IncreaseGhsToneDetectScale       0x2000         /* XDSLRTFW-2191 */
// IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413(End)

// XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_End)
//#define CMV_TO_ENABLE_US_INLV_DEPTH_STD 0x2000  //Moved to DSL 13
//BugFix_ALL_ALL_ALL_DisableB43J43Detection (Start_End)
#define CMV_TO_ENABLE_ANNEXM_B43_J43_TONES_BRCM  0x4000
//SMS00914848 DS_PERF_ALL_PllSnrThresshold (START_END)
#define CMV_TO_ENABLE_TEMPCHAMBER_PLL_THRESSHOLD  (0x8000)

//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
//As per VRx Msg Spec 1.9, "OPTN 25 Bits(15:9)" is reserved for "FE counter polling"
//So, while integrating the fix from VR9 R3.5 to R5.2, CMV is moved to "OPTN 16 Bit-0"
//#define CMV_TO_ENABLE_LINK_DROP_FOR_DYING_GASP   0x4000
#define CMV_TO_ENABLE_LINK_DROP_FOR_DYING_GASP  0x0001
//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

/* CNFG register address field */
//Increased the size of the Array to 46
//XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_End)
//Increased the size of the Array to 47
//XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start_End)
//XDSLRTFW-230 Bug_All_All_All_ResolveCnfg17Conflict (Start_End)
#define CNFGMAP_SIZE             48

/* these cmvs are used by bis handshake */

// Each of the CNFG_TPS entries points to a structure of type (TPS_TC_BearerChannel_t)
#define CNFG_TPS_TC_DS0             0
#define CNFG_TPS_TC_DS1             1
#define CNFG_TPS_TC_US0             2
#define CNFG_TPS_TC_US1             3

#define CNFG_HDLC_Overhead_Requirements   4

// Each of the CNFG_PMS entries points to a structure of type (PMS_TC_LatencyPath_t)
#define CNFG_PMS_TC_DS0             5
#define CNFG_PMS_TC_DS1             6
#define CNFG_PMS_TC_US0             7
#define CNFG_PMS_TC_US1             8

// CNFG_PMD_PARAMETERS points to a structure of type (PMD_params_t)
#define CNFG_PMD_PARAMETERS            9

/* these cmvs are used by bis training and showtime code */




/* Tx Config */
#define CNFG_tx_Cnfg_Nbc               (10)
#define CNFG_tx_Cnfg_Nlp               (11)
#define CNFG_tx_Cnfg_Rp                (12)
#define CNFG_tx_Cnfg_Mp                (13)
#define CNFG_tx_Cnfg_Lp                (14)
#define CNFG_tx_Cnfg_Tp                (15)
#define CNFG_tx_Cnfg_Dp                (16)

//XDSLRTFW-230 Bug_All_All_All_ResolveCnfg17Conflict (Start_End)
//CMV located changed to 47 (and kept at proper place) to resolve the conflict with VRx message spec for bonding feature
//#define CNFG_tx_Cnfg_Bpn             (17)

//XDSLRTFW-230 Bug_All_All_All_ResolveCnfg17Conflict (Start)
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (Start)
#ifdef ADSL_BONDING
//-------------------------------------------------------------------------------------
// Bonding is also known as PAF (PME Aggregate Function)

#define CNFG_Bonding_DiscAggr_Control     (17) // Points to structure of type (Bonding_DiscAggr_Control_t)

// Bit fields used in CNFG 17 0 are listed below
// [0]   :  PAF Enable - 0:Disable: 1: PAF:Enable
// [15:1]:     Reserved

#define CNFG_PAF_ENABLE_MASK     1
#define CNFG_PAF_ENABLE_SHIFT    0

#endif
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(End)
//XDSLRTFW-230 Bug_All_All_All_ResolveCnfg17Conflict (End)

#define CNFG_tx_Cnfg_FramingMode       (18)
#define CNFG_tx_Cnfg_MSGLp             (19)
#define CNFG_tx_Cnfg_MSGc              (20)


/* Rx Config */
#define CNFG_rx_Cnfg_Nbc               (21)
#define CNFG_rx_Cnfg_Nlp               (22)
#define CNFG_rx_Cnfg_Rp                (23)
#define CNFG_rx_Cnfg_Mp                (24)
#define CNFG_rx_Cnfg_Lp                (25)
#define CNFG_rx_Cnfg_Tp                (26)
#define CNFG_rx_Cnfg_Dp                (27)
#define CNFG_rx_Cnfg_Bpn               (28)
#define CNFG_rx_Cnfg_FramingMode       (29)
#define CNFG_rx_Cnfg_MSGLp             (30)
#define CNFG_rx_Cnfg_MSGc              (31)

#define CNFG_tx_Cnfg_BCnToLPp          (32)
#define CNFG_rx_Cnfg_BCnToLPp          (33)

/* these cmvs are used by plus handshake */

// Each of the CNFG_TPS entries points to a structure of type (TPS_TC_BearerChannel_t)
#define CNFG_TPS_TC_DS0_PLUS                (34)
#define CNFG_TPS_TC_DS1_PLUS                (35)
#define CNFG_TPS_TC_US0_PLUS                (36)
#define CNFG_TPS_TC_US1_PLUS                (37)

#define CNFG_HDLC_Overhead_Requirements_PLUS (38)

// Each of the CNFG_PMS entries points to a structure of type (PMS_TC_LatencyPath_t)
#define CNFG_PMS_TC_DS0_PLUS                (39)
#define CNFG_PMS_TC_DS1_PLUS                (40)
#define CNFG_PMS_TC_US0_PLUS                (41)
#define CNFG_PMS_TC_US1_PLUS                (42)

// CNFG_PMD_PARAMETERS points to a structure of type (PMD_params_t)
#define CNFG_PMD_PARAMETERS_PLUS            (43)

#define CNFG_ADSL1_CONTROL                (44)

//XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start_End)
#define CNFG_GHS_CarSet                (45) // GHS Carrier Set Configuration

//XDSLRTFW-699 XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_End)
#define CNFG_US_PMS_TC_CTRL               (46)

//XDSLRTFW-230 Bug_All_All_All_ResolveCnfg17Conflict (Start_End)
//CMV located changed to 47 (and kept at proper place) to resolve the conflict with VRx message spec for bonding feature
#define CNFG_tx_Cnfg_Bpn               (47)


//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
#define CNFG_58_SIZE                         1
#define CNFG_Misc                         (58) // miscellaneous configuration settings

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (Start)
#define CNFG_80_SIZE                        (1)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (End)

//XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start)
#define CNFG_82_SIZE                        (1)
#define CNFG_89_SIZE                        (1)

//CNFG 82 bit masks as per VRx Message Spec
#define G9935_VECTORING_DISABLED                   0x0000
#define G9935_COMPLETE_VECTORING_ENABLED           0x0001
#define G9935_ANX_Y_VECTOR_FULL_FRIENDLY_ENABLED   0x0002  //XDSLRTFW-2490 (Start_End)
//XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (End)

// Masks for miscellaneous configuration (CNFG_Misc)
#define CNFG_MISC_NON_STANDARD_HSK_MASK         (0x1)
#define CNFG_MISC_NON_STANDARD_HSK_T1413_MASK   (0x2)
#define CNFG_MISC_VRX518_ENABLE_GPIO14_FOR_DYING_GASP          (0x0100) //XDSLRTFW-3708 Control of GPIO14 to indicate dying gasp for ADSL

//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (End)
#ifdef ADSL_62
// Masks for Profile Control (CNFG_Profile_Ctrl)
// V2_PROFILE
#define CNFG_V2_PROFILE_NONE_MASK   (0x00)
#define CNFG_V2_PROFILE_8A_MASK     (0x01)
#define CNFG_V2_PROFILE_8B_MASK     (0x02)
#define CNFG_V2_PROFILE_8C_MASK     (0x04)
#define CNFG_V2_PROFILE_8D_MASK     (0x08)
#define CNFG_V2_PROFILE_12A_MASK (0x10)
#define CNFG_V2_PROFILE_12B_MASK (0x20)
#define CNFG_V2_PROFILE_17A_MASK (0x40)
#define CNFG_V2_PROFILE_30A_MASK (0x80)
#define CNFG_V2_PROFILE_8xALL_MASK  (CNFG_V2_PROFILE_8A_MASK | CNFG_V2_PROFILE_8B_MASK | CNFG_V2_PROFILE_8C_MASK | CNFG_V2_PROFILE_8D_MASK)
#define CNFG_V2_PROFILE_12xALL_MASK (CNFG_V2_PROFILE_12A_MASK | CNFG_V2_PROFILE_12B_MASK)
#define CNFG_V2_PROFILE_ALL_MASK (CNFG_V2_PROFILE_8xALL_MASK | CNFG_V2_PROFILE_12xALL_MASK | CNFG_V2_PROFILE_17A_MASK | CNFG_V2_PROFILE_30A_MASK)


// DSL[6]  DSL_ADC_TRIM_READ_WRITE
// DSL 6 0; us_options
#define ADC_TRIM_READ_ONLY             0x0000   //If B0 = 0; Read only Enabled; default;
#define ADC_TRIM_OVER_WRITE_STAGE1     0x0001   //If B0 = 1; Over write Enabled; If B1 = 0 for stage 1 only
#define ADC_TRIM_OVER_WRITE_STAGE12    0x0011   //If B0 = 1; Over write Enabled; If B1 = 1 for stage 1 & 2 both
#endif

#ifdef HERC_API
/* CNTR register address field */
#define CNTRMAP_SIZE             60  // XDSLRTFW-1481 (Start_End) Actully 57 is used and in message spec defines upto 59.
#define  CNTR_NE_LinePerfCount           2
#define  CNTR_FE_LinePerfCount           4
#define  CNTR_NE_CRC_Running           8
#define  CNTR_NE_FEC_Running           10
#define  CNTR_FE_CRC_Running           12
#define  CNTR_FE_FEC_Running           14
#define  CNTR_NearEndHECErrCnt           16
#define  CNTR_NearEndHECTotCnt           18
#define  CNTR_NearEndCellTotCnt          20
#define  CNTR_NearEndIdleCellBitErrs     22
#define  CNTR_PTM_BC0_StatsNE            45
#define  CNTR_ATM_BC0_StatsNE            46
#define CNTR_ATM_BC0_TxStatsNE          53


#define CNTR_46_SIZE          8
//Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
#define CNTR_45_SIZE          8

//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start_End)
#define CNTR_51_SIZE          (CNTR_46_SIZE)

//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)
#define CNTR_53_SIZE          4

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
#define CNTR_56_SIZE          1
//CNTR[56] CNTR_PRE_FAIL_STATE_WAIT_COUNT
//Counter is used to force required amount of symbols
//Min: CNTR[56], Max: PPE_ACK_WAIT_TIMEOUT
//16 bit counter to hold the state machine to read the debug information
//during TC later tear down state, pre fail state.

#define CNTR_57_SIZE          1
//CNTR[57] CNTR_NO_OF_SYM_IN_PRE_FAIL_STATE
//CNTR[57] indicates no of symbols spent in Pre fail state(LinkDownState)
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
//XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters (Start)
#define CNTR_43_SIZE          12
//XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters (End)
#define CNTR_44_SIZE          6
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

//Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
#define EFM_TC             (0x1)
#define ATM_TC             (0x2)
#define EFM_ATM_TC            (0x3)
//Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)

// XDSLRTFW-1924 (Start)
// DREG_MISCRAM4_ADDR values
#define DREG_MISCRAM4_ATM     (0x1)
#define DREG_MISCRAM4_EFM     (0x2)
// XDSLRTFW-1924 (End)

/* AINF register address field */
#define AINFMAP_SIZE             10
#define  AINF_ADSL_PCB                   0
#define  AINF_DS_FRAMING_INFO_LP0        1
#define  AINF_US_FRAMING_INFO_LP0        2
#define  AINF_DS_FRAMING_INFO_LP1        3
#define  AINF_US_FRAMING_INFO_LP1        4

#define AINF_US_BAT                     6
#define AINF_DS_BAT                     7
#define AINF_US_FINEGAINS               8
#define AINF_DS_FINEGAINS               9

/* MONI register address field */
#define MONIMAP_SIZE             7

#if 0
// this is not required , map it to MONI STAT
#define MONIMAP_SIZE             15
#endif

#define  MONI_STATE_TRANSITIONS          0
#define  MONI_NE_LINE_FAILURES           1
#define  MONI_FE_LINE_FAILURES           2
#define  MONI_STATE_MACHINE_CONTROL      4
#define  MONI_NE_SHOW_FAIL_CONDITIONS    5
#define  MONI_FE_SHOW_FAIL_CONDITIONS    6

// To be deleted
#define MONI_SHORT_INIT                 0x0080  // Not used
#define MONI_NE_DIAG_DATA_AVAILABLE     0x1000
#define MONI_SELT_IN_PROGRESS           0x2000  // Not used
#define MONI_SELT_DATA_AVAILABLE        0x4000  // Not used
#define MONI_BONDINGEXCHANGE_COMPLETE  (0x0001 <<15)

// MONI 0
// Parameter 2
#define MONI_RESET                           0x0001
#define MONI_T1413                           0x0002
#define MONI_GHS                             0x0004
#define MONI_FULL_INIT                       0x0008
#define MONI_SHOWTIME_TC_NOSYNC              0x0010
#define MONI_SHOWTIME_TC_SYNC                0x0020
#define MONI_DIAG_MODE                       0x0040
#define MONI_PREFAIL                         0x0080
#define MONI_FAIL                            0x0100
#define MONI_FIRST_SHOWTIME_TC_SYNC          0x0200
#define MONI_READY                           0x0400
#define MONI_DIAG_COMPLETE                   0x0800
#define MONI_MFD                             0x1000
#define MONI_MFD_COMPLETE                    0x2000
#define MONI_BONDING_CLR                     0x4000
#define MONI_TEST                            0x8000

// XDSLRTFW-3648 (Start)
// Parametr 3
#define MONI_DSL_POWER_DOWN             0x0001
// XDSLRTFW-3648 (End)

/* MONI_NE_SHOW_FAIL_CONDITIONS Offset0(Parameter 2)*/
#define MONI_LOS_FAILURE                0x0001
#define MONI_LOF_FAILURE                0x0002
#define MONI_LPR_FAILURE                0x0004
#define MONI_LOM_FAILURE                0x0008
#define MONI_RFI_FAILURE            0x0008

#define MONI_NCD_FAILURE_BC0            0x0100
//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers(start)
#define MONI_NCD_FAILURE_BC1            0x0200
#define MONI_LCD_FAILURE_BC0            0x0040
#define MONI_LCD_FAILURE_BC1            0x0080
//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers(end)

//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
//Overlaid for PTM mode as per VR9 message specification
#define MONI_OOS_FAILURE_BC0            0x0400

#define MONI_LOL_FAILURE                0x1000
#define MONI_ESE_FAILURE                0x2000
#define MONI_PRO_FAILURE                0x4000
#define MONI_LINIT_FAILURE              0x8000
/* MONI_NE_SHOW_FAIL_CONDITIONS Offset1 (Parameter 3)*/
#define MONI_SES30_FAILURE              0x0001
#define MONI_ES90_FAILURE               0x0002

#define MONI_AUTO_RESTART               0x0001

//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start_End)
   #if 0
      #define MONI_EnableBondingExchangeOnly 0x0080
   #endif
#define MONI_LINE_PROBE_ENABLE          0x0002
#define MONI_LOOP_DIAG_MODE_ENABLE      0x0004

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
//Controls of Virtual Noise feature are moved to CMV DSL 0
//#define MONI_DS_VIRTUAL_NOISE_SUPPORT   0x0008
//#define MONI_US_VIRTUAL_NOISE_SUPPORT   0x0010
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

#define MONI_ALL_DIGIAL_MODE            0x0020
#define MONI_PSD_SHAPING_IN_US0         0x0040

//XDSLRTFW-403: Enhancement_ALL_BisPLus_ALL_L2_HercCMVreMap (Start_End)
#define MONI_L2_LOW_POWER_ENABLE        0x0100
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
#define MONI_L2_RFI_AUTO_EXIT           (0x200)
#define MONI_L2_AMD4_SUP                (0x400)
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

//  Hercules CMV's ALGS, DBUG, ACFG & AOPT have not been implemented
//  in the StratiPHY code base yet.  These are currently just placeholders.
#define ALGSMAP_SIZE             1
#define DBUGMAP_SIZE             1
#define ACFGMAP_SIZE             1
#define AOPTMAP_SIZE             1
#endif // HERC_API
/*********************************************PTM CHANGES**************************************/
#define SCONTROL  (0)
/***********************************************Ramu****************************************************/
// XDSLRTFW-1481 (Start)
#define PLAM5_DATAPATH_NCD_NE_BC0             0x0001
#define PLAM5_DATAPATH_LCD_NE_BC0             0x0002
#define PLAM5_DATAPATH_NCD_NE_BC1             0x0004
#define PLAM5_DATAPATH_LCD_NE_BC1             0x0008

#define PLAM5_DATAPATH_NCD_FE_BC0             0x0100
#define PLAM5_DATAPATH_LCD_FE_BC0             0x0200
#define PLAM5_DATAPATH_NCD_FE_BC1             0x0400
#define PLAM5_DATAPATH_LCD_FE_BC1             0x0800

#define PLAM5_DATAPATH_OOS_NE_BC0             0x0001
#define PLAM5_DATAPATH_OOS_NE_BC1             0x0002
#define PLAM5_DATAPATH_OOS_FE_BC0             0x0100
#define PLAM5_DATAPATH_OOS_FE_BC1             0x0200
// XDSLRTFW-1481 (End)

//==============================================================================
// Function prototypes
//==============================================================================

extern void CMVInit_PreHandshake(void);

extern void CMVInit_UtopiaFix(void);

#endif // _CMV_H
