/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CMV_DATA_H
#define _CMV_DATA_H

/*******************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: cmv_Data.h
*
*  Header file for cmv_Data.c.
*
*******************************************************************************/
// *****************************************************************************
// cmv_Data.h
//
// History
//
// 21/06/2010 Bhadra : Added new CMV group "DSL".
//                   Grep for  Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//             Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on...).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on...).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                   0: disabled (default)
//                   1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                   0 -> GHS Activation startup (Default)
//                   1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 26/06/2012 Ram: Added code for mapping of ReTX Status counters to CMV CNTR 43,44
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 17/09/2012 Ram: Added code to support the foll CMVs
//                 "CNFG 80" -> Enable/Disable ReTx mode during G.HS
//                 "INFO 229" -> ReTx DS Showtime Status: ReTx On/OFF
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229"
//
// 07/01/2013 Ram: Added fix for JIRA 459. Implementing 'CMV CNTR 51'
//                Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// 04/02/2013 Sooraj: Added Support for CMV "OPTN 25" to control EOC polling.
//            Grep for XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 07/02/2013 Vinjam: Send "Vector" code pointer in "VDSL2 code pointers" in ADSL G.Hs Short CLR Message.
//            Vector feature is enabled using "CMV CNFG 82". If enabled, then set "SPAR2 OCTET2 Bit-3(0x8)" & NPAR3 OCTET1 Bit-0(0x1).
//            Grep for XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs
//
// 27/5/2013 Vinjam: Added CMV remap for INFO 221 using Hercules CMV dictionary entry
//            Grep for XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221
//
// 18/11/2014 : Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
//
// *****************************************************************************
#include "typedef.h"

// CMV block name array pointers
extern int16 STATArray[];
extern int16 INFOArray[];
extern int16 TESTArray[];
extern int16 OPTNArray[];

#ifdef HERC_API
// code set in the group field of MP structure to indicate that the network processor has not enabled AC_CLK
#define  AC_CLK_NOT_ENABLED_MSG 0x101 /* 0001 0000 0001b */

extern int16 *STAT_0_Map[];
extern int16 *STAT_1_Map[];
extern int16 *STAT_5_Map[];
extern int16 *OPTN_0_Map[];
extern int16 *OPTN_2_Map[];
extern int16 *INFO_74_Map[];
extern int16 *INFO_76_Map[];

#endif
extern int16 CNTLArray[];
extern int16 *INFOMap[];

#ifdef HERC_API
extern int16 *INFO_203_Map[];
extern int16 *INFO_209_Map[];
extern int16 *INFO_211_Map[];
extern int16 *INFO_212_Map[];

//XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221 (Start_End)
extern int16 *INFO_221_Map[];

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (Start)
extern int16 *INFO_229_Map[];
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (End)

// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
extern int16 *INFO_241_Map[];
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

// XDSLRTFW-3566 (Start_End)
extern int16 *INFO_244_Map[];

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
extern int16 *CNTR_43_Map[];
extern int16 *CNTR_44_Map[];
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (start_end)
extern int16 *CNTR_45_Map[];
extern int16 *CNTR_46_Map[];
//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start_End)
extern int16 *CNTR_51_Map[];
//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)
extern int16 *CNTR_53_Map[];

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
extern int16 *CNTR_56_Map[];
extern int16 *CNTR_57_Map[];
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
extern int16 *OPTN_15_Map[];
//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (start_end)
extern int16 *OPTN_28_Map[];
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
extern int16 *OPTN_25_Map[];

#endif

extern int16 *RATEMap[];
extern int16 *PLAMMap[];

extern   int16 *CNFG_0_Map[];
extern   int16 *CNFG_1_Map[];
extern   int16 *CNFG_2_Map[];
extern   int16 *CNFG_3_Map[];
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
extern   int16 *CNFG_58_Map[];

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (Start)
extern   int16 *CNFG_80_Map[];
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (End)

//XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start_End)
extern   int16 *CNFG_82_Map[];
//XDSLRTFW-2382 (Start_End)
extern   int16 *CNFG_89_Map[];

// XDSLRTFW-1481 (Start_End)
extern int16 *PLAM_5_Map[];

extern int16 *CNFGMap[];
#ifdef HERC_API
extern int16 *MONIMap[];
extern int16 *CNTRMap[];
extern int16 *ALGSMap[];
extern int16 *DBUGMap[];
extern int16 *ACFGMap[];
extern int16 *AINFMap[];
extern int16 *AOPTMap[];
#endif
extern int16 gs_MpWinhostControl;
extern int16 gs_ModemOperationRequired;
// Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (START_End)
extern int16 *DSLMap[];
extern int16 *DSL_4_Map[];  //XDSLRTFW-3705 (Start_End)

#endif // _CMV_DATA_H
