/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CMV_REMAP_H
#define _CMV_REMAP_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             cmv_remap.h
 * DESCRIPTION:      Header file for functions that perform Hercules CMV
 *                   Remapping.
 *
 **********************************************************************/
// *****************************************************************************
// cmv_remap.h
//
// History
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 07/01/2013 Ram: Added fix for JIRAs 575, 459.
//                 a) When SW/DSL-API either GETs/SETs 'a' CMV (perf counter),
//                    contents of the entire CMV set (CNTR 2,4,8,10,12,14) is being read/written.
//                    This mass read/write is being prevented now by passing the 'CMV number under interest'
//                    as an argument to mapping function.
//                    Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
//                 b) Implementing CMV 'CNTR 51'.
//                    Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// *****************************************************************************
#ifdef HERC_API
extern void MapHercCNFGtoSOC(void);
extern void MapHercOptnAlgtoSOC(void);
extern void MapHercOptnModetoSOC(void);
extern void MapSocOptnAlgtoHerc(void);
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
extern void MapHercOptnOlrtoSOC(void);

//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (start_end)
extern void MapHercOptnMarginDeltatoSOC(void);

extern void MapSocOptnModeCnttoHerc(void);
extern void MapSocStatFailtoHerc(void);
extern void MapSocStatModetoHerc(void);
extern void MapSocStatMacrosttoHerc(void);
extern void MapConfigtoAINF(HercADSL_AINFCMV_Framing_t *pt_HercADSL_Framing, Config_t *pt_config, int16 j);
extern void MapSocCNFGtoHercAINF(uint16 us_AddrField);
// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
extern void MapSocPLAMtoHercCNTR(uint16 us_CMVNum);
extern void MapHercCNTRtoSOCPLAM(uint16 us_CMVNum);
// XDSLRTFW-575: Counter Write back in ADSL mode (End)
extern void MapSocINFOtoHercINFO(void);
extern void MapSocOutputstoHercRate(void);
extern void HercMonitorUpdate(void);
extern void MapHERCMonitoSocOPTN(void);
//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)
extern void MapSocPLAMNETxCntrs(void);

//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
extern void MapSocPLAMtoHercNEDPPerfCntrs(void);
extern void MapSocPLAMtoHercFEDPPerfCntrs(void);
//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)

//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
extern void MapSocPLAMtoHercPTMRxPerf(void);
extern void MapSocPLAMtoHercDataPathFailuresStatus(void);

#endif  // #ifdef HERC_API

#endif /* _CMV_REMAP_H */


