/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CNFGMULT_H
#define _CNFGMULT_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             CNFGMULT.h
 * DESCRIPTION:      Header file for multimode (g992.1/g992.2) operation
 *
 **********************************************************************/



#define C_PILOT_TONE_96          (96)
#define C_PILOT_TONE_96_MIN         (91)  /*  minimum tone index used for detection of C_PILOT1_TONE */
#define C_PILOT_TONE_96_MAX         (101) /*  maximum tone index used for detection of C_PILOT1_TONE */

#define C_PILOT_TONE_64          (64)
#define C_PILOT_TONE_64_MIN         (60)  /*  minimum tone index used for detection of C_PILOT1_TONE */
#define C_PILOT_TONE_64_MAX         (68)  /*  maximum tone index used for detection of C_PILOT1_TONE */

#define MIN_RX_SAMPLES_PER_FRAME (512) /* min Rx samples per frame */
#define MIN_DEC_UPSAMPLING_FACTOR   (MIN_RX_SAMPLES_PER_FRAME / TX_FFT_LENGTH) /* Tx fft length is the max possible IFFT length */

#define NUM_DEC_STATES ((DEC_ORDER_MAX-1)/MIN_DEC_UPSAMPLING_FACTOR+MAX_DEC_DELAY)  /* increase number of state variables */

/* ============================================================================ */
/* The following parameters are used for configuring the system. */
/*                                                          */
/* The TX_FFT_LENGTH and RX_FFT_LENGTH define the IFFT and FFT length,        */
/* respectively.                                               */
/* The TX and RX CP LENGTHs are 1/16 of the IFFT and FFT length, respectively.   */
/*                                                          */
/* ============================================================================ */

#define TX_IFFT_LENGTH     (128)    /*  IFFT length */
#define RX_FFT_LENGTH      (1024)      /*  FFT length */

#define RX_BUFFER_SIZE      (512)       /* used to size the buffers to adsl+ */

#define GDMT_US_NUM_TONES  64       /* Max upstream number of tones */
#define GDMT_DS_NUM_TONES  512         /* Max downstream number of tones */

#define GLITE_DS_NUM_TONES 128         /* G.lite downstream number of tones */
#define GLITE_US_NUM_TONES 32       /* G.lite upstream number of tones */

#define TX_NUM_TONES    GDMT_US_NUM_TONES       /* number of tones for US */
#define RX_NUM_TONES    GDMT_DS_NUM_TONES       /* number of tones for DS */

/* ======================================================================== */
/*  Carrier or Channel Parameters */
/* ======================================================================== */
#define TX_FIRST_CHANNEL    6       /* Min Tx first channel across all modes -- unused */
#define TX_LAST_CHANNEL     60         /* Max Tx last channel  across all modes -- unused */

#define RX_FIRST_CHANNEL    33         /* Min Rx first channel across all modes -- unused */
#define RX_LAST_CHANNEL     511        /* Max Rx last channel  across all modes -- unused */

// Hardware limit assuming all US channels are used as data channels.
// Max upstream overhead is 2 bytes (sync and LEX byte in framing mode 1).
// (64-2) bytes per frame to reach 640 kbps in non-ISDN mode
// 20 bytes per frame to reach 640 kbps in ISDN mode
// Used to define array sizes bu *Cocomo* only; hence we set this to max of the above
#define MAX_LSX_PAYLOAD_BYTES  (64-2)

/* =========================================================================================== */
/* Paramters associated with TDQ */
/* WARNING! The following constants are used for test purpose and they need to be calibrated */
/* for real system. */
/* =========================================================================================== */

                                       /*  set to approximately log2(TDQ_LENGTH) */

#define  TDQ_LENGTH              (16)        /*  TDQ filter order */
#define TDQ_LENGTH_LITE          (6)            /*  TDQ filter order for Lite*/

#define TDQ_RIGHT_SHIFT_COUNT    (4)            /*  TDQ intermediate result right shift count */



/* ========================================================================= */
/* Modem configuration parameters */
/* ========================================================================= */
#define  TCM_OPTION           1           /* not support trellis coding */

#define  DESIRED_SNR_MARGIN      (6<<8)         /* 4 dB in Q8.8 format */


/* ====================================================================================== */
/* Bit loading paramters */
/* ====================================================================================== */
#define MAX_DS_FULL_ASYNC_OVERHEAD_BYTES    (6) /*  fast byte, sync byte, AEX and LEX bytes */
#define MAX_DS_FULL_SYNC_OVERHEAD_BYTES     (6) /*  fast byte, sync byte, AEX and LEX bytes */
#define REDUCED_SEPARATE_OVERHEAD_BYTES     (2) /*  fast byte and sync byte */
#define REDUCED_MERGED_OVERHEAD_BYTES       (1) /*  fast or sync byte (only one latency path  */
                                                /*  in merged overhead mode) */

#define MAX_US_FULL_ASYNC_OVERHEAD_BYTES    (4) /*  fast byte, sync byte, LEX bytes */
#define MAX_US_FULL_SYNC_OVERHEAD_BYTES     (4) /*  fast byte, sync byte, LEX bytes */

/*  maximum supported number of DS overhead bytes */
#define MAX_DS_PAYLOAD_OVERHEAD_BYTES   (MAX_DS_FULL_ASYNC_OVERHEAD_BYTES)
/*  maximum supported number of US overhead bytes */
#define MAX_US_PAYLOAD_OVERHEAD_BYTES   (MAX_US_FULL_ASYNC_OVERHEAD_BYTES)

#define MAX_DS_PAYLOAD_BYTES    MAX_AS0_PAYLOAD_BYTES

#define MAX_US_PAYLOAD_BYTES    MAX_LSX_PAYLOAD_BYTES

#define  MAX_DS_BYTES            (MAX_DS_PAYLOAD_BYTES + MAX_DS_PAYLOAD_OVERHEAD_BYTES + 16)
                           /* maximum number of bytes per symbol for downstream */
                           /* 192 payload (= (6144 Kbps)/(4000*8)) + 4 overhead +  */
                                    /* 16 checkbytes, where we assume that check bytes is  */
                                    /* limited to <=10% */

#define MAX_US_BYTES            (MAX_US_PAYLOAD_BYTES + MAX_US_PAYLOAD_OVERHEAD_BYTES + 6)
                           /* maximum number of bytes per symbol for upstream */
                           /* 20 payload (=(640 Kbps)/(4000*8))+4 overhead +  */
                                    /* 6 checkbytes, where we assume that check bytes  */
                                    /* is limited to <=10% */


/* ========================================================================= */
/*  Bit loading defaults */
/* ===================== */

/*  The default configuration shall be: */
/*       Framing Mode 3 - Reduced Overhead with merged fast and sync bytes */
/*       Single latency operation  - Interleaved Path */
/*       1 DS Bearer Channel - AS0 */
/*       1 US Bearer Channel - LS0 */
/* ========================================================================= */

/*  default configuration DS overhead bytes per symbol */
#define DEFAULT_DS_PAYLOAD_OVERHEAD_BYTES  (REDUCED_MERGED_OVERHEAD_BYTES)
/*  default configuration US overhead bytes per symbol */
#define DEFAULT_US_PAYLOAD_OVERHEAD_BYTES  (REDUCED_MERGED_OVERHEAD_BYTES)


#define DS_PAYLOAD_OVERHEAD_BYTES          (DEFAULT_DS_PAYLOAD_OVERHEAD_BYTES)
#define US_PAYLOAD_OVERHEAD_BYTES          (DEFAULT_US_PAYLOAD_OVERHEAD_BYTES)


#define MAX_RX_OUTBUF_FRAME_SIZE (MAX_DS_PAYLOAD_BYTES + MAX_DS_PAYLOAD_OVERHEAD_BYTES)

/* ========================================================================= */
/*  Showtime parameters */
/* ========================================================================= */
#define RX_MAX_D           64    /* maximum DS interleave depth */

#ifdef ISDN
#define R_C_RECOV_BURST_CNT                 (16)
#else
#define R_C_RECOV_BURST_CNT                 (1)
#endif

/* ====================================================================================== */
/*  Handshake parameters. These parameters can be configured */
/* ====================================================================================== */

#define MAX_NET_DATARATE_US     33      /*  maximum net data rate upstream = 2Mbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 14Mbps, this value should be 32+(14/2) = 39 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 640kbps, this value should be (640/64) = 10 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define MIN_NET_DATARATE_US     1       /*  minimum net data rate upstream = 64Kbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 4Mbps, this value should be 32+(4/2) = 34 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 128kbps, this value should be (128/64) = 2 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define AVG_NET_DATARATE_US     10      /*  Average net data rate upstream = 640Kbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 14Mbps, this value should be 32+(14/2) = 39 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 640kbps, this value should be (640/64) = 10 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define MAX_NET_DATARATE_DS     38      /*  maximum net data rate upstream = 12Mbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 12Mbps, this value should be 32+(12/2) = 38 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 640kbps, this value should be (640/64) = 10 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define MIN_NET_DATARATE_DS     1       /*  minimum net data rate upstream = 64Kbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 4Mbps, this value should be 32+(4/2) = 34 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 128kbps, this value should be (128/64) = 2 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define AVG_NET_DATARATE_DS     35      /*  Average net data rate upstream = 6Mbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 6Mbps, this value should be 32+(6/2) = 35 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 640kbps, this value should be (640/64) = 10 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define MAX_LATENCY_US          MAX_DELAY_IN_MSEC      /*  maximum latency upstream  */
                                        /*  For latency y (in msec) <= 31ms, this value should be equal to (y/1) 32+(y/2) */
                                        /*  Eg: for y = 6ms, this value should be 6 */
                                        /*  For latency y (in ms) >= 40ms, this value should be equal to 32+(y/10)-4 */
                                        /*  Eg: for y = 60ms, this value should be 32+(60/10)-4 = 34 */
                                        /*  we can have multiples of 1ms upto 31ms and thereafter we can have multiples of 10ms only */

#define AVG_LATENCY_US          8       /*  Average latency upstream = 8ms */
                                        /*  For latency y (in msec) <= 31ms, this value should be equal to (y/1) 32+(y/2) */
                                        /*  Eg: for y = 6ms, this value should be 6 */
                                        /*  For latency y (in ms) >= 40ms, this value should be equal to 32+(y/10)-4 */
                                        /*  Eg: for y = 60ms, this value should be 32+(60/10)-4 = 34 */
                                        /*  we can have multiples of 1ms upto 31ms and thereafter we can have multiples of 10ms only */

#define MAX_LATENCY_DS          MAX_DELAY_IN_MSEC      /*  maximum latency downstream  */
                                        /*  For latency y (in msec) <= 31ms, this value should be equal to (y/1) 32+(y/2) */
                                        /*  Eg: for y = 6ms, this value should be 6 */
                                        /*  For latency y (in ms) >= 40ms, this value should be equal to 32+(y/10)-4 */
                                        /*  Eg: for y = 60ms, this value should be 32+(60/10)-4 = 34 */
                                        /*  we can have multiples of 1ms upto 31ms and thereafter we can have multiples of 10ms only */

#define AVG_LATENCY_DS          8       /*  Average latency downstream = 8ms */
                                        /*  For latency y (in msec) <= 31ms, this value should be equal to (y/1) 32+(y/2) */
                                        /*  Eg: for y = 6ms, this value should be 6 */
                                        /*  For latency y (in ms) >= 40ms, this value should be equal to 32+(y/10)-4 */
                                        /*  Eg: for y = 60ms, this value should be 32+(60/10)-4 = 34 */
                                        /*  we can have multiples of 1ms upto 31ms and thereafter we can have multiples of 10ms only */


/* Note: If non-zero values are going to be employed,
 ; enable the transmission of this info in PrepareCLR(), by setting appropriate ID_SPar1 bits !!!
 */
#define RELATIVE_POWER_LEVEL_A43_UP 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set A43 */
#define RELATIVE_POWER_LEVEL_A43_DN 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set A43 */
#define RELATIVE_POWER_LEVEL_B43_UP 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set B43 */
#define RELATIVE_POWER_LEVEL_B43_DN 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set B43 */
#define RELATIVE_POWER_LEVEL_C43_UP 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set C43 */
#define RELATIVE_POWER_LEVEL_C43_DN 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set C43 */
#define RELATIVE_POWER_LEVEL_A4_UP  0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set A4 */
#define RELATIVE_POWER_LEVEL_A4_DN  0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set A4 */
#define RELATIVE_POWER_LEVEL_A43c_UP   0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set A43c */
#define RELATIVE_POWER_LEVEL_A43c_DN   0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set A43c */
#define RELATIVE_POWER_LEVEL_J43_UP 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set J43 */
#define RELATIVE_POWER_LEVEL_J43_DN 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set J43 */
#define RELATIVE_POWER_LEVEL_B43c_UP   0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set B43c */
#define RELATIVE_POWER_LEVEL_B43c_DN   0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set B43c */



#define GHS_SPAR1 0x1      /* G992_1_A */



#endif /* _CNFGMULT_H */


