/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CODESWAP_H
#define _CODESWAP_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  codeswap.h
;
;  Header file for functions in codeswap.c
;
*****************************************************************************/

#include "typedef.h"

/**********************************************************************
 * VARIABLES
 **********************************************************************/
extern int16 gs_CodeSwapCount;
extern int16 gs_CodeSwapSection;
extern int16 gs_CodeSwapStatus;
extern int16 gsa_CodeSwapStartState[];
extern int16 gsa_CodeSwapTxStartState[];

extern int32 gla_CodeSwapStartSymbol[];
extern int16 gsa_CodeSwapNextSection[];
extern int16 gsa_CodeSwapTrail[];
extern int16 gsa_CodeSwapTrailIndex;
extern int16 gsa_CodeSwapCheckState[];
extern int16 gsa_CodeSwapNextSection[];
extern int16 gsa_CodeSwapRxCheckState[];
extern int16 gsa_CodeSwapTxCheckState[];

extern int32 __StartOfSramBAR15;
extern int32 __StartOfSramBAR16;
extern int32 __StartOfSramBAR17;
extern int32 __StartOfSramBAR18; // XDSLRTFW-3708:Control of GPIO14 to indicate dying gasp for ADSL (Start)
extern int32 __StartOfSramBAR19;

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

extern void InitCodeSwap(void);
extern void HandleCodeSwap();
extern void FinishCodeSwap();
extern void CheckForCodeSwap(void);
void LoadCodeSwapPagesForInitialState(void);
void StartModemOperation(void);


#endif /* _CODESWAP_H */

