/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _COMPILER_H
#define _COMPILER_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             compiler.h
 * DESCRIPTION:      Provides compilation options.
 *
 **********************************************************************/


// ******************************************************************
// compiler.h
//
// History
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// 21/11/2011 Hanyu:  Added compiler switch "ENABLE_MICROFILTER_DETECT_FEATURE"
//                    for VR9 ADSL MFD integration.
//                    Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
//14/03/2012 Kannan:  06/04/2010 Bhadra:   Added code for uinversal ReTx(G.inp section A.2.2) as per Amd5 of G.HS.
//                      Added variables gft_ReTx_ATM_PTM,gft_ReTx_MS_incorrect for validity of MS message in UnivReTx.
//                      Grep for SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod to see changes.

//14/03/2012 Kannan: 08/04/2009 Bhadra:
//                   Increased "guca_R_C_Msgs1_bis size".by 10 bytes
//                   Increased guca_RMsgs1Tab_bis   by 1 byte
//                     Grep for SMS01436310:FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 14/06/2012 Kannan:
//          1. Added a preprocessor "ZEP_DEBUG_BLD_RX" to debug the
//             the Rx Path data and "FIFO3_FOR_RETX" may be enabled to debug the
//             ReTx data.
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 25/06/2013 Kannan:
//          1. Added a preprocessor "DEBUG_DEC_ADAPT" to debug the
//             the DEC adaptation state machine
//             XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest
// 11/07/2013 Kannan:
//          After implementing New FMLType-2, PM & DM image size issue is resolved
//          for VRX318. So debug traces are enabled bydefault.
//          Grep for "XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2"
// ******************************************************************
// #define LITE_ONLY


/* ================================================================================ */
/* The following five parameters are defined as the normal setting */
/* ================================================================================ */
#define FIXED_POINT_AEC             /*  if defined, use fixed point Analog Echo Canceller  */
#define NEW_DEC
#define DO_BYTE_FLIP             /*  if it is defined, flip the input byte  */


#ifndef DISABLE_LEAVE_TRAIL
#define LEAVE_TRAIL                 /*  if defined, print trail */
#endif

#define FILE_IO                     /*  if defined, input and output data are from/to files */

#define CALC_REVERB_SNR             /*  if define, calculate Reverb SNR without echo */
                              /*  for monitoring purpose */

#define CALC_REVERB_ECHO_SNR        /*  if define, calculate Reverb SNR with echo  */
                              /*  for monitoring purpose */

#define FLOAT_IN_SW                 /*  if defined use the fixed-point emulation  */
                              /*  of floating-point operations */
   #define IFFT128                     /* Define in order to allocate sufficient buffers */
                                 /* when 128 point IFFT is enabled */


/* ================================================================================ */
/* The following parameters may be turned on and off for various test senarios */
/* ================================================================================ */
/* #define USE_CHANNEL              // if defined, the channel effect is added to RX signal */

/* #define TEST_FAST_RETRAIN           // if defined, compile code for test fast retrain */

/* #define TEST_EC                  // if defined, compile code for test echo canceller */

/* #define DO_BERT                  // if defined, execute TX and RX in BERT mode. */
/* #define BERT_SF_CNT 20           // if defined, number of superframes to TX in BERT mode */
                              /*  if not defined and DO_BERT defined, contiuous operation */

/* ================================================================================ */
/* The following parameters provide additional options for test output */
/* ================================================================================ */
/* #define FORCE_CONFIGRATION       // if defined, use the pre-selected configuration */
                              /*  instead of the one obtained by channel analysis */
/*#define PRINT_INTERMEDIATE_RESULTS */   /* if defined, print intermediate results for debug  */
/*#define DEBUG_ANNEXC_ST */
/*#define DEBUG_CODE */

/* #define DEBUG_GHS                // if defined, print Tx octets and Rx octets                      */
// #define DEBUG_SNR             /* if defined prints immediate Reverb2, Reverb3 and Medley SNRs */
                              /* text files. */
#define PRINT_SIM_END_RESULTS

#define DO_PLAM                     /* if defined, compute PLAM statistics */

#ifndef DISABLE_COLLECT_SYNCSYMBOL_INFO
   #define COLLECT_SYNCSYMBOL_INFO
#endif

#ifndef DISABLE_COLLECT_EOC_AOC_IB_INFO
   #define COLLECT_EOCAOCIB_INFO
#endif

#ifndef DISABLE_COLLECT_SHOWTIME_EVENTS_INFO
   #define COLLECT_SHOWTIME_EVENTS_INFO
#endif

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (Start_End)
#define ENABLE_MICROFILTER_DETECT_FEATURE

// related to HDLC testing
#ifdef TARGET_HW
    // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
   #define HDLC_POLL_TEST
    // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)
   #define HDLC_STAT
#else
   #define HDLC_POLL_TEST
   #define HDLC_QUEUE_LOGGING
   #define HDLC_STAT
#endif



#if defined(INFINEON) && defined(AMAZON_AFE)
   #ifndef DANUBE
   // Infineon-only features
   #define PCM_INTERFACE_SUPPORT
   #endif
#endif

#define FD_ACCUM_FOR_FRAMEALIGN
#define FD_ACCUM_FOR_PGA
#define HW_SNR_FDQ
#define HW_VECPOW_ACCUM
#define PPE_ENGINE
#define ADSL_62_XYMEM
#define VR9_ERASURE
#define DEBUG_STREAMING
#define DEBUG_TRACES
#define WORKAROUND_CTLM_VENDORID
#define DANUBE_PTM_SUPPORT //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
#define ADSL_BONDING       //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING  (Start_End)
#define ENABLE_RETX_DS     //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
#define UNV_RETX_GHS
#define UNV_RETX_MSGS
#ifdef HERCULES_ADSL_CPE
   #define USE_HMP_MSG
#endif


#define XDMA_CODE_SWAP
#define ADSL_62_XMEM
#define ADSL_62_YMEM
//#define XDMA_DATA_SWAP        // probably never needed due to extra memory available
#define ENABLE_LEDs           // will turn on when board info available
#endif /* _COMPILER_H */

