/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CONST_H
#define _CONST_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;  40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;  Fax   (781) 276 - 4001
;
;  File Name: const.h
;
;   This is a header file defining useful constants
;
;***************************************************************************/
// ******************************************************************
// const.h
//
// History
//
// 16/04/2010 Nihar: Increase DS performance against Vinax in DTAG lab
//                   DTAG-lab shows higher WhiteNoise level => use -130dBm/Hz instead of
//                   -140dBm/Hz for White Noise detection
//                   Grep for IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz
//
// 11/08/2010 Kannan/Bhadra: Start Channel Identification & TDQ training
//                   from Rx channel '1' against TI & CNXT based COs for better
//                   DS performance. Since this change doesn't degrade the performance make it general.
//                   Grep for PERF_DS_ALL_TI&CNXT_ChIDfrmTone1
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 02/08/2011 Vinjam: Added exception code for show time "LOF", "OOS" & "ESE" failures.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 18/04/2011 Sriram: Use the special TSSI set to improve the US rates against CNXT DSLAMs with FW version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 06/09/2011 Vinjam: Exception code added for "LOS" due to DS CRC
//            Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 15/11/2011 ChihWen/Bhadra: There is a special requirement that CPE should sync up in 2km loop with -90 dBm/Hz AWGN (normally DS rate is 600 Kbps),
//                  and should be able to reach max capped rate of 6 Mbps by upshift SRA when noise power is decreased to -140 dBm/Hz AWGN.
//                  With this special requirement, we need to load more bits not only on already loaded tones, but also on monitored tones,
//                  in order to reach the max capped rate. A problem behind this requirement is that CNXT CO does not send signal on unloaded tones.
//                  So the workaround to fulfill the requirement for all CO are as below.
//                  1. For all CO, changing the threshold for setting monitored tones from 4 dB to 6 dB (SNR_THRESH_LOAD_MIN_BITS).
//                  2. For all CO, not limiting number of monitored tones to 20 if SRA is enabled on CO site.
//                  3. For all CO, making OLR (SRA and bitswap) only occurring on loaded/monitored tones.
//                  4. For CNXT CO, no updating FDQ cofficients on unloaded tones.
//                  5. For CNXT CO, measuring noise on monitored tones to get an estimation of SNR.
//                  6. For CNXT CO, SNR on monitored tones are capped to 2-bits required SNR, in order to load two bits and get better SNR measurement.
//
//                  7. When DS rate capped low, it took bitloading too long time to
//                     find gs_deltaLp_max and failed the training. This is the root cause
//                     of no-link with 3.5M capped profiles.
//                     The solution is to use a larger searching step to find a valid
//                     gs_deltaLp_max faster.
//
//                  8. For CNXT CO, decreasing the Tx buffer size for overhead message by 2 if the tone number in the last segment of SRA message was 14.
//                     This was because CRC/link drop was always seen when there was 14 tones in the last segment of SRA message.
//
//            Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Added ERROR CODE to indicate NLNF measurement is done.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additionally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//            Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
// 23/12/2011 Sabrina Y/Balabath: To improve US performance, retrain and switch to Aware VID
//            for IKNS DSLAMs.
//            Grep for XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE
// 12/01/2012 Kannan: Added an exception code to retrain and enable
//            64pt IFFT emulation for TI & CNXT in T1413 mode.
//            Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
// 25/01/2012 Kannan: No of FDQ adaptation channels increased from 32 to 48 for ADSL1 mode
//            to do the showtime SNR update faster, which will help to do the
//            bitswap faster while applying sudden RFI
//            Grep BugFix_DS_ADSL1_ALL_SuddenRFI
//
//12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero.
//                      Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
//
//
// 10/01/2012 ChihWen/Balabath: To improve the US/DS rate against NVLT-C in T1413 mode, the solutions are below.
//             1. When preparing the parameters in R-MsgsRA, search the best R which will achieve highest K (best net rate),
//                then set the parameters in R-MsgsRA accordingly.
//                After receiving R-MsgsRA, NVLT-C will send C-RatesRA with the first option of the R and K,
//                which are provided by CPE in R-MsgsRA.
//                Then CPE will select the first option from the C-RatesRA.
//             2. The channel response (HLin) on tone 33~38 could be (0,0), which will make channel extrapolation (DoFDExtrap)
//                incorrect because the extrapolation needs to convert the channel response on tone 33~38 to dB scale (ConvertToDB).
//                Then output will be saturated value (-31768, -32768). The saturated response (-32768, -32768) will make
//                frame sync and TDQ calculation incorrect.
//                The fix is to shift the indices of the reference tones in (DoFDExtrap) from tone 33~38 to tone 40~45, and also check the
//                zero response for the reference tones.
//             3. Change near-end vendor ID to "AWARE" to improve US rate.
//             4. NVLT-C will take about 550 symbols to transit from C-Pilot1 state to C-REVERB1 state after receiving R-REVERB1,
//                so adding 32 more symbols (512+16+32) for the transition from C-Pilot1 state to C-REVERB1 state.
//                Grep for XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement
//
//   07/02/2012 Shakil: Erasaure decoding feature was turned off by default which introduced CRCs in
//                the REIN test from Telefonica Spain in ADSL 2plus profile. As a sollution we enabled
//                erasure decoding feature and also make some small modification in the logic to easily
//                understand the code.
//                Grep for XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding
//
//15/03/2012 Kannna: 16/04/2009 Bhadra: Added code for bitload related changes in Universal Retransmission (G.INP)
//                Added required variables for bitload.
//                Grep for SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad to see changes.
// 25/04/2012 Kannan:
//                1. ADSL DS ReTx feature implementation
//                Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 07/06/2012 Vinjam: Added a constant for maximum number of Transmitter referred
//                Downstream virtual noise break points.
//                Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//                 --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                    in BIS/DMT mode and in 4.4Mhz in PLUS mode
//                 --> Remove all Rx bypass filters with unity pass
//                 --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                    RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//                 --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                    INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//                 --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                    every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//                 --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//                 --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//                Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
// 04/07/2012 Anantha: Added error code for LCD and NCD failure triggering
//                Grep for XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 10/01/2013 Ram: Bug fix for JIRA 261, 262. Defined a new Error codes to avoid re-use. Grep for:
//                 a) XDSLRTFW-261: BugFix_DS_DMT_ADI_Remove_Duplicate_ECODE
//                 b) XDSLRTFW-261: BugFix_DS_BisPlus_All_Remove_Duplicate_ECODE
//                 c) XDSLRTFW-262: BugFix_DS_DMT_ALL_BIS_ECODE_Reused_In_DMT
//
// 15/01/2013 Kannan: Declared Exception code constants for AFE initialization states
//                    Grep for XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication
//
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 10/04/2014 Sriram Shastry: Added the workaround requested by AT&T for their special profile
//                   on Alcatel BRCM DSLAMs (ABLT-D, ABLT-A and EBLT-K)
//                   in T1.413, G.dmt, G.lite and Annex L multimode, i.e.
//                   Multimode CPE needs to disable Annex L on short loops.
//                   This workaround is disabled by default with
//                   CMV bit7 = 0 for INFO 103 26.
//                   To enable it, set bit7 = 1 by cw INFO 103 26 0x0080.
//                   Grep for ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL
//
//  30/3/2015 Sriram Shastry:Jira XDSLRTFW-1843 :CPE  is unable to  link in ADSL2/ADSL2P under Multi-mode configuration.
//                Solution is force CPE  to  G.DMT  mode after 3 fails attempts during  training in ADSL2/ASDL2P mode.
//                Grep for  XDSLRTFW-1843
//
// 12/10/2015 Vinay: Added code to support G.Fast in ADSL G.Hs session.
//            Grep for XDSLRTFW-2298
// **********************************************************************************************************************************

#include "compiler.h"

/* ============================================================================= */
/* The following parameters are used for configuring the system.                 */
/*                                                                               */
/* The TX_FFT_LENGTH and RX_FFT_LENGTH define the IFFT and FFT length,           */
/* respectively.                                                                 */
/* The TX and RX CP LENGTHs are 1/16 of the IFFT and FFT length, respectively.   */
/*                                                                               */
/* Setting TX_NUM_TONES to 128 is used only to generate the test vector          */
/* as the RX input during SHOWTIME;                                              */

/* Setting RX_NUM_TONES to 32 is used only to test the TX output                 */
/* during SHOWTIME (to verify no CRC errors)                                     */
/* ============================================================================= */

#ifdef IFFT128
  #define TX_FFT_LENGTH          (128)    /*  IFFT length */
#else
  #define TX_FFT_LENGTH          (64)     /*  max IFFT length */
#endif


#define TX_PREFIX_LENGTH         (TX_FFT_LENGTH>>4)
#define RX_PREFIX_LENGTH         (RX_FFT_LENGTH>>4)

#define RX_LITE_PREFIX_LENGTH    (16)
#define RX_FULL_PREFIX_LENGTH    (32)

/* ====================================================================================== */
/*  Multiple Bearer Channels \ Dual Latency \ Framing parameters                          */
/* ====================================================================================== */
#define S_HALF_OPTION            (1)      // S=1/2 is supported by default

#define MAX_AS0_PAYLOAD_BYTES    (473)    // 511 - 6(overhead) - 2*16(RS) = 473

#define MAX_AS1_PAYLOAD_BYTES    (144)    /*  bytes per frame to reach 4608 kbps */
#define MAX_AS2_PAYLOAD_BYTES    (96)     /*  bytes per frame to reach 3072 kbps */
#define MAX_AS3_PAYLOAD_BYTES    (48)     /*  bytes per frame to reach 1536 kbps */

// Hardware limit is 256 bytes for upstream
#define MAX_US_BC_PAYLOAD_BYTES  256
// Hardware limit is 512 bytes for downstream
#define MAX_DS_BC_PAYLOAD_BYTES  512


// TX BERT Buffer Size
#define TX_BERT_BUFFER_SIZE      (2*MAX_US_BC_PAYLOAD_BYTES) /* multiply by 2 just to be safe we dont run out of data */

/* ============================================================================================ */
/* Modem Configuration Parameters                                                               */
/* ============================================================================================ */
#define OVERLAP_SPECTRUM_OPTION  0     /* not support overlap spectrum */
#define DUAL_PATH_OPTION         1     /* support dual latency */
#define NTR_OPTION               0     /* support NTR */
#define FRAMING_MODE_OPTION      3     /* support all framing modes */

                                       /*  chosen to roughly be RX_LOG2_FFT_LENGTH */


/* Constants needed for Kernel  */
// Constants for interrupt processing
// Note the order of these interrupts determines the priority
// of detecting multiple interrupts
#define RX_FRAME_START     (0)
#define RX_QAM_DONE        (1)
#define RX_FDQ_DONE        (2)
#define RX_FFT_DONE        (3)
#define RX_AAI_DONE        (4)
#define RX_FCI_DONE        (5)
#define TX_FRAME_START     (6)
#ifdef DANUBE
   #define TX_IFFT_DONE    (7)
   #define TX_AAI_DONE     (8)
   #define TX_FCI_DONE     (9)
   #define RX_GCI_DONE     (10)
#else
   #define TX_TDT_DONE     (7)
   #define TX_IFFT_DONE    (8)
   #define TX_AAI_DONE     (9)
   #define TX_FCI_DONE     (10)
#endif
#ifdef ADSL_62
   #define  TX_TSC_INT     (11)
   #define  RX_TSC_INT     (12)
#endif

//!!!Don't forget to update the following 2 macros when you add a new Interrupt macro
//!!!Also dont forget to update global array gusa_MapInterruptToMask[]

#ifdef DANUBE
   #define NUM_RX_INTERRUPTS   (6)
   #define NUM_TX_INTERRUPTS   (4)
#else //#ifdef DANUBE
#ifdef ADSL_62
   #define NUM_RX_INTERRUPTS   (10)
   #define NUM_TX_INTERRUPTS   (8)
#else //#ifdef ADSL_62
   #define NUM_RX_INTERRUPTS   (6)
   #define NUM_TX_INTERRUPTS   (5)
#endif //#ifdef ADSL_62
#endif //#ifdef DANUBE
#define NUM_INTERRUPTS        (NUM_RX_INTERRUPTS+NUM_TX_INTERRUPTS)
#define NUM_TASK_BUFFERS      (NUM_INTERRUPTS)

#define STACK_SIZE      (5)
#define NUM_THREADS     (2)
#define NUM_BG_BUFFERS  (12)
#define BUFFER_RESERVE (8)
#define THREAD0         (0*4096)
#define THREAD1         (1*4096)
#define FGTASK0         (0)
#define FGTASK1         (1)

#define LOADING_FUNCTION_FIFO_SIZE   (10)         /* defines the length of the fifo used      */
                                    /* to hold the Tx and Rx Loading functions   */


#define   NUM_CONFIG_SETS            (54)      /*  number of test configurations */

#ifdef DANUBE
// Initialize PLL freqoffset with a bias if the Crystal frequency is not 35.328 MHz
// Value is based on clock freq used by lab experiments with the ABLTJ dslam.
// Theorectical value was 0xfec859; based on  35.328/36.00 = 2^22/(2^22 + (-gl_initfreqoffset))
#define DAN_SRC_FREQ_OFFSET_FOR36MHz   (0xfecf03)
#define SRC_INITIAL_FREQ_OFFSET   DAN_SRC_FREQ_OFFSET_FOR36MHz
#endif

#ifdef ADSL_62
// Constant SRC FR offset value. crystal @ 36 MHz. CPE @ 35.328 MHz;
// default SRCFR = 2^24 *( 1- 35.328/36.000 ) = 0x4c756

#define SRC_INITIAL_FREQ_OFFSET   (0x0004C756)  // 20 bit field in Vr9.
#define DEC_FIFO_DELAY   9 // 9 samples determined experimentally
#endif



/* ============================================================================ */
/* ADSL TX CONFIGURATION PARAMETERS                                             */
/* ============================================================================ */
#define TX_MAX_BITS_PER_TONE     (15)   /*  maximum number of bits per tone at TX */
#define TX_MAX_R                 (16)   /*  maximum R parameter for Reed Solomon code */
#define TX_MAX_S                 (16)   /*  maximum number of frames per FEC codeword */
#define TX_SYMBOLS_PER_SFRAME    (68)   /*  symbols per superframe */


/* =========================================================================================== */
/* Parameters associated with QAM encoder                                                      */
/* =========================================================================================== */
/* QAM encoder constellation gain for bit size 2 to 15 */


// These are from the Cocomo common dir

#define ENCGAIN2                 (0x304d)
#define ENCGAIN3                 (0x37c6)
#define ENCGAIN4                 (0x2b34)
#define ENCGAIN5                 (0x3d19)
#define ENCGAIN6                 (0x2a29)
#define ENCGAIN7                 (0x3c59)
#define ENCGAIN8                 (0x29e9)
#define ENCGAIN9                 (0x3c30)
#define ENCGAIN10                (0x29e0)
#define ENCGAIN11                (0x3c20)
#define ENCGAIN12                (0x29e0)
#define ENCGAIN13                (0x3c1b)
#define ENCGAIN14                (0x29d5)
#define ENCGAIN15                (0x3c1b)


/* ============================================================================================= */
/* Parameters associated with TX filter ??? need to be chosen for CPE                            */
/* ============================================================================================= */
#define HPF_ALU_RSH_CNT           (5)     /*  high-pass filter intermediate ALU right shift count */
#define HPF_LEN                   (20)

/* ============================================================================ */
/* ADSL RX CONFIGURATION PARAMETERS                                             */
/* ============================================================================ */
#define RX_MAX_BITS_PER_TONE      (15)    /*  maximum number of bits per tone at RX */
#define RX_MIN_BITS_PER_TONE      (2)     /*  minimum number of bits per tone */
#define RX_MAX_R                  (16)    /*  maximum R parameter for Reed Solomon code */
#define RX_MAX_S                  (16)    /*  maximum number of DMT symbols per FEC codeword */
#define RX_SYMBOLS_PER_SFRAME     (68)    /*  number of symbols per super frame */

//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
#ifndef ISDN
#define SNR_THRESH_LOAD_MIN_BITS  (1536)  /* 6dB in Q8.8 */
#else
#define SNR_THRESH_LOAD_MIN_BITS  (1024)  /* 4dB in Q8.8 */
#endif
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)

#define NUM_MONITORED_TONES       (20)    /* Number of monitored tones for which don't set
                                          fine gain to NEGATIVE INFINITY EVEN IF BAT =0*/
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)
//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (Start End)
#define URETX_NUM_MONITORED_TONES (1)
/* ========================================================================== */
/* Buffer sizes                                                               */
/* ========================================================================== */
#define RX_INBUF_FRAME_SIZE          (RX_FFT_LENGTH+RX_PREFIX_LENGTH)
#define MAX_RX_INTERLEAVE_BUF_SIZE   (RX_MAX_D*RX_MAX_S*MAX_RX_OUTBUF_FRAME_SIZE)

#define RX_INIT_BUF_DELAY            1   /* 1 frame for frame realign */

#define RX_ADCBUF_SIZE               (5*RX_INBUF_FRAME_SIZE)   /* ADC buffer size */
#define   COMMONBLOCK_SIZE           (4096)

#ifdef ISI_ANALYSIS_ON
#define RX_MEDLEY_NUM_FRAMES         (1)   /* Number of RX medley frames captured for ISI analysis */
#endif

/* =========================================================================================== */
/* Parameters associated with Frame Synchronization                                            */
/* =========================================================================================== */

#define MAX_CORR_METHOD       0         /* use the method of maximizing X-correlation */
#define MAX_ENERGY_METHOD     1         /* use the method of maximixing energy of windowed X-Corr */

#define   CXY_THRESHOLD      (int16)(10922)     /* (10922 = 32768/3) threshold in Q1.15 format */
#define CXY_THRESHOLD_RSH     15                /* threshold right shift count    */
#define MAX_ENERGY_RSH        31                /* guardband right shift */

/* =========================================================================================== */
/* Parameters associated with TDQ implementation                                               */
/* =========================================================================================== */

#define TDQ_SCALE_FACTOR            (6183)         /*  scale power of filtered signal to (2^15/5.3) */
#define MAX_COEFF_VALUE             (2047)         /*  set maximum coefficent value prior to scaling */

#define TDQ_REF_LEVEL               (0x4000)       /*  scale factor used to generate TDQ reference waveform   */


#ifndef FLOAT_IN_SW
    /* #define TDQ_NOISE_LEVEL      (0.0009765625)   // adds to diagonal of A matrix (percentage of noise) */
    #define TDQ_NOISE_LEVEL         (0.0018)
#else
    /* #define TDQ_NOISE_LEVEL      0x3a800000 */
    #define TDQ_NOISE_LEVEL         0x3aebedfa
#endif

#define NULL_THRESH_MULTIPLIER      (0.01)         /*  -20dB cutoff for nulls */

#define POSTSYNCH_SEARCH_OFFSET     10    /* post frame synch search range is +/-POSTSYNCH_SEARCH_OFFSET */
                                          /* POSTSYNCH_SEARCH_OFFSET should be chosen <= RX_PREFIX_LENGTH */
                                          /* Otherwise, RX_INIT_BUF_DELAY has to be increased to */
                                          /* handle extra frame alignment offset */
#define MULTI_TDQ_FILTERS           (5)   /* number of TDQ filters to calculate in Multi Tdq approach   */

#ifndef ISDN   // Only for Anx-A
// Train the TDQ from Rx Chnl no 1
// AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1
#define RX_FIRST_CHNL_TDQ_TRAIN     (1)
#endif // ifndef ISDN
/* ============================================================================================ */
/* Parameters associated with digital echo canceler                                             */
/* WARNING! The following constants are used for test purpose, and they should not be           */
/* relied on for each individual system. Parameters for a different system should be calibrated */
/* based on that particular system.                                                             */
/* ============================================================================================ */
#define INIT_ECT_SIGNAL_LEVEL    (2048)
#define DS2US_RATE_RATIO         (RX_NUM_TONES/TX_NUM_TONES)      /*  ratio of sampling rate of DS over US */

#define DEC_RIGHT_SHIFT_COUNT    (LOG2DEC_ORDER)                  /*  set to approximately log2(DEC_ORDER) */
#define DEC_TRAINING_PERIOD      (1)      /* Period, in frames, of DEC Tx training signal. Can be 1 or 2. */

/* ============================================================================================ */
/* Parameters associated with DEC adaptation                                                    */
/* ============================================================================================ */
#define DEC_RX_DATA_CAPTURE_LEN        (64)
#ifdef ADSL_62
#define DEC_RX_DATA_CAPTURE_ESAMPLES   (2)   //DEC_RX_DATA_CAPTURE_LEN=64
#endif //ADSL_62

/* =========================================================================================== */
/* Parameters associated with AEC implementation */
/* =========================================================================================== */

#ifdef AMAZON_AFE
   #define AEC_ORDER       (1)   // No AEC in Eagle/Amazon AFEs, save Data memory
   #define LOG2_AEC_ORDER  (0)   // by reducing oredr of these filters defined globally
#else
   #define AEC_ORDER       (30)
   #define LOG2_AEC_ORDER  (5)
#endif

/* AEC constants used in RCReverb1RxF.c */
#define NUM_AEC_LMS_SYMBOLS         (32)
#define LOG2_NUM_AEC_LMS_SYMBOLS    (5)
#define NUM_AEC_LMS_ITERATIONS      (16)

/* =========================================================================================== */
/* Parameters associated with programmable hybrid training                                     */
/* =========================================================================================== */
#ifdef  AMAZON_AFE
  #define HYB_NUM_HYBRIDS               (35)
#endif

#define HYB_DECIM_FACTOR                (4)
#define HYB_LOG2_DECIM_FACTOR           (2)

#ifdef ISDN
//VR9_AnxB_HybImp
#define HYB_DECIM_POINTS                (110)
#define HYB_DECIM_POINTS_3B1B           (46)
#define HYB_START_TONE                  (64)
//End VR9_AnxB_HybImp
#else
#define HYB_DECIM_POINTS                (116)
#define HYB_START_TONE                  (38)
#endif
#define HYB_END_TONE                    (HYB_START_TONE + HYB_DECIM_FACTOR * HYB_DECIM_POINTS)
#define HYB_MAX_FINE_GAIN               (0x0280)
#define HYB_PHY_MARGIN                  (0x0080)   /* Physical layer margin (dB in 8.8 format) */
#define HYB_PGA_ACCUM_CNT               (2)
#define HYB_LOG2_PGA_ACCUM_CNT          (1)
#define HYB_SIG_PSD_ACCUM_CNT           (4)
#define HYB_LOG2_SIG_PSD_ACCUM_CNT      (2)
#define HYB_NOISE_PSD_ACCUM_CNT         (32)
#define HYB_LOG2_NOISE_PSD_ACCUM_CNT    (5)

//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
#define FDEXTRP_OFFSET                  (7)
//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)
// XDSLRTFW-1843(Start)
#define CRC_MISMATCH_ERR_FAIL_COUNT     (2)
// XDSLRTFW-1843(End)
/* =========================================================================================== */
/* Parameters associated with FDQ implementation                                               */
/* =========================================================================================== */
#ifdef HERCULES_ADSL_CPE
#define FDQ_MANTISSA_WORDLENGTH         (16)    /*  word length (in bits) of signed FDQ mantissa      */
#define FDQ_MANTISSA_FRAC_BITS          (15)    /*  number of fractional bits in FDQ mantissa         */
#else
#define   FDQ_MANTISSA_WORDLENGTH       (14)    /*  word length (in bits) of signed FDQ mantissa      */
#define   FDQ_MANTISSA_FRAC_BITS        (13)    /*  number of fractional bits in FDQ mantissa         */
#endif // HERCULES_ADSL_CPE
#define FDQ_EXPONENT_BITS               (4)     /* 4-bit, unsigned exponent */
#define FDQ_EXPONENT_MAX                (15)    /* Max representable exponent */
#define FDQ_MANTISSA_MAX                ((1<<FDQ_MANTISSA_FRAC_BITS)-1)   // Maximum mantissa
#define MIN_TONE_AMPLITUDE              (-32768) // Min possible value of Rx tone real or imag component.
#define MAX_TONE_AMPLITUDE              (32767)  // Max possible value of Rx tone real or imag component.


/* =========================================================================================== */
/* Parameters associated with FDQ adaptation                                                   */
/* =========================================================================================== */

/* =========================================================================================== */
/* Parameters associated with QAM decoder                                                      */
/* =========================================================================================== */
#define DEC_QPSK_GAIN            (0x2000) /*  this is agreed QPSK signal level for FDQ output */

/* QAM Decoder constellation gains for bit-sizes 2-15. Format is [S 2.13].  */

#define DECGAIN2                 (0x2000)
#define DECGAIN3                 (0x376d)
#define DECGAIN4                 (0x23c7)
#define DECGAIN5                 (0x3299)
#define DECGAIN6                 (0x24a9)
#define DECGAIN7                 (0x333a)
#define DECGAIN8                 (0x24e1)
#define DECGAIN9                 (0x3362)
#define DECGAIN10                (0x24ef)
#define DECGAIN11                (0x336b)
#define DECGAIN12                (0x24f2)
#define DECGAIN13                (0x336e)
#define DECGAIN14                (0x24f3)
#define DECGAIN15                (0x336f)


/* =========================================================================================== */
/* Parameters associated with Trellis decoder                                                  */
/* =========================================================================================== */
#define TRELLIS_NSTATES          16
#define MAX_TRELLIS_STAGES       (RX_NUM_TONES>>1)
#define TCM_DECODER_DEPTH        24    /*  Valid range is [1,RX_NUM_TONES>>1]. */

/*  Trellis decoder fixed point precision parameters. */
#define FRAC_BITS_INPUT_XY       14    /*  Must be <= 14. */
#define FRAC_BITS_DESCALED_XY    7     /*  Must be <= 7 due to C implementation. */
#define INT_BITS_ERROR_1D        3     /*  Must be >= 2. Does not include sign bit. */
#define FRAC_BITS_ERROR_1D_SQRD  14    /*  Must be <= 2*FRAC_BITS_DESCALED_XY. */
#define FRAC_BITS_ERROR_2D_SQRD  14    /*  Must be <= FRAC_BITS_ERROR_1D_SQRD. */

/* =========================================================================================== */
/* Parameters associated with Reed Solomon Coding and TCM coding                               */
/* =========================================================================================== */
#define NO_ERRORS               (0)
#define ERRORS_CORRECTED        (1)
#define ERRORS_DETECTED_A       (2)
#define ERRORS_DETECTED_B       (3)
#define NUM_RS_CODE             (4)

/* ??? The following coding gains (both RS and TCM) need to be calibrated */
#define RS_CODING_GAIN_2         3
#define RS_CODING_GAIN_4         6  /* coding gain for 4-checkbytes = 0.5 dB in Q.1 format */
#define RS_CODING_GAIN_6         7
#define RS_CODING_GAIN_8         8  /* coding gain for 8-checkbytes = 1.5 dB in Q.1 format */
#define RS_CODING_GAIN_10        9
#define RS_CODING_GAIN_12        10
#define RS_CODING_GAIN_14        10
#define RS_CODING_GAIN_16        11 /* coding gain for 16-checkbytes = 2.5 dB in Q.1 format */

#define TCM_CODING_GAIN          11 /* TCM coding gain 5.5 dB in Q.1 format */
#define TCM_CODING_GAIN_60dB     12 // TCM coding gain 6.0 dB in Q.1 format
// coding gain is expressed in 0.5 dB scale between 0 and 7.5 dB as specified in R_MSG_RA
#define MAX_CODING_GAIN          15
#define MAX_CODING_GAIN_80dB     16 // MAX coding gain 8.0 dB in Q.1 format
#define MAX_CODING_GAIN_85dB     17 // MAX coding gain 8.5 dB in Q.1 format

                           /* 7.5 dB as specified in R_MSG_RA*/
#define ONE_OVER_THREE   (int16)(16384/3+0.5)   /* 1/3 in Q1.14 format */
/* ======================================================================== */
/* Pseudo Random Sequence parameters                                        */
/* ======================================================================== */

#define PN1024_LEN                  (1023)   /*  # bits in Psuedo Random Downstream (PRD) sequence */
#define PN512_LEN                   (511)    /*  # bits in Psuedo Random Downstream (PRD) sequence */

/* ======================================================================== */
/* R_INFO parameters                                                        */
/* ======================================================================== */
#define R_RATES1_PRFX_BYTES         (4)
#define R_RATES1_NUM_BYTES          (44)
#define R_MSG1_NUM_BYTES            (6)
#define R_MSG_RA_NUM_BYTES          (10)
#define R_MSG2_NUM_BYTES            (4)
#define R_BG_NUM_BYTES              (512)

#define MAX_DELAY_IN_MSEC           (10)  /*  maximum end-to-end delay allowed (in msec) */
#define RS_OVERHEAD_PERCENTAGE      (0.1) /*  maximum RS overhead set 10% (fraction of BytesPerSymbol) */
#define RATE_OPTION_SPREAD_IN_KBPS  (32)  /*  rate difference (in kbps) between two adjacent rate options */
                                          /*  (must be in multiple of 32 kbps) */

/* ======================================================================== */
/* R_RATES_RA parameters                                                    */
/* ======================================================================== */
#define NUM_DS_RATE_OPTIONS         (4)
#define NUM_US_RATE_OPTIONS         (4)
#define RATE_OPTION1                (0)
#define RATE_OPTION2                (1)
#define RATE_OPTION3                (2)
#define RATE_OPTION4                (3)
#define NO_RATE_OPTION_SELECTED     (0x10)
#define ALL_OPTIONS_FAIL            (0x20)

#define NOT_RECEIVE                 (0)
#define RECEIVE_OK1                 (1)
#define RECEIVE_OK2                 (2)

/* ======================================================================== */
/* R_C_INFO parameters                                                      */
/* ======================================================================== */
#define R_C_RATES1_NUM_BYTES        (120)
#define R_C_MSGS1_NUM_BYTES         (6)
#define R_MSG_FR1_NUM_BYTES         (2)
#define R_MSG_FR2_NUM_BYTES         (2)

#define R_C_MSG_FR1_NUM_BYTES       (2)
#define R_C_MSG_FR2_NUM_BYTES       (2)


/* ====================================================================================== */
/*  R-MSG_RA parameters                                                                   */
/* ====================================================================================== */
#define DMAX_64     64
#define DMAX_128    128
#define DMAX_256    256
#define DMAX_512    512


/* ============================================================================================= */
/*  Reverb/Segue Mod. and DeMod                                                                  */
/* ============================================================================================= */
#define R_REVERB                    (0)
#define R_SEGUE                     (1)
#define C_REVERB                    (0)
#define C_SEGUE                     (1)

/* Parameter used to specify type of Reverb signal to generate. */
#define GEN_REVERB_TYPE_CO          (0)
#define GEN_REVERB_TYPE_RT          (1)

/* ======================================================================== */
/*  TX SHOWTIME CONSTANTS                                                   */
/* ======================================================================== */

#define NO_INLV_OUTPUT              (0)   /*  The TX interleaved path has no output available */
#define INLV_OUTPUT                 (1)   /*  The TX interleaved path has output available  */

#if(TX_NUM_TONES <= 64)
#define TX_MAX_D                    8    /* maximum US interleave depth */
#else                                    /* (note: mandatory TX_MAX_D for G.992.1 or g992.2 is 8, */
#define TX_MAX_D                    16   /*  we use 16 for testing interleaver in loopback mode) */
#endif

/* ============================================================================================= */
/* Handshake parameters                                                                          */
/* ============================================================================================= */
#define R_ACK1          (1)
#define R_ACK2          (2)



#define STM             (0x08)
#define ATM             (0x10)
#define PTM             (0x20)      /* this mode is used only by bis */


/* ============================================================================================= */

#define CRC_BURST_THRESHOLD      (32)        /*  Maximum number of consecutive superframes  */
                                             /*  w/ CRC error before fast retrain is triggered */
                                             /*  (about 0.55 sec) */


/* ========================================================================== */
/* Buffer sizes                                                               */
/* ========================================================================== */

#define TX_OUTBUF_FRAME_SIZE        (TX_FFT_LENGTH+TX_PREFIX_LENGTH)
#define TX_OUTFIFO_SIZE             (3 * TX_OUTBUF_FRAME_SIZE)
#define MAX_TX_INBUF_FRAME_SIZE     (70)
#define MAX_TX_INTERLEAVE_BUF_SIZE  (TX_MAX_D*TX_MAX_S*MAX_TX_INBUF_FRAME_SIZE)


/* ================================================================================ */
/*  Multiple Bearer Channels \ Dual Latency \ Framing parameters                    */
/* ================================================================================ */
#define FULL_ASYNC                (0)      /*  Framing Mode 0: Full Overhead,       */
                                           /*  Asynchronous bit-to-modem timing     */
#define FULL_SYNC                 (1)      /*  Framing Mode 1: Full Overhead,       */
                                           /*  Synchronous bit-to-modem timing      */
#define REDUCED_SEPARATE          (2)      /*  Framing Mode 2: Reduced Overhead,    */
                                           /*  Separate Fast and Sync bytes         */
#define REDUCED_MERGED            (3)      /*  Framing Mode 3: Reduced Overhead,    */
                                           /*  Merged Fast and Sync bytes           */
#define G_BIS_MODE                (4)      /*  G.Bis Framing Mode                   */
                                           /*  Overhead structure                   */
#define BYPASS_MODE               (7)      /*  Bypass framing mode                  */
#define NUM_BEARER_CHANNELS       (2)
#define ASX_BEARER_CHANNELS       (4)     /*  number of DS Simplex ASx channels */
#define LSX_BEARER_CHANNELS       (3)     /*  number of Duplex LSx channels */
#define NUM_DS_BEARER_CHANNELS    (ASX_BEARER_CHANNELS + LSX_BEARER_CHANNELS)
#define NUM_US_BEARER_CHANNELS    (LSX_BEARER_CHANNELS)
#define NUM_DATA_PATHS            (2)     /*  merged fast and interleaver path */
#define LP0_DATA_PATH             (0)
#define LP1_DATA_PATH             (1)
#define FAST_DATA_PATH            (LP1_DATA_PATH)
#define INTERLEAVE_DATA_PATH      (LP0_DATA_PATH)
#define S_HALF                    (0)     /* indicates S = 1/2. */
#define NUM_MODEM_CONFIG_SETS     (3)     /* number of modem configuration sets */


#define COMBINED_LP               (2)

/* ====================================================================================== */
/* Synchronization Control parameters                                                     */
/* ====================================================================================== */
#define STUFF                             (0)  /*  indicate stuffing Synchronization Control action */
#define ROB                               (1)  /*  indicate robbing Synchronization Control action */
#define ROB_BOTH                          (2)  /*  indicate robbing of both AEX and LEX Synchronization  */
                                               /*  Control action */

#define SYNC_ALLOWED                      (0)  /*  Indicates frame MAY be used for Synchronization Control */
#define NO_SYNC_ALLOWED                   (1)  /*  Indicates frame MAY NOT be used for Synchronization  */
                                               /*  Control */

#define SYNC_CONTROL_FRAME                (0)  /*  For the Fast Path: */
                                               /*  Indicates frame IS being used for Synchronization  */
                                               /*  Control */
                                               /*  For the Interleaved Path: */
                                               /*       Indicates LEX byte frame IS being used for  */
                                               /*       Synchronization Control */

#define EOC_FRAME                         (1)  /*  Indicates frame IS being used for EOC messaging */
#define AOC_FRAME                         (1)  /*  Indicates LEX byte IS being used for AOC messaging */

#define MAX_SYNC_CONTROL_FRAMES           (24) /*  Maximum number of consecutive Synchronization  */
                                               /*  Control frames before an EOC frame is required  */
                                               /*  to maintain minimum EOC rate */

#define EOC_RATE_COUNTER_INCREMENT        (5)  /*  Number of sync control frames that may be sent,  */
                                               /*  on average, for each EOC frame to maintain  */
                                               /*  minimum EOC rate */

#define SYNC_EOC_DESIGNATOR_BITMASK       (1)  /* Bit mask to obtain the Synchronization/EOC  */
                                               /* designator bit from the fast byte  */
#define SYNC_AOC_DESIGNATOR_BITMASK       (1)  /* Bit mask to obtain the Synchronization/AOC  */
                                               /* designator bit from the sync byte  */

#define NO_SYNC_ACTION                    (13) /*  = 0x0D, Idicates that no synchronization control is  */
                                               /*  being performed in the data path */

#define DEFAULT_MODEM_CONFIG              (0)

#define AUTO_CONFIG_SET                   (0)
#define FULL_CONFIG_SET                   (1)
#define LITE_CONFIG_SET                   (2)


/* ============================================================================================ */
/* Exception Codes                                                                              */
/* ============================================================================================ */
//XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start)

//ErrorCodes
#define E_NoError                         0
#define E_CONFIG                          1
#define E_NOTFEASIBLE                     2
#define E_COMM                            3
#define E_COMMCRC                         4
#define E_NOPEER                          5
#define E_CHIPSET                         6
#define E_UNKNOWN                         7
#define E_RESERVED                        8
#define E_ShowtimeNE                      0x10
#define E_ShowtimeFE                      0x11


// SubError Codes
#define Esub_Unknown                      0
#define Esub_CodeSwap                     1
#define Esub_PSD                          2
#define Esub_RateUS                       3
#define Esub_RateDS                       4
#define Esub_Retrain                      5     // Esub_INIT
#define Esub_S_TC_Mode                    5
#define Esub_INIT                         5
#define Esub_GhsNoCommonMode              6
#define Esub_HwModeChange                 7     // Unique sub error code for double training: needed by the host to recognize the double training
#define Esub_UpboCheck                    8     // Unique sub error code for UPBO compliance check: needed by the host to report error to the user API
#define Esub_Timeout                      9
#define Esub_S_XDSL_MODE                  0xA
#define Esub_S_PORT_MODE                  0xB
#define Esub_G_FAST_MODE                  0xD
#define Esub_FWInitiatedRetrain           0xE
#define Esub_FALSE_HYBRID                 0xF
#define ESub_LOSS_OF_SIGNAL               0x10
#define ESub_LOSS_OF_FRAME                0x11
#define ESub_LOSS_OF_POWER                0x12
#define ESub_LOSS_OF_MARGIN               0x13
#define ESub_EXCESSIVE_SEVERE_ERRORS      0x15
#define ESub_OOS_BC0                      0x18  //valid for PTM only
#define ESub_LCD_BC0                      0x20  //valid for ATM only
#define ESub_NCD_BC0                      0x22  //valid for ATM only
#define ESub_EXCESS_DOWNSTREAM_CRC_ERRORS 0x24
//XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH (Start)
#define Esub_s_PP_Driver                  0x25  // PPE F/W Miss Match, cannot enter Showtime
//XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH (END)
#define Esub_INTENDED_LOCAL_SHUTDOWN      0x26
#define Esub_HW_Error                     0x27
//XDSLRTFW-4041 (Start)
#define Esub_PSD_CALIBRATION              0x28
#define Esub_AUTO_MSG                     0x29
#define Esub_ERB_INIT                     0x2A
#define Esub_REBOOT_REQ                   0x2B
//XDSLRTFW-4041 (End)



//(0~49)  are reserved for common+DMT only error code, see below
//(50~79) are reserved for BIS only Error code, see detail in const_bis.h
//(80~89) are reserved for Kernel Exception Error code, see detail in soc_src\modem\include\interrupt.h
#define E_CODE_NO_ERROR                                                       (0)
#define E_CODE_BAT_TX                                                         (((E_NOTFEASIBLE | (Esub_INIT<<8))<<16)                         |(1))   /* TX BAT table is incorrect */
#define E_CODE_BAT_RX                                                         (((E_NOTFEASIBLE | (Esub_INIT<<8))<<16)                         |(2))   /* RX BAT table is incorrect */
#define E_CODE_PROFILE                                                        (((E_CONFIG      | (Esub_Retrain<<8))<<16)                      |(3))   /* profile is not selected in fast retrain */
#define E_CODE_MSG_FIFO_OVERFLOW                                              (((E_CHIPSET     | (Esub_INIT<<8))<<16)                         |(4))
#define E_CODE_TRUNCATE_FR                                                    (((E_CONFIG      | (Esub_Retrain<<8))<<16)                      |(5))   /* Fast Retrain truncated due to no stored profiles*/
#define E_CODE_BITLOAD                                                        (((E_NOTFEASIBLE | (Esub_INIT<<8))<<16)                         |(6))   /* bit loading fails */
#define E_CODE_ST_ERROR                                                       (((E_COMMCRC     | (Esub_Unknown<<8))<<16)                      |(7))   /* showtime CRC error */
#define E_CODE_RESERVED                                                       (((E_CONFIG      | (Esub_Unknown<<8))<<16)                      |(8))   /* using parameters reserved by the ITU-T */
#define E_CODE_C_TONES                                                        (((E_COMM        | (Esub_INIT<<8))<<16)                         |(9))   /* detected C_TONES */
#define E_CODE_CODESWAP_ERR                                                   (((E_CHIPSET     | (Esub_CodeSwap<<8))<<16)                     |(10))  /* codeswap not finished in time */
#define E_CODE_FIFO_OVERFLOW                                                  (((E_NoError     | (Esub_Unknown<<8))<<16)                      |(11))  /* we have run out of fifo space */
#define E_CODE_C_BG_DECODE_ERR                                                (((E_COMMCRC     | (Esub_Unknown<<8))<<16)                      |(12))  /* error in decoding C-BG message */
#define E_CODE_C_RATES2_DECODE_ERR                                            (((E_COMMCRC     | (Esub_Unknown<<8))<<16)                      |(13))  /* error in decoding C-MSGS2 and C-RATES2 */
#define E_CODE_RCMedleyRx_C_SEGUE2_Failure                                    (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(14))  /* Timeout after RCMedleyRx waiting for C_SEGUE2 */
#define E_CODE_RReverbRATx_C_SEGUE2_Failure                                   (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(15))  /* Timeout after RReverbRATx waiting for C_SEGUE2 */
#define E_CODE_RReverb3Tx_C_SEGUE1_Failure                                    (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(16))  /* Timeout after RReverb3Tx waiting for C_SEGUE1 */
#define E_CODE_RCCRC2Rx_C_RATES1_DECOD_ERR                                    (((E_COMMCRC     | (Esub_INIT<<8))<<16)                         |(17))  /* Received CRC not equal to computed CRC */
#define E_CODE_RCCRC1Rx_C_RATES1_DECOD_ERR                                    (((E_COMMCRC     | (Esub_INIT<<8))<<16)                         |(18))  /* Received CRC not equal to computed CRC */
#define E_CODE_RReverb5Tx_C_SEGUE2_Failure                                    (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(19))  /* Timeout after RReverb5Tx waiting for C_SEGUE2 */
#define E_CODE_RReverb6Tx_C_SEGUE3_Failure                                    (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(20))  /* Timeout after RReverb6Tx waiting for C_SEGUE3 */
#define E_CODE_RSegue5Tx_C_SEGUE3_Failure                                     (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(21))  /* Timeout after RSegue5Tx waiting for C_SEGUE3 */
#define E_CODE_RCReverb5Rx_C_SEGUE_Failure                                    (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(22))  /* Timeout after RCReverb5Rx waiting for C_SEGUE */
#define E_CODE_RCReverbRARx_C_SEGUE2_Failure                                  (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(23))  /* Timeout after RCReverbRARx waiting for C_SEGUE2 */
#define E_CODE_RCCRC4Rx_CMSGS2_DECOD_ERR                                      (((E_COMMCRC     | (Esub_INIT<<8))<<16)                         |(24))  /* Received CRC not equal to computed CRC */
#define E_CODE_RCCRC5Rx_C_BG_DECOD_ERR                                        (((E_COMMCRC     | (Esub_INIT<<8))<<16)                         |(25))  /* Received CRC not equal to computed CRC */
#define E_CODE_RCCRC3Rx_DECOD_ERR                                             (((E_COMMCRC     | (Esub_INIT<<8))<<16)                         |(26))  /* Received CRC not equal to computed CRC */
#define E_CODE_RCPilot3_DEC_PATH_DEL_TIMEOUT                                  (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(27))  /* DEC Path Delay timeout */
#define E_CODE_RCPilot3_DEC_TRAINING_TIMEOUT                                  (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(28))  /* DEC Training timeout */
#define E_CODE_RCReverb3Rx_C_SEGUE1_Failure                                   (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(29))  /* Timeout after RCReverb3Rx waiting for C_SEGUE1 */
#define E_CODE_RCReverb2Rx_SignalEnd_Failure                                  (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(30))  /* Timeout waiting for the end of RCReverb2Rx signal */
#define E_CODE_RQuiet2_SignalEnd_Failure                                      (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(31))  /* Timeout waiting for the end of RQuiet2 signal */
#define E_CODE_RCReverbFR1Rx_Failure                                          (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(32))  /* Timeout waiting for the end of RCReverbFR1Rx signal */
#define E_CODE_RCPilotFR1Rx_SignalEnd_Failure                                 (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(33))  /* Timeout waiting for the end of RCPilotFR1Rx signal */
#define E_CODE_RCReverbFR2Rx_C_Segue_Failure                                  (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(34))  /* Timeout after RCReverbFR2Rx waiting for C_SEGUE */
#define E_CODE_RCReverbFR5Rx_SignalEnd_TIMEOUT                                (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(35))  /* Timeout waiting for the end of RCReverbFR5Rx signal */
#define E_CODE_RCReverbFR6Rx_C_SEGUE_Failure                                  (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(36))  /* Timeout after RCReverbFR6Rx waiting for C_SEGUE */
#define E_CODE_RCReverbFR8Rx_C_SEGUE_FR4_Failure                              (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(37))  /* Timeout after RCReverbFR8Rx waiting for C_SEGUE_FR4 */
#define E_CODE_RCReverbFR8Rx_No_PROFILE                                       (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(38))  /* Timeout since no profile was selected */
#define E_CODE_RCReverbFR8Rx_SignalEnd_TIMEOUT                                (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(39))  /* Timeout waiting for the end of RCReverbFR8Rx signal */
#define E_CODE_RCCRCFR1_DECOD_ERR                                             (((E_COMMCRC     | (Esub_INIT<<8))<<16)                         |(40))  /* Received CRC not equal to computed CRC */
#define E_CODE_RCRecovRx_SingnalEnd_TIMEOUT                                   (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(41))  /* Timeout waiting for the end of RCRecovRx signal */
#define E_CODE_RSegueFR5Tx_TX_Not_Ready_TIMEOUT                               (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(42))  /* Timeout after RSegueFR5Tx waiting for C_SEGUE2 */
#define E_CODE_RRecovTx_SignalEnd_TIMEOUT                                     (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(43))  /* Timeout waiting for the end of RRecovTx signal */
#define E_CODE_RCMedleyFRRx_C_SEGUE2_Failure                                  (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(44))  /* Timeout after RCMedleyFRRx waiting for C_SEGUE2 */
#define E_CODE_CONFIGURATION_PARAMETERS_ERROR                                 (((E_CONFIG      | (Esub_INIT<<8))<<16)                         |(45))  /* one of the configuration parameters do not meet the standard */
#define E_CODE_BAD_MEM_ACCESS                                                 (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(46))
#define E_CODE_BAD_INSTRUCTION_ACCESS                                         (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(47))
#define E_CODE_GHS_CD_FLAG_TIME_OUT                                           (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(48))  /* Timeout when transmitting Flag in handshake cleardown */
#define E_CODE_BKGDFIFO_OVERFLOW                                              (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(49))
#define E_CODE_RCPILOT3_TIMEOUT                                               (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(50))  /*  Timeout when RX State is stuck in RC Pilot3 State  */ // XDSLRTFW-3500

#define E_CODE_RCQUIET2_TIMEOUT_Failure                                       (((E_COMM        | (Esub_Timeout<<8) )<<16)                     |(90))  /* Timeout when we cannot detect Pilot tone in RCQuiet2RxF */
#define E_CODE_OVHD_FIFO_OVERFLOW                                             (((E_CHIPSET     | (Esub_HW_Error<<8) )<<16)                    |(91))  /* HDLC OVHD  fifo overflow*/
#define E_CODE_CODESWAP_ERROR                                                 (((E_CHIPSET     | (Esub_CodeSwap<<8))<<16)                     |(92))  /* MEI has finished last codeswap request with an error */
#define E_CODE_HYB_ACCUM_FAILURE                                              (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8) )<<16)          |(93))  /* Background processing during hybrid training takes too long */
#define E_CODE_STATE_MACHINE_MISALIGNMENT                                     (((E_COMM        | (Esub_INIT<<8) )<<16)                        |(94))  /* Misalignment of TX and RX state machines (often caused by previous signal misdetection) */
#define E_CODE_SHOWTIME_BUFFER_CONFIGURATION_ERROR                            (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(95))  /* Showtime Buffer Configuration error */
#define E_CODE_ShowtimeMargin_Failure                                         (((E_ShowtimeNE  | (ESub_LOSS_OF_MARGIN<<8))<<16)               |(97))  /* Showtime SNR margin less than required Min margin or 0*/
#define E_CODE_ShowtimeLOS_Failure                                            (((E_ShowtimeNE  | (ESub_LOSS_OF_SIGNAL<<8))<<16)               |(98))  /* Showtime LOS failure*/
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
#define E_CODE_ShowtimeLOF_Failure                                            (((E_ShowtimeNE  | (ESub_LOSS_OF_FRAME<<8))<<16)                |(99))  /* Showtime LOF failure*/
#define E_CODE_ShowtimeOOS_Failure                                            (((E_ShowtimeNE  | (ESub_OOS_BC0<<8))<<16)                      |(100))
#define E_CODE_ShowtimeLOS_DueToCRC_Failure                                   (((E_ShowtimeNE  | (ESub_EXCESS_DOWNSTREAM_CRC_ERRORS<<8))<<16) |(101))
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)
// XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start_End)
#define E_CODE_ShowtimeLPR_Failure                                            (((E_ShowtimeNE  | (ESub_LOSS_OF_POWER<<8))<<16)                |(102))
//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
#define E_CODE_ShowtimeLCD_Failure                                            (((E_ShowtimeNE  | (ESub_LCD_BC0<<8))<<16)                      |(103))
#define E_CODE_ShowtimeNCD_Failure                                            (((E_ShowtimeNE  | (ESub_NCD_BC0<<8))<<16)                      |(104))
//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
//ToDo: revisit the number
#define E_CODE_SHORTLOOP_CUTPOWER_NonD57                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(105))
#define E_CODE_IOP_FIX_1                                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(110))
#define E_CODE_IOP_FIX_2                                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(111))
#define E_CODE_IOP_FIX_3                                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(112))
#define E_CODE_IOP_FIX_4                                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(113))
#define E_CODE_IOP_FIX_5                                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(114))
#define E_CODE_IOP_FIX_6                                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(115))
#define E_CODE_IOP_FIX_7                                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(116))
#define E_CODE_IOP_FIX_8                                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(117))
#define E_CODE_IOP_FIX_9                                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(118))
#define E_CODE_IOP_FIX_10                                                     (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(119))
//XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (Start)
#define E_CODE_IOP_CHANGE_VID_TSTC                                            (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(120))
#define E_CODE_IOP_RESET_CHANGE_VID_FLAG                                      (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(121))
//XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (End)
#define E_CODE_GHS_TONE_LOSS_OR_TIME_OUT                                      (((E_COMM        | (Esub_Timeout<<8) )<<16)                     |(150)) /* timeout or tone loss in the Rx side in ghs */
#define E_CODE_GHS_RX_MSGBUF_OVERFLOW                                         (((E_COMM        | (Esub_INIT<<8) )<<16)                        |(151)) /* Rx Decode (or Message) buffer overflow from too long a message */
#define E_CODE_GHS_TX_MSGBUF_OVERFLOW                                         (((E_COMM        | (Esub_INIT<<8) )<<16)                        |(152)) /* Tx Message buffer overflow from too long a message */
#define E_CODE_GHS_NearEnd_EF                                                 (((E_COMMCRC     | (Esub_INIT<<8) )<<16)                        |(153)) /* Received segment with non-matching CRC */
#define E_CODE_GHS_FarEnd_EF                                                  (((E_COMMCRC     | (Esub_INIT<<8) )<<16)                        |(154)) /* Other side sent NAK_EF, indicating segment with non-matching CRC */
#define E_CODE_GHS_NearEnd_CD                                                 (((E_COMM        | (Esub_INIT<<8) )<<16)                        |(155)) /* Received non-understood message or sth else non-compliant */
#define E_CODE_GHS_FarEnd_CD                                                  (((E_COMM        | (Esub_INIT<<8) )<<16)                        |(156)) /* Other side sent NAK_CD, indicating sth non-understood */
#define E_CODE_GHS_NoCommonMode                                               (((E_COMM        | (Esub_GhsNoCommonMode<<8))<<16)              |(157)) /* No common mode indicated in MS */
#define E_CODE_GHS_NoCommonMode_MS                                            (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(157)) /* No common mode indicated in MS */
// R3_P1: AR8_TF: PERF_US_T1413_T1&CNXT_64ptIFFT (START - END)
// XDSLRTFW-1164 BugFix_US_T1413_TI&CNXT_FWRetrain (Start_End)
#define E_CODE_RESTART_T1413                                                  (((E_COMM        | (Esub_FWInitiatedRetrain<<8)) <<16)          |(158)) /* Restart T1.413 after parsing CO VID in C-MSGS1 */
// XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (START)
#define E_CODE_GHS_ExceedingUSPowerAnxB                                       (((E_COMM        | (Esub_Unknown<<8) )<<16)                     |(159)) /* To avoid excess US transmit power we need a second training with reduces US band (adjusted TSSIs)*/
// XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (END)
#define E_CODE_GHS_SILENT                                                     (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(160)) /* No common mode indicated in MS */
#define E_CODE_GHS_RETX_ERROR                                                 (((E_COMM        | (Esub_INIT<<8))<<16)                         |(161)) /* No common mode indicated in MS */
// XDSLRTFW-507 IOP_ALL_ALL_ALL_HNSHKT1413_LongTrain_HSStuck (Start_End)
#define E_CODE_GHS_NearEnd_NoAnnexFound                                       (((E_COMM        | (Esub_GhsNoCommonMode<<8)   )<<16)           |(162)) /* no common Annex-Bit Indication CL-CLR Message*/
#define E_CODE_GHS_Dis_CTLMWorkAroundforNon_CTLM                              (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(163)) // Used for Non Centillium COs
#define E_CODE_GHS_Dis_CTLMWorkAroundfor_CTLM                                 (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(164)) // Used for Non Centillium COs
#ifdef ISDN
// SMS00842172 IOP_US_ALL_ADI930_AddNoiseToTxMedley (Start_End)
// Restart link to add Tx noise in Medley
//#define E_CODE_ADI_CHANGE_MEDLEX_TX_NOISE_LEVEL                             (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(164))
// SMS00842173 IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (Start_End)
#define E_CODE_TI_REDUCE_GHSPWR_LOW_DSPCB_RETRAIN                             (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(165))
// IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (Start_End)
#define E_CODE_Vinax_DSNomPSDBug                                              (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(166))
// IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB IOP_DS_DMT_ADI_SendNcloadedEqualToZero (Start)
#define E_CODE_ADI_REDUCE_REVPWR_LOW_DSPCB_RATE_OPTIONS_TX_MEDLEY_NOISE_RTN   (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(167))
#define E_CODE_ADI_REDUCE_REVPWR_LOW_DSPCB_RATE_OPTIONS_RETRAIN               (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(168))
// IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB IOP_DS_DMT_ADI_SendNcloadedEqualToZero (End)
#endif
#define E_CODE_GHS_VDSL_SUPPORT_FAREND                                        (((E_COMM        | (Esub_S_XDSL_MODE<<8))<<16)                  |(170)) //167 to 169 all are used in Danube
//XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (START_END)
#define E_CODE_GHS_IKNS_USPerf_ToAWRE_VID                                     (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(171))
//XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (Start_End)
#define E_CODE_RCMsg1_Bis_CNXT_USPerfMidLoopTSSI                              (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(172))
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (Start_End)
#ifdef ADSL_BONDING
#define E_CODE_BONDING_FAILURE                                                (((E_COMM        | (Esub_Timeout<<8))<<16)                      |(173))
#endif
// ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL (START_END)
#define E_CODE_BRCM_ATT_DISABLE_ANNEXL                                        (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(176))

// XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#define E_CODE_NLNF_DONE                                                      (((E_NoError     | (Esub_Unknown<<8))<<16)                      |(178))   //was 173, modified during integration
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (END)
//XDSLRTFW-262: BugFix_DS_DMT_ALL_BIS_ECODE_Reused_In_DMT (Start_End)
#define E_CODE_RCReverb5Rx_C_SEGUE_Quiet_Failure                              (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(179))
#define E_CODE_ADI_CHANGE_MEDLEX_TX_NOISE_LEVEL                               (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(180))
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
#ifdef UNV_RETX_GHS
// XDSLRTFW-261: BugFix_DS_BisPlus_All_Remove_Duplicate_ECODE (Start)
//#define E_CODE_GHS_ReTx_DS_ATM_PTM_BOTH_ENABLED      (164)   //See section A2.2 of G.inp
//#define E_CODE_GHS_DS_STM_ATM_PTM_SetInReTx          (165)   //See section A2.2 of G.inp
#define E_CODE_GHS_ReTx_DS_ATM_PTM_BOTH_ENABLED                               (((E_COMM        | (Esub_INIT<<8))<<16)                         |(181))   //See section A2.2 of G.inp
#define E_CODE_GHS_DS_STM_ATM_PTM_SetInReTx                                   (((E_COMM        | (Esub_INIT<<8))<<16)                         |(182))   //See section A2.2 of G.inp
// XDSLRTFW-261: BugFix_DS_BisPlus_All_Remove_Duplicate_ECODE (End)
#endif
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
//XDSLRTFW-1080 : IOP_GHS_WorkAround (start_end)
#define E_CODE_GHS_ALL_PTM_ENABLED                                            (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(183))
//#define E_CODE_CRC_MISMATCH_ERR_FAIL_COUNT                                  (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           | (184))   // XDSLRTFW-1843(Start_End)

//(200~206) are reserved for EOC states, see source\common\include\rt_states.h for details
#define E_CODE_JUMP_FROM_RESET_ERROR                                          (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(207))      /* ARC was reset without a code download */
#define E_CODE_XDMA_FAILURE_ON_RESET                                          (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(208))      /* XDMA not functioning after reset */
#define E_CODE_DATASWAP_XDMA_ERROR                                            (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(209))     /* Data swap encounters XDMA INT error */
#define E_CODE_DATASWAP_AHB_ERROR                                             (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(210))     /* Data swap encounters XDMA AHB error */
#define E_CODE_DATASWAP_QUEUE_BUSY_ERROR                                      (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(211))      /* Data swap times out on software queue busy */
#define E_CODE_DATASWAP_XDMA_BUSY_ERROR                                       (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(212))      /* Data swap times out on XDMA engine busy */
#define E_CODE_CODESWAP_XDMA_ERROR                                            (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(213))     /* Code swap encounters XDMA INT error */
#define E_CODE_CODESWAP_AHB_ERROR                                             (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(214))     /* Code swap encounters XDMA AHB error */
// Kernel exception
#define E_CODE_PPE_HUNG_ERROR                                                 (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(215))      /* PPE never completes  Error should be "E_CHIPSET" */
#define E_CODE_XDMA_ERROR                                                     (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(216))      /* XDMA READ error */
#define E_CODE_ADMA_ERROR                                                     (((E_CHIPSET     | (Esub_HW_Error<<8) )<<16)                    |(217))      /* ADMA READ & WRITE error */
#ifdef ADSL_62
#define E_CODE_LUT_ACCESS_ERR                                                 (((E_CHIPSET     | (Esub_HW_Error<<8) )<<16)                    |(218))
#define E_CODE_ADC_TRIM_TIMEOUT                                               (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(230))
#define E_CODE_AFE_EXCEPTION                                                  (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(231))
#define E_CODE_AFE_NOT_READY                                                  (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(232))
#define E_CODE_GLP_EXCEPTION                                                  (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(233))
#define E_CODE_AFE_RC_CALIB_ERROR                                             (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(234))
#define E_CODE_AFE_RC_MEAS_ERROR                                              (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(235))
#define E_CODE_AFE_RC_CALIB_TIMEOUT                                           (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(236))
#define E_CODE_AFE_RC_MEAS_TIMEOUT                                            (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(237))
// Kernel exception
#define E_CODE_REAL_TIME_EXCEPTION                                            (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(238))
#define E_CODE_UNEXPECTED_TX_QT_STALLS                                        (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(239))
#define E_CODE_UNEXPECTED_RX_QT_STALLS                                        (((E_CHIPSET     | (Esub_HW_Error<<8))<<16)                     |(240))
#define E_CODE_INCORRECT_LIF_MODULE                                           (((E_CONFIG      | (Esub_FALSE_HYBRID<<8))<<16)                 |(241))
#endif
//Feature_ALL_ALL_FT_ReInit_Triggers (Start)
#define E_CODE_SES30_FAILURE                                                  (((E_ShowtimeNE  | (ESub_EXCESSIVE_SEVERE_ERRORS<<8))<<16)      |(242))
#define E_CODE_ES90_FAILURE                                                   (((E_ShowtimeNE  | (ESub_EXCESSIVE_SEVERE_ERRORS<<8))<<16)      |(243))
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
#define E_CODE_ESE_FAILURE                                                    (((E_ShowtimeNE  | (ESub_EXCESSIVE_SEVERE_ERRORS<<8))<<16)      |(244))
//Feature_ALL_ALL_FT_ReInit_Triggers (End)
//Feature_ALL_ALL_FT_ReInit_Triggers (End)
#define E_CODE_L2_EXIT_REV_FALSE_DET                                          (((E_NoError     | (Esub_Unknown<<8))<<16)                      |(245))  // XDSLRTFW-416 : Enhancement_ALL_BisPLus_ALL_L2. Raise an exception if L2 exit is falsely detected.
//XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (START)
#define E_CODE_ADC_TRIM_TOP_THRESHOLD_TIMEOUT_ERROR                           (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(246))
#define E_CODE_ADC_TRIM_FSCALE_TIMEOUT_ERROR                                  (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(247))
#define E_CODE_ADC_TRIM_CAL_TIMEOUT_ERROR                                     (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(248))
#define E_CODE_AFE_WRITE_EXCEPTION_ERROR                                      (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(249))
#define E_CODE_AFE_READ_EXCEPTION_ERROR                                       (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(250))
#define E_CODE_GLP_MASTER_DFE_NOT_READY                                       (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(251))
#define E_CODE_GLP_SLAVE_AFE_NOT_READY                                        (((E_CHIPSET     | (Esub_FWInitiatedRetrain<<8))<<16)           |(252))
//XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (END)
#define E_CODE_ForceRetrain_at_Reverb1_ANNEXL                                 (((E_COMM        | (Esub_FWInitiatedRetrain<<8))<<16)           |(253))
/** XDSLRTFW-3766 Graceful shutdown due to unexpected value/situation which normally should have
    never occurred and which could cause indirectly issues (e.g. division by zero) */
#define E_CODE_UNEXPECTED_VALUE                                               (((E_UNKNOWN     | (Esub_FWInitiatedRetrain<<8))<<16)           |(254))
#define E_CODE_DEVELOPER_VALUE                                                (((E_UNKNOWN     | (Esub_FWInitiatedRetrain<<8))<<16)           |(255))
#define E_CODE_NOT_SUPPORTED_PORT_MODE                                        (((E_UNKNOWN     | (Esub_FWInitiatedRetrain<<8))<<16)           |(256))

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
//==============================================================================
//System Error Code:
//==============================================================================
//System Error code = E_OK (Lower byte in 16 bit word)
//System Sub Error code = Esub_S_INTENDED_LOCAL_SHUTDOWN (Higher byte in 16 bit word)

#define E_CODE_L3_ORDERLY_SHUTDOWN                        (((E_NoError     | (Esub_INTENDED_LOCAL_SHUTDOWN<<8))<<16) | (0xffff)) // L3 orderly shutdown
#define E_CODE_ORDERLY_SHUTDOWN                           (((E_NoError     | (Esub_INTENDED_LOCAL_SHUTDOWN<<8))<<16) | (0xffff)) // Orderly shutdown
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH (Start)
#define E_CODE_TC_NOT_SUPPORTED                           (((E_CONFIG      | (Esub_S_TC_Mode<<8))<<16)               | (552)) // TC Not If Not Supported By DSLAM
#define E_CODE_PPE_MISS_MATCH                             (((E_CONFIG      | (Esub_s_PP_Driver<<8))<<16)             | (553)) // PPE F/W Miss Match, cannot enter Showtime
//XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH (END)

// G.Fast
#define E_CODE_G_FAST_SWITCH                              (((E_COMM        | (Esub_G_FAST_MODE << 8))<<16)           | (584))
//G.Fast

//XDSLRTFW-3255 (Start)
#define E_CODE_BAR_NOT_CONFIGURED                         (((E_CONFIG      | (Esub_HW_Error<<8))<<16)                | (585)) //BAR registers (e.g. BAR-15,16,18) not configured
//XDSLRTFW-3255 (End)

// XDSLRTFW-3566 (Start_End)
#define E_CODE_PPE_CLOCK_INCORRECT                        (E_CONFIG        | (Esub_Unknown<<8)                       | ((608) << 16))   // XDSLRTFW-3565 (Start_End)

#define E_CODE_MODEM_FSM_EVENT_NOT_ALLOWED_CONFIGURATION  (E_CONFIG        | (Esub_AUTO_MSG<<8)                      | ((626) << 16))    ///< (0x0272) XDSLRTFW-4039
#define E_CODE_MODEM_FSM_EVENT_CONFIGURATION_ERROR        (E_CONFIG        | (Esub_AUTO_MSG<<8)                      | ((627) << 16))    ///< (0x0273) XDSLRTFW-4039


/* ============================================================================================ */
/* Codeswap Status Codes                                                                        */
/* ============================================================================================ */
#define CODESWAP_IDLE        (0)
#define CODESWAP_START       (1)
#define CODESWAP_IN_PROGRESS (2)
#define CODESWAP_COMPLETE    (3)
#define CODESWAP_ALL_DONE    (4)

/* ============================================================================================ */
/* Other Parameters                                                                             */
/* ============================================================================================ */
#ifndef ADSL_62
#define UNITY_SINE_GAIN          (4096)      /*  = 1 in Q4.12 */
#else
#define UNITY_SINE_GAIN          (0x8000)
#endif
#define FAIL                     (0)
#define SUCCEED                  (1)
#define OUTSTANDING              (2)
#define IDLE                     (3)

#ifndef TRUE
  #define TRUE                   (1)
#endif

#ifndef FALSE
  #define FALSE                  (0)
#endif

#define TX                       (0)
#define RX                       (1)

#define GHS                      (0)
#define TRAIN                    (1)
#define SHOWTIME                 (2)
#define RETRAIN                  (3)
#define XTRAIN                   (4)

#define DS_AS0_BEARER_CHANNEL    (0)
#define DS_AS1_BEARER_CHANNEL    (1)
#define DS_AS2_BEARER_CHANNEL    (2)
#define DS_AS3_BEARER_CHANNEL    (3)
#define DS_LS0_BEARER_CHANNEL    (4)
#define DS_LS1_BEARER_CHANNEL    (5)
#define DS_LS2_BEARER_CHANNEL    (6)

#define US_LS0_BEARER_CHANNEL    (0)
#define US_LS1_BEARER_CHANNEL    (1)
#define US_LS2_BEARER_CHANNEL    (2)



/* ============================================================================================= */
/* ============================================================================================= */
/*  Fast Retrain Parameters                                                                      */
/* ============================================================================================= */
/* ============================================================================================= */
#define NUM_PROFILES                      (4)

#define UNKNOWN_PROFILE                   (0x10)         /*  set unknown profile bit */
#define INVALID_PROFILE                   (0x20)         /*  set FR Truncate bit */

// # of 16-bit words contained in Rx Profile structure
#define SIZE_IN_WORDS_RXPROFILESTRUCT     (132)            /*  4 + gs_RxNumTones */

// # of 16-bit words contained in Tx Profile structure
#define SIZE_IN_WORDS_TXPROFILESTRUCT     (68)


/*  Line Probe parameters */
#define R_C_LINEPROBE_AC_LEN              (64)
#define LOG2_R_C_LINEPROBE_AC_LEN         (6)

#define NUM_LINEPROBE_TONES               (3)
#define R_LINEPROBE_TONE1                 (17)
#define R_LINEPROBE_TONE2                 (18)
#define R_LINEPROBE_TONE3                 (19)

#define NUM_LINEPROBE_HARMONIC2_TONES     (5)
#define NUM_LINEPROBE_HARMONIC3_TONES     (7)
#define LOGNUM_LINEPROBE_HARMONIC_TONES_TOTAL (4)        // Log2(NUM_HARMONIC2+NUM_HARMONIC3). Must be rounded UP to nearest integer.
#define FIRST_R_LINEPROBE_HARMONIC2_TONE  (34)
#define FIRST_R_LINEPROBE_HARMONIC3_TONE  (51)

// TODO: Raghu
#define NUM_LINEPROBE_CUTBACK_CNT         (3) //(6)

#define R_LINEPROBE_THRSH                 (0x7D00000)
#define PGA_DURING_LINEPROBE              (0x1400)       /*  20dB in Q8.8 format, this */
#define PGA_INITVAL_FOR_LINEPROBE         (0x1400)       /* PGA Initial Value for LineProbe */
                                                         /*  value is hardware dependent and can be changed ??? */

#define LINEPROBE_GAIN_FACTOR             (3)            /*  gus_TxSineGain gets multiplied by this factor */
#define SINEGAIN_INITVAL_FOR_LINEPROBE    (4 * UNITY_SINE_GAIN)   /* SineGain Initial Value for LineProbe */


#define EC_MARGIN                         (0x0200)       /*  PGA margin of 2 dB, Q8.8 format to account */
                                                         /*  for insufficient echo during RDC calculation */

#define NUM_TX_ECT_SYMBOLS_FR             (320)          /*  length (in symbols) of EC training signal sent by TX */

#define NUM_BITS_TO_BE_INCREMENTED        (16)           /*  Margin which determines if the stored */
                                                         /*  profile is declared valid or invalid */
                                                         /*  (64kbps/4000). 64kbps is arbitrarily chosen */
#define FINE_GAIN_DB_FACTOR               (0x4E45)       /*  = 10log10(2^26) in Q8.8, used to adjust dB value  */
                                                         /*  of fine gains when computed from Q3.13 format */
#define TWO_DB_SHORT                      (0x0303)       //  = (10log10(2) << 8).

#define CO_REVERB_TONEPOWER_DBM           (0xFC59)      //   Nominal single-tone power in CO's REVERB signal. This is
                                                         //   nominal power level for all initialization signals (except C-ECT)

#define HLOG_REPORTING_DEFAULT_ADJUST     (0)  // 0.0dB in 1/10th dB

#define TXAOCBUFFER_SIZE      10             //   starting with C-REVERB1. It does not include any power
                                             //   cutback in effect.
                                             //   Tone power = -40dBm/Hz + 10log10(4.3125kHz) = -3.65 dBm,
                                             //   where
                                             //   -40dBm/Hz is nominal PSD specified in standard, and 4.3125kHz is
                                             //   bandwidth of single tone.  In Q8.8 format, -3.65dBm => 0xFC59.

// The following parameters represent the coefficients of the polynomial approximation
// to pow(10,x) = 0.3937*x^4 + 1.4807*x^3 + 2.4667*x^2 + 2.2785*x + 0.9993
// which is only valid over the range -1 <= x <= 0.
#define POW10X_ORDER       (4)
#define POW10X_C0_MANT     (8186)      // 0.9993 in Q3.13
#define POW10X_C1_MANT     (18665)     // 2.2785 in Q3.13
#define POW10X_C2_MANT     (20207)     // 2.4667 in Q3.13
#define POW10X_C3_MANT     (12130)     // 1.4807 in Q3.13
#define POW10X_C4_MANT     (3225)      // 0.3937 in Q3.13

#define G_DMT              0
#define G_DMT_BIS          1



#define LP0_TX_RATEBUF_BOTTOM   0
#define LP0_TX_RATEBUF_TOP      (LP0_TX_RATEBUF_BOTTOM + 0x017F)

#define LP1_TX_RATEBUF_BOTTOM   (LP0_TX_RATEBUF_TOP + 0x01)
#define LP1_TX_RATEBUF_TOP      (LP1_TX_RATEBUF_BOTTOM + 0x017F)

#define LP0_RX_RATEBUF_BOTTOM   0
#define LP0_RX_RATEBUF_TOP      (LP0_RX_RATEBUF_BOTTOM + 0x05DF)

#define LP1_RX_RATEBUF_BOTTOM   (LP0_RX_RATEBUF_TOP + 0x01)
#define LP1_RX_RATEBUF_TOP      (LP1_RX_RATEBUF_BOTTOM + 0x05DF)


#define LP0_TX_RATEBUF_SIZE   (LP0_TX_RATEBUF_TOP - LP0_TX_RATEBUF_BOTTOM + 1)
#define LP1_TX_RATEBUF_SIZE   (LP1_TX_RATEBUF_TOP - LP1_TX_RATEBUF_BOTTOM + 1)
#define LP0_RX_RATEBUF_SIZE   (LP0_RX_RATEBUF_TOP - LP0_RX_RATEBUF_BOTTOM + 1)
#define LP1_RX_RATEBUF_SIZE   (LP1_RX_RATEBUF_TOP - LP1_RX_RATEBUF_BOTTOM + 1)

/* Constants to control the FFT scenario transition */
#define FFT_BUFFER_SCENARIO_TRANSITION_WAITING    0
#define FFT_BUFFER_SCENARIO_TRANSITION_STEP1      1
#define FFT_BUFFER_SCENARIO_TRANSITION_STEP2      2
#define FFT_BUFFER_SCENARIO_TRANSITION_STEP3      3

/* The usage of these constants is TDP only for codeswaping purposes */
#define NO_CODESWAP              0
#define DO_CODESWAP              1
#define START_CODESWAP           2
#define FINISHED_CODESWAP        3

/* used to choose between iridia hardware generated tx sequence */
#define GENERATE_REVERB          0
#define GENERATE_SEGUE           1
#define GENERATE_DMT_MEDLEY      2
#define GENERATE_BIS_MEDLEY      3

/* Used to record hardware overflow (Iridia, Strymon) */
// The particular bits checked are defined in ovflow.c
#ifndef ADSL_62
#define TOTAL_IT_OVERFLOW_FIELDS    1   // IFFT
#define TOTAL_IR_OVERFLOW_FIELDS    3   // FFT, FDQ, GS
#define TOTAL_ST_OVERFLOW_FIELDS    4   // GainControl, POTS HPF, AEC, DEC
#define TOTAL_SR_OVERFLOW_FIELDS    2   // Check SRC output, TDQ output
#else
#define TOTAL_IT_OVERFLOW_FIELDS    2   // IFFT
#define TOTAL_IR_OVERFLOW_FIELDS    4   // FFT, FDQ, GS
#define TOTAL_ST_OVERFLOW_FIELDS    6
#define TOTAL_SR_OVERFLOW_FIELDS    9
#endif

#define NUM_TX_OVFLOW_CNTRS         (TOTAL_IT_OVERFLOW_FIELDS+TOTAL_ST_OVERFLOW_FIELDS)
#define NUM_RX_OVFLOW_CNTRS         (TOTAL_IR_OVERFLOW_FIELDS+TOTAL_SR_OVERFLOW_FIELDS)

/* RX Strymon overflow index */
#define RXSRC_OVERFLOW_BIT          4
#define DECIMHPF_OVERFLOW_BIT       8
#define TDQ_OVERFLOW_BIT            9

/* Indicates the max number of tones that will be processed per data symbol during dd snr/fdq update */
//BugFix_DS_ADSL1_ALL_SuddenRFI (START)
#define DD_MAX_TONES_PER_SYMBOL     48
//BugFix_DS_ADSL1_ALL_SuddenRFI (END)

#define DD_FFTFDQ_LOGICAL_BUFFER    1
#define DD_GSRCD_LOGICAL_BUFFER     2

// Used in SnrUpdate_PostProcess();  A count of 20 corresponds to 10 seconds of time. With 512 tones the time is doubled.
#define NEGSNRM_THRESHOLD           20

#ifndef C_SCOPE
#define C_SCOPE
#endif

#define CONSTANT   /* Dummy used in gdata.c to draw attention to initialized constant variables */

#define FRAME_COUNT_FOR_ONE_SEC     4000

#define MAX(x,y) (x>y?x:y)
#define MIN(x,y) (x<y?x:y)

#define VENDOR_ID_LENGTH            0x08
#define VERSION_NUM_LENGTH          0x10
#define SERIAL_NUM_LENGTH           0x20

#define SECONDS_PER_MINUTE          60
#define MINUTES_PER_HOUR            60
#define HOURS_PER_DAY               24

#define FDQ_DISABLED                0
#define FDQ_ENABLED                 1

#define IRIDIA_30                   0x20      // corresponds to iridia BM 3.0

#define IRIDIA_31                   0x21      // corresponds to iridia BM 3.1
#define ZEPHYR_31                   0x31      // corresponds to iridia BM 3.1
#define STRYMON_31                  0x30      // corresponds to strymon BM 3.1

#define STRYMON_32                  0x32      // corresponds to iridia BM 3.2
#define IRIDIA_5X                   0x50      // corresponds to iridia BM 5.0 onwards

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
//Note: As per G.992.3, Ammendment-5, maximum number of break points is 16 in
//downstream direction.
#define MAX_NUM_VN_DS_PSD_POINTS   (16)
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

//constant used to set threshold for enabling S = 1/4 option against INFN
#define NET_MAX_RATE_THRESHOLD         (0xBF3)

#define PCM_FIFO_SIZE                  (100) //PCM FIFO length in bytes

#ifdef HW_VECPOW_ACCUM
   #define HW_VECPOW_ACCUM_DELAY (1)
#else
   #define HW_VECPOW_ACCUM_DELAY (0)
#endif

/* =============================================== */
/* AutoMsgHandler substates                        */
/* =============================================== */
#define CHECK_MODEM_MACRO_STATE                    0
#define SUBMIT_MODEM_STAT_FAILURE_INFO             1
#define CHECK_AUTOMESSAGE_ON_LINE_FAILURES_NE      2
#define CHECK_AUTOMESSAGE_ON_LINE_FAILURES_FE      3
#define CHECK_FAILSTATE_ON_LINE_FAILURES_NE        4
#define CHECK_FAILSTATE_ON_LINE_FAILURES_FE        5
#define CHECK_TR1_ROLLOVER                         6
#define CHECK_TR1_ALARM                            7
#define CHECK_FEDATASEND                           8
#define SUBMIT_AUTO_MSG                            9
#define CHECK_CLEAREOCSTAT                         10
#define CHECK_CLEAREOCMSG                          11
#define CHECK_AUTOMESSAGE_TC_LOADED                12


#ifdef AMAZON_SE  //HW version
#define A11 0x00
#define A12 0x01
#endif

#define IMPULSE_NOISE_COARSE_DETECT          0x1
#define IMPULSE_NOISE_FREQ_VALID             0x2
#define IMPULSE_NOISE_POWER_LEVEL_VALID      0x4
#define REIN_IMPULSE_NOISE_VALID            (IMPULSE_NOISE_COARSE_DETECT | IMPULSE_NOISE_FREQ_VALID|IMPULSE_NOISE_POWER_LEVEL_VALID)

/* =============================================== */
/* Rein Immunity                                   */
/* =============================================== */
#define DEBUG_IMP_DETECT            1
#define MAX_IMP_WIDTH               8     // for protection upto INP =8
#define INITIALIZE_METRIC_SORT      0     // metric sorting step 0
#define RUN_METRIC_SORT             1     // metric sorting step 1
#define DONE_METRIC_SORT            2     // metric sorting step 2
#define NUM_FRAMES_FDQ_PREP_METRIC  8     // frames used to average rx data for FDQ

#define DS_LOOP_ATTN_2500m          (398)       // 39.8dB
#define DS_LOOP_ATTN_2750m          (439)       // 43.9dB
#define DS_LOOP_ATTN_3000m          (477)       // 47.7dB
#define DS_LOOP_ATTN_3250m          (516)       // 51.6dB
#define DS_LOOP_ATTN_3500m          (554)       // 55.4dB
#define DS_LOOP_ATTN_3750m          (594)       // 59.4dB

#ifdef ADSL_62
//Set the time slot control
//Note: The number of clocks per time slot is computed as:
//The assumed core high speed clock rate is R = 282.624 Mhz.
//Each frame (not including the CE) is L = 4096*2 = 8192 samples
//The sampling rate for 4096 tones is S = 35.328 Mhz
//The number of clocks per frame is R*L/S = 65536
//The number of clocks per time-slot is 65536/4 = 16384
//NUM_TS = 3
//NUM_CLKS = 16383
//CLKS_LAST = 0
//TSC_ENABLE = 0 (will enable TSC right at LinkStart)
#define CRI_TSC_CTRL_NUM_TS_4K      (4-1)
#define CRI_TSC_CTRL_NUM_TS_8K      (2-1)
#define CRI_TSC_CTRL_NUM_CLKS       (16384-1)
#define CRI_TSC_CTRL_CLKS_LAST      (0)
#define CRI_TSC_CTRL_ENABLE         (1)
#define CRI_TSC_CTRL_DISABLE        (0)

//Set other clocks
#define CRI_FFT_STALL_CTL_FFT_DONE_CLKS   (29000)
#define CRI_TX_QT_STALL_CLKS_4K     (0)
#define CRI_RX_QT_STALL_CLKS_4K     (0)

#define CRI_TX_QT_STALL_CLKS_8K     (5800)
#define CRI_RX_QT_STALL_CLKS_8K     (5300)

#define CRI_TX_PMS_GO_CNT_8K        (8192)
#define CRI_TX_QTP_GO_CNT_8K        (8192)
#define CRI_TX_QT_GO_CNT_8K         (4096)
#define CRI_RX_PMS_GO_CNT_8K        (4096)
#define CRI_RX_QTP_GO_CNT_8K        (4096)
#define CRI_RX_QT_GO_CNT_8K         (0)


#define TX_IFFT_START_TIMER_4K      (36536)
#define TX_IFFT_START_TIMER_8K      (3768)

//gs_CRI_DbgCntl
#define CRI_DBG_CNTL_DISABLE_IFFT   (1<<0)
#define CRI_DBG_CNTL_DISABLE_TXQT   (1<<1)
#define CRI_DBG_CNTL_DISABLE_TXQTP  (1<<2)

#define CRI_DBG_CNTL_DISABLE_FFT    (1<<8)
#define CRI_DBG_CNTL_DISABLE_RXQT   (1<<9)
#define CRI_DBG_CNTL_DISABLE_RXQTP  (1<<10)

#endif //ADSL_62

#ifdef ADSL_62
// RTV_OUTx field in IR_RTVx
#define FFT_OUTPUT         (0)
#define SFDQ_OUTPUT        (1)
#define CDEC_OUTPUT        (6)
#define ERROR_OUTPUT       (7)

#define ERROR_ACC_OUTPUT   (3)
#define DEFAULT_OUTPUT     (2)

#define STR_NO_LPBK        (0)      //not lpbk in strymon
#define STR_TX_RX_LPBK     (1)      //loopback from strymon TX interp to ADC adjust
#define STR_AFEIF_LPBK     (2)      //loopback at strymon to AFE interface

//----------------------------------------------
// Unity Tx variable gain = (1/8)*(2^3)
//----------------------------------------------
#define UNITY_TX_VAR_GAIN        (0x1000)      //  = 1/8 in Q1.15
#define UNITY_TX_VAR_GAIN_EXP    (3)

#define TD_FD_PWR_DIFF_PLUS      (0x300)
#define TD_FD_PWR_DIFF_BIS       (0x600)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End)
//iir are stored as shifts[2], inscale[1] and 5 coefs per biquad, Rx has an outScale
#define TX_IIR_SIZE              (34)
#define RX_IIR_SIZE              (14)
#endif  //ADSL_62
//XDSLRTFW-1692 (start)
#define M_pt5_dB     15467    // (0x3C6B)
#define M_pt6_dB     15290    // (0x3BBA)
#define M_pt8_dB     14942    // (0x3A5E)
#define M_ONE_dB     14602    // (0x390A)
#define M_TWO_dB     13014    // (0x32D6)
#define M_THREE_dB   11599    // (0x2D4F)
#define M_FOUR_dB    10338    // (0x2862)
#define M_FIVE_dB    9213     // (0x23FD)
#define M_SIX_dB     8211     // (0x2013)
#define M_SEVEN_dB   7318     // (0x1C96)
#define M_EIGHT_dB   6522     // (0x197A)
#define M_NINE_dB    5813     // (0x16B5)
#define M_TEN_dB     5181     // (0x143D)
#define M_ELEVEN_dB  4617     // (0x1209)
#define M_TWELVE_dB  4115     // (0x1013)
#define DEFAULT_0_dB 16384    // (0x4000)
//XDSLRTFW-1692 (end)
#define LOWEST_SNR_VALUE      ((-32) << 8)
#define HIGHEST_SNR_VALUE     (95 << 8)
#define OUT_OF_RANGE_SNR      (255)

//SMS00801609 PERF_DS_Plus_BDCM_CGainCheating5T1 (START)
#define PGA_THRESHOLD_3_KFT      (10)     //5T1Noise, BDCM, between 3kft 5kft CG (to be 7)
#define PGA_THRESHOLD_5_KFT      (23)     //5T1Noise, BDCM, between 3kft 5kft CG  (to be 19)
//SMS00801609 PERF_DS_Plus_BDCM_CGainCheating5T1 (END)
#define PGA_THRESHOLD_6_5_KFT1   (25)     //24HDSLNoise, 6.5kft above    CG inflated
// IOP_DS_BRCM_BisPlus_DisableAnxL (START)
#define PGA_THRESHOLD_8_KFT      (36)     //not in use
//XDSLRTFW-815 PERF_A_DS_BISPLUS_ALL_MV12K750FT (START)
#define PGA_THRESHOLD_10_KFT     (40)     //12K750FT Margin Verification tests for GSI.
//ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL (START)
#define PGA_THRESHOLD_11_KFT     (42)     //not in use
#define PGA_THRESHOLD_12_KFT     (44)     // below 9.5kft disable Annex L(default CMV disabled)
//ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL (END)
#define PGA_THRESHOLD_14_KFT     (55)     //12K750FT Margin Verification tests for GSI.
//XDSLRTFW-815 PERF_A_DS_BISPLUS_ALL_MV12K750FT (END)
#define PGA_THRESHOLD_15_KFT     (70)     // Not in use
// IOP_DS_BRCM_BisPlus_DisableAnxL (END)
#define PGA_THRESHOLD_5500M      (0x46)   // Not in use

// Defines used in "BgComputeDsPCB" in oPOTS based on "CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE"
#define PGA_THRESHOLD_2KFT_AWGN     0
#define PGA_THRESHOLD_4KFT_AWGN     12
#define PGA_THRESHOLD_6KFT_AWGN     22
#define PGA_THRESHOLD_8KFT_AWGN     30
#define PGA_THRESHOLD_10KFT_AWGN    39
#define PGA_THRESHOLD_12KFT_AWGN    47
#define PGA_THRESHOLD_14KFT_AWGN    53
#define PGA_THRESHOLD_16KFT_AWGN    62


#define NMS_ADD_AGC_GAIN            (3)     //3db additional AGC gain

// constants used in NMS Algorithm Handler ( guc_NMS_AlgHandler)
#define  NOISE_MARGIN_SEP_DONE             0
#define  CALCULATE_SNR_DELTA_AGC_GAIN      1
#define  CALCULATE_SNR_DEFAULT_AGC_GAIN    2
#define  NOISE_MARGIN_SEP_DISABLED         3
#define  NOISE_MARGIN_SEP_NO_SNR_UPDATE    4
#define  NOISE_MARGIN_SEP_SRA_TEST         8
#define  NO_CTUNE_AWGN_140_THR             180 //XDSLRTFW-3603
#define  NO_CTUNE_AWGN_140_THR_ADSL1       165 //XDSLRTFW-3603 for VinaxRev2 seen as 170. So changed to 165 except BDCM/CNXT.




// ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise(Start)
// Tx Noise to Medley Signal
// Example:Ref_Singal = -38dBm/Hz & Noise = -66Bm/Hz then SNR = 28 dB(S-N)
// TxNSR(dBm/Hz)
/*
                  Calculate TxSNR value from the TxNoise offset added to RMedley Signal

 TxNoise_Round |       TxNoise(hex) |      SNR |       TxBAT|     maxLineRate |maxTotalDatarate|     maxNetRate|

             2 |             0x   2 |     75.0 |        15.0 |           1380 |            1334|           1302|
             2 |             0x   2 |     74.0 |        15.0 |           1380 |            1334|           1302|
             3 |             0x   3 |     73.0 |        15.0 |           1380 |            1334|           1302|
             3 |             0x   3 |     72.0 |        15.0 |           1380 |            1334|           1302|
             3 |             0x   3 |     71.0 |        15.0 |           1380 |            1334|           1302|
             4 |             0x   4 |     70.0 |        15.0 |           1380 |            1334|           1302|
             4 |             0x   4 |     69.0 |        15.0 |           1380 |            1334|           1302|
             5 |             0x   5 |     68.0 |        15.0 |           1380 |            1334|           1302|
             6 |             0x   6 |     67.0 |        15.0 |           1380 |            1334|           1302|
             6 |             0x   6 |     66.0 |        15.0 |           1380 |            1334|           1302|
             7 |             0x   7 |     65.0 |        15.0 |           1380 |            1334|           1302|
             8 |             0x   8 |     64.0 |        15.0 |           1380 |            1334|           1302|
             9 |             0x   9 |     63.0 |        15.0 |           1380 |            1334|           1302|
            10 |             0x   a |     62.0 |        15.0 |           1380 |            1334|           1302|
            11 |             0x   b |     61.0 |        15.0 |           1380 |            1334|           1302|
            12 |             0x   c |     60.0 |        15.0 |           1380 |            1334|           1302|
            14 |             0x   e |     59.0 |        15.0 |           1380 |            1334|           1302|
            16 |             0x  10 |     58.0 |        15.0 |           1380 |            1334|           1302|
            17 |             0x  11 |     57.0 |        15.0 |           1380 |            1334|           1302|
            20 |             0x  14 |     56.0 |        15.0 |           1380 |            1334|           1302|
            22 |             0x  16 |     55.0 |        14.9 |           1374 |            1328|           1296|
            25 |             0x  19 |     54.0 |        14.6 |           1343 |            1297|           1265|
            28 |             0x  1c |     53.0 |        14.3 |           1313 |            1267|           1235|
            31 |             0x  1f |     52.0 |        13.9 |           1282 |            1236|           1204|
            35 |             0x  23 |     51.0 |        13.6 |           1251 |            1205|           1173|
            39 |             0x  27 |     50.0 |        13.3 |           1221 |            1175|           1143|
            44 |             0x  2c |     49.0 |        12.9 |           1190 |            1144|           1112|
            49 |             0x  31 |     48.0 |        12.6 |           1159 |            1113|           1081|
            55 |             0x  37 |     47.0 |        12.3 |           1129 |            1083|           1051|
            62 |             0x  3e |     46.0 |        11.9 |           1098 |            1052|           1020|
            70 |             0x  46 |     45.0 |        11.6 |           1067 |            1021|            989|
            78 |             0x  4e |     44.0 |        11.3 |           1037 |             991|            959|
            88 |             0x  58 |     43.0 |        10.9 |           1006 |             960|            928|
            98 |             0x  62 |     42.0 |        10.6 |            975 |             929|            897|
           110 |             0x  6e |     41.0 |        10.3 |            945 |             899|            867|
           124 |             0x  7c |     40.0 |         9.9 |            914 |             868|            836|
           139 |             0x  8b |     39.0 |         9.6 |            883 |             837|            805|
           156 |             0x  9c |     38.0 |         9.3 |            853 |             807|            775|
           175 |             0x  af |     37.0 |         8.9 |            822 |             776|            744|
           196 |             0x  c4 |     36.0 |         8.6 |            791 |             745|            713|
           220 |             0x  dc |     35.0 |         8.3 |            761 |             715|            683|
           247 |             0x  f7 |     34.0 |         7.9 |            730 |             684|            652|
           277 |             0x 115 |     33.0 |         7.6 |            699 |             653|            621|
           311 |             0x 137 |     32.0 |         7.3 |            669 |             623|            591|
           348 |             0x 15c |     31.0 |         6.9 |            638 |             592|            560|
           391 |             0x 187 |     30.0 |         6.6 |            607 |             561|            529|
           439 |             0x 1b7 |     29.0 |         6.3 |            577 |             531|            499|
           492 |             0x 1ec |     28.0 |         5.9 |            546 |             500|            468|
           552 |             0x 228 |     27.0 |         5.6 |            515 |             469|            437|
           620 |             0x 26c |     26.0 |         5.3 |            485 |             439|            407|
           695 |             0x 2b7 |     25.0 |         4.9 |            454 |             408|            376|
           780 |             0x 30c |     24.0 |         4.6 |            423 |             377|            345|
           875 |             0x 36b |     23.0 |         4.3 |            393 |             347|            315|
           982 |             0x 3d6 |     22.0 |         3.9 |            362 |             316|            284|
          1102 |             0x 44e |     21.0 |         3.6 |            331 |             285|            253|
          1237 |             0x 4d5 |     20.0 |         3.3 |            301 |             255|            223|
          1387 |             0x 56b |     19.0 |         2.9 |            270 |             224|            192|
          1557 |             0x 615 |     18.0 |         2.6 |            239 |             193|            161|
          1747 |             0x 6d3 |     17.0 |         2.3 |            209 |             163|            131|
          1960 |             0x 7a8 |     16.0 |         1.9 |            178 |             132|            100|
          2199 |             0x 897 |     15.0 |         1.6 |            147 |             101|             69|
*/
// #define TxSNR_75_8db_maxBitPerTone_15_0_UsNetRate_1302kbps   (0x2)    // TxSNR_75_8db  75.8dbm/Hz            maxBitPerTone_15_0   15.0
// #define TxSNR_69_8db_maxBitPerTone_15_0_UsNetRate_1302kbps   (0x4)    // TxSNR_69_8db  69.8dbm/Hz            maxBitPerTone_15_0   15.0
// #define TxSNR_63_8db_maxBitPerTone_15_0_UsNetRate_1302kbps   (0x8)    // TxSNR_63_8db  63.8dbm/Hz            maxBitPerTone_15_0   15.0
// #define TxSNR_57_8db_maxBitPerTone_15_0_UsNetRate_1302kbps   (0x10)   // TxSNR_57_8db  57.8dbm/Hz            maxBitPerTone_15_0   15.0
// #define TxSNR_51_7db_maxBitPerTone_13_8_UsNetRate_1196kbps   (0x20)   // TxSNR_51_7db  51.7dbm/Hz            maxBitPerTone_13_8   13.8
// #define TxSNR_48_2db_maxBitPerTone_12_7_UsNetRate_1088kbps   (0x30)   // TxSNR_48_2db  48.2dbm/Hz            maxBitPerTone_12_7   12.7
// #define TxSNR_45_7db_maxBitPerTone_11_8_UsNetRate_1011kbps   (0x40)   // TxSNR_45_7db  45.7dbm/Hz            maxBitPerTone_11_8   11.8
// #define TxSNR_43_8db_maxBitPerTone_11_2_UsNetRate_952kbps    (0x50)   // TxSNR_43_8db  43.8dbm/Hz            maxBitPerTone_11_2   11.2
// #define TxSNR_42_2db_maxBitPerTone_10_7_UsNetRate_903kbps    (0x60)   // TxSNR_42_2db  42.2dbm/Hz            maxBitPerTone_10_7   10.7
// #define TxSNR_40_9db_maxBitPerTone_10_2_UsNetRate_862kbps    (0x70)   // TxSNR_40_9db  40.9dbm/Hz            maxBitPerTone_10_2   10.2
// #define TxSNR_39_7db_maxBitPerTone_9_8_UsNetRate_827kbps     (0x80)   // TxSNR_39_7db  39.7dbm/Hz            maxBitPerTone_9_8    9.8
// #define TxSNR_38_7db_maxBitPerTone_9_5_UsNetRate_795kbps     (0x90)   // TxSNR_38_7db  38.7dbm/Hz            maxBitPerTone_9_5    9.5
// #define TxSNR_37_8db_maxBitPerTone_9_2_UsNetRate_767kbps     (0xA0)   // TxSNR_37_8db  37.8dbm/Hz            maxBitPerTone_9_2    9.2
// #define TxSNR_36_9db_maxBitPerTone_8_9_UsNetRate_742kbps     (0xB0)   // TxSNR_36_9db  36.9dbm/Hz            maxBitPerTone_8_9    8.9
// #define TxSNR_36_2db_maxBitPerTone_8_7_UsNetRate_719kbps     (0xC0)   // TxSNR_36_2db  36.2dbm/Hz            maxBitPerTone_8_7    8.7
// #define TxSNR_35_5db_maxBitPerTone_8_4_UsNetRate_697kbps     (0xD0)   // TxSNR_35_5db  35.5dbm/Hz            maxBitPerTone_8_4    8.4
// #define TxSNR_34_8db_maxBitPerTone_8_2_UsNetRate_678kbps     (0xE0)   // TxSNR_34_8db  34.8dbm/Hz            maxBitPerTone_8_2    8.2
// #define TxSNR_34_2db_maxBitPerTone_8_0_UsNetRate_659kbps     (0xF0)   // TxSNR_34_2db  34.2dbm/Hz            maxBitPerTone_8_0    8.0
// #define TxSNR_33_7db_maxBitPerTone_7_8_UsNetRate_642kbps     (0x100)  // TxSNR_33_7db  33.7dbm/Hz            maxBitPerTone_7_8    7.8
// #define TxSNR_33_2db_maxBitPerTone_7_7_UsNetRate_626kbps     (0x110)  // TxSNR_33_2db  33.2dbm/Hz            maxBitPerTone_7_7    7.7
// #define TxSNR_32_7db_maxBitPerTone_7_5_UsNetRate_611kbps     (0x120)  // TxSNR_32_7db  32.7dbm/Hz            maxBitPerTone_7_5    7.5
// #define TxSNR_32_2db_maxBitPerTone_7_3_UsNetRate_596kbps     (0x130)  // TxSNR_32_2db  32.2dbm/Hz            maxBitPerTone_7_3    7.3
// #define TxSNR_31_7db_maxBitPerTone_7_2_UsNetRate_583kbps     (0x140)  // TxSNR_31_7db  31.7dbm/Hz            maxBitPerTone_7_2    7.2
// #define TxSNR_31_3db_maxBitPerTone_7_0_UsNetRate_570kbps     (0x150)  // TxSNR_31_3db  31.3dbm/Hz            maxBitPerTone_7_0    7.0
// #define TxSNR_30_9db_maxBitPerTone_6_9_UsNetRate_557kbps     (0x160)  // TxSNR_30_9db  30.9dbm/Hz            maxBitPerTone_6_9    6.9
// #define TxSNR_30_5db_maxBitPerTone_6_8_UsNetRate_545kbps     (0x170)  // TxSNR_30_5db  30.5dbm/Hz            maxBitPerTone_6_8    6.8
// #define TxSNR_30_2db_maxBitPerTone_6_7_UsNetRate_534kbps     (0x180)  // TxSNR_30_2db  30.2dbm/Hz            maxBitPerTone_6_7    6.7
// #define TxSNR_29_8db_maxBitPerTone_6_5_UsNetRate_523kbps     (0x190)  // TxSNR_29_8db  29.8dbm/Hz            maxBitPerTone_6_5    6.5
// #define TxSNR_29_5db_maxBitPerTone_6_4_UsNetRate_513kbps     (0x1A0)  // TxSNR_29_5db  29.5dbm/Hz            maxBitPerTone_6_4    6.4
// #define TxSNR_29_1db_maxBitPerTone_6_3_UsNetRate_503kbps     (0x1B0)  // TxSNR_29_1db  29.1dbm/Hz            maxBitPerTone_6_3    6.3
// #define TxSNR_28_8db_maxBitPerTone_6_2_UsNetRate_493kbps     (0x1C0)  // TxSNR_28_8db  28.8dbm/Hz            maxBitPerTone_6_2    6.2
// #define TxSNR_28_5db_maxBitPerTone_6_1_UsNetRate_484kbps     (0x1D0)  // TxSNR_28_5db  28.5dbm/Hz            maxBitPerTone_6_1    6.1
// #define TxSNR_28_2db_maxBitPerTone_6_0_UsNetRate_475kbps     (0x1E0)  // TxSNR_28_2db  28.2dbm/Hz            maxBitPerTone_6_0    6.0
// #define TxSNR_27_9db_maxBitPerTone_5_9_UsNetRate_466kbps     (0x1F0)  // TxSNR_27_9db  27.9dbm/Hz            maxBitPerTone_5_9    5.9
// #define TxSNR_27_7db_maxBitPerTone_5_8_UsNetRate_457kbps     (0x200)  // TxSNR_27_7db  27.7dbm/Hz            maxBitPerTone_5_8    5.8
// #define TxSNR_27_4db_maxBitPerTone_5_7_UsNetRate_449kbps     (0x210)  // TxSNR_27_4db  27.4dbm/Hz            maxBitPerTone_5_7    5.7
// #define TxSNR_27_1db_maxBitPerTone_5_6_UsNetRate_441kbps     (0x220)  // TxSNR_27_1db  27.1dbm/Hz            maxBitPerTone_5_6    5.6
// #define TxSNR_26_9db_maxBitPerTone_5_6_UsNetRate_434kbps     (0x230)  // TxSNR_26_9db  26.9dbm/Hz            maxBitPerTone_5_6    5.6
// #define TxSNR_26_6db_maxBitPerTone_5_5_UsNetRate_426kbps     (0x240)  // TxSNR_26_6db  26.6dbm/Hz            maxBitPerTone_5_5    5.5
// #define TxSNR_26_4db_maxBitPerTone_5_4_UsNetRate_419kbps     (0x250)  // TxSNR_26_4db  26.4dbm/Hz            maxBitPerTone_5_4    5.4
// #define TxSNR_26_2db_maxBitPerTone_5_3_UsNetRate_412kbps     (0x260)  // TxSNR_26_2db  26.2dbm/Hz            maxBitPerTone_5_3    5.3
// #define TxSNR_25_9db_maxBitPerTone_5_2_UsNetRate_405kbps     (0x270)  // TxSNR_25_9db  25.9dbm/Hz            maxBitPerTone_5_2    5.2
// #define TxSNR_25_7db_maxBitPerTone_5_2_UsNetRate_398kbps     (0x280)  // TxSNR_25_7db  25.7dbm/Hz            maxBitPerTone_5_2    5.2
// #define TxSNR_25_5db_maxBitPerTone_5_1_UsNetRate_391kbps     (0x290)  // TxSNR_25_5db  25.5dbm/Hz            maxBitPerTone_5_1    5.1
// #define TxSNR_25_3db_maxBitPerTone_5_0_UsNetRate_385kbps     (0x2A0)  // TxSNR_25_3db  25.3dbm/Hz            maxBitPerTone_5_0    5.0
// #define TxSNR_25_1db_maxBitPerTone_5_0_UsNetRate_379kbps     (0x2B0)  // TxSNR_25_1db  25.1dbm/Hz            maxBitPerTone_5_0    5.0
// #define TxSNR_24_9db_maxBitPerTone_4_9_UsNetRate_373kbps     (0x2C0)  // TxSNR_24_9db  24.9dbm/Hz            maxBitPerTone_4_9    4.9
// #define TxSNR_24_7db_maxBitPerTone_4_8_UsNetRate_367kbps     (0x2D0)  // TxSNR_24_7db  24.7dbm/Hz            maxBitPerTone_4_8    4.8
// #define TxSNR_24_5db_maxBitPerTone_4_8_UsNetRate_361kbps     (0x2E0)  // TxSNR_24_5db  24.5dbm/Hz            maxBitPerTone_4_8    4.8
// #define TxSNR_24_3db_maxBitPerTone_4_7_UsNetRate_355kbps     (0x2F0)  // TxSNR_24_3db  24.3dbm/Hz            maxBitPerTone_4_7    4.7
// #define TxSNR_24_1db_maxBitPerTone_4_6_UsNetRate_349kbps     (0x300)  // TxSNR_24_1db  24.1dbm/Hz            maxBitPerTone_4_6    4.6
// #define TxSNR_24_0db_maxBitPerTone_4_6_UsNetRate_344kbps     (0x310)  // TxSNR_24_0db  24.0dbm/Hz            maxBitPerTone_4_6    4.6
// #define TxSNR_23_8db_maxBitPerTone_4_5_UsNetRate_339kbps     (0x320)  // TxSNR_23_8db  23.8dbm/Hz            maxBitPerTone_4_5    4.5
// #define TxSNR_23_6db_maxBitPerTone_4_5_UsNetRate_333kbps     (0x330)  // TxSNR_23_6db  23.6dbm/Hz            maxBitPerTone_4_5    4.5
// #define TxSNR_23_4db_maxBitPerTone_4_4_UsNetRate_328kbps     (0x340)  // TxSNR_23_4db  23.4dbm/Hz            maxBitPerTone_4_4    4.4
// #define TxSNR_23_3db_maxBitPerTone_4_4_UsNetRate_323kbps     (0x350)  // TxSNR_23_3db  23.3dbm/Hz            maxBitPerTone_4_4    4.4
// #define TxSNR_23_1db_maxBitPerTone_4_3_UsNetRate_318kbps     (0x360)  // TxSNR_23_1db  23.1dbm/Hz            maxBitPerTone_4_3    4.3
// #define TxSNR_23_0db_maxBitPerTone_4_3_UsNetRate_313kbps     (0x370)  // TxSNR_23_0db  23.0dbm/Hz            maxBitPerTone_4_3    4.3
// #define TxSNR_22_8db_maxBitPerTone_4_2_UsNetRate_308kbps     (0x380)  // TxSNR_22_8db  22.8dbm/Hz            maxBitPerTone_4_2    4.2
// #define TxSNR_22_6db_maxBitPerTone_4_1_UsNetRate_304kbps     (0x390)  // TxSNR_22_6db  22.6dbm/Hz            maxBitPerTone_4_1    4.1
// #define TxSNR_22_5db_maxBitPerTone_4_1_UsNetRate_299kbps     (0x3A0)  // TxSNR_22_5db  22.5dbm/Hz            maxBitPerTone_4_1    4.1
// #define TxSNR_22_3db_maxBitPerTone_4_0_UsNetRate_294kbps     (0x3B0)  // TxSNR_22_3db  22.3dbm/Hz            maxBitPerTone_4_0    4.0
// #define TxSNR_22_2db_maxBitPerTone_4_0_UsNetRate_290kbps     (0x3C0)  // TxSNR_22_2db  22.2dbm/Hz            maxBitPerTone_4_0    4.0
// #define TxSNR_22_1db_maxBitPerTone_4_0_UsNetRate_286kbps     (0x3D0)  // TxSNR_22_1db  22.1dbm/Hz            maxBitPerTone_4_0    4.0
// #define TxSNR_21_9db_maxBitPerTone_3_9_UsNetRate_281kbps     (0x3E0)  // TxSNR_21_9db  21.9dbm/Hz            maxBitPerTone_3_9    3.9
// #define TxSNR_21_8db_maxBitPerTone_3_9_UsNetRate_277kbps     (0x3F0)  // TxSNR_21_8db  21.8dbm/Hz            maxBitPerTone_3_9    3.9
// #define TxSNR_21_6db_maxBitPerTone_3_8_UsNetRate_273kbps     (0x400)  // TxSNR_21_6db  21.6dbm/Hz            maxBitPerTone_3_8    3.8

#define USSNR_Medley_60_0_maxBitPerTone_15_0_maxNetRate_1302kbps      (0xc)               // USSNR_Medley_60_0           60.0      maxBitPerTone_15.0       15.0
#define USSNR_Medley_59_0_maxBitPerTone_15_0_maxNetRate_1302kbps      (0xe)               // USSNR_Medley_59_0           59.0      maxBitPerTone_15.0       15.0
#define USSNR_Medley_58_0_maxBitPerTone_15_0_maxNetRate_1302kbps      (0x10)              // USSNR_Medley_58_0           58.0      maxBitPerTone_15.0       15.0
#define USSNR_Medley_57_0_maxBitPerTone_15_0_maxNetRate_1302kbps      (0x11)              // USSNR_Medley_57_0           57.0      maxBitPerTone_15.0       15.0
#define USSNR_Medley_56_0_maxBitPerTone_15_0_maxNetRate_1302kbps      (0x14)              // USSNR_Medley_56_0           56.0      maxBitPerTone_15.0       15.0
#define USSNR_Medley_55_0_maxBitPerTone_14_9_maxNetRate_1296kbps      (0x16)              // USSNR_Medley_55_0           55.0      maxBitPerTone_14.9       14.9
#define USSNR_Medley_54_0_maxBitPerTone_14_6_maxNetRate_1265kbps      (0x19)              // USSNR_Medley_54_0           54.0      maxBitPerTone_14.6       14.6
#define USSNR_Medley_53_0_maxBitPerTone_14_3_maxNetRate_1235kbps      (0x1c)              // USSNR_Medley_53_0           53.0      maxBitPerTone_14.3       14.3
#define USSNR_Medley_52_0_maxBitPerTone_13_9_maxNetRate_1204kbps      (0x1f)              // USSNR_Medley_52_0           52.0      maxBitPerTone_13.9       13.9
#define USSNR_Medley_51_0_maxBitPerTone_13_6_maxNetRate_1173kbps      (0x23)              // USSNR_Medley_51_0           51.0      maxBitPerTone_13.6       13.6
#define USSNR_Medley_50_0_maxBitPerTone_13_3_maxNetRate_1143kbps      (0x27)              // USSNR_Medley_50_0           50.0      maxBitPerTone_13.3       13.3
#define USSNR_Medley_49_0_maxBitPerTone_12_9_maxNetRate_1112kbps      (0x2c)              // USSNR_Medley_49_0           49.0      maxBitPerTone_12.9       12.9
#define USSNR_Medley_48_0_maxBitPerTone_12_6_maxNetRate_1081kbps      (0x31)              // USSNR_Medley_48_0           48.0      maxBitPerTone_12.6       12.6
#define USSNR_Medley_47_0_maxBitPerTone_12_3_maxNetRate_1051kbps      (0x37)              // USSNR_Medley_47_0           47.0      maxBitPerTone_12.3       12.3
#define USSNR_Medley_46_0_maxBitPerTone_11_9_maxNetRate_1020kbps      (0x3e)              // USSNR_Medley_46_0           46.0      maxBitPerTone_11.9       11.9
#define USSNR_Medley_45_0_maxBitPerTone_11_6_maxNetRate_989kbps       (0x46)              // USSNR_Medley_45_0           45.0      maxBitPerTone_11.6       11.6
#define USSNR_Medley_44_0_maxBitPerTone_11_3_maxNetRate_959kbps       (0x4e)              // USSNR_Medley_44_0           44.0      maxBitPerTone_11.3       11.3
#define USSNR_Medley_43_0_maxBitPerTone_10_9_maxNetRate_928kbps       (0x58)              // USSNR_Medley_43_0           43.0      maxBitPerTone_10.9       10.9
#define USSNR_Medley_42_0_maxBitPerTone_10_6_maxNetRate_897kbps       (0x62)              // USSNR_Medley_42_0           42.0      maxBitPerTone_10.6       10.6
#define USSNR_Medley_41_0_maxBitPerTone_10_3_maxNetRate_867kbps       (0x6e)              // USSNR_Medley_41_0           41.0      maxBitPerTone_10.3       10.3
#define USSNR_Medley_40_0_maxBitPerTone_9_9_maxNetRate_836kbps        (0x7c)              // USSNR_Medley_40_0           40.0      maxBitPerTone_ 9.9        9.9
#define USSNR_Medley_39_0_maxBitPerTone_9_6_maxNetRate_805kbps        (0x8b)              // USSNR_Medley_39_0           39.0      maxBitPerTone_ 9.6        9.6
#define USSNR_Medley_38_0_maxBitPerTone_9_3_maxNetRate_775kbps        (0x9c)              // USSNR_Medley_38_0           38.0      maxBitPerTone_ 9.3        9.3
#define USSNR_Medley_37_0_maxBitPerTone_8_9_maxNetRate_744kbps        (0xaf)              // USSNR_Medley_37_0           37.0      maxBitPerTone_ 8.9        8.9
#define USSNR_Medley_36_0_maxBitPerTone_8_6_maxNetRate_713kbps        (0xc4)              // USSNR_Medley_36_0           36.0      maxBitPerTone_ 8.6        8.6
#define USSNR_Medley_35_0_maxBitPerTone_8_3_maxNetRate_683kbps        (0xdc)              // USSNR_Medley_35_0           35.0      maxBitPerTone_ 8.3        8.3
#define USSNR_Medley_34_0_maxBitPerTone_7_9_maxNetRate_652kbps        (0xf7)              // USSNR_Medley_34_0           34.0      maxBitPerTone_ 7.9        7.9
#define USSNR_Medley_33_0_maxBitPerTone_7_6_maxNetRate_621kbps        (0x15)              // USSNR_Medley_33_0           33.0      maxBitPerTone_ 7.6        7.6
#define USSNR_Medley_32_0_maxBitPerTone_7_3_maxNetRate_591kbps        (0x37)              // USSNR_Medley_32_0           32.0      maxBitPerTone_ 7.3        7.3
#define USSNR_Medley_31_0_maxBitPerTone_6_9_maxNetRate_560kbps        (0x5c)              // USSNR_Medley_31_0           31.0      maxBitPerTone_ 6.9        6.9
#define USSNR_Medley_30_0_maxBitPerTone_6_6_maxNetRate_529kbps        (0x87)              // USSNR_Medley_30_0           30.0      maxBitPerTone_ 6.6        6.6
#define USSNR_Medley_29_0_maxBitPerTone_6_3_maxNetRate_499kbps        (0xb7)              // USSNR_Medley_29_0           29.0      maxBitPerTone_ 6.3        6.3
#define USSNR_Medley_28_0_maxBitPerTone_5_9_maxNetRate_468kbps        (0xec)              // USSNR_Medley_28_0           28.0      maxBitPerTone_ 5.9        5.9
#define USSNR_Medley_27_0_maxBitPerTone_5_6_maxNetRate_437kbps        (0x28)              // USSNR_Medley_27_0           27.0      maxBitPerTone_ 5.6        5.6
#define USSNR_Medley_26_0_maxBitPerTone_5_3_maxNetRate_407kbps        (0x6c)              // USSNR_Medley_26_0           26.0      maxBitPerTone_ 5.3        5.3
#define USSNR_Medley_25_0_maxBitPerTone_4_9_maxNetRate_376kbps        (0xb7)              // USSNR_Medley_25_0           25.0      maxBitPerTone_ 4.9        4.9
#define USSNR_Medley_24_0_maxBitPerTone_4_6_maxNetRate_345kbps        (0x0c)              // USSNR_Medley_24_0           24.0      maxBitPerTone_ 4.6        4.6
#define USSNR_Medley_23_0_maxBitPerTone_4_3_maxNetRate_315kbps        (0x6b)              // USSNR_Medley_23_0           23.0      maxBitPerTone_ 4.3        4.3
#define USSNR_Medley_22_0_maxBitPerTone_3_9_maxNetRate_284kbps        (0xd6)              // USSNR_Medley_22_0           22.0      maxBitPerTone_ 3.9        3.9
#define USSNR_Medley_21_0_maxBitPerTone_3_6_maxNetRate_253kbps        (0x4e)              // USSNR_Medley_21_0           21.0      maxBitPerTone_ 3.6        3.6
#define USSNR_Medley_20_0_maxBitPerTone_3_3_maxNetRate_223kbps        (0xd5)              // USSNR_Medley_20_0           20.0      maxBitPerTone_ 3.3        3.3
#define USSNR_Medley_19_0_maxBitPerTone_2_9_maxNetRate_192kbps        (0x6b)              // USSNR_Medley_19_0           19.0      maxBitPerTone_ 2.9        2.9
#define USSNR_Medley_18_0_maxBitPerTone_2_6_maxNetRate_161kbps        (0x15)              // USSNR_Medley_18_0           18.0      maxBitPerTone_ 2.6        2.6
#define USSNR_Medley_17_0_maxBitPerTone_2_3_maxNetRate_131kbps        (0xd3)              // USSNR_Medley_17_0           17.0      maxBitPerTone_ 2.3        2.3
#define USSNR_Medley_16_0_maxBitPerTone_1_9_maxNetRate_100kbps        (0xa8)              // USSNR_Medley_16_0           16.0      maxBitPerTone_ 1.9        1.9
#define USSNR_Medley_15_0_maxBitPerTone_1_6_maxNetRate_69kbps         (0x97)              // USSNR_Medley_15_0           15.0      maxBitPerTone_ 1.6        1.6

// Support the exsisting TxNoise Offset
// %  TxNoise|       SNR |       TxBAT|     maxLineRate |maxTotalDatarate|     maxNetRate|
// %  0x200(512)    27.7 |         5.8 |            535 |            489|             457|
// %  0x100(256)    33.7 |         7.8 |            720 |            674|             642|
// %  0xC0(192)     36.2 |         8.7 |            797 |            751|             719|
// %  0x23(35)      51.0 |        13.6 |           1250 |           1204|            1172|
// %  0x16(22)      55.0 |        14.9 |           1374 |           1328|            1296|
// %  0x40(64)      45.7 |        11.8 |           1089 |           1043|            1011|
// %  0x80(128)     39.7 |         9.8 |            905 |            859|             827|

#define USSNR_Medley_27_7_maxBitPerTone_5_8_maxNetRate_457kbps       (0x200)
#define USSNR_Medley_33_7_maxBitPerTone_7_8_maxNetRate_642kbps       (0x100)
#define USSNR_Medley_51_0_maxBitPerTone_13_6_maxNetRate_1172kbps     (0x23)
#define USSNR_Medley_36_2_maxBitPerTone_8_7_maxNetRate_719kbps       (0xC0)
#define USSNR_Medley_45_7_maxBitPerTone_11_8_maxNetRate_1011kbps     (0x40)
#define USSNR_Medley_39_7_maxBitPerTone_9_8_maxNetRate_827kbps       (0x80)

// DS Line Attenuation values are calibration in BLR Lab on AR9 Platform
// LoopReachTest
  // LPR(M)|  LATN(dB)| USRate  DSRate|
       // 0 |    0.0|     1325 |   27510
      // 50 |    0.0|     1353 |   27478
    // 5750 |  790.0|      424 |     661
    // 5800 |  794.0|      409 |     597
    // 5850 |  801.0|      405 |     564
    // 5900 |  806.0|      377 |     533
    // 5950 |  814.0|      364 |     469
    // 6000 |  821.0|      345 |     436
#define DS_LPR_0_M_Line_ATTEN_0_0_dB         (0)
#define DS_LPR_50_M_Line_ATTEN_0_0_dB        (0)
#define DS_LPR_100_M_Line_ATTEN_0_0_dB       (0)
#define DS_LPR_150_M_Line_ATTEN_0_0_dB       (0)
#define DS_LPR_200_M_Line_ATTEN_0_0_dB       (0)
#define DS_LPR_250_M_Line_ATTEN_0_9_dB       (9)
#define DS_LPR_300_M_Line_ATTEN_2_1_dB       (21)
#define DS_LPR_350_M_Line_ATTEN_3_3_dB       (33)
#define DS_LPR_400_M_Line_ATTEN_4_4_dB       (44)
#define DS_LPR_450_M_Line_ATTEN_5_8_dB       (58)
#define DS_LPR_500_M_Line_ATTEN_6_8_dB       (68)
#define DS_LPR_550_M_Line_ATTEN_7_8_dB       (78)
#define DS_LPR_600_M_Line_ATTEN_8_9_dB       (89)
#define DS_LPR_650_M_Line_ATTEN_10_0_dB      (100)
#define DS_LPR_700_M_Line_ATTEN_10_9_dB      (109)
#define DS_LPR_750_M_Line_ATTEN_11_9_dB      (119)
#define DS_LPR_800_M_Line_ATTEN_12_9_dB      (129)
#define DS_LPR_850_M_Line_ATTEN_13_8_dB      (138)
#define DS_LPR_900_M_Line_ATTEN_14_6_dB      (146)
#define DS_LPR_1000_M_Line_ATTEN_16_4_dB     (164)
#define DS_LPR_1050_M_Line_ATTEN_17_2_dB     (172)
#define DS_LPR_1100_M_Line_ATTEN_18_2_dB     (182)
#define DS_LPR_1150_M_Line_ATTEN_19_0_dB     (190)
#define DS_LPR_1200_M_Line_ATTEN_19_7_dB     (197)
#define DS_LPR_1250_M_Line_ATTEN_20_6_dB     (206)
#define DS_LPR_1300_M_Line_ATTEN_21_4_dB     (214)
#define DS_LPR_1350_M_Line_ATTEN_22_2_dB     (222)
#define DS_LPR_1400_M_Line_ATTEN_22_8_dB     (228)
#define DS_LPR_1450_M_Line_ATTEN_23_7_dB     (237)
#define DS_LPR_1500_M_Line_ATTEN_24_4_dB     (244)
#define DS_LPR_1550_M_Line_ATTEN_25_2_dB     (252)
#define DS_LPR_1600_M_Line_ATTEN_26_0_dB     (260)
#define DS_LPR_1650_M_Line_ATTEN_26_8_dB     (268)
#define DS_LPR_1700_M_Line_ATTEN_27_4_dB     (274)
#define DS_LPR_1750_M_Line_ATTEN_28_3_dB     (283)
#define DS_LPR_1800_M_Line_ATTEN_28_9_dB     (289)
#define DS_LPR_1850_M_Line_ATTEN_29_7_dB     (297)
#define DS_LPR_1900_M_Line_ATTEN_30_3_dB     (303)
#define DS_LPR_1950_M_Line_ATTEN_31_2_dB     (312)
#define DS_LPR_2000_M_Line_ATTEN_31_8_dB     (318)
#define DS_LPR_2050_M_Line_ATTEN_32_6_dB     (326)
#define DS_LPR_2100_M_Line_ATTEN_33_3_dB     (333)
#define DS_LPR_2150_M_Line_ATTEN_34_0_dB     (340)
#define DS_LPR_2200_M_Line_ATTEN_34_6_dB     (346)
#define DS_LPR_2250_M_Line_ATTEN_35_3_dB     (353)
#define DS_LPR_2300_M_Line_ATTEN_36_0_dB     (360)
#define DS_LPR_2350_M_Line_ATTEN_36_7_dB     (367)
#define DS_LPR_2400_M_Line_ATTEN_37_4_dB     (374)
#define DS_LPR_2450_M_Line_ATTEN_38_1_dB     (381)
#define DS_LPR_2500_M_Line_ATTEN_38_8_dB     (388)
#define DS_LPR_2550_M_Line_ATTEN_39_5_dB     (395)
#define DS_LPR_2600_M_Line_ATTEN_40_2_dB     (402)
#define DS_LPR_2650_M_Line_ATTEN_40_9_dB     (409)
#define DS_LPR_2700_M_Line_ATTEN_41_5_dB     (415)
#define DS_LPR_2750_M_Line_ATTEN_42_3_dB     (423)
#define DS_LPR_2800_M_Line_ATTEN_42_9_dB     (429)
#define DS_LPR_2850_M_Line_ATTEN_43_7_dB     (437)
#define DS_LPR_2900_M_Line_ATTEN_44_3_dB     (443)
#define DS_LPR_2950_M_Line_ATTEN_45_1_dB     (451)
#define DS_LPR_3000_M_Line_ATTEN_45_7_dB     (457)
#define DS_LPR_3050_M_Line_ATTEN_46_4_dB     (464)
#define DS_LPR_3100_M_Line_ATTEN_47_0_dB     (470)
#define DS_LPR_3150_M_Line_ATTEN_47_8_dB     (478)
#define DS_LPR_3200_M_Line_ATTEN_48_4_dB     (484)
#define DS_LPR_3250_M_Line_ATTEN_49_1_dB     (491)
#define DS_LPR_3300_M_Line_ATTEN_49_8_dB     (498)
#define DS_LPR_3350_M_Line_ATTEN_50_5_dB     (505)
#define DS_LPR_3400_M_Line_ATTEN_51_1_dB     (511)
#define DS_LPR_3450_M_Line_ATTEN_51_8_dB     (518)
#define DS_LPR_3500_M_Line_ATTEN_52_4_dB     (524)
#define DS_LPR_3550_M_Line_ATTEN_53_1_dB     (531)
#define DS_LPR_3600_M_Line_ATTEN_53_7_dB     (537)
#define DS_LPR_3650_M_Line_ATTEN_54_4_dB     (544)
#define DS_LPR_3700_M_Line_ATTEN_55_0_dB     (550)
#define DS_LPR_3750_M_Line_ATTEN_55_7_dB     (557)
#define DS_LPR_3800_M_Line_ATTEN_56_3_dB     (563)
#define DS_LPR_3850_M_Line_ATTEN_57_0_dB     (570)
#define DS_LPR_3900_M_Line_ATTEN_57_5_dB     (575)
#define DS_LPR_3950_M_Line_ATTEN_57_7_dB     (577)
#define DS_LPR_4000_M_Line_ATTEN_58_3_dB     (583)
#define DS_LPR_4050_M_Line_ATTEN_59_0_dB     (590)
#define DS_LPR_4100_M_Line_ATTEN_59_5_dB     (595)
#define DS_LPR_4150_M_Line_ATTEN_60_2_dB     (602)
#define DS_LPR_4200_M_Line_ATTEN_60_3_dB     (603)
#define DS_LPR_4250_M_Line_ATTEN_61_0_dB     (610)
#define DS_LPR_4300_M_Line_ATTEN_61_6_dB     (616)
#define DS_LPR_4350_M_Line_ATTEN_62_2_dB     (622)
#define DS_LPR_4400_M_Line_ATTEN_62_3_dB     (623)
#define DS_LPR_4450_M_Line_ATTEN_63_1_dB     (631)
#define DS_LPR_4500_M_Line_ATTEN_63_5_dB     (635)
#define DS_LPR_4550_M_Line_ATTEN_64_2_dB     (642)
#define DS_LPR_4600_M_Line_ATTEN_64_8_dB     (648)
#define DS_LPR_4650_M_Line_ATTEN_65_5_dB     (655)
#define DS_LPR_4700_M_Line_ATTEN_66_0_dB     (660)
#define DS_LPR_4750_M_Line_ATTEN_82_1_dB     (821)
#define DS_LPR_4800_M_Line_ATTEN_67_2_dB     (672)
#define DS_LPR_4850_M_Line_ATTEN_68_0_dB     (680)
#define DS_LPR_4900_M_Line_ATTEN_82_1_dB     (821)
#define DS_LPR_4950_M_Line_ATTEN_69_2_dB     (692)
#define DS_LPR_5000_M_Line_ATTEN_69_7_dB     (697)
#define DS_LPR_5050_M_Line_ATTEN_70_4_dB     (704)
#define DS_LPR_5100_M_Line_ATTEN_70_9_dB     (709)
#define DS_LPR_5150_M_Line_ATTEN_71_6_dB     (716)
#define DS_LPR_5200_M_Line_ATTEN_72_1_dB     (721)
#define DS_LPR_5250_M_Line_ATTEN_72_9_dB     (729)
#define DS_LPR_5300_M_Line_ATTEN_73_3_dB     (733)
#define DS_LPR_5350_M_Line_ATTEN_74_1_dB     (741)
#define DS_LPR_5400_M_Line_ATTEN_74_6_dB     (746)
#define DS_LPR_5450_M_Line_ATTEN_75_3_dB     (753)
#define DS_LPR_5500_M_Line_ATTEN_75_8_dB     (758)
#define DS_LPR_5550_M_Line_ATTEN_76_5_dB     (765)
#define DS_LPR_5600_M_Line_ATTEN_77_0_dB     (770)
#define DS_LPR_5650_M_Line_ATTEN_77_8_dB     (778)
#define DS_LPR_5700_M_Line_ATTEN_78_2_dB     (782)
#define DS_LPR_5750_M_Line_ATTEN_79_0_dB     (790)
#define DS_LPR_5800_M_Line_ATTEN_79_4_dB     (794)
#define DS_LPR_5850_M_Line_ATTEN_80_1_dB     (801)
#define DS_LPR_5900_M_Line_ATTEN_80_6_dB     (806)
#define DS_LPR_5950_M_Line_ATTEN_81_4_dB     (814)
#define DS_LPR_6000_M_Line_ATTEN_82_1_dB     (821)
// ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise   (End)

// XDSLRTFW-3566 (Start)
// XDSLRTFW-3712 (Start)
#define PPE_CLOCK_576MHz      (0x1)      // PPE32 clock frequency of 576 MHz
#define PPE_CLOCK_494MHz      (0x2)      // PPE32 clock frequency of 494 MHz
#define PPE_CLOCK_432MHz      (0x3)      // PPE32 clock frequency of 432 MHz
#define PPE_CLOCK_288MHz      (0x4)      // PPE32 clock frequency of 288 MHz

#define TRIGGER_PPE_WRITE     (0x10)     // This bit is used to trigger/force the PPE32 frequency
#define PPE_CLOCK_FREQ_MASK   (0x3)      // The PPE32 clock frequency which is to be forced (567 MHz or 494MHz or 432MHz or 288 MHz)

#define FSCALE_AUTO_OFF       (0x0)      // No change in PPE32 clock frequency.
#define FSCALE_AUTO_A         (0x1)      // PPE32 clock frequency is changed based on the profile or bonding capability
#define FSCALE_AUTO_B         (0x2)      // PPE32 clock frequency is changed based on the datarates after SRA (For Future, Not supported currently)
#define FSCALE_AUTO_C         (0x3)      // PPE32 clock frequency is changed based on the user traffic (For Future, Not supported currently)
// XDSLRTFW-3712 (End)
// XDSLRTFW-3566 (End)

// XDSLRTFW-1782 (Start_End)
// The size of the buffer is 2048 bytes because we are using variable array of
// length 1024 of type uint16 i.e, 1024*2 = 2048 bytes
#define MAX_SIZE_OF_CMV_CONFIGURATION        (1024)

#ifdef DEBUG_STREAMING

#define SIZE_STRYMON_REG_DUMP 22

#define DSH_EOC_BUFFER_LENGTH 1000

// defines to determine which background functions shall be re-queued after execution
#define DSH_REQUEUE_DSH_BG_SERVICE      0x0001
#define DSH_REQUEUE_NMP_BG_SERVICE      0x0002

//=========================================================================
// Common Defines
//=========================================================================
#define DSH_PROTOCOL_VERSION 0x4000

// number of bytes in buffer befor a stream message is sent.
#define DSH_BUFFER_FILL_THRESHOLD  200
/// size of debug stream queue
#define DSH_QUEUE_DEPTH            18
/// size of the byte buffer to hold buffered streams
#define DSH_BUFFER_SIZE            370
#define MAX_MAILBOX_PAYLOAD_LENGTH 256

/// maximum number of debug stream ids.
/**
    Must be a multiple of T_DSH_MaskEntry's number of bits as each id is represented as a bit.
*/
#define DSH_CTRL_MAX_NUM             160



#define DSH_EVENT_DBG_STR           0x0001
#define DSH_EVENT_EVT_BUF           0x0002
#define DSH_EVENT_HEADER_SIZE 6

/// mask for debug stream source for Tracee to differentiate between CPE CO debug streams
#define DSH_STREAM_MASK             0x0C00
/// Stream coming from CO
#define DSH_STREAM_SOURCE_CO        0x0000
/// Stream coming from CPE
#define DSH_STREAM_SOURCE_CPE       0x0400
/// Stream coming from whatever (reserved for future)
#define DSH_STREAM_SOURCE_WHATEVER  0x0800
/// this flag is set when the stream's payload had to be padded by one byte to have an even size.
#define DSH_STREAM_SIZE_IS_ODD      0x1000
/// Overflow in debug stream queue
#define DSH_OVERFLOW_INDICATION     0x2000
/// Next fragment of debug stream data
#define DSH_NEXT_FRAGMENT           0x0000
/// first fragment of debug stream data
#define DSH_FIRST_FRAGMENT          0x4000
/// last fragment of debug stream data
#define DSH_LAST_FRAGMENT           0x8000
/// mask for fragment bits in debug stream status field
#define DSH_MASK_FRAGMENT           0xC000


//=========================================================================
// Stream IDs
//=========================================================================

/* Debug Streams: VDSL2 SOC Message Subtypes */

//******************************************************************************
// Common Streams for CPE & CO but mainly intended for ADSL!!! (0x0000 - 0x0031)

//******************************************************************************

/** A macro state change happened. For ADSL1, ADSL2/2+, VDSL */
#define DSH_FSM_STATE                0x0001
/** This stream holds all kind of short data that needs buffering,
    e.g. state and substate changes, G.HS messages...
    For ADSL1, ADSL2/2+, VDSL */
#define DSH_STATE_TRAIL              0x0002
/** AFE register dump. */
#define DSH_AFE_REGISTERS            0x0003

#define  DSH_C_MSG1                  0x000A
#define  DSH_C_MSG_PCB               0x000B
#define  DSH_C_MSG_FMT               0x000C
#define  DSH_C_PARAMS                0x000D
#define  DSH_C_MSG2                  0x000E
#define  DSH_C_RATES1                0x000F
#define  DSH_C_RATES_RA              0x0010
#define  DSH_C_MSG_RA                0x0011
#define  DSH_C_RATES2                0x0012

#define  DSH_R_MSG1_ADSL             0x0014
#define  DSH_R_MSG_PCB               0x0015
#define  DSH_R_MSG_FMT               0x0016
#define  DSH_R_PARAMS                0x0017
#define  DSH_R_MSG2_ADSL             0x0018
#define  DSH_R_RATES1                0x0019
#define  DSH_R_MSG_RA                0x001A
#define  DSH_R_RATES_RA              0x001B
#define  DSH_R_RATES2                0x001C



/** For VDSL */
/** log outgoing OHC TX messages, both commands and responses */
#define DSH_OCH_TX_MESSAGES          0x0030
/** log incoming OHC RX messages, both command sand responses */
#define DSH_OCH_RX_MESSAGES          0x0031


//*************************************************************************************
// CO non-standard Streams !!! DO NOT USE ANY OF THESE STREAM IDs !!! (0x0032 - 0x0050)
//*************************************************************************************

// DO NOT ADD STREAMS IN THIS STREAM ID RANGE



//*************************************************************************************
// CPE non-standard Streams  Feel free to add streams with these IDs  (0x0051 - 0x006E)
//*************************************************************************************

// Feel free to add streams in this stream id range
/** Channel Discover SNR */
#define DSH_CD_SNR                   0x0051
/** Transceiver Training SNR */
#define DSH_TRTR_SNR                 0x0052
/** Medley SNR */
#define DSH_MEDLEY_SNR               0x0053
/** Showtime SNR */
#define DSH_SHOWTIME_SNR             0x0054
/** Channel Discover Receive PSD */
#define DHS_CD_RX_PSD                0x0055
/** US PSD related: gt_TxPsdControl*/
#define DSH_TX_PSD_CONTROL           0x0056
/** US PSD related: pt_MaxPsdDescIn */
#define DSH_MAX_PSD_DESC_IN          0x0057
/** US PSD related: pt_ActPsdDescOut */
#define DSH_Max_PSD_DESC_OUT         0x0058
/** Strymon register dump */
#define STRYMON_CONF                 0x0059
/** DS Ceiling values  **/
#define DSH_PROPOSED_CEILING_DS      0x005A
/** Hybrid metric  **/
#define DSH_HYBRID_METRIC            0x005B
/** Quiet line Noise */
#define DSH_QLN                      0x005C
/** HLOG */
#define DSH_HLOG                     0x005D
/** ADC Noise */
#define DSH_QLN_PSD_DB               0x005E
/** ADC Noise */
#define DSH_ADC_NOISE_PSD            0x005F





/** Debug vars for OP_Vect1 detector e.g Trace gl_MaxEnergy, l_NoisPwrAcc and gs_AlignmentOffset **/
#define OP_VECT1_DETECT_DBG          0x0060
/** Debug vars for OP_Vect1 alignment */
#define OP_VECT1_ALIGNMENT_DBG       0x0061
/** @todo add description  **/
#define OP_VECT1_DETECT_DBG2         0x0062
/** @todo add description  **/
#define OP_VECT1_EXIT_DBG            0x0063
/** gpsa_IlvDbgBuffer dump */
#define DSH_ILV_DBG_BUFFER_PLL       0x0064
/** @todo add description  **/
#define OP_SYNCHROV1_TRACE           0x0065
/** DS Framer **/
#define DSH_DS_FRAMER                0x0066
/** DS Data rate in LP0 and LP1 computed from the Framer  **/
#define DSH_DS_DATA_RATE             0x0067
/** Complete pilot tone array and config **/
#define DSH_PILOT_TONE_ARRAY         0x0068
/** Skipped switching to new pilot tone **/
#define DSH_SKIP_PT_SWITCHING        0x0069
/** RxPathCompensation */
#define DSH_RX_PATH_COMP_DB          0x006A

/** Showtime DS BAT */
#define DSH_SHOWTIME_BAT             0x006E

//***************************************************************************************
// CPE & CO standard Streams - Feel free to add streams with these IDs  (0x006F - 0x009F)
//***************************************************************************************

// Only intended for streams which are standardized and can be used by CO & CPE e.g. SOC messages

/** O-ACK, for VDSL2 */
#define DSH_O_ACK                    0x0080
/** O-SIGNATURE, for VDSL2 */
#define DSH_O_SIGNATURE              0x0081
/** O-UPDATE, for VDSL2 */
#define DSH_O_UPDATE                 0x0082
/** O-MSG1, for VDSL2 */
#define DSH_O_MSG1                   0x0083
/** O-PRM, for VDSL2 */
#define DSH_O_PRM                    0x0084
/** O-TA-UPDATE, for VDSL2 */
#define DSH_O_TA_UPDATE              0x0085
/** O-TPS, for VDSL2 */
#define DSH_O_TPS                    0x0086
/** O-PMS, for VDSL2 */
#define DSH_O_PMS                    0x0087
/** O-PMD, for VDSL2 */
#define DSH_O_PMD                    0x0088
/** O-PRM-LD,For VDSL2 */
#define DSH_O_PRM_LD                 0x0089
/** O-MSG-LD,For VDSL2 */
#define DSH_O_MSG_LD                 0x008A
/** O-REPEAT_REQUEST, for VDSL2 */
#define DSH_O_REPEAT_REQUEST         0x008B
/** O-ACK_SEG, for VDSL2 */
#define DSH_O_ACK_SEG                0x008C
/** R-ACK, for VDSL2 */
#define DSH_R_ACK                    0x0090
/** R-MSG1, for VDSL2 */
#define DSH_R_MSG1                   0x0091
/** R-UPDATE, for VDSL2 */
#define DSH_R_UPDATE                 0x0092
/** R-MSG2, for VDSL2 */
#define DSH_R_MSG2                   0x0093
/** R-PRM, for VDSL2 */
#define DSH_R_PRM                    0x0094
/** R-TA-UPDATE, for VDSL2 */
#define DSH_R_TA_UPDATE              0x0095
/** R-TPS-ACK, for VDSL2 */
#define DSH_R_TPS_ACK                0x0096
/** R-PMS, for VDSL2 */
#define DSH_R_PMS                    0x0097
/** R-PMD, for VDSL2 */
#define DSH_R_PMD                    0x0098
/** R-PRM-LD,For VDSL2 */
#define DSH_R_PRM_LD                 0x0099
/** R-MSG-LD,For VDSL2 */
#define DSH_R_MSG_LD                 0x009a
/** R-ERROR-FEEDBACK,For VDSL2, Vectoring */
#define DSH_R_ERROR_FEEDBACK         0x009b
/** R-REPEAT_REQUEST, for VDSL2 */
#define DSH_R_REPEAT_REQUEST         0x009c
/** R-ACK-SEG, for VDSL2 */
#define DSH_R_ACK_SEG                0x009d

/** send content of  tMTK_AckVersionInfoGet. This stream is always on.*/
#define DSH_VERSION_INFO             0x009F
/** @} */ /* _DEBUG_STREAMTYPE_DEF_ */



//=========================================================================
// Event IDs
//=========================================================================

// Common event IDs, only add IDs which are applicable for CO and CPE (0/0x0000 - 63/0x003F)

#define DSH_EVT_SYM_CNT_ZERO                0x0000
#define DSH_EVT_STATE_CHANGE                0x0001
#define DSH_EVT_SUB_STATE_CHANGE            0x0002
#define DSH_EVT_LOS                         0x0003
#define DSH_EVT_NLOS                        0x0004
#define DSH_EVT_MIN_USMARGIN                0x0005
#define DSH_EVT_EXCEPTION                   0x0006
#define DSH_EVT_CONSECUTIVE_US_CRC8         0x0007
#define DSH_EVT_GHS_RX                      0x000A
#define DSH_EVT_GHS_TX                      0x000B
#define DSH_EVT_OLR_DS_STATS                0x000C
#define DSH_EVT_OLR_US_STATS                0x000D
#define DSH_EVT_OLR_CO_REJECTED_US_BS       0x000E
#define DSH_EVT_OLR_CO_REJECTED_DS_BS_BUSY  0x000F
#define DSH_EVT_OLR_STATISTICS              0x0010
#define DSH_EVT_DSM_TX_MSG                  0x0011
#define DSH_EVT_DSM_RX_MSG                  0x0012
#define DSH_EVT_OCH_BYTEPOOL                0x0013
#define DSH_EVT_APS_DATA                    0x0014
#define DSH_EVT_TX_PHASE_REVERSAL           0x0015
#define DSH_EVT_RX_PHASE_REVERSAL           0x0016
#define DSH_EVT_RX_IBIT_CHANGE              0x0017
#define DSH_EVT_TX_IBIT_CHANGE              0x0018
#define DSH_EVT_ERB_L2_DATA                 0x0019
#define DSH_EVT_BGTASK_INFO                 0x001A

//*************************************************************************************
// CO Only Events!!! DO NOT USE ANY OF THESE STREAM IDs !!! (64/0x0040 - 95/0x005F)
//*************************************************************************************

// DO NOT ADD EVENTS IN THIS ID RANGE


//*************************************************************************************
// CPE Only Events!!! DO NOT USE ANY OF THESE STREAM IDs !!! (96/0x0060 - 63/0x007E)
//*************************************************************************************

// Feel free to add streams in this stream id range

/** PGA reconfiguration values  **/
#define DSH_EVT_PGA_RECONFIGURE            0x0060  // This debug stream is not used in VRX518, but the ID is blocked, since decoding script for VR9/VRx318 exist
/** @todo add description  **/
#define DSH_EVT_PLL_STATE                  0x0061
/** Debug info for bitswap algo fail **/
#define DSH_EVT_BITSWAP_ALGO_FAIL          0x0062
/** @todo add description  **/
#define DSH_EVT_ABANDON_OLR                0x0063
/** OP_VECT1_DEBUG Trace REVERB and SEGUE decision for O_P_SYNCHRO_V1 detection **/
#define DSH_EVT_OP_VECT1_ALIGNMENT_DBG     0x0064
/** @todo add description  **/
#define DSH_EVT_NOSYNCSYM_ENGY_CNT         0x0065
/** PGA reconfiguration values for VRX518 **/
#define DSH_EVT_PGA_RECONFIGURE_VRX518     0x0066
/** @todo add description  **/
#define DSH_EVT_START_COUNTER              0x0067
/** @todo add description  **/
#define DSH_G997_FAIL_OCCURED              0x0068
/** Hybrid setting to be tested during Hybrid training  **/
#define DSH_EVT_HYBRID_SETTING             0x0069
/** Hybrid metric  **/
#define DSH_EVT_HYBRID_METRIC              0x006A

/** @todo add description  **/
#define DSH_EVT_CPE_SYM_ZERO_DEBUG         0x0070
/** @todo add description  **/
#define DSH_EVT_QTRX_NOT_DONE              0x0071
/** @todo add description  **/
#define DSH_EVT_RXQTP_NOT_DONE             0x0072
/** All 3 pilot tones  **/
#define DSH_EVT_PILOT_TONES                0x0073
/** Max cycles for phase error calculation **/
#define DSH_EVT_PLL_Cycles                 0x0074


#endif // DEBUG_STREAMING

/****************************************************************************************************************************/

#endif /* _CONST_H */
