/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef DLI_H
#define DLI_H
#ifdef DLI_EXPORTS
#define DLI_API __declspec(dllexport)
#else
#define DLI_API __declspec(dllimport)
#endif

/**
    \mainpage

    The DLI is an asynchronous interface. However, it should be
    understood that the ratio of the upstream and
    downstream data rate must be of integer value at all
    time. To simplify implementation it is not valid to
    switch the ratio during runtime. The central office (CO)
    side is configured as master, the consumer permise equipment (CPE)
    side as slave. The master  will write an arbitrary amount
    of samples to the DLI and will block until it receives the
    corresponding number of samples from the DLI. The slave will
    wait for samples to read from the DLI and will write the
    corresponding amount of samples to the DLI. Even though
    it is desired to process an arbitrary amount of data
    per access on each side, the size should be limited to
    following restrictions for the sake of easy implementation:

    - the maximum amount will be a symbol's size

    - the minimum amount has to grant at least a single
      sample to be processed within the other direction.

    - the number of upstream and downstream samples must be
      a multiple of the sample ratio

    For example having a GDMT, double upstream, link the
    maximum size will be 512 samples downstream and 128
    samples upstream. The minimum size will be 4 samples
    upstream and 1 sample downstream. 7 samples downstream
    are not valid and will lead to undefined behavior.

    Use initDLI() to register your application once to the
    interface. There can't be a second connect to one side
    until the interface is propperly released by releaseDLI().

    A call to processDLI() will transmit a given number of
    samples and receive samples according to the sample
    rate ration. This call can block for inifinite time,
    depending on the state of the opponent.

*/
///maximum size for downstream symbols
#define MAX_DOWNSTREAM_BUF_SIZE     2048
///maximum size for upstream symbols
#define MAX_UPSTREAM_BUF_SIZE       128

///interface type
enum if_type_e {co,cpe};

///connect to interface
/**
    This can be called only once for CO and CPE, until releaseDLI() is called.
    There can be several peer-to-peer connections with different unique names.

    @param type the interface type, either co or cpe
    @param sizeDD symbol size downstream in number of samples
    @param sizeDU symbol size upstream in number of samples
    @param unique_name a string to make this interface a singelton in memory

    @return 0 on success, -1 on error
*/
DLI_API int initDLI(enum if_type_e type, int sizeDD, int sizeDU, const char * unique_name);
///transmit and receive data
/**
    You have to take care of buffer overflows yourself!

    @param pusTxData pointer to data to transmit
    @param size number of samples to transmit
    @param pusRxData pointer to the receive buffer

    @return 0 on success, -1 on error. Having no opponent will return -1, too.
*/
DLI_API int processDLI(const unsigned short * pusTxData, int size, unsigned short * pusRxData);
///release the interface
/**
    This function has to be called if you want to reconnect to the interface.
*/
DLI_API void releaseDLI();

///for use when loading the library explicitly at run time
typedef int (*initDLI_t)(enum if_type_e,int,int,const char * );
///for use when loading the library explicitly at run time
typedef int (*processDLI_t)(const unsigned short * , int, unsigned short *);
///for use when loading the library explicitly at run time
typedef void (*releaseDLI_t)();
#endif //DLI_H

