/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DSP_OP_H
#define _DSP_OP_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  dsp_op.h
;
;  Header file for functions in dsp_op.c
;
*****************************************************************************/

#include "typedef.h"

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#ifndef DSP_OP2_H
#define MAX_16 0x7fff
#endif
#define MIN_16 0x8000
#define MAX_32  0x7fffffff
#define MIN_32  0x80000000

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
extern int16 sature16(int32 L_var1);
extern int32 round(int32 L_var, int16 s_bit_position);
extern int32 l_add(int32 L_var1, int32 L_var2);
extern int16 norm_l(int32 L_var1);
extern int16 div_s(int16 s_var1, int16 s_var2);
extern int16 div_l( int32  L_num, int16 s_den );

#endif /* _DSP_OP_H */
