/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DSP_OP2_H
#define _DSP_OP2_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  dsp_op2.h
;
;  Header file for functions in dsp_op2.c
;
*****************************************************************************/

#include "typedef.h"

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#ifndef DSP_OP_H
#define MAX_16 0x7fff
#endif

/**********************************************************************
 * VARIABLES
 **********************************************************************/
extern FlagT gs_Overflow;        /*  indicates that overflow has occurred */

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
extern int16 abs_s(int16 var1);
extern void RightNormalizeSignedPair(int32 *pl_x, int32 *pl_y, int16 s_NBits, int16 *ps_RightShift);
extern int16 Divide_16bit(int16 s_num_mant, int16 s_num_exp, int16 s_den_mant, int16 s_den_exp, int16 *ps_quot_mant, int16 *ps_quot_exp);
int16 Divide_32by16bit(int32 s_numer_mantissa, int16 s_numer_exponent,
                                   int16 s_denom_mantissa, int16 s_denom_exponent,
                                   int16 *ps_quot_mantissa, int16 *ps_quot_exponent
                                   );
//XDSLRTFW-1727
int16 Divide_32by16U(int32 l_numer_mantissa, int16 s_numer_exponent,
                                   uint16 us_denom_mantissa, int16 s_denom_exponent,
                                   int16 *ps_quot_mantissa, int16 *ps_quot_exponent
                                   );
extern int16 norm_16bit(int16 s_var1);

uint8 Bit_Rev(uint8 uc_Index, int16 s_Nbits);
int16 sqrt32(int32 l_in);

#ifdef HERCULES_ADSL_CPE
int16 floor16(int16 s_num, int16 s_den);
int16 ceil16(int16 s_num, int16 s_den);
int16 mod16(int16 s_num, int16 s_den);
#endif // HERCULES_ADSL_CPE

#endif /* _DSP_OP2_H */
