/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _EC_DATA_H
#define _EC_DATA_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             ec_data.h
 * DESCRIPTION:      Header file for echo canceller data.
 *
 **********************************************************************/
// ******************************************************************
// ec_data.h
//
// History
//
// 24/06/2011 Kannan: Added debug feature to measure the residual Echo on BT loops.
//                    It is disabled by default. It can be enabled using
//                    "VR9_DEC_TRAIN_DBG" defined ec_data.h
//                    Grep for XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA
//
// ******************************************************************
#include "typedef.h"
#include "const.h"
#include "platform.h"
/**********************************************************************
 * VARIABLES
 **********************************************************************/
extern int16 gs_DEC_ORDER;
extern int16 gsa_pre_dec_h[DEC_ORDER_MAX];         /* DEC coefficient mantissas (1.15) */
extern int16 gs_pre_dec_h_exp;               /* DEC coefficient exponent */
extern int16 gs_pre_dec_h_delay;
extern int16 gs_DECUpsamplingFactor;
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
#ifndef VR9_DEC_TRAIN_DBG
//#define VR9_DEC_TRAIN_DBG //define "VR9_DEC_TRAIN_DBG" while debugging VR9 DEC TRAINING code
#endif
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)
/* DEC tap tapering: LOG2_TAPER_WIN_SCALE = number of quantization levels
                  for the length TAIL_TAPER_LEN raised cosine tapering. */
#define LOG2_TAPER_WIN_SCALE  (9)
#define TAIL_TAPER_LEN  (40)
#ifndef ADSL_62
#define EC_TRAIN_SEQ_BUF_SIZE   (64*2+TAIL_TAPER_LEN+8*128 + RX_NUM_TONES)
#else
#define EC_TRAIN_SEQ_BUF_SIZE   (64*2+TAIL_TAPER_LEN+ 2*512 + 2*1024 + RX_NUM_TONES)
#endif

#endif /* _EC_DATA_H */

