/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _EOC_H
#define _EOC_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: eoc.h
;
;  Header file for constants and data types in test_eoc.c
;
*****************************************************************************/

#include "typedef.h"

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#define  EOC_MESSAGE          (0x1)    /*  indicates eoc byte contains eoc message */

/* EOC message fields */
#define EOC_ATU_R          (0x0)    /*  ATU_R in address field */
#define EOC_ATU_C          (0x3)    /*  ATU_C in address field */
#define EOC_DATA           (0x0)    /*  data byte */
#define EOC_OPCODE            (0x1)    /*  opcode byte */
#define EOC_ODD_PARITY        (0x1)    /*  odd parity */
#define  EOC_EVEN_PARITY         (0x0)    /*  even parity */

/* EOC opcodes */
#define OPCODE_NO_SYNC_ACTION (0x0C)      /*  opcode for no synchronization action */
#define  OPCODE_HOLD          (0x01)      /*  opcode for HOLD */
#define  OPCODE_RTN           (0xF0)      /*  opcode for Return to Normal */
#define  OPCODE_SLFTST        (0x02)      /*  opcode for Self Test */
#define  OPCODE_REQCOR        (0x07)      /*  opcode for request corrupt crc bits from ATU-R */
#define  OPCODE_REQEND        (0x08)      /*  opcode for request ATU-R to stop sending corrupt crc bits */
#define  OPCODE_NOTCOR        (0x0B)      /*  opcode for send corrupt crc bits by ATU-C */
#define  OPCODE_NOTEND        (0x0D)      /*  opcode for ATU-C stopped sending corrupt crc bits */
#define  OPCODE_EOD           (0x0E)      /*  opcode for End of Data */
#define  OPCODE_REQTPU        (0x13)      /*  opcode for request ATU-R to update test parameter set of ATM  */

#define  OPCODE_UTC           (0x04)      /*  opcode for Unable To Comply */
#define  OPCODE_DGASP         (0xE7)      /*  opcode for Dying Gasp Message */
#define  OPCODE_NEXT          (0x10)      /*  opcode for "NEXT" message */

#define  OPCODE_WRITE1        (0x20)      /*  opcode for Write */
#define  OPCODE_WRITE2        (0x23)      /*  opcode for Write */
#define  OPCODE_WRITE3        (0x25)      /*  opcode for Write */
#define  OPCODE_WRITE4        (0x26)      /*  opcode for Write */
#define  OPCODE_WRITE5        (0x29)      /*  opcode for Write */
#define  OPCODE_WRITE6        (0x2A)      /*  opcode for Write */
#define  OPCODE_WRITE7        (0x2C)      /*  opcode for Write */
#define  OPCODE_WRITE8        (0x2F)      /*  opcode for Write */
#define  OPCODE_WRITE9        (0x31)      /*  opcode for Write */
#define  OPCODE_WRITE10       (0x32)      /*  opcode for Write */
#define  OPCODE_WRITE11       (0x34)      /*  opcode for Write */
#define  OPCODE_WRITE12       (0x37)      /*  opcode for Write */
#define  OPCODE_WRITE13       (0x38)      /*  opcode for Write */
#define  OPCODE_WRITE14       (0x3B)      /*  opcode for Write */
#define  OPCODE_WRITE15       (0x3D)      /*  opcode for Write */
#define  OPCODE_WRITE16       (0x3E)      /*  opcode for Write */

#define  OPCODE_READ1         (0x40)      /*  opcode for Read */
#define  OPCODE_READ2         (0x43)      /*  opcode for Read */
#define  OPCODE_READ3         (0x45)      /*  opcode for Read */
#define  OPCODE_READ4         (0x46)      /*  opcode for Read */
#define  OPCODE_READ5         (0x49)      /*  opcode for Read */
#define  OPCODE_READ6         (0x4A)      /*  opcode for Read */
#define  OPCODE_READ7         (0x4C)      /*  opcode for Read */
#define  OPCODE_READ8         (0x4F)      /*  opcode for Read */
#define  OPCODE_READ9         (0x51)      /*  opcode for Read */
#define  OPCODE_READ10        (0x52)      /*  opcode for Read */
#define  OPCODE_READ11        (0x54)      /*  opcode for Read */
#define  OPCODE_READ12        (0x57)      /*  opcode for Read */
#define  OPCODE_READ13        (0x58)      /*  opcode for Read */
#define  OPCODE_READ14        (0x5B)      /*  opcode for Read */
#define  OPCODE_READ15        (0x5D)      /*  opcode for Read */
#define  OPCODE_READ16        (0x5E)      /*  opcode for Read */

/**********************************************************************
 * G992_2 opcodes
 **********************************************************************/
#define  OPCODE_GNTPDN        (0x16)      /*  opcode for grant power down in response to REQPDN */
#define  OPCODE_REJPDN        (0x83)      /*  opcode for reject power down in response to REQPDN */
#define  OPCODE_REQPDN        (0x15)      /*  opcode for request power down by ATU-R */


#define EOC_NO_SYNC_MSG         (0x0C0C)
#define EOC_HOLD_MSG            (0x01F3)
#define EOC_RTN_MSG             (0xF173)
#define EOC_UTC_MSG             (0x0573)
#define EOC_NEXT_ODD_MSG        (0x1173)
#define EOC_NEXT_EVEN_MSG       (0x1153)
#define DGASP_EOC_FRAMES                (12) /*  # of frames during which atleast 4 Dgasp msgs. should be received by ATU-C */

/*  EOC Data Registers Length in bytes */
#define EOC_VENDOR_ID_LEN               (8)
#define EOC_T1413_VENDOR_ID_LEN        (2)
#define EOC_REVISION_NUM_LEN            (16)    /*  vendor discretionary */
#define EOC_SERIAL_NUM_LEN              (32)
#define  EOC_LINE_ATTENUATION_LEN        (1)
#define EOC_SNR_MARGIN_LEN              (1)
#define EOC_ATU_R_CONFIGURATION_LEN     (30)

#define  EOC_VENDOR_DISCR_LEN            (1)    /*  length of vendor discr. ATU-R data registers */
#define EOC_AUTONOMOUS_MSG_LEN          (1)

#define  CLEAR_EOC                       (3)
#define  REQPDN                          (4)
#define MASKBIT6                       (0x0040)

#define EOC_NO_SYNC_BYTE1               (0x0C)
#define EOC_NO_SYNC_BYTE2               (0x0C)

/* ============================================================================================= */
/*  Power management constants */
/* ============================================================================================= */

#define GRANTED     1
#define REJECTED    2

/*  EOC Data Registers Length in bytes */
#define  EOC_LINK_STATE_LEN              (1)


/*  Power Management states */
#define LINK_STATE_L0                   (0x00)  /*  state L0, full power mode */
#define LINK_STATE_L1                   (0x01)  /*  state L1, optional, not implemented currently */
#define LINK_STATE_L3                   (0x03)  /*  state L3, Idle, low power mode */

#define TX_EOC_MSG_BUF_LEN              10

#define  TXEOCBUFFER_SIZE  10
#define  RXEOCBUFFER_SIZE  10

typedef struct {
    uint8   us_vendor_id[EOC_VENDOR_ID_LEN];                    /*  ATU-R vendor id */
    uint8   us_revision_num[EOC_REVISION_NUM_LEN];              /*  ATU-R Revision number    */
    uint8   us_serial_num[EOC_SERIAL_NUM_LEN];                  /*  ATU-R Serial number   */
    uint8   uc_line_attenuation[EOC_LINE_ATTENUATION_LEN];      /*  ATU-R Line Attenuation   */
    int8 c_snr_margin[EOC_SNR_MARGIN_LEN];                   /*  ATU-R snr margin   */
    uint8   uc_atu_r_configuration[EOC_ATU_R_CONFIGURATION_LEN];/*  ATU-R Configuration   */
    uint8   uc_link_state[EOC_LINK_STATE_LEN];                  /*  ATU-R Link state   */
    uint8   uc_vendor_discr[EOC_VENDOR_DISCR_LEN];              /*  vendor discretionary information */
    uint8   uc_clear_eoc_payload;                               /*  clear eoc payload byte   */
} RxEocReadStruct_t;


/**********************************************************************
 * TYPEDEFS
 **********************************************************************/
/* Structure containing TX EOC handler variables */
typedef struct {
    uint16  us_tx_eoc_msg[TX_EOC_MSG_BUF_LEN]; /* current echoed tx eoc message */
    int16   s_tx_eoc_msg_put_ptr;
    int16   s_tx_eoc_msg_get_ptr;
    uint8   uca_TxEocOutBuf[2];         /*  contains the eoc byte to be x'mited */
    uint8   uc_tx_info_buf_index;       /*  index to the buffer containing data to be written into ATU-R data register  */
    uint8   *puc_tx_eoc_buf;            /*  pointer to the members of ReadEocBuf */
} TxEocHandlerStruct_t;

typedef struct {
    uint8   uc_EocAction;               /*  type of autonomous msg to be transmitted */
    int8 c_tx_eoc_info_buf;          /*  Buffer containing data for clear EOC transmission */
} TxEocNetworkStruct_t;

typedef struct {
    FlagT ft_send_dgasp_flag;   /*  indicates if there is a loss of power */
    uint8 uc_dgasp_msg_count;   /*  counter for transmitted Dgasp msgs. */
} TxEocDgaspStruct_t;

/* Structure containing RX EOC handler variables */
typedef struct {
    uint16  us_rx_eoc_msg_count;/*  received eoc message count */
    uint16  us_RxEocState;      /*  current state of Rx Eoc state machine */
    uint16  us_rx_eoc_msg;      /*  current received eoc message */
    uint16  us_pre_eoc_msg;     /*  previous received eoc message */
    uint8   uc_rx_info_buf_index; /*  index to the buffer containing data to be read from ATU-R data register  */
    uint16  us_msg_len;         /*  length of the ATU-R data registers */
    uint8   *puc_rx_eoc_buf;    /*  pointer to the members of ReadEocBuf */

} RxEocHandlerStruct_t;

typedef struct {
    uint8   uc_Address;             /*  address field */
    uint8   uc_DataOrOpcode;        /*  Data/Opcode field */
    uint8   uc_Parity;              /*  Byte Parity field */
    uint8   uc_AutonomousMsg;       /*  Autonomous message field */
    uint8   uc_Information;         /*  information field */
} RxEocDecodStruct_t;

/*  Power management variables */
extern FlagT gft_response_to_powerdown;                 /*  = GRANTED, if GNTPDN is received in response to REQPDN */
                                                        /*  = REJECTED, if REJPDN is received in response to REQPDN */
// size in words
#define RX_CLEAR_EOC_DATA_SIZE   256

// this struct is used by Rx Clear EOC code
typedef struct {
   int16 *gpus_RxClearEocBuf;
   int16 gs_RxClearEocBuf_Length;
   int16 gs_RxClearEocBuf_ReadIndex;
   int16 gs_RxClearEocBuf_WriteIndex;
   int16 gs_RxClearEocBuf_OverflowCnt;
   int16 s_RxClearEocBuf_Disable; //Bit 0: If set to 1 by the ME, disables Rx Clear EOC bytes
                           //from being written into the Rx Clear EOC Fifo.
                           //This bit is automatically cleared by the ATU-R after a Tx
                           //ME-HDLC message is copied from the ME-HDLC buffer in
                           //preparation for transmission.

} RxClearEocBuf_t;

#endif /* _EOC_H */

