/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _EXCHDATA_H
#define _EXCHDATA_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             exchdata.h
 * DESCRIPTION:      Header file containing variables .
 *
 **********************************************************************/

#include "typedef.h"
#include "const.h"
#include "rt_state.h"
#include "config.h"

/**********************************************************************
 * VARIABLES
 **********************************************************************/
extern int16 *gpsa_RxExchMsg;
extern int16 gs_RxExchMsgLength;

/* =============================================================================== */
/*  Data used for R_RATES_RA and R_MSG_RA messages to be sent to ATU-C */
/* =============================================================================== */
extern uint8 guca_RMsgRATab[R_MSG_RA_NUM_BYTES];
extern uint8 guc_RRatesRA;
extern RMsgRA_t gt_RMsgRA;

/* =============================================================================== */
/*  Data used for R_EXCH messages to be sent to ATU-C */
/* =============================================================================== */
extern uint8  guca_RMsg2[R_MSG2_NUM_BYTES];        /* R_MSG2 message to be sent to ATU-C */
extern uint8  guc_RRates2;                   /* R_RATES2 message to be sent to ATU-C */
extern int16  *gpsa_DS_BitAndGain;              /* downstream R_C_B&G message. */
                                       /* length RX_NUM_TONES for all Annex A's */
                                       /* length 2*RX_NUM_TONES for Annex C */
extern int16  gs_DS_RateOption;                 /* final downstream rate option */
extern int16  gs_US_RateOption;                 /* final upstream rate option */

extern uint16 gusa_DS_OptionOrder[NUM_DS_RATE_OPTIONS];  /* Order (decreasing payload) to process DS Options*/

/* =============================================================================== */
/*  Data used for C_MSG_RA and C_RATES_RA received from ATU-C */
/* =============================================================================== */
extern int16 gsa_RCRatesRA[R_C_RATES_RA_RX_LEN];   /* Packed C_RATES_RA data */
extern int16 gsa_RCMsgRA[R_C_MSG_RA_RX_LEN];    /* Packed C_MSG_RA data */
extern RCMsgRA_t gt_RCMsgRA;                 /* Unpacked C_MSG_RA information */

/* =============================================================================== */
/*  Data used for R_EXCH2 received from ATU-C */
/* =============================================================================== */
extern int16 gsa_RCMsg2[R_C_MSG2_RX_LEN];       /* C_MSG2 received from ATU-C */
extern int16 gs_RCRates2;                    /* C_RATES2 received from ATU-C */
extern CMsg2_t gt_RCMsg2;                    /* decoded C_MSG2 messages */
extern RMsg2_t gt_RMsg2;                     /* R_MSG2 parameters */

/* =============================================================================== */
/*  Data used for R_EXCH2 received from ATU-R */
/* =============================================================================== */
extern int16 gsa_US_BitAndGain[(R_C_BG_RX_LEN>>1)];      /* Upstream R_B&G message */
extern int16 gsa_US_BitAndGain2[(R_C_BG_RX_LEN>>1)];     /* Upstream R_B&G backup message */

extern int16 *gsa_RxExchMsg1;


#endif /* _EXCHDATA_H */

